/* [wam/init.c wk 22.01.93] Application startup
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * Hier sind Funktionen implementiert, die das
 * Initialisieren von Anwendungen vornehmen.
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: init.c,v 1.9 1996/05/05 10:13:49 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <wk/wam.h>
#include "wammain.h"


const char *wamApplicationName = "generic";


/**************************************************
 *************	Global Functions  *****************
 **************************************************/

#ifdef DOCUMENTATION
@Summary WamInitialize
 #include <wk/wam.h>

 void WamInitialize(void);

@Description
 Fuehrt alle notwemdigen Initialsierunegn durch. Nach dieser
 Funktion kann die eigentliche Anwendung via WamEnterProcess
 gestartet werden.
@See Also
 WamEnterProcess
#endif /*DOCUMENTATION*/


void WamInitialize(void)
{

    WamInitializeSymbols();
    /* Die folgende Funktion wird von symcllct.exe aufgebaut */
    /* Wenn dieses Modul in einer DLL ist, wird es nicht exportiert */
    /* so dass es alle in der DLL enthaltenen Symbole initialisiert. */
    /* Falls die eine Library ist, so sammelt symcllct.exe auch die */
    /* symbole in der library, da sie ja in jedem Headerfile deklariert */
    /* sind und deswegen in jedem Objekt Modul vorkommen. */
    /* Dass bei Verwendung von DLLs ein doppelter satz von Variabeln */
    /* fuer die Symbole vorhanden ist (in DLL und EXE) wird in Kauf */
    /* genommen, da die RelokationTabelle in der DLL dann kleiner ist */
    SymbolInitialization();
    WamInitializeMessager();
}


void WamSUCStdClasses(void)
{
    WamSUC_Object(); /* setup the root class */
    WamSUC_Symbol(); /* this one is very special */

    WamSUC_GUI();
    WamSUC_String();
    WamSUC_Message();
    WamSUC_Integer();
    WamSUC_Float();
    WamSUC_Date();
    WamSUC_Time();
    WamSUC_Timestamp();

    WamSUC_IdArray();
    WamSUC_StringArray();
    WamSUC_WordArray();

    WamSUC_SymbolSet();

    WamSUC_Dictionary();
    WamSUC_SymbolDictionary();

    WamSUC_Form();
    WamSUC_FormItem();
    WamSUC_FormItemText();
    WamSUC_FormItemNumber();
    WamSUC_FormItemInteger();
    WamSUC_FormItemDate();
    WamSUC_FormItemKey();
    WamSUC_FormItemMenu();
    WamSUC_FormItemToggle();
    WamSUC_FormItemCheckMenu();
    WamSUC_FormItemRadio();
    WamSUC_FormItemNumericSpin();
    WamSUC_FormItemValueSet();
    WamSUC_FormItemList();

    WamSUC_AutomaticForm();
    WamSUC_View();

    WamSUC_Database();
    WamSUC_Table();
    WamSUC_TableRow();
}



/**** end of file ****/
