/* [wam/IdArray.c wk 25.02.93] Class IdArray
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 ******************************************************
 * History:
 * 07.10.93 wk #size now returns the actual number of elements
 *	       (fixed bug caused by use of #remove).
 *	       #cdr should now work as expected.
 *	       added #car.
 */

#include <wk/tailor.h>
RCSID("$Id: idarray.c,v 1.6 1996/01/10 19:01:53 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>

/**************************************************
 *************	Constants  ************************
 **************************************************/
#define FIRSTCHUNK   10  /* beim ersten mal nich soviel allokieren */
#define CHUNK	     50  /* wahrscheinlich brauchen wir dann doch mehr*/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(IdArray)
id Array = (id)&factoryPrivateData; /* synonym for IdArray */

BEGIN_DCLPRIVATEPART
    id	 *contents;
    unsigned capacity; /* allocated size of contents */
    unsigned size;     /* current size of contents */
    unsigned enSize;   /* used for enumeration */
    unsigned enIdx;    /* used for enumeration */
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLOBJFNC( free )
{
    DCL_var();

    free( var->contents );
    return msgSuper( sym_free );
}




/****************
 * Free the Array and send an free to every element
 */

DCLOBJFNC( deepFree )
{
    unsigned n;
    id *rover;
    DCL_var();

    if( var->contents )
	for(n=0,rover=var->contents; n < var->size; n++, rover++ )
	    freeObj(*rover);
    free( var->contents );
    return msgSuper( sym_free );
}


/****************
 * Add an element at the end
 */

DCLOBJFNC( add )
{
    DCL_arg(id, element );
    DCL_var();

    if( !var->contents )
	var->contents = xcalloc(var->capacity=FIRSTCHUNK,sizeof *var->contents);
    else if( var->size == var->capacity ) {
	var->capacity += CHUNK;
	var->contents = xrealloc(var->contents,
				 var->capacity * sizeof *var->contents);
    }
    var->contents[var->size] = element;
    var->size++;
    return self;
}


/****************
 * Add an element at the end if not there
 */

DCLOBJFNC( addSingle )
{
    DCL_arg(id, element );
    unsigned n;
    id *rover;
    DCL_var();

    if( var->contents )
	for(n=0,rover=var->contents; n < var->size; n++, rover++ )
	    if( *rover == element )
		return self; /* already in array */
    return msg1( self, sym_add, element );
}


/****************
 * removes an element (all occurences)
 */

DCLOBJFNC( remove )
{
    DCL_arg(id, element );
    unsigned n;
    id *rover;
    DCL_var();

    if( var->contents )
	for(n=0,rover=var->contents; n < var->size; n++, rover++ )
	    if( *rover == element )
		*rover = nil;
    return self;
}

/****************
 * removes an element (but only the first occurence)
 */

DCLOBJFNC( removeSingle )
{
    DCL_arg(id, element );
    unsigned n;
    id *rover;
    DCL_var();

    if( var->contents )
	for(n=0,rover=var->contents; n < var->size; n++, rover++ )
	    if( *rover == element ) {
		*rover = nil;
		break;
	    }
    return self;
}


DCLOBJFNC( clear )
{
    DCL_var();
    if( var->contents )
	var->size = 0;
    return self;
}


/****************
 * Die wahre gre, d.h. die anzahl der Elemente im Array zurckgeben.
 */
DCLOBJFNC_I( size )
{
    unsigned n, cnt=0;
    id *rover;
    DCL_var();

    if( var->contents )
	for(n=0,rover=var->contents; n < var->size; n++, rover++ )
	    if( *rover )
		cnt++;
    return cnt;
}


/****************
 * Seq. Zugriff: aber einmal gleichzeitig
 * (fuer Anderes ist die Sequence Methode zu benutzen)
 * Returns: self or nil; bei nil braucht close nicht mehr
 * benutzt zu werden, da es ein leeres Array anzeigt.
 */

DCLOBJFNC( enumOpen )
{
    DCL_var();

    if( var->enSize ) {
	msg1(self,sym_error,"nested enumOpen");
	return nil;
    }

    if( !var->capacity || !var->size )
	return nil;
    var->enSize = var->size;
    var->enIdx	 = 0;
    return self;
}


DCLOBJFNC( enumGet )
{
    DCL_var();

    if( !var->enSize ) {
	msg1(self,sym_error,"enumGet without enumBegin");
	return nil;
    }
    for( ; var->enIdx < var->enSize; var->enIdx++ )
	if( var->contents[var->enIdx] )
	    return var->contents[var->enIdx++];
    var->enSize = 0;
    return nil;
}


DCLOBJFNC( enumClose )
{
    DCL_var();
    var->enSize = 0;
    return nil;
}


/****************
 * Da Elemet an dem gegtebenen Index zurckgeben. Exitiert
 * an dem index kein Element mehr, so wird nil zurckgeben.
 * Zugriff hinter den Grenzen des Array liefert ebenfalls nil und
 * lst kein #bounds aus.
 * Wie der Name #atIndex bereits andeuted, wird _keine_ Kopie
 * zurckgegeben.
 */
DCLOBJFNC( atIndex )
{
    DCL_arg(unsigned, idx );
    DCL_var();

    if( var->contents && idx < var->size )
	return var->contents[idx];
    return nil;
}


/****************
 * Erzeugt eine StringArray mit den Objekten in self
 * bereit um in eine Datenbank eingesetzt zu werden
 */

DCLOBJFNC( asDBStringArray )
{
    id arr;
    unsigned n;
    id *rover;
    DCL_var();

    arr = newObj(StringArray);
    if( var->contents )
	for(n=0,rover=var->contents; n < var->size; n++, rover++ )
	    msg1(arr, sym_addAsDBString, *rover );
    return arr;
}



DCLOBJFNC( car )
{
    unsigned n;
    int i;
    id *rover;
    DCL_var();

    if( var->contents )
	for(n=0,i=0,rover=var->contents; n < var->size; n++, rover++ )
	    if( *rover )
		return *rover;

    return nil;
}


DCLOBJFNC( cdr )
{
    unsigned n;
    int i;
    id *rover, arr;
    DCL_var();

    arr = nil;
    if( var->contents )
	for(n=0,i=0,rover=var->contents; n < var->size; n++, rover++ )
	    if( *rover )
		if( i ) {
		    if( !arr )
			arr = newObj(factory);
		    msg1(arr, sym_add, *rover );
		}
		else
		    i++;
    return arr;
}



/****************
 * Returns: a Copy of self (shallowCopy)
 */

DCLOBJFNC( copy )
{
    id arr, *rover;
    unsigned n;
    DCL_var();

    arr = newObj(factory);
    if( var->contents )
	for(n=0,rover=var->contents; n < var->size; n++, rover++ )
	    msg1(arr, sym_add, *rover );
    return arr;
}



void WamSUC_IdArray()
{
    id self = IdArray;
    CREATECLASS("IdArray");
    WamSubclassClass( sym_Object, self );
    WamSetAtticLimit(self, 100 );

    DCLMTHD( free );
    DCLMTHD( deepFree );
    DCLMTHD( add );
    DCLMTHD( addSingle );
    DCLMTHD( remove );
    DCLMTHD( removeSingle );
    DCLMTHD( clear );
    DCLMTHD( size );
    DCLMTHD( enumOpen );
    DCLMTHD( enumGet  );
    DCLMTHD( enumClose);
    DCLMTHD( atIndex );
    DCLMTHD( asDBStringArray );
    DCLMTHD( car );
    DCLMTHD( cdr );
    DCLMTHD( copy );

}


/**** end of file ****/
