/* [gupta.h wk 07.09.93]
 * COPYRIGHT (C) GUPTA TECHNOLOGIES, INC. 1984-1992
 * This is the new name for: Id: sql.h,v 1.2 1993/09/07 17:21:02 wk Exp
 * $Id: gupta.h,v 1.1 1996/01/10 19:01:50 wernerk Exp $

INTERFACE TO
  SQL
REVISION HISTORY
  12/04/91 GTI release 5.0.0
  12/08/91 GTI release 5.0.1
  04/01/92 GTI release 5.0.2
  08/28/92 GTI release 5.1.0
  08.02.93 wk  Support for OS/2 2.0 (CSet/2) controlled by macro OS20
  08.12.95 wk  renamed to gupta.h
DESCRIPTION
  This file contains structure	definitions  and  defined  constants  used  to
  interface with SQLBASE.  For a more  complete  definition  see  "SQLBASE:  C
  Programmer's Guide".
*/

#ifndef SQL
#define SQL

/* VERSION NUMBER */
#define   SQLVERS   50100		/* version number		    */
#define   SQLAPIV   00102		/* API version number since 3.6     */
/* DEFINED CONSTANTS */

/* FAR POINTER */
#if OS20
  #define PTR * _Seg16
#else
  #ifdef SYSFN386
  #undef	  far
  /*#define   far	    near*/
  #define far
  /*#define   PTR     near **/
  #define PTR *
  #else
  #define   PTR 	    far *
  #endif
#endif
/* FETCH RETURN CODES */
#define   FETRTRU   1			/* data truncated		    */
#define   FETRSIN   2			/* signed number fetched	    */
#define   FETRDNN   3			/* data is not numeric		    */
#define   FETRNOF   4			/* numeric overflow		    */
#define   FETRDTN   5			/* data type not supported	    */
#define   FETRDND   6			/* data is not in date format	    */
#define   FETRNUL   7			/* data is null 		    */
/* DATABASE DATA TYPES */
#define   SQLDCHR   1			/* character data type		    */
#define   SQLDNUM   2			/* numeric data type		    */
#define   SQLDDAT   3			/* date-time data type		    */
#define   SQLDLON   4			/* long data type		    */
#define   SQLDDTE   5			/* date (only) data type	    */
#define   SQLDTIM   6			/* time (only) data type	    */
#define   SQLDDTM   6			/* maximum data type		    */
/* PROGRAM DATA TYPES */
#define   SQLPBUF   1			/* buffer			    */
#define   SQLPSTR   2			/* string (zero terminated)	    */
#define   SQLPUCH   3			/* unsigned char		    */
#define   SQLPSCH   4			/* char 			    */
#define   SQLPUIN   5			/* unsigned int 		    */
#define   SQLPSIN   6			/* int				    */
#define   SQLPULO   7			/* unsigned long		    */
#define   SQLPSLO   8			/* long 			    */
#define   SQLPFLT   9			/* float			    */
#define   SQLPDOU   10			/* double			    */
#define   SQLPNUM   11			/* SQLBASE internal numeric format  */
#define   SQLPDAT   12			/* SQLBASE internal datetime format */
#define   SQLPUPD   13			/* unsigend packed decimal	    */
#define   SQLPSPD   14			/* signed packed decimal	    */
#define   SQLPDTE   15			/* date only format		    */
#define   SQLPTIM   16			/* time only format		    */
#define   SQLPUSH   17			/* unsigned short		    */
#define   SQLPSSH   18			/* short			    */
#define   SQLPNST   19			/* numeric string		    */
#define   SQLPNBU   20			/* numeric buffer		    */
#define   SQLPEBC   21			/* EBCDIC buffer format 	    */
#define   SQLPDTM   21			/* data type maximum		    */
/* EXTERNAL DATA TYPES */
#define   SQLEINT   1			/* INTEGER			    */
#define   SQLESMA   2			/* SMALLINT			    */
#define   SQLEFLO   3			/* FLOAT			    */
#define   SQLECHR   4			/* CHAR 			    */
#define   SQLEVAR   5			/* VARCHAR			    */
#define   SQLELON   6			/* LONGVAR			    */
#define   SQLEDEC   7			/* DECIMAL			    */
#define   SQLEDAT   8			/* DATE 			    */
#define   SQLETIM   9			/* TIME 			    */
#define   SQLETMS   10			/* TIMESTAMP			    */
#define   SQLEMON   11			/* MONEY			    */
#define   SQLEDOU   12			/* DOUBLE			    */
#define   SQLEGPH   13			/* GRAPHIC			    */
#define   SQLEVGP   14			/* VAR GRAPHIC			    */
#define   SQLELGP   15			/* LONG VAR GRAPHIC		    */
#define   SQLEBIN   16			/* BINARY			    */
#define   SQLEVBI   17			/* VAR BINARY			    */
#define   SQLELBI   18			/* LONG BINARY			    */
#define   SQLEBOO   19			/* BOOLEAN			    */

/* SET and GET PARAMETER TYPES */
/*	Global parameters
	------------------						    */
#define   SQLPDDB   1			/* default database name	    */
#define   SQLPDUS   2			/* default user name		    */
#define   SQLPDPW   3			/* default password		    */
#define   SQLPGBC   4			/* global cursor value		    */
#define   SQLPLRD   5			/* local result set directory	    */
#define   SQLPDBM   6			/* db mode - see below		    */
#define   SQLPDBD   7			/* dbdir			    */
#define   SQLPCPG   8			/* code page information	    */
#define   SQLPNIE   9			/* null indicator error 	    */

/*	Server specific parameters
	--------------------------					    */

#define   SQLPHEP   1001		/* HEAP size for TSR executables    */
#define   SQLPCAC   1002		/* CACHE size in Kbytes 	    */
#define   SQLPBRN   1003		/* brand of database		    */
#define   SQLPVER   1004		/* release version (ex. "4.0.J")    */
#define   SQLPPRF   1005		/* server profiling		    */
#define   SQLPPDB   1006		/* partitioned database 	    */
#define   SQLPGCM   1007		/* group commit count		    */
#define   SQLPGCD   1008		/* group commit delay ticks	    */

/*	Database specific parameters
	----------------------------					    */

#define   SQLPDBN   2001		/* database name		    */
#define   SQLPDDR   2002		/* database directory		    */
#define   SQLPLDR   2003		/* log directory		    */
#define   SQLPLFS   2004		/* log file size in Kbytes	    */
#define   SQLPCTI   2005		/* checkpoint time interval in mins */
#define   SQLPLBM   2006		/* log backup mode? (0 or 1)	    */
#define   SQLPPLF   2007		/* Pre-allocate log files? (0 or 1) */
#define   SQLPTSL   2008		/* transaction span limit	    */
#define   SQLPROT   2009		/* read-only transactions (0, 1, 2) */
#define   SQLPHFS   2010		/* history file size in Kbytes	    */
#define   SQLPREC   2011		/* recovery			    */
#define   SQLPEXE   2012		/* name of executable		    */
#define   SQLPNLB   2013		/* next log to backup		    */
#define   SQLPROD   2014		/* read-only database (0 or 1)	    */
#define   SQLPEXS   2015		/* database file extension size     */
#define   SQLPPAR   2016		/* partitioned database (0 or 1)    */
#define   SQLPNDB   2017		/* NEWDB			    */
#define   SQLPLGF   2018		/* log file offset		    */

/*	Cursor specific parameters
	--------------------------					    */

#define   SQLPISO   3001		/* isolation level (SQLILRR etc..)  */
#define   SQLPWTO   3002		/* lock wait timeout in seconds     */
#define   SQLPPCX   3003		/* preserve context (0 or 1)	    */
#define   SQLPFRS   3004		/* front end result sets	    */
#define   SQLPLDV   3005		/* load version (ex. "3.6.22")      */
#define   SQLPAUT   3006		/* autocommit			    */
#define   SQLPRTO   3007		/* rollback trans on lock timeout   */
#define   SQLPSCR   3008		/* scroll mode (0 or 1) 	    */
#define   SQLPRES   3009		/* restriction mode (0 or 1)	    */
#define   SQLPFT    3010		/* fetch through		    */
#define   SQLPNPB   3011		/* no pre-build in RL mode	    */
#define   SQLPPWD   3012		/* current password		    */
#define   SQLPDB2   3013		/* DB2 compatibility mode	    */
#define   SQLPREF   3014		/* referential integrity checking   */
#define   SQLPBLK   3015		/* bulk-execute mode		    */
#define   SQLPOBL   3016		/* optimized bulk-execute mode	    */
#define   SQLPLFF   3017		/* LONG data allowed in FERS	    */
#define   SQLPDIS   3018		/* When to return Describe info     */
#define   SQLPCMP   3019		/* Compress messages sent to server */
#define   SQLPCHS   3020		/* chained cmd has SELECT (0 or 1)  */
#define   SQLPOPL   3021		/* optimizer level		    */
#define   SQLPRID   3022		/* ROWID			    */

/*	Static attributes
	--------------------------					    */

#define   SQLPFAT   4000		/* first attribute		    */
#define   SQLPBRS   4001		/* back end result sets 	    */
#define   SQLPMUL   4002		/* multi-user			    */
#define   SQLPDMO   4003		/* demonstration version	    */
#define   SQLPLOC   4004		/* local version of database	    */
#define   SQLPLAT   4005		/* last attribute		    */
/*	Server specific parameters
	----------------------------					    */

#define   SQLPPLV   5001		/* print level			    */
#define   SQLPALG   5002		/* activity log 		    */
#define   SQLPTMS   5003		/* time stamp			    */

/*	SQL Server & Router/Gateway specific parameters
	------------------------------					    */
#define   SQLPESTR  5101		/* get server error # and string    */
#define   SQLPMSTR  5102		/* get server msg# and string	    */
#define   SQLPMAPC  5103		/* MapGTICursors		    */
#define   SQLPUPRE  5104		/* get user prefix		    */
#define   SQLPORID  5105		/* Oracle RowID 		    */
#define   SQLPERRM  5106		/* error mapping		    */

/* end of SET and GET PARAMETER TYPES */


/* defines for ON, OFF, DEFAULT parameter values			    */

#define   SQLVOFF    0			/* parameter should be OFF	    */
#define   SQLVON     1			/* parameter should be ON	    */
#define   SQLVDFL    2			/* parameter should default	    */

/* defines for SQLPDBM (db mode) */

#define   SQLMDBL    1			/* DB Local			    */
#define   SQLMRTR    2			/* DB Router			    */
#define   SQLMCOM    3			/* DB Combo			    */

/* defines for database brands */

#define   SQLBSQB    1			/* SQLBASE			    */
#define   SQLBDB2    2			/* DB2				    */
#define   SQLBDBM    3			/* IBM OS/2 Database Manager	    */
#define   SQLBORA    4			/* Oracle			    */
#define   SQLBIGW    5			/* Informix			    */
#define   SQLBNTW    6			/* Netware SQL			    */
#define   SQLBAS4    7			/* IBM AS/400 SQL/400		    */
#define   SQLBSYB    8			/* Sybase SQL Server		    */
#define   SQLBDBC    9			/* Teradata DBC Machines	    */
#define   SQLBALB   10			/* HP Allbase			    */
#define   SQLBRDB   11			/* DEC's RDB                        */
#define   SQLBTDM   12			/* Tandem's Nonstop SQL             */
#define   SQLBSDS   13			/* IBM SQL/DS			    */
#define   SQLBSES   14			/* SNI SESAM			    */
#define   SQLBING   15			/* Ingres			    */
#define   SQLBSQL   16			/* SQL Access			    */
#define   SQLBDBA   17			/* DBase			    */
#define   SQLBDB4   18			/* SNI DDB4			    */
#define   SQLBFUJ   19			/* Fujitsu RDBII		    */
#define   SQLBSUP   20			/* Cincom SUPRA 		    */
#define   SQLB204   21			/* CCA Model 204		    */
#define   SQLBDAL   22			/* Apple DAL interface		    */
#define   SQLBSHR   23			/* Teradata ShareBase		    */
#define   SQLBAPP   99			/* SQLHost App Services 	    */

/* SIZES */
#define   SQLSNUM   12			/* numeric program buffer size	    */
#define   SQLSDAT   SQLSNUM		/* date-time program buffer size    */
#define   SQLSCDA   26			/* character date-time size	    */
#define   SQLSDTE   SQLSDAT		/* date (only) program buffer size  */
#define   SQLSCDE   10			/* character date (only) size	    */
#define   SQLSRID   40			/* size of ROWID		    */
#define   SQLSTIM   SQLSDAT		/* time (only) program buffer size  */
#define   SQLSCTI   15			/* character time (only) size	    */
#define   SQLSFEM   100L		/* file extension size (multi-user) */
#define   SQLSFES   20L 		/* file extension size (single-user) */
#define   SQLSTEX   5L			/* table extent size		    */

/* NULL POINTER */
#define   SQLNPTR   (ubyte1 PTR)0	/* null pointer 		    */
/* RESULT COMMAND TYPES */
#define   SQLTSEL   1			/* select			    */
#define   SQLTINS   2			/* insert			    */
#define   SQLTCTB   3			/* create table 		    */
#define   SQLTUPD   4			/* update			    */
#define   SQLTDEL   5			/* delete			    */
#define   SQLTCIN   6			/* create index 		    */
#define   SQLTDIN   7			/* drop index			    */
#define   SQLTDTB   8			/* drop table			    */
#define   SQLTCMT   9			/* commit			    */
#define   SQLTRBK   10			/* rollback			    */
#define   SQLTACO   11			/* add column			    */
#define   SQLTDCO   12			/* drop column			    */
#define   SQLTRTB   13			/* rename table 		    */
#define   SQLTRCO   14			/* rename column		    */
#define   SQLTMCO   15			/* modify column		    */
#define   SQLTGRP   16			/* grant privilege on table	    */
#define   SQLTGRD   17			/* grant dba			    */
#define   SQLTGRC   18			/* grant connect		    */
#define   SQLTGRR   19			/* grant resource		    */
#define   SQLTREP   20			/* revoke privilege on table	    */
#define   SQLTRED   21			/* revoke dba			    */
#define   SQLTREC   22			/* revoke connect		    */
#define   SQLTRER   23			/* revoke resource		    */
#define   SQLTCOM   24			/* comment on			    */
#define   SQLTWAI   25			/* wait 			    */
#define   SQLTPOS   26			/* post 			    */
#define   SQLTCSY   27			/* create synonym		    */
#define   SQLTDSY   28			/* drop synonym 		    */
#define   SQLTCVW   29			/* create view			    */
#define   SQLTDVW   30			/* drop view			    */
#define   SQLTRCT   31			/* row count			    */
#define   SQLTAPW   32			/* alter password		    */
#define   SQLTLAB   33			/* label on			    */
#define   SQLTCHN   34			/* chained command		    */
#define   SQLTRPT   35			/* repair table 		    */
#define   SQLTSVP   36			/* savepoint			    */
#define   SQLTRBS   37			/* rollback to savepoint	    */
#define   SQLTUDS   38			/* update statistics		    */
#define   SQLTCDB   39			/* check database		    */
#define   SQLTFRN   40			/* foreign DBMS commands	    */
#define   SQLTAPK   41			/* add primary key		    */
#define   SQLTAFK   42			/* add foreign key		    */
#define   SQLTDPK   43			/* drop primary key		    */
#define   SQLTDFK   44			/* drop foreign key		    */
/* SERVER COMMAND TYPES */
#define   SQLTCDA   45			/* create dbarea		    */
#define   SQLTADA   46			/* alter  dbarea		    */
#define   SQLTDDA   47			/* delete dbarea		    */
#define   SQLTCSG   48			/* create stogroup		    */
#define   SQLTASG   49			/* alter  stogroup		    */
#define   SQLTDSG   50			/* delete stogroup		    */
#define   SQLTCRD   51			/* create database		    */
#define   SQLTADB   52			/* alter  database		    */
#define   SQLTDDB   53			/* delete database		    */
#define   SQLTSDS   54			/* set default stogroup 	    */
#define   SQLTIND   55			/* install database		    */
#define   SQLTDED   56			/* de-install database		    */
/* END OF SERVER COMMAND TYPES */
#define   SQLTARU   57			/* add RI user error		    */
#define   SQLTDRU   58			/* drop RI user error		    */
#define   SQLTMRU   59			/* modify RI user error 	    */
#define   SQLTSCL   60			/* set client			    */
/* DEFAULTS */
#define   SQLDNPG   50			/* CACHE, number of cache pages     */
#define   SQLDCGP   30			/* CACHEGROUP, cache page allocation group */
#define   SQLDCRT   5			/* CONNECTRETRY, seconds for connect timeout */
#define   SQLDCPT   10			/* CONNECTPAUSETICKS, ticks for pausing */
#define   SQLDDGH   10000l		/* HEAP, DBGATEWY heap size	    */
#define   SQLDDLH   145000l		/* HEAP, DBLOCAL heap size	    */
#define   SQLDDRH   20000l		/* HEAP, DBROUTER heap size	    */
#define   SQLDNTN   71			/* INTERRUPT, interrupt number	    */
#define   SQLDNBS   30000		/* NETBUFFER, size DBXROUTR network buffer */
#define   SQLDRET   3			/* RETRY, number of connect retries */
#define   SQLDNSCPG 64			/* SORTCACHE, number of sort cache pages */
#define   SQLDSVS   0X8000		/* STACKSIZE, DBSERVER stack	    */
#define   SQLDSMS   0X8000		/* STACKSIZE, DBSIM stack	    */
#define   SQLDSRS   7000		/* STACKSIZE, DBSIM w/router stack  */
#define   SQLDTMZ   0l			/* TIMEZONE			    */
#define   SQLDSVU   128 		/* USERS, DBSERVER users	    */
#define   SQLDSMU   3			/* USERS, DBSIM users		    */
#define   SQLDCLI   1024000L		/* checkpoint log interval in bytes */
#define   SQLDCTI   1			/* checkpt time interval in minutes */
#define   SQLDWSA   1000		/* cursor work space allocation     */
#define   SQLDPRE   5			/* decimal precision		    */
#define   SQLDSCA   0			/* decimal scale		    */
#define   SQLDIML   2000		/* input message buffer length	    */
#define   SQLDPRI   10			/* integer precision		    */
#define   SQLDSUL   6			/* length of system user name	    */
#define   SQLDLBS   20480		/* log buffer size in bytes	    */
#define   SQLDLFS   1024000L		/* log file size in bytes	    */
#define   SQLDSLS   15			/* maximum # of large server stacks */
#define   SQLDHFS   1000		/* maximum history file size	    */
#define   SQLDLPM   20000		/* maximum number of rollback log pages */
#define   SQLDNES   100 		/* normal file extension size	    */
#define   SQLDOML   1000		/* output message buffer length     */
#define   SQLDPES   1024		/* partitioned file extension size  */
#define   SQLDPUB   "PUBLIC"            /* public user name                 */
#define   SQLDLPT   16000		/* rollback log page threshold	    */
#define   SQLDPRS   5			/* smallint precision		    */
#define   SQLDSUN   "SYSADM"            /* system default username          */

/* MAXIMUM SIZES */
#define   SQLMBNL   18			/* bind name length		    */
#define   SQLMCG1   32767		/* cache group pages		    */
#define   SQLMCKF   16			/* concatenated key fields	    */
#define   SQLMCLL   255 		/* clientlimit			    */
#define   SQLMCLN   12			/* maximum client name size	    */
#define   SQLMCLP   128 		/* commmand line parameter length   */
#define   SQLMCNM   8			/* max referential constraint name  */
#define   SQLMCOH   255 		/* column heading string	    */
#define   SQLMDBA   10			/* number of databases accessed     */
#define   SQLMDFN   25			/* database file name		    */
#define   SQLMDMO   750 		/* maximum DB size for demos (Kbytes) */
#define   SQLMDNM   8			/* database name		    */
#define   SQLMDVL   254 		/* data value length		    */
#define   SQLMERR   255 		/* error message length 	    */
#define   SQLMETX   3000		/* error text length		    */
#define   SQLMFNL   128 		/* filename length		    */
#define   SQLMFQN   3			/* number of fields in fully qualified column name */
#define   SQLMFRD   40			/* maximum size of foreign result set directory */
#define   SQLMGCM   32767		/* maximum group commit count	    */
#define   SQLMICO   255 		/* installed cache page owners	    */
#define   SQLMICU   255 		/* installed cursors		    */
#define   SQLMIDB   255 		/* installed databases		    */
#define   SQLMILK   32767		/* installed locks		    */
#define   SQLMINL   2000		/* input length 		    */
#define   SQLMIPG   32767		/* installed pages		    */
#define   SQLMIPR   255 		/* installed processes		    */
#define   SQLMISCPG 5000		/* installed sort cache pages	    */
#define   SQLMITR   255 		/* installed transactions	    */
#define   SQLMJTB   17			/* joined tables		    */
#define   SQLMLID   32			/* long identifiers		    */
#define   SQLMNBF   60000		/* network buffer size		    */
#define   SQLMNCO   254 		/* number of columns allowed	    */
#define   SQLMOUL   1000		/* output length		    */
#define   SQLMPAL   255 		/* max path string length	    */
#define   SQLMPKL   254 		/* max primary key length	    */
#define   SQLMPRE   15			/* maximum decimal precision	    */
#define   SQLMPTL   4			/* maximum print level		    */
#define   SQLMRBB   8192		/* maximum rollback log buffer	    */
#define   SQLMRCB   20480		/* maximum recovery log buffer	    */
#define   SQLMRET   1000		/* retry count			    */
#define   SQLMRFH   4			/* maximum # remote file handles    */
#define   SQLMROB   8192		/* max. size of restore output buffer */
#define   SQLMSES   16			/* number of sessions		    */
#define   SQLMSID   8			/* short identifiers		    */
#define   SQLMSLI   255 		/* maximum number of select list exprs. */
#define   SQLMSNM   8			/* server name			    */
#define   SQLMSRL   32			/* maximum length of SQL reserved word */
#define   SQLMSVN   199 		/* maximum server names 	    */
#define   SQLMTFS   10			/* maximum temporary file size	    */
#define   SQLMTMO   200 		/* maximum timeout		    */
#define   SQLMTSS   256 		/* text string space size	    */
#define   SQLMVER   8			/* max version string (nn.nn.nn)    */
#define   SQLMXER   255 		/* Extended error message length    */
#define   SQLMXLF   4194304		/* max log file size		    */

/* MINIMUMS */
#define   SQLMCG0   1			/* cache group pages		    */
#define   SQLMEXS   1024		/* partitioned file extension size  */
#define   SQLMLFE   100000L		/* minimum log file extension size  */
#define   SQLMLFS   100000L		/* minimum log file size	    */
#define   SQLMPAG   15			/* minimum pages (cache)	    */
#define   SQLMSCPAG 32			/* minimum sort cache pages	    */
#define   SQLMSRS   3000		/* minimum sort space		    */

/* typedefs */
typedef   unsigned char     ubyte1;
typedef   unsigned short    ubyte2;
typedef   unsigned long     ubyte4;
typedef 	   ubyte1    byte1;
typedef 	   short     byte2;
typedef 	   long      byte4;
typedef   unsigned char PTR ubyte1p;
#if OS20
typedef int (* _Far16 _Pascal SQLTPFP)();
#else
typedef int (far pascal *SQLTPFP)();
#endif

typedef   ubyte1    SQLTARC;		/* remote connection architecture   */
typedef   ubyte1    SQLTBNL;		/* bind name length		    */
typedef   ubyte1    SQLTBNN;		/* bind number			    */
typedef   ubyte1p   SQLTBNP;		/* bind name pointer		    */
typedef   byte2     SQLTNUL;		/* null indicator		    */
typedef   ubyte1    SQLTBOO;		/* boolean data type		    */
typedef   ubyte1    SQLTCDL;		/* column data length		    */
typedef   ubyte1    SQLTCHL;		/* column header length 	    */
typedef   ubyte1    SQLTCHO;		/* check option 		    */
typedef   ubyte1p   SQLTCHP;		/* column header pointer	    */
typedef   ubyte1    SQLTCTY;		/* command type 		    */
typedef   ubyte2    SQLTCUR;		/* cursor number		    */
typedef   ubyte2    SQLTDAL;		/* data length			    */
typedef   ubyte1p   SQLTDAP;		/* data pointer 		    */
typedef   byte2     SQLTDAY;		/* number of days		    */
typedef   ubyte1    SQLTDDL;		/* database data length 	    */
typedef   ubyte1    SQLTDDT;		/* database data type		    */
typedef   ubyte2    SQLTDEDL;		/* database extended data length    */
typedef   ubyte2    SQLTDPT;		/* database parameter type	    */
typedef   ubyte4    SQLTDPV;		/* database parameter value	    */
typedef   ubyte2    SQLTEPO;		/* error position		    */
typedef   ubyte2    SQLTFLD;		/* SELECT statement field number    */
typedef   byte2     SQLTFLG;		/* flag field			    */
typedef   ubyte4    SQLTFLH;		/* file handle			    */
typedef   byte2     SQLTFMD;		/* file mode			    */
typedef   ubyte2    SQLTFNL;		/* file name length		    */
typedef   ubyte1p   SQLTFNP;		/* file name pointer		    */
typedef   ubyte1    SQLTFSC;		/* fetch status code		    */
typedef   ubyte1p   SQLTILV;		/* isolation level string	    */
typedef   ubyte1    SQLTLBL;		/* label information length	    */
typedef   ubyte1p   SQLTLBP;		/* label infromation pointer	    */
typedef   byte4     SQLTLNG;		/* long size			    */
typedef   ubyte4    SQLTLSI;		/* long size			    */
typedef   ubyte2    SQLTMSZ;		/* message size 		    */
typedef   ubyte1    SQLTNBV;		/* number of bind variables	    */
typedef   ubyte2    SQLTNCU;		/* number of cursors		    */
typedef   ubyte1    SQLTNML;		/* number length		    */
typedef   ubyte1p   SQLTNMP;		/* number pointer		    */
typedef   ubyte2    SQLTNPG;		/* number of pages		    */
typedef   ubyte1    SQLTNSI;		/* number of select items	    */
typedef   ubyte1    SQLTPCX;		/* preserve context flag	    */
typedef   ubyte1    SQLTPDL;		/* program data length		    */
typedef   ubyte1    SQLTPDT;		/* program data type		    */
typedef   ubyte4    SQLTPGN;		/* page number			    */
typedef   ubyte2    SQLTPNM;		/* process number		    */
typedef   ubyte1    SQLTPRE;		/* precision			    */
typedef   ubyte2    SQLTPTY;		/* set/get parameter type	    */
typedef   ubyte1    SQLTRBF;		/* roll back flag		    */
typedef   byte2     SQLTRCD;		/* return codes 		    */
typedef   ubyte1    SQLTRCF;		/* recovery flag		    */
typedef   ubyte2    SQLTRFM;		/* rollforward mode		    */
typedef   byte4     SQLTROW;		/* number of rows		    */
typedef   ubyte1    SQLTSCA;		/* scale			    */
typedef   ubyte1    SQLTSLC;		/* select list column		    */
typedef   ubyte2    SQLTSTC;		/* statistics counter		    */
typedef   ubyte2    SQLTSVH;		/* server handle		    */
typedef   ubyte2    SQLTSVN;		/* server number		    */
typedef   byte2     SQLTTIV;		/* wait timeout value		    */
typedef   byte2     SQLTWNC;		/* whence			    */
typedef   ubyte2    SQLTWSI;		/* work size			    */
typedef   ubyte2    SQLTBIR;		/* bulk insert error row number     */
typedef   ubyte1p   SQLTDIS;		/* Describe info indicator	    */
typedef   byte4     SQLTXER;		/* extended error #		    */
/* defines for isolation level string */
#define   SQLILRR   "RR"                /* Repeatable Read isolation        */
#define   SQLILCS   "CS"                /* Cursor Stability isolation       */
#define   SQLILRO   "RO"                /* Read-Only isolation              */
#define   SQLILRL   "RL"                /* Release Locks isolation          */
/* defines for SQLROF rollforward mode parameter			    */
#define   SQLMEOL   1			/* rollforward to end of log	    */
#define   SQLMEOB   2			/* rollforward to end of backup     */
#define   SQLMTIM   3			/* rollforward to specified time    */
/* defines for when to collect Describe information			    */
#define   SQLDELY   0			/* get Describe info after sqlcom   */
#define   SQLDDLD   1			/* get Describe info after sqlexe   */
#define   SQLDNVR   2			/* never get any Describe info	    */
/* defines for SQLETX error text type parameter 			    */
#define   SQLXMSG   1			/* retrieve error message text	    */
#define   SQLXREA   2			/* retrieve error message reason    */
#define   SQLXREM   4			/* retrieve error message remedy    */

/* SYSTEM DEFINED TYPEDEF'S -- FOR SYSTEM USE ONLY                          */

typedef   ubyte2 SQLTMSL;		/* message length		    */
typedef   byte1 _far* SQLTMSP;		 /* message pointer		     */

/*
DESCRIPTION
  This structure is used to receive system information from the
  backend.  Structure elements must be arranged so that the structure
  layout is the same in packed or padded compilation modes.  For
  now, this means longs in the front, ints in the middle, and chars at
  the end of the structure.
*/

struct	  sysdefx
	  {
	  SQLTPGN   syslpt;		/* log page threshold		    */
	  SQLTPGN   syslpm;		/* log page maximum		    */
	  ubyte4    syshep;		/* heap size			    */
	  SQLTNPG   sysncp;		/* number of cache pages	    */
	  SQLTTIV   systiv;		/* wait timeout value in seconds    */
	  ubyte1    sysiso[3];		/* isolation level		    */
	  ubyte1    sysjou;		/* journal			    */
	  ubyte1    syslog;		/* log				    */
	  ubyte1    sysrec;		/* recovery			    */
	  ubyte1    systyp;		/* system type			    */
	  };
typedef   struct    sysdefx sysdef;
typedef   struct    sysdefx SQLTSYS;
#if OS20
  #pragma seg16( sysdef )
  #pragma seg16( SQLTSYS )
#endif
#define   SYSSIZ    sizeof(sysdef)

/*
DESCRIPTION:
  This structure is used as a parameter to the SQLGDI function.  After a
  a compile, all relevant information for a given Select column can be
  obtained in this structure.
*/
struct	  gdidefx
	  {
	  ubyte1   gdichb[31];		/* column heading		    */
	  SQLTCHL  gdichl;		/* column heading length	    */
	  ubyte1   gdilbb[31];		/* label buffer 		    */
	  SQLTLBL  gdilbl;		/* label info length		    */
	  SQLTSLC  gdicol;		/* select column number 	    */
	  SQLTDDT  gdiddt;		/* database data type		    */
	  SQLTDEDL gdiddl;		/* database extended data length    */
	  SQLTDDT  gdiedt;		/* external data type		    */
	  SQLTDEDL gdiedl;		/* external extended data length    */
	  SQLTPRE  gdipre;		/* decimal precision		    */
	  SQLTSCA  gdisca;		/* decimal scale		    */
	  byte2    gdinul;		/* null indicator		    */
	  byte1    gdifil[50];		/* for future use		    */
	  };
typedef   struct    gdidefx gdidef;
typedef   struct gdidefx SQLTGDI;
typedef   struct gdidefx* SQLTPGD;
#if OS20
  #pragma seg16( gdidef )
  #pragma seg16( SQLTGDI )
  #pragma seg16( SQLTPGD )
#endif
#define   GDISIZ    sizeof(gdidef)

/* system types */
#define   SYSTSGL   1			/* single user			    */
#define   SYSTMUL   2			/* multi-user			    */
#define   SYSTDB2   3			/* DB2				    */
#define   SYSTDMO   4			/* demo 			    */
#define   SYSTGWY   5			/* SQLNetwork Gateway		    */
#define   SYSTRTR   6			/* SQLNetwork Router		    */
#define   SYSTSHAS  7			/* SQLNetwork SQLHost App Services  */

#if OS20
#define SQLTAPI byte2 _Far16 _Pascal
#elif SYSFN386
#define SQLTAPI byte2 pascal
#else
#define SQLTAPI byte2 far pascal
#endif
#ifndef NLINT_ARGS			/* argument checking enabled	    */

/* SQL FUNCTION PROTOTYPES */

SQLTAPI sqlarf(SQLTCUR	   cur	   , SQLTFNP	 fnp	 ,
	       SQLTFNL	   fnl	   , SQLTCHO	 cho	 );
SQLTAPI sqlbbr(SQLTCUR	   cur	   , SQLTXER PTR errno	 ,
	       SQLTDAP	   errbuf  , SQLTDAL PTR buflen  ,
	       SQLTBIR PTR errrow  , SQLTRBF PTR rbf	 ,
	       SQLTBIR	   errseq  );
SQLTAPI sqlbdb(SQLTSVH	   shandle , SQLTDAP	 dbname  ,
	       SQLTDAL	   dbnamel , SQLTFNP	 bkpdir  ,
	       SQLTFNL	   bkpdirl , SQLTBOO	 local	 ,
	       SQLTBOO	   over    );
SQLTAPI sqlbef(SQLTCUR	   cur	   );
SQLTAPI sqlber(SQLTCUR	   cur	   , SQLTRCD PTR rcd	 ,
	       SQLTBIR PTR errrow  , SQLTRBF PTR rbf	 ,
	       SQLTBIR	   errseq  );
SQLTAPI sqlbkp(SQLTCUR	   cur	   , SQLTBOO	 defalt  ,
	       SQLTBOO	   overwrt , SQLTFNP	 bkfname ,
	       SQLTFNL	   bkfnlen );
SQLTAPI sqlbld(SQLTCUR	   cur	   , SQLTBNP	 bnp	 ,
	       SQLTBNL	   bnl	   );
SQLTAPI sqlblf(SQLTSVH	   shandle , SQLTDAP	 dbname  ,
	       SQLTDAL	   dbnamel , SQLTFNP	 bkpdir  ,
	       SQLTFNL	   bkpdirl , SQLTBOO	 local	 ,
	       SQLTBOO	   over    );
SQLTAPI sqlblk(SQLTCUR	   cur	   , SQLTFLG	 blkflg  );
SQLTAPI sqlbln(SQLTCUR	   cur	   , SQLTBNN	 bnn	 );
SQLTAPI sqlbna(SQLTCUR	   cur	   , SQLTBNP	 bnp	 ,
	       SQLTBNL	   bnl	   , SQLTDAP	 dap	 ,
	       SQLTDAL	   dal	   , SQLTSCA	 sca	 ,
	       SQLTPDT	   pdt	   , SQLTNUL	 nli	 );
SQLTAPI sqlbnd(SQLTCUR	   cur	   , SQLTBNP	 bnp	 ,
	       SQLTBNL	   bnl	   , SQLTDAP	 dap	 ,
	       SQLTDAL	   dal	   , SQLTSCA	 sca	 ,
	       SQLTPDT	   pdt	   );
SQLTAPI sqlbnn(SQLTCUR	   cur	   , SQLTBNN	 bnn	 ,
	       SQLTDAP	   dap	   , SQLTDAL	 dal	 ,
	       SQLTSCA	   sca	   , SQLTPDT	 pdt	 );
SQLTAPI sqlbnu(SQLTCUR	   cur	   , SQLTBNN	 bnn	 ,
	       SQLTDAP	   dap	   , SQLTDAL	 dal	 ,
	       SQLTSCA	   sca	   , SQLTPDT	 pdt	 ,
	       SQLTNUL	   nli	   );
SQLTAPI sqlbss(SQLTSVH	   shandle , SQLTDAP	 dbname  ,
	       SQLTDAL	   dbnamel , SQLTFNP	 bkpdir  ,
	       SQLTFNL	   bkpdirl , SQLTBOO	 local	 ,
	       SQLTBOO	   over    );
SQLTAPI sqlcan(SQLTCUR	   cur	   );
SQLTAPI sqlcbv(SQLTCUR	   cur	   );
SQLTAPI sqlcex(SQLTCUR	   cur	   , SQLTDAP	 dap	 ,
	       SQLTDAL	   dal	   );
SQLTAPI sqlclf(SQLTSVH	   cur	   , SQLTDAP	 logfile ,
	       SQLTFMD	   startflag);
SQLTAPI sqlcmt(SQLTCUR	   cur	   );
SQLTAPI sqlcnc(SQLTCUR PTR curp    , SQLTDAP	 dbnamp  ,
	       SQLTDAL	   dbnaml  );
SQLTAPI sqlcnr(SQLTCUR PTR curp    , SQLTDAP	 dbnamp  ,
	       SQLTDAL	   dbnaml  );
SQLTAPI sqlcom(SQLTCUR	   cur	   , SQLTDAP	 cmdp	 ,
	       SQLTDAL	   cmdl    );
SQLTAPI sqlcon(SQLTCUR PTR curp    , SQLTDAP	 dbnamp  ,
	       SQLTDAL	   dbnaml  , SQLTWSI	 cursiz  ,
	       SQLTNPG	   pages   , SQLTRCF	 recovr  ,
	       SQLTDAL	   outsize , SQLTDAL	 insize  );
SQLTAPI sqlcpy(SQLTCUR	   fcur    , SQLTDAP	 selp	 ,
	       SQLTDAL	   sell    , SQLTCUR	 tcur	 ,
	       SQLTDAP	   isrtp   , SQLTDAL	 isrtl	 );
SQLTAPI sqlcre(SQLTSVH	   shandle , SQLTDAP	 dbnamp  ,
	       SQLTDAL	   dbnaml  );
SQLTAPI sqlcrf(SQLTSVH	   shandle , SQLTDAP	 dbname  ,
	       SQLTDAL	   dbnamel );
SQLTAPI sqlcrs(SQLTCUR	   cur	   , SQLTDAP	 rsp	 ,
	       SQLTDAL	   rsl	   );
SQLTAPI sqlcsv(SQLTSVH PTR handlep , SQLTDAP	 serverid,
	       SQLTDAP	   password);
SQLTAPI sqlcty(SQLTCUR	   cur	   , SQLTCTY PTR cty	 );
SQLTAPI sqldbn(SQLTDAP	   serverid, SQLTDAP	 buffer  ,
	       SQLTDAL	   length  );
SQLTAPI sqlded(SQLTSVH	   shandle , SQLTDAP	 dbnamp  ,
	       SQLTDAL	   dbnaml  );
SQLTAPI sqldel(SQLTSVH	   shandle , SQLTDAP	 dbnamp  ,
	       SQLTDAL	   dbnaml  );
SQLTAPI sqldes(SQLTCUR	   cur	   , SQLTSLC	 slc	 ,
	       SQLTDDT PTR ddt	   , SQLTDDL PTR ddl	 ,
	       SQLTCHP	   chp	   , SQLTCHL PTR chlp	 ,
	       SQLTPRE PTR prep    , SQLTSCA PTR scap	 );
SQLTAPI sqldid(SQLTDAP	   dbname  , SQLTDAL	 dbnamel );
SQLTAPI sqldin(SQLTDAP	   dbnamp  , SQLTDAL	 dbnaml  );
SQLTAPI sqldir(SQLTSVN	   srvno   , SQLTDAP	 buffer  ,
	       SQLTDAL	   length  );
SQLTAPI sqldis(SQLTCUR	   cur	   );
SQLTAPI sqldon(void);
SQLTAPI sqldrc(SQLTSVH	   cur	   );
SQLTAPI sqldro(SQLTSVH	   cur	   , SQLTDAP	 dirname );
SQLTAPI sqldrr(SQLTSVH	   cur	   , SQLTDAP	 filename);
SQLTAPI sqldrs(SQLTCUR	   cur	   , SQLTDAP	 rsp	 ,
	       SQLTDAL	   rsl	   );
SQLTAPI sqldsc(SQLTCUR	   cur	   , SQLTSLC	 slc	 ,
	       SQLTDDT PTR edt	   , SQLTDDL PTR edl	 ,
	       SQLTCHP	   chp	   , SQLTCHL PTR chlp	 ,
	       SQLTPRE PTR prep    , SQLTSCA PTR scap	 );
SQLTAPI sqldst(SQLTCUR	   cur	   , SQLTDAP	 cnp	 ,
	       SQLTDAL	   cnl	   );
SQLTAPI sqldsv(SQLTSVH	   handle  );
SQLTAPI sqlebk(SQLTCUR	   cur	   );
SQLTAPI sqlefb(SQLTCUR	   cur	   );
SQLTAPI sqlelo(SQLTCUR	   cur	   );
SQLTAPI sqlenr(SQLTSVH	   shandle , SQLTDAP	 dbname  ,
	       SQLTDAL	   dbnamel );
SQLTAPI sqlepo(SQLTCUR	   cur	   , SQLTEPO PTR epo	 );
SQLTAPI sqlerf(SQLTCUR	   cur	   );
SQLTAPI sqlerr(SQLTRCD	   error   , SQLTDAP	 msg	 );
SQLTAPI sqlers(SQLTCUR	   cur	   );
SQLTAPI sqletx(SQLTRCD	   error   , SQLTPTY	 msgtyp  ,
	       SQLTDAP	   bfp	   , SQLTDAL	 bfl	 ,
	       SQLTDAL PTR txtlen  );
SQLTAPI sqlexe(SQLTCUR	   cur	   );
SQLTAPI sqlexp(SQLTCUR	   cur	   , SQLTDAP	 buffer  ,
	       SQLTDAL	   length  );
SQLTAPI sqlfbk(SQLTCUR	   cur	   );
SQLTAPI sqlfer(SQLTRCD	   error   , SQLTDAP	 msg	 );
SQLTAPI sqlfet(SQLTCUR	   cur	   );
SQLTAPI sqlfgt(SQLTSVH	   cur	   , SQLTDAP	 srvfile ,
	       SQLTDAP	   lclfile );
SQLTAPI sqlfpt(SQLTSVH	   cur	   , SQLTDAP	 srvfile ,
	       SQLTDAP	   lclfile );
SQLTAPI sqlfqn(SQLTCUR	   cur	   , SQLTFLD	 field	 ,
	       SQLTDAP	   nameptr , SQLTDAL PTR namelen );
SQLTAPI sqlgdi(SQLTCUR	   cur	   , SQLTPGD	 gdi	 );
SQLTAPI sqlget(SQLTCUR	   cur	   , SQLTPTY	 parm	 ,
	       SQLTDAP	   p	   , SQLTDAL PTR l	 );
SQLTAPI sqlgfi(SQLTCUR	   cur	   , SQLTSLC	 slc	 ,
	       SQLTCDL PTR cvl	   , SQLTFSC PTR fsc	 );
SQLTAPI sqlgls(SQLTCUR	   cur	   , SQLTSLC	 slc	 ,
	       SQLTLSI PTR size    );
SQLTAPI sqlgnl(SQLTSVH	   shandle , SQLTDAP	 dbname  ,
	       SQLTDAL	   dbnamel , SQLTLNG PTR lognum  );
SQLTAPI sqlgnr(SQLTCUR	   cur	   , SQLTDAP	 tbnam	 ,
	       SQLTDAL	   tbnaml  , SQLTROW PTR rows	 );
SQLTAPI sqlgsi(SQLTSVH	   cur	   , SQLTFLG	 infoflags,
	       SQLTDAP	   buffer  , SQLTDAL	 buflen  ,
	       SQLTDAL PTR rbuflen );
SQLTAPI sqlidb(SQLTCUR	   cur	   );
SQLTAPI sqlims(SQLTCUR	   cur	   , SQLTDAL	 insize  );
SQLTAPI sqlind(SQLTSVH	   shandle , SQLTDAP	 dbnamp  ,
	       SQLTDAL	   dbnaml  );
SQLTAPI sqlini(SQLTPFP	   callback);
SQLTAPI sqlins(SQLTSVN	   srvno   , SQLTDAP	 dbnamp  ,
	       SQLTDAL	   dbnaml  , SQLTFLG	 createflag,
	       SQLTFLG	   overwrite);
SQLTAPI sqllab(SQLTCUR	   cur	   , SQLTSLC	 slc	 ,
	       SQLTCHP	   lbp	   , SQLTCHL PTR lblp	 );
SQLTAPI sqllsk(SQLTCUR	   cur	   , SQLTSLC	 slc	 ,
	       SQLTLSI	   pos	   );
SQLTAPI sqlmcl(SQLTSVH	   cur	   , SQLTFLH	 fd	 );
SQLTAPI sqlmdl(SQLTSVH	   cur	   , SQLTDAP	 filename);
SQLTAPI sqlmop(SQLTSVH	   cur	   , SQLTFLH PTR fdp	 ,
	       SQLTDAP	   filename, SQLTFMD	 openmode);
SQLTAPI sqlmrd(SQLTSVH	   cur	   , SQLTFLH	 fd	 ,
	       SQLTDAP	   buffer  , SQLTDAL	 len	 ,
	       SQLTDAL PTR rlen    );
SQLTAPI sqlmsk(SQLTSVH	   cur	   , SQLTFLH	 fd	 ,
	       SQLTLNG	   offset  , SQLTWNC	 whence  ,
	       SQLTLNG PTR roffset );
SQLTAPI sqlmwr(SQLTSVH	   cur	   , SQLTFLH	 fd	 ,
	       SQLTDAP	   buffer  , SQLTDAL	 len	 ,
	       SQLTDAL PTR rlen    );
SQLTAPI sqlnbv(SQLTCUR	   cur	   , SQLTNBV PTR nbv	 );
SQLTAPI sqlnrr(SQLTCUR	   cur	   , SQLTROW PTR rcountp );
SQLTAPI sqlnsi(SQLTCUR	   cur	   , SQLTNSI PTR nsi	 );
SQLTAPI sqloms(SQLTCUR	   cur	   , SQLTDAL	 outsize );
SQLTAPI sqlprs(SQLTCUR	   cur	   , SQLTROW	 row	 );
SQLTAPI sqlrbf(SQLTCUR	   cur	   , SQLTRBF PTR rbf	 );
SQLTAPI sqlrbk(SQLTCUR	   cur	   );
SQLTAPI sqlrcd(SQLTCUR	   cur	   , SQLTRCD PTR rcd	 );
SQLTAPI sqlrdb(SQLTSVH	   shandle , SQLTDAP	 dbname  ,
	       SQLTDAL	   dbnamel , SQLTFNP	 bkpdir  ,
	       SQLTFNL	   bkpdirl , SQLTBOO	 local	 ,
	       SQLTBOO	   over    );
SQLTAPI sqlrdc(SQLTCUR	   cur	   , SQLTDAP	 bufp	 ,
	       SQLTDAL	   bufl    , SQLTDAL PTR readl	 );
SQLTAPI sqlrel(SQLTCUR	   cur	   );
SQLTAPI sqlres(SQLTCUR PTR curptr  , SQLTFNP	 bkfname ,
	       SQLTFNL	   bkfnlen , SQLTSVN	 bkfserv ,
	       SQLTBOO	   overwrt , SQLTDAP	 dbname  ,
	       SQLTDAL	   dbnlen  , SQLTSVN	 dbserv  );
SQLTAPI sqlret(SQLTCUR	   cur	   , SQLTDAP	 cnp	 ,
	       SQLTDAL	   cnl	   );
SQLTAPI sqlrlf(SQLTSVH	   shandle , SQLTDAP	 dbname  ,
	       SQLTDAL	   dbnamel , SQLTFNP	 bkpdir  ,
	       SQLTFNL	   bkpdirl , SQLTBOO	 local	 ,
	       SQLTBOO	   over    );
SQLTAPI sqlrlo(SQLTCUR	   cur	   , SQLTSLC	 slc	 ,
	       SQLTDAP	   bufp    , SQLTDAL	 bufl	 ,
	       SQLTDAL PTR readl   );
SQLTAPI sqlrof(SQLTSVH	   shandle , SQLTDAP	 dbname  ,
	       SQLTDAL	   dbnamel , SQLTRFM	 mode	 ,
	       SQLTDAP	   datetime, SQLTDAL	 datetimel);
SQLTAPI sqlrow(SQLTCUR	   cur	   , SQLTROW PTR row	 );
SQLTAPI sqlrrd(SQLTCUR	   cur	   );
SQLTAPI sqlrrs(SQLTCUR	   cur	   , SQLTDAP	 rsp	 ,
	       SQLTDAL	   rsl	   );
SQLTAPI sqlrss(SQLTSVH	   shandle , SQLTDAP	 dbname  ,
	       SQLTDAL	   dbnamel , SQLTFNP	 bkpdir  ,
	       SQLTFNL	   bkpdirl , SQLTBOO	 local	 ,
	       SQLTBOO	   over    );
SQLTAPI sqlsab(SQLTSVH	   shandle , SQLTPNM	 pnum	 );
SQLTAPI sqlsap(SQLTSVN	   srvno   , SQLTDAP	 password,
	       SQLTPNM	   pnum    );
SQLTAPI sqlscn(SQLTCUR	   cur	   , SQLTDAP	 namp	 ,
	       SQLTDAL	   naml    );
SQLTAPI sqlscp(SQLTNPG	   pages   );
SQLTAPI sqlsdn(SQLTDAP	   dbnamp  , SQLTDAL	 dbnaml  );
SQLTAPI sqlset(SQLTCUR	   cur	   , SQLTPTY	 parm	 ,
	       SQLTDAP	   p	   , SQLTDAL	 l	 );
SQLTAPI sqlsil(SQLTCUR	   cur	   , SQLTILV	 isolation);
SQLTAPI sqlslp(SQLTCUR	   cur	   , SQLTNPG	 lpt	 ,
	       SQLTNPG	   lpm	   );
SQLTAPI sqlspr(SQLTCUR	   cur	   );
SQLTAPI sqlsrf(SQLTCUR	   cur	   , SQLTDAP	 fnp	 ,
	       SQLTDAL	   fnl	   );
SQLTAPI sqlsrs(SQLTCUR	   cur	   );
SQLTAPI sqlssb(SQLTCUR	   cur	   , SQLTSLC	 slc	 ,
	       SQLTPDT	   pdt	   , SQLTDAP	 pbp	 ,
	       SQLTPDL	   pdl	   , SQLTSCA	 sca	 ,
	       SQLTCDL PTR pcv	   , SQLTFSC PTR pfc	 );
SQLTAPI sqlsss(SQLTCUR	   cur	   , SQLTDAL	 size	 );
SQLTAPI sqlsta(SQLTCUR	   cur	   , SQLTSTC PTR svr	 ,
	       SQLTSTC PTR svw	   , SQLTSTC PTR spr	 ,
	       SQLTSTC PTR spw	   );
SQLTAPI sqlstm(SQLTSVH	   shandle );
SQLTAPI sqlsto(SQLTCUR	   cur	   , SQLTDAP	 cnp	 ,
	       SQLTDAL	   cnl	   , SQLTDAP	 ctp	 ,
	       SQLTDAL	   ctl	   );
SQLTAPI sqlstr(SQLTCUR	   cur	   );
SQLTAPI sqlsxt(SQLTSVN	   srvno   , SQLTDAP	 password);
SQLTAPI sqlsys(SQLTCUR	   cur	   , SQLTSYS PTR sys	 );
SQLTAPI sqltec(SQLTRCD	   rcd	   , SQLTRCD PTR np	 );
SQLTAPI sqltio(SQLTCUR	   cur	   , SQLTTIV	 _timeout);
SQLTAPI sqlurs(SQLTCUR	   cur	   );
SQLTAPI sqlwdc(SQLTCUR	   cur	   , SQLTDAP	 bufp	 ,
	       SQLTDAL	   bufl    );
SQLTAPI sqlwlo(SQLTCUR	   cur	   , SQLTDAP	 bufp	 ,
	       SQLTDAL	   bufl    );
SQLTAPI sqlxad(SQLTNMP	   op	   , SQLTNMP	 np1	 ,
	       SQLTNML	   nl1	   , SQLTNMP	 np2	 ,
	       SQLTNML	   nl2	   );
SQLTAPI sqlxcn(SQLTNMP	   op	   , SQLTDAP	 ip	 ,
	       SQLTDAL	   il	   );
SQLTAPI sqlxda(SQLTNMP	   op	   , SQLTNMP	 dp	 ,
	       SQLTNML	   dl	   , SQLTDAY	 days	 );
SQLTAPI sqlxdp(SQLTDAP	   op	   , SQLTDAL	 ol	 ,
	       SQLTNMP	   ip	   , SQLTNML	 il	 ,
	       SQLTDAP	   pp	   , SQLTDAL	 pl	 );
SQLTAPI sqlxdv(SQLTNMP	   op	   , SQLTNMP	 np1	 ,
	       SQLTNML	   nl1	   , SQLTNMP	 np2	 ,
	       SQLTNML	   nl2	   );
SQLTAPI sqlxer(SQLTCUR	      cur  , SQLTXER PTR    errno,
	       SQLTDAP	      errbuf, SQLTDAL PTR    buflen);
SQLTAPI sqlxml(SQLTNMP	   op	   , SQLTNMP	 np1	 ,
	       SQLTNML	   nl1	   , SQLTNMP	 np2	 ,
	       SQLTNML	   nl2	   );
SQLTAPI sqlxnp(SQLTDAP	   outp    , SQLTDAL	 outl	 ,
	       SQLTNMP	   isnp    , SQLTNML	 isnl	 ,
	       SQLTDAP	   picp    , SQLTDAL	 picl	 );
SQLTAPI sqlxpd(SQLTNMP	   op	   , SQLTNML PTR olp	 ,
	       SQLTDAP	   ip	   , SQLTDAP	 pp	 ,
	       SQLTDAL	   pl	   );
SQLTAPI sqlxsb(SQLTNMP	   op	   , SQLTNMP	 np1	 ,
	       SQLTNML	   nl1	   , SQLTNMP	 np2	 ,
	       SQLTNML	   nl2	   );

#else

SQLTAPI sqlarf();
SQLTAPI sqlbbr();
SQLTAPI sqlbdb();
SQLTAPI sqlbef();
SQLTAPI sqlber();
SQLTAPI sqlbkp();
SQLTAPI sqlbld();
SQLTAPI sqlblf();
SQLTAPI sqlblk();
SQLTAPI sqlbln();
SQLTAPI sqlbna();
SQLTAPI sqlbnd();
SQLTAPI sqlbnn();
SQLTAPI sqlbnu();
SQLTAPI sqlbss();
SQLTAPI sqlcan();
SQLTAPI sqlcbv();
SQLTAPI sqlcex();
SQLTAPI sqlclf();
SQLTAPI sqlcmt();
SQLTAPI sqlcnc();
SQLTAPI sqlcnr();
SQLTAPI sqlcom();
SQLTAPI sqlcon();
SQLTAPI sqlcpy();
SQLTAPI sqlcre();
SQLTAPI sqlcrf();
SQLTAPI sqlcrs();
SQLTAPI sqlcsv();
SQLTAPI sqlcty();
SQLTAPI sqldbn();
SQLTAPI sqlded();
SQLTAPI sqldel();
SQLTAPI sqldes();
SQLTAPI sqldid();
SQLTAPI sqldin();
SQLTAPI sqldir();
SQLTAPI sqldis();
SQLTAPI sqldon();
SQLTAPI sqldrc();
SQLTAPI sqldro();
SQLTAPI sqldrr();
SQLTAPI sqldrs();
SQLTAPI sqldsc();
SQLTAPI sqldst();
SQLTAPI sqldsv();
SQLTAPI sqlebk();
SQLTAPI sqlefb();
SQLTAPI sqlelo();
SQLTAPI sqlenr();
SQLTAPI sqlepo();
SQLTAPI sqlerf();
SQLTAPI sqlerr();
SQLTAPI sqlers();
SQLTAPI sqletx();
SQLTAPI sqlexe();
SQLTAPI sqlexp();
SQLTAPI sqlfbk();
SQLTAPI sqlfer();
SQLTAPI sqlfet();
SQLTAPI sqlfgt();
SQLTAPI sqlfpt();
SQLTAPI sqlfqn();
SQLTAPI sqlgdi();
SQLTAPI sqlget();
SQLTAPI sqlgfi();
SQLTAPI sqlgls();
SQLTAPI sqlgnl();
SQLTAPI sqlgnr();
SQLTAPI sqlgsi();
SQLTAPI sqlidb();
SQLTAPI sqlims();
SQLTAPI sqlind();
SQLTAPI sqlini();
SQLTAPI sqlins();
SQLTAPI sqllab();
SQLTAPI sqllsk();
SQLTAPI sqlmcl();
SQLTAPI sqlmdl();
SQLTAPI sqlmop();
SQLTAPI sqlmrd();
SQLTAPI sqlmsk();
SQLTAPI sqlmwr();
SQLTAPI sqlnbv();
SQLTAPI sqlnrr();
SQLTAPI sqlnsi();
SQLTAPI sqloms();
SQLTAPI sqlprs();
SQLTAPI sqlrbf();
SQLTAPI sqlrbk();
SQLTAPI sqlrcd();
SQLTAPI sqlrdb();
SQLTAPI sqlrdc();
SQLTAPI sqlrel();
SQLTAPI sqlres();
SQLTAPI sqlret();
SQLTAPI sqlrlf();
SQLTAPI sqlrlo();
SQLTAPI sqlrof();
SQLTAPI sqlrow();
SQLTAPI sqlrrd();
SQLTAPI sqlrrs();
SQLTAPI sqlrss();
SQLTAPI sqlsab();
SQLTAPI sqlsap();
SQLTAPI sqlscn();
SQLTAPI sqlscp();
SQLTAPI sqlsdn();
SQLTAPI sqlset();
SQLTAPI sqlsil();
SQLTAPI sqlslp();
SQLTAPI sqlspr();
SQLTAPI sqlsrf();
SQLTAPI sqlsrs();
SQLTAPI sqlssb();
SQLTAPI sqlsss();
SQLTAPI sqlsta();
SQLTAPI sqlstm();
SQLTAPI sqlsto();
SQLTAPI sqlstr();
SQLTAPI sqlsxt();
SQLTAPI sqlsys();
SQLTAPI sqltec();
SQLTAPI sqltio();
SQLTAPI sqlurs();
SQLTAPI sqlwdc();
SQLTAPI sqlwlo();
SQLTAPI sqlxad();
SQLTAPI sqlxcn();
SQLTAPI sqlxda();
SQLTAPI sqlxdp();
SQLTAPI sqlxdv();
SQLTAPI sqlxer();
SQLTAPI sqlxml();
SQLTAPI sqlxnp();
SQLTAPI sqlxpd();
SQLTAPI sqlxsb();

#endif

#define SQLFINI 1   /* SQL INItialize applications use of the database	    */
#define SQLFDON 2   /* SQL DONe using database				    */
#define SQLFCON 3   /* SQL CONnect to a cursor/database 		    */
#define SQLFDIS 4   /* SQL DISconnect from a cursor/database		    */
#define SQLFCOM 5   /* SQL COMpile a SQL command			    */
#define SQLFEXE 6   /* SQL EXEcute an SQL command			    */
#define SQLFCEX 7   /* SQL Compile and EXecute a SQL command		    */
#define SQLFCMT 8   /* SQL CoMmiT a transaction to the database 	    */
#define SQLFDES 9   /* SQL DEScribe the items of a select statement	    */
#define SQLFGFI 10  /* SQL Get Fetch Information			    */
#define SQLFFBK 11  /* SQL FETch previous row from SELECT		    */
#define SQLFFET 12  /* SQL FETch next row from SELECT			    */
#define SQLFEFB 13  /* SQL Enable Fetch Backwards			    */
#define SQLFPRS 14  /* SQL Position in Result Set			    */
#define SQLFURS 15  /* SQL Undo Result Set				    */
#define SQLFNBV 16  /* SQL get Number of Bind Variables 		    */
#define SQLFBND 17  /* SQL BiNd Data variables.  This function is supercede */
#define SQLFBNN 18  /* SQL BiNd Numerics				    */
#define SQLFBLN 19  /* SQL Bind Long Number				    */
#define SQLFBLD 20  /* SQL Bind Long Data variables			    */
#define SQLFSRS 21  /* SQL Start Restriction Set processing		    */
#define SQLFRRS 22  /* SQL Restart Restriction Set processing		    */
#define SQLFCRS 23  /* SQL Close Restriction Set			    */
#define SQLFDRS 24  /* SQL Drop Restriction Set 			    */
#define SQLFARF 25  /* SQL Apply Roll Forward journal			    */
#define SQLFERF 26  /* SQL End RollForward recovery (no longer supported)   */
#define SQLFSRF 27  /* SQL Start Roll Forward journal			    */
#define SQLFSTO 28  /* SQL STOre a compiled SQL command 		    */
#define SQLFRET 29  /* SQL RETrieve a compiled SQL command		    */
#define SQLFDST 30  /* SQL Drop a STored command			    */
#define SQLFCTY 31  /* SQL get Command TYpe				    */
#define SQLFEPO 32  /* SQL get Error POsition				    */
#define SQLFGNR 33  /* SQL Get Number of Rows				    */
#define SQLFNSI 34  /* SQL get Number of Select Items			    */
#define SQLFRBF 35  /* SQL get Roll Back Flag				    */
#define SQLFRCD 36  /* SQL get Return CoDe				    */
#define SQLFROW 37  /* SQL get number of ROWs				    */
#define SQLFSCN 38  /* SQL Set Cursor Name				    */
#define SQLFSIL 39  /* SQL Set Isolation Level				    */
#define SQLFSLP 40  /* SQL Set Log Parameters				    */
#define SQLFSSB 41  /* SQL Set Select Buffer				    */
#define SQLFSSS 42  /* SQL Set SortSpace				    */
#define SQLFRLO 43  /* SQL Read LOng					    */
#define SQLFWLO 44  /* SQL Write LOng					    */
#define SQLFLSK 45  /* SQL Long SeeK					    */
#define SQLFGLS 46  /* SQL Get Long Size				    */
#define SQLFELO 47  /* SQL End Long Operation				    */
#define SQLFRBK 48  /* SQL RollBacK a transaction from the database	    */
#define SQLFERR 49  /* SQL get ERRor message				    */
#define SQLFCPY 50  /* SQL CoPY 					    */
#define SQLFIDB 51  /* SQL Initialize DataBase				    */
#define SQLFSYS 52  /* SQL SYSTEM					    */
#define SQLFSTA 53  /* SQL STAtistics					    */
#define SQLFR02 54  /* SQL RESERVED					    */
#define SQLFXAD 55  /* SQL eXtra ADd					    */
#define SQLFXCN 56  /* SQL eXtra Character to NUmber			    */
#define SQLFXDA 57  /* SQL eXtra Date Add				    */
#define SQLFXDP 58  /* SQL eXtra convert SQLBASE Date to Picture	    */
#define SQLFXDV 59  /* SQL eXtra DiVide 				    */
#define SQLFXML 60  /* SQL eXtra MuLtiply				    */
#define SQLFXNP 61  /* SQL eXtra convert SQLBASE Numeric to Picture	    */
#define SQLFXPD 62  /* SQL eXtra convert Picture to SQLBASE Date.	    */
#define SQLFXSB 63  /* SQL eXtra SuBtract				    */
#define SQLFINS 64  /* SQL INStall database (no longer supported)	    */
#define SQLFDIN 65  /* SQL DeINstall database (no longer supported)	    */
#define SQLFDIR 66  /* SQL DIRectory of databases			    */
#define SQLFTIO 67  /* SQL TImeOut					    */
#define SQLFFQN 68  /* SQL get Fully Qualified column Name		    */
#define SQLFEXP 69  /* SQL EXexcution Plan				    */
#define SQLFFER 70  /* SQL Full ERror message				    */
#define SQLFBKP 71  /* SQL BacKuP					    */
#define SQLFRDC 72  /* SQL Read Database Chunk				    */
#define SQLFEBK 73  /* SQL End network online BacKup			    */
#define SQLFRES 74  /* SQL REStore from backup				    */
#define SQLFWDC 75  /* SQL Write Database Chunk 			    */
#define SQLFRRD 76  /* SQL Recover Restored Database			    */
#define SQLFERS 77  /* SQL End network ReStore				    */
#define SQLFNRR 78  /* SQL Number of Rows in Result set 		    */
#define SQLFSTR 79  /* SQL STart Restriction mode			    */
#define SQLFSPR 80  /* SQL StoP Restriction mode			    */
#define SQLFCNC 81  /* SQL CoNneCt: the sequel. 			    */
#define SQLFCNR 82  /* SQL Connect with No Recovery			    */
#define SQLFOMS 83  /* SQL set Output Message Size			    */
#define SQLFIMS 84  /* SQL set Input Message Size			    */
#define SQLFSCP 85  /* SQL Set Cache Pages				    */
#define SQLFDSC 86  /* SQL DeSCribe item of SELECT with external type	    */
#define SQLFLAB 87  /* SQL get LABel information			    */
#define SQLFCBV 88  /* SQL Clear Bind Variables 			    */
#define SQLFGET 89  /* SQL GET database parameter			    */
#define SQLFSET 90  /* SQL SET database parameter			    */
#define SQLFTEC 91  /* SQL Translate Error Code 			    */
#define SQLFBDB 92  /* SQL Backup DataBase				    */
#define SQLFBEF 93  /* SQL Bulk Execute Flush				    */
#define SQLFBER 94  /* SQL get Bulk Execute Returned code		    */
#define SQLFBLF 95  /* SQL Backup Log Files				    */
#define SQLFBLK 96  /* SQL set BuLK insert mode 			    */
#define SQLFBSS 97  /* SQL Backup SnapShot				    */
#define SQLFCAN 98  /* SQL CaNceL command				    */
#define SQLFCLF 99  /* SQL Change server activity LogFile		    */
#define SQLFCRE 100 /* SQL CREate database				    */
#define SQLFCRF 101 /* SQL Continue RollForward recovery		    */
#define SQLFCSV 102 /* SQL Connect to SerVer				    */
#define SQLFDBN 103 /* SQL Directory By Name				    */
#define SQLFDED 104 /* SQL DeINstall database				    */
#define SQLFDEL 105 /* SQL DELete database				    */
#define SQLFDID 106 /* SQL DeInstall database and Delete database files     */
#define SQLFDRC 107 /* SQL DiRectory Close				    */
#define SQLFDRO 108 /* SQL DiRectory Open				    */
#define SQLFDRR 109 /* SQL DiRectory Read				    */
#define SQLFDSV 110 /* SQL Disconnect from SerVer			    */
#define SQLFENR 111 /* SQL ENd Rollforward recovery			    */
#define SQLFFGT 112 /* SQL File GeT					    */
#define SQLFFPT 113 /* SQL File Put					    */
#define SQLFGNL 114 /* SQL Get Next Log for rollforward 		    */
#define SQLFGSI 115 /* SQL Get Server Information			    */
#define SQLFIND 116 /* SQL INstall Database				    */
#define SQLFMCL 117 /* SQL reMote CLose server file			    */
#define SQLFMDL 118 /* SQL reMote DeLete file or directory on remote server */
#define SQLFMOP 119 /* SQL reMote OPen file on server			    */
#define SQLFMRD 120 /* SQL reMote ReaD from file on server		    */
#define SQLFMSK 121 /* SQL reMote SeeK into file on server		    */
#define SQLFMWR 122 /* SQL reMote WRite to file on server		    */
#define SQLFRDB 123 /* SQL Restore DataBase				    */
#define SQLFREL 124 /* SQL RELease log					    */
#define SQLFRLF 125 /* SQL Restore Log Files				    */
#define SQLFROF 126 /* SQL ROllForward recovery 			    */
#define SQLFRSS 127 /* SQL Restore SnapShot				    */
#define SQLFSAB 128 /* SQL Server ABort process 			    */
#define SQLFSAP 129 /* SQL Server Abort Process 			    */
#define SQLFSDN 130 /* SQL ShutDowN database				    */
#define SQLFSTM 131 /* SQL Server TerMinate				    */
#define SQLFBBR 132 /* SQL get Bulk Execute Backend error # and message     */
#define SQLFBNA 133 /* SQL BiNd Data variables by name			    */
#define SQLFBNU 134 /* SQL BiNd Numerical bind variable 		    */
#define SQLFGDI 135 /* SQL Get Descriptor info for a given Select column.   */
#define SQLFSXT 136 /* SQL Server eXiT (no longer supported)		    */
#define SQLFXER 137 /* SQL get backend (Extended) error number and Message  */
#define SQLFETX 138 /* SQL get Error message TeXt			    */

#endif
