/* [wam/gui.c wk 30.09.93] GUI interface
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: gui.c,v 1.5 1996/05/05 10:13:48 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <wk/wam.h>
#include <wk/environ.h>
#include "wammain.h"
#include "wamgui.h"
#include "wamdb.h"

/** prototypes of dummy functions **/
static void _wamapi RegisterFormItem( id form, id fItem, int dlgItem, int iType);
static void _wamapi OpenWindow(id form, int subID, void *reserved );
static void _wamapi CloseWindow( id form );
static void _wamapi GetItemText( id form, id fitem, char *buffer, size_t buflen );
static void _wamapi PutItemText( id form, id fitem, char *buffer );
static void _wamapi EnableItem( id form, id fitem, int state );
static void _wamapi SetWindowFocus( id form, id fitem );
static id   _wamapi QueryWindowFocus( id form );
static void _wamapi SetWindowTitle( id form, const char *string );
static void _wamapi InsertListItem( id form, id fitem, int mode, char *string );
static int  _wamapi ShowMessageBox( id form, int msgType, const char *text );
static int  _wamapi GetListSelection( id form, id fitem, int start );
static void _wamapi PutListSelection( id form, id fitem, int index );
static int  _wamapi GetPutCheckState( id form, id fitem, int state );
static int  _wamapi SpinButtonControl( id form, id fitem, int mode, int lower, int upper);
static int  _wamapi WindowVisibility( id form, int mode );
static void _wamapi SetWindowPointer( int nr );
static void _wamapi SetWindowTimer( id form, ulong ms );
static int  _wamapi SetGridValue( id form, id fitem, int x, int y,
			  int datatype, const void *data, size_t datalen );


/*** Addresses of wrapped functions ***/
static const char *(* _wamapi GUIInfo)(int) = NULL;
static void (*_wamapi SetGUIOption)( const char *option, int val );
static void (*_wamapi StartupGui)(void);
static int  (*_wamapi WaitForEvent)(int);
static void (*_wamapi RegisterForm)( id form, int dlg );
static void (*_wamapi AddWindowMenu)( id form,int parent,int pos, char **textArr, int *idArr);

/** Initialization of functions (to dummy) **/
void (*_wamapi WamRegisterFormItem)( id form, id fItem,
				     int dlgItem, int iType)= NULL;
void (*_wamapi WamOpenWindow)(id form, int subId, void *reserved )= NULL;
void (*_wamapi WamCloseWindow)( id form )= NULL;
void (*_wamapi WamGetItemText)( id form, id fitem,
				char *buffer, size_t buflen )= NULL;
void (*_wamapi WamPutItemText)( id form, id fitem, char *buffer )= NULL;
void (*_wamapi WamEnableItem)( id form, id fitem, int state )= NULL;
void (*_wamapi WamSetWindowFocus)( id form, id fitem )= NULL;
id   (*_wamapi WamQueryWindowFocus)( id form )= NULL;
void (*_wamapi WamSetWindowTitle)( id form, const char *string )= NULL;
void (*_wamapi WamInsertListItem)( id form, id fitem,
				   int mode, char *string )= NULL;
int  (*_wamapi WamShowMessageBox)( id form, int msgType,
				   const char *text )= NULL;
int  (*_wamapi WamGetListSelection)( id form, id fitem, int start )= NULL;
void (*_wamapi WamPutListSelection)( id form, id fitem, int index )= NULL;
int  (*_wamapi WamGetPutCheckState)( id form, id fitem, int state )= NULL;
int  (*_wamapi WamSpinButtonControl)( id form, id fitem,
				      int mode, int lower, int upper)= NULL;
int  (*_wamapi WamWindowVisibility)( id form, int mode )= NULL;
void (*_wamapi WamSetWindowPointer)( int nr )= NULL;
void (*_wamapi WamSetWindowTimer)( id form, ulong ms )= NULL;
int  (*_wamapi WamSetGridValue)( id form, id fitem, int x, int y,
		 int datatype, const void *data, size_t datalen ) = NULL;



/**** DLL Load Stuff
 * If this function is called with NULL it checks, wether the GUI is
 * loaded or not (Returns: 0 ::= is loaded)
 */

int _wamapi
WamLoadGUI( const char *moduleName )
{
    struct {
	char *name;
	void **addr;
    } tbl[] = {
	{ "WamDLLInfoGUI"          , (void*)&GUIInfo }, /* must be the first*/
	{ "WamSetGUIOption"        , (void*)&SetGUIOption        },
	{ "WamStartupGui"          , (void*)&StartupGui          },
	{ "WamWaitForEvent"        , (void*)&WaitForEvent        },
	{ "WamRegisterForm"        , (void*)&RegisterForm        },
	{ "WamAddWindowMenu"       , (void*)&AddWindowMenu       },
	{ "WamRegisterFormItem"    , (void*)&WamRegisterFormItem },
	{ "WamOpenWindow"          , (void*)&WamOpenWindow       },
	{ "WamCloseWindow"         , (void*)&WamCloseWindow      },
	{ "WamGetItemText"         , (void*)&WamGetItemText      },
	{ "WamPutItemText"         , (void*)&WamPutItemText      },
	{ "WamEnableItem"          , (void*)&WamEnableItem       },
	{ "WamSetWindowFocus"      , (void*)&WamSetWindowFocus   },
	{ "WamQueryWindowFocus"    , (void*)&WamQueryWindowFocus },
	{ "WamSetWindowTitle"      , (void*)&WamSetWindowTitle   },
	{ "WamInsertListItem"      , (void*)&WamInsertListItem   },
	{ "WamShowMessageBox"      , (void*)&WamShowMessageBox   },
	{ "WamGetListSelection"    , (void*)&WamGetListSelection },
	{ "WamPutListSelection"    , (void*)&WamPutListSelection },
	{ "WamGetPutCheckState"    , (void*)&WamGetPutCheckState },
	{ "WamSpinButtonControl"   , (void*)&WamSpinButtonControl},
	{ "WamWindowVisibility"    , (void*)&WamWindowVisibility },
	{ "WamSetWindowPointer"    , (void*)&WamSetWindowPointer },
	{ "WamSetWindowTimer"      , (void*)&WamSetWindowTimer },
	{ "WamSetGridValue"        , (void*)&WamSetGridValue   },
	{ NULL }
    };
    const char *p, *p2;
    int i, rc;

    if( !moduleName )
	return GUIInfo ? 0 : E_WAM_NOGUI;
    if( GUIInfo ) { /* GUI Module is loaded */
	Error(0,"Warning: A GUI is already loaded");
	return 0;
    }

    if( !(*tbl[0].addr = WKLoadModule(moduleName,tbl[0].name,&rc)) ) {
	Error(0,"Error: LoadModule '%s': rc=%d ", moduleName, rc);
	return E_WAM_GUIFOUND;
    }
    p = GUIInfo(71);
    p2 = WAMGUI_INTERFACE_VERSION;
    if( !p || strcmp( p, p2 ) ) {
	Error(0,"Error: GUI-Version is '%s' but we want '%s' ", p, p2);
	/* fixme: we have no WKUnloadModule(), would be nice here */
	*tbl[0].addr = NULL;
	return E_WAM_GUIINV;
    }

    for(i=1; tbl[i].name; i++ )
	if( !(*tbl[i].addr = WKLoadModule(moduleName,tbl[i].name,&rc)) ) {
	    Error(0,"Error: LoadModule '%s'(%d): rc=%d ", moduleName,i,rc);
	    return E_WAM_GUIINV;
	}

    return 0;
}



static volatile int *attFlags[5];


/****************
 * Diese Funktion kann benutzt werden um ein Signal abzusetzen.
 * Beispielsweise von einem anderen Thread (GUI) um in Folge dann eine
 * Datenbankoperation oder etwas anderes zu unterbrechen.
 * ACHTUNG: Diese Funktion darf nicht warten, da sie ja eventuell
 * vom GUI Thread aufgerufen wird.
 *
 * AttNr := 0 := Global
 *	    1 := Datenbank operation unterbrechen
 *	    2 := Interpreter o.a. beenden.
 *	   11 := User-Flag 1 betatigt.
 *	    .....
 *	   19 := User-Flag 9 betatigt
 *
 * Returns:
 *	  -1 := Attention ist negativ beantwortet
 *	   0 := Attention negativ beantwortet oder keine Reaktion
 *	   1 := Attention ist positiv beantwortet
 */

int WamUserAttention( int attNr )
{
    int i;

    if( attNr < 11 || attNr > 19 )
	WamSQLAttention(0,1);
    if( !attNr )
	attNr = -1;
    for(i=0; i < DIM(attFlags); i++ )
	if( attFlags[i] )
	    *attFlags[i] = attNr;
    return 0;
}


/****************
 * Ein Flag registrieren, welches  bei einer Attention gesetzt wird
 * und z.B. ein Interpreter gelegentlich abfragen kann.
 * Der Eigentuemer dieses Flags muss selbst dafuer sorgen, dass es
 * zurueckgesetzt wird.
 * return : 0 ::= flag wurde regsitriert
 *	   !0 ::= Die Flags Tabelle ist voll.
 */

int WamRegAttentionFlag( volatile int *addr )
{
    int i;
    for(i=0; i < DIM(attFlags); i++ )
	if( !attFlags[i] ) {
	    attFlags[i] = addr;
	    return 0;
	}
    return -1;
}


/**********************************************
 *************** Function Wrappers ************
 **********************************************/

const char * _wamapi
WamDLLInfoGUI( int level )
{
    const char *p;

    if( GUIInfo )   /* GUI Module is loaded */
	return GUIInfo(level);

    switch( level ) {
      case 10:
      case 0:	p = "WAM GUI-Dummy"; break;
      case 1:
      case 11:	p = ""; break;
      case 16:
      case 13:	p = "WAMGUI?"; break;
      default: p = "?";
    }
    return p;
}


void _wamapi
WamSetGUIOption( const char *option, int val )
{
    if( GUIInfo )   /* GUI Module is loaded */
	SetGUIOption( option, val );
}

void _wamapi
WamStartupGui(void)
{
    if( GUIInfo )   /* GUI Module is loaded */
	StartupGui();
}

int _wamapi
WamWaitForEvent(int mode)
{
    if( GUIInfo )   /* GUI Module is loaded */
	return WaitForEvent(mode);
    return E_WAM_NOGUI;
}

void _wamapi
WamRegisterForm( id form, int dlg )
{
    if( GUIInfo )   /* GUI Module is loaded */
	RegisterForm(form,dlg);
}

void _wamapi
WamAddWindowMenu( id form,int parent,int pos, char **textArr, int *idArr)
{
    if( GUIInfo )   /* GUI Module is loaded */
	AddWindowMenu(form,parent,pos,textArr,idArr);
}


/***** DUMMY  Functions *****/

static void _wamapi RegisterFormItem( id form, id fItem, int dlgItem, int iType)
{   return; }
static void _wamapi OpenWindow(id form, int subId, void *reserved )
{   return; }
static void _wamapi CloseWindow( id form )
{   return; }
static void _wamapi GetItemText( id form, id fitem, char *buffer, size_t buflen )
{   return; }
static void _wamapi PutItemText( id form, id fitem, char *buffer )
{   return; }
static void _wamapi EnableItem( id form, id fitem, int state )
{   return; }
static void _wamapi SetWindowFocus( id form, id fitem )
{   return; }
static id   _wamapi QueryWindowFocus( id form )
{   return nil; }
static void _wamapi SetWindowTitle( id form, const char *string )
{   return; }
static void _wamapi InsertListItem( id form, id fitem, int mode, char *string )
{   return; }

static int  _wamapi ShowMessageBox( id form, int msgType, const char *text )
{
    char *p;

    switch( msgType ) {
      case WAM_INFO:	p = "Information";
			break;
      case WAM_WARNING: p = "Warnung";
			break;
      case WAM_ERROR:	p = "Fehler";
			break;
      case WAM_FATAL:	p = "Schwerer Fehler";
			break;
      case WAM_ABORT:	p = "Schwerer Systemfehler";
			break;
      case WAM_QUERY:	p = "Frage";
			break;
      case WAM_VERIFY:	p = "Frage";
			break;
      case WAM_DEBUG:	p = "Debug Info";
			break;
      default: BUG();
    }
    fprintf(stderr,"\n*** %s\n%s\n", p, text );
    fflush(stderr);
    return WAM_CANCEL;
}


static int  _wamapi GetListSelection( id form, id fitem, int start )
{   return 0; }
static void _wamapi PutListSelection( id form, id fitem, int index )
{   return; }
static int  _wamapi GetPutCheckState( id form, id fitem, int state )
{   return 0; }
static int  _wamapi SpinButtonControl( id form, id fitem, int mode, int lower, int upper)
{   return 0; }
static int  _wamapi WindowVisibility( id form, int mode )
{   return 0; }
static void _wamapi SetWindowPointer( int nr )
{   return; }
static void _wamapi SetWindowTimer( id form, ulong ms )
{   return; }
static int _wamapi  SetGridValue( id form, id fitem, int x, int y,
		 int datatype, const void *data, size_t datalen )
{  return 0; }


/****************
 * We need a constructor here
 * Initialize to the dummy function - this is needed, in the case that
 * we do  not want (or have) the GUI.
 */
void
WamSUC_GUI()
{
    if( !WamRegisterFormItem ) {
	WamRegisterFormItem = RegisterFormItem;
	WamOpenWindow = OpenWindow;
	WamCloseWindow = CloseWindow;
	WamGetItemText = GetItemText;
	WamPutItemText = PutItemText;
	WamEnableItem = EnableItem;
	WamSetWindowFocus = SetWindowFocus;
	WamQueryWindowFocus = QueryWindowFocus;
	WamSetWindowTitle = SetWindowTitle;
	WamInsertListItem = InsertListItem;
	WamShowMessageBox = ShowMessageBox;
	WamGetListSelection = GetListSelection;
	WamPutListSelection = PutListSelection;
	WamGetPutCheckState = GetPutCheckState;
	WamSpinButtonControl = SpinButtonControl;
	WamWindowVisibility = WindowVisibility;
	WamSetWindowPointer = SetWindowPointer;
	WamSetWindowTimer   = SetWindowTimer;
	WamSetGridValue     = SetGridValue  ;
    }
}

/**** end of file ****/
