/* [wam/formitem.c wk 7.02.93] Class FormItem
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * Dieses Modul implementiert die Class FormItem
 * Diese Class implementiert einzelne GUI Windows Items
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: formitem.c,v 1.7 1996/09/25 16:20:53 wk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>
#include "wammain.h"
#include "wamgui.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/
DCLSYM sym_getInternalItemType;

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(FormItem)

BEGIN_DCLPRIVATEPART
    id	     form;	  /* form of this item */
    symbol_t name;	  /* name of this item */
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/


/**************************************************
 ******************  Methods  *********************
 **************************************************/


/****************
 * Ein neues FormItem erzeugen
 * Returns: created formitem
 */

DCLFOBJFNC( newItem )
{
    DCL_arg(id, form);		/* form of formitem */
    DCL_arg(symbol_t, name);	/* name of formitem */
    DCL_arg(int, ri );		/* resourceId of formItem */
    id obj, var; /* created form object and its variable ptr */

    obj = msgSuper( sym_new );
    SET_var(obj);
    var->form = form;
    var->name = name;
    WamRegisterFormItem( form, obj, ri, i_msg(obj, sym_getInternalItemType) );
    msg2( form, sym_addItem, obj, name );
    return obj;
}

/****************
 * Change the behaviour of new created entry fields to insertMode (default)
 * There is also an instance method to control this on an item by item basis
 * This is only a dummy here, semantics are onyl in fitext.c
 */
DCLFOBJFNC( insertMode )
{
    return self;
}

/****************
 * Change the behaviour of new created entry fields to overtypeMode
 * There is also an instance method to control this on an item by item basis
 * This is only a dummy here, semantics are onyl in fitext.c
 */
DCLFOBJFNC( overtypeMode )
{
    return self;
}


DCLOBJFNC_i( getInternalItemType )
{
    return 0; /* undefined */
}


DCLOBJFNC( form )  /* return form of formitem */
{
    DCL_var();
    return var->form;
}

DCLOBJFNC_s( name )  /* return name of formitem */
{
    DCL_var();
    return var->name;
}


DCLOBJFNC( command )	/* command Message send from formWindow */
{
    DCL_var();
    puts("Item received a command - forwarding to form");
    msg1(var->form, sym_command, self );
    return self;
}


DCLOBJFNC( event )
{
    return self;  /* may be subclassed */
}

DCLOBJFNC( gotFocus )
{
    return self;       /* may be subclassed */
}

DCLOBJFNC( lostFocus )
{
    return self;      /* may be subclassed */
}




DCLOBJFNC( get ) /* get value as object */
{
    return msg(self, sym_subclassResponsibility);
}

DCLOBJFNC( put )
{
    return msg(self, sym_subclassResponsibility);
}



DCLOBJFNC( getValue ) /* get value direct */
{
    return msg(self, sym_subclassResponsibility);
}

DCLOBJFNC( putValue ) /* put value direct */
{
    return msg(self, sym_subclassResponsibility);
}


DCLOBJFNC( clear ) /* clear value direct */
{
    return msg(self, sym_subclassResponsibility);
}

/****************
 * this is only a stup. the message can be used to check wether the
 * user changed the value of an item. An item Object class should
 * track this and reset its internal flag, whenever a new value is set
 * or clear is called.
 */
DCLOBJFNC( modified )
{
    return False;
}

/****************
 * reset the internal modify flag, returns old flag.
 */
DCLOBJFNC( resetModify )
{
    return False;
}

DCLOBJFNC( enable )
{
    DCL_var();
    WamEnableItem( var->form, self, 1 );
    return self;
}

DCLOBJFNC( disable)
{
    DCL_var();
    WamEnableItem( var->form, self, 0 );
    return self;
}


DCLOBJFNC( readWrite )
{
    DCL_var();
    WamEnableItem( var->form, self, 3 );
    return self;
}

DCLOBJFNC( readOnly )
{
    DCL_var();
    WamEnableItem( var->form, self, 2 );
    return self;
}

DCLOBJFNC( insertMode )
{
    DCL_var();
    WamEnableItem( var->form, self, 4 );
    return self;
}

DCLOBJFNC( overtypeMode )
{
    DCL_var();
    WamEnableItem( var->form, self, 5 );
    return self;
}



DCLOBJFNC( renewText )
{
    return self;
}


DCLOBJFNC( valueChanged )
{
    DCL_var();
    msg2(var->form, sym_notify, self, sym_ItemValueChange );
    return self;
}


DCLOBJFNC( openInitialization )
{
    return self;
}


/****************
 * This message get send directly from the GUI!
 */
DCLOBJFNC( itemModified )
{
    return self;
}



/****************
 * Eine Funktion registrieren, die nache dem Erhalt eines Wertes vom GUI
 * aufgerufen wird.
 * Ein Formitem welches diese Verfahren untersttzt, muss diese Methode
 * subclassen.
 * Die Funktion ist folgendermaen definiert:
 *    const char *function( id formitem, char *buffer, size_t maxbuflen )
 * Das formitem kann als Key fr Tabellen benutzt werden.
 * Der buffer enthlt einen normalen C String, dessen Aufbau
 * vom Typ des formitems abhngt.
 * Mit maxbuflen ist die gesamte Lnge des Buffers angegeben.
 * Die Funktion kann den Buffer beliebig ndern, oder aber einen anderen
 * String als Return-Wert zurckgeben.
 * Der Returnwert ist NULL oder eine Beschreibung des Fehler.
 * Eventuell wird das System noch erweitert, so da ein ReturnString
 * der mit '#' beginnt z.B. einen Fehlercode bermittelt.
 */
DCLOBJFNC( setInputFilterFunction )
{
    return self;
}


/****************
 * Eine Funktion registrieren, die direkt vor der Ausgabe eines Wertes
 * auf das GUI aufgerufen wird. Dies Funktion kann den bergebenen String
 * ndern oder einen neuen String zurckgeben.
 * Der Ausfbaue der Funktion ist unter "setInputFilterFunction"
 * beschrieben.
 * Ein Formitem welches diese Verfahren untersttzt, muss diese Methode
 * subclassen.
 */
DCLOBJFNC( setOutputFilterFunction )
{
    return self;
}


DCLOBJFNC( linkItemToItem )
{
    DCL_arg(id,fitem);
    return self;
}


void WamSUC_FormItem()
{
    id self = FormItem;
    CREATECLASS("FormItem");
    WamSubclassClass( sym_Object, self );

    DCLFMTHD( newItem );
    DCLFMTHD( insertMode);
    DCLFMTHD( overtypeMode);

    DCLMTHD( getInternalItemType );
    DCLMTHD( form );
    DCLMTHD( name );
    DCLMTHD( command );
    DCLMTHD( event );
    DCLMTHD( gotFocus );
    DCLMTHD( lostFocus );
    DCLMTHD( get );
    DCLMTHD( put );
    DCLMTHD( getValue );
    DCLMTHD( putValue );
    DCLMTHD( clear );
    DCLMTHD( modified );
    DCLMTHD( resetModify );
    DCLMTHD( enable   );
    DCLMTHD( disable  );
    DCLMTHD( readWrite );
    DCLMTHD( readOnly  );
    DCLMTHD( insertMode );
    DCLMTHD( overtypeMode );
    DCLMTHD( openInitialization );
    DCLMTHD( renewText		);
    DCLMTHD( valueChanged	);
    DCLMTHD( itemModified	);
    DCLMTHD( setInputFilterFunction );
    DCLMTHD( setOutputFilterFunction );
    DCLMTHD( linkItemToItem );

}


/**** end of file ****/
