/* [wam/form.c wk 31.01.93] Class Form
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * Dieses Modul implementiert die Class Form.
 * Diese Class implementiert einzelne GUI Windows ...
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: form.c,v 1.11 1996/09/25 16:20:53 wk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>
#include "wammain.h"
#include "wamgui.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/
static symbol_t sym_focusChange;

DCLSYM sym_notification;
/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(Form)

BEGIN_DCLPRIVATEPART
    id	 view;	    /* associated view */
    id	 itemDict;
    int  isOpen;    /* form is open,d.h. openInitialization wurde aufgerufen*/
    int  locked;    /* form is locked, no input to window allowed */
    symbol_t focusItemName;
    id	     focusItem;
    int  subId;     /* for save/restore windowPos in GUI */
    int  in_timer_tick;
END_DCLPRIVATEPART

    /* gegen Rekursion: lostFocus,setFocus... */
    /* single threaded is enough */
static volatile int setFocusSentinel;

/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

static void ItemDoesNotExist( symbol_t name );

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

static void ItemDoesNotExist( symbol_t name )
{
    Error(0,"Error: Item '%s' does not exist", name ? symName(name): "[none]");
}

/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLFOBJFNC( new )
{
    id obj; /* created object */
    id var;

    obj = msgSuper( sym_new );
    SET_var(obj);
    var->itemDict = newObj(Dictionary);
    msg(obj, sym_initialize );
    return obj;
}


DCLFOBJFNC( terminate )
{
    WamCloseWindow( 0 );
    return nil;
}


DCLOBJFNC( free )
{
    DCL_var();

    msg(var->itemDict, sym_deepFree );
    return msgSuper( sym_free );
}





DCLOBJFNC( initialize )
{
    return msg(self, sym_subclassResponsibility );
}



/****************
 * Add a formItem to my list of formitems
 * Der Name wird doppelt gehalten da er fuer schnellen zugriff
 * auf das item als key eines dictionary benutzt wird.
 */

DCLOBJFNC( addItem )
{
    DCL_arg(id,      fitem );
    DCL_arg(symbol_t,iName );
    DCL_var();

    msg2( var->itemDict, sym_atPut, iName, fitem );

    return self;
}




DCLOBJFNC(setSubId)
{
    DCL_arg(int, subId);
    DCL_var();

    var->subId = subId;
    return self;
}



/****************
 * Actually open the Window
 */

DCLOBJFNC( open )
{
    id *arr;
    ulong i,n;
    DCL_var();

    WamOpenWindow( self, var->subId, NULL );
    msg(self, sym_openInitialization );
    /* jetzt noch fuer weitere Initialisierung eine Msg an alle Items senden */
    arr = a_msg(var->itemDict, sel(valuesAsCArray) );
    n = (ulong)arr[0];
    for(i=0; i < n; i++ )
	if( arr[i+1] )
	    msg(arr[i+1], sym_openInitialization );
    free(arr);
    return self;
}


DCLOBJFNC( openInitialization )
{
    return self;
}

/****************
 * Folgendes wird von der View gesendet, um ihr mitzuteilen, dass
 * alle Open-Sachen erledigt sind und das Window jetzt sichtbar gemacht werden
 * kann. Daraufhin wird die GUI postOpenInitialization senden
 */

DCLOBJFNC( finishInitialization )
{
    DCL_var();
    if( !var->isOpen ) {
	WamWindowVisibility( self, -111 );
	var->isOpen++;
    }
    return self;
}




/****************
 * Wird von GUI gesendet
 */

DCLOBJFNC( postOpenInitialization )
{
    DCL_var();

    msg(var->view, sym_postOpenInitialization );
    return self;
}


/****************
 * Wird von GUI gesendet
 */

DCLOBJFNC( closeRequested )
{
    DCL_var();

    msg(var->view, sym_closeRequested );
    return self;
}


/****************
 * Actually close the form
 */

DCLOBJFNC( close )
{
    WamCloseWindow( self );
    return self;
}


/****************
 * Setzt die View der Form.
 */

DCLOBJFNC( setView )
{
    DCL_arg(id,view);
    DCL_var();

    var->view = view;
    return self;
}


DCLOBJFNC( view )
{
    DCL_var();
    return var->view;
}



/****************
 * Bestimmen, welches Item den Focus hat, soll bestimmt werden,
 * welche Form den Focus hat, so ist eine entsprechende
 * FactoryMethode zu implementieren
 * Returns: nil oder FormItemObject
 */

DCLOBJFNC( focus )
{
    return WamQueryWindowFocus(self);
}



/****************
 * Den Titel der Form setzen
 */

DCLOBJFNC( setTitle )
{
    DCL_arg(const char *, p);	/* title String */

    WamSetWindowTitle( self, p );
    return self;
}


/****************
 * Den Focus auf diese Form setzen
 */

DCLOBJFNC( setFocus )
{
    setFocusSentinel++;
    WamSetWindowFocus( self, 0 );
    setFocusSentinel--;
    return self;
}


/****************
 * Den Focus auf ein Item setzen
 */

DCLOBJFNC( setFocusTo )
{
    DCL_arg(symbol_t, name);	/* item name */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }
    if( !var->focusItem && !var->focusItemName) {
	/* inital setting of focus item */
	var->focusItem = fitem;
	var->focusItemName = name;
    }
    setFocusSentinel++;
    WamSetWindowFocus( self, fitem );
    setFocusSentinel--;

    return self;
}



DCLOBJFNC( enable )
{
    DCL_arg(symbol_t, name);	/* item name */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg(fitem, sym_enable );
}

DCLOBJFNC( disable )
{
    DCL_arg(symbol_t, name);	/* item name */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg(fitem, sym_disable );
}

DCLOBJFNC( readWrite )
{
    DCL_arg(symbol_t, name);	/* item name */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg(fitem, sym_readWrite );
}

DCLOBJFNC( readOnly )
{
    DCL_arg(symbol_t, name);	/* item name */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg(fitem, sym_readOnly );
}

DCLOBJFNC( insertMode )
{
    DCL_arg(symbol_t, name);	/* item name */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg(fitem, sym_insertMode );
}

DCLOBJFNC( overtypeMode )
{
    DCL_arg(symbol_t, name);	/* item name */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg(fitem, sym_overtypeMode );
}


DCLOBJFNC( hideWindow )
{
    WamWindowVisibility( self, -2 );
    return self;
}

DCLOBJFNC( showWindow )
{
    WamWindowVisibility( self, -1 );
    return self;
}


DCLOBJFNC( restore )
{
    WamWindowVisibility( self, 1 );
    return self;
}

DCLOBJFNC( restoreIfNotMaximized )
{
    WamWindowVisibility( self, 11 );
    return self;
}

DCLOBJFNC( minimize )
{
    WamWindowVisibility( self, 2 );
    return self;
}

DCLOBJFNC( maximize )
{
    WamWindowVisibility( self, 3 );
    return self;
}






DCLOBJFNC( command )	/* command Message send from window */
{
    DCL_arg(id, item);
    symbol_t n;
    DCL_var();

    if( !item )
	printf("command received for form\n");
    else {
	/* inform the formItem about the event */
	msg( item, sym_event );
	/* get name of item */
	n = s_msg( item, sym_name );
	/*printf("command received for item '%s'\n", symName(n));*/
	/* and pass it to the view */
	msg1(var->view, sym_event, n );
    }
    return self;
}



DCLOBJFNC( gotFocus )	 /* Message sent from window */
{
    DCL_arg(id, item);
    symbol_t n;
    DCL_var();

    if( !setFocusSentinel ) {	/* not inside setFocus */
	if( !item ) /* form got the focus */
	    msg1(var->view, sym_gotFocus, 0 );
	else {
	    if( var->focusItem != item ) {
		msg( item, sym_lostFocus );
		var->focusItem = item;
	    }
	    msg( item, sym_gotFocus );
	    /* and tell the view */
	    n = s_msg( item, sym_name );
	    msg1(var->view, sym_gotFocus, n );
	    /* inform view about focuschange */
	    if( var->focusItemName != n ) { /* real change */
		msg2(var->view, sym_focusChange, var->focusItemName, n );
		var->focusItemName = n;
	    }
	}
    }
    return self;
}


DCLOBJFNC( lostFocus )	  /* Message sent from window */
{
    DCL_arg(id, item);
    symbol_t n;
    DCL_var();

    if( !setFocusSentinel ) {	/* not inside setFocus */
	if( !item ) /* form lost the focus */
	    msg1(var->view, sym_lostFocus, 0 );
	else {
	    /* inform the formItem about the focusChange */
	    msg( item, sym_lostFocus );
	    /* and tell the view */
	    n = s_msg( item, sym_name );
	    msg1(var->view, sym_lostFocus, n );
	}
    }
    return self;
}






DCLOBJFNC( item )	/* get item object */
{
    DCL_arg(symbol_t, name);	/* name of item */
    DCL_var();
    return msg1(var->itemDict, sym_at, name );
}


DCLOBJFNC( getValue )
{
    DCL_arg(symbol_t, name);	/* name of item */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg(fitem, sym_getValue );
}


DCLOBJFNC( putValue )
{
    DCL_arg(symbol_t, name);	    /* item name */
    DCL_arg(const void *, p); /* ptr to value */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg1(fitem, sym_putValue, p );
}

DCLOBJFNC( clearValue )
{
    DCL_arg(symbol_t, name);	    /* item name */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg(fitem, sym_clearValue );
}

DCLOBJFNC( modified )
{
    DCL_arg(symbol_t, name);	    /* item name */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg(fitem, sym_modified );
}

DCLOBJFNC( resetModify )
{
    DCL_arg(symbol_t, name);	    /* item name */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg(fitem, sym_resetModify );
}


DCLOBJFNC_s( getSymbol )
{
    DCL_arg(symbol_t, name);	/* name of item */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return 0;
    }

    return s_msg(fitem, sym_getSymbol );
}


DCLOBJFNC( putSymbol )
{
    DCL_arg(symbol_t, name);	    /* item name */
    DCL_arg(symbol_t, sym);
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg1(fitem, sym_putSymbol, sym );
}

DCLOBJFNC( putLabel )
{
    DCL_arg(symbol_t, name);	    /* item name */
    DCL_arg(id, val);
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg1(fitem, sym_putLabel, val );
}


DCLOBJFNC( get )
{
    DCL_arg(symbol_t, name);	/* name of item */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg(fitem, sym_get );
}

DCLOBJFNC( getCheckedItem )
{
    DCL_arg(symbol_t, name);	/* name of item */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg(fitem, sym_getCheckedItem );
}


DCLOBJFNC( put )
{
    DCL_arg(symbol_t, name);	    /* item name */
    DCL_arg(id, val);		    /* new value for item */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg1(fitem, sym_put, val );
}


DCLOBJFNC( setSelection )
{
    DCL_arg(symbol_t,name);
    DCL_arg(int,sel);
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }

    return msg1(fitem, sym_setSelection, sel );
}


DCLOBJFNC( linkItemToItem )
{
    DCL_arg(symbol_t,name);
    DCL_arg(symbol_t,other);
    id fitem, fother;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return nil;
    }
    fother = msg1(var->itemDict, sym_at, other );
    if( !fother ) {
	ItemDoesNotExist(other);
	return nil;
    }

    return msg1(fitem, sym_linkItemToItem, fother );
}


/****************
 * Group all the items from the given list, the list is terminated by an nil.
 * The list is a list of item names.
 */
DCLOBJFNC( groupItems )
{
    id array, name, fitem, fother;
    unsigned i, n;
    DCL_var();

    array = newObj(Array);
    for(n=0; name = va_arg(arg_ptr,symbol_t); ) {
	fitem = msg1(var->itemDict, sym_at, name );
	if( !fitem )
	    ItemDoesNotExist(name);
	else {
	    msg1(array, sym_add, fitem);
	    n++;
	}
    }
    if( n > 1 ) {
	for(i=0; i < n; i++ ) {
	    if((fitem=msg1(array, sym_atIndex,i))&& msg(array, sym_enumOpen)) {
		while( fother = msg(array, sym_enumGet) )
		    if( fother != fitem )
			msg1(fitem, sym_linkItemToItem, fother);
	    }
	}
    }
    freeObj(array);
    return self;
}


DCLOBJFNC_i( messageBox )
{
    DCL_arg(int, t);		/* type of message WAm_INFO etc.. */
    DCL_arg(const char*, s);

    return WamShowMessageBox( self, t, s );
}


DCLFOBJFNC_i( messageBox )  /* nochmal fuer die Factory */
{
    DCL_arg(int, t);		/* type of message WAm_INFO etc.. */
    DCL_arg(const char*, s);

    return WamShowMessageBox( self, t, s );
}



DCLOBJFNC_i( isOpen )
{
    DCL_var();
    return var->isOpen;
}


DCLOBJFNC_i( isLocked )
{
    DCL_var();
    return var->locked;
}



/****************
 * lock is the same as disable Window
 */

DCLOBJFNC( lockWindow )
{
    DCL_var();

    if( !var->locked ) {
	WamWindowVisibility( self, 5 );
	var->locked = 1;
    }
    return self;
}


DCLOBJFNC( unlockWindow )
{
    DCL_var();

    if( var->locked ) {
	WamWindowVisibility( self, 6 );
	var->locked = 0;
    }
    return self;
}


DCLOBJFNC( setSelection_to )
{
/*  DCL_arg(symbol_t,item);
    DCL_arg(int,sel);
    DCL_var(); */

    return self;
}


DCLOBJFNC_i( getSelection )
{
    DCL_arg(symbol_t, name);	    /* item name */
    id fitem;
    DCL_var();

    fitem = msg1(var->itemDict, sym_at, name );
    if( !fitem ) {
	ItemDoesNotExist(name);
	return 0;
    }

    return i_msg(fitem, sym_getSelection );
}


/****************
 * Wir leiten jedes notify direkt zu notification der View um.
 */
DCLOBJFNC( notify )
{
    DCL_arg(id, from);
    DCL_arg(symbol_t, reason);
    DCL_var();
    return var->view ? msg2( var->view, sym_notification, from, reason ):self;
}



/****************
 * Start or restart a window timer
 */
DCLOBJFNC( startTimer )
{
    DCL_arg(ulong, milliseconds);   /* title String */

    WamSetWindowTimer( self, milliseconds  );
    return self;
}

/****************
 * Stop a timer
 */
DCLOBJFNC( stopTimer )
{
    WamSetWindowTimer( self, -1L  );
    return self;
}


DCLOBJFNC( timerTick )	  /* message send from window */
{
    DCL_var();

    if( !var->in_timer_tick ) {
	var->in_timer_tick = 1;
	msg2(var->view, sym_notify, self, sym_TimerTick );
	var->in_timer_tick = 0;
    }

    return self;
}



void WamSUC_Form()
{
    id self = Form;
    CREATECLASS("Form");
    WamSubclassClass( sym_Object, self );
    WamSetAtticLimit( self, 20 );

    DCLFMTHD( new );
    DCLFMTHD( terminate );

    DCLMTHD( free	);
    DCLMTHD( initialize );
    DCLMTHD( addItem	);
    DCLMTHD( setSubId );
    DCLMTHD( open );
    DCLMTHD( openInitialization );
    DCLMTHD( finishInitialization );
    DCLMTHD( postOpenInitialization );
    DCLMTHD( closeRequested );
    DCLMTHD( close );
    DCLMTHD( setView );
    DCLMTHD( view );
    DCLMTHD( command );
    DCLMTHD( focus   );
    DCLMTHD( setFocus);
    DCLMTHD( setFocusTo);
    DCLMTHD( gotFocus );
    DCLMTHD( lostFocus );
    DCLMTHD( setTitle);
    DCLMTHD( enable  );
    DCLMTHD( disable );
    DCLMTHD( readWrite );
    DCLMTHD( readOnly  );
    DCLMTHD( insertMode);
    DCLMTHD( overtypeMode);
    DCLMTHD( hideWindow );
    DCLMTHD( showWindow );
    DCLMTHD( restore );
    DCLMTHD( restoreIfNotMaximized );
    DCLMTHD( minimize );
    DCLMTHD( maximize );
    DCLMTHD( item    );
    DCLMTHD( getValue );
    DCLMTHD( putValue );
    DCLMTHD( clearValue );
    DCLMTHD( modified );
    DCLMTHD( resetModify );
    DCLMTHD( getSymbol);
    DCLMTHD( putSymbol);
    DCLMTHD( putLabel );
    DCLMTHD( get      );
    DCLMTHD( getCheckedItem );
    DCLMTHD( put      );
    DCLMTHD( messageBox );
    DCLFMTHD( messageBox );   /* auch als Factory Method notwendig */

    DCLMTHD( setSelection );


    DCLMTHD( isOpen );
    DCLMTHD( isLocked );
    DCLMTHD( lockWindow );
    DCLMTHD( unlockWindow );
    DCLMTHD( setSelection_to );
    DCLMTHD( getSelection );
    DCLMTHD( linkItemToItem );
    DCLMTHD( groupItems );
    DCLMTHD( notify );
    DCLMTHD( startTimer );
    DCLMTHD( stopTimer );
    DCLMTHD( timerTick	);

    sym_focusChange = sym(focusChange);
}


/**** end of file ****/
