/* [wam/float.c wk 25.02.93] Class Float
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 *
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: float.c,v 1.10 1996/01/10 19:01:45 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(Float)

BEGIN_DCLPRIVATEPART
    double val;
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLFOBJFNC( create )
{
    DCL_arg(double, val);
    id obj;
    id	var;

    obj = msgSuper( sym_new );
    SET_var(obj);
    var->val = val;
    return obj;
}


DCLOBJFNC( copy )
{
    id obj;
    double val;
    DCL_var();

    obj = msg(factory, sym_new );
    val = var->val;
    SET_var(obj);
    var->val = val;
    return obj;
}

DCLOBJFNC( asNumber )
{
    id obj;
    double val;
    DCL_var();

    obj = msg(factory, sym_new );
    val = var->val;
    SET_var(obj);
    var->val = val;
    return obj;
}

/****************
 * Erzeugt eine neues Float Objekt mit dem negativen Wert von self.
 */

DCLOBJFNC( negated )
{
    id obj;
    double val;
    DCL_var();

    obj = msg(factory, sym_new );
    val = var->val;
    SET_var(obj);
    var->val = -val;
    return obj;
}




DCLOBJFNC_v( getValue )  /* gibt Ptr auf den Wert zurueck */
{
    DCL_var();
    return &var->val;
}

DCLOBJFNC( putValue )
{
    DCL_arg(double, val);
    DCL_var();

    var->val = val;
    return self;
}


DCLOBJFNC_p( allocAsDBString )
{
    char buf[30];
    int n;
    DCL_var();

    if( !var->val )
	strcpy(buf, "0");
    else {
	n = sprintf(buf, "%f", var->val );
	while( n > 1 ) { /* strip trailing zeoes */
	    if( buf[--n] == '0' )
		buf[n] = 0;
	    else if( buf[n] == '.' ) {
		buf[n] = 0;
		break;
	    }
	    else
		break;
	}
    }
    return xstrdup(buf);
}


DCLOBJFNC(asString)
{
    char buf[30];
    int n;
    DCL_var();

    if( !var->val )
	strcpy(buf, "0");
    else {
	n = sprintf(buf, "%f", var->val );
	while( n > 1 ) { /* strip trailing zeoes */
	    if( buf[--n] == '0' )
		buf[n] = 0;
	    else if( buf[n] == '.' ) {
		buf[n] = 0;
		break;
	    }
	    else
		break;
	}
    }
    return newString(buf);
}


DCLOBJFNC( asCSVString )
{
    char buf[30], *p;
    int n;
    DCL_var();

    if( !var->val )
	strcpy(buf, "0");
    else {
	n = sprintf(buf, "%f", var->val );
	while( n > 1 ) { /* strip trailing zeoes */
	    if( buf[--n] == '0' )
		buf[n] = 0;
	    else if( buf[n] == '.' ) {
		buf[n] = 0;
		break;
	    }
	    else
		break;
	}
	for(p=buf; *p; p++ )
	    if( *p=='.' )
		*p=',';
    }
    return newString(buf);
}


DCLOBJFNC_i( isEqual )
{
    DCL_arg(id, other );    /* sollte float oder integer sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val == var2->val;
    }
    else if( WamIsKindOf( other, factory ) )
	return var->val == getFloat(other);
    else if( WamIsKindOf( other, Integer ) )
	return var->val == getInteger(other);
    else
	return 0;   /* from other class - cannot be equal */
}

DCLOBJFNC_i( isGT )
{
    DCL_arg(id, other );    /* sollte float oder integer sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val > var2->val;
    }
    else if( WamIsKindOf( other, factory ) )
	return var->val > getFloat(other);
    else if( WamIsKindOf( other, Integer ) )
	return var->val > getInteger(other);
    else
	return 0;   /* from other class - cannot be equal */
}

DCLOBJFNC_i( isGE )
{
    DCL_arg(id, other );    /* sollte float oder integer sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val >= var2->val;
    }
    else if( WamIsKindOf( other, factory ) )
	return var->val >= getFloat(other);
    else if( WamIsKindOf( other, Integer ) )
	return var->val >= getInteger(other);
    else
	return 0;   /* from other class - cannot be equal */
}

DCLOBJFNC_i( isLT )
{
    DCL_arg(id, other );    /* sollte float oder integer sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val < var2->val;
    }
    else if( WamIsKindOf( other, factory ) )
	return var->val < getFloat(other);
    else if( WamIsKindOf( other, Integer ) )
	return var->val < getInteger(other);
    else
	return 0;   /* from other class - cannot be equal */
}

DCLOBJFNC_i( isLE )
{
    DCL_arg(id, other );    /* sollte float oder integer sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val <= var2->val;
    }
    else if( WamIsKindOf( other, factory ) )
	return var->val <= getFloat(other);
    else if( WamIsKindOf( other, Integer ) )
	return var->val <= getInteger(other);
    else
	return 0;   /* from other class - cannot be equal */
}



DCLOBJFNC_i( isEmptyOrNil )
{
    DCL_var();
    return var->val == 0;
}



/****************
 *  Den Wert um eins erhoehen
 */

DCLOBJFNC(inc)
{
    DCL_var();
    var->val++;
    return self;
}

/****************
 *  Den Wert um eins erniedrigen
 */

DCLOBJFNC(dec)
{
    DCL_var();
    var->val--;
    return self;
}

DCLOBJFNC(isTrue)
{
    DCL_var();
    return var->val ? True : False;
}


void WamSUC_Float()
{
    id self = Float;
    CREATECLASS("Float");
    WamSubclassClass( sym_Object, self );
    WamSetAtticLimit(self, 500);

    DCLFMTHD( create );

    DCLMTHD( copy );
    DCLMTHD( asNumber );
    DCLMTHD( negated );
    DCLMTHD( getValue );
    DCLMTHD( putValue );
    DCLMTHD( allocAsDBString );
    DCLMTHD( asString );
    DCLMTHD( asCSVString );
    DCLMTHD( isEqual	  );
    DCLMTHD( isGT );
    DCLMTHD( isGE );
    DCLMTHD( isLT );
    DCLMTHD( isLE );
    DCLMTHD( isEmptyOrNil );
    DCLMTHD( inc );
    DCLMTHD( dec );
    DCLMTHD( isTrue );

}


/**** end of file ****/
