/* [wam/fivalset.c wk 03.05.96] Class FormItemValueSet
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: fivalset.c,v 1.1 1996/05/05 10:13:46 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>
#include "wammain.h"
#include "wamgui.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(FormItemValueSet)

BEGIN_DCLPRIVATEPART
    int is_open;
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/


/**************************************************
 ******************  Methods  *********************
 **************************************************/


DCLOBJFNC( putStringAtXY )
{
    DCL_arg(const char *, string);
    DCL_arg(int, x);
    DCL_arg(int, y);

    WamSetGridValue( msg(self, sym_form), self,
		     x, y, 0 /* datatype*/,
		     string, 0 );
    return self;
}


DCLOBJFNC( setSelectionToXY )
{
    DCL_arg(int, x);
    DCL_arg(int, y);
    int index;

    index = ((y << 16)&0xffff0000) | (x & 0xffff);
    WamPutListSelection( msg(self, sym_form), self, index );
    return self;
}


DCLOBJFNC( clearValue )
{
    /*DCL_var();*/
    /* fixme: */
    return self;
}

DCLOBJFNC_i( getInternalItemType )
{
    return ITEMTYPE_VALUESET;
}

void WamSUC_FormItemValueSet()
{
    id self = FormItemValueSet;
    CREATECLASS("FormItemValueSet");
    WamSubclassClass( sym_FormItemKey, self );

    DCLMTHD( putStringAtXY );
    DCLMTHD( setSelectionToXY );
    DCLMTHD( clearValue );
    DCLMTHD( getInternalItemType );
}


/**** end of file ****/
