/* [wam/fitoggle.c wk 7.02.93] Class FormItemToggle
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * Ein ToggleItem ist im einfachsten Fall eine CheckBox
 * kann aber auch eine Reihe von Radiobuttons oder eine
 * DropDownList sein.
 * Voreingestellt ist CheckBox dies gibt dann
 * die Werte sym_True oder sym_False zurck.
 * DropDownList o.. kann mit Labels und Values versehen
 * werden, wobei die Labels immer Strings sind und die
 * Values immer symbole sind.
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: fitoggle.c,v 1.7 1996/01/25 20:17:43 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>
#include "wammain.h"
#include "wamgui.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(FormItemToggle)

BEGIN_DCLPRIVATEPART
    int state;		/* check state of menueitem or checkbox */
    size_t entries;	/* number of entries */
    symbol_t *values;	/* NULL bei CheckBox, ansonsten symbolListe */
    char **labels;
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/


/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLOBJFNC( free )
{
    int i;
    DCL_var();

    if( var->labels ) {
	for(i=0; i < var->entries; i++ )
	    free(var->labels[i]);
	free(var->labels);
    }
    free(var->values);
    return msgSuper( sym_free );
}



/****************
 * Der Aufruf dieser Funktion setzt die Lables und (falls noch nicht
 * vorhanden) auch die Values fuer eine Liste. Als Argument wird ein
 * Array von C-Strings erwartet, deren nachletzter Eintrag NULL sein muss
 * diese Labels sollten mit eventuell bereits gesetzten Values (z.Z.
 * ni#och nicht implemetiert) uebereinstimmem.
 */

DCLOBJFNC( setLabels )
{
    DCL_arg(char **,labelList);
    char *p;
    int n, i;
    DCL_var();

    for(n=0; labelList[n]; n++ )
	;
    var->entries = n;
    var->values = xcalloc(n, sizeof *var->values );
    var->labels = xcalloc(n, sizeof *var->labels );
    for(i=0; p = labelList[i]; i++ ) {
	var->values[i] = *p ? WamCreateSymbol( p ) : 0 ;
	var->labels[i] = xstrdup( p );
    }
    return self;
}



/****************
 * Window ist jetzt offen: Labels koennen gesetzt werden.
 */

DCLOBJFNC( openInitialization )
{
    id form;
    char *p;
    int i;
    DCL_var();

    if( var->labels ) {
	form = msg(self, sym_form);
	WamInsertListItem( form, self, -1, NULL );
	for(i=0; i < var->entries; i++ ) {
	    p = var->labels[i];
	    WamInsertListItem( form, self, -2, p);
	    free( p );
	}
	FREE(var->labels);
    }
    return self;
}



DCLOBJFNC_s( getSymbol )
{
    int index;
    symbol_t sym;
    DCL_var();

    sym = 0;
    if( !var->values ) { /* CheckBox or checked menueitem */
	sym = var->state ? sym_True : sym_False;
    }
    else if( !var->entries )
	Fatal("Labels not set for ListItem");
    else {
	index = WamGetListSelection( msg(self, sym_form), self, -1 );
	if( index == -1 )
	    ;
	else if( index < 0 || index >= var->entries )
	    Fatal("Index %d in Selection is out of range 0..%u",
		    index, var->entries-1 );
	else {
	    sym = var->values[index];
	}
    }
    return sym;
}


DCLOBJFNC( putSymbol )
{
    DCL_arg(symbol_t, sym);
    int index,i;
    DCL_var();

    if( !var->values ) { /* CheckBox or check menueitem */
	i =  sym == sym_True;
	if( !var->state != !i ) {
	    var->state = i;
	    WamGetPutCheckState( msg(self, sym_form), self, var->state? 1:0 );
	}
    }
    else {
	index = -1; /* default and if sym == 0: deselect */
	for(i=0; i < var->entries; i++ )
	    if( var->values[i] == sym ) {
		index =i;
		break;
	    }
	WamPutListSelection( msg(self, sym_form), self, index );
    }
    return self;
}


DCLOBJFNC( setSelection )
{
    DCL_arg(int, idx);
    DCL_var();

    if( idx < 0 )
	idx = -1;
    if( var->values )
	WamPutListSelection( msg(self, sym_form), self, idx );
    return self;
}


DCLOBJFNC_i( getSelection )
{
    int index;
    DCL_var();

    if( !var->values ) { /* CheckBox or checked menueitem */
	index = var->state ? 1 : 0;
    }
    else if( !var->entries ) {
	Fatal("Labels not set for ListItem");
	index = -1;
    }
    else {
	index = WamGetListSelection( msg(self, sym_form), self, -1 );
	if( index == -1 )
	    ;
	else if( index < 0 || index >= var->entries ) {
	    Fatal("Index %d in Selection is out of range 0..%u",
		    index, var->entries-1 );
	    index = -1;
	}
    }
    return index;
}


DCLOBJFNC( event )
{
    DCL_var();


    if( !var->values ) { /* CheckBox or check menueitem */
	/* toggle check state */
	var->state = !var->state;
	WamGetPutCheckState( msg(self, sym_form), self, var->state? 1:0 );
	msg(self, sym_valueChanged );
    }
    return self;
}


void WamSUC_FormItemToggle()
{
    id self = FormItemToggle;
    CREATECLASS("FormItemToggle");
    WamSubclassClass( sym_FormItemKey, self );

    DCLMTHD( free );
    DCLMTHD( setLabels );
    DCLMTHD( openInitialization );
    DCLMTHD( getSymbol );
    DCLMTHD( putSymbol );
    DCLMTHD( setSelection );
    DCLMTHD( getSelection );
    DCLMTHD( event );
}


/**** end of file ****/
