/* [wam/fitext.c wk 7.02.93] Class FormItemText
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: fitext.c,v 1.10 1996/09/25 16:20:53 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/string.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>
#include "wammain.h"
#include "wamgui.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/
#define DEFAULT_LEN 35

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(FormItemText)

BEGIN_DCLPRIVATEPART
    char    *buffer;  /* kann auch NULL sein = keine Buffer */
    ushort  buflen;   /* allocation length */
    char    *hlpbuffer;
    int     readOnly;
    int     setToUpper;
    itemFilterFnc_type inFilter, outFilter;
    char   *mapping;  /* malloced mapping string */
    struct {
	unsigned passed:1;  /* openInitialization performed */
	unsigned set_len:1; /* must set length in openInitialization */
    } oflags; /* openInitialization flags */
    int modified;
END_DCLPRIVATEPART

static int defaultIsOvertypeMode; /* siehe +insertMode */

/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/
static void GetValue( id self, id var );

/**************************************************
 *************	Local Functions  ******************
 **************************************************/


static void
GetValue( id self, id var )
{
    if( !var->buffer )
	msg1( self, sym_setLength, DEFAULT_LEN );
    if( var->readOnly )
	/*msg(self, sym_renewText)*/;
    else {
	strcpy(var->hlpbuffer, var->buffer); /* save */
	WamGetItemText( msg(self, sym_form),
			self,
			var->buffer,
			var->buflen    );
	if( var->mapping ) {
	    char *p;
	    const char *s;

	    for( p = var->buffer; *p; p++ )
		for( s=var->mapping; *s && s[1] ; s += 2)
		    if( *s == *p ) {
			*p = s[1];
			break; /* inner for */
		    }
	}
    }
    if( var->inFilter ) {
	const char *s;
	s = (*var->inFilter)(self, var->buffer, var->buflen );
      #if 0
	if( s )
	    Display error(1)
      #endif
    }
    else {
	StripTrailingWSpaces(var->buffer);
	if( var->setToUpper )
	    strupr(var->buffer);
    }
    if( strcmp(var->hlpbuffer, var->buffer) )
	var->modified = 1;
}

/**************************************************
 ******************  Methods  *********************
 **************************************************/

/****************
 * Change the behaviour of new created entry fields to insertMode (default)
 * There is also an instance method to control this on an item by item basis
 */
DCLFOBJFNC( insertMode )
{
    defaultIsOvertypeMode = 0;
    return self;
}

/****************
 * Change the behaviour of new created entry fields to overtypeMode
 * There is also an instance method to control this on an item by item basis
 */
DCLFOBJFNC( overtypeMode )
{
    defaultIsOvertypeMode = 1;
    return self;
}


DCLOBJFNC( free )
{
    DCL_var();
    free( var->buffer );
    free( var->hlpbuffer );
    free( var->mapping );
    return msgSuper( sym_free );
}

DCLOBJFNC( setLength )
{
    DCL_arg( size_t, len );
    DCL_var();

    free( var->buffer );
    free( var->hlpbuffer );
    len++;
    var->buffer = xmalloc( len );
    var->hlpbuffer = xmalloc( len );
    *var->buffer= 0;
    var->buflen = len;
    /* set the length of the entry field */
    if( var->oflags.passed )
	WamGetItemText( msg(self, sym_form), self, NULL, len-1 );
    else
	var->oflags.set_len = 1;
    return self;
}

DCLOBJFNC( setToUpper )
{
    DCL_var();

    var->setToUpper = 1;
    return self;
}

/****************
 * This function sets a mapping string, which is used to map an entered
 * character to another character. the string may be of any length
 * and contains alternating thje character to map and the mapped character.
 * Example: With the mapping string: ",._-" an entered comma will be
 * returned as a dot and an entered underscore maps to am hyphen.
 * This mapping is executed before a filterfunction or the setToUpper
 * function. A MapString of NULL disables this feature.
 */
DCLOBJFNC( setMapString )
{
    DCL_arg(const char *, s );
    DCL_var();

    FREE(var->mapping);
    if( s )
	var->mapping = xstrdup(s);
    return self;
}


DCLOBJFNC( openInitialization )
{
    DCL_var();

    if( !var->oflags.passed ) {
	var->oflags.passed = 1;
	if( var->oflags.set_len )
	    WamGetItemText( msg(self, sym_form), self, NULL, var->buflen-1 );
	/* Switch to overtype mode if this is the default
	 * FIXME: actually we must decide, wether to switch to
	 * overtype or insertMode, depending on the GUI.
	 * This needs an extra Query API for the GUI Module
	 * simple, but should be done in the future
	 */
	if( defaultIsOvertypeMode )
	    msg(self, sym_overtypeMode );
	else
	    msg(self, sym_insertMode );

    }
    return msgSuper( sym_openInitialization );
}


DCLOBJFNC( get )
{
    DCL_var();
    GetValue(self, var);
    return newString(var->buffer);
}


DCLOBJFNC( put )
{
    DCL_arg(id, newVal);

    if( !newVal )
	msg1(self, sym_putValue, "" );
    else if( WamIsKindOf( newVal, String ) )
	msg1(self, sym_putValue, getString(newVal) );
    else
	msg1(self, sym_putValue, "<invalid datatype>" );

    return self;
}



DCLOBJFNC_p( getValue )
{
    DCL_var();
    GetValue(self, var);
    return var->buffer;
}


DCLOBJFNC( putValue )
{
    DCL_arg(const char *, p);  /* here it is a string */
    DCL_var();

    if( !var->buffer )
	msg1( self, sym_setLength, DEFAULT_LEN );
    mem2str(var->buffer,p, var->buflen );
    if( var->outFilter )
	(*var->outFilter)(self, var->buffer, var->buflen );
    else {
	if( var->setToUpper )
	    strupr(var->buffer);
    }
    WamPutItemText( msg(self, sym_form),
		    self,
		    var->buffer );
    var->modified = 0;
    return self;
}


DCLOBJFNC( clearValue )
{
    msg1(self, sym_putValue, "" );
    return self;
}

DCLOBJFNC( modified )
{
    DCL_var();
    GetValue(self, var); /* get it from the gui */
    return var->modified ? True : False;
}

DCLOBJFNC( resetModify )
{
    id old;
    DCL_var();

    old = var->modified ? True : False;
    var->modified = 0;
    return old;
}


DCLOBJFNC( renewText )
{
    DCL_var();

    WamPutItemText( msg(self, sym_form), self, var->buffer );
    return self;
}

/****************
 * This message get send directly from the GUI!
 * And performs the same action as renewTExt.
 */
DCLOBJFNC( itemModified )
{
    DCL_var();

    if( var->readOnly )
	msg(self, sym_renewText );
    return self;
}


DCLOBJFNC_i( getInternalItemType )
{
    return ITEMTYPE_ENTRY;
}


DCLOBJFNC( readWrite )
{
    DCL_var();
    var->readOnly = 0;
    /* fixme: leider habe wir noch keine entsprechende Funktion
     * um eine readonyl (== output-only) field zu setzen, wir benutzen
     * deswegen disabel/enable (keine ahnung, warum ich hier mal
     * diese readonly Variable eingebaut habe) --> siehe formitem.c
     */
    return msgSuper( sym_readWrite);
}

DCLOBJFNC( readOnly )
{
    DCL_var();
    var->readOnly = 1;
    return msgSuper(sym_readOnly);
}

DCLOBJFNC( lostFocus )
{
  #if 0
    DCL_var();
    if( var->readOnly )
	msg(self, sym_renewText);
  #endif
    return self;
}


DCLOBJFNC_I( size )
{
    DCL_var();
    GetValue(self,var);
    return strlen(var->buffer);
}



/****************
 * Wird eine Filter funktion benutzt, so sind
 * einige andere Features ausgeschaltet.
 */
DCLOBJFNC( setInputFilterFunction )
{
    DCL_arg(itemFilterFnc_type, fnc);
    DCL_var();
    var->inFilter = fnc;
    return self;
}


/****************
 * Wird eine Filter funktion benutzt, so sind
 * einige andere Features ausgeschaltet.
 */
DCLOBJFNC( setOutputFilterFunction )
{
    DCL_arg(itemFilterFnc_type, fnc);
    DCL_var();
    var->outFilter = fnc;
    return self;
}



void WamSUC_FormItemText()
{
    id self = FormItemText;
    CREATECLASS("FormItemText");
    WamSubclassClass( sym_FormItem, self );

    DCLFMTHD( insertMode);
    DCLFMTHD( overtypeMode);

    DCLMTHD( free );
    DCLMTHD( getInternalItemType );
    DCLMTHD( setLength );
    DCLMTHD( setToUpper );
    DCLMTHD( setMapString );
    DCLMTHD( openInitialization );
    DCLMTHD( get );
    DCLMTHD( put );
    DCLMTHD( getValue );
    DCLMTHD( putValue );
    DCLMTHD( clearValue );
    DCLMTHD( modified );
    DCLMTHD( resetModify );
    DCLMTHD( renewText);
    DCLMTHD( itemModified );
    DCLMTHD( readWrite );
    DCLMTHD( readOnly );
    DCLMTHD( lostFocus );
    DCLMTHD( size );
    DCLMTHD( setInputFilterFunction );
    DCLMTHD( setOutputFilterFunction );
}


/**** end of file ****/
