/* [wam/firadio.c wk 29.09.93] Class FormItemRadio
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * Handler for Radiobuttons.
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: firadio.c,v 1.2 1996/01/10 19:01:42 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>
#include "wamgui.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/
DCLSYM sym_privatePut;
DCLSYM sym_addSingle;

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(FormItemRadio)

BEGIN_DCLPRIVATEPART
    int checked;
    id linked_items;
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

/**************************************************
 ******************  Methods  *********************
 **************************************************/


DCLOBJFNC( free )
{
    DCL_var();
    freeObj(var->linked_items);
    return msgSuper( sym_free );
}

/****************
 * Add fother to the list of our linked items
 */
DCLOBJFNC( linkItemToItem )
{
    DCL_arg(id,fother);
    DCL_var();

    if( fother && fother != self ) {
	if( !var->linked_items )
	    var->linked_items = newObj(Array);
	msg1(var->linked_items, sym_addSingle, fother );
    }
    return self;
}

DCLOBJFNC_s( getSymbol )
{
    DCL_var();

    return var->checked? sym_True : sym_False;
  #if 0
    if( WamGetPutCheckState( msg(self, sym_form), self, -1 ) )
	return sym_True;
    return sym_False;
  #endif
}

DCLOBJFNC( get )
{
    DCL_var();

    return var->checked? True : False;
  #if 0
    if( WamGetPutCheckState( msg(self, sym_form), self, -1 ) )
	return True;
    return False;
  #endif
}



/****************
 * This function can be used to return the name of the item which is
 * checked. May also return nil if none is checked or this item is not
 * member in a group of Radiobuttons.
 */
DCLOBJFNC( getCheckedItem )
{
    DCL_var();

    if( var->checked )
	return msg(self, sym_name);
    if( var->linked_items && msg( var->linked_items, sym_enumOpen ) ) {
	id obj, name;
	while( obj = msg(var->linked_items, sym_enumGet) )
	    if( msg(obj, sym_get)== True ) {
		name = msg(obj, sym_name);
		msg(var->linked_items, sym_enumClose);
		return name;
	    }
    }

    return nil;
}


DCLOBJFNC( putSymbol )
{
    DCL_arg(symbol_t, s);

    return msg1(self, sym_put, s==sym_True? True : False);
}

DCLOBJFNC( put )
{
    DCL_arg(symbol_t, s);
    DCL_var();

    if( var->checked = s == True )
       WamGetPutCheckState( msg(self, sym_form), self, 1 );
    else
       WamGetPutCheckState( msg(self, sym_form), self, 0 );
    if( var->linked_items && msg( var->linked_items, sym_enumOpen ) ) {
	id obj;
	s = s==True? False:True;
	while( obj = msg(var->linked_items, sym_enumGet) )
	    msg1(obj, sym_privatePut, s);
    }
    return self;
}

DCLOBJFNC( privatePut )
{
    DCL_arg(symbol_t, s);
    DCL_var();

    if( var->checked = s == True )
       WamGetPutCheckState( msg(self, sym_form), self, 1 );
    else
       WamGetPutCheckState( msg(self, sym_form), self, 0 );
    return self;
}



/****************
 * This should not be used with automatic buttons
 * because we assume that an event does only occur on a click.
 */
DCLOBJFNC( event )
{
    DCL_var();

    if( var->linked_items && msg( var->linked_items, sym_enumOpen ) ) {
	id obj;
	WamGetPutCheckState( msg(self, sym_form), self, 1 );
	var->checked = 1;
	while( obj = msg(var->linked_items, sym_enumGet) )
	    msg1(obj, sym_privatePut, False);
    }
    else if( !var->linked_items ) {  /* toggle this one */
	var->checked = !var->checked;
	WamGetPutCheckState( msg(self, sym_form), self, var->checked?1:0 );
    }
    return self;
}

void WamSUC_FormItemRadio()
{
    id self = FormItemRadio;
    CREATECLASS("FormItemRadio");
    WamSubclassClass( sym_FormItemKey, self );

    DCLMTHD( free );
    DCLMTHD( linkItemToItem );
    DCLMTHD( getSymbol );
    DCLMTHD( putSymbol );
    DCLMTHD( get );
    DCLMTHD( getCheckedItem );
    DCLMTHD( put );
    DCLMTHD( privatePut );
    DCLMTHD( event );
}


/**** end of file ****/
