/* [wam/finumber.c wk 7.02.93] Class FormItemNumber
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: finumber.c,v 1.6 1996/09/25 16:20:52 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>
#include "wamgui.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(FormItemNumber)

BEGIN_DCLPRIVATEPART
    double val;
    int    isFloat;
    int    nks;
    int    usePrecision;
    int modified;
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/
static void DoPut( id self, id var );
static void DoGet( id self, id var );

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

static void
DoPut( id self, id var )
{
    char buf[50], *p;
    int val;

    if( var->isFloat ) {
	if( var->usePrecision ) {
	    if( var->val ) { /* runden */
		double i, f, x;
		int pow, n;

		for( pow=1,n=0; n < var->nks; n++, pow *= 10 )
		    ;
		f = modf(var->val, &i);
		f *= pow;
		f +=  f < 0 ? -0.5 : 0.5;
		f = modf(f, &x);
		f = x ? (x / pow) : 0;
		var->val = i + f;
	    }
	    sprintf(buf, "%.*f", var->nks, var->val );
	}
	else
	    sprintf(buf, "%f", var->val );
	for(p=buf; *p; p++ )
	    if( *p == '.' )
		*p = ',';
	/* ... hier noch tausenderpunkte einbauen ... */
	WamPutItemText( msg(self, sym_form), self, buf );
    }
    else {
	val = var->val;
	sprintf(buf, "%d", val );
	WamPutItemText( msg(self, sym_form), self, buf );
    }
}

static void
DoGet( id self, id var )
{
    char buf[50], *p;
    double old;

    WamGetItemText( msg(self, sym_form), self, buf, DIM(buf)  );
    for(p=buf; *p; p++ )
	if( *p == ',' )
	    *p = '.';
    old = var->val;
    var->val = atof(buf);
    if( old != var->val )
	var->modified = 1;
}

/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLOBJFNC( setPrecision )
{
    DCL_arg( int, nks );
    DCL_var();

    var->usePrecision = 1;
    var->isFloat = 1;
    var->nks = nks > 0 ? nks : 0;
    return self;
}



/* gibt z.Z. immer nur Obj of Class Float zurueck
 * und dies ist auch gut so, da wir dann einfacher abfragen knnen.
 */
DCLOBJFNC( get )
{
    DCL_var();

    DoGet(self, var);
    DoPut(self, var);
    return newFloat(var->val);
}


DCLOBJFNC( put )
{
    DCL_arg(id, newVal);
    DCL_var();

    if( !newVal || WamIsKindOf( newVal, Float ) ) {
	var->val = newVal ? getFloat(newVal) : 0;
	var->isFloat = 1;
    }
    else if( WamIsKindOf( newVal, Integer ) ) {
	int val = getInteger(newVal);
	var->val = val;
	if( !var->usePrecision )
	    var->isFloat = 0;
    }
    else {
	var->val = 0;
	Error(0,"invalid datatype for put in class Float");
    }
    DoPut(self,var);
    var->modified = 0;

    return self;
}


/****************
 *  Dieses getValue kann nur fuer Integer Werte benutzt werden !
 */

DCLOBJFNC_i( getValue )
{
    int val, old;
    char buf[50];
    DCL_var();

    WamGetItemText( msg(self, sym_form), self, buf, DIM(buf)  );
    old = var->val;
    var->val = atof(buf);
    val = var->val;
    var->val = val;
    DoPut(self, var);
    if( val != old )
	var->modified = 1;
    return val;
}

/****************
 *  Dieses putValue kann nur fuer Integer Werte benutzt werden !
 */
DCLOBJFNC( putValue )
{
    DCL_arg(int, val);
    DCL_var();

    var->val = val;
    if( !var->usePrecision )
	var->isFloat = 0;
    DoPut(self,var);
    var->modified = 0;
    return self;
}


DCLOBJFNC( clearValue )
{
    DCL_var();

    var->val = 0;
    WamPutItemText( msg(self, sym_form), self, "" );
    var->modified = 0;
    return self;
}



DCLOBJFNC( modified )
{
    DCL_var();
    DoGet(self,var);
    return var->modified ? True : False;
}

DCLOBJFNC( resetModify )
{
    id old;
    DCL_var();

    old = var->modified ? True : False;
    var->modified = 0;
    return old;
}




DCLOBJFNC( renewText )
{
    DCL_var();

    DoPut(self, var );
    return self;
}


void WamSUC_FormItemNumber()
{
    id self = FormItemNumber;
    CREATECLASS("FormItemNumber");
    WamSubclassClass( sym_FormItemText, self );

    DCLMTHD( setPrecision );
    DCLMTHD( get );
    DCLMTHD( put );
    DCLMTHD( getValue );
    DCLMTHD( putValue );
    DCLMTHD( clearValue );
    DCLMTHD( modified );
    DCLMTHD( resetModify );
    DCLMTHD( renewText);
}


/**** end of file ****/
