/* [wam/finspin.c wk 16.03.93] Class FormItemNumericSpin
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: finspin.c,v 1.6 1996/09/25 16:20:52 wk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>
#include "wammain.h"
#include "wamgui.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(FormItemNumericSpin)

BEGIN_DCLPRIVATEPART
    int last_val;
    int lowerLim;
    int upperLim;
    int is_open;
    int modified;
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/


/**************************************************
 ******************  Methods  *********************
 **************************************************/

/****************
 * Setzt den unteren und oberen Wert
 */

DCLOBJFNC( setRange )
{
    DCL_arg(int,a);
    DCL_arg(int,b);
    DCL_var();
    var->lowerLim = var->last_val = a;
    var->upperLim = b;
    if( var->is_open ) {
	/*, keine Ahnung, warum dies hier nicht gemacht wurde,
	 * sicherheitshalber mache ich es nur nach openInitialization
	 */
	WamSpinButtonControl( msg(self, sym_form), self,
			      0 /* set range */,
			      var->lowerLim,
			      var->upperLim );
    }
    return self;
}



/****************
 * Window ist jetzt offen: Labels koennen gesetzt werden.
 */

DCLOBJFNC( openInitialization )
{
    DCL_var();
    WamSpinButtonControl( msg(self, sym_form), self,
			  0 /* set range */,
			  var->lowerLim,
			  var->upperLim );
    var->is_open = 1;
    var->last_val = var->lowerLim;
    return self;
}



DCLOBJFNC( get )
{
    int val;
    DCL_var();

    val = WamSpinButtonControl( msg(self, sym_form), self,
				1 /* query value */,
				0,
				0 );
    if( val != var->last_val )
	var->modified = 1;
    var->last_val = val;
    return newInteger(val);
}


DCLOBJFNC( put )
{
    int i;
    DCL_arg(id, nval);
    DCL_var();

    i = nval ? getInteger(nval): 0;
    WamSpinButtonControl( msg(self, sym_form), self,
			  2 /* set value */,
			  i,
			  0 );
    var->last_val = i;
    var->modified = 0;
    return self;
}

DCLOBJFNC( clearValue )
{
    DCL_var();
    WamSpinButtonControl( msg(self, sym_form), self,
			  2 /* set value */,
			  var->lowerLim,
			  0 );
    var->last_val = var->lowerLim;
    var->modified = 0;
    return self;
}

DCLOBJFNC( modified )
{
    id val;
    DCL_var();
    val = msg(self, sym_get); freeObj(val);
    return var->modified ? True : False;
}

DCLOBJFNC( resetModify )
{
    id old;
    DCL_var();

    old = var->modified ? True : False;
    var->modified = 0;
    return old;
}



DCLOBJFNC_i( getInternalItemType )
{
    return ITEMTYPE_ENTRY;
}


void WamSUC_FormItemNumericSpin()
{
    id self = FormItemNumericSpin;
    CREATECLASS("FormItemNumericSpin");
    WamSubclassClass( sym_FormItemKey, self );

    DCLMTHD( setRange );
    DCLMTHD( openInitialization );
    DCLMTHD( get );
    DCLMTHD( put );
    DCLMTHD( clearValue );
    DCLMTHD( getInternalItemType );
    DCLMTHD( modified );
    DCLMTHD( resetModify );
}


/**** end of file ****/
