/* [wam/filist.c wk 25.02.93] Class FormItemList
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <wk/tailor.h>
RCSID("$Id: filist.c,v 1.7 1996/01/10 19:01:37 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>
#include "wammain.h"
#include "wamgui.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(FormItemList)

BEGIN_DCLPRIVATEPART
    enum { NONE, TABLE, STRINGARRAY } type;
    id tbl;
    id strgarry;
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

static void Redisplay( id self, id var );
static void RedisplayTable( id self, id var );
static void RedisplayStringArray( id self, id var );

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

static void
Redisplay( id self, id var )
{
    if( var->type == TABLE )
	RedisplayTable( self, var );
    else if( var->type == STRINGARRAY )
	RedisplayStringArray( self, var );
    else /* clear the list */
	WamInsertListItem( msg(self, sym_form),self, -1, NULL );
}


static void
RedisplayTable( id self, id var )
{
    id arr, form;
    char *p;

    if( var->tbl )
	arr = msg(var->tbl, sym_formatTable );
    form = msg(self, sym_form);
    WamInsertListItem( form, self, -1, NULL );
    if( var->tbl ) {
	if( msg(arr, sym_enumOpen ) )
	    while( p = p_msg(arr, sym_enumGet) )
		WamInsertListItem( form, self, -2, p);
	freeObj(arr);
    }
}

static void
RedisplayStringArray( id self, id var )
{
    id form;
    char *p;

    form = msg(self, sym_form);
    WamInsertListItem( form, self, -1, NULL );
    if( var->strgarry ) {
	if( msg(var->strgarry, sym_enumOpen ) )
	    while( p = p_msg(var->strgarry, sym_enumGet) )
		WamInsertListItem( form, self, -2, p);
    }
}


/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLOBJFNC( free )
{
    DCL_var();
    if( var->tbl )
	msg1(var->tbl, sym(removeDependent), self );
    freeObj(var->strgarry);
    return msgSuper( sym_free );
}


/****************
 * Gibt das ausgewhlte Objekt zurck. Dies ist ein Objekt
 * der Klasse TableRow falls wir eine Table hier haben oder
 * ein String, falls wir hier ein StringArray gespeichert haben-
 * Falls nichts oder fehlerhaft selektiert wurde, so wird
 * nil zurueckgegeben.
 */

DCLOBJFNC( get )
{
    int index;
    id obj;
    DCL_var();

    obj = nil;
    index = WamGetListSelection( msg(self, sym_form), self, -1 );
    if( index >= 0 ) {
	if( var->type == TABLE && var->tbl )
	    obj = msg1( var->tbl, sel(asTableRowAt), (unsigned)index );
	else if( var->type == STRINGARRAY && var->strgarry )
	    obj = msg1( var->strgarry, sym_get, (unsigned)index );
    }
    return obj;
}


/****************
 * Ein Objekt fr die liste setzen.
 * Dies kann sein: nil := lschen
 *		   StringArray (Kopie)
 *		   Table
 */
DCLOBJFNC( put )
{
    DCL_arg(id, obj );
    DCL_var();

    /* den typ bestimmen */
    if( !obj )
	var->type = NONE;
    else if( WamIsKindOf( obj, Table ) )
	var->type = TABLE;
    else if( WamIsKindOf( obj, StringArray ) )
	var->type = STRINGARRAY;
    else {
	Info("Class not supported by FormItemList");
	var->type = NONE;
    }

    /* cleanup */
    if( var->tbl ) {
	msg1(var->tbl, sym(removeDependent), self );
	var->tbl = nil;
    }
    if( var->strgarry ) {
	freeObj(var->strgarry);
    }

    /* set new vaulues */
    if( var->type == TABLE ) {
	var->tbl = obj;
	msg1(var->tbl, sym(addDependent), self );
    }
    else if( var->type == STRINGARRAY ) {
	var->strgarry = msg(obj, sym_copy);
    }
    Redisplay(self,var);
    return self;
}


DCLOBJFNC( clearValue )
{
    return msg1(self, sym_put, nil );
}


DCLOBJFNC( changed )
{
/*  DCL_arg(id,dep);  wird immer sein: tbl */
    DCL_var();

    if( var->tbl || var->strgarry )
	Redisplay(self,var);
    return self;
}


DCLOBJFNC( killDependency )
{
    /*DCL_arg(id,dep); wird immer sein: tbl */
    DCL_var();
    var->tbl = nil;
    return self;
}




DCLOBJFNC( setSelection )
{
    DCL_arg(int, index);

    if( index < 0 )
	index = -1;
    WamPutListSelection( msg(self, sym_form), self, index );
    return self;
}


DCLOBJFNC_i( getInternalItemType )
{
    return ITEMTYPE_LIST;
}




void WamSUC_FormItemList()
{
    id self = FormItemList;
    CREATECLASS("FormItemList");
    WamSubclassClass( sym_FormItem, self );

    DCLMTHD( free );
    DCLMTHD( get );
    DCLMTHD( put );
    DCLMTHD( clearValue );
    DCLMTHD( changed );
    DCLMTHD( setSelection );
    DCLMTHD( killDependency );
    DCLMTHD( getInternalItemType );
}


/**** end of file ****/
