/* [wam/fiint.c wk 28.08.93] Class FormItemInteger
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: fiint.c,v 1.5 1996/09/25 16:20:52 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>
#include "wamgui.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(FormItemInteger)

BEGIN_DCLPRIVATEPART
    long   val;
    int    len;     /* 0 = no limit */
    int    modified;
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

/**************************************************
 *************	Local Functions  ******************
 **************************************************/


/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLOBJFNC( setPrecision )
{
    /* DCL_arg( int, nks ); */
    /* catch this, there is no need for it in Integer */
    return self;
}

DCLOBJFNC( setLength )
{
    DCL_arg( int, len );
    DCL_var();
    var->len = len > 0 ? len : 0;
    return self;
}



DCLOBJFNC( get )    /* gibt immer ein Obj of Class Integer zurueck */
{
    char buf[50], *p;
    int n;
    long old;
    DCL_var();

    n = var->len ? var->len : 20;
    WamGetItemText( msg(self, sym_form), self, buf, DIM(buf)  );
    for(p=buf; *p && isspace(*p) ; p++ )
	;
    if( *p =='-' )  /* minus sign and additional white space are allowed */
	p++;
    for( ; *p && isspace(*p) ; p++ )
	;
    for( ; *p && isdigit(*p) && n ; p++, n-- )
	;
    *p = 0; /* throw away all other characters */
    old = var->val;
    var->val = atol(buf);
    sprintf(buf, "%ld", var->val );
    /* ... hier noch tausenderpunkte einbauen ... */
    WamPutItemText( msg(self, sym_form), self, buf );
    if( old != var->val )
	var->modified = 1;
    return newInteger(var->val);
}


DCLOBJFNC( put )
{
    DCL_arg(id, newVal);
    char buf[50];
    DCL_var();

    if( !newVal || WamIsKindOf( newVal, Float ) ) {
	var->val = newVal ? (long)(getFloat(newVal)) : 0;
	sprintf(buf, "%ld", var->val );
	/* ... hier noch tausenderpunkte einbauen ... */
	WamPutItemText( msg(self, sym_form), self, buf );
    }
    else if( WamIsKindOf( newVal, Integer ) ) {
	var->val = getInteger(newVal);
	sprintf(buf, "%ld", var->val );
	/* ... hier noch tausenderpunkte einbauen ... */
	WamPutItemText( msg(self, sym_form), self, buf );
    }
    else
	Error(0,"invalid datatype for put in class FormItemInteger");
    var->modified = 0;
    return self;
}


/****************
 *  Dieses getValue kann nur fuer (C-)Integer Werte benutzt werden !
 */

DCLOBJFNC_i( getValue )
{
    char buf[50];
    long old;
    DCL_var();

    WamGetItemText( msg(self, sym_form), self, buf, DIM(buf)  );
    old = var->val;
    var->val = atol(buf);
    sprintf(buf, "%ld", var->val );
    WamPutItemText( msg(self, sym_form), self, buf );
    if( old != var->val )
	var->modified = 1;
    return var->val;
}

/****************
 *  Dieses putValue kann nur fuer (C-)Integer Werte benutzt werden !
 */

DCLOBJFNC( putValue )
{
    DCL_arg(int, val);
    char buf[50];
    DCL_var();

    var->val = val;
    sprintf(buf, "%ld", var->val );
    WamPutItemText( msg(self, sym_form), self, buf );
    var->modified = 0;
    return self;
}


DCLOBJFNC( clearValue )
{
    DCL_var();

    var->val = 0;
    WamPutItemText( msg(self, sym_form), self, "" );
    var->modified = 0;
    return self;
}


DCLOBJFNC( modified )
{
    id val;
    DCL_var();

    val = msg(self, sym_get); freeObj(val);
    return var->modified ? True : False;
}

DCLOBJFNC( resetModify )
{
    id old;
    DCL_var();

    old = var->modified ? True : False;
    var->modified = 0;
    return old;
}



void WamSUC_FormItemInteger()
{
    id self = FormItemInteger;
    CREATECLASS("FormItemInteger");
    WamSubclassClass( sym_FormItemNumber, self );

    DCLMTHD( setPrecision ); /* a dummy */
    DCLMTHD( setLength );
    DCLMTHD( get );
    DCLMTHD( put );
    DCLMTHD( getValue );
    DCLMTHD( putValue );
    DCLMTHD( clearValue );
    DCLMTHD( modified );
    DCLMTHD( resetModify );
}


/**** end of file ****/
