/* [wam/fidate.c wk 27.03.93] Class FormItemDate
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: fidate.c,v 1.7 1996/09/25 16:20:52 wk Exp $")
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <wk/string.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>
#include "wammain.h"
#include "wamgui.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(FormItemDate)

BEGIN_DCLPRIVATEPART
    long date;
    int  readOnly;
    int rememberYear;
    int rememberMonth;
    int lastYear;
    int lastMonth;
    int modified;
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/

static void EvaluateText( id self, id var );

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

static void
EvaluateText( id self, id var )
{
    char buf[50];
    int d,m,y, n;


    WamGetItemText( msg(self, sym_form), self, buf, DIM(buf)  );

    d = m = y = 0;
    if( stristr(buf, "HEUTE") || stristr(buf, "TODAY") ) {
	var->date = TodaysJD();
	return;
    }

    n = sscanf(buf, " %u.%u.%u", &d, &m, &y );
    if( n > 1 )
	var->lastMonth = m;
    if( n > 2 ) {
	if( y >= 0 && y < 100 )  /* kurzschreibweise */
	    y += y < 50 ? 2000 : 1900;
	var->lastYear = y;
    }

    if( n == 1 && var->rememberMonth && var->lastMonth ) {
	n++;
	m = var->lastMonth;
    }
    if( n == 2 && var->rememberYear && var->lastYear ) {
	n++;
	y = var->lastYear;
    }

    if( n != 3 )
	var->date = 0;
    else if( !d && !m && !y )
	var->date = 0;
    else {
	if( CheckDate( d, m, y ) ) {
	    /*sprintf(buf, "%d?%d?%d?", d,m,y );*/
	    var->date = 0;  /* fehlerhaftes Datum */
	}
	else
	    var->date = Date2JD( d, m, y );
    }

}
/**************************************************
 ******************  Methods  *********************
 **************************************************/


DCLOBJFNC( get )    /* gibt Object of Class Date zurueck */
{
    long old;
    DCL_var();

    old = var->date;
    if( !var->readOnly )
	EvaluateText( self, var );
    msg( self, sym_renewText );
    if( old != var->date )
	var->modified = 1;
    return msg1(Date, sym_create, var->date);
}


DCLOBJFNC( put )
{
    DCL_arg(id, newVal);  /* Object of Class Date */
    DCL_var();

    if( !newVal ) {
	var->date = 0;
	msg(self, sym_renewText );
    }
    else if( WamIsKindOf( newVal, Date ) ) {
	var->date = getInteger(newVal);
	msg(self, sym_renewText );
    }
    else
	Error(0,"inv. type for put in FormItemDateClass");
    var->modified = 0;
    return self;
}


DCLOBJFNC( clearValue )
{
    DCL_var();

    var->date = 0;
    msg(self, sym_renewText );
    var->modified = 0;
    return self;
}


DCLOBJFNC( modified )
{
    id val;
    DCL_var();
    val = msg(self, sym_get); freeObj(val);
    return var->modified ? True : False;
}

DCLOBJFNC( resetModify )
{
    id old;
    DCL_var();

    old = var->modified ? True : False;
    var->modified = 0;
    return old;
}



DCLOBJFNC( renewText )
{
    char buf[50];
    int d,m,y;
    DCL_var();

    if( !var->date )
	*buf = 0;
    else {
	if( !JD2Date( var->date, &d, &m, &y ) ) {
	    var->date = 0;
	    *buf = 0;  /* invalid or 0 */
	}
	else
	    sprintf(buf, "%d.%02d.%d", d,m,y );
    }
    WamPutItemText( msg(self, sym_form), self, buf );
    return self;
}


DCLOBJFNC( readWrite )
{
    DCL_var();
    var->readOnly = 0;
    return self;
}

DCLOBJFNC( readOnly )
{
    DCL_var();
    var->readOnly = 1;
    return self;
}


DCLOBJFNC( lostFocus )
{
    DCL_var();
    if( !var->readOnly )
	EvaluateText( self, var );
    msg(self, sym_renewText);
    return self;
}


DCLOBJFNC( rememberYear )
{
    DCL_arg(int,yesno);
    DCL_var();

    var->rememberYear = yesno;
    return self;
}

DCLOBJFNC( rememberMonth )
{
    DCL_arg(int,yesno);
    DCL_var();

    var->rememberMonth = yesno;
    return self;
}

void WamSUC_FormItemDate()
{
    id self = FormItemDate;
    CREATECLASS("FormItemDate");
    WamSubclassClass( sym_FormItemText, self );

    DCLMTHD( get );
    DCLMTHD( put );
    DCLMTHD( clearValue );
    DCLMTHD( renewText);
    DCLMTHD( readWrite );
    DCLMTHD( readOnly );
    DCLMTHD( lostFocus);
    DCLMTHD( rememberYear );
    DCLMTHD( rememberMonth );
    DCLMTHD( modified );
    DCLMTHD( resetModify );
}


/**** end of file ****/
