/* [dllmain.c wk 02.04.93] Pull in DLL Initialization
 *	(c) Copyright 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * History:
 * $Id: dllmain.c,v 1.13 1996/09/18 13:17:09 wk Exp $
 */

#include <wk/tailor.h>
#include <stdio.h>
#include <stdlib.h>
#include <wk/lib.h>
#include <wk/wam.h>

#include "version.h"

#ifdef DOCUMENTATION
@Summary WamDLLInfo
 #include <wk/wam.h>

 const char *CopyRight( int level );
 level 0: Copyright String zurueckgeben
       1: Empty string
       2: Empty string
      10: Copyrightstring zurckgeben
      11: Empty string
      12: Empty string
      13: Programmnamen zurckgeben
      14: Versionsnummer zurckgeben
      15: Empty string
      16: Name unter dem im Profile gespeichert werden soll
      20: unused
      21: unused
      22: unused
      23: CompileTime
@Description
 Funktionsnummer wie bei CopyRight()
@Return Value
 Pointer zum String
#endif /*DOCUMENTATION*/

const char * _wamapi WamDLLInfo( int level )
{
    const char *p;

    switch( level ) {
      case 10:
      case 0:	p = "WAM Main Library"
		    "; Copyright 1993,95 by Werner Koch (dd9jn)" ; break;
      case 1:
      case 11:	p = ""; break;
      case 16:
      case 13:	p = "WAMLib"; break;
      case 14:	p = VERSION; break;
      case 15:	p = ""; break;
      case 23:	p = __DATE__ " " __TIME__; break;
      default: p = "?";
    }
    return p;
}


/******* bottom of file *******/
