/* [wam/date.c wk 27.03.93] Class Date
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 ******************************************************
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: date.c,v 1.10 1997/02/12 13:09:23 wk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>

/**************************************************
 *************	Constants  ************************
 **************************************************/

/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(Date)

BEGIN_DCLPRIVATEPART
    long val;
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/
static int WeekFromDate( long jd , int *ret_jahr );

/**************************************************
 *************	Local Functions  ******************
 **************************************************/

/****************
 * Bei einem Fehler wird 0 zurckgegeben.
 */
static int
WeekFromDate( long jd , int *ret_jahr )
{
    long firstday;
    int jahr, week;

    if( !JD2Date( jd, NULL, NULL, &jahr ) )
	return 0;
    firstday = Date2JD( 1, 1, jahr );
    while( firstday % 7 )
	firstday--;
    if( jd < firstday ) {
	week = 53;
	jahr--;
    }
    else
	week = (jd - firstday) / 7 + 1;
    if( ret_jahr )
	*ret_jahr = jahr;
    return week;
}

/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLFOBJFNC( create )
{
    DCL_arg(long, val); /* julian date */
    id obj;
    id	var;

    obj = msgSuper( sym_new );
    SET_var(obj);
    var->val = val;
    return obj;
}


DCLFOBJFNC( today )
{
    id obj;
    id	var;

    obj = msgSuper( sym_new );
    SET_var(obj);
    var->val = TodaysJD();
    return obj;
}


DCLOBJFNC( copy )
{
    id obj;
    long val;
    DCL_var();

    obj = msg(factory, sym_new );
    val = var->val;
    SET_var(obj);
    var->val = val;
    return obj;
}



DCLOBJFNC_i( getValue )  /* gibt den Wert zurueck */
{
    DCL_var();
    return var->val;
}

DCLOBJFNC( putValue )
{
    DCL_arg(long, val);
    DCL_var();

    var->val = val;
    return self;
}

DCLOBJFNC( date )
{
    return msg(self, sym_copy);
}


DCLOBJFNC( asString )  /* t.mm.jjjj */
{
    int d,m,y;
    char buf[25];
    DCL_var();

    if( !JD2Date( var->val, &d, &m, &y ) )
	*buf = 0;
    else
	sprintf(buf,"%d.%02d.%d",d,m,y);
    return newString(buf);
}


DCLOBJFNC( asCSVString )
{
    return I_asString(self, arg_ptr);
}


DCLOBJFNC( asShortString )  /* t.mm.jj */
{
    int d,m,y;
    char buf[20];
    DCL_var();

    if( !JD2Date( var->val, &d, &m, &y ) )
	*buf = 0;
    else {
	if( y >= 1950 && y < 2000 )
	    y -= 1900;
	else if( y >= 2000 && y < 2050 )
	    y -= 2000;
	sprintf(buf,"%d.%02d.%d",d,m,y);
    }
    return newString(buf);
}


/****************
 * Returns a String with the weeknummer and the year of this date
 * e.g.: "14/95" value range of the week part is 1..53
 * Returns an empty string for an invalid date.
 */
DCLOBJFNC( asWeekString )
{
    int week, year;
    char buf[25];
    DCL_var();

    week = WeekFromDate(var->val, &year);
    if( !week )
	*buf = 0;
    else
	sprintf(buf,"%2d/%02d", week, year%100);
    return newString(buf);
}



DCLOBJFNC_p( allocAsDBString )
{
    char buf[20];
    int d,m,y;
    DCL_var();

    if( !JD2Date( var->val, &d, &m, &y ) )
	strcpy(buf,"'[?]'");
    else
	sprintf(buf,"'%04d-%02d-%02d'",y,m,d);

    return xstrdup(buf);
}


DCLOBJFNC_i( isEqual )
{
    DCL_arg(id, other );    /* kann nur date sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val == var2->val;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	return var->val == getInteger(other);
    }
    else
	return 0;   /* from other class - cannot be equal */
}


DCLOBJFNC_i( isGT )
{
    DCL_arg(id, other );    /* kann nur date sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val > var2->val;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	return var->val > getInteger(other);
    }
    else
	return 0;   /* from other class - cannot be equal */
}

DCLOBJFNC_i( isGE )
{
    DCL_arg(id, other );    /* kann nur date sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val >= var2->val;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	return var->val >= getInteger(other);
    }
    else
	return 0;   /* from other class - cannot be equal */
}


DCLOBJFNC_i( isLT )
{
    DCL_arg(id, other );    /* kann nur date sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val < var2->val;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	return var->val < getInteger(other);
    }
    else
	return 0;   /* from other class - cannot be equal */
}


DCLOBJFNC_i( isLE )
{
    DCL_arg(id, other );    /* kann nur date sein */
    id var2;
    DCL_var();

    if( WamIsMemberOf( other, factory ) ) {
	SET_varx(var2,other);
	return var->val <= var2->val;
    }
    else if( WamIsKindOf( other, factory ) ) { /* a subclass */
	return var->val <= getInteger(other);
    }
    else
	return 0;   /* from other class - cannot be equal */
}


DCLOBJFNC_i( isEmptyOrNil )
{
    DCL_var();
    return var->val == 0;
}


DCLOBJFNC( asNumber )
{
    DCL_var();
    return newInteger(var->val);
}

void WamSUC_Date()
{
    id self = Date;
    CREATECLASS("Date");
    WamSubclassClass( sym_Object, self );
    WamSetAtticLimit(self, 500);

    DCLFMTHD( create );
    DCLFMTHD( today  );

    DCLMTHD( copy );
    DCLMTHD( getValue );
    DCLMTHD( putValue );
    DCLMTHD( date     );
    DCLMTHD( asString );
    DCLMTHD( asCSVString );
    DCLMTHD( asShortString );
    DCLMTHD( asWeekString );
    DCLMTHD( allocAsDBString );
    DCLMTHD( isEqual );
    DCLMTHD( isGT );
    DCLMTHD( isGE );
    DCLMTHD( isLT );
    DCLMTHD( isLE );
    DCLMTHD( isEmptyOrNil );
    DCLMTHD( asNumber );
}


/**** end of file ****/
