/* [wam/autoform.c wk 18.04.93] Class AutomaticForm
 *	Copyright (c) 1993 by Werner Koch (dd9jn)
 *  This file is part of WAM.
 *
 *  WAM is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  WAM is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************
 * Implementiert eine Vereinfachte Version von Forms.
 * Es ist nicht mehr notwendig, zu jeder ViewClass eine
 * eigen FormClass zu schreiben, sondern jeder View kann
 * Instance dieser Class zugeordnet werden.
 ******************************************************
 * History:
 */

#include <wk/tailor.h>
RCSID("$Id: autoform.c,v 1.5 1996/01/10 19:01:25 wernerk Exp $")
#include <stdio.h>
#include <stdlib.h>

#define CLASS_IMPLEMENTATION 1
#include <wk/wam.h>
#include "wammain.h"

/**************************************************
 *************	Constants  ************************
 **************************************************/
/**************************************************
 *************	Local Vars & Types ****************
 **************************************************/

DCLSHAREDPART(AutomaticForm)

BEGIN_DCLPRIVATEPART
    int isRegistered; /* flag damit nur das erste #registerAs wirksam ist */
END_DCLPRIVATEPART


/**************************************************
 *************	Local Prototypes  *****************
 **************************************************/
/**************************************************
 *************	Local Functions  ******************
 **************************************************/

/**************************************************
 ******************  Methods  *********************
 **************************************************/

DCLOBJFNC( initialize )
{
    /* stub - wird durch #registerAs ersetzt, die durch */
    /* #initialize in der View aufgerufen werden */
    return self;
}


DCLOBJFNC( registerAs )
{
    DCL_arg( int, n );
    DCL_var();
    if( !var->isRegistered ) {
	WamRegisterForm( self, n );
	var->isRegistered++;
    }
    return self;
}



DCLOBJFNC( openInitialization )
{
    msg1(msg(self, sym_view), sym_openInitializationForForm, self );
    return self;
}


void WamSUC_AutomaticForm()
{
    id self = AutomaticForm;
    CREATECLASS("AutomaticForm");
    WamSubclassClass( sym_Form, self );
    WamSetAtticLimit( self, 20 );

    DCLMTHD( initialize );
    DCLMTHD( registerAs );
    DCLMTHD( openInitialization );

}


/**** end of file ****/
