/* [wam/app.c wk 22.01.93] Application to Test WAM
 *	Copyright (c) 1992 by Werner Koch (dd9jn)
 * History:
 *
 */

#include <wk/tailor.h>
RCSID("$Id: app.c,v 1.3 1996/01/10 19:01:25 wernerk Exp $")
#include <stdio.h>
RCSID("$Id: app.c,v 1.3 1996/01/10 19:01:25 wernerk Exp $")
#include <stdlib.h>
#include <wk/file.h>
#include <wk/wam.h>

/****** constants *********/
/******** typedefs ********/
/******* globals **********/

static struct {
	int tty;
	int wait;
	int quiet;
	int verbose;
	int trace;
    } opt ;

/****** prototypes ********/
static int Application( long dummy );
static void SetupClasses(void);
/******* Functions ********/

const char *CopyRight( int level )
{
    const char *p;
    switch( level ) {
      case 10:
      case 0:	p = "WAMTestApp - Ver. 0.00; "
		    "Copyright 1993 by Werner Koch (dd9jn)" ; break;
      case 14:	p = "0.00"; break;
      case 1:
      case 11:	p = "Usage: app [options]  (-h for help)";
		break;
      case 2:
      case 12:	p =
    "Syntax: app [options] \n\n"
    "This is a test application for the WAM-System\n"
    "Options summary:\n"
    " -q = quiet mode\n"
    " -v = verbose listing\n"
    " -t = trace messages\n"
    " -h = help\n";
	break;
      case 16:
      case 13:	p = "TestApp"; break;
      default: p = "?";
    }

    if( !level ) { puts( p ); putchar('\n'); }
    else if( level == 1 ) { fputs( p, stderr ); putc( '\n', stderr );exit(3);}
    else if( level == 2 ) {  /* help */ puts( p ); exit(0); }

    return p;
}


void main( int argc, char **argv )
{
    char *s;

    ErrorStream(stdout);
    setvbuf(stdout,NULL,_IOLBF,0);

    for( s=""; --argc && **++argv == '-' && *s != '-'; )
	for( s = *argv + 1 ; *s && *s != '-' ; s++ )
	    switch( *s ) {
	      case 'v': opt.verbose++; break;
	      case 'q': opt.quiet++; break;
	      case 't': opt.trace++; break;
	      case 'w': opt.wait++; break;
	      case 'h' :
	      case '?' : CopyRight(0) ; CopyRight(2); break;
	      default  : Error(3,GetStr(15),s );
	    }

    if( !opt.quiet ) {
	if( opt.tty = IsTerminal(0) )
	    setvbuf(stdout,NULL,_IONBF,0);
	CopyRight(0);
    }
    else
	opt.verbose = 0 ;

    WamInitialize();
    WamEnterProcess( Application, 0 );
    Bug("returned from WamEnterProcess()"); /*NOTREACHED*/
} /* end main() */



static int Application( long dummy )
{
    int rc;
    int cnt;

    SetupClasses();
    if( opt.trace )
	WamSetMessagerOption( 1, 1 );
    WamStartupGui();
    WamStartMessager( sym_ViewMain, sym_open );
    cnt = 0;
    while( !(rc = WamWaitForEvent()) )
	if( ++cnt > 100 )
	    break;
    if( rc != -1 )
	Error(0,"terminated due to error %d", rc );
    return 0;
}

static void SetupClasses(void)
{
    WamSUCStdClasses(); /* setup standard classes */
    WamSUC_FormLogon();
    WamSUC_ViewMain();
    WamSUC_FormTest();
    WamSUC_ViewTest();
    WamSUC_FormSQLWindow();
    WamSUC_ViewSQLWindow();
    WamSUCFinish();
}


/*** bottom of file ***/
