/*************************************************************
 *  
 *          I R I S P L O T   ---------- new2.c
 *
 *    Copyright (C) 1989 Maorong Zou
 *
 *************************************************************/

#include <stdio.h>
#include "plot.h"

extern int    c_token,num_tokens;
extern struct at_type *perm_at(), *unit_func_at;
extern struct udft_entry *dummy_func;
extern char   c_dummy_var[], c_dummy_var1[];
extern char   c_dummy_var2[],c_dummy_var3[];
extern struct value  *const_express();
extern double real();
extern struct a_graph    *c_graph;

char    *malloc();
static struct uaxes *parse_for_axies();
/************************************************************/

#define locate_an_udft_entry(fx)  if(! (fx = (struct udft_entry *)\
  malloc( (unsigned int) sizeof( struct udft_entry)))) \
  int_error("out of memory",-1)

#define locate_an_at_entry(att)  if( !((att) =  perm_at())) \
  int_error("out of memory",-1)			       

#define  IS_DUMMY if(equals(c_token,c_dummy_var ) || \
		     equals(c_token,c_dummy_var1) || \
		     equals(c_token,c_dummy_var2) || \
		     equals(c_token,c_dummy_var3))
/************************************************************/
eat_a_comma(t_num)
     int t_num;
{
  if(!equals(t_num, ",") && !equals(t_num,";"))
    int_error("need a ','",c_token);
}
/**************************************/
#define CGP   (c_graph->picture)

grab_variables(start)
     int start;
{
  int done = 0;
  c_token = start;

  if(!equals(c_token,"D") && !equals(c_token,"d"))
    int_error("need a 'D['",c_token);
  c_token++;
  if(!equals(c_token,"[")) int_error("need a 'D['",c_token);
  c_token++;
  if(!isletter(c_token))  int_error("Not a variable",c_token);
  m_capture( &(CGP.eqn.vname1), c_token, c_token); c_token++;
  eat_a_comma(c_token); c_token++;
  if(!isletter(c_token))  int_error("Not a variable",c_token);
  m_capture(&(CGP.eqn.vname4), c_token,c_token); c_token++;
  if(!equals(c_token,"]")) int_error("need a ']'",c_token);
  c_token++; 

  while( c_token <num_tokens && !equals(c_token,"}") &&
	!( (equals(c_token,"D")|| equals(c_token,"d")) 
	  && equals(c_token+1,"[")))
    c_token++;
  if(c_token >= num_tokens || equals(c_token,"}"))   return(1);
  c_token += 2;
  if(!isletter(c_token))  int_error("Not a variable",c_token);
  m_capture(&(CGP.eqn.vname2), c_token,c_token); c_token++;  
  eat_a_comma(c_token); c_token++;
  if(!equals(c_token, CGP.eqn.vname4))
    int_error("Oo... not an ODE", c_token);

  while( c_token <num_tokens && !equals(c_token,"}") &&
	!( (equals(c_token,"D")|| equals(c_token,"d")) 
	  && equals(c_token+1,"[")))
    c_token++;
  if(c_token >= num_tokens || equals(c_token,"}"))   return(2);

  c_token += 2;
  if(!isletter(c_token))  int_error("Not a variable",c_token);
  m_capture(&(CGP.eqn.vname3), c_token,c_token); c_token++;  
  eat_a_comma(c_token); c_token++;
  if(!equals(c_token, CGP.eqn.vname4))
    int_error("Oo... not an ODE", c_token);

  while( c_token <num_tokens && !equals(c_token,"}") &&
	!( (equals(c_token,"D")|| equals(c_token,"d")) 
	  && equals(c_token+1,"[")))
    c_token++;
  if(c_token >= num_tokens || equals(c_token,"}"))   return(3);

  c_token += 2;

  if(!isletter(c_token))  int_error("Not a variable",c_token);
  if(!equals(c_token+2, CGP.eqn.vname4))
    int_error("Oo... not an ODE", c_token);
  m_capture(&(CGP.eqn.vname4), c_token,c_token); c_token++;  
  
  return(4);
}
  
/************************************************************/

parse_ode()
{
  char *tmp_ch;
  register int ii, start_token;
  struct value a;
  
  (c_graph->picture).eqn.fx= (struct udft_entry *)NULL;
  (c_graph->picture).eqn.fy= (struct udft_entry *)NULL;
  (c_graph->picture).eqn.fz= (struct udft_entry *)NULL;
  (c_graph->picture).eqn.fw= (struct udft_entry *)NULL;
  (c_graph->picture).eqn.vname1 = (char *)NULL;
  (c_graph->picture).eqn.vname2= (char *)NULL;
  (c_graph->picture).eqn.vname3= (char *)NULL;
  (c_graph->picture).eqn.vname4 = (char *)NULL;
  (c_graph->picture).eqn.sample = EQNSAMPLE/2;
  (c_graph->picture).eqn.small  = EQNSMALL;
  (c_graph->picture).eqn.step =   10.0*EQNSTEP;
  (c_graph->picture).eqn.method = RK;
  (c_graph->picture).eqn.color = 0;
  (c_graph->picture).eqn.skip = 5;
  (c_graph->picture).eqn.dimension = 0;
  (c_graph->picture).eqn.start_time = 0.0;
  (c_graph->picture).eqn.end_time = 10.0;
  (c_graph->picture).eqn.x0 =  0.0;
  (c_graph->picture).eqn.y0 =  0.0;
  (c_graph->picture).eqn.z0 =  0.0;
  (c_graph->picture).eqn.w0 =  0.0;
  (c_graph->picture).eqn.x1 =  1.0;
  (c_graph->picture).eqn.y1 =  1.0;
  (c_graph->picture).eqn.z1 =  1.0;
  (c_graph->picture).eqn.w1 =  1.0;
  (c_graph->picture).eqn.orbit = 0;
  (c_graph->picture).eqn.xmn = -10.0;
  (c_graph->picture).eqn.xmx = 10.0;
  (c_graph->picture).eqn.ymn = -10.0;
  (c_graph->picture).eqn.ymx = 10.0;
  (c_graph->picture).eqn.xgrid = 30;
  (c_graph->picture).eqn.ygrid = 30;
  /*
   * added, for axes
   */
  (c_graph->picture).eqn.uaxes = (struct uaxes *)NULL;

  /* first grab the variables. Due to the internal structure
   * of variable handling, we have to do a backtracking here
   * to figure out the variables used.  Gnuplot use dummy_var 
   * which don't have the flexibity we need.
   */
  start_token = c_token;
  ii = grab_variables(start_token);
  if(ii == 1)
    {
      tmp_ch = CGP.eqn.vname1;
      CGP.eqn.vname1 = CGP.eqn.vname4;
      CGP.eqn.vname2 = tmp_ch;
      CGP.eqn.vname4 = (char *)0;
    }
  else if(ii == 2)
    {
      CGP.eqn.vname3 = CGP.eqn.vname4;
      CGP.eqn.vname4 = (char *)0;
    }

  if(CGP.eqn.vname1)
    strcpy(c_dummy_var,  CGP.eqn.vname1);
  if(CGP.eqn.vname2)
    strcpy(c_dummy_var1,  CGP.eqn.vname2);
  if(CGP.eqn.vname3)
    strcpy(c_dummy_var2,  CGP.eqn.vname3);
  if(CGP.eqn.vname4)
    strcpy(c_dummy_var3,  CGP.eqn.vname4);

  if(ii < 4)  CGP.eqn.dimension =ii + 1;
  else CGP.eqn.dimension = 4;
  /* in the case of 4 equations, it has to be an automous system 
   * only have 4 variables to deal with. If there are < 4 eqns,
   * add one more equation D[t,t]=1
   */

  c_token = start_token +6;
  if(!equals(c_token,"="))    int_error("need a '='",c_token);
  c_token++;
  locate_an_udft_entry( (c_graph->picture).eqn.fx );
  dummy_func = (c_graph->picture).eqn.fx;
  locate_an_at_entry( ( (c_graph->picture).eqn.fx)->at);
  if(ii == 1)
    {
      CGP.eqn.fy = CGP.eqn.fx;  /* switch fx and fy, fx is the time */
      locate_an_udft_entry( (c_graph->picture).eqn.fx ); 
      (CGP.eqn.fx)->at = unit_func_at;
      goto others;
    }
  if(equals(c_token,",") || equals(c_token,";")) c_token++;      
  
  c_token += 6;
  if(!equals(c_token,"="))    int_error("need a '='",c_token);
  c_token++;
  locate_an_udft_entry( (c_graph->picture).eqn.fy);
  locate_an_at_entry( ( (c_graph->picture).eqn.fy)->at);
  if(ii == 2)
    {
      locate_an_udft_entry( (c_graph->picture).eqn.fz ); 
      (CGP.eqn.fz)->at = unit_func_at;
      goto others;  
    }
  if(equals(c_token,",") || equals(c_token,";")) c_token++; 

  c_token += 6;
  if(!equals(c_token,"="))    int_error("need a '='",c_token);
  c_token++;
  locate_an_udft_entry( (c_graph->picture).eqn.fz);
  locate_an_at_entry( ( (c_graph->picture).eqn.fz)->at);
  if( ii == 3)
    {
      locate_an_udft_entry( (c_graph->picture).eqn.fw ); 
      (CGP.eqn.fw)->at = unit_func_at;
      goto others;
    }
  if(equals(c_token,",") || equals(c_token,";")) c_token++;      

  c_token += 6;
  if(!equals(c_token,"="))    int_error("need a '='",c_token);
  c_token++;
  locate_an_udft_entry( (c_graph->picture).eqn.fw);
  locate_an_at_entry( ( (c_graph->picture).eqn.fw)->at);

 others:
  c_token++;

  if(equals(c_token,",") )  c_token++;

  while(!equals(c_token,"}") && !END_OF_COMMAND)
    {
      if(!equals(c_token,"["))  
	int_error("need a '['",c_token);
      c_token++;
      if(almost_equals(c_token,"num$ber_of_steps"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.sample = 
	    (int) real(const_express(&a));
	  if( (c_graph->picture).eqn.sample < 10)
	    int_error("too few steps",c_token);
	}
      else if(almost_equals(c_token,"col$or"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.color = (int) real(const_express(&a));	  
	}
      else if(almost_equals(c_token,"meth$od"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.method =(int) real(const_express(&a));	  
	  if( (c_graph->picture).eqn.method != RK &&
	     (c_graph->picture).eqn.method != RKQC )
	    int_error("avaible methods: RK and RKQC",c_token);
	}
      else if(equals(c_token,"skip"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.skip =(int) real(const_express(&a));	  
	  if( ((c_graph->picture).eqn.skip) < 0)
	    int_error("need a positive integer",c_token);
	}
      else if(almost_equals(c_token,"ti$me"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.start_time = real(const_express(&a));	  
	  if(equals(c_token,",") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.end_time = real(const_express(&a));	  
	}
      else if(almost_equals(c_token,"sma$ll"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.small = real(const_express(&a));	  
	}
      else if(equals(c_token,"step"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.step = real(const_express(&a));	  
	}
      else if(almost_equals(c_token,"ini$tials"))
	{
	  ii = 0;
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  while(ii <  (c_graph->picture).eqn.dimension)
	    {
	      if(ii==0)
		(c_graph->picture).eqn.x0 =  real(const_express(&a));	 
	      else if(ii==1)
		(c_graph->picture).eqn.y0 =  real(const_express(&a));	 
	      else if(ii==2)
		(c_graph->picture).eqn.z0 =  real(const_express(&a));	 
	      else if(ii==3)
		(c_graph->picture).eqn.w0 =  real(const_express(&a));	 

	      if(equals(c_token,",") || equals(c_token,":")) c_token++;	
	      ii++;
	    }
	}
      else if(almost_equals(c_token,"sca$le"))
	{
	  ii = 0;
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  while(ii <  (c_graph->picture).eqn.dimension)
	    {
	      if(ii==0)
		(c_graph->picture).eqn.x1 =  real(const_express(&a));	 
	      else if(ii==1)
		(c_graph->picture).eqn.y1 =  real(const_express(&a));	 
	      else if(ii==2)
		(c_graph->picture).eqn.z1 =  real(const_express(&a));	 
	      else if(ii==3)
		(c_graph->picture).eqn.w1 =  real(const_express(&a));	 

	      if(equals(c_token,",") || equals(c_token,":")) c_token++;	
	      ii++;
	    }
	}
      /*
       * added stuff, for axes
       */ 
      else if(equals(c_token,"axes") || equals(c_token,"axis"))
	{
	  c_token++;
	  (c_graph->picture).eqn.uaxes = parse_for_axies();
	}
      if(!equals(c_token,"]")) 
	int_error("need a ']'",c_token);
      c_token++;
      if(equals(c_token,",") ) c_token++;
    }
  if(equals(c_token,"}")) c_token++;
}
/**********************************************************************************/
parse_eqn()
{
  register int ii;
  struct value a;

  (c_graph->picture).eqn.fx= (struct udft_entry *)NULL;
  (c_graph->picture).eqn.fy= (struct udft_entry *)NULL;
  (c_graph->picture).eqn.fz= (struct udft_entry *)NULL;
  (c_graph->picture).eqn.fw= (struct udft_entry *)NULL;
  (c_graph->picture).eqn.sample = EQNSAMPLE;
  (c_graph->picture).eqn.small  = EQNSMALL;
  (c_graph->picture).eqn.step =   EQNSTEP;
  (c_graph->picture).eqn.method = RK;
  (c_graph->picture).eqn.color = 0;
  (c_graph->picture).eqn.skip = 5;
  (c_graph->picture).eqn.dimension = 0;
  (c_graph->picture).eqn.start_time = 0.0;
  (c_graph->picture).eqn.end_time = 10.0;
  (c_graph->picture).eqn.x0 =  0.0;
  (c_graph->picture).eqn.y0 =  0.0;
  (c_graph->picture).eqn.z0 =  0.0;
  (c_graph->picture).eqn.w0 =  0.0;
  (c_graph->picture).eqn.x1 =  1.0;
  (c_graph->picture).eqn.y1 =  1.0;
  (c_graph->picture).eqn.z1 =  1.0;
  (c_graph->picture).eqn.w1 =  1.0;

  /*
   * added, for axes
   */
  (c_graph->picture).eqn.uaxes = (struct uaxes *)NULL;


  if(!equals(c_token,"["))
    int_error("need a '['",c_token);
  c_token++;
  locate_an_udft_entry( (c_graph->picture).eqn.fx );
  dummy_func = (c_graph->picture).eqn.fx;
  locate_an_at_entry( ( (c_graph->picture).eqn.fx)->at);
  if(equals(c_token,",") || equals(c_token,":")) c_token++;      
  if(equals(c_token, "]"))
    (c_graph->picture).eqn.dimension = 1;
  else
    {
      locate_an_udft_entry( (c_graph->picture).eqn.fy);
      locate_an_at_entry( ( (c_graph->picture).eqn.fy)->at);
      if(equals(c_token,",") || equals(c_token,":")) c_token++;      
      if(equals(c_token, "]"))
	(c_graph->picture).eqn.dimension = 2;
      else
	{
	  locate_an_udft_entry( (c_graph->picture).eqn.fz);
	  locate_an_at_entry( ( (c_graph->picture).eqn.fz)->at);
	  if(equals(c_token,",") || equals(c_token,":")) c_token++;      
	  if(equals(c_token, "]"))
	    (c_graph->picture).eqn.dimension = 3;
	  else
	    { 
	      locate_an_udft_entry( (c_graph->picture).eqn.fw);
	      locate_an_at_entry( ( (c_graph->picture).eqn.fw)->at);
	      (c_graph->picture).eqn.dimension = 4;	      
	      if(!equals(c_token,"]"))
		int_error("need a ']'",c_token);
	    }
	}
    }
  c_token++;

  if(equals(c_token,","))  c_token++;

  while(!equals(c_token,"}") && !END_OF_COMMAND)
    {
      if(!equals(c_token,"["))  
	int_error("need a '['",c_token);
      c_token++;
      if(almost_equals(c_token,"num$ber_of_steps"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.sample = 
	    (int) real(const_express(&a));
	  if( (c_graph->picture).eqn.sample < 10)
	    int_error("too few steps",c_token);
	}
      else if(almost_equals(c_token,"col$or"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.color = (int) real(const_express(&a));	  
	}
      else if(almost_equals(c_token,"meth$od"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.method =(int) real(const_express(&a));	  
	  if( (c_graph->picture).eqn.method != RK &&
	     (c_graph->picture).eqn.method != RKQC )
	    int_error("avaible methods: RK and RKQC",c_token);
	}
      else if(equals(c_token,"skip"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.skip =(int) real(const_express(&a));	  
	  if( ((c_graph->picture).eqn.skip) < 0)
	    int_error("need a positive integer",c_token);
	}
      else if(almost_equals(c_token,"ti$me"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.start_time = real(const_express(&a));	  
	  if(equals(c_token,",") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.end_time = real(const_express(&a));	  
	}
      else if(almost_equals(c_token,"sma$ll"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.small = real(const_express(&a));	  
	}
      else if(equals(c_token,"step"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).eqn.step = real(const_express(&a));	  
	}
      else if(almost_equals(c_token,"ini$tials"))
	{
	  ii = 0;
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  while(ii <  (c_graph->picture).eqn.dimension)
	    {
	      if(ii==0)
		(c_graph->picture).eqn.x0 =  real(const_express(&a));	 
	      else if(ii==1)
		(c_graph->picture).eqn.y0 =  real(const_express(&a));	 
	      else if(ii==2)
		(c_graph->picture).eqn.z0 =  real(const_express(&a));	 
	      else if(ii==3)
		(c_graph->picture).eqn.w0 =  real(const_express(&a));	 

	      if(equals(c_token,",") || equals(c_token,":")) c_token++;	
	      ii++;
	    }
	}
      else if(almost_equals(c_token,"sca$le"))
	{
	  ii = 0;
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  while(ii <  (c_graph->picture).eqn.dimension)
	    {
	      if(ii==0)
		(c_graph->picture).eqn.x1 =  real(const_express(&a));	 
	      else if(ii==1)
		(c_graph->picture).eqn.y1 =  real(const_express(&a));	 
	      else if(ii==2)
		(c_graph->picture).eqn.z1 =  real(const_express(&a));	 
	      else if(ii==3)
		(c_graph->picture).eqn.w1 =  real(const_express(&a));	 

	      if(equals(c_token,",") || equals(c_token,":")) c_token++;	
	      ii++;
	    }
	}
      /*
       * added stuff, for axes
       */ 
      else if(equals(c_token,"axes") || equals(c_token,"axis"))
	{
	  c_token++;
	  (c_graph->picture).eqn.uaxes = parse_for_axies();
	}
      if(!equals(c_token,"]")) 
	int_error("need a ']'",c_token);
      c_token++;
      if(equals(c_token,",") ) c_token++;
    }
  if(equals(c_token,"}")) c_token++;
}
/*******************************************************/

parse_surface()
{
  struct value a;
  int which_first = 0;

  (c_graph->picture).surface.fx= (struct udft_entry *)NULL;
  (c_graph->picture).surface.fy= (struct udft_entry *)NULL;
  (c_graph->picture).surface.fz= (struct udft_entry *)NULL;
  (c_graph->picture).surface.fr1= (struct udft_entry *)NULL;
  (c_graph->picture).surface.fr2= (struct udft_entry *)NULL;
  (c_graph->picture).surface.sample = SAMPLE;
  (c_graph->picture).surface.sample1 = SAMPLE;
  (c_graph->picture).surface.which_first = 1;
  (c_graph->picture).surface.is_function = 0;
  (c_graph->picture).surface.is_wire = 0;
  (c_graph->picture).surface.oren = 1;
  (c_graph->picture).surface.xmin = -4.0;
  (c_graph->picture).surface.ymin = -4.0;
  (c_graph->picture).surface.xmax =  4.0;
  (c_graph->picture).surface.ymax =  4.0;
  /*
   * added, for axes
   */
  (c_graph->picture).surface.uaxes = (struct uaxes *)NULL;

  if(!equals(c_token,"[")) 
    int_error("need a '['",c_token);
  c_token++;
  if(isstring(c_token))
    {
      c_graph->is_data = 1;
      quote_str(c_graph->data_file,c_token);
      c_token++;
      if(!equals(c_token,"]")) 
	int_error("need a ']'",c_token);
    }
  else
    {
      locate_an_udft_entry( (c_graph->picture).surface.fx );
      dummy_func = (c_graph->picture).surface.fx;
      locate_an_at_entry( ( (c_graph->picture).surface.fx)->at);
      if(equals(c_token, "]"))
	(c_graph->picture).surface.is_function = 1;
      else
	{
	  if(equals(c_token,",") || equals(c_token,":")) c_token++; 
	  locate_an_udft_entry( (c_graph->picture).surface.fy);
	  locate_an_at_entry( ( (c_graph->picture).surface.fy)->at);
	  if(equals(c_token,",") || equals(c_token,":")) c_token++; 
	  locate_an_udft_entry( (c_graph->picture).surface.fz);
	  locate_an_at_entry( ( (c_graph->picture).surface.fz)->at);
	  if(!equals(c_token,"]"))
	    int_error("need a ']'",c_token);
	}
    }
  c_token++;

  if(equals(c_token,","))  c_token++;

  while(!equals(c_token,"}") && !END_OF_COMMAND)
    {
      if(!equals(c_token,"["))  
	int_error("need a '['",c_token);
      c_token++;
      if(almost_equals(c_token,"samp$les"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).surface.sample = 
	    (int) real(const_express(&a));
	  if(equals(c_token,":") || equals(c_token,",")) c_token++;
	  (c_graph->picture).surface.sample1 = 
	    (int) real(const_express(&a));
	  if(c_graph->is_data)
	    {
	      if( ((c_graph->picture).surface.sample) < 4 ||
		 ((c_graph->picture).surface.sample1) < 4)
		int_error("sample rate too small",c_token);
	    }
	  else
	    {
	      if( ((c_graph->picture).surface.sample) < 4 ||
		 ((c_graph->picture).surface.sample1) < 4)
		int_error("sample rate too small",c_token);
	    }
	}
      else if(almost_equals(c_token,"wire$frame"))
	{
	  c_token++;
	  if( equals(c_token,"=") || equals(c_token,":")) c_token++;
	  if(equals(c_token,"false")||equals(c_token,"FALSE")) c_token++;
	  if(equals(c_token,"true")||equals(c_token,"TRUE"))
	    {
	      c_token++;
	      (c_graph->picture).surface.is_wire = 1;
	    } 
	}
      else if(almost_equals(c_token,"orien$tation"))
	{
	  c_token++;
	  if( equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).surface.oren = 
	    (int) real(const_express(&a));
	}
      else if(almost_equals(c_token,"data_ch$eck") ||
	      almost_equals(c_token,"check$_data") )
	{
	  c_token++;
	  if( equals(c_token,"=") || equals(c_token,":")) c_token++;
	  if(equals(c_token,"true")||equals(c_token,"TRUE")) c_token++;
	  if(equals(c_token,"false")||equals(c_token,"FALSE")) 
	    {
	      c_token++;
	      c_graph->data_check = 0;
	    }	  
	}
      /*
       * added stuff, for axes
       */ 
      else if(equals(c_token,"axes") || equals(c_token,"axis"))
	{
	  c_token++;
	  (c_graph->picture).surface.uaxes = parse_for_axies();
	}
      else if(isletter(c_token))
	{
	  if(equals(c_token,c_dummy_var))
	    {
	      c_token++;
	      if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	      if(!which_first) 
		{
		  which_first = 1;
		  (c_graph->picture).surface.xmin = 
		    real(const_express(&a));
		  if(equals(c_token,":") || equals(c_token,",")) c_token++;
		  (c_graph->picture).surface.xmax =
		    real(const_express(&a));
		}
	      else
		{
		  locate_an_udft_entry( (c_graph->picture).surface.fr1 );
		  locate_an_at_entry( ( (c_graph->picture).surface.fr1)->at);
		  if(equals(c_token,":") || equals(c_token,",")) c_token++;
		  locate_an_udft_entry( (c_graph->picture).surface.fr2 );
		  locate_an_at_entry( ( (c_graph->picture).surface.fr2)->at);
		}
	      if(equals(c_token,",")) c_token++;
	    }
	  else  if(equals(c_token,c_dummy_var1))
	    {
	      c_token++;
	      if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	      if(!which_first) 
		{
		  which_first = 1;
		  (c_graph->picture).surface.which_first = 2;
		  (c_graph->picture).surface.ymin = 
		    real(const_express(&a));
		  if(equals(c_token,":") || equals(c_token,",")) c_token++;
		  (c_graph->picture).surface.ymax =
		    real(const_express(&a));
		}
	      else
		{
		  locate_an_udft_entry( (c_graph->picture).surface.fr1 );
		  locate_an_at_entry( ( (c_graph->picture).surface.fr1)->at);
		  if(equals(c_token,":") || equals(c_token,",")) c_token++;
		  locate_an_udft_entry( (c_graph->picture).surface.fr2 );
		  locate_an_at_entry( ( (c_graph->picture).surface.fr2)->at);
		}
	      if(equals(c_token,",")) c_token++;
	    }  
	  else
	    int_error("unkown attributes",c_token);
	}
      if(!equals(c_token,"]")) 
	    int_error("need a ']'",c_token);
      c_token++;
      if(equals(c_token,",") ) c_token++;
    }
  if(equals(c_token,"}")) c_token++;
}
/*******************************************************/

parse_curve()
{
  struct value a;

  (c_graph->picture).curve.fx= (struct udft_entry *)NULL;
  (c_graph->picture).curve.fy= (struct udft_entry *)NULL;
  (c_graph->picture).curve.fz= (struct udft_entry *)NULL;
  (c_graph->picture).curve.sample = CURVESAMPLE;
  (c_graph->picture).curve.sample1 = 1;
  (c_graph->picture).curve.color = 0;
  (c_graph->picture).curve.style = 0;
  (c_graph->picture).curve.xmin = -4.0;
  (c_graph->picture).curve.xmax =  4.0;

  /*
   * added, for axes
   */
  (c_graph->picture).curve.uaxes = (struct uaxes *)NULL;

  if(!equals(c_token,"["))
	    int_error("need a '['",c_token);
  c_token++;  
  if(isstring(c_token))
    {
      c_graph->is_data = 1;
      quote_str(c_graph->data_file,c_token);
      c_token++;
    }
  else
    {
      locate_an_udft_entry( (c_graph->picture).curve.fx );
      dummy_func = (c_graph->picture).curve.fx;
      locate_an_at_entry( ( (c_graph->picture).curve.fx)->at);
      if(equals(c_token,",") || equals(c_token,":")) c_token++;      
      locate_an_udft_entry( (c_graph->picture).curve.fy);
      locate_an_at_entry( ( (c_graph->picture).curve.fy)->at);
      if(equals(c_token,",") || equals(c_token,":")) c_token++;      
      locate_an_udft_entry( (c_graph->picture).curve.fz);
      locate_an_at_entry( ( (c_graph->picture).curve.fz)->at);
    }
  if(!equals(c_token,"]"))
    int_error("need a ']'",c_token);
  c_token++;

  if(equals(c_token,","))  c_token++;

  while(!equals(c_token,"}") && !END_OF_COMMAND)
    {
      if(!equals(c_token,"["))  
	int_error("need a '['",c_token);
      c_token++;
      if(almost_equals(c_token,"samp$les"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).curve.sample = 
	    (int) real(const_express(&a));
	  if( (c_graph->picture).curve.sample < 2)
	    int_error("sample rate too small",c_token);
	  if(equals(c_token,",") || equals(c_token,":")) c_token++;
	  if( (c_graph->is_data) && !equals(c_token,"]")) {
	    (c_graph->picture).curve.sample1 =
	      (c_graph->picture).curve.sample;
	    (c_graph->picture).curve.sample =   
	      (int) real(const_express(&a));
	  if( (c_graph->picture).curve.sample < 1)
	    int_error("sample rate too small",c_token); }
	}
      else if(almost_equals(c_token,"sty$le"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).curve.style =
	    (int) real(const_express(&a)); 
	}
      else if(almost_equals(c_token,"col$or"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).curve.color =
	    (int) real(const_express(&a)); 
	}
      else if(almost_equals(c_token,"data_ch$eck") ||
	      almost_equals(c_token,"check$_data") )
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  if(equals(c_token,"true")||equals(c_token,"TRUE")) c_token++;
	  if(equals(c_token,"false")||equals(c_token,"FALSE")) 
	    {
	      c_token++;
	      c_graph->data_check = 0;
	    }	  
	}
      /*
       * added stuff, for axes
       */ 
      else if(equals(c_token,"axes") || equals(c_token,"axis"))
	{
	  c_token++;
	  (c_graph->picture).curve.uaxes = parse_for_axies();
	}
      else if(isletter(c_token))
	{
	  copy_str(c_dummy_var,c_token++);
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).curve.xmin =
	    real( const_express(&a));	  
	  if(equals(c_token,",") || equals(c_token,":")) c_token++;
	  (c_graph->picture).curve.xmax =
	    real( const_express(&a));	  
	}
      if(!equals(c_token,"]"))
	int_error("need a ']'",c_token);
      c_token++;
      if(equals(c_token,",") ) c_token++;
    }
  if(equals(c_token,"}")) c_token++;
}
/*******************************************************/
#ifdef HAVE_F77
parse_contour()
{
  register int value_count;
  struct value a;
  
  (c_graph->picture).contour.fx= (struct udft_entry *)NULL;
  (c_graph->picture).contour.sample = SAMPLE;
  (c_graph->picture).contour.sample1 = SAMPLE;
  (c_graph->picture).contour.threed = 0;
  (c_graph->picture).contour.n_cs = 10;
  (c_graph->picture).contour.nconts = (int **)NULL;
  (c_graph->picture).contour.c_vs =
    (double *)malloc((unsigned int) 10 * sizeof(double));
  for(value_count = 0; value_count < 10; value_count++)
    *(  (c_graph->picture).contour.c_vs + value_count) = BADVALUE;
  (c_graph->picture).contour.xmin = -4.0;
  (c_graph->picture).contour.xmax =  4.0;
  (c_graph->picture).contour.ymin = -4.0;
  (c_graph->picture).contour.ymax =  4.0;
  /*
   * added, for axes
   */
  (c_graph->picture).contour.uaxes = (struct uaxes *)NULL;

  value_count = 0;

  if(!equals(c_token,"[")) 
    int_error("need a '['",c_token);
  c_token++;  
  if(isstring(c_token))
    {
      c_graph->is_data = 1;
      quote_str(c_graph->data_file,c_token);
      c_token++;
    }
  else
    {
      locate_an_udft_entry( (c_graph->picture).contour.fx );
      dummy_func = (c_graph->picture).contour.fx;
      locate_an_at_entry( ( (c_graph->picture).contour.fx)->at);
    }
  if(!equals(c_token,"]"))
    int_error("need a ']'",c_token);
  c_token++;
  
  if(equals(c_token,","))  c_token++;

  while(!equals(c_token,"}") && !END_OF_COMMAND)
    {
      if(!equals(c_token,"[")) 
    int_error("need a '['",c_token);
      c_token++;

      if(almost_equals(c_token,"samp$les"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).contour.sample = 
	    (int) real(const_express(&a));
	  if(equals(c_token,":") || equals(c_token,",")) c_token++;
	  (c_graph->picture).contour.sample1 = 
	    (int) real(const_express(&a));
	  if (((c_graph->picture).contour.sample) < 3 ||
	      ((c_graph->picture).contour.sample1) < 3)
	    int_error("sample rate too small",c_token); 
	}
      else if(almost_equals(c_token,"three$d"))
	{
	  c_token++;
	  (c_graph->picture).contour.threed = 1;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  if(equals(c_token,"true")||equals(c_token,"TRUE")) c_token++;
	  if(equals(c_token,"false")||equals(c_token,"FALSE")) 
	    {
	      c_token++;
	      (c_graph->picture).contour.threed = 0;
	    }	  
	}
      else if(almost_equals(c_token,"num$ber_of_contours"))
	{
	  c_token++;
	  if( equals(c_token,"=") || equals(c_token,":") ) c_token++;
	  (c_graph->picture).contour.n_cs =
	    (int) real(const_express(&a));
	  if( (c_graph->picture).contour.n_cs < 1)
	    int_error("need a positive integer",c_token);
	  if( (c_graph->picture).contour.c_vs )
	    (void) free ( (char *) (c_graph->picture).contour.c_vs );
	  (c_graph->picture).contour.c_vs = (double *)
	    malloc( (unsigned int) ( (c_graph->picture).contour.n_cs)
		   * sizeof(double));
	  for(value_count = 0; value_count <
	      (c_graph->picture).contour.n_cs; value_count++)
	    *( (c_graph->picture).contour.c_vs +value_count) = BADVALUE;
	}
      else if(almost_equals(c_token,"cont$our_values"))
	{
	  c_token++;
	  if( equals(c_token,"=") || equals(c_token,":") ) c_token++;

	  value_count = 0;
	  while( !equals(c_token,"]") && value_count <
		(c_graph->picture).contour.n_cs  && !END_OF_COMMAND)
	    {
	      if(equals(c_token,",") || equals(c_token,":")) c_token++;
	      *( ( (c_graph->picture).contour.c_vs + value_count)) =
		real(const_express(&a)); 
	    }
	}
      else if(almost_equals(c_token,"data_ch$eck") ||
	      almost_equals(c_token,"check$_data") )
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  if(equals(c_token,"true")||equals(c_token,"TRUE")) c_token++;
	  if(equals(c_token,"false")||equals(c_token,"FALSE")) 
	    {
	      c_token++;
	      c_graph->data_check = 0;
	    }	  
	}
      /*
       * added stuff, for axes
       */ 
      else if(equals(c_token,"axes") || equals(c_token,"axis"))
	{
	  c_token++;
	  (c_graph->picture).contour.uaxes = parse_for_axies();
	}
      else if(isletter(c_token))
	{
	  if(equals(c_token,c_dummy_var))
	    {
	      c_token++;
	      if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	      (c_graph->picture).contour.xmin = 
		real(const_express(&a));	  
	      if(equals(c_token,",") || equals(c_token,":")) c_token++;
	      (c_graph->picture).contour.xmax = 
		real(const_express(&a));	  
	    }
	  else if(equals(c_token,c_dummy_var1))
	    {
	      c_token++;
	      if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	      (c_graph->picture).contour.ymin = 
		real(const_express(&a));	  
	      if(equals(c_token,",") || equals(c_token,":")) c_token++;
	      (c_graph->picture).contour.ymax = 
		real(const_express(&a));	  
	    }
	  else
	    int_error("unkown attributes",c_token);
	}
      if(!equals(c_token,"]")) 
    int_error("need a ']'",c_token);
      c_token++;
      if(equals(c_token,",") ) c_token++;
    }
  if(equals(c_token,"}")) c_token++;
}
#endif
/*******************************************************/

parse_map()
{
  register int ii;
  struct value a;

  (c_graph->picture).map.fx= (struct udft_entry *)NULL;
  (c_graph->picture).map.fy= (struct udft_entry *)NULL;
  (c_graph->picture).map.fz= (struct udft_entry *)NULL;
  (c_graph->picture).map.fw= (struct udft_entry *)NULL;
  (c_graph->picture).map.sample = MAPSAMPLE;
  (c_graph->picture).map.color = 0;
  (c_graph->picture).map.dimension = 0;
  (c_graph->picture).map.x0 = -0.0;
  (c_graph->picture).map.y0 = -0.0;
  (c_graph->picture).map.z0 =  0.0;
  (c_graph->picture).map.w0 =  0.0;
  /*
   * added, for axes
   */
  (c_graph->picture).map.uaxes = (struct uaxes *)NULL;

  if(!equals(c_token,"[")) 
    int_error("need a '['",c_token);
  c_token++;
  locate_an_udft_entry( (c_graph->picture).map.fx );
  dummy_func = (c_graph->picture).map.fx;
  locate_an_at_entry( ( (c_graph->picture).map.fx)->at);
  if(equals(c_token,",") || equals(c_token,":")) c_token++;      
  if(equals(c_token, "]"))
    (c_graph->picture).map.dimension = 1;
  else
    {
      locate_an_udft_entry( (c_graph->picture).map.fy);
      locate_an_at_entry( ( (c_graph->picture).map.fy)->at);
      if(equals(c_token,",") || equals(c_token,":")) c_token++;      
      if(equals(c_token, "]"))
	(c_graph->picture).map.dimension = 2;
      else
	{
	  locate_an_udft_entry( (c_graph->picture).map.fz);
	  locate_an_at_entry( ( (c_graph->picture).map.fz)->at);
	  if(equals(c_token,",") || equals(c_token,":")) c_token++;      
	  if(equals(c_token, "]"))
	    (c_graph->picture).map.dimension = 3;
	  else
	    { 
	      locate_an_udft_entry( (c_graph->picture).map.fw);
	      locate_an_at_entry( ( (c_graph->picture).map.fw)->at);
	      (c_graph->picture).map.dimension = 4;	      
	      if(!equals(c_token,"]")) 
		int_error("need a ']'",c_token);
	    }
	}
    }
  c_token++;

  if(equals(c_token,","))  c_token++;

  while(!equals(c_token,"}") && !END_OF_COMMAND)
    {
      if(!equals(c_token,"["))  
	int_error("need a '['",c_token);
      c_token++;
      if(almost_equals(c_token,"iter$ates"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).map.sample = 
	    (int) real(const_express(&a));
	  if( (c_graph->picture).map.sample < 10)
	    int_error("iterate must > 10",c_token);
	}
      else if(almost_equals(c_token,"col$or"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).map.color = (int) real(const_express(&a));	  
	}
      else if(almost_equals(c_token,"ini$tials"))
	{
	  ii = 0;
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  while(ii <  (c_graph->picture).map.dimension)
	    {
	      if(ii==0)
		(c_graph->picture).map.x0 =  real(const_express(&a));	 
	      else if(ii==1)
		(c_graph->picture).map.y0 =  real(const_express(&a));	 
	      else if(ii==2)
		(c_graph->picture).map.z0 =  real(const_express(&a));	 
	      else if(ii==3)
		(c_graph->picture).map.w0 =  real(const_express(&a));	 
	      if(equals(c_token,",") || equals(c_token,":")) c_token++;	
	      ii++;
	    }
	}
      /*
       * added stuff, for axes
       */ 
      else if(equals(c_token,"axes") || equals(c_token,"axis"))
	{
	  c_token++;
	  (c_graph->picture).map.uaxes = parse_for_axies();
	}
      if(!equals(c_token,"]")) 
	int_error("need a ']'",c_token);	
      c_token++;
      if(equals(c_token,",") ) c_token++;
    }
  if(equals(c_token,"}")) c_token++;
}
/*******************************************************/

parse_tmesh()
{
  struct value a;

  (c_graph->picture).tmesh.sample = SAMPLE;
  (c_graph->picture).tmesh.sample1 = SAMPLE;
  (c_graph->picture).tmesh.oren = 1;
  /*
   * added, for axes
   */
  (c_graph->picture).tmesh.uaxes = (struct uaxes *)NULL;


  if(!equals(c_token,"["))
    int_error("need a '['",c_token);
  c_token++;

  if(!isstring(c_token))
    int_error("file name in quotes expected",c_token);
  c_graph->is_data = 1;
  quote_str(c_graph->data_file,c_token);
  c_token++;
  if(!equals(c_token,"]"))
    int_error("need a ']'",c_token);

  c_token++;
  if(equals(c_token,","))  c_token++;
  while(!equals(c_token,"}") && !END_OF_COMMAND)
    {
      if(!equals(c_token,"["))  
	int_error("need a '['",c_token);
      c_token++;
      if(almost_equals(c_token,"samp$les"))
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).tmesh.sample = 
	    (int) real(const_express(&a));
	  if(equals(c_token,",") || equals(c_token,":")) c_token++;
	  (c_graph->picture).tmesh.sample1 = 
	    (int) real(const_express(&a));
	  if( (c_graph->picture).tmesh.sample < 1 ||
	     (c_graph->picture).tmesh.sample1 < 3)
	    int_error("need at least 3 vertices for a t-mesh",c_token);
	  if( (c_graph->picture).tmesh.sample1 > 255)
	    int_error("Too many vertices for t-mesh (should < 256)",c_token);
	}
      else if(almost_equals(c_token,"orien$"))
	{
	  c_token++;
	  if( equals(c_token,"=") || equals(c_token,":")) c_token++;
	  (c_graph->picture).tmesh.oren = 
	    (int) real(const_express(&a));
	}
      else if(almost_equals(c_token,"data_ch$eck") ||
	      almost_equals(c_token,"check$_data") )
	{
	  c_token++;
	  if(equals(c_token,"=") || equals(c_token,":")) c_token++;
	  if(equals(c_token,"true")||equals(c_token,"TRUE")) c_token++;
	  if(equals(c_token,"false")||equals(c_token,"FALSE")) 
	    {
	      c_token++;
	      c_graph->data_check = 0;
	    }	  
	}
      /*
       * added stuff, for axes
       */ 
      else if(equals(c_token,"axes") || equals(c_token,"axis"))
	{
	  c_token++;
	  (c_graph->picture).tmesh.uaxes = parse_for_axies();
	}
      if(!equals(c_token,"]")) 
	int_error("need a ']'",c_token);
      c_token++;
      if(equals(c_token,",") ) c_token++;
    }
  if(equals(c_token,"}")) c_token++;
}
/*******************************************************/
static struct uaxes *parse_for_axies()
{
  struct uaxes *tmp;
  struct value a;

  tmp = (struct uaxes *)malloc( sizeof(struct uaxes));
  tmp->ox = 0.0;   tmp->oy = 0.0;   tmp->oz = 0.0;
  tmp->xx = 0.0;   tmp->xy = 0.0;   tmp->xz = 0.0;
  tmp->yx = 0.0;   tmp->yy = 0.0;   tmp->yz = 0.0;
  tmp->zx = 0.0;   tmp->zy = 0.0;   tmp->zz = 0.0;
  tmp->ticmarks = 20;
  if(equals(c_token,":") || equals(c_token,",")) c_token++ ;
  if(equals(c_token,"on") || almost_equals(c_token,"auto$matic"))
    c_token++;
  while( !equals(c_token,"]"))
    {
      if(almost_equals(c_token,"o$rigin")) 
	{
	  c_token++;
	  if(equals(c_token,":") || equals(c_token,"="))
	    c_token++;
	  if(!equals(c_token, "(") )
	    int_error("Need a '(' ", c_token);
	  c_token++;
	  tmp->ox = real(const_express(&a));
	  if(equals(c_token,",")) c_token++;
	  tmp->oy = real(const_express(&a));
	  if(equals(c_token,",")) c_token++;
	  tmp->oz = real(const_express(&a));
	  if(!equals(c_token,")") )
	    int_error("Need a ')' ", c_token);
	  c_token++;
	}
      else if(equals(c_token,"x") || equals(c_token,"X"))
	{
	  c_token++;
	  if(equals(c_token,":") || equals(c_token,"="))
	    c_token++;
	  if(!equals(c_token, "(") )
	    int_error("Need a '(' ", c_token);
	  c_token++;
	  tmp->xx = real(const_express(&a));
	  if(equals(c_token,",")) c_token++;
	  tmp->xy = real(const_express(&a));
	  if(equals(c_token,",")) c_token++;
	  tmp->xz = real(const_express(&a));
	  if(!equals(c_token,")") )
	    int_error("Need a ')' ", c_token);
	  c_token++;
	}
      else if(equals(c_token,"y") || equals(c_token,"Y"))
	{
	  c_token++;
	  if(equals(c_token,":") || equals(c_token,"="))
	    c_token++;
	  if(!equals(c_token, "(") )
	    int_error("Need a '(' ", c_token);
	  c_token++;
	  tmp->yx = real(const_express(&a));
	  if(equals(c_token,",")) c_token++;
	  tmp->yy = real(const_express(&a));
	  if(equals(c_token,",")) c_token++;
	  tmp->yz = real(const_express(&a));
	  if(!equals(c_token,")") )
	    int_error("Need a ')' ", c_token);
	  c_token++;
	}
      else if(equals(c_token,"z") || equals(c_token,"Z"))
	{
	  c_token++;
	  if(equals(c_token,":") || equals(c_token,"="))
	    c_token++;
	  if(!equals(c_token, "(") )
	    int_error("Need a '(' ", c_token);
	  c_token++;
	  tmp->zx = real(const_express(&a));
	  if(equals(c_token,",")) c_token++;
	  tmp->zy = real(const_express(&a));
	  if(equals(c_token,",")) c_token++;
	  tmp->zz = real(const_express(&a));
	  if(!equals(c_token,")") )
	    int_error("Need a ')' ", c_token);
	  c_token++;
	}
      else if(almost_equals(c_token,"tic$marks"))
	{
	  c_token++;
	  if(equals(c_token,":") || equals(c_token,"="))
	    c_token++;
	  tmp->ticmarks = (int)real(const_express(&a));
	}
      if(equals(c_token,",")) c_token++;
    }
  return(tmp);
}
/*******************************************************/
