/*************************************************************
 *  
 *          I R I S P L O T   ---------- gplot.c
 *
 *    Copyright (C) 1989 Maorong Zou
 *
 *************************************************************/

#include <stdio.h>
#include <gl.h>
#include <math.h>
#include "graph.h"
#include "graph1.h"
#define max(x,y)  ( (x) > (y) ? (x) : (y))
#define ABS(x)  ((x)>0?(x):(-(x)))

extern int  depth_color[6];
extern Flag flag;
extern  float  sizze;

extern int base_box;
extern int show_wire;
extern struct an_object *objects;
extern struct a_graph  *graph;
extern int obj_table[];
extern float *material_table;
extern int   num_graphs;
extern char  *m_string[];
extern oview pview;

/**************************************************************/

static float npx[3], nnx[3],npy[3],nny[3],nnz[3];
static int show_normal = 0;
static int old_light = 1,color_mode = 0;
static struct an_object *c_object;
static float normal_size;
void   draw_obj();
void   pre_ini();

/**************************************************************/

main()
{
  set_base_data(1);
  initialize();
  read_attr();
  read_data();
  set_config();
  graphic_manager(pre_ini,draw_obj,(&pview),obj_table,material_table,m_string);
}
/****************************************************************************/

/*
 * pre_int() finds the pre_MODELING actions in the object definitions
 * and pre_load them on the matrix stack. Note that these tokens has
 * to be on top of the action stack.
 */
void pre_ini()
{
  extern int obj_index;
  register int nn;
  float x,y,z;
  
  c_object = objects;
  while( c_object)
    {
      nn = 0;
      while( nn < c_object->num_action)
	{
	  if( ( *(c_object->actions+nn)) == (float)PRETRANSLATION)
	    {
	      x =  *(c_object->actions+nn+1);
	      y = *(c_object->actions+nn+2);
	      z = *(c_object->actions+nn+3);
	      do_translate(x,y,z);
	      nn += 4;
	    }
	  else if( ( *(c_object->actions+nn)) == (float)PREROTATION)
	    {
	      x = *(c_object->actions+nn+1);
	      y = *(c_object->actions+nn+2);
	      z = *(c_object->actions+nn+3);
	      do_rotate((short)x,(short)y, (short)z);
	      nn += 4;
	    }
	  else if(  ( *(c_object->actions+nn)) == (float)PRESCALING)
	    {
	      x = *(c_object->actions+nn+1);
	      y = *(c_object->actions+nn+2);
	      z = *(c_object->actions+nn+3);
	      do_scale(x,y,z);
	      nn += 4;
	    }
	  else
	    break;
	}
      obj_index++;
      c_object = c_object->next;
    }
  obj_index = 0;
}
/************************************************************/

/*
 * draw_obj() is the actual plot function. 
 */
void draw_obj()
{
  register int nn,kkk;
  
  /*
   * if lighting is just oggled off or on, recalculate the appropriate
   * attributs. e.g. vertex normal, color ...
   */
  if(old_light != flag.light)
    {
      set_base_data(flag.light);
      
      /*
       * light is toggled on, if old color_mode is not 0
       * set it to 0
       */
      if(color_mode && flag.light)
	{
	  for(nn = 0; nn < num_graphs;nn++)
	    {
	      if(graph[nn].type == SURFACE)
		toggle_color_mode(nn,color_mode,1);
	      else if(graph[nn].type == TMESH)
		toggle_color_mode_tmesh(nn,color_mode,1);
	    }
	  color_mode = 0;
	  flag.random_color = 0;
	}
      /*
       * light is toggled on, recalculate the normals
       */
      for(nn = 0; nn < num_graphs;nn++)
	{
	  if(graph[nn].type == SURFACE)
	    compute_normal(nn,flag.light);
	  else if(graph[nn].type == TMESH)
	    compute_normal_tmesh(nn,flag.light);
	}
      old_light = flag.light;
    }

  /*
   * if light is off and color_mode is reset, recalculate
   * color for each vertex by first set color_mode to 0 
   * then set it to random_color.
   */
  if( !flag.light && (color_mode != flag.random_color))
    {
      if(color_mode)
	{
	  for(nn = 0; nn < num_graphs;nn++)
	    {
	      if(graph[nn].type == SURFACE)
		toggle_color_mode(nn,color_mode,1);
	      else if(graph[nn].type == TMESH)
		toggle_color_mode_tmesh(nn,color_mode,1);
	    }      
	}
      color_mode = flag.random_color;
      for(nn = 0; nn < num_graphs;nn++)
	{
	  if(graph[nn].type == SURFACE)
	    toggle_color_mode(nn,color_mode,0);
	  else  if(graph[nn].type == TMESH)
	    toggle_color_mode_tmesh(nn,color_mode,0);
	}
    }
  
  /*
   *  begin plotting
   */
  c_object = objects;
  while( c_object)
    {
      if( bgnobj())   /*       object is visiable  */
	{
	  nn = 0;
	  while( nn < c_object->num_action)
	    {
	      /*
	       * we didn't use 'else if' here in order to 
	       * speed up a litle bit if actions are properly
	       * set.
	       */
	      if( ( *(c_object->actions+nn)) == (float)BMATERIAL)
		{ 
		  nn + = 2;
		  bgnmaterial(); 
		}
	      if( ( *(c_object->actions+nn)) == (float)GRAPH)
		{
		  nn++; 
		  kkk = ((int)(*(c_object->actions + nn)));
		  if(graph[kkk].type == SURFACE || graph[kkk].type == CURVE)
		    draw_surface_curve(kkk);
		  else
		    draw_picture(kkk);
		  nn++;
		}
	      if( ( *(c_object->actions+nn)) == (float) PUSHMATRIX)
		{
		  pushmatrix();
		  nn++;
		}
	      if( (*(c_object->actions+nn)) == (float)POPMATRIX)
		{
		  popmatrix();
		  nn++;
		}
	      if( (*(c_object->actions+nn)) == (float)TRANSLATE)
		{
		  nn++;
		  translate( *(c_object->actions+nn),
			    *(c_object->actions+nn+1),
			    *(c_object->actions+nn+2));
		  nn += 3;
		}
	      if( (*(c_object->actions+nn)) == (float)SCALE)
		{
		  scale( (*(c_object->actions+nn+1)),
			(*(c_object->actions+nn+2)),
			(*(c_object->actions+nn+3)));
		  nn += 4;
		}
	      if( (*(c_object->actions+nn)) == (float)ROTATEX)
		{ 
		  rotate(((short) (*(c_object->actions+nn+1))),'x');
		  nn += 2;
		}
	      if((*(c_object->actions+nn)) == (float)ROTATEY)
		{ 
		  nn++;
		  rotate(((short) (*(c_object->actions+nn))),'y');
		  nn++;
		}
	      if(( *(c_object->actions+nn)) == (float)ROTATEZ)
		{ 
		  nn++;
		  rotate(((short) (*(c_object->actions+nn))),'z');
		  nn++;
		}
	      if(( *(c_object->actions+nn)) == (float)TRANSPARANT)
		{
		  nn++;
		  bgntransparent();
		}
	      if(( *(c_object->actions+nn)) == (float)OBLIQUE)
		{
		  nn++;
		  endtransparent();
		}
	      if( ( *(c_object->actions+nn)) == (float)PRETRANSLATION
		 ||  ( *(c_object->actions+nn)) == (float)PREROTATION
		 ||  ( *(c_object->actions+nn)) == (float)PRESCALING)
		nn += 4;
	    }
	}
      endobj();
      c_object = c_object->next;
    }
}
/*****************************************************************/

#define BGNPOLYGON()  if(!(graph[ii].picture.surface.is_wire)\
  && !show_wire)  bgnpolygon(); else bgnline()
#define ENDPOLYGON()  if(!(graph[ii].picture.surface.is_wire) \
  && !show_wire)   endpolygon(); else endline()

/**************************************************************/

/*
 * We write almost identical code here for different situations
 * to reduce the number of if tests
 */
draw_picture(ii)
     int ii;
{
  int i,j,k,mm,l;
  struct uaxes *axes;
  float ***sx,***snx;

  if(graph[ii].type == TMESH)
    {
      axes = graph[ii].picture.tmesh.uaxes;
      sx = graph[ii].picture.tmesh.sx;
      snx = graph[ii].picture.tmesh.snx;
      if(flag.light)
	{
	  for(i = 0; i < graph[ii].picture.tmesh.sample; i++)
	    {
	      bgntmesh();
	      for(j = 0; j < graph[ii].picture.tmesh.sample1 ; j++)    
		{
		  n3f(snx[i][j]);
		  v3f(sx[i][j]);
		}
	      endtmesh();
	    }
	}
      else if(!flag.depthcue)
	{
	  for(i = 0; i < graph[ii].picture.tmesh.sample; i++)
	    {
	      bgntmesh();
	      for(j = 0; j < graph[ii].picture.tmesh.sample1 ; j++)    
		{
		  c3f(snx[i][j]);
		  v3f(sx[i][j]);
		}
	      endtmesh();
	    }
	}
      else
	{
	  for(i = 0; i < graph[ii].picture.tmesh.sample; i++)
	    {
	      bgntmesh();
	      for(j = 0; j < graph[ii].picture.tmesh.sample1 ; j++)    
		v3f(sx[i][j]);
	      endtmesh();
	    }
	}

      if(show_normal && flag.light)
	{
	  for(i = 0; i < graph[ii].picture.tmesh.sample; i++)
	    {
	      for(j = 0; j < graph[ii].picture.tmesh.sample1 ; j++)    	  
		{
		  if( !flag.local_light) 
		    c3f(snx[i][j]);
		  move(sx[i][j][0], sx[i][j][1], sx[i][j][2]);
		  draw(sx[i][j][0] + normal_size * snx[i][j][0],
		       sx[i][j][1] + normal_size * snx[i][j][1],
		       sx[i][j][2] + normal_size * snx[i][j][2]);
		}
	    }
	}
    }
#ifdef HAVE_F77
  else if(graph[ii].type == CONTOUR)
    {
      axes = graph[ii].picture.contour.uaxes;
      if(!flag.depthcue && !flag.local_light)  get_color(0);
      bgnline();
      v3f(graph[ii].picture.contour.cx[0]);
      v3f(graph[ii].picture.contour.cx[4]);      
      v3f(graph[ii].picture.contour.cx[5]);
      v3f(graph[ii].picture.contour.cx[6]);
      v3f(graph[ii].picture.contour.cx[7]);
      v3f(graph[ii].picture.contour.cx[4]);
      endline();
      bgnline();
      v3f(graph[ii].picture.contour.cx[1]);      
      v3f(graph[ii].picture.contour.cx[5]);
      endline();
      bgnline();
      v3f(graph[ii].picture.contour.cx[2]);      
      v3f(graph[ii].picture.contour.cx[6]);
      endline();
      bgnline();
      v3f(graph[ii].picture.contour.cx[3]);      
      v3f(graph[ii].picture.contour.cx[7]);
      endline();
      
      mm = 0;
      sx = graph[ii].picture.contour.sx;
      for(i = 0; i < graph[ii].picture.contour.n_cs; i++)
	{
	  if(!flag.depthcue && !flag.local_light)  get_color(i);
	  for(j=0; j< graph[ii].picture.contour.npts[i][0] ; j++)
	    {
	      bgnline();
	      k = 0;
	      for(l = 0; l < graph[ii].picture.contour.npts[i][j+1]; l++)
		{
		  v3f(sx[mm][l]);
		  if(k == 253)
		    {
		      endline();
		      k = -1;
		      l--;      /* move back one point */
		      bgnline();
		    }
		  k++;
		}
	      endline();
	      mm++;
	    }
	}
    }
#endif
  else if(graph[ii].type == MAP)
    {
      float **cx = graph[ii].picture.map.cx;
      axes = graph[ii].picture.map.uaxes;
      k = 0;
      if(!flag.local_light) 
	get_color( graph[ii].picture.map.color);
      bgnpoint();
      for(i = 0; i < graph[ii].picture.map.sample; i++)
	{
	  v3f(cx[i]);
	  if(k ==253 )
	    {
	      endpoint();
	      i--; k = -1;
	      bgnpoint();
	    }
	  k++;
	}
      endpoint();
    }
  else if(graph[ii].type == EQN)
    {
      float **cx = graph[ii].picture.eqn.cx;
      axes = graph[ii].picture.eqn.uaxes;
      k = 0;
      bgnline();
      if(!flag.depthcue && !flag.local_light)
	get_color( graph[ii].picture.eqn.color);
      for(i = 0; i < graph[ii].picture.eqn.sample; i++)
	{
	  v3f(cx[i]);
	  if(k ==253 )
	    {
	      endline();
	      i--; k = -1;
	      bgnline();
	    }
	  k++;
	}
      endline();
    } 
  if(axes != (struct uaxes *)0)
    draw_user_defined_axes(axes);
}
/*********************************************************************/

set_line(line_type)
     int line_type;
{
  line_type %= 5;
  if(line_type) setlinestyle(line_type);
}

get_color(index)
  int index;
{
  if(index == 0) cpack(0x00ffffff);
  else if(index==1) cpack(0x00ff0000);
  else if(index==2) cpack(0x0000ff00);
  else if(index==3) cpack(0x000000ff);
  else if(index==4) cpack(0x00ff00ff);
  else if(index==5) cpack(0x0085f88f);
  else if(index==6) cpack(0x0000ffff);
  else if(index==7) cpack(0x00ffff00);
  else if(index==7) cpack(0x00ff8f00);
  else if(index==8) cpack(0x008fff00);
  else if(index==9) cpack(0x008f00ff);
  else if(index==10) cpack(0x00ff008f);
  else if(index==11) cpack(0x00008fff);
  else if(index==12) cpack(0x0000ff8f);
  else if(index==13) cpack(0x00ef0f00);
  else if(index==14) cpack(0x0000ef00);
  else if(index==15) cpack(0x0000008f);
  else if(index==16) cpack(0x00efef00);
  else if(index==17) cpack(0x00ef00ef);
  else if(index==18) cpack(0x0000efef);
  else if(index==19) cpack(0x00efef8f);
  else if(index==20) cpack(0x00df8f5f);
  else if(index==21) cpack(0x00cf4f5f);
  else if(index==22) cpack(0x00cf5f4f);
  else if(index==23) cpack(0x00df5f8f);
  else if(index==24) cpack(0x00cf5f4f);
  else if(index==25) cpack(0x00cf9f00);
  else if(index==26) cpack(0x00cf009f);
  else if(index==27) cpack(0x00cf5f00);
  else if(index==28) cpack(0x00cf0f5f);
  else if(index==29) cpack(0x005fcf00);
  else if(index==30) cpack(0x005f00cf);
  else if(index==31) cpack(0x0000cf5f);
  else if(index==32) cpack(0x00005fcf);
  else if(index==33) cpack(0x00bf0000);
  else if(index==34) cpack(0x0000cf00);
  else if(index==35) cpack(0x000000cf);
  else if(index==36) cpack(0x00cf0000);
  else if(index==37) cpack(0x0000cf00);
  else if(index==38) cpack(0x000000cf);
  else if(index==39) cpack(0x00bf004f);
  else if(index==40) cpack(0x00009f5f);
  else if(index==41) cpack(0x00df4f00);
  else if(index==41) cpack(0x0000bf4f);
  else if(index==42) cpack(0x00dfbf3f);
  else if(index==43) cpack(0x00af0000);
  else if(index==44) cpack(0x0000af5f);
  else if(index==45) cpack(0x00df00af);
  else if(index==46) cpack(0x00af0faf);
  else if(index==47) cpack(0x0000af5f);
  else if(index==48) cpack(0x00bf8f5f);
  else if(index==49) cpack(0x00008fbf);
  else if(index==50) cpack(0x00af8faf);
  else cpack(0x00ffffff);
}
/****************************************************************************/

togle_to_wire_frame()
{
  show_wire = !show_wire;
}

togle_to_show_normal_for_surface()
{
  normal_size  = ABS(pview.xmax - pview.xmin) * 0.035;
  show_normal = !show_normal;
}

do_demo()
{
}
/****************************************************************************/

set_base_data(ll)
     int ll;
{
  npx[0] = 1.0;
  npx[1] = 0.0;
  npx[2] = 0.0;
  if(!ll)
    nnx[0] = 1.0;
  else
    nnx[0] = -1.0;
  nnx[1] = 0.0;
  nnx[2] = 0.0;
  npy[0] = 0.0;
  npy[1] = 1.0;
  npy[2] = 0.0;
  nny[0] = 0.0;  
  nny[2] = 0.0;
  if(!ll)
    nny[1] = 1.0;
  else
    nny[1] = -1.0;
  nnz[0] = 0.0;
  nnz[1] = 0.0;
  if(!ll)
    nnz[2] = 1.0;
  else
    nnz[2] = -1.0;
}
/***************************************************/

draw_surface_curve(ii)
     int ii;
{
  int i,j,k;
  struct uaxes *axes;

  if(graph[ii].type == CURVE)
    {
      if(!flag.depthcue  && !flag.local_light)
	get_color(graph[ii].picture.curve.color);
      if((graph[ii].picture.curve.style) != -1) 
	set_line(graph[ii].picture.curve.style);
      axes = (graph[ii].picture.curve.uaxes);
    }
  else
    axes = (graph[ii].picture.surface.uaxes);

  if(graph[ii].data_type == GRID_DATA) 
    {
      if(graph[ii].type == SURFACE) 
	{
	  float ***sx,***snx;
	  sx = graph[ii].picture.surface.sx;
	  snx = graph[ii].picture.surface.snx;
	  if(!(graph[ii].picture.surface.is_wire) && !show_wire) 
	    {
	      if(flag.light) 
		{
		  for(i = 0; i < graph[ii].picture.surface.sample -1; i++)
		    {
		      bgntmesh();
		      for(j = 0; j< graph[ii].picture.surface.sample1; j++)   
		      {
			n3f(snx[i][j]);
			v3f(sx[i][j]);
			n3f(snx[i+1][j]);
			v3f(sx[i+1][j]);
		      }
		      endtmesh();  
		    }
		}
	      else if(!flag.depthcue) 
		{
		  for(i = 0; i < graph[ii].picture.surface.sample -1; i++)
		    {
		      bgntmesh();
		      for(j = 0; j < graph[ii].picture.surface.sample1 ; j++) 
			{
			  c3f(snx[i][j]);
			  v3f(sx[i][j]);
			  c3f(snx[i+1][j]);
			  v3f(sx[i+1][j]);
			}
		      endtmesh();  
		    }
		}
	      else 
		{
		  for(i = 0; i < graph[ii].picture.surface.sample -1; i++)
		    {
		      bgntmesh();
		      for(j = 0; j < graph[ii].picture.surface.sample1 ; j++)
			{
			  v3f(sx[i][j]);
			  v3f(sx[i+1][j]);
			}
		      endtmesh();  
		    }
		}
	    }
	  else  
	    {
	      if(flag.light) 
		{
		  for(i = 0; i < graph[ii].picture.surface.sample;i++)
		    {
		      bgnline();
		      for(j = 0; j < graph[ii].picture.surface.sample1 ; j++) 
			{
			  n3f(snx[i][j]);
			  v3f(sx[i][j]);
			}
		      endline();
		    }
		  for(j = 0; j < graph[ii].picture.surface.sample1;j++)
		    {
		      bgnline();
		      for(i = 0; i < graph[ii].picture.surface.sample ; i++) 
			{
			  n3f(snx[i][j]);
			  v3f(sx[i][j]);
			}
		      endline();
		    }
		}
	      else if(!flag.depthcue) 
		{
		  for(i = 0; i < graph[ii].picture.surface.sample;i++)
		    {
		      bgnline();
		      for(j = 0; j < graph[ii].picture.surface.sample1 ; j++) 
			{
			  c3f(snx[i][j]);
			  v3f(sx[i][j]);
			}
		      endline();
		    }
		  for(j = 0; j < graph[ii].picture.surface.sample1;j++)
		    {
		      bgnline();
		      for(i = 0; i < graph[ii].picture.surface.sample ; i++) 
			{
			  c3f(snx[i][j]);
			  v3f(sx[i][j]);
			}
		      endline();
		    }
		}
	      else 
		{
		  for(i = 0; i < graph[ii].picture.surface.sample;i++)
		    {
		      bgnline();
		      for(j = 0; j < graph[ii].picture.surface.sample1 ; j++) 
			v3f(sx[i][j]);
		      endline();
		    }
		  for(j = 0; j < graph[ii].picture.surface.sample1;j++)
		    {
		      bgnline();
		      for(i = 0; i < graph[ii].picture.surface.sample ; i++) 
			v3f(sx[i][j]);
		      endline();
		    }
		}
	    }
	  if(show_normal && flag.light )
	    {
	      for(i = 0; i < graph[ii].picture.surface.sample;i++)
		{
		  for(j = 0; j < graph[ii].picture.surface.sample1;j++)
		    {
		      if( !flag.local_light) 
			c3f(snx[i][j]);
		      move(sx[i][j][0],sx[i][j][1],sx[i][j][2]);
		      draw(sx[i][j][0] + normal_size * snx[i][j][0],
			   sx[i][j][1] + normal_size * snx[i][j][1],
			   sx[i][j][2] + normal_size * snx[i][j][2]);
		    }
		}
	    }
	  if(base_box )
	    {
	      BGNPOLYGON();
	      if(flag.light)
		n3f(nny);
	      else if(!flag.depthcue)
		c3f(nny);
	      v3f(graph[ii].picture.surface.cx[0]);
	      for(i = 0; i < graph[ii].picture.surface.sample; i++)
		v3f(graph[ii].picture.surface.sx[i][0]);
	      v3f(graph[ii].picture.surface.cx[1]);
	      ENDPOLYGON();

	      BGNPOLYGON();
	      if(flag.light) 
		n3f(npx);
	      else if(!flag.depthcue)
		c3f(npx);
	      v3f(graph[ii].picture.surface.cx[1]);
	      for(i = 0; i < graph[ii].picture.surface.sample1; i++)
		v3f(graph[ii].picture.surface.sx
		    [graph[ii].picture.surface.sample-1][i]);
	      v3f(graph[ii].picture.surface.cx[2]);
	      ENDPOLYGON();
	  
	      BGNPOLYGON();
	      if(flag.light) 
		n3f(npy);
	      else if(!flag.depthcue)
		c3f(npy);
	      v3f(graph[ii].picture.surface.cx[2]);
	      for(i = 0; i < graph[ii].picture.surface.sample; i++)
		v3f(graph[ii].picture.surface.sx
		    [graph[ii].picture.surface.sample-1-i]
		    [graph[ii].picture.surface.sample1-1]);
	      v3f(graph[ii].picture.surface.cx[3]);
	      ENDPOLYGON();
	  
	      BGNPOLYGON();
	      if(flag.light) 
		n3f(nnx);
	      else if(!flag.depthcue)
		c3f(nnx);
	      
	      v3f(graph[ii].picture.surface.cx[3]);
	      for(i = 0; i < graph[ii].picture.surface.sample1; i++)
		v3f(graph[ii].picture.surface.sx
		    [0][graph[ii].picture.surface.sample1-1-i]);
	      v3f(graph[ii].picture.surface.cx[0]);
	      ENDPOLYGON();
	      
	      BGNPOLYGON();
	      if(flag.light)
		n3f(nnz);
	      else if(!flag.depthcue)
		c3f(nnz);
	      v3f(graph[ii].picture.surface.cx[0]);	
	      v3f(graph[ii].picture.surface.cx[1]);
	      v3f(graph[ii].picture.surface.cx[2]);	 
	      v3f(graph[ii].picture.surface.cx[3]);
	      v3f(graph[ii].picture.surface.cx[0]);	
	      ENDPOLYGON();
	    }
	}
      else   if(graph[ii].type == CURVE) 
	{
	  float ***cx = graph[ii].picture.curve.cx;
	  if(!flag.local_light)       
	    get_color(graph[ii].picture.curve.color);
	  for(i = 0; i < graph[ii].picture.curve.sample1 ; i++)
	    {
	      if((graph[ii].picture.curve.style) == -1) 
		bgnpoint();
	      else
		bgnline();
	      k = 0;
	      for (j = 0; j < graph[ii].picture.curve.sample ; j++)
		{
		  v3f(cx[i][j]);
		  if(k >= 253)
		    {
		      if(graph[ii].picture.curve.style == -1)
			endpoint();
		      else
			endline();
		      k = -1;
		      j--;
		      if(graph[ii].picture.curve.style == -1)
			bgnpoint();
		      else
			bgnline();
		    }
		  k++;
		}
	      if(graph[ii].picture.curve.style == -1)
		endpoint();
	      else 
		endline();
	    }
	}
    }
  else if(graph[ii].data_type == CVN_DATA)
    {
      struct a_cvn_point *t_cvn;
      register int is_there=0;
      if(graph[ii].type == SURFACE)
	{
	  t_cvn = graph[ii].picture.surface.cvn;
	  if(flag.light)
	    {
	      while(t_cvn)
		{
		  if(t_cvn->c == 'v')    v3f(t_cvn->x);
		  else if(t_cvn->c == 'n') n3f(t_cvn->x);
		  else if(t_cvn->c == 'c') c3f(t_cvn->x);
		  else if(t_cvn->c == 'a') c4f(t_cvn->x);
		  else 
		    {
		      if((graph[ii].picture.surface.is_wire) || show_wire)
			{
			  if(is_there) endline();
			  bgnline(); is_there = 1;
			}
		      else
			{
			  if(is_there) endpolygon();
			  bgnpolygon(); is_there = 1;
			}
		    }
		  t_cvn = t_cvn->next;
		}
	    }
	  else {
	    while(t_cvn)
	      {
		if(t_cvn->c == 'v') v3f(t_cvn->x);
		else if(t_cvn->c == 'c') c3f(t_cvn->x);
		else if(t_cvn->c == 'n') c3f(t_cvn->x);
		else if(t_cvn->c == 'a') c4f(t_cvn->x);
		else
		  {
		    if((graph[ii].picture.surface.is_wire) || show_wire)
		      {
			if(is_there) endline();
			bgnline(); is_there = 1;
		      }
		    else
		      {
			if(is_there) endpolygon();
			bgnpolygon(); is_there = 1;
		      }
		  }
		t_cvn = t_cvn->next;
	      }
	  }
	  if((graph[ii].picture.surface.is_wire) || show_wire)
	    endline();
	  else
	    endpolygon();

	  if(show_normal && flag.light)
	    {
	      register float x0,y57,z0;
	      t_cvn = graph[ii].picture.surface.cvn;
	      while(t_cvn)
		{
		  if(t_cvn->c == 'n')
		    {
		      if( !flag.local_light)  c3f(t_cvn->x);
		      x0 = t_cvn->x[0];y57 = t_cvn->x[1];z0 = t_cvn->x[2];
		    }
		  else if(t_cvn->c == 'v')
		    {
		      move(t_cvn->x[0], t_cvn->x[1], t_cvn->x[2]);
		      draw(t_cvn->x[0]+normal_size * x0,
			   t_cvn->x[1]+normal_size * y57,
			   t_cvn->x[2]+normal_size * z0);
		    }
		  t_cvn = t_cvn->next;
		}
	    }
	}
      else
	{
	  t_cvn = graph[ii].picture.curve.cvn;	
	  while(t_cvn)
	    {
	      if(t_cvn->c == 'v') v3f(t_cvn->x);
	      else if(t_cvn->c == 'c') c3f(t_cvn->x);
	      else if(t_cvn->c == 'n') n3f(t_cvn->x);
	      else if(t_cvn->c == 'a') c4f(t_cvn->x);
	      else
		{
		  if(graph[ii].picture.curve.style == -1)
		    {
		      if(is_there) endpoint();
		      bgnpoint(); is_there = 1;
		    }
		  else
		    {
		      if(is_there) endline();
		      bgnline(); is_there = 1;
		    }
		}
	      t_cvn = t_cvn->next;
	    }
	  if(graph[ii].picture.curve.style == -1)
	    endpoint();
	  else
	    endline();
	}
    }
  else if(graph[ii].data_type == POLYGON_DATA)
    {
      struct a_polygon *t_p;
      if(graph[ii].type == SURFACE)
	{
	  t_p = graph[ii].picture.surface.poly;
	  if(flag.light)
	    {
	      while(t_p)
		{
		  if((graph[ii].picture.surface.is_wire) || show_wire)
		    bgnline();
		  else
		    bgnpolygon();
		  for(i = 0; i <  t_p->num_points; i++)
		    {
		      n3f(t_p->norm[i]);
		      v3f(t_p->points[i]);
		    }
		  if((graph[ii].picture.surface.is_wire) || show_wire)
		    endline();
		  else
		    endpolygon();
		  t_p = t_p->next;
		}
	    }
	  else if(!flag.depthcue) {
	    while(t_p)
	      {
		if((graph[ii].picture.surface.is_wire) || show_wire)
		  bgnline();
		else
		  bgnpolygon();
		for(i = 0; i <  t_p->num_points; i++)
		  {
		    c3f(t_p->norm[i]);
		    v3f(t_p->points[i]);
		  }
		if((graph[ii].picture.surface.is_wire) || show_wire)
		  endline();
		else
		  endpolygon();
		t_p = t_p->next;
	      }
	  }
	  else {
	    while(t_p)
	      {
		if((graph[ii].picture.surface.is_wire) || show_wire)
		  bgnline();
		else
		  bgnpolygon();
		for(i = 0; i <  t_p->num_points; i++)
		  v3f(t_p->points[i]);
		if((graph[ii].picture.surface.is_wire) || show_wire)
		  endline();
		else
		  endpolygon();
		t_p = t_p->next;
	      }
	  } 
	  if(show_normal && flag.light)
	    {
	      t_p = graph[ii].picture.surface.poly;
	      while(t_p)
		{
		  for(i = 0; i < t_p->num_points; i++)
		    {
		      if( !flag.local_light)  c3f(t_p->norm[i]);
		      move(t_p->points[i][0],
			   t_p->points[i][1],t_p->points[i][2]);
		      draw(t_p->points[i][0]+normal_size * t_p->norm[i][0],
			   t_p->points[i][1]+normal_size * t_p->norm[i][1],
			   t_p->points[i][2]+normal_size * t_p->norm[i][2]);
		    }
		  t_p = t_p->next;
		}
	    }
	}
      if(graph[ii].type == CURVE)
	{
	  if(!flag.local_light) 
	    get_color(graph[ii].picture.curve.color);
	  t_p = graph[ii].picture.curve.poly;
	  while(t_p)
	    {
	      if((graph[ii].picture.curve.style == -1))
		bgnpoint();
	      else 
		bgnline();
	      for(i = 0; i < t_p->num_points; i++)
		v3f(t_p->points[i]);
	      if((graph[ii].picture.curve.style == -1))
		endpoint();
	      else 
		endline();	      
	      t_p = t_p->next;
	    }
	}
    }
  else if(graph[ii].data_type == FEA_POLYGON)
    draw_fea(ii);

  if(axes != (struct uaxes *)0)
    draw_user_defined_axes(axes);
} 
/********************************************************************/
draw_fea(ii)
     int ii;
{
  struct fea_poly *temp;
  register int aaa = 0,i,j;
  
  if(graph[ii].type == CURVE)
    {
      aaa = 1;
      temp = graph[ii].picture.curve.fea_poly;
    }
  else
    {
      if( graph[ii].picture.surface.is_wire) aaa = 1;
      temp = graph[ii].picture.surface.fea_poly;
    } 
  
  while(temp) {
    for(i = 0; i < temp->np; i++)  {
      if( aaa || show_wire )
	bgnline();
      else
	bgnpolygon();
      if(flag.light)  {
	for(j = 0; j < (temp->nn[i][0]);j++)
	  {
	    n3f(temp->nx[ (temp->nn[i][j+1])]);
	    v3f(temp->x[(temp->nn[i][j+1])]);
	  }
	if( aaa || show_wire )
	  endline();
	else
	  endpolygon();
      }
      else if(!flag.depthcue) {
	for(j = 0; j < (temp->nn[i][0]);j++)
	  {
	    c3f(temp->nx[(temp->nn[i][j+1])]);
	    v3f(temp->x[(temp->nn[i][j+1])]);
	  }
	if( aaa || show_wire )
	  endline();
	else
	  endpolygon();
      }
      else {
	for(j = 0; j < (temp->nn[i][0]);j++)
	  v3f(temp->x[(temp->nn[i][j+1])]);
	if( aaa || show_wire )
	  endline();
	else
	  endpolygon();
      }
    }	
    if(show_normal && flag.light && graph[ii].type == SURFACE)
      {
	for(i = 0; i < temp->np; i++)
	  {
	    for(j = 0; j < (temp->nn[i][0]);j++)
	      {
		if( !flag.local_light) 
		  c3f(temp->nx[(temp->nn[i][j+1])]);
		move(temp->x[(temp->nn[i][j+1])][0],
		     temp->x[(temp->nn[i][j+1])][1],
		     temp->x[(temp->nn[i][j+1])][2]);
		draw(temp->x[(temp->nn[i][j+1])][0]+ normal_size *
		     temp->nx[(temp->nn[i][j+1])][0],
		     temp->x[(temp->nn[i][j+1])][1]+ normal_size *
		     temp->nx[(temp->nn[i][j+1])][1],
		     temp->x[(temp->nn[i][j+1])][2]+ normal_size *
		     temp->nx[(temp->nn[i][j+1])][2]);
	      }
	  }
      }
    temp = temp->next;
  }
}
/********************************************************************/
extern int plot3d;

draw_user_defined_axes(axes)
     struct uaxes *axes;
{
  float mark_length,xx,yy,zz,nx,ny,nz;
  int i,tmp;

  mark_length = ABS(pview.xmax - pview.xmin) * 0.01;
  {
    if(flag.depthcue)
      {
	lRGBrange(depth_color[1],depth_color[2],depth_color[0],
		  depth_color[4],depth_color[5],
		  depth_color[3],0,0x007fff);
      }
    else cpack(0x00008fff);
  }
  move(axes->xx,axes->xy,axes->xz);
  draw(axes->ox,axes->oy,axes->oz);
  draw(axes->yx,axes->yy,axes->yz);
  cmov(axes->xx,axes->xy,axes->xz);
  charstr("x");
  cmov(axes->yx,axes->yy,axes->yz);
  charstr("y");
  tmp = axes->ticmarks;

  nx = (axes->xx - axes->ox)/(float)tmp;
  ny = (axes->xy - axes->oy)/(float)tmp;
  nz = (axes->xz - axes->oz)/(float)tmp;

  for(i = 1; i <= tmp; i++)
    {
      xx = axes->ox + nx*(float)i;
      yy = axes->oy + ny*(float)i;
      zz = axes->oz + nz*(float)i;
      move(xx,yy,zz);
      draw(xx,yy+mark_length,zz);
    }

  nx = (axes->yx - axes->ox)/(float)tmp;
  ny = (axes->yy - axes->oy)/(float)tmp;
  nz = (axes->yz - axes->oz)/(float)tmp;

  for(i = 1; i <= tmp; i++)
    {
      xx = axes->ox + nx*(float)i;
      yy = axes->oy + ny*(float)i;
      zz = axes->oz + nz*(float)i;
      move(xx,yy,zz);
      draw(xx+mark_length,yy,zz);
    }
  if(plot3d)
    {
      move(axes->zx,axes->zy,axes->zz);
      draw(axes->ox,axes->oy,axes->oz); 
      cmov(axes->zx,axes->zy,axes->zz);
      charstr("z");
      
      nx = (axes->zx - axes->ox)/(float)tmp;
      ny = (axes->zy - axes->oy)/(float)tmp;
      nz = (axes->zz - axes->oz)/(float)tmp;

      for(i = 1; i <= tmp; i++)
	{
	  xx = axes->ox + nx*(float)i;
	  yy = axes->oy + ny*(float)i;
	  zz = axes->oz + nz*(float)i;
	  move(xx,yy,zz);
	  draw(xx,yy+mark_length,zz);
	}
    }
}
/********************************************************************/

