require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_SWAP_H)) {
    eval 'sub _LINUX_SWAP_H () {1;}' unless defined(&_LINUX_SWAP_H);
    require 'linux/config.ph';
    require 'linux/spinlock.ph';
    require 'linux/linkage.ph';
    require 'linux/mmzone.ph';
    require 'linux/list.ph';
    require 'linux/sched.ph';
    require 'asm/atomic.ph';
    require 'asm/page.ph';
    eval 'sub SWAP_FLAG_PREFER () {0x8000;}' unless defined(&SWAP_FLAG_PREFER);
    eval 'sub SWAP_FLAG_PRIO_MASK () {0x7fff;}' unless defined(&SWAP_FLAG_PRIO_MASK);
    eval 'sub SWAP_FLAG_PRIO_SHIFT () {0;}' unless defined(&SWAP_FLAG_PRIO_SHIFT);
    eval 'sub current_is_kswapd {
        my($void) = @_;
	    eval q({  ($current->{flags}) &  &PF_KSWAPD; });
    }' unless defined(&current_is_kswapd);
    eval 'sub MAX_SWAPFILES_SHIFT () {5;}' unless defined(&MAX_SWAPFILES_SHIFT);
    eval 'sub MAX_SWAPFILES () {(1<<  &MAX_SWAPFILES_SHIFT);}' unless defined(&MAX_SWAPFILES);
    if(defined(&__KERNEL__)) {
	eval 'sub __swapoffset {
	    my($x) = @_;
    	    eval q(((0)->$x));
	}' unless defined(&__swapoffset);
	eval 'sub MAX_SWAP_BADPAGES () {(( &__swapoffset( ($magic->{magic})) -  &__swapoffset( ($info->{badpages}))) / $sizeof{\'int\'});}' unless defined(&MAX_SWAP_BADPAGES);
	eval("sub SWP_USED () { (1<<0); }") unless defined(&SWP_USED);
	eval("sub SWP_WRITEOK () { (1<<1); }") unless defined(&SWP_WRITEOK);
	eval("sub SWP_ACTIVE () { (SWP_USED|SWP_WRITEOK); }") unless defined(&SWP_ACTIVE);
	eval 'sub SWAP_CLUSTER_MAX () {32;}' unless defined(&SWAP_CLUSTER_MAX);
	eval 'sub SWAP_MAP_MAX () {0x7fff;}' unless defined(&SWAP_MAP_MAX);
	eval 'sub SWAP_MAP_BAD () {0x8000;}' unless defined(&SWAP_MAP_BAD);
	eval 'sub vm_swap_full () {
	    eval q(( &nr_swap_pages*2<  &total_swap_pages));
	}' unless defined(&vm_swap_full);
	if(defined(&CONFIG_MMU)) {
	}
	if(defined(&CONFIG_SWAP)) {
	    eval 'sub total_swapcache_pages () { ($swapper_space->{nrpages});}' unless defined(&total_swapcache_pages);
	    eval 'sub swap_list_lock () {
	        eval q( &spin_lock( &swaplock));
	    }' unless defined(&swap_list_lock);
	    eval 'sub swap_list_unlock () {
	        eval q( &spin_unlock( &swaplock));
	    }' unless defined(&swap_list_unlock);
	    eval 'sub swap_device_lock {
	        my($p) = @_;
    		eval q( &spin_lock( ($p->{sdev_lock})));
	    }' unless defined(&swap_device_lock);
	    eval 'sub swap_device_unlock {
	        my($p) = @_;
    		eval q( &spin_unlock( ($p->{sdev_lock})));
	    }' unless defined(&swap_device_unlock);
	    eval 'sub has_swap_token {
	        my($mm) = @_;
    		eval q({ ($mm ==  &swap_token_mm); });
	    }' unless defined(&has_swap_token);
	    eval 'sub put_swap_token {
	        my($mm) = @_;
    		eval q({  &if ( &has_swap_token($mm))  &__put_swap_token($mm); });
	    }' unless defined(&put_swap_token);
	} else {
	    eval 'sub total_swap_pages () {0;}' unless defined(&total_swap_pages);
	    eval 'sub total_swapcache_pages () {0;}' unless defined(&total_swapcache_pages);
	    eval 'sub si_swapinfo {
	        my($val) = @_;
    		eval q( &do { ($val)-> &freeswap = ($val)-> &totalswap = 0; }  &while (0));
	    }' unless defined(&si_swapinfo);
	    eval 'sub free_page_and_swap_cache {
	        my($page) = @_;
    		eval q( &page_cache_release($page));
	    }' unless defined(&free_page_and_swap_cache);
	    eval 'sub free_pages_and_swap_cache {
	        my($pages, $nr) = @_;
    		eval q( &release_pages(($pages), ($nr), 0););
	    }' unless defined(&free_pages_and_swap_cache);
	    eval 'sub show_swap_cache_info () {
	        eval q();
	    }' unless defined(&show_swap_cache_info);
	    eval 'sub free_swap_and_cache {
	        my($swp) = @_;
    		eval q();
	    }' unless defined(&free_swap_and_cache);
	    eval 'sub swap_duplicate {
	        my($swp) = @_;
    		eval q();
	    }' unless defined(&swap_duplicate);
	    eval 'sub swap_free {
	        my($swp) = @_;
    		eval q();
	    }' unless defined(&swap_free);
	    eval 'sub read_swap_cache_async {
	        my($swp,$vma,$addr) = @_;
    		eval q( &NULL);
	    }' unless defined(&read_swap_cache_async);
	    eval 'sub lookup_swap_cache {
	        my($swp) = @_;
    		eval q( &NULL);
	    }' unless defined(&lookup_swap_cache);
	    eval 'sub valid_swaphandles {
	        my($swp, $off) = @_;
    		eval q(0);
	    }' unless defined(&valid_swaphandles);
	    eval 'sub can_share_swap_page {
	        my($p) = @_;
    		eval q(0);
	    }' unless defined(&can_share_swap_page);
	    eval 'sub move_to_swap_cache {
	        my($p, $swp) = @_;
    		eval q(1);
	    }' unless defined(&move_to_swap_cache);
	    eval 'sub move_from_swap_cache {
	        my($p, $i, $m) = @_;
    		eval q(1);
	    }' unless defined(&move_from_swap_cache);
	    eval 'sub __delete_from_swap_cache {
	        my($p) = @_;
    		eval q();
	    }' unless defined(&__delete_from_swap_cache);
	    eval 'sub delete_from_swap_cache {
	        my($p) = @_;
    		eval q();
	    }' unless defined(&delete_from_swap_cache);
	    eval 'sub swap_token_default_timeout () {0;}' unless defined(&swap_token_default_timeout);
	    eval 'sub remove_exclusive_swap_page {
	        my($p) = @_;
    		eval q({ 0; });
	    }' unless defined(&remove_exclusive_swap_page);
	    eval 'sub get_swap_page {
	        my($void) = @_;
    		eval q({  &swp_entry_t  &entry;  ($entry->{val}) = 0;  &entry; });
	    }' unless defined(&get_swap_page);
	    eval 'sub put_swap_token {
	        my($x) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&put_swap_token);
	    eval 'sub grab_swap_token () {
	        eval q( &do { }  &while(0));
	    }' unless defined(&grab_swap_token);
	    eval 'sub has_swap_token {
	        my($x) = @_;
    		eval q(0);
	    }' unless defined(&has_swap_token);
	}
    }
}
1;
