require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&LINUX_SERIAL_CORE_H)) {
    eval 'sub LINUX_SERIAL_CORE_H () {1;}' unless defined(&LINUX_SERIAL_CORE_H);
    eval 'sub PORT_UNKNOWN () {0;}' unless defined(&PORT_UNKNOWN);
    eval 'sub PORT_8250 () {1;}' unless defined(&PORT_8250);
    eval 'sub PORT_16450 () {2;}' unless defined(&PORT_16450);
    eval 'sub PORT_16550 () {3;}' unless defined(&PORT_16550);
    eval 'sub PORT_16550A () {4;}' unless defined(&PORT_16550A);
    eval 'sub PORT_CIRRUS () {5;}' unless defined(&PORT_CIRRUS);
    eval 'sub PORT_16650 () {6;}' unless defined(&PORT_16650);
    eval 'sub PORT_16650V2 () {7;}' unless defined(&PORT_16650V2);
    eval 'sub PORT_16750 () {8;}' unless defined(&PORT_16750);
    eval 'sub PORT_STARTECH () {9;}' unless defined(&PORT_STARTECH);
    eval 'sub PORT_16C950 () {10;}' unless defined(&PORT_16C950);
    eval 'sub PORT_16654 () {11;}' unless defined(&PORT_16654);
    eval 'sub PORT_16850 () {12;}' unless defined(&PORT_16850);
    eval 'sub PORT_RSA () {13;}' unless defined(&PORT_RSA);
    eval 'sub PORT_NS16550A () {14;}' unless defined(&PORT_NS16550A);
    eval 'sub PORT_XSCALE () {15;}' unless defined(&PORT_XSCALE);
    eval 'sub PORT_MAX_8250 () {15;}' unless defined(&PORT_MAX_8250);
    eval 'sub PORT_PXA () {31;}' unless defined(&PORT_PXA);
    eval 'sub PORT_AMBA () {32;}' unless defined(&PORT_AMBA);
    eval 'sub PORT_CLPS711X () {33;}' unless defined(&PORT_CLPS711X);
    eval 'sub PORT_SA1100 () {34;}' unless defined(&PORT_SA1100);
    eval 'sub PORT_UART00 () {35;}' unless defined(&PORT_UART00);
    eval 'sub PORT_21285 () {37;}' unless defined(&PORT_21285);
    eval 'sub PORT_SUNZILOG () {38;}' unless defined(&PORT_SUNZILOG);
    eval 'sub PORT_SUNSAB () {39;}' unless defined(&PORT_SUNSAB);
    eval 'sub PORT_V850E_UART () {40;}' unless defined(&PORT_V850E_UART);
    eval 'sub PORT_DZ () {47;}' unless defined(&PORT_DZ);
    eval 'sub PORT_MUX () {48;}' unless defined(&PORT_MUX);
    eval 'sub PORT_MAC_ZILOG () {50;}' unless defined(&PORT_MAC_ZILOG);
    eval 'sub PORT_PMAC_ZILOG () {51;}' unless defined(&PORT_PMAC_ZILOG);
    eval 'sub PORT_SCI () {52;}' unless defined(&PORT_SCI);
    eval 'sub PORT_SCIF () {53;}' unless defined(&PORT_SCIF);
    eval 'sub PORT_IRDA () {54;}' unless defined(&PORT_IRDA);
    eval 'sub PORT_S3C2410 () {55;}' unless defined(&PORT_S3C2410);
    eval 'sub PORT_IP22ZILOG () {56;}' unless defined(&PORT_IP22ZILOG);
    eval 'sub PORT_LH7A40X () {57;}' unless defined(&PORT_LH7A40X);
    eval 'sub PORT_CPM () {58;}' unless defined(&PORT_CPM);
    eval 'sub PORT_MPC52xx () {59;}' unless defined(&PORT_MPC52xx);
    eval 'sub PORT_ICOM () {60;}' unless defined(&PORT_ICOM);
    eval 'sub PORT_S3C2440 () {61;}' unless defined(&PORT_S3C2440);
    eval 'sub PORT_IMX () {62;}' unless defined(&PORT_IMX);
    eval 'sub PORT_MPSC () {63;}' unless defined(&PORT_MPSC);
    eval 'sub PORT_TXX9 () {64;}' unless defined(&PORT_TXX9);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/interrupt.ph';
	require 'linux/circ_buf.ph';
	require 'linux/spinlock.ph';
	require 'linux/sched.ph';
	require 'linux/tty.ph';
	eval 'sub UART_CONFIG_TYPE () {(1<< 0);}' unless defined(&UART_CONFIG_TYPE);
	eval 'sub UART_CONFIG_IRQ () {(1<< 1);}' unless defined(&UART_CONFIG_IRQ);
	eval 'sub UPIO_PORT () {(0);}' unless defined(&UPIO_PORT);
	eval 'sub UPIO_HUB6 () {(1);}' unless defined(&UPIO_HUB6);
	eval 'sub UPIO_MEM () {(2);}' unless defined(&UPIO_MEM);
	eval 'sub UPIO_MEM32 () {(3);}' unless defined(&UPIO_MEM32);
	if(defined(&CONFIG_SERIAL_CORE_CONSOLE)) {
	}
	eval 'sub UPF_FOURPORT () {(1<< 1);}' unless defined(&UPF_FOURPORT);
	eval 'sub UPF_SAK () {(1<< 2);}' unless defined(&UPF_SAK);
	eval 'sub UPF_SPD_MASK () {(0x1030);}' unless defined(&UPF_SPD_MASK);
	eval 'sub UPF_SPD_HI () {(0x10);}' unless defined(&UPF_SPD_HI);
	eval 'sub UPF_SPD_VHI () {(0x20);}' unless defined(&UPF_SPD_VHI);
	eval 'sub UPF_SPD_CUST () {(0x30);}' unless defined(&UPF_SPD_CUST);
	eval 'sub UPF_SPD_SHI () {(0x1000);}' unless defined(&UPF_SPD_SHI);
	eval 'sub UPF_SPD_WARP () {(0x1010);}' unless defined(&UPF_SPD_WARP);
	eval 'sub UPF_SKIP_TEST () {(1<< 6);}' unless defined(&UPF_SKIP_TEST);
	eval 'sub UPF_AUTO_IRQ () {(1<< 7);}' unless defined(&UPF_AUTO_IRQ);
	eval 'sub UPF_HARDPPS_CD () {(1<< 11);}' unless defined(&UPF_HARDPPS_CD);
	eval 'sub UPF_LOW_LATENCY () {(1<< 13);}' unless defined(&UPF_LOW_LATENCY);
	eval 'sub UPF_BUGGY_UART () {(1<< 14);}' unless defined(&UPF_BUGGY_UART);
	eval 'sub UPF_AUTOPROBE () {(1<< 15);}' unless defined(&UPF_AUTOPROBE);
	eval 'sub UPF_MAGIC_MULTIPLIER () {(1<< 16);}' unless defined(&UPF_MAGIC_MULTIPLIER);
	eval 'sub UPF_BOOT_ONLYMCA () {(1<< 22);}' unless defined(&UPF_BOOT_ONLYMCA);
	eval 'sub UPF_CONS_FLOW () {(1<< 23);}' unless defined(&UPF_CONS_FLOW);
	eval 'sub UPF_SHARE_IRQ () {(1<< 24);}' unless defined(&UPF_SHARE_IRQ);
	eval 'sub UPF_BOOT_AUTOCONF () {(1<< 28);}' unless defined(&UPF_BOOT_AUTOCONF);
	eval 'sub UPF_IOREMAP () {(1<< 31);}' unless defined(&UPF_IOREMAP);
	eval 'sub UPF_CHANGE_MASK () {(0x17fff);}' unless defined(&UPF_CHANGE_MASK);
	eval 'sub UPF_USR_MASK () {( &UPF_SPD_MASK| &UPF_LOW_LATENCY);}' unless defined(&UPF_USR_MASK);
	eval 'sub USF_CLOSING_WAIT_INF () {(0);}' unless defined(&USF_CLOSING_WAIT_INF);
	eval 'sub USF_CLOSING_WAIT_NONE () {(~0);}' unless defined(&USF_CLOSING_WAIT_NONE);
	eval 'sub UART_XMIT_SIZE () { &PAGE_SIZE;}' unless defined(&UART_XMIT_SIZE);
	eval 'sub UIF_CHECK_CD () {(1<< 25);}' unless defined(&UIF_CHECK_CD);
	eval 'sub UIF_CTS_FLOW () {(1<< 26);}' unless defined(&UIF_CTS_FLOW);
	eval 'sub UIF_NORMAL_ACTIVE () {(1<< 29);}' unless defined(&UIF_NORMAL_ACTIVE);
	eval 'sub UIF_INITIALIZED () {(1<< 31);}' unless defined(&UIF_INITIALIZED);
	eval 'sub WAKEUP_CHARS () {256;}' unless defined(&WAKEUP_CHARS);
	eval 'sub uart_circ_empty {
	    my($circ) = @_;
    	    eval q((($circ)-> &head == ($circ)-> &tail));
	}' unless defined(&uart_circ_empty);
	eval 'sub uart_circ_clear {
	    my($circ) = @_;
    	    eval q((($circ)-> &head = ($circ)-> &tail = 0));
	}' unless defined(&uart_circ_clear);
	eval 'sub uart_circ_chars_pending {
	    my($circ) = @_;
    	    eval q(( &CIRC_CNT(($circ)-> &head, ($circ)-> &tail,  &UART_XMIT_SIZE)));
	}' unless defined(&uart_circ_chars_pending);
	eval 'sub uart_circ_chars_free {
	    my($circ) = @_;
    	    eval q(( &CIRC_SPACE(($circ)-> &head, ($circ)-> &tail,  &UART_XMIT_SIZE)));
	}' unless defined(&uart_circ_chars_free);
	eval 'sub uart_tx_stopped {
	    my($port) = @_;
    	    eval q((($port)-> ($info->{tty}->{stopped}) || ($port)-> ($info->{tty}->{hw_stopped})));
	}' unless defined(&uart_tx_stopped);
	if(defined(&SUPPORT_SYSRQ)) {
	    eval 'sub uart_handle_sysrq_char {
	        my($port,$ch,$regs) = @_;
    		eval q({  &if ( ($port->{sysrq})) {  &if ($ch  &&  &time_before( &jiffies,  ($port->{sysrq}))) {  &handle_sysrq($ch, $regs,  &NULL);  ($port->{sysrq}) = 0; 1; }  ($port->{sysrq}) = 0; } 0; });
	    }' unless defined(&uart_handle_sysrq_char);
	} else {
	    eval 'sub uart_handle_sysrq_char {
	        my($port,$ch,$regs) = @_;
    		eval q((0));
	    }' unless defined(&uart_handle_sysrq_char);
	}
	if(defined(&SUPPORT_SYSRQ)) {
	}
	if(defined(&CONFIG_HARD_PPS)) {
	}
	eval 'sub UART_ENABLE_MS {
	    my($port,$cflag) = @_;
    	    eval q((($port)-> &flags &  &UPF_HARDPPS_CD || ($cflag) &  &CRTSCTS || !(($cflag) &  &CLOCAL)));
	}' unless defined(&UART_ENABLE_MS);
    }
}
1;
