require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_NFS_FS_H)) {
    eval 'sub _LINUX_NFS_FS_H () {1;}' unless defined(&_LINUX_NFS_FS_H);
    require 'linux/config.ph';
    require 'linux/in.ph';
    require 'linux/mm.ph';
    require 'linux/pagemap.ph';
    require 'linux/rwsem.ph';
    require 'linux/wait.ph';
    require 'linux/uio.ph';
    require 'linux/nfs_fs_sb.ph';
    require 'linux/sunrpc/debug.ph';
    require 'linux/sunrpc/auth.ph';
    require 'linux/sunrpc/clnt.ph';
    require 'linux/nfs.ph';
    require 'linux/nfs2.ph';
    require 'linux/nfs3.ph';
    require 'linux/nfs4.ph';
    require 'linux/nfs_xdr.ph';
    require 'linux/rwsem.ph';
    require 'linux/workqueue.ph';
    require 'linux/mempool.ph';
    if(defined(&RPC_DEBUG)) {
	eval 'sub NFS_DEBUG () {1;}' unless defined(&NFS_DEBUG);
    }
    eval 'sub NFS_MAX_FILE_IO_BUFFER_SIZE () {32768;}' unless defined(&NFS_MAX_FILE_IO_BUFFER_SIZE);
    eval 'sub NFS_DEF_FILE_IO_BUFFER_SIZE () {4096;}' unless defined(&NFS_DEF_FILE_IO_BUFFER_SIZE);
    eval 'sub NFS_WRITEBACK_DELAY () {(5* &HZ);}' unless defined(&NFS_WRITEBACK_DELAY);
    eval 'sub NFS_WRITEBACK_LOCKDELAY () {(60* &HZ);}' unless defined(&NFS_WRITEBACK_LOCKDELAY);
    eval 'sub NFS_COMMIT_DELAY () {(5* &HZ);}' unless defined(&NFS_COMMIT_DELAY);
    eval 'sub NFS_SUPER_MAGIC () {0x6969;}' unless defined(&NFS_SUPER_MAGIC);
    eval 'sub NFS_RPC_SWAPFLAGS () {( &RPC_TASK_SWAPPER| &RPC_TASK_ROOTCREDS);}' unless defined(&NFS_RPC_SWAPFLAGS);
    eval 'sub NFS_RW_SYNC () {0x1;}' unless defined(&NFS_RW_SYNC);
    eval 'sub NFS_RW_SWAP () {0x2;}' unless defined(&NFS_RW_SWAP);
    eval 'sub FLUSH_AGING () {0;}' unless defined(&FLUSH_AGING);
    eval 'sub FLUSH_SYNC () {1;}' unless defined(&FLUSH_SYNC);
    eval 'sub FLUSH_WAIT () {2;}' unless defined(&FLUSH_WAIT);
    eval 'sub FLUSH_STABLE () {4;}' unless defined(&FLUSH_STABLE);
    eval 'sub FLUSH_LOWPRI () {8;}' unless defined(&FLUSH_LOWPRI);
    eval 'sub FLUSH_HIGHPRI () {16;}' unless defined(&FLUSH_HIGHPRI);
    if(defined(&__KERNEL__)) {
	if(defined(&CONFIG_NFS_V4)) {
	}
	eval 'sub NFS_INO_STALE () {0x1;}' unless defined(&NFS_INO_STALE);
	eval 'sub NFS_INO_ADVISE_RDPLUS () {0x2;}' unless defined(&NFS_INO_ADVISE_RDPLUS);
	eval 'sub NFS_INO_REVALIDATING () {0x4;}' unless defined(&NFS_INO_REVALIDATING);
	eval 'sub NFS_INO_INVALID_ATTR () {0x8;}' unless defined(&NFS_INO_INVALID_ATTR);
	eval 'sub NFS_INO_INVALID_DATA () {0x10;}' unless defined(&NFS_INO_INVALID_DATA);
	eval 'sub NFS_INO_INVALID_ATIME () {0x20;}' unless defined(&NFS_INO_INVALID_ATIME);
	eval 'sub NFS_INO_INVALID_ACCESS () {0x40;}' unless defined(&NFS_INO_INVALID_ACCESS);
	eval 'sub nfs_inode {
	    eval q(* &NFS_I(\'struct inode\' * &inode) {  &container_of( &inode, \'struct nfs_inode\',  &vfs_inode); });
	}' unless defined(&nfs_inode);
	eval 'sub NFS_SB {
	    my($s) = @_;
    	    eval q((( ($s->{s_fs_info}))));
	}' unless defined(&NFS_SB);
	eval 'sub NFS_FH {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &fh));
	}' unless defined(&NFS_FH);
	eval 'sub NFS_SERVER {
	    my($inode) = @_;
    	    eval q(( &NFS_SB( ($inode->{i_sb}))));
	}' unless defined(&NFS_SERVER);
	eval 'sub NFS_CLIENT {
	    my($inode) = @_;
    	    eval q(( &NFS_SERVER($inode)-> &client));
	}' unless defined(&NFS_CLIENT);
	eval 'sub NFS_PROTO {
	    my($inode) = @_;
    	    eval q(( &NFS_SERVER($inode)-> &rpc_ops));
	}' unless defined(&NFS_PROTO);
	eval 'sub NFS_ADDR {
	    my($inode) = @_;
    	    eval q(( &RPC_PEERADDR( &NFS_CLIENT($inode))));
	}' unless defined(&NFS_ADDR);
	eval 'sub NFS_COOKIEVERF {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &cookieverf));
	}' unless defined(&NFS_COOKIEVERF);
	eval 'sub NFS_READTIME {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &read_cache_jiffies));
	}' unless defined(&NFS_READTIME);
	eval 'sub NFS_CHANGE_ATTR {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &change_attr));
	}' unless defined(&NFS_CHANGE_ATTR);
	eval 'sub NFS_ATTRTIMEO {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &attrtimeo));
	}' unless defined(&NFS_ATTRTIMEO);
	eval 'sub NFS_MINATTRTIMEO {
	    my($inode) = @_;
    	    eval q(( &S_ISDIR( ($inode->{i_mode}))?  &NFS_SERVER($inode)-> &acdirmin :  &NFS_SERVER($inode)-> &acregmin));
	}' unless defined(&NFS_MINATTRTIMEO);
	eval 'sub NFS_MAXATTRTIMEO {
	    my($inode) = @_;
    	    eval q(( &S_ISDIR( ($inode->{i_mode}))?  &NFS_SERVER($inode)-> &acdirmax :  &NFS_SERVER($inode)-> &acregmax));
	}' unless defined(&NFS_MAXATTRTIMEO);
	eval 'sub NFS_ATTRTIMEO_UPDATE {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &attrtimeo_timestamp));
	}' unless defined(&NFS_ATTRTIMEO_UPDATE);
	eval 'sub NFS_FLAGS {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &flags));
	}' unless defined(&NFS_FLAGS);
	eval 'sub NFS_REVALIDATING {
	    my($inode) = @_;
    	    eval q(( &NFS_FLAGS($inode) &  &NFS_INO_REVALIDATING));
	}' unless defined(&NFS_REVALIDATING);
	eval 'sub NFS_STALE {
	    my($inode) = @_;
    	    eval q(( &NFS_FLAGS($inode) &  &NFS_INO_STALE));
	}' unless defined(&NFS_STALE);
	eval 'sub NFS_FILEID {
	    my($inode) = @_;
    	    eval q(( &NFS_I($inode)-> &fileid));
	}' unless defined(&NFS_FILEID);
	eval 'sub nfs_caches_unstable {
	    my($inode) = @_;
    	    eval q({  &atomic_read( &NFS_I($inode)-> &data_updates) != 0; });
	}' unless defined(&nfs_caches_unstable);
	eval 'sub NFS_CACHEINV {
	    my($inode) = @_;
    	    eval q({  &if (! &nfs_caches_unstable($inode))  &NFS_FLAGS($inode) |=  &NFS_INO_INVALID_ATTR |  &NFS_INO_INVALID_ACCESS; });
	}' unless defined(&NFS_CACHEINV);
	eval 'sub nfs_server_capable {
	    my($inode,$cap) = @_;
    	    eval q({  &NFS_SERVER($inode)-> &caps & $cap; });
	}' unless defined(&nfs_server_capable);
	eval 'sub NFS_USE_READDIRPLUS {
	    my($inode) = @_;
    	    eval q({  &NFS_FLAGS($inode) &  &NFS_INO_ADVISE_RDPLUS; });
	}' unless defined(&NFS_USE_READDIRPLUS);
	eval 'sub rpc_cred {
	    eval q(* &nfs_file_cred(\'struct file\' * &file) {  &if ( &file !=  &NULL) { \'struct nfs_open_context\' * &ctx;  &ctx =  ($file->{private_data});  ($ctx->{cred}); }  &NULL; });
	}' unless defined(&rpc_cred);
	if(defined( &CONFIG_NFS_V3) || defined( &CONFIG_NFS_V4)) {
	}
	if(defined( &CONFIG_NFS_V3) || defined( &CONFIG_NFS_V4)) {
	} else {
	    eval 'sub nfs_commit_inode {
	        my($inode,$idx_start,$npages,$how) = @_;
    		eval q({ 0; });
	    }' unless defined(&nfs_commit_inode);
	}
	eval 'sub nfs_have_writebacks {
	    my($inode) = @_;
    	    eval q({  &NFS_I($inode)-> &npages != 0; });
	}' unless defined(&nfs_have_writebacks);
	eval 'sub nfs_wb_all {
	    my($inode) = @_;
    	    eval q({ \'int\'  &error =  &nfs_sync_inode($inode, 0, 0,  &FLUSH_WAIT); ( &error < 0) ?  &error : 0; });
	}' unless defined(&nfs_wb_all);
	eval 'sub nfs_wb_page {
	    my($inode,$page) = @_;
    	    eval q({  &nfs_wb_page_priority($inode, $page, 0); });
	}' unless defined(&nfs_wb_page);
	eval 'sub nfs_write_data {
	    eval q(* &nfs_writedata_alloc( &void) { \'struct nfs_write_data\' * &p =  &mempool_alloc( &nfs_wdata_mempool,  &SLAB_NOFS);  &if ( &p) {  &memset( &p, 0, $sizeof{ &p});  &INIT_LIST_HEAD( ($p->{pages})); }  &p; });
	}' unless defined(&nfs_write_data);
	eval 'sub nfs_writedata_free {
	    my($p) = @_;
    	    eval q({  &mempool_free($p,  &nfs_wdata_mempool); });
	}' unless defined(&nfs_writedata_free);
	eval 'sub nfs_write_data {
	    eval q(* &nfs_commit_alloc( &void) { \'struct nfs_write_data\' * &p =  &mempool_alloc( &nfs_commit_mempool,  &SLAB_NOFS);  &if ( &p) {  &memset( &p, 0, $sizeof{ &p});  &INIT_LIST_HEAD( ($p->{pages})); }  &p; });
	}' unless defined(&nfs_write_data);
	eval 'sub nfs_commit_free {
	    my($p) = @_;
    	    eval q({  &mempool_free($p,  &nfs_commit_mempool); });
	}' unless defined(&nfs_commit_free);
	unless(defined(&IS_SWAPFILE)) {
	    eval 'sub IS_SWAPFILE {
	        my($inode) = @_;
    		eval q((0));
	    }' unless defined(&IS_SWAPFILE);
	}
	eval 'sub nfs_read_data {
	    eval q(* &nfs_readdata_alloc( &void) { \'struct nfs_read_data\' * &p =  &mempool_alloc( &nfs_rdata_mempool,  &SLAB_NOFS);  &if ( &p)  &memset( &p, 0, $sizeof{ &p});  &p; });
	}' unless defined(&nfs_read_data);
	eval 'sub nfs_readdata_free {
	    my($p) = @_;
    	    eval q({  &mempool_free($p,  &nfs_rdata_mempool); });
	}' unless defined(&nfs_readdata_free);
	eval 'sub nfs_fileid_to_ino_t {
	    my($fileid) = @_;
    	    eval q({  &ino_t  &ino = ( &ino_t) $fileid;  &if ($sizeof{ &ino_t} < $sizeof{ &u64})  &ino ^= $fileid >> ($sizeof{ &u64}-$sizeof{ &ino_t}) * 8;  &ino; });
	}' unless defined(&nfs_fileid_to_ino_t);
	eval 'sub nfs_wait_event {
	    my($clnt, $wq, $condition) = @_;
    	    eval q(({ \'int\'  &__retval = 0;  &if ( ($clnt->{cl_intr})) {  &sigset_t  &oldmask;  &rpc_clnt_sigmask($clnt,  &oldmask);  &__retval =  &wait_event_interruptible($wq, $condition);  &rpc_clnt_sigunmask($clnt,  &oldmask); }  &else  &wait_event($wq, $condition);  &__retval; }));
	}' unless defined(&nfs_wait_event);
	eval 'sub NFS_JUKEBOX_RETRY_TIME () {(5*  &HZ);}' unless defined(&NFS_JUKEBOX_RETRY_TIME);
	if(defined(&CONFIG_NFS_V4)) {
	    eval 'sub seqid_mutating_err {
	        my($err) = @_;
    		eval q(((($err) !=  &NFSERR_STALE_CLIENTID)  && (($err) !=  &NFSERR_STALE_STATEID)  && (($err) !=  &NFSERR_BAD_STATEID)  && (($err) !=  &NFSERR_BAD_SEQID)  && (($err) !=  &NFSERR_BAD_XDR)  && (($err) !=  &NFSERR_RESOURCE)  && (($err) !=  &NFSERR_NOFILEHANDLE)));
	    }' unless defined(&seqid_mutating_err);
	    eval("sub NFS4CLNT_OK () { 0; }") unless defined(&NFS4CLNT_OK);
	    eval 'sub NFS_LOCK_INITIALIZED () {1;}' unless defined(&NFS_LOCK_INITIALIZED);
	    eval("sub LK_STATE_IN_USE () { 0; }") unless defined(&LK_STATE_IN_USE);
	    eval("sub NFS_DELEGATED_STATE () { 1; }") unless defined(&NFS_DELEGATED_STATE);
	} else {
	    eval 'sub init_nfsv4_state {
	        my($server) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&init_nfsv4_state);
	    eval 'sub destroy_nfsv4_state {
	        my($server) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&destroy_nfsv4_state);
	    eval 'sub nfs4_put_state_owner {
	        my($inode, $owner) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&nfs4_put_state_owner);
	    eval 'sub nfs4_put_open_state {
	        my($state) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&nfs4_put_open_state);
	    eval 'sub nfs4_close_state {
	        my($a, $b) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&nfs4_close_state);
	    eval 'sub nfs4_renewd_prepare_shutdown {
	        my($server) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&nfs4_renewd_prepare_shutdown);
	}
    }
    eval 'sub NFSDBG_VFS () {0x1;}' unless defined(&NFSDBG_VFS);
    eval 'sub NFSDBG_DIRCACHE () {0x2;}' unless defined(&NFSDBG_DIRCACHE);
    eval 'sub NFSDBG_LOOKUPCACHE () {0x4;}' unless defined(&NFSDBG_LOOKUPCACHE);
    eval 'sub NFSDBG_PAGECACHE () {0x8;}' unless defined(&NFSDBG_PAGECACHE);
    eval 'sub NFSDBG_PROC () {0x10;}' unless defined(&NFSDBG_PROC);
    eval 'sub NFSDBG_XDR () {0x20;}' unless defined(&NFSDBG_XDR);
    eval 'sub NFSDBG_FILE () {0x40;}' unless defined(&NFSDBG_FILE);
    eval 'sub NFSDBG_ROOT () {0x80;}' unless defined(&NFSDBG_ROOT);
    eval 'sub NFSDBG_CALLBACK () {0x100;}' unless defined(&NFSDBG_CALLBACK);
    eval 'sub NFSDBG_ALL () {0xffff;}' unless defined(&NFSDBG_ALL);
    if(defined(&__KERNEL__)) {
	undef(&ifdebug) if defined(&ifdebug);
	if(defined(&NFS_DEBUG)) {
	    eval 'sub ifdebug {
	        my($fac) = @_;
    		eval q( &if ( &unlikely( &nfs_debug &  &NFSDBG_$fac)));
	    }' unless defined(&ifdebug);
	} else {
	    eval 'sub ifdebug {
	        my($fac) = @_;
    		eval q( &if (0));
	    }' unless defined(&ifdebug);
	}
    }
}
1;
