require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_NETFILTER_H)) {
    eval 'sub __LINUX_NETFILTER_H () {1;}' unless defined(&__LINUX_NETFILTER_H);
    if(defined(&__KERNEL__)) {
	require 'linux/init.ph';
	require 'linux/types.ph';
	require 'linux/skbuff.ph';
	require 'linux/net.ph';
	require 'linux/if.ph';
	require 'linux/wait.ph';
	require 'linux/list.ph';
    }
    require 'linux/compiler.ph';
    eval 'sub NF_DROP () {0;}' unless defined(&NF_DROP);
    eval 'sub NF_ACCEPT () {1;}' unless defined(&NF_ACCEPT);
    eval 'sub NF_STOLEN () {2;}' unless defined(&NF_STOLEN);
    eval 'sub NF_QUEUE () {3;}' unless defined(&NF_QUEUE);
    eval 'sub NF_REPEAT () {4;}' unless defined(&NF_REPEAT);
    eval 'sub NF_MAX_VERDICT () { &NF_REPEAT;}' unless defined(&NF_MAX_VERDICT);
    eval 'sub NFC_UNKNOWN () {0x4000;}' unless defined(&NFC_UNKNOWN);
    eval 'sub NFC_ALTERED () {0x8000;}' unless defined(&NFC_ALTERED);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	if(defined(&CONFIG_NETFILTER)) {
	    eval 'sub NF_MAX_HOOKS () {8;}' unless defined(&NF_MAX_HOOKS);
	    if(defined(&CONFIG_NETFILTER_DEBUG)) {
		eval 'sub NF_HOOK {
		    my($pf, $hook, $skb, $indev, $outdev, $okfn) = @_;
    		    eval q( &nf_hook_slow(($pf), ($hook), ($skb), ($indev), ($outdev), ($okfn),  &INT_MIN));
		}' unless defined(&NF_HOOK);
		eval 'sub NF_HOOK_THRESH () { &nf_hook_slow;}' unless defined(&NF_HOOK_THRESH);
	    } else {
		eval 'sub NF_HOOK {
		    my($pf, $hook, $skb, $indev, $outdev, $okfn) = @_;
    		    eval q(( &list_empty( $nf_hooks[($pf)][($hook)]) ? ($okfn)($skb) :  &nf_hook_slow(($pf), ($hook), ($skb), ($indev), ($outdev), ($okfn),  &INT_MIN)));
		}' unless defined(&NF_HOOK);
		eval 'sub NF_HOOK_THRESH {
		    my($pf, $hook, $skb, $indev, $outdev, $okfn, $thresh) = @_;
    		    eval q(( &list_empty( $nf_hooks[($pf)][($hook)]) ? ($okfn)($skb) :  &nf_hook_slow(($pf), ($hook), ($skb), ($indev), ($outdev), ($okfn), ($thresh))));
		}' unless defined(&NF_HOOK_THRESH);
	    }
	} else {
	    eval 'sub NF_HOOK {
	        my($pf, $hook, $skb, $indev, $outdev, $okfn) = @_;
    		eval q(($okfn)($skb));
	    }' unless defined(&NF_HOOK);
	}
    }
}
1;
