require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_MM_H)) {
    eval 'sub _LINUX_MM_H () {1;}' unless defined(&_LINUX_MM_H);
    require 'linux/sched.ph';
    require 'linux/errno.ph';
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	require 'linux/gfp.ph';
	require 'linux/list.ph';
	require 'linux/mmzone.ph';
	require 'linux/rbtree.ph';
	require 'linux/prio_tree.ph';
	require 'linux/fs.ph';
	unless(defined(&CONFIG_DISCONTIGMEM)) {
	}
	if(defined(&CONFIG_SYSCTL)) {
	} else {
	    eval 'sub sysctl_legacy_va_layout () {0;}' unless defined(&sysctl_legacy_va_layout);
	}
	require 'asm/page.ph';
	require 'asm/pgtable.ph';
	require 'asm/processor.ph';
	require 'asm/atomic.ph';
	unless(defined(&MM_VM_SIZE)) {
	    eval 'sub MM_VM_SIZE {
	        my($mm) = @_;
    		eval q((( &TASK_SIZE +  &PGDIR_SIZE - 1) &  &PGDIR_MASK));
	    }' unless defined(&MM_VM_SIZE);
	}
	eval 'sub nth_page {
	    my($page,$n) = @_;
    	    eval q( &pfn_to_page( &page_to_pfn(($page)) + ($n)));
	}' unless defined(&nth_page);
	unless(defined(&CONFIG_MMU)) {
	}
	if(defined(&CONFIG_NUMA)) {
	}
	unless(defined(&CONFIG_MMU)) {
	}
	eval 'sub VM_READ () {0x1;}' unless defined(&VM_READ);
	eval 'sub VM_WRITE () {0x2;}' unless defined(&VM_WRITE);
	eval 'sub VM_EXEC () {0x4;}' unless defined(&VM_EXEC);
	eval 'sub VM_SHARED () {0x8;}' unless defined(&VM_SHARED);
	eval 'sub VM_MAYREAD () {0x10;}' unless defined(&VM_MAYREAD);
	eval 'sub VM_MAYWRITE () {0x20;}' unless defined(&VM_MAYWRITE);
	eval 'sub VM_MAYEXEC () {0x40;}' unless defined(&VM_MAYEXEC);
	eval 'sub VM_MAYSHARE () {0x80;}' unless defined(&VM_MAYSHARE);
	eval 'sub VM_GROWSDOWN () {0x100;}' unless defined(&VM_GROWSDOWN);
	eval 'sub VM_GROWSUP () {0x200;}' unless defined(&VM_GROWSUP);
	eval 'sub VM_SHM () {0x400;}' unless defined(&VM_SHM);
	eval 'sub VM_DENYWRITE () {0x800;}' unless defined(&VM_DENYWRITE);
	eval 'sub VM_EXECUTABLE () {0x1000;}' unless defined(&VM_EXECUTABLE);
	eval 'sub VM_LOCKED () {0x2000;}' unless defined(&VM_LOCKED);
	eval 'sub VM_IO () {0x4000;}' unless defined(&VM_IO);
	eval 'sub VM_SEQ_READ () {0x8000;}' unless defined(&VM_SEQ_READ);
	eval 'sub VM_RAND_READ () {0x10000;}' unless defined(&VM_RAND_READ);
	eval 'sub VM_DONTCOPY () {0x20000;}' unless defined(&VM_DONTCOPY);
	eval 'sub VM_DONTEXPAND () {0x40000;}' unless defined(&VM_DONTEXPAND);
	eval 'sub VM_RESERVED () {0x80000;}' unless defined(&VM_RESERVED);
	eval 'sub VM_ACCOUNT () {0x100000;}' unless defined(&VM_ACCOUNT);
	eval 'sub VM_HUGETLB () {0x400000;}' unless defined(&VM_HUGETLB);
	eval 'sub VM_NONLINEAR () {0x800000;}' unless defined(&VM_NONLINEAR);
	unless(defined(&VM_STACK_DEFAULT_FLAGS)) {
	    eval 'sub VM_STACK_DEFAULT_FLAGS () { &VM_DATA_DEFAULT_FLAGS;}' unless defined(&VM_STACK_DEFAULT_FLAGS);
	}
	if(defined(&CONFIG_STACK_GROWSUP)) {
	    eval 'sub VM_STACK_FLAGS () {( &VM_GROWSUP |  &VM_STACK_DEFAULT_FLAGS |  &VM_ACCOUNT);}' unless defined(&VM_STACK_FLAGS);
	} else {
	    eval 'sub VM_STACK_FLAGS () {( &VM_GROWSDOWN |  &VM_STACK_DEFAULT_FLAGS |  &VM_ACCOUNT);}' unless defined(&VM_STACK_FLAGS);
	}
	eval 'sub VM_READHINTMASK () {( &VM_SEQ_READ |  &VM_RAND_READ);}' unless defined(&VM_READHINTMASK);
	eval 'sub VM_ClearReadHint {
	    my($v) = @_;
    	    eval q(($v)-> &vm_flags &= ~ &VM_READHINTMASK);
	}' unless defined(&VM_ClearReadHint);
	eval 'sub VM_NormalReadHint {
	    my($v) = @_;
    	    eval q((!(($v)-> &vm_flags &  &VM_READHINTMASK)));
	}' unless defined(&VM_NormalReadHint);
	eval 'sub VM_SequentialReadHint {
	    my($v) = @_;
    	    eval q((($v)-> &vm_flags &  &VM_SEQ_READ));
	}' unless defined(&VM_SequentialReadHint);
	eval 'sub VM_RandomReadHint {
	    my($v) = @_;
    	    eval q((($v)-> &vm_flags &  &VM_RAND_READ));
	}' unless defined(&VM_RandomReadHint);
	if(defined(&CONFIG_NUMA)) {
	}
	if(defined(&ARCH_HAS_ATOMIC_UNSIGNED)) {
	} else {
	}
	if(defined( &WANT_PAGE_VIRTUAL)) {
	}
	require 'linux/page-flags.ph';
	eval 'sub put_page_testzero {
	    my($p) = @_;
    	    eval q(({  &BUG_ON( &page_count($p) == 0);  &atomic_add_negative(-1, ($p)-> &_count); }));
	}' unless defined(&put_page_testzero);
	eval 'sub get_page_testone {
	    my($p) = @_;
    	    eval q( &atomic_inc_and_test(($p)-> &_count));
	}' unless defined(&get_page_testone);
	eval 'sub set_page_count {
	    my($p,$v) = @_;
    	    eval q( &atomic_set(($p)-> &_count, $v - 1));
	}' unless defined(&set_page_count);
	eval 'sub __put_page {
	    my($p) = @_;
    	    eval q( &atomic_dec(($p)-> &_count));
	}' unless defined(&__put_page);
	if(defined(&CONFIG_HUGETLB_PAGE)) {
	    eval 'sub page_count {
	        my($p) = @_;
    		eval q({  &if ( &PageCompound($p)) $p =  ($p->{private});  &atomic_read(($p)-> &_count) + 1; });
	    }' unless defined(&page_count);
	    eval 'sub get_page {
	        my($page) = @_;
    		eval q({  &if ( &unlikely( &PageCompound($page))) $page =  ($page->{private});  &atomic_inc( ($page->{_count})); });
	    }' unless defined(&get_page);
	} else {
	    eval 'sub page_count {
	        my($p) = @_;
    		eval q(( &atomic_read(($p)-> &_count) + 1));
	    }' unless defined(&page_count);
	    eval 'sub get_page {
	        my($page) = @_;
    		eval q({  &atomic_inc( ($page->{_count})); });
	    }' unless defined(&get_page);
	    eval 'sub put_page {
	        my($page) = @_;
    		eval q({  &if (! &PageReserved($page)  &&  &put_page_testzero($page))  &__page_cache_release($page); });
	    }' unless defined(&put_page);
	}
	eval 'sub NODEZONE_SHIFT () {($sizeof{ &page_flags_t}*8-  &MAX_NODES_SHIFT -  &MAX_ZONES_SHIFT);}' unless defined(&NODEZONE_SHIFT);
	eval 'sub NODEZONE {
	    my($node, $zone) = @_;
    	    eval q((($node <<  &ZONES_SHIFT) | $zone));
	}' unless defined(&NODEZONE);
	eval 'sub page_zonenum {
	    my($page) = @_;
    	    eval q({ ( ($page->{flags}) >>  &NODEZONE_SHIFT) & (~(~0 <<  &ZONES_SHIFT)); });
	}' unless defined(&page_zonenum);
	eval 'sub page_to_nid {
	    my($page) = @_;
    	    eval q({ ( ($page->{flags}) >> ( &NODEZONE_SHIFT +  &ZONES_SHIFT)); });
	}' unless defined(&page_to_nid);
	eval 'sub zone {
	    eval q(* &page_zone(\'struct page\' * &page) {  $zone_table[ ($page->{flags}) >>  &NODEZONE_SHIFT]; });
	}' unless defined(&zone);
	eval 'sub set_page_zone {
	    my($page,$nodezone_num) = @_;
    	    eval q({  ($page->{flags}) &= ~(~0 <<  &NODEZONE_SHIFT);  ($page->{flags}) |= $nodezone_num <<  &NODEZONE_SHIFT; });
	}' unless defined(&set_page_zone);
	unless(defined(&CONFIG_DISCONTIGMEM)) {
	}
	eval 'sub void {
	    eval q(* &lowmem_page_address(\'struct page\' * &page) {  &__va( &page_to_pfn( &page) <<  &PAGE_SHIFT); });
	}' unless defined(&void);
	if(defined( &CONFIG_HIGHMEM)  && !defined( &WANT_PAGE_VIRTUAL)) {
	    eval 'sub HASHED_PAGE_VIRTUAL () {1;}' unless defined(&HASHED_PAGE_VIRTUAL);
	}
	if(defined( &WANT_PAGE_VIRTUAL)) {
	    eval 'sub page_address {
	        my($page) = @_;
    		eval q((($page)-> &virtual));
	    }' unless defined(&page_address);
	    eval 'sub set_page_address {
	        my($page, $address) = @_;
    		eval q( &do { ($page)-> &virtual = ($address); }  &while(0));
	    }' unless defined(&set_page_address);
	    eval 'sub page_address_init () {
	        eval q( &do { }  &while(0));
	    }' unless defined(&page_address_init);
	}
	if(defined( &HASHED_PAGE_VIRTUAL)) {
	}
	if(!defined( &HASHED_PAGE_VIRTUAL)  && !defined( &WANT_PAGE_VIRTUAL)) {
	    eval 'sub page_address {
	        my($page) = @_;
    		eval q( &lowmem_page_address($page));
	    }' unless defined(&page_address);
	    eval 'sub set_page_address {
	        my($page, $address) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&set_page_address);
	    eval 'sub page_address_init () {
	        eval q( &do { }  &while(0));
	    }' unless defined(&page_address_init);
	}
	eval 'sub PAGE_MAPPING_ANON () {1;}' unless defined(&PAGE_MAPPING_ANON);
	eval 'sub address_space {
	    eval q(* &page_mapping(\'struct page\' * &page) { \'struct address_space\' * &mapping =  ($page->{mapping});  &if ( &unlikely)  &mapping =  &swapper_space;  &else  &if ( &unlikely( &mapping &  &PAGE_MAPPING_ANON))  &mapping =  &NULL;  &mapping; });
	}' unless defined(&address_space);
	eval 'sub PageAnon {
	    my($page) = @_;
    	    eval q({ ( ($page->{mapping}) &  &PAGE_MAPPING_ANON) != 0; });
	}' unless defined(&PageAnon);
	eval 'sub page_mapcount {
	    my($page) = @_;
    	    eval q({  &atomic_read(($page)-> &_mapcount) + 1; });
	}' unless defined(&page_mapcount);
	eval 'sub NOPAGE_SIGBUS () {( &NULL);}' unless defined(&NOPAGE_SIGBUS);
	eval 'sub NOPAGE_OOM () {( (-1));}' unless defined(&NOPAGE_OOM);
	eval 'sub VM_FAULT_OOM () {(-1);}' unless defined(&VM_FAULT_OOM);
	eval 'sub VM_FAULT_SIGBUS () {0;}' unless defined(&VM_FAULT_SIGBUS);
	eval 'sub VM_FAULT_MINOR () {1;}' unless defined(&VM_FAULT_MINOR);
	eval 'sub VM_FAULT_MAJOR () {2;}' unless defined(&VM_FAULT_MAJOR);
	eval 'sub offset_in_page {
	    my($p) = @_;
    	    eval q((($p) & ~ &PAGE_MASK));
	}' unless defined(&offset_in_page);
	if(defined(&CONFIG_SHMEM)) {
	} else {
	    eval 'sub shmem_nopage () { &filemap_nopage;}' unless defined(&shmem_nopage);
	    eval 'sub shmem_lock {
	        my($a, $b, $c) = @_;
    		eval q(({0;}));
	    }' unless defined(&shmem_lock);
	    eval 'sub shmem_set_policy {
	        my($a, $b) = @_;
    		eval q((0));
	    }' unless defined(&shmem_set_policy);
	    eval 'sub shmem_get_policy {
	        my($a, $b) = @_;
    		eval q(( &NULL));
	    }' unless defined(&shmem_get_policy);
	}
	eval 'sub can_do_mlock {
	    my($void) = @_;
    	    eval q({  &if ( &capable( &CAP_IPC_LOCK)) 1;  &if ( ($current->{signal}->{rlim[&RLIMIT_MEMLOCK]}->{rlim_cur}) != 0) 1; 0; });
	}' unless defined(&can_do_mlock);
	eval 'sub unmap_shared_mapping_range {
	    my($mapping,$holebegin,$holelen) = @_;
    	    eval q({  &unmap_mapping_range($mapping, $holebegin, $holelen, 0); });
	}' unless defined(&unmap_shared_mapping_range);
	eval 'sub DEFAULT_SEEKS () {2;}' unless defined(&DEFAULT_SEEKS);
	if(defined(&CONFIG_MMU)) {
	    unless(defined(&__ARCH_HAS_4LEVEL_HACK)) {
		eval 'sub pud_t {
		    eval q(* &pud_alloc(\'struct mm_struct\' * &mm,  &pgd_t * &pgd, my $address) {  &if ( &pgd_none(* &pgd))  &__pud_alloc( &mm,  &pgd,  $address);  &pud_offset( &pgd,  $address); });
		}' unless defined(&pud_t);
		eval 'sub pmd_t {
		    eval q(* &pmd_alloc(\'struct mm_struct\' * &mm,  &pud_t * &pud, my $address) {  &if ( &pud_none(* &pud))  &__pmd_alloc( &mm,  &pud,  $address);  &pmd_offset( &pud,  $address); });
		}' unless defined(&pmd_t);
	    }
	}
	eval 'sub vma_prio_tree_foreach {
	    my($vma, $iter, $root, $begin, $end) = @_;
    	    eval q( &for ( &prio_tree_iter_init($iter, $root, $begin, $end), $vma =  &NULL; ($vma =  &vma_prio_tree_next($vma, $iter)); ));
	}' unless defined(&vma_prio_tree_foreach);
	eval 'sub vma_nonlinear_insert {
	    my($vma,$list) = @_;
    	    eval q({  ($vma->{shared}->{vm_set}->{parent}) =  &NULL;  &list_add_tail( ($vma->{shared}->{vm_set}->{list}), $list); });
	}' unless defined(&vma_nonlinear_insert);
	eval 'sub do_mmap {
	    my($file,$addr,$len,$prot,$flag,$offset) = @_;
    	    eval q({ my $ret = - &EINVAL;  &if (($offset +  &PAGE_ALIGN($len)) < $offset)  &goto  &out;  &if (!($offset & ~ &PAGE_MASK))  $ret =  &do_mmap_pgoff($file, $addr, $len, $prot, $flag, $offset >>  &PAGE_SHIFT);  &out:  $ret; });
	}' unless defined(&do_mmap);
	eval 'sub VM_MAX_READAHEAD () {128;}' unless defined(&VM_MAX_READAHEAD);
	eval 'sub VM_MIN_READAHEAD () {16;}' unless defined(&VM_MIN_READAHEAD);
	eval 'sub VM_MAX_CACHE_HIT () {256;}' unless defined(&VM_MAX_CACHE_HIT);
	eval 'sub vma_pages {
	    my($vma) = @_;
    	    eval q({ ( ($vma->{vm_end}) -  ($vma->{vm_start})) >>  &PAGE_SHIFT; });
	}' unless defined(&vma_pages);
	if(defined(&CONFIG_PROC_FS)) {
	} else {
	    eval 'sub __vm_stat_account {
	        my($mm,$flags,$file,$pages) = @_;
    		eval q({ });
	    }' unless defined(&__vm_stat_account);
	}
	eval 'sub vm_stat_account {
	    my($vma) = @_;
    	    eval q({  &__vm_stat_account( ($vma->{vm_mm}),  ($vma->{vm_flags}),  ($vma->{vm_file}),  &vma_pages($vma)); });
	}' unless defined(&vm_stat_account);
	eval 'sub vm_stat_unaccount {
	    my($vma) = @_;
    	    eval q({  &__vm_stat_account( ($vma->{vm_mm}),  ($vma->{vm_flags}),  ($vma->{vm_file}), - &vma_pages($vma)); });
	}' unless defined(&vm_stat_unaccount);
	unless(defined(&CONFIG_DEBUG_PAGEALLOC)) {
	    eval 'sub kernel_map_pages {
	        my($page,$numpages,$enable) = @_;
    		eval q({ });
	    }' unless defined(&kernel_map_pages);
	}
	if(defined(&__HAVE_ARCH_GATE_AREA)) {
	} else {
	    eval 'sub in_gate_area {
	        my($task, $addr) = @_;
    		eval q(({( &void)$task;  &in_gate_area_no_task($addr);}));
	    }' unless defined(&in_gate_area);
	}
    }
}
1;
