require '_h2ph_pre.ph';

no warnings 'redefine';

require 'linux/init.ph';
require 'linux/posix_acl.ph';
require 'linux/xattr_acl.ph';
unless(defined(&REISERFS_ACL_VERSION)) {
    sub REISERFS_ACL_VERSION () {	0x1;}
}
unless(defined(&reiserfs_acl_size)) {
    sub reiserfs_acl_size {
	my($count) = @_;
	eval q({  &if ($count <= 4) { $sizeof{ &reiserfs_acl_header} + $count * $sizeof{'reiserfs_acl_entry_short'}; }  &else { $sizeof{ &reiserfs_acl_header} + 4* $sizeof{'reiserfs_acl_entry_short'} + ($count - 4) * $sizeof{ &reiserfs_acl_entry}; } });
    }
}
unless(defined(&reiserfs_acl_count)) {
    sub reiserfs_acl_count {
	my($size) = @_;
	eval q({  &ssize_t  &s; $size -= $sizeof{ &reiserfs_acl_header};  &s = $size - 4* $sizeof{'reiserfs_acl_entry_short'};  &if ( &s < 0) {  &if ($size % $sizeof{'reiserfs_acl_entry_short'}) -1; $size / $sizeof{'reiserfs_acl_entry_short'}; }  &else {  &if ( &s % $sizeof{ &reiserfs_acl_entry}) -1;  &s / $sizeof{ &reiserfs_acl_entry} + 4; } });
    }
}
if(defined(&CONFIG_REISERFS_FS_POSIX_ACL)) {
} else {
    eval 'sub reiserfs_get_acl () { &NULL;}' unless defined(&reiserfs_get_acl);
    eval 'sub reiserfs_cache_default_acl {
        my($inode) = @_;
	    eval q(0);
    }' unless defined(&reiserfs_cache_default_acl);
    eval 'sub reiserfs_xattr_posix_acl_init {
        my($void) = @_;
	    eval q({ 0; });
    }' unless defined(&reiserfs_xattr_posix_acl_init);
    eval 'sub reiserfs_xattr_posix_acl_exit {
        my($void) = @_;
	    eval q({ 0; });
    }' unless defined(&reiserfs_xattr_posix_acl_exit);
    eval 'sub reiserfs_acl_chmod {
        my($inode) = @_;
	    eval q({ 0; });
    }' unless defined(&reiserfs_acl_chmod);
    eval 'sub reiserfs_inherit_default_acl {
        my($dir,$dentry,$inode) = @_;
	    eval q({ 0; });
    }' unless defined(&reiserfs_inherit_default_acl);
}
1;
