require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_PAGEMAP_H)) {
    eval 'sub _LINUX_PAGEMAP_H () {1;}' unless defined(&_LINUX_PAGEMAP_H);
    require 'linux/mm.ph';
    require 'linux/fs.ph';
    require 'linux/list.ph';
    require 'linux/highmem.ph';
    require 'linux/compiler.ph';
    require 'asm/uaccess.ph';
    require 'linux/gfp.ph';
    eval 'sub AS_EIO () {( &__GFP_BITS_SHIFT + 0);}' unless defined(&AS_EIO);
    eval 'sub AS_ENOSPC () {( &__GFP_BITS_SHIFT + 1);}' unless defined(&AS_ENOSPC);
    eval 'sub mapping_gfp_mask {
        my($mapping) = @_;
	    eval q({  ($mapping->{flags}) &  &__GFP_BITS_MASK; });
    }' unless defined(&mapping_gfp_mask);
    eval 'sub PAGE_CACHE_SHIFT () { &PAGE_SHIFT;}' unless defined(&PAGE_CACHE_SHIFT);
    eval 'sub PAGE_CACHE_SIZE () { &PAGE_SIZE;}' unless defined(&PAGE_CACHE_SIZE);
    eval 'sub PAGE_CACHE_MASK () { &PAGE_MASK;}' unless defined(&PAGE_CACHE_MASK);
    eval 'sub PAGE_CACHE_ALIGN {
        my($addr) = @_;
	    eval q(((($addr)+ &PAGE_CACHE_SIZE-1) &PAGE_CACHE_MASK));
    }' unless defined(&PAGE_CACHE_ALIGN);
    eval 'sub page_cache_get {
        my($page) = @_;
	    eval q( &get_page($page));
    }' unless defined(&page_cache_get);
    eval 'sub page_cache_release {
        my($page) = @_;
	    eval q( &put_page($page));
    }' unless defined(&page_cache_release);
    eval 'sub page {
        eval q(* &page_cache_alloc(\'struct address_space\' * &x) {  &alloc_pages( &mapping_gfp_mask( &x), 0); });
    }' unless defined(&page);
    eval 'sub page {
        eval q(* &page_cache_alloc_cold(\'struct address_space\' * &x) {  &alloc_pages( &mapping_gfp_mask( &x)| &__GFP_COLD, 0); });
    }' unless defined(&page);
    if(defined(&CONFIG_SMP)) {
	eval 'sub PAGECACHE_ACCT_THRESHOLD () { &max(16,  &NR_CPUS * 2);}' unless defined(&PAGECACHE_ACCT_THRESHOLD);
    } else {
	eval 'sub pagecache_acct {
	    my($count) = @_;
    	    eval q({  &atomic_add($count,  &nr_pagecache); });
	}' unless defined(&pagecache_acct);
    }
    eval 'sub get_page_cache_size {
        my($void) = @_;
	    eval q({ \'int\'  &ret =  &atomic_read( &nr_pagecache);  &if ( &unlikely( &ret < 0))  &ret = 0;  &ret; });
    }' unless defined(&get_page_cache_size);
    eval 'sub linear_page_index {
        my($vma,$address) = @_;
	    eval q({  &pgoff_t  &pgoff = ($address -  ($vma->{vm_start})) >>  &PAGE_SHIFT;  &pgoff +=  ($vma->{vm_pgoff});  &pgoff >> ( &PAGE_CACHE_SHIFT -  &PAGE_SHIFT); });
    }' unless defined(&linear_page_index);
    eval 'sub lock_page {
        my($page) = @_;
	    eval q({  &might_sleep();  &if ( &TestSetPageLocked($page))  &__lock_page($page); });
    }' unless defined(&lock_page);
    eval 'sub fault_in_pages_readable {
        my($uaddr,$size) = @_;
	    eval q({  &volatile \'char\'  &c; \'int\'  &ret;  &ret =  &__get_user( &c, $uaddr);  &if ( &ret == 0) {  &const \'char\'  &__user * &end = $uaddr + $size - 1;  &if (($uaddr &  &PAGE_MASK) != ( &end &  &PAGE_MASK))  &__get_user( &c,  &end); } });
    }' unless defined(&fault_in_pages_readable);
}
1;
