require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&PAGE_FLAGS_H)) {
    eval 'sub PAGE_FLAGS_H () {1;}' unless defined(&PAGE_FLAGS_H);
    require 'linux/percpu.ph';
    require 'linux/cache.ph';
    require 'asm/pgtable.ph';
    eval 'sub PG_locked () {0;}' unless defined(&PG_locked);
    eval 'sub PG_error () {1;}' unless defined(&PG_error);
    eval 'sub PG_referenced () {2;}' unless defined(&PG_referenced);
    eval 'sub PG_uptodate () {3;}' unless defined(&PG_uptodate);
    eval 'sub PG_dirty () {4;}' unless defined(&PG_dirty);
    eval 'sub PG_lru () {5;}' unless defined(&PG_lru);
    eval 'sub PG_active () {6;}' unless defined(&PG_active);
    eval 'sub PG_slab () {7;}' unless defined(&PG_slab);
    eval 'sub PG_highmem () {8;}' unless defined(&PG_highmem);
    eval 'sub PG_checked () {9;}' unless defined(&PG_checked);
    eval 'sub PG_arch_1 () {10;}' unless defined(&PG_arch_1);
    eval 'sub PG_reserved () {11;}' unless defined(&PG_reserved);
    eval 'sub PG_private () {12;}' unless defined(&PG_private);
    eval 'sub PG_writeback () {13;}' unless defined(&PG_writeback);
    eval 'sub PG_nosave () {14;}' unless defined(&PG_nosave);
    eval 'sub PG_compound () {15;}' unless defined(&PG_compound);
    eval 'sub PG_swapcache () {16;}' unless defined(&PG_swapcache);
    eval 'sub PG_mappedtodisk () {17;}' unless defined(&PG_mappedtodisk);
    eval 'sub PG_reclaim () {18;}' unless defined(&PG_reclaim);
    eval 'sub PG_nosave_free () {19;}' unless defined(&PG_nosave_free);
    eval 'sub GET_PAGE_STATE_LAST () { &nr_slab;}' unless defined(&GET_PAGE_STATE_LAST);
    eval 'sub read_page_state {
        my($member) = @_;
	    eval q( &__read_page_state( &offsetof(\'struct page_state\', $member)));
    }' unless defined(&read_page_state);
    eval 'sub mod_page_state {
        my($member, $delta) = @_;
	    eval q( &__mod_page_state( &offsetof(\'struct page_state\', $member), ($delta)));
    }' unless defined(&mod_page_state);
    eval 'sub inc_page_state {
        my($member) = @_;
	    eval q( &mod_page_state($member, 1));
    }' unless defined(&inc_page_state);
    eval 'sub dec_page_state {
        my($member) = @_;
	    eval q( &mod_page_state($member, 0 - 1));
    }' unless defined(&dec_page_state);
    eval 'sub add_page_state {
        my($member,$delta) = @_;
	    eval q( &mod_page_state($member, ($delta)));
    }' unless defined(&add_page_state);
    eval 'sub sub_page_state {
        my($member,$delta) = @_;
	    eval q( &mod_page_state($member, 0 - ($delta)));
    }' unless defined(&sub_page_state);
    eval 'sub mod_page_state_zone {
        my($zone, $member, $delta) = @_;
	    eval q( &do { \'unsigned offset\';  &if ( &is_highmem($zone))  &offset =  &offsetof(\'struct page_state\', $member &_high);  &else  &if ( &is_normal($zone))  &offset =  &offsetof(\'struct page_state\', $member &_normal);  &else  &offset =  &offsetof(\'struct page_state\', $member &_dma);  &__mod_page_state( &offset, ($delta)); }  &while (0));
    }' unless defined(&mod_page_state_zone);
    eval 'sub PageLocked {
        my($page) = @_;
	    eval q( &test_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&PageLocked);
    eval 'sub SetPageLocked {
        my($page) = @_;
	    eval q( &set_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&SetPageLocked);
    eval 'sub TestSetPageLocked {
        my($page) = @_;
	    eval q( &test_and_set_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&TestSetPageLocked);
    eval 'sub ClearPageLocked {
        my($page) = @_;
	    eval q( &clear_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&ClearPageLocked);
    eval 'sub TestClearPageLocked {
        my($page) = @_;
	    eval q( &test_and_clear_bit( &PG_locked, ($page)-> &flags));
    }' unless defined(&TestClearPageLocked);
    eval 'sub PageError {
        my($page) = @_;
	    eval q( &test_bit( &PG_error, ($page)-> &flags));
    }' unless defined(&PageError);
    eval 'sub SetPageError {
        my($page) = @_;
	    eval q( &set_bit( &PG_error, ($page)-> &flags));
    }' unless defined(&SetPageError);
    eval 'sub ClearPageError {
        my($page) = @_;
	    eval q( &clear_bit( &PG_error, ($page)-> &flags));
    }' unless defined(&ClearPageError);
    eval 'sub PageReferenced {
        my($page) = @_;
	    eval q( &test_bit( &PG_referenced, ($page)-> &flags));
    }' unless defined(&PageReferenced);
    eval 'sub SetPageReferenced {
        my($page) = @_;
	    eval q( &set_bit( &PG_referenced, ($page)-> &flags));
    }' unless defined(&SetPageReferenced);
    eval 'sub ClearPageReferenced {
        my($page) = @_;
	    eval q( &clear_bit( &PG_referenced, ($page)-> &flags));
    }' unless defined(&ClearPageReferenced);
    eval 'sub TestClearPageReferenced {
        my($page) = @_;
	    eval q( &test_and_clear_bit( &PG_referenced, ($page)-> &flags));
    }' unless defined(&TestClearPageReferenced);
    eval 'sub PageUptodate {
        my($page) = @_;
	    eval q( &test_bit( &PG_uptodate, ($page)-> &flags));
    }' unless defined(&PageUptodate);
    unless(defined(&SetPageUptodate)) {
	eval 'sub SetPageUptodate {
	    my($page) = @_;
    	    eval q( &set_bit( &PG_uptodate, ($page)-> &flags));
	}' unless defined(&SetPageUptodate);
    }
    eval 'sub ClearPageUptodate {
        my($page) = @_;
	    eval q( &clear_bit( &PG_uptodate, ($page)-> &flags));
    }' unless defined(&ClearPageUptodate);
    eval 'sub PageDirty {
        my($page) = @_;
	    eval q( &test_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&PageDirty);
    eval 'sub SetPageDirty {
        my($page) = @_;
	    eval q( &set_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&SetPageDirty);
    eval 'sub TestSetPageDirty {
        my($page) = @_;
	    eval q( &test_and_set_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&TestSetPageDirty);
    eval 'sub ClearPageDirty {
        my($page) = @_;
	    eval q( &clear_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&ClearPageDirty);
    eval 'sub TestClearPageDirty {
        my($page) = @_;
	    eval q( &test_and_clear_bit( &PG_dirty, ($page)-> &flags));
    }' unless defined(&TestClearPageDirty);
    eval 'sub SetPageLRU {
        my($page) = @_;
	    eval q( &set_bit( &PG_lru, ($page)-> &flags));
    }' unless defined(&SetPageLRU);
    eval 'sub PageLRU {
        my($page) = @_;
	    eval q( &test_bit( &PG_lru, ($page)-> &flags));
    }' unless defined(&PageLRU);
    eval 'sub TestSetPageLRU {
        my($page) = @_;
	    eval q( &test_and_set_bit( &PG_lru, ($page)-> &flags));
    }' unless defined(&TestSetPageLRU);
    eval 'sub TestClearPageLRU {
        my($page) = @_;
	    eval q( &test_and_clear_bit( &PG_lru, ($page)-> &flags));
    }' unless defined(&TestClearPageLRU);
    eval 'sub PageActive {
        my($page) = @_;
	    eval q( &test_bit( &PG_active, ($page)-> &flags));
    }' unless defined(&PageActive);
    eval 'sub SetPageActive {
        my($page) = @_;
	    eval q( &set_bit( &PG_active, ($page)-> &flags));
    }' unless defined(&SetPageActive);
    eval 'sub ClearPageActive {
        my($page) = @_;
	    eval q( &clear_bit( &PG_active, ($page)-> &flags));
    }' unless defined(&ClearPageActive);
    eval 'sub TestClearPageActive {
        my($page) = @_;
	    eval q( &test_and_clear_bit( &PG_active, ($page)-> &flags));
    }' unless defined(&TestClearPageActive);
    eval 'sub TestSetPageActive {
        my($page) = @_;
	    eval q( &test_and_set_bit( &PG_active, ($page)-> &flags));
    }' unless defined(&TestSetPageActive);
    eval 'sub PageSlab {
        my($page) = @_;
	    eval q( &test_bit( &PG_slab, ($page)-> &flags));
    }' unless defined(&PageSlab);
    eval 'sub SetPageSlab {
        my($page) = @_;
	    eval q( &set_bit( &PG_slab, ($page)-> &flags));
    }' unless defined(&SetPageSlab);
    eval 'sub ClearPageSlab {
        my($page) = @_;
	    eval q( &clear_bit( &PG_slab, ($page)-> &flags));
    }' unless defined(&ClearPageSlab);
    eval 'sub TestClearPageSlab {
        my($page) = @_;
	    eval q( &test_and_clear_bit( &PG_slab, ($page)-> &flags));
    }' unless defined(&TestClearPageSlab);
    eval 'sub TestSetPageSlab {
        my($page) = @_;
	    eval q( &test_and_set_bit( &PG_slab, ($page)-> &flags));
    }' unless defined(&TestSetPageSlab);
    if(defined(&CONFIG_HIGHMEM)) {
	eval 'sub PageHighMem {
	    my($page) = @_;
    	    eval q( &test_bit( &PG_highmem, ($page)-> &flags));
	}' unless defined(&PageHighMem);
    } else {
	eval 'sub PageHighMem {
	    my($page) = @_;
    	    eval q(0);
	}' unless defined(&PageHighMem);
    }
    eval 'sub PageChecked {
        my($page) = @_;
	    eval q( &test_bit( &PG_checked, ($page)-> &flags));
    }' unless defined(&PageChecked);
    eval 'sub SetPageChecked {
        my($page) = @_;
	    eval q( &set_bit( &PG_checked, ($page)-> &flags));
    }' unless defined(&SetPageChecked);
    eval 'sub ClearPageChecked {
        my($page) = @_;
	    eval q( &clear_bit( &PG_checked, ($page)-> &flags));
    }' unless defined(&ClearPageChecked);
    eval 'sub PageReserved {
        my($page) = @_;
	    eval q( &test_bit( &PG_reserved, ($page)-> &flags));
    }' unless defined(&PageReserved);
    eval 'sub SetPageReserved {
        my($page) = @_;
	    eval q( &set_bit( &PG_reserved, ($page)-> &flags));
    }' unless defined(&SetPageReserved);
    eval 'sub ClearPageReserved {
        my($page) = @_;
	    eval q( &clear_bit( &PG_reserved, ($page)-> &flags));
    }' unless defined(&ClearPageReserved);
    eval 'sub __ClearPageReserved {
        my($page) = @_;
	    eval q( &__clear_bit( &PG_reserved, ($page)-> &flags));
    }' unless defined(&__ClearPageReserved);
    eval 'sub SetPagePrivate {
        my($page) = @_;
	    eval q( &set_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&SetPagePrivate);
    eval 'sub ClearPagePrivate {
        my($page) = @_;
	    eval q( &clear_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&ClearPagePrivate);
    eval 'sub PagePrivate {
        my($page) = @_;
	    eval q( &test_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&PagePrivate);
    eval 'sub __SetPagePrivate {
        my($page) = @_;
	    eval q( &__set_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&__SetPagePrivate);
    eval 'sub __ClearPagePrivate {
        my($page) = @_;
	    eval q( &__clear_bit( &PG_private, ($page)-> &flags));
    }' unless defined(&__ClearPagePrivate);
    eval 'sub PageWriteback {
        my($page) = @_;
	    eval q( &test_bit( &PG_writeback, ($page)-> &flags));
    }' unless defined(&PageWriteback);
    eval 'sub SetPageWriteback {
        my($page) = @_;
	    eval q( &do {  &if (! &test_and_set_bit( &PG_writeback, ($page)-> &flags))  &inc_page_state( &nr_writeback); }  &while (0));
    }' unless defined(&SetPageWriteback);
    eval 'sub TestSetPageWriteback {
        my($page) = @_;
	    eval q(({ \'int\'  &ret;  &ret =  &test_and_set_bit( &PG_writeback, ($page)-> &flags);  &if (! &ret)  &inc_page_state( &nr_writeback);  &ret; }));
    }' unless defined(&TestSetPageWriteback);
    eval 'sub ClearPageWriteback {
        my($page) = @_;
	    eval q( &do {  &if ( &test_and_clear_bit( &PG_writeback, ($page)-> &flags))  &dec_page_state( &nr_writeback); }  &while (0));
    }' unless defined(&ClearPageWriteback);
    eval 'sub TestClearPageWriteback {
        my($page) = @_;
	    eval q(({ \'int\'  &ret;  &ret =  &test_and_clear_bit( &PG_writeback, ($page)-> &flags);  &if ( &ret)  &dec_page_state( &nr_writeback);  &ret; }));
    }' unless defined(&TestClearPageWriteback);
    eval 'sub PageNosave {
        my($page) = @_;
	    eval q( &test_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&PageNosave);
    eval 'sub SetPageNosave {
        my($page) = @_;
	    eval q( &set_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&SetPageNosave);
    eval 'sub TestSetPageNosave {
        my($page) = @_;
	    eval q( &test_and_set_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&TestSetPageNosave);
    eval 'sub ClearPageNosave {
        my($page) = @_;
	    eval q( &clear_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&ClearPageNosave);
    eval 'sub TestClearPageNosave {
        my($page) = @_;
	    eval q( &test_and_clear_bit( &PG_nosave, ($page)-> &flags));
    }' unless defined(&TestClearPageNosave);
    eval 'sub PageNosaveFree {
        my($page) = @_;
	    eval q( &test_bit( &PG_nosave_free, ($page)-> &flags));
    }' unless defined(&PageNosaveFree);
    eval 'sub SetPageNosaveFree {
        my($page) = @_;
	    eval q( &set_bit( &PG_nosave_free, ($page)-> &flags));
    }' unless defined(&SetPageNosaveFree);
    eval 'sub ClearPageNosaveFree {
        my($page) = @_;
	    eval q( &clear_bit( &PG_nosave_free, ($page)-> &flags));
    }' unless defined(&ClearPageNosaveFree);
    eval 'sub PageMappedToDisk {
        my($page) = @_;
	    eval q( &test_bit( &PG_mappedtodisk, ($page)-> &flags));
    }' unless defined(&PageMappedToDisk);
    eval 'sub SetPageMappedToDisk {
        my($page) = @_;
	    eval q( &set_bit( &PG_mappedtodisk, ($page)-> &flags));
    }' unless defined(&SetPageMappedToDisk);
    eval 'sub ClearPageMappedToDisk {
        my($page) = @_;
	    eval q( &clear_bit( &PG_mappedtodisk, ($page)-> &flags));
    }' unless defined(&ClearPageMappedToDisk);
    eval 'sub PageReclaim {
        my($page) = @_;
	    eval q( &test_bit( &PG_reclaim, ($page)-> &flags));
    }' unless defined(&PageReclaim);
    eval 'sub SetPageReclaim {
        my($page) = @_;
	    eval q( &set_bit( &PG_reclaim, ($page)-> &flags));
    }' unless defined(&SetPageReclaim);
    eval 'sub ClearPageReclaim {
        my($page) = @_;
	    eval q( &clear_bit( &PG_reclaim, ($page)-> &flags));
    }' unless defined(&ClearPageReclaim);
    eval 'sub TestClearPageReclaim {
        my($page) = @_;
	    eval q( &test_and_clear_bit( &PG_reclaim, ($page)-> &flags));
    }' unless defined(&TestClearPageReclaim);
    if(defined(&CONFIG_HUGETLB_PAGE)) {
	eval 'sub PageCompound {
	    my($page) = @_;
    	    eval q( &test_bit( &PG_compound, ($page)-> &flags));
	}' unless defined(&PageCompound);
    } else {
	eval 'sub PageCompound {
	    my($page) = @_;
    	    eval q(0);
	}' unless defined(&PageCompound);
    }
    eval 'sub SetPageCompound {
        my($page) = @_;
	    eval q( &set_bit( &PG_compound, ($page)-> &flags));
    }' unless defined(&SetPageCompound);
    eval 'sub ClearPageCompound {
        my($page) = @_;
	    eval q( &clear_bit( &PG_compound, ($page)-> &flags));
    }' unless defined(&ClearPageCompound);
    if(defined(&CONFIG_SWAP)) {
	eval 'sub PageSwapCache {
	    my($page) = @_;
    	    eval q( &test_bit( &PG_swapcache, ($page)-> &flags));
	}' unless defined(&PageSwapCache);
	eval 'sub SetPageSwapCache {
	    my($page) = @_;
    	    eval q( &set_bit( &PG_swapcache, ($page)-> &flags));
	}' unless defined(&SetPageSwapCache);
	eval 'sub ClearPageSwapCache {
	    my($page) = @_;
    	    eval q( &clear_bit( &PG_swapcache, ($page)-> &flags));
	}' unless defined(&ClearPageSwapCache);
    } else {
	eval 'sub PageSwapCache {
	    my($page) = @_;
    	    eval q(0);
	}' unless defined(&PageSwapCache);
    }
    eval 'sub clear_page_dirty {
        my($page) = @_;
	    eval q({  &test_clear_page_dirty($page); });
    }' unless defined(&clear_page_dirty);
    eval 'sub set_page_writeback {
        my($page) = @_;
	    eval q({  &test_set_page_writeback($page); });
    }' unless defined(&set_page_writeback);
}
1;
