require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_NCP_FS_H)) {
    eval 'sub _LINUX_NCP_FS_H () {1;}' unless defined(&_LINUX_NCP_FS_H);
    require 'linux/fs.ph';
    require 'linux/in.ph';
    require 'linux/types.ph';
    require 'linux/ncp_fs_i.ph';
    require 'linux/ncp_fs_sb.ph';
    require 'linux/ipx.ph';
    require 'linux/ncp_no.ph';
    eval 'sub NCP_LOCK_LOG () {0;}' unless defined(&NCP_LOCK_LOG);
    eval 'sub NCP_LOCK_SH () {1;}' unless defined(&NCP_LOCK_SH);
    eval 'sub NCP_LOCK_EX () {2;}' unless defined(&NCP_LOCK_EX);
    eval 'sub NCP_LOCK_CLEAR () {256;}' unless defined(&NCP_LOCK_CLEAR);
    eval 'sub NCP_LOCK_DEFAULT_TIMEOUT () {18;}' unless defined(&NCP_LOCK_DEFAULT_TIMEOUT);
    eval 'sub NCP_LOCK_MAX_TIMEOUT () {180;}' unless defined(&NCP_LOCK_MAX_TIMEOUT);
    eval 'sub NCP_AUTH_NONE () {0x;}' unless defined(&NCP_AUTH_NONE);
    eval 'sub NCP_AUTH_BIND () {0x31;}' unless defined(&NCP_AUTH_BIND);
    eval 'sub NCP_AUTH_NDS () {0x32;}' unless defined(&NCP_AUTH_NDS);
    eval 'sub NCP_IOCSNAME_LEN () {20;}' unless defined(&NCP_IOCSNAME_LEN);
    eval 'sub NCP_IOC_NCPREQUEST () { &_IOR(ord(\'n\'), 1, \'struct ncp_ioctl_request\');}' unless defined(&NCP_IOC_NCPREQUEST);
    eval 'sub NCP_IOC_GETMOUNTUID () { &_IOW(ord(\'n\'), 2,  &__kernel_old_uid_t);}' unless defined(&NCP_IOC_GETMOUNTUID);
    eval 'sub NCP_IOC_GETMOUNTUID2 () { &_IOW(ord(\'n\'), 2, \'unsigned long\');}' unless defined(&NCP_IOC_GETMOUNTUID2);
    eval 'sub NCP_IOC_CONN_LOGGED_IN () { &_IO(ord(\'n\'), 3);}' unless defined(&NCP_IOC_CONN_LOGGED_IN);
    eval 'sub NCP_GET_FS_INFO_VERSION () {(1);}' unless defined(&NCP_GET_FS_INFO_VERSION);
    eval 'sub NCP_IOC_GET_FS_INFO () { &_IOWR(ord(\'n\'), 4, \'struct ncp_fs_info\');}' unless defined(&NCP_IOC_GET_FS_INFO);
    eval 'sub NCP_GET_FS_INFO_VERSION_V2 () {(2);}' unless defined(&NCP_GET_FS_INFO_VERSION_V2);
    eval 'sub NCP_IOC_GET_FS_INFO_V2 () { &_IOWR(ord(\'n\'), 4, \'struct ncp_fs_info_v2\');}' unless defined(&NCP_IOC_GET_FS_INFO_V2);
    eval 'sub NCP_IOC_SIGN_INIT () { &_IOR(ord(\'n\'), 5, \'struct ncp_sign_init\');}' unless defined(&NCP_IOC_SIGN_INIT);
    eval 'sub NCP_IOC_SIGN_WANTED () { &_IOR(ord(\'n\'), 6, \'int\');}' unless defined(&NCP_IOC_SIGN_WANTED);
    eval 'sub NCP_IOC_SET_SIGN_WANTED () { &_IOW(ord(\'n\'), 6, \'int\');}' unless defined(&NCP_IOC_SET_SIGN_WANTED);
    eval 'sub NCP_IOC_LOCKUNLOCK () { &_IOR(ord(\'n\'), 7, \'struct ncp_lock_ioctl\');}' unless defined(&NCP_IOC_LOCKUNLOCK);
    eval 'sub NCP_IOC_GETROOT () { &_IOW(ord(\'n\'), 8, \'struct ncp_setroot_ioctl\');}' unless defined(&NCP_IOC_GETROOT);
    eval 'sub NCP_IOC_SETROOT () { &_IOR(ord(\'n\'), 8, \'struct ncp_setroot_ioctl\');}' unless defined(&NCP_IOC_SETROOT);
    eval 'sub NCP_IOC_GETOBJECTNAME () { &_IOWR(ord(\'n\'), 9, \'struct ncp_objectname_ioctl\');}' unless defined(&NCP_IOC_GETOBJECTNAME);
    eval 'sub NCP_IOC_SETOBJECTNAME () { &_IOR(ord(\'n\'), 9, \'struct ncp_objectname_ioctl\');}' unless defined(&NCP_IOC_SETOBJECTNAME);
    eval 'sub NCP_IOC_GETPRIVATEDATA () { &_IOWR(ord(\'n\'), 10, \'struct ncp_privatedata_ioctl\');}' unless defined(&NCP_IOC_GETPRIVATEDATA);
    eval 'sub NCP_IOC_SETPRIVATEDATA () { &_IOR(ord(\'n\'), 10, \'struct ncp_privatedata_ioctl\');}' unless defined(&NCP_IOC_SETPRIVATEDATA);
    eval 'sub NCP_IOC_GETCHARSETS () { &_IOWR(ord(\'n\'), 11, \'struct ncp_nls_ioctl\');}' unless defined(&NCP_IOC_GETCHARSETS);
    eval 'sub NCP_IOC_SETCHARSETS () { &_IOR(ord(\'n\'), 11, \'struct ncp_nls_ioctl\');}' unless defined(&NCP_IOC_SETCHARSETS);
    eval 'sub NCP_IOC_GETDENTRYTTL () { &_IOW(ord(\'n\'), 12,  &__u32);}' unless defined(&NCP_IOC_GETDENTRYTTL);
    eval 'sub NCP_IOC_SETDENTRYTTL () { &_IOR(ord(\'n\'), 12,  &__u32);}' unless defined(&NCP_IOC_SETDENTRYTTL);
    eval 'sub NCP_PACKET_SIZE () {4070;}' unless defined(&NCP_PACKET_SIZE);
    eval 'sub NCP_MAXPATHLEN () {255;}' unless defined(&NCP_MAXPATHLEN);
    eval 'sub NCP_MAXNAMELEN () {14;}' unless defined(&NCP_MAXNAMELEN);
    if(defined(&__KERNEL__)) {
	require 'linux/config.ph';
	undef(&PRINTK) if defined(&PRINTK);
	eval 'sub PRINTK () {( &format,  &args...)  &printk( &KERN_DEBUG  &format ,   &args);}' unless defined(&PRINTK);
	undef(&NCPFS_PARANOIA) if defined(&NCPFS_PARANOIA);
	if(defined(&NCPFS_PARANOIA)) {
	    eval 'sub PPRINTK () {( &format,  &args...)  &PRINTK( &format ,   &args);}' unless defined(&PPRINTK);
	} else {
	    eval 'sub PPRINTK () {( &format,  &args...);}' unless defined(&PPRINTK);
	}
	unless(defined(&DEBUG_NCP)) {
	    eval 'sub DEBUG_NCP () {0;}' unless defined(&DEBUG_NCP);
	}
	if((defined(&DEBUG_NCP) ? &DEBUG_NCP : 0) > 0) {
	    eval 'sub DPRINTK () {( &format,  &args...)  &PRINTK( &format ,   &args);}' unless defined(&DPRINTK);
	} else {
	    eval 'sub DPRINTK () {( &format,  &args...);}' unless defined(&DPRINTK);
	}
	if((defined(&DEBUG_NCP) ? &DEBUG_NCP : 0) > 1) {
	    eval 'sub DDPRINTK () {( &format,  &args...)  &PRINTK( &format ,   &args);}' unless defined(&DDPRINTK);
	} else {
	    eval 'sub DDPRINTK () {( &format,  &args...);}' unless defined(&DDPRINTK);
	}
	eval 'sub NCP_MAX_RPC_TIMEOUT () {(6* &HZ);}' unless defined(&NCP_MAX_RPC_TIMEOUT);
	eval 'sub NCP_SUPER_MAGIC () {0x564c;}' unless defined(&NCP_SUPER_MAGIC);
	eval 'sub ncp_server {
	    eval q(* &NCP_SBP(\'struct super_block\' * &sb) {  ($sb->{s_fs_info}); });
	}' unless defined(&ncp_server);
	eval 'sub NCP_SERVER {
	    my($inode) = @_;
    	    eval q( &NCP_SBP(($inode)-> &i_sb));
	}' unless defined(&NCP_SERVER);
	eval 'sub ncp_inode_info {
	    eval q(* &NCP_FINFO(\'struct inode\' * &inode) {  &container_of( &inode, \'struct ncp_inode_info\',  &vfs_inode); });
	}' unless defined(&ncp_inode_info);
	if(defined(&DEBUG_NCP_MALLOC)) {
	    require 'linux/slab.ph';
	    eval 'sub ncp_kmalloc {
	        my($size,$priority) = @_;
    		eval q({  &ncp_malloced += 1;  &ncp_current_malloced += 1;  &kmalloc($size, $priority); });
	    }' unless defined(&ncp_kmalloc);
	    eval 'sub ncp_kfree_s {
	        my($obj,$size) = @_;
    		eval q({  &ncp_current_malloced -= 1;  &kfree($obj); });
	    }' unless defined(&ncp_kfree_s);
	} else {
	    eval 'sub ncp_kmalloc {
	        my($s,$p) = @_;
    		eval q( &kmalloc($s,$p));
	    }' unless defined(&ncp_kmalloc);
	    eval 'sub ncp_kfree_s {
	        my($o,$s) = @_;
    		eval q( &kfree($o));
	    }' unless defined(&ncp_kfree_s);
	}
	eval 'sub ncp_request {
	    my($server,$function) = @_;
    	    eval q({  &ncp_request2($server, $function,  ($server->{packet}),  ($server->{packet_size})); });
	}' unless defined(&ncp_request);
	eval 'sub ncp_namespace {
	    my($i) = @_;
    	    eval q(( &NCP_SERVER($i)-> $name_space[ &NCP_FINFO($i)-> &volNumber]));
	}' unless defined(&ncp_namespace);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub ncp_preserve_entry_case {
	    my($i,$nscreator) = @_;
    	    eval q({ ) 0;  &endif 1; });
	}' unless defined(&ncp_preserve_entry_case);
	eval 'sub ncp_preserve_case {
	    my($i) = @_;
    	    eval q(( &ncp_namespace($i) !=  &NW_NS_DOS));
	}' unless defined(&ncp_preserve_case);
# some #ifdef were dropped here -- fill in the blanks
	eval 'sub ncp_case_sensitive {
	    my($i) = @_;
    	    eval q({ } );
	}' unless defined(&ncp_case_sensitive);
    }
}
1;
