require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_KEY_H)) {
    eval 'sub _LINUX_KEY_H () {1;}' unless defined(&_LINUX_KEY_H);
    require 'linux/types.ph';
    require 'linux/list.ph';
    require 'linux/rbtree.ph';
    require 'linux/spinlock.ph';
    require 'asm/atomic.ph';
    if(defined(&__KERNEL__)) {
	if(defined(&CONFIG_KEYS)) {
	    undef(&KEY_DEBUGGING) if defined(&KEY_DEBUGGING);
	    eval 'sub KEY_USR_VIEW () {0x10000;}' unless defined(&KEY_USR_VIEW);
	    eval 'sub KEY_USR_READ () {0x20000;}' unless defined(&KEY_USR_READ);
	    eval 'sub KEY_USR_WRITE () {0x40000;}' unless defined(&KEY_USR_WRITE);
	    eval 'sub KEY_USR_SEARCH () {0x80000;}' unless defined(&KEY_USR_SEARCH);
	    eval 'sub KEY_USR_LINK () {0x100000;}' unless defined(&KEY_USR_LINK);
	    eval 'sub KEY_USR_ALL () {0x1f0000;}' unless defined(&KEY_USR_ALL);
	    eval 'sub KEY_GRP_VIEW () {0x100;}' unless defined(&KEY_GRP_VIEW);
	    eval 'sub KEY_GRP_READ () {0x200;}' unless defined(&KEY_GRP_READ);
	    eval 'sub KEY_GRP_WRITE () {0x400;}' unless defined(&KEY_GRP_WRITE);
	    eval 'sub KEY_GRP_SEARCH () {0x800;}' unless defined(&KEY_GRP_SEARCH);
	    eval 'sub KEY_GRP_LINK () {0x1000;}' unless defined(&KEY_GRP_LINK);
	    eval 'sub KEY_GRP_ALL () {0x1f00;}' unless defined(&KEY_GRP_ALL);
	    eval 'sub KEY_OTH_VIEW () {0x1;}' unless defined(&KEY_OTH_VIEW);
	    eval 'sub KEY_OTH_READ () {0x2;}' unless defined(&KEY_OTH_READ);
	    eval 'sub KEY_OTH_WRITE () {0x4;}' unless defined(&KEY_OTH_WRITE);
	    eval 'sub KEY_OTH_SEARCH () {0x8;}' unless defined(&KEY_OTH_SEARCH);
	    eval 'sub KEY_OTH_LINK () {0x10;}' unless defined(&KEY_OTH_LINK);
	    eval 'sub KEY_OTH_ALL () {0x1f;}' unless defined(&KEY_OTH_ALL);
	    eval 'sub KEY_FLAG_INSTANTIATED () {0x1;}' unless defined(&KEY_FLAG_INSTANTIATED);
	    eval 'sub KEY_FLAG_DEAD () {0x2;}' unless defined(&KEY_FLAG_DEAD);
	    eval 'sub KEY_FLAG_REVOKED () {0x4;}' unless defined(&KEY_FLAG_REVOKED);
	    eval 'sub KEY_FLAG_IN_QUOTA () {0x8;}' unless defined(&KEY_FLAG_IN_QUOTA);
	    eval 'sub KEY_FLAG_USER_CONSTRUCT () {0x10;}' unless defined(&KEY_FLAG_USER_CONSTRUCT);
	    eval 'sub KEY_FLAG_NEGATIVE () {0x20;}' unless defined(&KEY_FLAG_NEGATIVE);
	    if(defined(&KEY_DEBUGGING)) {
		eval 'sub KEY_DEBUG_MAGIC () {0x18273645;}' unless defined(&KEY_DEBUG_MAGIC);
		eval 'sub KEY_DEBUG_MAGIC_X () {0xf8e9dacb;}' unless defined(&KEY_DEBUG_MAGIC_X);
	    }
	    eval 'sub key {
	        eval q(* &key_get(\'struct key\' * &key) {  &if ( &key)  &atomic_inc( ($key->{usage}));  &key; });
	    }' unless defined(&key);
	    eval 'sub key_serial {
	        my($key) = @_;
    		eval q((($key) ? ($key)-> &serial : 0));
	    }' unless defined(&key_serial);
	} else {
	    eval 'sub key_validate {
	        my($k) = @_;
    		eval q(0);
	    }' unless defined(&key_validate);
	    eval 'sub key_serial {
	        my($k) = @_;
    		eval q(0);
	    }' unless defined(&key_serial);
	    eval 'sub key_get {
	        my($k) = @_;
    		eval q( &NULL);
	    }' unless defined(&key_get);
	    eval 'sub key_put {
	        my($k) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&key_put);
	    eval 'sub alloc_uid_keyring {
	        my($u) = @_;
    		eval q(0);
	    }' unless defined(&alloc_uid_keyring);
	    eval 'sub switch_uid_keyring {
	        my($u) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&switch_uid_keyring);
	    eval 'sub copy_keys {
	        my($f,$t) = @_;
    		eval q(0);
	    }' unless defined(&copy_keys);
	    eval 'sub exit_keys {
	        my($t) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&exit_keys);
	    eval 'sub suid_keys {
	        my($t) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&suid_keys);
	    eval 'sub exec_keys {
	        my($t) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&exec_keys);
	    eval 'sub key_fsuid_changed {
	        my($t) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&key_fsuid_changed);
	    eval 'sub key_fsgid_changed {
	        my($t) = @_;
    		eval q( &do { }  &while(0));
	    }' unless defined(&key_fsgid_changed);
	    eval 'sub key_init () {
	        eval q( &do { }  &while(0));
	    }' unless defined(&key_init);
	}
    }
}
1;
