require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_INTERRUPT_H)) {
    eval 'sub _LINUX_INTERRUPT_H () {1;}' unless defined(&_LINUX_INTERRUPT_H);
    require 'linux/config.ph';
    require 'linux/kernel.ph';
    require 'linux/linkage.ph';
    require 'linux/bitops.ph';
    require 'linux/preempt.ph';
    require 'linux/cpumask.ph';
    require 'linux/hardirq.ph';
    require 'asm/atomic.ph';
    require 'asm/ptrace.ph';
    require 'asm/system.ph';
    eval 'sub IRQ_NONE () {(0);}' unless defined(&IRQ_NONE);
    eval 'sub IRQ_HANDLED () {(1);}' unless defined(&IRQ_HANDLED);
    eval 'sub IRQ_RETVAL {
        my($x) = @_;
	    eval q((($x) != 0));
    }' unless defined(&IRQ_RETVAL);
    if(defined(&CONFIG_GENERIC_HARDIRQS)) {
    }
    unless(defined(&CONFIG_SMP)) {
	eval 'sub cli {
	    my($void) = @_;
    	    eval q({  &local_irq_disable(); });
	}' unless defined(&cli);
	eval 'sub sti {
	    my($void) = @_;
    	    eval q({  &local_irq_enable(); });
	}' unless defined(&sti);
	eval 'sub save_flags {
	    my($x) = @_;
    	    eval q({  &local_save_flags(*$x); });
	}' unless defined(&save_flags);
	eval 'sub save_flags {
	    my($x) = @_;
    	    eval q( &save_flags($x););
	}' unless defined(&save_flags);
	eval 'sub restore_flags {
	    my($x) = @_;
    	    eval q({  &local_irq_restore($x); });
	}' unless defined(&restore_flags);
	eval 'sub save_and_cli {
	    my($x) = @_;
    	    eval q({  &local_irq_save(*$x); });
	}' unless defined(&save_and_cli);
	eval 'sub save_and_cli {
	    my($x) = @_;
    	    eval q( &save_and_cli($x));
	}' unless defined(&save_and_cli);
    }
    eval 'sub local_bh_disable () {
        eval q( &do {  &add_preempt_count( &SOFTIRQ_OFFSET);  &barrier(); }  &while (0));
    }' unless defined(&local_bh_disable);
    eval 'sub __local_bh_enable () {
        eval q( &do {  &barrier();  &sub_preempt_count( &SOFTIRQ_OFFSET); }  &while (0));
    }' unless defined(&__local_bh_enable);
    eval("sub HI_SOFTIRQ () { 0; }") unless defined(&HI_SOFTIRQ);
    eval("sub TIMER_SOFTIRQ () { 1; }") unless defined(&TIMER_SOFTIRQ);
    eval("sub NET_TX_SOFTIRQ () { 2; }") unless defined(&NET_TX_SOFTIRQ);
    eval("sub NET_RX_SOFTIRQ () { 3; }") unless defined(&NET_RX_SOFTIRQ);
    eval("sub SCSI_SOFTIRQ () { 4; }") unless defined(&SCSI_SOFTIRQ);
    eval("sub TASKLET_SOFTIRQ () { 5; }") unless defined(&TASKLET_SOFTIRQ);
    eval 'sub __raise_softirq_irqoff {
        my($nr) = @_;
	    eval q( &do {  &local_softirq_pending() |= 1 << ($nr); }  &while (0));
    }' unless defined(&__raise_softirq_irqoff);
    eval 'sub DECLARE_TASKLET {
        my($name, $func, $data) = @_;
	    eval q(\'struct tasklet_struct\' $name = {  &NULL, 0,  &ATOMIC_INIT(0), $func, $data });
    }' unless defined(&DECLARE_TASKLET);
    eval 'sub DECLARE_TASKLET_DISABLED {
        my($name, $func, $data) = @_;
	    eval q(\'struct tasklet_struct\' $name = {  &NULL, 0,  &ATOMIC_INIT(1), $func, $data });
    }' unless defined(&DECLARE_TASKLET_DISABLED);
    eval("sub TASKLET_STATE_SCHED () { 0; }") unless defined(&TASKLET_STATE_SCHED);
    eval("sub TASKLET_STATE_RUN () { 1; }") unless defined(&TASKLET_STATE_RUN);
    if(defined(&CONFIG_SMP)) {
	eval 'sub tasklet_trylock {
	    my($t) = @_;
    	    eval q({ ! &test_and_set_bit( &TASKLET_STATE_RUN, ($t)-> &state); });
	}' unless defined(&tasklet_trylock);
	eval 'sub tasklet_unlock {
	    my($t) = @_;
    	    eval q({  &smp_mb__before_clear_bit();  &clear_bit( &TASKLET_STATE_RUN, ($t)-> &state); });
	}' unless defined(&tasklet_unlock);
	eval 'sub tasklet_unlock_wait {
	    my($t) = @_;
    	    eval q({  &while ( &test_bit( &TASKLET_STATE_RUN, ($t)-> &state)) {  &barrier(); } });
	}' unless defined(&tasklet_unlock_wait);
    } else {
	eval 'sub tasklet_trylock {
	    my($t) = @_;
    	    eval q(1);
	}' unless defined(&tasklet_trylock);
	eval 'sub tasklet_unlock_wait {
	    my($t) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&tasklet_unlock_wait);
	eval 'sub tasklet_unlock {
	    my($t) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&tasklet_unlock);
    }
    eval 'sub tasklet_schedule {
        my($t) = @_;
	    eval q({  &if (! &test_and_set_bit( &TASKLET_STATE_SCHED,  ($t->{s$tate})))  &__tasklet_schedule($t); });
    }' unless defined(&tasklet_schedule);
    eval 'sub tasklet_hi_schedule {
        my($t) = @_;
	    eval q({  &if (! &test_and_set_bit( &TASKLET_STATE_SCHED,  ($t->{s$tate})))  &__tasklet_hi_schedule($t); });
    }' unless defined(&tasklet_hi_schedule);
    eval 'sub tasklet_disable_nosync {
        my($t) = @_;
	    eval q({  &atomic_inc( ($t->{count}));  &smp_mb__after_atomic_inc(); });
    }' unless defined(&tasklet_disable_nosync);
    eval 'sub tasklet_disable {
        my($t) = @_;
	    eval q({  &tasklet_disable_nosync($t);  &tasklet_unlock_wait($t);  &smp_mb(); });
    }' unless defined(&tasklet_disable);
    eval 'sub tasklet_enable {
        my($t) = @_;
	    eval q({  &smp_mb__before_atomic_dec();  &atomic_dec( ($t->{count})); });
    }' unless defined(&tasklet_enable);
    eval 'sub tasklet_hi_enable {
        my($t) = @_;
	    eval q({  &smp_mb__before_atomic_dec();  &atomic_dec( ($t->{count})); });
    }' unless defined(&tasklet_hi_enable);
    if(defined( &CONFIG_GENERIC_HARDIRQS)  && !defined( &CONFIG_GENERIC_IRQ_PROBE) ) {
	eval 'sub probe_irq_on {
	    my($void) = @_;
    	    eval q({ 0; });
	}' unless defined(&probe_irq_on);
	eval 'sub probe_irq_off {
	    my($val) = @_;
    	    eval q({ 0; });
	}' unless defined(&probe_irq_off);
	eval 'sub probe_irq_mask {
	    my($val) = @_;
    	    eval q({ 0; });
	}' unless defined(&probe_irq_mask);
    } else {
    }
}
1;
