require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_I2O_H)) {
    eval 'sub _I2O_H () {1;}' unless defined(&_I2O_H);
    if(defined(&__KERNEL__)) {
	require 'linux/i2o-dev.ph';
	eval 'sub I2O_MAX_DRIVERS () {8;}' unless defined(&I2O_MAX_DRIVERS);
	require 'asm/io.ph';
	require 'asm/semaphore.ph';
	require 'linux/pci.ph';
	require 'linux/dma-mapping.ph';
	eval 'sub I2O_QUEUE_EMPTY () {0xffffffff;}' unless defined(&I2O_QUEUE_EMPTY);
	if(defined(&CONFIG_MTRR)) {
	}
	if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) == 64) {
	}
	if((defined(&BITS_PER_LONG) ? &BITS_PER_LONG : 0) == 64) {
	    eval 'sub i2o_ptr_low {
	        my($ptr) = @_;
    		eval q({ ( &u32) ( &u64) $ptr; };);
	    }' unless defined(&i2o_ptr_low);
	    eval 'sub i2o_ptr_high {
	        my($ptr) = @_;
    		eval q({ ( &u32) (( &u64) $ptr >> 32); };);
	    }' unless defined(&i2o_ptr_high);
	} else {
	    eval 'sub i2o_cntxt_list_add {
	        my($c,$ptr) = @_;
    		eval q({ ( &u32) $ptr; };);
	    }' unless defined(&i2o_cntxt_list_add);
	    eval 'sub void {
	        eval q(* &i2o_cntxt_list_get(\'struct i2o_controller\' * &c,  &u32  &context) { ( &void *) &context; };);
	    }' unless defined(&void);
	    eval 'sub i2o_cntxt_list_remove {
	        my($c,$ptr) = @_;
    		eval q({ ( &u32) $ptr; };);
	    }' unless defined(&i2o_cntxt_list_remove);
	    eval 'sub i2o_cntxt_list_get_ptr {
	        my($c,$ptr) = @_;
    		eval q({ ( &u32) $ptr; };);
	    }' unless defined(&i2o_cntxt_list_get_ptr);
	    eval 'sub i2o_ptr_low {
	        my($ptr) = @_;
    		eval q({ ( &u32) $ptr; };);
	    }' unless defined(&i2o_ptr_low);
	    eval 'sub i2o_ptr_high {
	        my($ptr) = @_;
    		eval q({ 0; };);
	    }' unless defined(&i2o_ptr_high);
	}
	eval 'sub to_i2o_driver {
	    my($drv) = @_;
    	    eval q( &container_of($drv,\'struct i2o_driver\',  &driver));
	}' unless defined(&to_i2o_driver);
	eval 'sub to_i2o_device {
	    my($dev) = @_;
    	    eval q( &container_of($dev, \'struct i2o_device\',  &device));
	}' unless defined(&to_i2o_device);
	eval 'sub I2O_POST_WRITE32 {
	    my($c,$val) = @_;
    	    eval q({  &wmb();  &writel($val,  ($c->{post_port})); };);
	}' unless defined(&I2O_POST_WRITE32);
	eval 'sub I2O_REPLY_READ32 {
	    my($c) = @_;
    	    eval q({  &rmb();  &readl( ($c->{reply_port})); };);
	}' unless defined(&I2O_REPLY_READ32);
	eval 'sub I2O_REPLY_WRITE32 {
	    my($c,$val) = @_;
    	    eval q({  &wmb();  &writel($val,  ($c->{reply_port})); };);
	}' unless defined(&I2O_REPLY_WRITE32);
	eval 'sub I2O_IRQ_READ32 {
	    my($c) = @_;
    	    eval q({  &rmb();  &readl( ($c->{irq_mask})); };);
	}' unless defined(&I2O_IRQ_READ32);
	eval 'sub I2O_IRQ_WRITE32 {
	    my($c,$val) = @_;
    	    eval q({  &wmb();  &writel($val,  ($c->{irq_mask}));  &wmb(); };);
	}' unless defined(&I2O_IRQ_WRITE32);
	eval 'sub i2o_raw_writel {
	    my($val, $mem) = @_;
    	    eval q( &__raw_writel( &cpu_to_le32($val), $mem));
	}' unless defined(&i2o_raw_writel);
	eval 'sub osm_printk () {( &level,  &format,  &arg...)  &printk( &level "%s: "  &format,  &OSM_NAME ,   &arg);}' unless defined(&osm_printk);
	if(defined(&DEBUG)) {
	    eval 'sub osm_debug () {( &format,  &arg...)  &osm_printk( &KERN_DEBUG,  &format ,   &arg);}' unless defined(&osm_debug);
	} else {
	    eval 'sub osm_debug () {( &format,  &arg...)  &do { }  &while (0);}' unless defined(&osm_debug);
	}
	eval 'sub osm_err () {( &format,  &arg...)  &osm_printk( &KERN_ERR,  &format ,   &arg);}' unless defined(&osm_err);
	eval 'sub osm_info () {( &format,  &arg...)  &osm_printk( &KERN_INFO,  &format ,   &arg);}' unless defined(&osm_info);
	eval 'sub osm_warn () {( &format,  &arg...)  &osm_printk( &KERN_WARNING,  &format ,   &arg);}' unless defined(&osm_warn);
	eval 'sub CACHE_NULL () {0;}' unless defined(&CACHE_NULL);
	eval 'sub CACHE_PREFETCH () {1;}' unless defined(&CACHE_PREFETCH);
	eval 'sub CACHE_SMARTFETCH () {2;}' unless defined(&CACHE_SMARTFETCH);
	eval 'sub CACHE_WRITETHROUGH () {17;}' unless defined(&CACHE_WRITETHROUGH);
	eval 'sub CACHE_WRITEBACK () {18;}' unless defined(&CACHE_WRITEBACK);
	eval 'sub CACHE_SMARTBACK () {19;}' unless defined(&CACHE_SMARTBACK);
	eval 'sub CACHE_SMARTTHROUGH () {20;}' unless defined(&CACHE_SMARTTHROUGH);
	eval 'sub BLKI2OGRSTRAT () { &_IOR(ord(\'2\'), 1, \'int\');}' unless defined(&BLKI2OGRSTRAT);
	eval 'sub BLKI2OGWSTRAT () { &_IOR(ord(\'2\'), 2, \'int\');}' unless defined(&BLKI2OGWSTRAT);
	eval 'sub BLKI2OSRSTRAT () { &_IOW(ord(\'2\'), 3, \'int\');}' unless defined(&BLKI2OSRSTRAT);
	eval 'sub BLKI2OSWSTRAT () { &_IOW(ord(\'2\'), 4, \'int\');}' unless defined(&BLKI2OSWSTRAT);
	eval 'sub I2O_CMD_ADAPTER_ASSIGN () {0xb3;}' unless defined(&I2O_CMD_ADAPTER_ASSIGN);
	eval 'sub I2O_CMD_ADAPTER_READ () {0xb2;}' unless defined(&I2O_CMD_ADAPTER_READ);
	eval 'sub I2O_CMD_ADAPTER_RELEASE () {0xb5;}' unless defined(&I2O_CMD_ADAPTER_RELEASE);
	eval 'sub I2O_CMD_BIOS_INFO_SET () {0xa5;}' unless defined(&I2O_CMD_BIOS_INFO_SET);
	eval 'sub I2O_CMD_BOOT_DEVICE_SET () {0xa7;}' unless defined(&I2O_CMD_BOOT_DEVICE_SET);
	eval 'sub I2O_CMD_CONFIG_VALIDATE () {0xbb;}' unless defined(&I2O_CMD_CONFIG_VALIDATE);
	eval 'sub I2O_CMD_CONN_SETUP () {0xca;}' unless defined(&I2O_CMD_CONN_SETUP);
	eval 'sub I2O_CMD_DDM_DESTROY () {0xb1;}' unless defined(&I2O_CMD_DDM_DESTROY);
	eval 'sub I2O_CMD_DDM_ENABLE () {0xd5;}' unless defined(&I2O_CMD_DDM_ENABLE);
	eval 'sub I2O_CMD_DDM_QUIESCE () {0xc7;}' unless defined(&I2O_CMD_DDM_QUIESCE);
	eval 'sub I2O_CMD_DDM_RESET () {0xd9;}' unless defined(&I2O_CMD_DDM_RESET);
	eval 'sub I2O_CMD_DDM_SUSPEND () {0xaf;}' unless defined(&I2O_CMD_DDM_SUSPEND);
	eval 'sub I2O_CMD_DEVICE_ASSIGN () {0xb7;}' unless defined(&I2O_CMD_DEVICE_ASSIGN);
	eval 'sub I2O_CMD_DEVICE_RELEASE () {0xb9;}' unless defined(&I2O_CMD_DEVICE_RELEASE);
	eval 'sub I2O_CMD_HRT_GET () {0xa8;}' unless defined(&I2O_CMD_HRT_GET);
	eval 'sub I2O_CMD_ADAPTER_CLEAR () {0xbe;}' unless defined(&I2O_CMD_ADAPTER_CLEAR);
	eval 'sub I2O_CMD_ADAPTER_CONNECT () {0xc9;}' unless defined(&I2O_CMD_ADAPTER_CONNECT);
	eval 'sub I2O_CMD_ADAPTER_RESET () {0xbd;}' unless defined(&I2O_CMD_ADAPTER_RESET);
	eval 'sub I2O_CMD_LCT_NOTIFY () {0xa2;}' unless defined(&I2O_CMD_LCT_NOTIFY);
	eval 'sub I2O_CMD_OUTBOUND_INIT () {0xa1;}' unless defined(&I2O_CMD_OUTBOUND_INIT);
	eval 'sub I2O_CMD_PATH_ENABLE () {0xd3;}' unless defined(&I2O_CMD_PATH_ENABLE);
	eval 'sub I2O_CMD_PATH_QUIESCE () {0xc5;}' unless defined(&I2O_CMD_PATH_QUIESCE);
	eval 'sub I2O_CMD_PATH_RESET () {0xd7;}' unless defined(&I2O_CMD_PATH_RESET);
	eval 'sub I2O_CMD_STATIC_MF_CREATE () {0xdd;}' unless defined(&I2O_CMD_STATIC_MF_CREATE);
	eval 'sub I2O_CMD_STATIC_MF_RELEASE () {0xdf;}' unless defined(&I2O_CMD_STATIC_MF_RELEASE);
	eval 'sub I2O_CMD_STATUS_GET () {0xa0;}' unless defined(&I2O_CMD_STATUS_GET);
	eval 'sub I2O_CMD_SW_DOWNLOAD () {0xa9;}' unless defined(&I2O_CMD_SW_DOWNLOAD);
	eval 'sub I2O_CMD_SW_UPLOAD () {0xab;}' unless defined(&I2O_CMD_SW_UPLOAD);
	eval 'sub I2O_CMD_SW_REMOVE () {0xad;}' unless defined(&I2O_CMD_SW_REMOVE);
	eval 'sub I2O_CMD_SYS_ENABLE () {0xd1;}' unless defined(&I2O_CMD_SYS_ENABLE);
	eval 'sub I2O_CMD_SYS_MODIFY () {0xc1;}' unless defined(&I2O_CMD_SYS_MODIFY);
	eval 'sub I2O_CMD_SYS_QUIESCE () {0xc3;}' unless defined(&I2O_CMD_SYS_QUIESCE);
	eval 'sub I2O_CMD_SYS_TAB_SET () {0xa3;}' unless defined(&I2O_CMD_SYS_TAB_SET);
	eval 'sub I2O_CMD_UTIL_NOP () {0x;}' unless defined(&I2O_CMD_UTIL_NOP);
	eval 'sub I2O_CMD_UTIL_ABORT () {0x1;}' unless defined(&I2O_CMD_UTIL_ABORT);
	eval 'sub I2O_CMD_UTIL_CLAIM () {0x9;}' unless defined(&I2O_CMD_UTIL_CLAIM);
	eval 'sub I2O_CMD_UTIL_RELEASE () {0xb;}' unless defined(&I2O_CMD_UTIL_RELEASE);
	eval 'sub I2O_CMD_UTIL_PARAMS_GET () {0x6;}' unless defined(&I2O_CMD_UTIL_PARAMS_GET);
	eval 'sub I2O_CMD_UTIL_PARAMS_SET () {0x5;}' unless defined(&I2O_CMD_UTIL_PARAMS_SET);
	eval 'sub I2O_CMD_UTIL_EVT_REGISTER () {0x13;}' unless defined(&I2O_CMD_UTIL_EVT_REGISTER);
	eval 'sub I2O_CMD_UTIL_EVT_ACK () {0x14;}' unless defined(&I2O_CMD_UTIL_EVT_ACK);
	eval 'sub I2O_CMD_UTIL_CONFIG_DIALOG () {0x10;}' unless defined(&I2O_CMD_UTIL_CONFIG_DIALOG);
	eval 'sub I2O_CMD_UTIL_DEVICE_RESERVE () {0xd;}' unless defined(&I2O_CMD_UTIL_DEVICE_RESERVE);
	eval 'sub I2O_CMD_UTIL_DEVICE_RELEASE () {0xf;}' unless defined(&I2O_CMD_UTIL_DEVICE_RELEASE);
	eval 'sub I2O_CMD_UTIL_LOCK () {0x17;}' unless defined(&I2O_CMD_UTIL_LOCK);
	eval 'sub I2O_CMD_UTIL_LOCK_RELEASE () {0x19;}' unless defined(&I2O_CMD_UTIL_LOCK_RELEASE);
	eval 'sub I2O_CMD_UTIL_REPLY_FAULT_NOTIFY () {0x15;}' unless defined(&I2O_CMD_UTIL_REPLY_FAULT_NOTIFY);
	eval 'sub I2O_CMD_SCSI_EXEC () {0x81;}' unless defined(&I2O_CMD_SCSI_EXEC);
	eval 'sub I2O_CMD_SCSI_ABORT () {0x83;}' unless defined(&I2O_CMD_SCSI_ABORT);
	eval 'sub I2O_CMD_SCSI_BUSRESET () {0x27;}' unless defined(&I2O_CMD_SCSI_BUSRESET);
	eval 'sub I2O_CMD_BLOCK_READ () {0x30;}' unless defined(&I2O_CMD_BLOCK_READ);
	eval 'sub I2O_CMD_BLOCK_WRITE () {0x31;}' unless defined(&I2O_CMD_BLOCK_WRITE);
	eval 'sub I2O_CMD_BLOCK_CFLUSH () {0x37;}' unless defined(&I2O_CMD_BLOCK_CFLUSH);
	eval 'sub I2O_CMD_BLOCK_MLOCK () {0x49;}' unless defined(&I2O_CMD_BLOCK_MLOCK);
	eval 'sub I2O_CMD_BLOCK_MUNLOCK () {0x4b;}' unless defined(&I2O_CMD_BLOCK_MUNLOCK);
	eval 'sub I2O_CMD_BLOCK_MMOUNT () {0x41;}' unless defined(&I2O_CMD_BLOCK_MMOUNT);
	eval 'sub I2O_CMD_BLOCK_MEJECT () {0x43;}' unless defined(&I2O_CMD_BLOCK_MEJECT);
	eval 'sub I2O_CMD_BLOCK_POWER () {0x70;}' unless defined(&I2O_CMD_BLOCK_POWER);
	eval 'sub I2O_PRIVATE_MSG () {0xff;}' unless defined(&I2O_PRIVATE_MSG);
	eval 'sub I2O_CMD_IN_PROGRESS () {0x1;}' unless defined(&I2O_CMD_IN_PROGRESS);
	eval 'sub I2O_CMD_REJECTED () {0x2;}' unless defined(&I2O_CMD_REJECTED);
	eval 'sub I2O_CMD_FAILED () {0x3;}' unless defined(&I2O_CMD_FAILED);
	eval 'sub I2O_CMD_COMPLETED () {0x4;}' unless defined(&I2O_CMD_COMPLETED);
	eval 'sub I2O_RTN_NO_ERROR () {0;}' unless defined(&I2O_RTN_NO_ERROR);
	eval 'sub I2O_RTN_NOT_INIT () {1;}' unless defined(&I2O_RTN_NOT_INIT);
	eval 'sub I2O_RTN_FREE_Q_EMPTY () {2;}' unless defined(&I2O_RTN_FREE_Q_EMPTY);
	eval 'sub I2O_RTN_TCB_ERROR () {3;}' unless defined(&I2O_RTN_TCB_ERROR);
	eval 'sub I2O_RTN_TRANSACTION_ERROR () {4;}' unless defined(&I2O_RTN_TRANSACTION_ERROR);
	eval 'sub I2O_RTN_ADAPTER_ALREADY_INIT () {5;}' unless defined(&I2O_RTN_ADAPTER_ALREADY_INIT);
	eval 'sub I2O_RTN_MALLOC_ERROR () {6;}' unless defined(&I2O_RTN_MALLOC_ERROR);
	eval 'sub I2O_RTN_ADPTR_NOT_REGISTERED () {7;}' unless defined(&I2O_RTN_ADPTR_NOT_REGISTERED);
	eval 'sub I2O_RTN_MSG_REPLY_TIMEOUT () {8;}' unless defined(&I2O_RTN_MSG_REPLY_TIMEOUT);
	eval 'sub I2O_RTN_NO_STATUS () {9;}' unless defined(&I2O_RTN_NO_STATUS);
	eval 'sub I2O_RTN_NO_FIRM_VER () {10;}' unless defined(&I2O_RTN_NO_FIRM_VER);
	eval 'sub I2O_RTN_NO_LINK_SPEED () {11;}' unless defined(&I2O_RTN_NO_LINK_SPEED);
	eval 'sub I2O_REPLY_STATUS_SUCCESS () {0x;}' unless defined(&I2O_REPLY_STATUS_SUCCESS);
	eval 'sub I2O_REPLY_STATUS_ABORT_DIRTY () {0x1;}' unless defined(&I2O_REPLY_STATUS_ABORT_DIRTY);
	eval 'sub I2O_REPLY_STATUS_ABORT_NO_DATA_TRANSFER () {0x2;}' unless defined(&I2O_REPLY_STATUS_ABORT_NO_DATA_TRANSFER);
	eval 'sub I2O_REPLY_STATUS_ABORT_PARTIAL_TRANSFER () {0x3;}' unless defined(&I2O_REPLY_STATUS_ABORT_PARTIAL_TRANSFER);
	eval 'sub I2O_REPLY_STATUS_ERROR_DIRTY () {0x4;}' unless defined(&I2O_REPLY_STATUS_ERROR_DIRTY);
	eval 'sub I2O_REPLY_STATUS_ERROR_NO_DATA_TRANSFER () {0x5;}' unless defined(&I2O_REPLY_STATUS_ERROR_NO_DATA_TRANSFER);
	eval 'sub I2O_REPLY_STATUS_ERROR_PARTIAL_TRANSFER () {0x6;}' unless defined(&I2O_REPLY_STATUS_ERROR_PARTIAL_TRANSFER);
	eval 'sub I2O_REPLY_STATUS_PROCESS_ABORT_DIRTY () {0x8;}' unless defined(&I2O_REPLY_STATUS_PROCESS_ABORT_DIRTY);
	eval 'sub I2O_REPLY_STATUS_PROCESS_ABORT_NO_DATA_TRANSFER () {0x9;}' unless defined(&I2O_REPLY_STATUS_PROCESS_ABORT_NO_DATA_TRANSFER);
	eval 'sub I2O_REPLY_STATUS_PROCESS_ABORT_PARTIAL_TRANSFER () {0xa;}' unless defined(&I2O_REPLY_STATUS_PROCESS_ABORT_PARTIAL_TRANSFER);
	eval 'sub I2O_REPLY_STATUS_TRANSACTION_ERROR () {0xb;}' unless defined(&I2O_REPLY_STATUS_TRANSACTION_ERROR);
	eval 'sub I2O_REPLY_STATUS_PROGRESS_REPORT () {0x80;}' unless defined(&I2O_REPLY_STATUS_PROGRESS_REPORT);
	eval 'sub I2O_PARAMS_STATUS_SUCCESS () {0x;}' unless defined(&I2O_PARAMS_STATUS_SUCCESS);
	eval 'sub I2O_PARAMS_STATUS_BAD_KEY_ABORT () {0x1;}' unless defined(&I2O_PARAMS_STATUS_BAD_KEY_ABORT);
	eval 'sub I2O_PARAMS_STATUS_BAD_KEY_CONTINUE () {0x2;}' unless defined(&I2O_PARAMS_STATUS_BAD_KEY_CONTINUE);
	eval 'sub I2O_PARAMS_STATUS_BUFFER_FULL () {0x3;}' unless defined(&I2O_PARAMS_STATUS_BUFFER_FULL);
	eval 'sub I2O_PARAMS_STATUS_BUFFER_TOO_SMALL () {0x4;}' unless defined(&I2O_PARAMS_STATUS_BUFFER_TOO_SMALL);
	eval 'sub I2O_PARAMS_STATUS_FIELD_UNREADABLE () {0x5;}' unless defined(&I2O_PARAMS_STATUS_FIELD_UNREADABLE);
	eval 'sub I2O_PARAMS_STATUS_FIELD_UNWRITEABLE () {0x6;}' unless defined(&I2O_PARAMS_STATUS_FIELD_UNWRITEABLE);
	eval 'sub I2O_PARAMS_STATUS_INSUFFICIENT_FIELDS () {0x7;}' unless defined(&I2O_PARAMS_STATUS_INSUFFICIENT_FIELDS);
	eval 'sub I2O_PARAMS_STATUS_INVALID_GROUP_ID () {0x8;}' unless defined(&I2O_PARAMS_STATUS_INVALID_GROUP_ID);
	eval 'sub I2O_PARAMS_STATUS_INVALID_OPERATION () {0x9;}' unless defined(&I2O_PARAMS_STATUS_INVALID_OPERATION);
	eval 'sub I2O_PARAMS_STATUS_NO_KEY_FIELD () {0xa;}' unless defined(&I2O_PARAMS_STATUS_NO_KEY_FIELD);
	eval 'sub I2O_PARAMS_STATUS_NO_SUCH_FIELD () {0xb;}' unless defined(&I2O_PARAMS_STATUS_NO_SUCH_FIELD);
	eval 'sub I2O_PARAMS_STATUS_NON_DYNAMIC_GROUP () {0xc;}' unless defined(&I2O_PARAMS_STATUS_NON_DYNAMIC_GROUP);
	eval 'sub I2O_PARAMS_STATUS_OPERATION_ERROR () {0xd;}' unless defined(&I2O_PARAMS_STATUS_OPERATION_ERROR);
	eval 'sub I2O_PARAMS_STATUS_SCALAR_ERROR () {0xe;}' unless defined(&I2O_PARAMS_STATUS_SCALAR_ERROR);
	eval 'sub I2O_PARAMS_STATUS_TABLE_ERROR () {0xf;}' unless defined(&I2O_PARAMS_STATUS_TABLE_ERROR);
	eval 'sub I2O_PARAMS_STATUS_WRONG_GROUP_TYPE () {0x10;}' unless defined(&I2O_PARAMS_STATUS_WRONG_GROUP_TYPE);
	eval 'sub I2O_DSC_SUCCESS () {0x;}' unless defined(&I2O_DSC_SUCCESS);
	eval 'sub I2O_DSC_BAD_KEY () {0x2;}' unless defined(&I2O_DSC_BAD_KEY);
	eval 'sub I2O_DSC_TCL_ERROR () {0x3;}' unless defined(&I2O_DSC_TCL_ERROR);
	eval 'sub I2O_DSC_REPLY_BUFFER_FULL () {0x4;}' unless defined(&I2O_DSC_REPLY_BUFFER_FULL);
	eval 'sub I2O_DSC_NO_SUCH_PAGE () {0x5;}' unless defined(&I2O_DSC_NO_SUCH_PAGE);
	eval 'sub I2O_DSC_INSUFFICIENT_RESOURCE_SOFT () {0x6;}' unless defined(&I2O_DSC_INSUFFICIENT_RESOURCE_SOFT);
	eval 'sub I2O_DSC_INSUFFICIENT_RESOURCE_HARD () {0x7;}' unless defined(&I2O_DSC_INSUFFICIENT_RESOURCE_HARD);
	eval 'sub I2O_DSC_CHAIN_BUFFER_TOO_LARGE () {0x9;}' unless defined(&I2O_DSC_CHAIN_BUFFER_TOO_LARGE);
	eval 'sub I2O_DSC_UNSUPPORTED_FUNCTION () {0xa;}' unless defined(&I2O_DSC_UNSUPPORTED_FUNCTION);
	eval 'sub I2O_DSC_DEVICE_LOCKED () {0xb;}' unless defined(&I2O_DSC_DEVICE_LOCKED);
	eval 'sub I2O_DSC_DEVICE_RESET () {0xc;}' unless defined(&I2O_DSC_DEVICE_RESET);
	eval 'sub I2O_DSC_INAPPROPRIATE_FUNCTION () {0xd;}' unless defined(&I2O_DSC_INAPPROPRIATE_FUNCTION);
	eval 'sub I2O_DSC_INVALID_INITIATOR_ADDRESS () {0xe;}' unless defined(&I2O_DSC_INVALID_INITIATOR_ADDRESS);
	eval 'sub I2O_DSC_INVALID_MESSAGE_FLAGS () {0xf;}' unless defined(&I2O_DSC_INVALID_MESSAGE_FLAGS);
	eval 'sub I2O_DSC_INVALID_OFFSET () {0x10;}' unless defined(&I2O_DSC_INVALID_OFFSET);
	eval 'sub I2O_DSC_INVALID_PARAMETER () {0x11;}' unless defined(&I2O_DSC_INVALID_PARAMETER);
	eval 'sub I2O_DSC_INVALID_REQUEST () {0x12;}' unless defined(&I2O_DSC_INVALID_REQUEST);
	eval 'sub I2O_DSC_INVALID_TARGET_ADDRESS () {0x13;}' unless defined(&I2O_DSC_INVALID_TARGET_ADDRESS);
	eval 'sub I2O_DSC_MESSAGE_TOO_LARGE () {0x14;}' unless defined(&I2O_DSC_MESSAGE_TOO_LARGE);
	eval 'sub I2O_DSC_MESSAGE_TOO_SMALL () {0x15;}' unless defined(&I2O_DSC_MESSAGE_TOO_SMALL);
	eval 'sub I2O_DSC_MISSING_PARAMETER () {0x16;}' unless defined(&I2O_DSC_MISSING_PARAMETER);
	eval 'sub I2O_DSC_TIMEOUT () {0x17;}' unless defined(&I2O_DSC_TIMEOUT);
	eval 'sub I2O_DSC_UNKNOWN_ERROR () {0x18;}' unless defined(&I2O_DSC_UNKNOWN_ERROR);
	eval 'sub I2O_DSC_UNKNOWN_FUNCTION () {0x19;}' unless defined(&I2O_DSC_UNKNOWN_FUNCTION);
	eval 'sub I2O_DSC_UNSUPPORTED_VERSION () {0x1a;}' unless defined(&I2O_DSC_UNSUPPORTED_VERSION);
	eval 'sub I2O_DSC_DEVICE_BUSY () {0x1b;}' unless defined(&I2O_DSC_DEVICE_BUSY);
	eval 'sub I2O_DSC_DEVICE_NOT_AVAILABLE () {0x1c;}' unless defined(&I2O_DSC_DEVICE_NOT_AVAILABLE);
	eval 'sub I2O_BSA_DSC_SUCCESS () {0x;}' unless defined(&I2O_BSA_DSC_SUCCESS);
	eval 'sub I2O_BSA_DSC_MEDIA_ERROR () {0x1;}' unless defined(&I2O_BSA_DSC_MEDIA_ERROR);
	eval 'sub I2O_BSA_DSC_ACCESS_ERROR () {0x2;}' unless defined(&I2O_BSA_DSC_ACCESS_ERROR);
	eval 'sub I2O_BSA_DSC_DEVICE_FAILURE () {0x3;}' unless defined(&I2O_BSA_DSC_DEVICE_FAILURE);
	eval 'sub I2O_BSA_DSC_DEVICE_NOT_READY () {0x4;}' unless defined(&I2O_BSA_DSC_DEVICE_NOT_READY);
	eval 'sub I2O_BSA_DSC_MEDIA_NOT_PRESENT () {0x5;}' unless defined(&I2O_BSA_DSC_MEDIA_NOT_PRESENT);
	eval 'sub I2O_BSA_DSC_MEDIA_LOCKED () {0x6;}' unless defined(&I2O_BSA_DSC_MEDIA_LOCKED);
	eval 'sub I2O_BSA_DSC_MEDIA_FAILURE () {0x7;}' unless defined(&I2O_BSA_DSC_MEDIA_FAILURE);
	eval 'sub I2O_BSA_DSC_PROTOCOL_FAILURE () {0x8;}' unless defined(&I2O_BSA_DSC_PROTOCOL_FAILURE);
	eval 'sub I2O_BSA_DSC_BUS_FAILURE () {0x9;}' unless defined(&I2O_BSA_DSC_BUS_FAILURE);
	eval 'sub I2O_BSA_DSC_ACCESS_VIOLATION () {0xa;}' unless defined(&I2O_BSA_DSC_ACCESS_VIOLATION);
	eval 'sub I2O_BSA_DSC_WRITE_PROTECTED () {0xb;}' unless defined(&I2O_BSA_DSC_WRITE_PROTECTED);
	eval 'sub I2O_BSA_DSC_DEVICE_RESET () {0xc;}' unless defined(&I2O_BSA_DSC_DEVICE_RESET);
	eval 'sub I2O_BSA_DSC_VOLUME_CHANGED () {0xd;}' unless defined(&I2O_BSA_DSC_VOLUME_CHANGED);
	eval 'sub I2O_BSA_DSC_TIMEOUT () {0xe;}' unless defined(&I2O_BSA_DSC_TIMEOUT);
	eval 'sub I2O_FSC_TRANSPORT_SERVICE_SUSPENDED () {0x81;}' unless defined(&I2O_FSC_TRANSPORT_SERVICE_SUSPENDED);
	eval 'sub I2O_FSC_TRANSPORT_SERVICE_TERMINATED () {0x82;}' unless defined(&I2O_FSC_TRANSPORT_SERVICE_TERMINATED);
	eval 'sub I2O_FSC_TRANSPORT_CONGESTION () {0x83;}' unless defined(&I2O_FSC_TRANSPORT_CONGESTION);
	eval 'sub I2O_FSC_TRANSPORT_FAILURE () {0x84;}' unless defined(&I2O_FSC_TRANSPORT_FAILURE);
	eval 'sub I2O_FSC_TRANSPORT_STATE_ERROR () {0x85;}' unless defined(&I2O_FSC_TRANSPORT_STATE_ERROR);
	eval 'sub I2O_FSC_TRANSPORT_TIME_OUT () {0x86;}' unless defined(&I2O_FSC_TRANSPORT_TIME_OUT);
	eval 'sub I2O_FSC_TRANSPORT_ROUTING_FAILURE () {0x87;}' unless defined(&I2O_FSC_TRANSPORT_ROUTING_FAILURE);
	eval 'sub I2O_FSC_TRANSPORT_INVALID_VERSION () {0x88;}' unless defined(&I2O_FSC_TRANSPORT_INVALID_VERSION);
	eval 'sub I2O_FSC_TRANSPORT_INVALID_OFFSET () {0x89;}' unless defined(&I2O_FSC_TRANSPORT_INVALID_OFFSET);
	eval 'sub I2O_FSC_TRANSPORT_INVALID_MSG_FLAGS () {0x8a;}' unless defined(&I2O_FSC_TRANSPORT_INVALID_MSG_FLAGS);
	eval 'sub I2O_FSC_TRANSPORT_FRAME_TOO_SMALL () {0x8b;}' unless defined(&I2O_FSC_TRANSPORT_FRAME_TOO_SMALL);
	eval 'sub I2O_FSC_TRANSPORT_FRAME_TOO_LARGE () {0x8c;}' unless defined(&I2O_FSC_TRANSPORT_FRAME_TOO_LARGE);
	eval 'sub I2O_FSC_TRANSPORT_INVALID_TARGET_ID () {0x8d;}' unless defined(&I2O_FSC_TRANSPORT_INVALID_TARGET_ID);
	eval 'sub I2O_FSC_TRANSPORT_INVALID_INITIATOR_ID () {0x8e;}' unless defined(&I2O_FSC_TRANSPORT_INVALID_INITIATOR_ID);
	eval 'sub I2O_FSC_TRANSPORT_INVALID_INITIATOR_CONTEXT () {0x8f;}' unless defined(&I2O_FSC_TRANSPORT_INVALID_INITIATOR_CONTEXT);
	eval 'sub I2O_FSC_TRANSPORT_UNKNOWN_FAILURE () {0xff;}' unless defined(&I2O_FSC_TRANSPORT_UNKNOWN_FAILURE);
	eval 'sub I2O_CLAIM_PRIMARY () {0x1000000;}' unless defined(&I2O_CLAIM_PRIMARY);
	eval 'sub I2O_CLAIM_MANAGEMENT () {0x2000000;}' unless defined(&I2O_CLAIM_MANAGEMENT);
	eval 'sub I2O_CLAIM_AUTHORIZED () {0x3000000;}' unless defined(&I2O_CLAIM_AUTHORIZED);
	eval 'sub I2O_CLAIM_SECONDARY () {0x4000000;}' unless defined(&I2O_CLAIM_SECONDARY);
	eval 'sub I2OVER15 () {0x1;}' unless defined(&I2OVER15);
	eval 'sub I2OVER20 () {0x2;}' unless defined(&I2OVER20);
	eval 'sub I2OVERSION () { &I2OVER15;}' unless defined(&I2OVERSION);
	eval 'sub SGL_OFFSET_0 () { &I2OVERSION;}' unless defined(&SGL_OFFSET_0);
	eval 'sub SGL_OFFSET_4 () {(0x40 |  &I2OVERSION);}' unless defined(&SGL_OFFSET_4);
	eval 'sub SGL_OFFSET_5 () {(0x50 |  &I2OVERSION);}' unless defined(&SGL_OFFSET_5);
	eval 'sub SGL_OFFSET_6 () {(0x60 |  &I2OVERSION);}' unless defined(&SGL_OFFSET_6);
	eval 'sub SGL_OFFSET_7 () {(0x70 |  &I2OVERSION);}' unless defined(&SGL_OFFSET_7);
	eval 'sub SGL_OFFSET_8 () {(0x80 |  &I2OVERSION);}' unless defined(&SGL_OFFSET_8);
	eval 'sub SGL_OFFSET_9 () {(0x90 |  &I2OVERSION);}' unless defined(&SGL_OFFSET_9);
	eval 'sub SGL_OFFSET_10 () {(0xa0 |  &I2OVERSION);}' unless defined(&SGL_OFFSET_10);
	eval 'sub TRL_OFFSET_5 () {(0x50 |  &I2OVERSION);}' unless defined(&TRL_OFFSET_5);
	eval 'sub TRL_OFFSET_6 () {(0x60 |  &I2OVERSION);}' unless defined(&TRL_OFFSET_6);
	eval 'sub TRL_SINGLE_FIXED_LENGTH () {0x;}' unless defined(&TRL_SINGLE_FIXED_LENGTH);
	eval 'sub TRL_SINGLE_VARIABLE_LENGTH () {0x40;}' unless defined(&TRL_SINGLE_VARIABLE_LENGTH);
	eval 'sub TRL_MULTIPLE_FIXED_LENGTH () {0x80;}' unless defined(&TRL_MULTIPLE_FIXED_LENGTH);
	eval 'sub MSG_STATIC () {0x100;}' unless defined(&MSG_STATIC);
	eval 'sub MSG_64BIT_CNTXT () {0x200;}' unless defined(&MSG_64BIT_CNTXT);
	eval 'sub MSG_MULTI_TRANS () {0x1000;}' unless defined(&MSG_MULTI_TRANS);
	eval 'sub MSG_FAIL () {0x2000;}' unless defined(&MSG_FAIL);
	eval 'sub MSG_FINAL () {0x4000;}' unless defined(&MSG_FINAL);
	eval 'sub MSG_REPLY () {0x8000;}' unless defined(&MSG_REPLY);
	eval 'sub THREE_WORD_MSG_SIZE () {0x30000;}' unless defined(&THREE_WORD_MSG_SIZE);
	eval 'sub FOUR_WORD_MSG_SIZE () {0x40000;}' unless defined(&FOUR_WORD_MSG_SIZE);
	eval 'sub FIVE_WORD_MSG_SIZE () {0x50000;}' unless defined(&FIVE_WORD_MSG_SIZE);
	eval 'sub SIX_WORD_MSG_SIZE () {0x60000;}' unless defined(&SIX_WORD_MSG_SIZE);
	eval 'sub SEVEN_WORD_MSG_SIZE () {0x70000;}' unless defined(&SEVEN_WORD_MSG_SIZE);
	eval 'sub EIGHT_WORD_MSG_SIZE () {0x80000;}' unless defined(&EIGHT_WORD_MSG_SIZE);
	eval 'sub NINE_WORD_MSG_SIZE () {0x90000;}' unless defined(&NINE_WORD_MSG_SIZE);
	eval 'sub TEN_WORD_MSG_SIZE () {0xa0000;}' unless defined(&TEN_WORD_MSG_SIZE);
	eval 'sub ELEVEN_WORD_MSG_SIZE () {0xb0000;}' unless defined(&ELEVEN_WORD_MSG_SIZE);
	eval 'sub I2O_MESSAGE_SIZE {
	    my($x) = @_;
    	    eval q((($x)<<16));
	}' unless defined(&I2O_MESSAGE_SIZE);
	eval 'sub ADAPTER_TID () {0;}' unless defined(&ADAPTER_TID);
	eval 'sub HOST_TID () {1;}' unless defined(&HOST_TID);
	eval 'sub MSG_FRAME_SIZE () {128;}' unless defined(&MSG_FRAME_SIZE);
	eval 'sub REPLY_FRAME_SIZE () {17;}' unless defined(&REPLY_FRAME_SIZE);
	eval 'sub SG_TABLESIZE () {30;}' unless defined(&SG_TABLESIZE);
	eval 'sub NMBR_MSG_FRAMES () {128;}' unless defined(&NMBR_MSG_FRAMES);
	eval 'sub MSG_POOL_SIZE () {( &MSG_FRAME_SIZE* &NMBR_MSG_FRAMES*$sizeof{ &u32});}' unless defined(&MSG_POOL_SIZE);
	eval 'sub I2O_POST_WAIT_OK () {0;}' unless defined(&I2O_POST_WAIT_OK);
	eval 'sub I2O_POST_WAIT_TIMEOUT () {- &ETIMEDOUT;}' unless defined(&I2O_POST_WAIT_TIMEOUT);
	eval 'sub I2O_CONTEXT_LIST_MIN_LENGTH () {15;}' unless defined(&I2O_CONTEXT_LIST_MIN_LENGTH);
	eval 'sub I2O_CONTEXT_LIST_USED () {0x1;}' unless defined(&I2O_CONTEXT_LIST_USED);
	eval 'sub I2O_CONTEXT_LIST_DELETED () {0x2;}' unless defined(&I2O_CONTEXT_LIST_DELETED);
	eval 'sub I2O_TIMEOUT_INIT_OUTBOUND_QUEUE () {15;}' unless defined(&I2O_TIMEOUT_INIT_OUTBOUND_QUEUE);
	eval 'sub I2O_TIMEOUT_MESSAGE_GET () {5;}' unless defined(&I2O_TIMEOUT_MESSAGE_GET);
	eval 'sub I2O_TIMEOUT_RESET () {30;}' unless defined(&I2O_TIMEOUT_RESET);
	eval 'sub I2O_TIMEOUT_STATUS_GET () {5;}' unless defined(&I2O_TIMEOUT_STATUS_GET);
	eval 'sub I2O_TIMEOUT_LCT_GET () {360;}' unless defined(&I2O_TIMEOUT_LCT_GET);
	eval 'sub I2O_TIMEOUT_SCSI_SCB_ABORT () {240;}' unless defined(&I2O_TIMEOUT_SCSI_SCB_ABORT);
	eval 'sub I2O_HRT_GET_TRIES () {3;}' unless defined(&I2O_HRT_GET_TRIES);
	eval 'sub I2O_LCT_GET_TRIES () {3;}' unless defined(&I2O_LCT_GET_TRIES);
	eval 'sub I2O_MAX_SECTORS () {1024;}' unless defined(&I2O_MAX_SECTORS);
	eval 'sub I2O_MAX_SEGMENTS () {128;}' unless defined(&I2O_MAX_SEGMENTS);
	eval 'sub I2O_REQ_MEMPOOL_SIZE () {32;}' unless defined(&I2O_REQ_MEMPOOL_SIZE);
    }
}
1;
