require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_GENHD_H)) {
    eval 'sub _LINUX_GENHD_H () {1;}' unless defined(&_LINUX_GENHD_H);
    require 'linux/config.ph';
    require 'linux/types.ph';
    require 'linux/major.ph';
    require 'linux/device.ph';
    require 'linux/smp.ph';
    require 'linux/string.ph';
    require 'linux/fs.ph';
    eval("sub DOS_EXTENDED_PARTITION () { 5; }") unless defined(&DOS_EXTENDED_PARTITION);
    eval("sub LINUX_EXTENDED_PARTITION () { 0x85; }") unless defined(&LINUX_EXTENDED_PARTITION);
    eval("sub WIN98_EXTENDED_PARTITION () { 0x0f; }") unless defined(&WIN98_EXTENDED_PARTITION);
    eval("sub LINUX_SWAP_PARTITION () { 0x82; }") unless defined(&LINUX_SWAP_PARTITION);
    eval("sub LINUX_RAID_PARTITION () { 0xfd; }") unless defined(&LINUX_RAID_PARTITION);
    eval("sub SOLARIS_X86_PARTITION () { LINUX_SWAP_PARTITION; }") unless defined(&SOLARIS_X86_PARTITION);
    eval("sub NEW_SOLARIS_X86_PARTITION () { 0xbf; }") unless defined(&NEW_SOLARIS_X86_PARTITION);
    eval("sub DM6_AUX1PARTITION () { 0x51; }") unless defined(&DM6_AUX1PARTITION);
    eval("sub DM6_AUX3PARTITION () { 0x53; }") unless defined(&DM6_AUX3PARTITION);
    eval("sub DM6_PARTITION () { 0x54; }") unless defined(&DM6_PARTITION);
    eval("sub EZD_PARTITION () { 0x55; }") unless defined(&EZD_PARTITION);
    eval("sub FREEBSD_PARTITION () { 0xa5; }") unless defined(&FREEBSD_PARTITION);
    eval("sub OPENBSD_PARTITION () { 0xa6; }") unless defined(&OPENBSD_PARTITION);
    eval("sub NETBSD_PARTITION () { 0xa9; }") unless defined(&NETBSD_PARTITION);
    eval("sub BSDI_PARTITION () { 0xb7; }") unless defined(&BSDI_PARTITION);
    eval("sub MINIX_PARTITION () { 0x81; }") unless defined(&MINIX_PARTITION);
    eval("sub UNIXWARE_PARTITION () { 0x63; }") unless defined(&UNIXWARE_PARTITION);
    unless(defined(&__KERNEL__)) {
    }
    if(defined(&__KERNEL__)) {
	eval 'sub GENHD_FL_REMOVABLE () {1;}' unless defined(&GENHD_FL_REMOVABLE);
	eval 'sub GENHD_FL_DRIVERFS () {2;}' unless defined(&GENHD_FL_DRIVERFS);
	eval 'sub GENHD_FL_CD () {8;}' unless defined(&GENHD_FL_CD);
	eval 'sub GENHD_FL_UP () {16;}' unless defined(&GENHD_FL_UP);
	eval 'sub GENHD_FL_SUPPRESS_PARTITION_INFO () {32;}' unless defined(&GENHD_FL_SUPPRESS_PARTITION_INFO);
	if(defined(&CONFIG_SMP)) {
	} else {
	}
	if(defined(&CONFIG_SMP)) {
	    eval 'sub __disk_stat_add {
	        my($gendiskp, $field, $addnd) = @_;
    		eval q(( &per_cpu_ptr( ($gendiskp->{dkstats}),  &smp_processor_id())->$field += $addnd));
	    }' unless defined(&__disk_stat_add);
	    eval 'sub disk_stat_read {
	        my($gendiskp, $field) = @_;
    		eval q(({  &typeof( ($gendiskp->{dkstats}->{field}))  &res = 0; \'int\'  &i;  &for ( &i=0;  &i <  &NR_CPUS;  &i++) {  &if (! &cpu_possible( &i))  &continue;  &res +=  &per_cpu_ptr( ($gendiskp->{dkstats}),  &i)->$field; }  &res; }));
	    }' unless defined(&disk_stat_read);
	    eval 'sub disk_stat_set_all {
	        my($gendiskp,$value) = @_;
    		eval q({ \'int\'  &i;  &for ( &i=0;  &i <  &NR_CPUS;  &i++) {  &if ( &cpu_possible( &i)) {  &memset( &per_cpu_ptr( ($gendiskp->{dkstats}),  &i), $value, $sizeof{\'struct disk_stats\'}); } } } );
	    }' unless defined(&disk_stat_set_all);
	} else {
	    eval 'sub __disk_stat_add {
	        my($gendiskp, $field, $addnd) = @_;
    		eval q(( ($gendiskp->{dkstats}->{field}) += $addnd));
	    }' unless defined(&__disk_stat_add);
	    eval 'sub disk_stat_read {
	        my($gendiskp, $field) = @_;
    		eval q(( ($gendiskp->{dkstats}->{field})));
	    }' unless defined(&disk_stat_read);
	    eval 'sub disk_stat_set_all {
	        my($gendiskp,$value) = @_;
    		eval q({  &memset( ($gendiskp->{dkstats}), $value, $sizeof{\'struct disk_stats\'}); });
	    }' unless defined(&disk_stat_set_all);
	}
	eval 'sub disk_stat_add {
	    my($gendiskp, $field, $addnd) = @_;
    	    eval q( &do {  &preempt_disable();  &__disk_stat_add($gendiskp, $field, $addnd);  &preempt_enable(); }  &while (0));
	}' unless defined(&disk_stat_add);
	eval 'sub __disk_stat_dec {
	    my($gendiskp, $field) = @_;
    	    eval q( &__disk_stat_add($gendiskp, $field, -1));
	}' unless defined(&__disk_stat_dec);
	eval 'sub disk_stat_dec {
	    my($gendiskp, $field) = @_;
    	    eval q( &disk_stat_add($gendiskp, $field, -1));
	}' unless defined(&disk_stat_dec);
	eval 'sub __disk_stat_inc {
	    my($gendiskp, $field) = @_;
    	    eval q( &__disk_stat_add($gendiskp, $field, 1));
	}' unless defined(&__disk_stat_inc);
	eval 'sub disk_stat_inc {
	    my($gendiskp, $field) = @_;
    	    eval q( &disk_stat_add($gendiskp, $field, 1));
	}' unless defined(&disk_stat_inc);
	eval 'sub __disk_stat_sub {
	    my($gendiskp, $field, $subnd) = @_;
    	    eval q( &__disk_stat_add($gendiskp, $field, -$subnd));
	}' unless defined(&__disk_stat_sub);
	eval 'sub disk_stat_sub {
	    my($gendiskp, $field, $subnd) = @_;
    	    eval q( &disk_stat_add($gendiskp, $field, -$subnd));
	}' unless defined(&disk_stat_sub);
	if(defined(&CONFIG_SMP)) {
	    eval 'sub init_disk_stats {
	        my($disk) = @_;
    		eval q({  ($disk->{dkstats}) =  &alloc_percpu;  &if (! ($disk->{dkstats})) 0; 1; });
	    }' unless defined(&init_disk_stats);
	    eval 'sub free_disk_stats {
	        my($disk) = @_;
    		eval q({  &free_percpu( ($disk->{dkstats})); });
	    }' unless defined(&free_disk_stats);
	} else {
	    eval 'sub init_disk_stats {
	        my($disk) = @_;
    		eval q({ 1; });
	    }' unless defined(&init_disk_stats);
	    eval 'sub free_disk_stats {
	        my($disk) = @_;
    		eval q({ });
	    }' unless defined(&free_disk_stats);
	}
	eval 'sub get_start_sect {
	    my($bdev) = @_;
    	    eval q({  ($bdev->{bd_contains}) == $bdev ? 0:  ($bdev->{bd_part}->{start_sect}); });
	}' unless defined(&get_start_sect);
	eval 'sub get_capacity {
	    my($disk) = @_;
    	    eval q({  ($disk->{capacity}); });
	}' unless defined(&get_capacity);
	eval 'sub set_capacity {
	    my($disk,$size) = @_;
    	    eval q({  ($disk->{capacity}) = $size; });
	}' unless defined(&set_capacity);
    }
    if(defined(&CONFIG_SOLARIS_X86_PARTITION)) {
	eval 'sub SOLARIS_X86_NUMSLICE () {8;}' unless defined(&SOLARIS_X86_NUMSLICE);
	eval 'sub SOLARIS_X86_VTOC_SANE () {(0x600ddeee);}' unless defined(&SOLARIS_X86_VTOC_SANE);
    }
    if(defined(&CONFIG_BSD_DISKLABEL)) {
	eval 'sub BSD_DISKMAGIC () {(0x82564557);}' unless defined(&BSD_DISKMAGIC);
	eval 'sub BSD_MAXPARTITIONS () {16;}' unless defined(&BSD_MAXPARTITIONS);
	eval 'sub OPENBSD_MAXPARTITIONS () {16;}' unless defined(&OPENBSD_MAXPARTITIONS);
	eval 'sub BSD_FS_UNUSED () {0;}' unless defined(&BSD_FS_UNUSED);
	eval 'sub NDDATA () {5;}' unless defined(&NDDATA);
	eval 'sub NSPARE () {5;}' unless defined(&NSPARE);
    }
    if(defined(&CONFIG_UNIXWARE_DISKLABEL)) {
	eval 'sub UNIXWARE_DISKMAGIC () {(0xca5e600d);}' unless defined(&UNIXWARE_DISKMAGIC);
	eval 'sub UNIXWARE_DISKMAGIC2 () {(0x600ddeee);}' unless defined(&UNIXWARE_DISKMAGIC2);
	eval 'sub UNIXWARE_NUMSLICE () {16;}' unless defined(&UNIXWARE_NUMSLICE);
	eval 'sub UNIXWARE_FS_UNUSED () {0;}' unless defined(&UNIXWARE_FS_UNUSED);
    }
    if(defined(&CONFIG_MINIX_SUBPARTITION)) {
	eval 'sub MINIX_NR_SUBPARTITIONS () {4;}' unless defined(&MINIX_NR_SUBPARTITIONS);
    }
    if(defined(&__KERNEL__)) {
	eval 'sub block_device {
	    eval q(* &bdget_disk(\'struct gendisk\' * &disk, \'int\'  &index) {  &bdget( &MKDEV( ($disk->{major}),  ($disk->{first_minor})) +  &index); });
	}' unless defined(&block_device);
    }
}
1;
