require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_DEVICE_H_)) {
    eval 'sub _DEVICE_H_ () {1;}' unless defined(&_DEVICE_H_);
    require 'linux/config.ph';
    require 'linux/ioport.ph';
    require 'linux/kobject.ph';
    require 'linux/list.ph';
    require 'linux/spinlock.ph';
    require 'linux/types.ph';
    require 'linux/module.ph';
    require 'linux/pm.ph';
    require 'asm/semaphore.ph';
    require 'asm/atomic.ph';
    eval 'sub DEVICE_NAME_SIZE () {50;}' unless defined(&DEVICE_NAME_SIZE);
    eval 'sub DEVICE_NAME_HALF () { &__stringify(20);}' unless defined(&DEVICE_NAME_HALF);
    eval 'sub DEVICE_ID_SIZE () {32;}' unless defined(&DEVICE_ID_SIZE);
    eval 'sub BUS_ID_SIZE () { &KOBJ_NAME_LEN;}' unless defined(&BUS_ID_SIZE);
    eval("sub SUSPEND_NOTIFY () { 0; }") unless defined(&SUSPEND_NOTIFY);
    eval("sub SUSPEND_SAVE_STATE () { 1; }") unless defined(&SUSPEND_SAVE_STATE);
    eval("sub SUSPEND_DISABLE () { 2; }") unless defined(&SUSPEND_DISABLE);
    eval("sub SUSPEND_POWER_DOWN () { 3; }") unless defined(&SUSPEND_POWER_DOWN);
    eval("sub RESUME_POWER_ON () { 0; }") unless defined(&RESUME_POWER_ON);
    eval("sub RESUME_RESTORE_STATE () { 1; }") unless defined(&RESUME_RESTORE_STATE);
    eval("sub RESUME_ENABLE () { 2; }") unless defined(&RESUME_ENABLE);
    eval 'sub BUS_ATTR {
        my($_name,$_mode,$_show,$_store) = @_;
	    eval q(\'struct bus_attribute\'  &bus_attr_$_name =  &__ATTR($_name,$_mode,$_show,$_store));
    }' unless defined(&BUS_ATTR);
    eval 'sub DRIVER_ATTR {
        my($_name,$_mode,$_show,$_store) = @_;
	    eval q(\'struct driver_attribute\'  &driver_attr_$_name =  &__ATTR($_name,$_mode,$_show,$_store));
    }' unless defined(&DRIVER_ATTR);
    eval 'sub CLASS_ATTR {
        my($_name,$_mode,$_show,$_store) = @_;
	    eval q(\'struct class_attribute\'  &class_attr_$_name =  &__ATTR($_name,$_mode,$_show,$_store));
    }' unless defined(&CLASS_ATTR);
    eval 'sub class_get_devdata {
        my($dev) = @_;
	    eval q({  ($dev->{class_data}); });
    }' unless defined(&class_get_devdata);
    eval 'sub class_set_devdata {
        my($dev,$data) = @_;
	    eval q({  ($dev->{class_data}) = $data; });
    }' unless defined(&class_set_devdata);
    eval 'sub CLASS_DEVICE_ATTR {
        my($_name,$_mode,$_show,$_store) = @_;
	    eval q(\'struct class_device_attribute\'  &class_device_attr_$_name =  &__ATTR($_name,$_mode,$_show,$_store));
    }' unless defined(&CLASS_DEVICE_ATTR);
    eval 'sub list_to_dev {
        my($node) = @_;
	    eval q({  &list_entry($node, \'struct device\', $node); });
    }' unless defined(&list_to_dev);
    eval 'sub dev_get_drvdata {
        my($dev) = @_;
	    eval q({  ($dev->{driver_data}); });
    }' unless defined(&dev_get_drvdata);
    eval 'sub dev_set_drvdata {
        my($dev,$data) = @_;
	    eval q({  ($dev->{driver_data}) = $data; });
    }' unless defined(&dev_set_drvdata);
    eval 'sub DEVICE_ATTR {
        my($_name,$_mode,$_show,$_store) = @_;
	    eval q(\'struct device_attribute\'  &dev_attr_$_name =  &__ATTR($_name,$_mode,$_show,$_store));
    }' unless defined(&DEVICE_ATTR);
    eval 'sub to_platform_device {
        my($x) = @_;
	    eval q( &container_of(($x), \'struct platform_device\',  &dev));
    }' unless defined(&to_platform_device);
    eval 'sub dev_printk () {( &level,  &dev,  &format,  &arg...)  &printk( &level "%s %s: "  &format , ( &dev)-> &driver ? ( &dev)-> ($driver->{name}) : "" , ( &dev)-> &bus_id ,   &arg);}' unless defined(&dev_printk);
    if(defined(&DEBUG)) {
	eval 'sub dev_dbg () {( &dev,  &format,  &arg...)  &dev_printk( &KERN_DEBUG ,  &dev ,  &format ,   &arg);}' unless defined(&dev_dbg);
    } else {
	eval 'sub dev_dbg () {( &dev,  &format,  &arg...)  &do { ( &void)( &dev); }  &while (0);}' unless defined(&dev_dbg);
    }
    eval 'sub dev_err () {( &dev,  &format,  &arg...)  &dev_printk( &KERN_ERR ,  &dev ,  &format ,   &arg);}' unless defined(&dev_err);
    eval 'sub dev_info () {( &dev,  &format,  &arg...)  &dev_printk( &KERN_INFO ,  &dev ,  &format ,   &arg);}' unless defined(&dev_info);
    eval 'sub dev_warn () {( &dev,  &format,  &arg...)  &dev_printk( &KERN_WARNING ,  &dev ,  &format ,   &arg);}' unless defined(&dev_warn);
    eval 'sub MODULE_ALIAS_CHARDEV {
        my($major,$minor) = @_;
	    eval q( &MODULE_ALIAS(\\"char-major-\\"  &__stringify($major) \\"-\\"  &__stringify($minor)));
    }' unless defined(&MODULE_ALIAS_CHARDEV);
    eval 'sub MODULE_ALIAS_CHARDEV_MAJOR {
        my($major) = @_;
	    eval q( &MODULE_ALIAS(\\"char-major-\\"  &__stringify($major) \\"-*\\"));
    }' unless defined(&MODULE_ALIAS_CHARDEV_MAJOR);
}
1;
