require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_AUDIT_H_)) {
    eval 'sub _LINUX_AUDIT_H_ () {1;}' unless defined(&_LINUX_AUDIT_H_);
    eval 'sub AUDIT_GET () {1000;}' unless defined(&AUDIT_GET);
    eval 'sub AUDIT_SET () {1001;}' unless defined(&AUDIT_SET);
    eval 'sub AUDIT_LIST () {1002;}' unless defined(&AUDIT_LIST);
    eval 'sub AUDIT_ADD () {1003;}' unless defined(&AUDIT_ADD);
    eval 'sub AUDIT_DEL () {1004;}' unless defined(&AUDIT_DEL);
    eval 'sub AUDIT_USER () {1005;}' unless defined(&AUDIT_USER);
    eval 'sub AUDIT_LOGIN () {1006;}' unless defined(&AUDIT_LOGIN);
    eval 'sub AUDIT_KERNEL () {2000;}' unless defined(&AUDIT_KERNEL);
    eval 'sub AUDIT_PER_TASK () {0x1;}' unless defined(&AUDIT_PER_TASK);
    eval 'sub AUDIT_AT_ENTRY () {0x2;}' unless defined(&AUDIT_AT_ENTRY);
    eval 'sub AUDIT_AT_EXIT () {0x4;}' unless defined(&AUDIT_AT_EXIT);
    eval 'sub AUDIT_PREPEND () {0x10;}' unless defined(&AUDIT_PREPEND);
    eval 'sub AUDIT_NEVER () {0;}' unless defined(&AUDIT_NEVER);
    eval 'sub AUDIT_POSSIBLE () {1;}' unless defined(&AUDIT_POSSIBLE);
    eval 'sub AUDIT_ALWAYS () {2;}' unless defined(&AUDIT_ALWAYS);
    eval 'sub AUDIT_MAX_FIELDS () {64;}' unless defined(&AUDIT_MAX_FIELDS);
    eval 'sub AUDIT_BITMASK_SIZE () {64;}' unless defined(&AUDIT_BITMASK_SIZE);
    eval 'sub AUDIT_WORD {
        my($nr) = @_;
	    eval q((( &__u32)(($nr)/32)));
    }' unless defined(&AUDIT_WORD);
    eval 'sub AUDIT_BIT {
        my($nr) = @_;
	    eval q((1<< (($nr) -  &AUDIT_WORD($nr)*32)));
    }' unless defined(&AUDIT_BIT);
    eval 'sub AUDIT_PID () {0;}' unless defined(&AUDIT_PID);
    eval 'sub AUDIT_UID () {1;}' unless defined(&AUDIT_UID);
    eval 'sub AUDIT_EUID () {2;}' unless defined(&AUDIT_EUID);
    eval 'sub AUDIT_SUID () {3;}' unless defined(&AUDIT_SUID);
    eval 'sub AUDIT_FSUID () {4;}' unless defined(&AUDIT_FSUID);
    eval 'sub AUDIT_GID () {5;}' unless defined(&AUDIT_GID);
    eval 'sub AUDIT_EGID () {6;}' unless defined(&AUDIT_EGID);
    eval 'sub AUDIT_SGID () {7;}' unless defined(&AUDIT_SGID);
    eval 'sub AUDIT_FSGID () {8;}' unless defined(&AUDIT_FSGID);
    eval 'sub AUDIT_LOGINUID () {9;}' unless defined(&AUDIT_LOGINUID);
    eval 'sub AUDIT_PERS () {10;}' unless defined(&AUDIT_PERS);
    eval 'sub AUDIT_DEVMAJOR () {100;}' unless defined(&AUDIT_DEVMAJOR);
    eval 'sub AUDIT_DEVMINOR () {101;}' unless defined(&AUDIT_DEVMINOR);
    eval 'sub AUDIT_INODE () {102;}' unless defined(&AUDIT_INODE);
    eval 'sub AUDIT_EXIT () {103;}' unless defined(&AUDIT_EXIT);
    eval 'sub AUDIT_SUCCESS () {104;}' unless defined(&AUDIT_SUCCESS);
    eval 'sub AUDIT_ARG0 () {200;}' unless defined(&AUDIT_ARG0);
    eval 'sub AUDIT_ARG1 () {( &AUDIT_ARG0+1);}' unless defined(&AUDIT_ARG1);
    eval 'sub AUDIT_ARG2 () {( &AUDIT_ARG0+2);}' unless defined(&AUDIT_ARG2);
    eval 'sub AUDIT_ARG3 () {( &AUDIT_ARG0+3);}' unless defined(&AUDIT_ARG3);
    eval 'sub AUDIT_NEGATE () {0x80000000;}' unless defined(&AUDIT_NEGATE);
    eval 'sub AUDIT_STATUS_ENABLED () {0x1;}' unless defined(&AUDIT_STATUS_ENABLED);
    eval 'sub AUDIT_STATUS_FAILURE () {0x2;}' unless defined(&AUDIT_STATUS_FAILURE);
    eval 'sub AUDIT_STATUS_PID () {0x4;}' unless defined(&AUDIT_STATUS_PID);
    eval 'sub AUDIT_STATUS_RATE_LIMIT () {0x8;}' unless defined(&AUDIT_STATUS_RATE_LIMIT);
    eval 'sub AUDIT_STATUS_BACKLOG_LIMIT () {0x10;}' unless defined(&AUDIT_STATUS_BACKLOG_LIMIT);
    eval 'sub AUDIT_FAIL_SILENT () {0;}' unless defined(&AUDIT_FAIL_SILENT);
    eval 'sub AUDIT_FAIL_PRINTK () {1;}' unless defined(&AUDIT_FAIL_PRINTK);
    eval 'sub AUDIT_FAIL_PANIC () {2;}' unless defined(&AUDIT_FAIL_PANIC);
    unless(defined(&__KERNEL__)) {
	require 'linux/netlink.ph';
    }
    if(defined(&__KERNEL__)) {
	if(defined(&CONFIG_AUDIT)) {
	}
	if(defined(&CONFIG_AUDITSYSCALL)) {
	} else {
	    eval 'sub audit_alloc {
	        my($t) = @_;
    		eval q(({ 0; }));
	    }' unless defined(&audit_alloc);
	    eval 'sub audit_free {
	        my($t) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_free);
	    eval 'sub audit_syscall_entry {
	        my($t,$a,$b,$c,$d,$e) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_syscall_entry);
	    eval 'sub audit_syscall_exit {
	        my($t,$r) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_syscall_exit);
	    eval 'sub audit_getname {
	        my($n) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_getname);
	    eval 'sub audit_putname {
	        my($n) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_putname);
	    eval 'sub audit_inode {
	        my($n,$i,$d) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_inode);
	    eval 'sub audit_get_loginuid {
	        my($c) = @_;
    		eval q(({ -1; }));
	    }' unless defined(&audit_get_loginuid);
	}
	if(defined(&CONFIG_AUDIT)) {
	} else {
	    eval 'sub audit_log () {( &t, &f,...)  &do { ; }  &while (0);}' unless defined(&audit_log);
	    eval 'sub audit_log_start {
	        my($t) = @_;
    		eval q(({  &NULL; }));
	    }' unless defined(&audit_log_start);
	    eval 'sub audit_log_vformat {
	        my($b,$f,$a) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_log_vformat);
	    eval 'sub audit_log_format () {( &b, &f,...)  &do { ; }  &while (0);}' unless defined(&audit_log_format);
	    eval 'sub audit_log_end {
	        my($b) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_log_end);
	    eval 'sub audit_log_end_fast {
	        my($b) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_log_end_fast);
	    eval 'sub audit_log_end_irq {
	        my($b) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_log_end_irq);
	    eval 'sub audit_log_d_path {
	        my($b,$p,$d,$v) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_log_d_path);
	    eval 'sub audit_set_rate_limit {
	        my($l) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_set_rate_limit);
	    eval 'sub audit_set_backlog_limit {
	        my($l) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_set_backlog_limit);
	    eval 'sub audit_set_enabled {
	        my($s) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_set_enabled);
	    eval 'sub audit_set_failure {
	        my($s) = @_;
    		eval q( &do { ; }  &while (0));
	    }' unless defined(&audit_set_failure);
	}
    }
}
1;
