require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_LIBATA_H__)) {
    eval 'sub __LINUX_LIBATA_H__ () {1;}' unless defined(&__LINUX_LIBATA_H__);
    require 'linux/delay.ph';
    require 'linux/interrupt.ph';
    require 'linux/pci.ph';
    require 'asm/io.ph';
    require 'linux/ata.ph';
    require 'linux/workqueue.ph';
    undef(&ATA_DEBUG) if defined(&ATA_DEBUG);
    undef(&ATA_VERBOSE_DEBUG) if defined(&ATA_VERBOSE_DEBUG);
    undef(&ATA_IRQ_TRAP) if defined(&ATA_IRQ_TRAP);
    undef(&ATA_NDEBUG) if defined(&ATA_NDEBUG);
    undef(&ATA_ENABLE_ATAPI) if defined(&ATA_ENABLE_ATAPI);
    undef(&ATA_ENABLE_PATA) if defined(&ATA_ENABLE_PATA);
    undef(&ATAPI_ENABLE_DMADIR) if defined(&ATAPI_ENABLE_DMADIR);
    if(defined(&ATA_DEBUG)) {
	eval 'sub DPRINTK () {( &fmt,  &args...)  &printk( &KERN_ERR "%s: "  &fmt,  &__FUNCTION__,   &args);}' unless defined(&DPRINTK);
	if(defined(&ATA_VERBOSE_DEBUG)) {
	    eval 'sub VPRINTK () {( &fmt,  &args...)  &printk( &KERN_ERR "%s: "  &fmt,  &__FUNCTION__,   &args);}' unless defined(&VPRINTK);
	} else {
	    eval 'sub VPRINTK () {( &fmt,  &args...);}' unless defined(&VPRINTK);
	}
    } else {
	eval 'sub DPRINTK () {( &fmt,  &args...);}' unless defined(&DPRINTK);
	eval 'sub VPRINTK () {( &fmt,  &args...);}' unless defined(&VPRINTK);
    }
    if(defined(&ATA_NDEBUG)) {
	eval 'sub assert {
	    my($expr) = @_;
    	    eval q();
	}' unless defined(&assert);
    } else {
	eval 'sub assert {
	    my($expr) = @_;
    	    eval q( &if( &unlikely(!($expr))) {  &printk( &KERN_ERR \\"Assertion failed! %s,%s,%s,line=%d\\\\n\\", $expr, &__FILE__, &__FUNCTION__, &__LINE__); });
	}' unless defined(&assert);
    }
    eval 'sub ATA_TAG_POISON () {0xfafbfcfd;}' unless defined(&ATA_TAG_POISON);
    eval("sub LIBATA_MAX_PRD () { ATA_MAX_PRD/2; }") unless defined(&LIBATA_MAX_PRD);
    eval("sub ATA_MAX_PORTS () { 8; }") unless defined(&ATA_MAX_PORTS);
    eval("sub ATA_DEF_QUEUE () { 1; }") unless defined(&ATA_DEF_QUEUE);
    eval("sub ATA_MAX_QUEUE () { 1; }") unless defined(&ATA_MAX_QUEUE);
    eval("sub ATA_MAX_SECTORS () { 200; }") unless defined(&ATA_MAX_SECTORS);
    eval("sub ATA_MAX_BUS () { 2; }") unless defined(&ATA_MAX_BUS);
    eval("sub ATA_DEF_BUSY_WAIT () { 10000; }") unless defined(&ATA_DEF_BUSY_WAIT);
    eval("sub ATA_SHORT_PAUSE () { (HZ>>6)+1; }") unless defined(&ATA_SHORT_PAUSE);
    eval("sub ATA_SHT_EMULATED () { 1; }") unless defined(&ATA_SHT_EMULATED);
    eval("sub ATA_SHT_CMD_PER_LUN () { 1; }") unless defined(&ATA_SHT_CMD_PER_LUN);
    eval("sub ATA_SHT_THIS_ID () { -1; }") unless defined(&ATA_SHT_THIS_ID);
    eval("sub ATA_SHT_USE_CLUSTERING () { 0; }") unless defined(&ATA_SHT_USE_CLUSTERING);
    eval("sub ATA_DFLAG_LBA48 () { (1<<0); }") unless defined(&ATA_DFLAG_LBA48);
    eval("sub ATA_DFLAG_PIO () { (1<<1); }") unless defined(&ATA_DFLAG_PIO);
    eval("sub ATA_DFLAG_LOCK_SECTORS () { (1<<2); }") unless defined(&ATA_DFLAG_LOCK_SECTORS);
    eval("sub ATA_DEV_UNKNOWN () { 0; }") unless defined(&ATA_DEV_UNKNOWN);
    eval("sub ATA_DEV_ATA () { 1; }") unless defined(&ATA_DEV_ATA);
    eval("sub ATA_DEV_ATA_UNSUP () { 2; }") unless defined(&ATA_DEV_ATA_UNSUP);
    eval("sub ATA_DEV_ATAPI () { 3; }") unless defined(&ATA_DEV_ATAPI);
    eval("sub ATA_DEV_ATAPI_UNSUP () { 4; }") unless defined(&ATA_DEV_ATAPI_UNSUP);
    eval("sub ATA_DEV_NONE () { 5; }") unless defined(&ATA_DEV_NONE);
    eval("sub ATA_FLAG_SLAVE_POSS () { (1<<1); }") unless defined(&ATA_FLAG_SLAVE_POSS);
    eval("sub ATA_FLAG_PORT_DISABLED () { (1<<2); }") unless defined(&ATA_FLAG_PORT_DISABLED);
    eval("sub ATA_FLAG_SATA () { (1<<3); }") unless defined(&ATA_FLAG_SATA);
    eval("sub ATA_FLAG_NO_LEGACY () { (1<<4); }") unless defined(&ATA_FLAG_NO_LEGACY);
    eval("sub ATA_FLAG_SRST () { (1<<5); }") unless defined(&ATA_FLAG_SRST);
    eval("sub ATA_FLAG_MMIO () { (1<<6); }") unless defined(&ATA_FLAG_MMIO);
    eval("sub ATA_FLAG_SATA_RESET () { (1<<7); }") unless defined(&ATA_FLAG_SATA_RESET);
    eval("sub ATA_FLAG_PIO_DMA () { (1<<8); }") unless defined(&ATA_FLAG_PIO_DMA);
    eval("sub ATA_QCFLAG_ACTIVE () { (1<<1); }") unless defined(&ATA_QCFLAG_ACTIVE);
    eval("sub ATA_QCFLAG_SG () { (1<<3); }") unless defined(&ATA_QCFLAG_SG);
    eval("sub ATA_QCFLAG_SINGLE () { (1<<4); }") unless defined(&ATA_QCFLAG_SINGLE);
    eval("sub ATA_QCFLAG_DMAMAP () { ATA_QCFLAG_SG|ATA_QCFLAG_SINGLE; }") unless defined(&ATA_QCFLAG_DMAMAP);
    eval("sub ATA_TMOUT_EDD () { 5*HZ; }") unless defined(&ATA_TMOUT_EDD);
    eval("sub ATA_TMOUT_PIO () { 30*HZ; }") unless defined(&ATA_TMOUT_PIO);
    eval("sub ATA_TMOUT_BOOT () { 30*HZ; }") unless defined(&ATA_TMOUT_BOOT);
    eval("sub ATA_TMOUT_BOOT_QUICK () { 7*HZ; }") unless defined(&ATA_TMOUT_BOOT_QUICK);
    eval("sub ATA_TMOUT_CDB () { 30*HZ; }") unless defined(&ATA_TMOUT_CDB);
    eval("sub ATA_TMOUT_CDB_QUICK () { 5*HZ; }") unless defined(&ATA_TMOUT_CDB_QUICK);
    eval("sub BUS_UNKNOWN () { 0; }") unless defined(&BUS_UNKNOWN);
    eval("sub BUS_DMA () { 1; }") unless defined(&BUS_DMA);
    eval("sub BUS_IDLE () { 2; }") unless defined(&BUS_IDLE);
    eval("sub BUS_NOINTR () { 3; }") unless defined(&BUS_NOINTR);
    eval("sub BUS_NODATA () { 4; }") unless defined(&BUS_NODATA);
    eval("sub BUS_TIMER () { 5; }") unless defined(&BUS_TIMER);
    eval("sub BUS_PIO () { 6; }") unless defined(&BUS_PIO);
    eval("sub BUS_EDD () { 7; }") unless defined(&BUS_EDD);
    eval("sub BUS_IDENTIFY () { 8; }") unless defined(&BUS_IDENTIFY);
    eval("sub BUS_PACKET () { 9; }") unless defined(&BUS_PACKET);
    eval("sub PORT_UNKNOWN () { 0; }") unless defined(&PORT_UNKNOWN);
    eval("sub PORT_ENABLED () { 1; }") unless defined(&PORT_ENABLED);
    eval("sub PORT_DISABLED () { 2; }") unless defined(&PORT_DISABLED);
    eval("sub ATA_SHIFT_UDMA () { 0; }") unless defined(&ATA_SHIFT_UDMA);
    eval("sub ATA_SHIFT_MWDMA () { 8; }") unless defined(&ATA_SHIFT_MWDMA);
    eval("sub ATA_SHIFT_PIO () { 11; }") unless defined(&ATA_SHIFT_PIO);
    eval("sub PIO_ST_UNKNOWN () { 0; }") unless defined(&PIO_ST_UNKNOWN);
    eval("sub PIO_ST_IDLE () { 1; }") unless defined(&PIO_ST_IDLE);
    eval("sub PIO_ST_POLL () { 2; }") unless defined(&PIO_ST_POLL);
    eval("sub PIO_ST_TMOUT () { 3; }") unless defined(&PIO_ST_TMOUT);
    eval("sub PIO_ST () { 4; }") unless defined(&PIO_ST);
    eval("sub PIO_ST_LAST () { 5; }") unless defined(&PIO_ST_LAST);
    eval("sub PIO_ST_LAST_POLL () { 6; }") unless defined(&PIO_ST_LAST_POLL);
    eval("sub PIO_ST_ERR () { 7; }") unless defined(&PIO_ST_ERR);
    if(defined(&CONFIG_PCI)) {
    }
    if(defined(&CONFIG_PCI)) {
    }
    eval 'sub ata_tag_valid {
        my($tag) = @_;
	    eval q({ ($tag <  &ATA_MAX_QUEUE) ? 1: 0; });
    }' unless defined(&ata_tag_valid);
    eval 'sub ata_dev_present {
        my($dev) = @_;
	    eval q({ (( ($dev->{class}) ==  &ATA_DEV_ATA) || ( ($dev->{class}) ==  &ATA_DEV_ATAPI)); });
    }' unless defined(&ata_dev_present);
    eval 'sub ata_chk_status {
        my($ap) = @_;
	    eval q({  ($ap->{ops}->{check_status})($ap); });
    }' unless defined(&ata_chk_status);
    eval 'sub ata_pause {
        my($ap) = @_;
	    eval q({  &ata_altstatus($ap);  &ndelay(400); });
    }' unless defined(&ata_pause);
    eval 'sub ata_busy_wait {
        my($ap,$bits,$max) = @_;
	    eval q({  &u8  &status;  &do {  &udelay(10);  &status =  &ata_chk_status($ap); $max--; }  &while (( &status & $bits)  && ($max > 0));  &status; });
    }' unless defined(&ata_busy_wait);
    eval 'sub ata_wait_idle {
        my($ap) = @_;
	    eval q({  &u8  &status =  &ata_busy_wait($ap,  &ATA_BUSY |  &ATA_DRQ, 1000);  &if ( &status & ( &ATA_BUSY |  &ATA_DRQ)) { my $l =  ($ap->{ioaddr}->{status_addr});  &printk( &KERN_WARNING \\"ATA: abnormal status 0x%X on port 0x%lX\\\\n\\",  &status,  $l); }  &status; });
    }' unless defined(&ata_wait_idle);
    eval 'sub ata_qc_set_polling {
        my($qc) = @_;
	    eval q({  ($qc->{tf}->{ctl}) |=  &ATA_NIEN; });
    }' unless defined(&ata_qc_set_polling);
    eval 'sub ata_queued_cmd {
        eval q(* &ata_qc_from_tag (\'struct ata_port\' * &ap, my $tag) {  &if ( &likely( &ata_tag_valid( $tag)))  ($ap->{qcmd[$tag]});  &NULL; });
    }' unless defined(&ata_queued_cmd);
    eval 'sub ata_tf_init {
        my($ap,$tf,$device) = @_;
	    eval q({  &memset($tf, 0, $sizeof{$tf});  ($tf->{ctl}) =  ($ap->{ctl});  &if ($device == 0)  ($tf->{device}) =  &ATA_DEVICE_OBS;  &else  ($tf->{device}) =  &ATA_DEVICE_OBS |  &ATA_DEV1; });
    }' unless defined(&ata_tf_init);
    eval 'sub ata_irq_on {
        my($ap) = @_;
	    eval q({ \'struct ata_ioports\' * &ioaddr =  ($ap->{ioaddr});  &u8  &tmp;  ($ap->{ctl}) &= ~ &ATA_NIEN;  ($ap->{last_ctl}) =  ($ap->{ctl});  &if ( ($ap->{flags}) &  &ATA_FLAG_MMIO)  &writeb( ($ap->{ctl}), ( &void  &__iomem *)  ($ioaddr->{ctl_addr}));  &else  &outb( ($ap->{ctl}),  ($ioaddr->{ctl_addr}));  &tmp =  &ata_wait_idle($ap);  ($ap->{ops}->{irq_clear})($ap);  &tmp; });
    }' unless defined(&ata_irq_on);
    eval 'sub ata_irq_ack {
        my($ap,$chk_drq) = @_;
	    eval q({ my $bits = $chk_drq ?  &ATA_BUSY |  &ATA_DRQ :  &ATA_BUSY;  &u8  &host_stat,  &post_stat,  &status;  &status =  &ata_busy_wait($ap,  $bits, 1000);  &if ( &status &  $bits)  &DPRINTK(\\"abnormal status 0x%X\\\\n\\",  &status);  &if ( ($ap->{flags}) &  &ATA_FLAG_MMIO) {  &void  &__iomem * &mmio = ( &void  &__iomem *)  ($ap->{ioaddr}->{bmdma_addr});  &host_stat =  &readb( &mmio +  &ATA_DMA_STATUS);  &writeb( &host_stat |  &ATA_DMA_INTR |  &ATA_DMA_ERR,  &mmio +  &ATA_DMA_STATUS);  &post_stat =  &readb( &mmio +  &ATA_DMA_STATUS); }  &else {  &host_stat =  &inb( ($ap->{ioaddr}->{bmdma_addr}) +  &ATA_DMA_STATUS);  &outb( &host_stat |  &ATA_DMA_INTR |  &ATA_DMA_ERR,  ($ap->{ioaddr}->{bmdma_addr}) +  &ATA_DMA_STATUS);  &post_stat =  &inb( ($ap->{ioaddr}->{bmdma_addr}) +  &ATA_DMA_STATUS); }  &VPRINTK(\\"irq ack: host_stat 0x%X, new host_stat 0x%X, drv_stat 0x%X\\\\n\\",  &host_stat,  &post_stat,  &status);  &status; });
    }' unless defined(&ata_irq_ack);
    eval 'sub scr_read {
        my($ap,$reg) = @_;
	    eval q({  ($ap->{ops}->{scr_read})($ap, $reg); });
    }' unless defined(&scr_read);
    eval 'sub scr_write {
        my($ap,$reg,$val) = @_;
	    eval q({  ($ap->{ops}->{scr_write})($ap, $reg, $val); });
    }' unless defined(&scr_write);
    eval 'sub sata_dev_present {
        my($ap) = @_;
	    eval q({ (( &scr_read($ap,  &SCR_STATUS) & 0xf) == 0x3) ? 1: 0; });
    }' unless defined(&sata_dev_present);
    eval 'sub ata_try_flush_cache {
        my($dev) = @_;
	    eval q({  &ata_id_wcache_enabled( ($dev->{id})) ||  &ata_id_has_flush( ($dev->{id})) ||  &ata_id_has_flush_ext( ($dev->{id})); });
    }' unless defined(&ata_try_flush_cache);
}
1;
