require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ISOFS_FS_H)) {
    eval 'sub _ISOFS_FS_H () {1;}' unless defined(&_ISOFS_FS_H);
    require 'linux/types.ph';
    eval 'sub ISODCL {
        my($from, $to) = @_;
	    eval q(($to - $from + 1));
    }' unless defined(&ISODCL);
    eval 'sub ISO_VD_PRIMARY () {1;}' unless defined(&ISO_VD_PRIMARY);
    eval 'sub ISO_VD_SUPPLEMENTARY () {2;}' unless defined(&ISO_VD_SUPPLEMENTARY);
    eval 'sub ISO_VD_END () {255;}' unless defined(&ISO_VD_END);
    eval 'sub ISO_STANDARD_ID () {"CD001";}' unless defined(&ISO_STANDARD_ID);
    eval 'sub HS_STANDARD_ID () {"CDROM";}' unless defined(&HS_STANDARD_ID);
    eval 'sub ISOFS_BLOCK_BITS () {11;}' unless defined(&ISOFS_BLOCK_BITS);
    eval 'sub ISOFS_BLOCK_SIZE () {2048;}' unless defined(&ISOFS_BLOCK_SIZE);
    eval 'sub ISOFS_BUFFER_SIZE {
        my($INODE) = @_;
	    eval q((($INODE)-> ($i_sb->{s_blocksize})));
    }' unless defined(&ISOFS_BUFFER_SIZE);
    eval 'sub ISOFS_BUFFER_BITS {
        my($INODE) = @_;
	    eval q((($INODE)-> ($i_sb->{s_blocksize_bits})));
    }' unless defined(&ISOFS_BUFFER_BITS);
    eval 'sub ISOFS_SUPER_MAGIC () {0x9660;}' unless defined(&ISOFS_SUPER_MAGIC);
    if(defined(&__KERNEL__)) {
	require 'asm/byteorder.ph';
	require 'asm/unaligned.ph';
	require 'linux/iso_fs_i.ph';
	require 'linux/iso_fs_sb.ph';
	eval 'sub isofs_sb_info {
	    eval q(* &ISOFS_SB(\'struct super_block\' * &sb) {  ($sb->{s_fs_info}); });
	}' unless defined(&isofs_sb_info);
	eval 'sub iso_inode_info {
	    eval q(* &ISOFS_I(\'struct inode\' * &inode) {  &container_of( &inode, \'struct iso_inode_info\',  &vfs_inode); });
	}' unless defined(&iso_inode_info);
	eval 'sub isonum_711 {
	    my($p) = @_;
    	    eval q({ *( &u8 *)$p; });
	}' unless defined(&isonum_711);
	eval 'sub isonum_712 {
	    my($p) = @_;
    	    eval q({ *( &s8 *)$p; });
	}' unless defined(&isonum_712);
	eval 'sub isonum_721 {
	    my($p) = @_;
    	    eval q({  &le16_to_cpu( &get_unaligned(( &__le16 *)$p)); });
	}' unless defined(&isonum_721);
	eval 'sub isonum_722 {
	    my($p) = @_;
    	    eval q({  &be16_to_cpu( &get_unaligned(( &__le16 *)$p)); });
	}' unless defined(&isonum_722);
	eval 'sub isonum_723 {
	    my($p) = @_;
    	    eval q({  &le16_to_cpu( &get_unaligned(( &__le16 *)$p)); });
	}' unless defined(&isonum_723);
	eval 'sub isonum_731 {
	    my($p) = @_;
    	    eval q({  &le32_to_cpu( &get_unaligned(( &__le32 *)$p)); });
	}' unless defined(&isonum_731);
	eval 'sub isonum_732 {
	    my($p) = @_;
    	    eval q({  &be32_to_cpu( &get_unaligned(( &__le32 *)$p)); });
	}' unless defined(&isonum_732);
	eval 'sub isonum_733 {
	    my($p) = @_;
    	    eval q({  &le32_to_cpu( &get_unaligned(( &__le32 *)$p)); });
	}' unless defined(&isonum_733);
	if(defined(&LEAK_CHECK)) {
	    eval 'sub free_s () { &leak_check_free_s;}' unless defined(&free_s);
	    eval 'sub malloc () { &leak_check_malloc;}' unless defined(&malloc);
	    eval 'sub sb_bread () { &leak_check_bread;}' unless defined(&sb_bread);
	    eval 'sub brelse () { &leak_check_brelse;}' unless defined(&brelse);
	}
    }
}
1;
