require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_LINUX_HUGETLB_H)) {
    eval 'sub _LINUX_HUGETLB_H () {1;}' unless defined(&_LINUX_HUGETLB_H);
    if(defined(&CONFIG_HUGETLB_PAGE)) {
	require 'linux/mempolicy.ph';
	eval 'sub is_vm_hugetlb_page {
	    my($vma) = @_;
    	    eval q({  ($vma->{vm_flags}) &  &VM_HUGETLB; });
	}' unless defined(&is_vm_hugetlb_page);
	unless(defined(&ARCH_HAS_HUGEPAGE_ONLY_RANGE)) {
	    eval 'sub is_hugepage_only_range {
	        my($addr, $len) = @_;
    		eval q(0);
	    }' unless defined(&is_hugepage_only_range);
	    eval 'sub hugetlb_free_pgtables {
	        my($tlb, $prev, $start, $end) = @_;
    		eval q( &do { }  &while (0));
	    }' unless defined(&hugetlb_free_pgtables);
	}
	unless(defined(&ARCH_HAS_PREPARE_HUGEPAGE_RANGE)) {
	    eval 'sub prepare_hugepage_range {
	        my($addr, $len) = @_;
    		eval q( &is_aligned_hugepage_range($addr, $len));
	    }' unless defined(&prepare_hugepage_range);
	} else {
	}
    } else {
	eval 'sub is_vm_hugetlb_page {
	    my($vma) = @_;
    	    eval q({ 0; });
	}' unless defined(&is_vm_hugetlb_page);
	eval 'sub hugetlb_total_pages {
	    my($void) = @_;
    	    eval q({ 0; });
	}' unless defined(&hugetlb_total_pages);
	eval 'sub follow_hugetlb_page {
	    my($m,$v,$p,$vs,$a,$b,$i) = @_;
    	    eval q(({  &BUG(); 0; }));
	}' unless defined(&follow_hugetlb_page);
	eval 'sub follow_huge_addr {
	    my($mm, $addr, $write) = @_;
    	    eval q( &ERR_PTR(- &EINVAL));
	}' unless defined(&follow_huge_addr);
	eval 'sub copy_hugetlb_page_range {
	    my($src, $dst, $vma) = @_;
    	    eval q(({  &BUG(); 0; }));
	}' unless defined(&copy_hugetlb_page_range);
	eval 'sub hugetlb_prefault {
	    my($mapping, $vma) = @_;
    	    eval q(({  &BUG(); 0; }));
	}' unless defined(&hugetlb_prefault);
	eval 'sub zap_hugepage_range {
	    my($vma, $start, $len) = @_;
    	    eval q( &BUG());
	}' unless defined(&zap_hugepage_range);
	eval 'sub unmap_hugepage_range {
	    my($vma, $start, $end) = @_;
    	    eval q( &BUG());
	}' unless defined(&unmap_hugepage_range);
	eval 'sub is_hugepage_mem_enough {
	    my($size) = @_;
    	    eval q(0);
	}' unless defined(&is_hugepage_mem_enough);
	eval 'sub hugetlb_report_meminfo {
	    my($buf) = @_;
    	    eval q(0);
	}' unless defined(&hugetlb_report_meminfo);
	eval 'sub hugetlb_report_node_meminfo {
	    my($n, $buf) = @_;
    	    eval q(0);
	}' unless defined(&hugetlb_report_node_meminfo);
	eval 'sub follow_huge_pmd {
	    my($mm, $addr, $pmd, $write) = @_;
    	    eval q( &NULL);
	}' unless defined(&follow_huge_pmd);
	eval 'sub is_aligned_hugepage_range {
	    my($addr, $len) = @_;
    	    eval q(0);
	}' unless defined(&is_aligned_hugepage_range);
	eval 'sub prepare_hugepage_range {
	    my($addr, $len) = @_;
    	    eval q((- &EINVAL));
	}' unless defined(&prepare_hugepage_range);
	eval 'sub pmd_huge {
	    my($x) = @_;
    	    eval q(0);
	}' unless defined(&pmd_huge);
	eval 'sub is_hugepage_only_range {
	    my($addr, $len) = @_;
    	    eval q(0);
	}' unless defined(&is_hugepage_only_range);
	eval 'sub hugetlb_free_pgtables {
	    my($tlb, $prev, $start, $end) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&hugetlb_free_pgtables);
	eval 'sub alloc_huge_page () {
	    eval q(({  &NULL; }));
	}' unless defined(&alloc_huge_page);
	eval 'sub free_huge_page {
	    my($p) = @_;
    	    eval q(({ ( &void)($p);  &BUG(); }));
	}' unless defined(&free_huge_page);
	unless(defined(&HPAGE_MASK)) {
	    eval 'sub HPAGE_MASK () {0;}' unless defined(&HPAGE_MASK);
	    eval 'sub HPAGE_SIZE () {0;}' unless defined(&HPAGE_SIZE);
	}
    }
    if(defined(&CONFIG_HUGETLBFS)) {
	eval 'sub hugetlbfs_inode_info {
	    eval q(* &HUGETLBFS_I(\'struct inode\' * &inode) {  &container_of( &inode, \'struct hugetlbfs_inode_info\',  &vfs_inode); });
	}' unless defined(&hugetlbfs_inode_info);
	eval 'sub hugetlbfs_sb_info {
	    eval q(* &HUGETLBFS_SB(\'struct super_block\' * &sb) {  ($sb->{s_fs_info}); });
	}' unless defined(&hugetlbfs_sb_info);
	eval 'sub is_file_hugepages {
	    my($file) = @_;
    	    eval q({  ($file->{f_op}) ==  &hugetlbfs_file_operations; });
	}' unless defined(&is_file_hugepages);
	eval 'sub set_file_hugepages {
	    my($file) = @_;
    	    eval q({  ($file->{f_op}) =  &hugetlbfs_file_operations; });
	}' unless defined(&set_file_hugepages);
    } else {
	eval 'sub is_file_hugepages {
	    my($file) = @_;
    	    eval q(0);
	}' unless defined(&is_file_hugepages);
	eval 'sub set_file_hugepages {
	    my($file) = @_;
    	    eval q( &BUG());
	}' unless defined(&set_file_hugepages);
	eval 'sub hugetlb_zero_setup {
	    my($size) = @_;
    	    eval q( &ERR_PTR(- &ENOSYS));
	}' unless defined(&hugetlb_zero_setup);
    }
}
1;
