require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_FTAPE_H)) {
    eval 'sub _FTAPE_H () {1;}' unless defined(&_FTAPE_H);
    eval 'sub FTAPE_VERSION () {"ftape v3.04d 25/11/97";}' unless defined(&FTAPE_VERSION);
    if(defined(&__KERNEL__)) {
	require 'linux/interrupt.ph';
	require 'linux/mm.ph';
    }
    require 'linux/types.ph';
    require 'linux/config.ph';
    require 'linux/mtio.ph';
    eval 'sub FT_SECTOR {
        my($x) = @_;
	    eval q(($x+1));
    }' unless defined(&FT_SECTOR);
    eval 'sub FT_SECTOR_SIZE () {1024;}' unless defined(&FT_SECTOR_SIZE);
    eval 'sub FT_SECTORS_PER_SEGMENT () {32;}' unless defined(&FT_SECTORS_PER_SEGMENT);
    eval 'sub FT_ECC_SECTORS () {3;}' unless defined(&FT_ECC_SECTORS);
    eval 'sub FT_SEGMENT_SIZE () {(( &FT_SECTORS_PER_SEGMENT -  &FT_ECC_SECTORS) *  &FT_SECTOR_SIZE);}' unless defined(&FT_SEGMENT_SIZE);
    eval 'sub FT_BUFF_SIZE () {( &FT_SECTORS_PER_SEGMENT *  &FT_SECTOR_SIZE);}' unless defined(&FT_BUFF_SIZE);
    eval 'sub FTAPE_SEL_A () {0;}' unless defined(&FTAPE_SEL_A);
    eval 'sub FTAPE_SEL_B () {1;}' unless defined(&FTAPE_SEL_B);
    eval 'sub FTAPE_SEL_C () {2;}' unless defined(&FTAPE_SEL_C);
    eval 'sub FTAPE_SEL_D () {3;}' unless defined(&FTAPE_SEL_D);
    eval 'sub FTAPE_SEL_MASK () {3;}' unless defined(&FTAPE_SEL_MASK);
    eval 'sub FTAPE_SEL {
        my($unit) = @_;
	    eval q((($unit) &  &FTAPE_SEL_MASK));
    }' unless defined(&FTAPE_SEL);
    eval 'sub FTAPE_NO_REWIND () {4;}' unless defined(&FTAPE_NO_REWIND);
    if(defined(&__KERNEL__)) {
	eval 'sub FT_RQM_DELAY () {12;}' unless defined(&FT_RQM_DELAY);
	eval 'sub FT_MILLISECOND () {1;}' unless defined(&FT_MILLISECOND);
	eval 'sub FT_SECOND () {1000;}' unless defined(&FT_SECOND);
	eval 'sub FT_FOREVER () {-1;}' unless defined(&FT_FOREVER);
	unless(defined(&HZ)) {
	    die("HZ undefined.");
	}
	eval 'sub FT_USPT () {(1000000/ &HZ);}' unless defined(&FT_USPT);
	if(defined(&TESTING)) {
	    eval 'sub FT_SOFT_RETRIES () {1;}' unless defined(&FT_SOFT_RETRIES);
	    eval 'sub FT_RETRIES_ON_ECC_ERROR () {3;}' unless defined(&FT_RETRIES_ON_ECC_ERROR);
	} else {
	    eval 'sub FT_SOFT_RETRIES () {6;}' unless defined(&FT_SOFT_RETRIES);
	    eval 'sub FT_RETRIES_ON_ECC_ERROR () {3;}' unless defined(&FT_RETRIES_ON_ECC_ERROR);
	}
	unless(defined(&THE_FTAPE_MAINTAINER)) {
	    eval 'sub THE_FTAPE_MAINTAINER () {"the ftape maintainer";}' unless defined(&THE_FTAPE_MAINTAINER);
	}
	unless(defined(&CONFIG_FT_NR_BUFFERS)) {
	    eval 'sub CONFIG_FT_NR_BUFFERS () {3;}' unless defined(&CONFIG_FT_NR_BUFFERS);
	}
	unless(defined(&CONFIG_FT_FDC_THR)) {
	    eval 'sub CONFIG_FT_FDC_THR () {8;}' unless defined(&CONFIG_FT_FDC_THR);
	}
	unless(defined(&CONFIG_FT_FDC_MAX_RATE)) {
	    eval 'sub CONFIG_FT_FDC_MAX_RATE () {2000;}' unless defined(&CONFIG_FT_FDC_MAX_RATE);
	}
	unless(defined(&CONFIG_FT_FDC_BASE)) {
	    eval 'sub CONFIG_FT_FDC_BASE () {0;}' unless defined(&CONFIG_FT_FDC_BASE);
	}
	unless(defined(&CONFIG_FT_FDC_IRQ)) {
	    eval 'sub CONFIG_FT_FDC_IRQ () {0;}' unless defined(&CONFIG_FT_FDC_IRQ);
	}
	unless(defined(&CONFIG_FT_FDC_DMA)) {
	    eval 'sub CONFIG_FT_FDC_DMA () {0;}' unless defined(&CONFIG_FT_FDC_DMA);
	}
	if(defined(&CONFIG_FT_PROBE_FC10)) {
	    undef(&CONFIG_FT_PROBE_FC10) if defined(&CONFIG_FT_PROBE_FC10);
	    eval 'sub CONFIG_FT_PROBE_FC10 () {1;}' unless defined(&CONFIG_FT_PROBE_FC10);
	} else {
	    eval 'sub CONFIG_FT_PROBE_FC10 () {0;}' unless defined(&CONFIG_FT_PROBE_FC10);
	}
	if(defined(&CONFIG_FT_MACH2)) {
	    undef(&CONFIG_FT_MACH2) if defined(&CONFIG_FT_MACH2);
	    eval 'sub CONFIG_FT_MACH2 () {1;}' unless defined(&CONFIG_FT_MACH2);
	} else {
	    eval 'sub CONFIG_FT_MACH2 () {0;}' unless defined(&CONFIG_FT_MACH2);
	}
	if((defined(&CONFIG_FT_PROBE_FC10) ? &CONFIG_FT_PROBE_FC10 : 0) == 1) {
	    if((defined(&CONFIG_FT_FDC_BASE) ? &CONFIG_FT_FDC_BASE : 0) == 0) {
		undef(&CONFIG_FT_FDC_BASE) if defined(&CONFIG_FT_FDC_BASE);
		eval 'sub CONFIG_FT_FDC_BASE () {0x180;}' unless defined(&CONFIG_FT_FDC_BASE);
	    }
	    if((defined(&CONFIG_FT_FDC_IRQ) ? &CONFIG_FT_FDC_IRQ : 0) == 0) {
		undef(&CONFIG_FT_FDC_IRQ) if defined(&CONFIG_FT_FDC_IRQ);
		eval 'sub CONFIG_FT_FDC_IRQ () {9;}' unless defined(&CONFIG_FT_FDC_IRQ);
	    }
	    if((defined(&CONFIG_FT_FDC_DMA) ? &CONFIG_FT_FDC_DMA : 0) == 0) {
		undef(&CONFIG_FT_FDC_DMA) if defined(&CONFIG_FT_FDC_DMA);
		eval 'sub CONFIG_FT_FDC_DMA () {3;}' unless defined(&CONFIG_FT_FDC_DMA);
	    }
	}
 elsif((defined(&CONFIG_FT_MACH2) ? &CONFIG_FT_MACH2 : 0) == 1) {
	    if((defined(&CONFIG_FT_FDC_BASE) ? &CONFIG_FT_FDC_BASE : 0) == 0) {
		undef(&CONFIG_FT_FDC_BASE) if defined(&CONFIG_FT_FDC_BASE);
		eval 'sub CONFIG_FT_FDC_BASE () {0x1e0;}' unless defined(&CONFIG_FT_FDC_BASE);
	    }
	    if((defined(&CONFIG_FT_FDC_IRQ) ? &CONFIG_FT_FDC_IRQ : 0) == 0) {
		undef(&CONFIG_FT_FDC_IRQ) if defined(&CONFIG_FT_FDC_IRQ);
		eval 'sub CONFIG_FT_FDC_IRQ () {6;}' unless defined(&CONFIG_FT_FDC_IRQ);
	    }
	    if((defined(&CONFIG_FT_FDC_DMA) ? &CONFIG_FT_FDC_DMA : 0) == 0) {
		undef(&CONFIG_FT_FDC_DMA) if defined(&CONFIG_FT_FDC_DMA);
		eval 'sub CONFIG_FT_FDC_DMA () {2;}' unless defined(&CONFIG_FT_FDC_DMA);
	    }
	}
 elsif((defined(&CONFIG_FT_ALT_FDC) ? &CONFIG_FT_ALT_FDC : 0) == 1) {
	    if((defined(&CONFIG_FT_FDC_BASE) ? &CONFIG_FT_FDC_BASE : 0) == 0) {
		undef(&CONFIG_FT_FDC_BASE) if defined(&CONFIG_FT_FDC_BASE);
		eval 'sub CONFIG_FT_FDC_BASE () {0x370;}' unless defined(&CONFIG_FT_FDC_BASE);
	    }
	    if((defined(&CONFIG_FT_FDC_IRQ) ? &CONFIG_FT_FDC_IRQ : 0) == 0) {
		undef(&CONFIG_FT_FDC_IRQ) if defined(&CONFIG_FT_FDC_IRQ);
		eval 'sub CONFIG_FT_FDC_IRQ () {6;}' unless defined(&CONFIG_FT_FDC_IRQ);
	    }
	    if((defined(&CONFIG_FT_FDC_DMA) ? &CONFIG_FT_FDC_DMA : 0) == 0) {
		undef(&CONFIG_FT_FDC_DMA) if defined(&CONFIG_FT_FDC_DMA);
		eval 'sub CONFIG_FT_FDC_DMA () {2;}' unless defined(&CONFIG_FT_FDC_DMA);
	    }
	} else {
	    if((defined(&CONFIG_FT_FDC_BASE) ? &CONFIG_FT_FDC_BASE : 0) == 0) {
		undef(&CONFIG_FT_FDC_BASE) if defined(&CONFIG_FT_FDC_BASE);
		eval 'sub CONFIG_FT_FDC_BASE () {0x3f0;}' unless defined(&CONFIG_FT_FDC_BASE);
	    }
	    if((defined(&CONFIG_FT_FDC_IRQ) ? &CONFIG_FT_FDC_IRQ : 0) == 0) {
		undef(&CONFIG_FT_FDC_IRQ) if defined(&CONFIG_FT_FDC_IRQ);
		eval 'sub CONFIG_FT_FDC_IRQ () {6;}' unless defined(&CONFIG_FT_FDC_IRQ);
	    }
	    if((defined(&CONFIG_FT_FDC_DMA) ? &CONFIG_FT_FDC_DMA : 0) == 0) {
		undef(&CONFIG_FT_FDC_DMA) if defined(&CONFIG_FT_FDC_DMA);
		eval 'sub CONFIG_FT_FDC_DMA () {2;}' unless defined(&CONFIG_FT_FDC_DMA);
	    }
	}
	eval 'sub NR_ITEMS {
	    my($x) = @_;
    	    eval q(($sizeof{$x}/ $sizeof{$x}));
	}' unless defined(&NR_ITEMS);
    }
}
1;
