require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_COMPILER_H)) {
    eval 'sub __LINUX_COMPILER_H () {1;}' unless defined(&__LINUX_COMPILER_H);
    unless(defined(&__ASSEMBLY__)) {
	if(defined(&__CHECKER__)) {
	    eval 'sub __user () { &__attribute__(( &noderef,  &address_space(1)));}' unless defined(&__user);
	    eval 'sub __kernel () {1;}' unless defined(&__kernel);
	    eval 'sub __safe () { &__attribute__(( &safe));}' unless defined(&__safe);
	    eval 'sub __force () { &__attribute__(( &force));}' unless defined(&__force);
	    eval 'sub __iomem () { &__attribute__(( &noderef,  &address_space(2)));}' unless defined(&__iomem);
	    eval 'sub __acquires {
	        my($x) = @_;
    		eval q( &__attribute__(( &context(0,1))));
	    }' unless defined(&__acquires);
	    eval 'sub __releases {
	        my($x) = @_;
    		eval q( &__attribute__(( &context(1,0))));
	    }' unless defined(&__releases);
	    eval 'sub __acquire {
	        my($x) = @_;
    		eval q( &__context__(1));
	    }' unless defined(&__acquire);
	    eval 'sub __release {
	        my($x) = @_;
    		eval q( &__context__(-1));
	    }' unless defined(&__release);
	    eval 'sub __cond_lock {
	        my($x) = @_;
    		eval q((($x) ? ({  &__context__(1); 1; }) : 0));
	    }' unless defined(&__cond_lock);
	} else {
	    eval 'sub __user () {1;}' unless defined(&__user);
	    eval 'sub __kernel () {1;}' unless defined(&__kernel);
	    eval 'sub __safe () {1;}' unless defined(&__safe);
	    eval 'sub __force () {1;}' unless defined(&__force);
	    eval 'sub __iomem () {1;}' unless defined(&__iomem);
	    eval 'sub __chk_user_ptr {
	        my($x) = @_;
    		eval q(( &void)0);
	    }' unless defined(&__chk_user_ptr);
	    eval 'sub __chk_io_ptr {
	        my($x) = @_;
    		eval q(( &void)0);
	    }' unless defined(&__chk_io_ptr);
	    eval 'sub __builtin_warning () {( &x,  &y...) (1);}' unless defined(&__builtin_warning);
	    eval 'sub __acquires {
	        my($x) = @_;
    		eval q();
	    }' unless defined(&__acquires);
	    eval 'sub __releases {
	        my($x) = @_;
    		eval q();
	    }' unless defined(&__releases);
	    eval 'sub __acquire {
	        my($x) = @_;
    		eval q(( &void)0);
	    }' unless defined(&__acquire);
	    eval 'sub __release {
	        my($x) = @_;
    		eval q(( &void)0);
	    }' unless defined(&__release);
	    eval 'sub __cond_lock {
	        my($x) = @_;
    		eval q(($x));
	    }' unless defined(&__cond_lock);
	}
	if(((defined(&__GNUC__) ? &__GNUC__ : 0) > 3) || ((defined(&__GNUC__) ? &__GNUC__ : 0) == 3 && (defined(&__GNUC_MINOR__) ? &__GNUC_MINOR__ : 0) >= 1)) {
	    eval 'sub inline () { &__inline__;}' unless defined(&inline);
	    eval 'sub __inline__ () { &__inline__;}' unless defined(&__inline__);
	    eval 'sub __inline () { &__inline__;}' unless defined(&__inline);
	    unless(defined(&asm)) {
		eval 'sub asm () {"(assembly code)";}' unless defined(&asm);
	    }
	    unless(defined(&volatile)) {
		eval 'sub volatile () { &__volatile__;}' unless defined(&volatile);
	    }
	}
	if(defined(&__KERNEL__)) {
	    if((defined(&__GNUC__) ? &__GNUC__ : 0) > 3) {
		require 'linux/compiler-gcc+.ph';
	    }
 elsif((defined(&__GNUC__) ? &__GNUC__ : 0) == 3) {
		require 'linux/compiler-gcc3.ph';
	    }
 elsif((defined(&__GNUC__) ? &__GNUC__ : 0) == 2) {
		require 'linux/compiler-gcc2.ph';
	    } else {
		die("Sorry\,\ your\ compiler\ is\ too\ old\/not\ recognized\.");
	    }
	}
	if(defined(&__INTEL_COMPILER)) {
	    require 'linux/compiler-intel.ph';
	}
	eval 'sub likely {
	    my($x) = @_;
    	    eval q( &__builtin_expect(!!($x), 1));
	}' unless defined(&likely);
	eval 'sub unlikely {
	    my($x) = @_;
    	    eval q( &__builtin_expect(!!($x), 0));
	}' unless defined(&unlikely);
	unless(defined(&barrier)) {
	    if(defined(&mb)) {
		eval 'sub barrier () {
		    eval q( &mb());
		}' unless defined(&barrier);
	    } else {
		eval 'sub barrier () {
		    eval q(\\"(assembly code)\\");
		}' unless defined(&barrier);
	    }
	}
	unless(defined(&RELOC_HIDE)) {
	    eval 'sub RELOC_HIDE {
	        my($ptr, $off) = @_;
    		eval q(({ \'unsigned long __ptr\';  &__ptr = ($ptr); ( &typeof($ptr)) ( &__ptr + ($off)); }));
	    }' unless defined(&RELOC_HIDE);
	}
    }
    unless(defined(&__deprecated)) {
	eval 'sub __deprecated () {1;}' unless defined(&__deprecated);
    }
    unless(defined(&__must_check)) {
	eval 'sub __must_check () {1;}' unless defined(&__must_check);
    }
    unless(defined(&__attribute_used__)) {
	eval 'sub __attribute_used__ () {1;}' unless defined(&__attribute_used__);
    }
    unless(defined(&__attribute_pure__)) {
	eval 'sub __attribute_pure__ () {1;}' unless defined(&__attribute_pure__);
    }
    unless(defined(&__attribute_const__)) {
	eval 'sub __attribute_const__ () {1;}' unless defined(&__attribute_const__);
    }
    unless(defined(&__always_inline)) {
	eval 'sub __always_inline () { &inline;}' unless defined(&__always_inline);
    }
    if(defined(&__cplusplus)) {
	eval 'sub __cast__ {
	    my($_to) = @_;
    	    eval q(($_to));
	}' unless defined(&__cast__);
    } else {
	eval 'sub __cast__ {
	    my($_to) = @_;
    	    eval q();
	}' unless defined(&__cast__);
    }
}
1;
