require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_ATA_H__)) {
    eval 'sub __LINUX_ATA_H__ () {1;}' unless defined(&__LINUX_ATA_H__);
    require 'linux/types.ph';
    eval 'sub ATA_DMA_BOUNDARY () {0xffff;}' unless defined(&ATA_DMA_BOUNDARY);
    eval 'sub ATA_DMA_MASK () {0xffffffff;}' unless defined(&ATA_DMA_MASK);
    eval("sub ATA_MAX_DEVICES () { 2; }") unless defined(&ATA_MAX_DEVICES);
    eval("sub ATA_MAX_PRD () { 256; }") unless defined(&ATA_MAX_PRD);
    eval("sub ATA_SECT_SIZE () { 512; }") unless defined(&ATA_SECT_SIZE);
    eval("sub ATA_ID_WORDS () { 256; }") unless defined(&ATA_ID_WORDS);
    eval("sub ATA_ID_PROD_OFS () { 27; }") unless defined(&ATA_ID_PROD_OFS);
    eval("sub ATA_ID_FW_REV_OFS () { 23; }") unless defined(&ATA_ID_FW_REV_OFS);
    eval("sub ATA_ID_SERNO_OFS () { 10; }") unless defined(&ATA_ID_SERNO_OFS);
    eval("sub ATA_ID_MAJOR_VER () { 80; }") unless defined(&ATA_ID_MAJOR_VER);
    eval("sub ATA_ID_PIO_MODES () { 64; }") unless defined(&ATA_ID_PIO_MODES);
    eval("sub ATA_ID_MWDMA_MODES () { 63; }") unless defined(&ATA_ID_MWDMA_MODES);
    eval("sub ATA_ID_UDMA_MODES () { 88; }") unless defined(&ATA_ID_UDMA_MODES);
    eval("sub ATA_ID_PIO4 () { (1<<1); }") unless defined(&ATA_ID_PIO4);
    eval("sub ATA_PCI_CTL_OFS () { 2; }") unless defined(&ATA_PCI_CTL_OFS);
    eval("sub ATA_SERNO_LEN () { 20; }") unless defined(&ATA_SERNO_LEN);
    eval("sub ATA_UDMA0 () { (1<<0); }") unless defined(&ATA_UDMA0);
    eval("sub ATA_UDMA1 () { ATA_UDMA0|(1<<1); }") unless defined(&ATA_UDMA1);
    eval("sub ATA_UDMA2 () { ATA_UDMA1|(1<<2); }") unless defined(&ATA_UDMA2);
    eval("sub ATA_UDMA3 () { ATA_UDMA2|(1<<3); }") unless defined(&ATA_UDMA3);
    eval("sub ATA_UDMA4 () { ATA_UDMA3|(1<<4); }") unless defined(&ATA_UDMA4);
    eval("sub ATA_UDMA5 () { ATA_UDMA4|(1<<5); }") unless defined(&ATA_UDMA5);
    eval("sub ATA_UDMA6 () { ATA_UDMA5|(1<<6); }") unless defined(&ATA_UDMA6);
    eval("sub ATA_UDMA7 () { ATA_UDMA6|(1<<7); }") unless defined(&ATA_UDMA7);
    eval("sub ATA_UDMA_MASK_40C () { ATA_UDMA2; }") unless defined(&ATA_UDMA_MASK_40C);
    eval("sub ATA_PRD_SZ () { 8; }") unless defined(&ATA_PRD_SZ);
    eval("sub ATA_PRD_TBL_SZ () { (ATA_MAX_PRD*ATA_PRD_SZ); }") unless defined(&ATA_PRD_TBL_SZ);
    eval("sub ATA_PRD_EOT () { (1<<31); }") unless defined(&ATA_PRD_EOT);
    eval("sub ATA_DMA_TABLE_OFS () { 4; }") unless defined(&ATA_DMA_TABLE_OFS);
    eval("sub ATA_DMA_STATUS () { 2; }") unless defined(&ATA_DMA_STATUS);
    eval("sub ATA_DMA_CMD () { 0; }") unless defined(&ATA_DMA_CMD);
    eval("sub ATA_DMA_WR () { (1<<3); }") unless defined(&ATA_DMA_WR);
    eval("sub ATA_DMA_START () { (1<<0); }") unless defined(&ATA_DMA_START);
    eval("sub ATA_DMA_INTR () { (1<<2); }") unless defined(&ATA_DMA_INTR);
    eval("sub ATA_DMA_ERR () { (1<<1); }") unless defined(&ATA_DMA_ERR);
    eval("sub ATA_DMA_ACTIVE () { (1<<0); }") unless defined(&ATA_DMA_ACTIVE);
    eval("sub ATA_HOB () { (1<<7); }") unless defined(&ATA_HOB);
    eval("sub ATA_NIEN () { (1<<1); }") unless defined(&ATA_NIEN);
    eval("sub ATA_LBA () { (1<<6); }") unless defined(&ATA_LBA);
    eval("sub ATA_DEV1 () { (1<<4); }") unless defined(&ATA_DEV1);
    eval("sub ATA_DEVICE_OBS () { (1<<7)|(1<<5); }") unless defined(&ATA_DEVICE_OBS);
    eval("sub ATA_DEVCTL_OBS () { (1<<3); }") unless defined(&ATA_DEVCTL_OBS);
    eval("sub ATA_BUSY () { (1<<7); }") unless defined(&ATA_BUSY);
    eval("sub ATA_DRDY () { (1<<6); }") unless defined(&ATA_DRDY);
    eval("sub ATA_DF () { (1<<5); }") unless defined(&ATA_DF);
    eval("sub ATA_DRQ () { (1<<3); }") unless defined(&ATA_DRQ);
    eval("sub ATA_ERR () { (1<<0); }") unless defined(&ATA_ERR);
    eval("sub ATA_SRST () { (1<<2); }") unless defined(&ATA_SRST);
    eval("sub ATA_ABORTED () { (1<<2); }") unless defined(&ATA_ABORTED);
    eval("sub ATA_REG_DATA () { 0x00; }") unless defined(&ATA_REG_DATA);
    eval("sub ATA_REG_ERR () { 0x01; }") unless defined(&ATA_REG_ERR);
    eval("sub ATA_REG_NSECT () { 0x02; }") unless defined(&ATA_REG_NSECT);
    eval("sub ATA_REG_LBAL () { 0x03; }") unless defined(&ATA_REG_LBAL);
    eval("sub ATA_REG_LBAM () { 0x04; }") unless defined(&ATA_REG_LBAM);
    eval("sub ATA_REG_LBAH () { 0x05; }") unless defined(&ATA_REG_LBAH);
    eval("sub ATA_REG_DEVICE () { 0x06; }") unless defined(&ATA_REG_DEVICE);
    eval("sub ATA_REG_STATUS () { 0x07; }") unless defined(&ATA_REG_STATUS);
    eval("sub ATA_REG_FEATURE () { ATA_REG_ERR; }") unless defined(&ATA_REG_FEATURE);
    eval("sub ATA_REG_CMD () { ATA_REG_STATUS; }") unless defined(&ATA_REG_CMD);
    eval("sub ATA_REG_BYTEL () { ATA_REG_LBAM; }") unless defined(&ATA_REG_BYTEL);
    eval("sub ATA_REG_BYTEH () { ATA_REG_LBAH; }") unless defined(&ATA_REG_BYTEH);
    eval("sub ATA_REG_DEVSEL () { ATA_REG_DEVICE; }") unless defined(&ATA_REG_DEVSEL);
    eval("sub ATA_REG_IRQ () { ATA_REG_NSECT; }") unless defined(&ATA_REG_IRQ);
    eval("sub ATA_CMD_CHK_POWER () { 0xE5; }") unless defined(&ATA_CMD_CHK_POWER);
    eval("sub ATA_CMD_EDD () { 0x90; }") unless defined(&ATA_CMD_EDD);
    eval("sub ATA_CMD_FLUSH () { 0xE7; }") unless defined(&ATA_CMD_FLUSH);
    eval("sub ATA_CMD_FLUSH_EXT () { 0xEA; }") unless defined(&ATA_CMD_FLUSH_EXT);
    eval("sub ATA_CMD_ID_ATA () { 0xEC; }") unless defined(&ATA_CMD_ID_ATA);
    eval("sub ATA_CMD_ID_ATAPI () { 0xA1; }") unless defined(&ATA_CMD_ID_ATAPI);
    eval("sub ATA_CMD_READ () { 0xC8; }") unless defined(&ATA_CMD_READ);
    eval("sub ATA_CMD_READ_EXT () { 0x25; }") unless defined(&ATA_CMD_READ_EXT);
    eval("sub ATA_CMD_WRITE () { 0xCA; }") unless defined(&ATA_CMD_WRITE);
    eval("sub ATA_CMD_WRITE_EXT () { 0x35; }") unless defined(&ATA_CMD_WRITE_EXT);
    eval("sub ATA_CMD_PIO_READ () { 0x20; }") unless defined(&ATA_CMD_PIO_READ);
    eval("sub ATA_CMD_PIO_READ_EXT () { 0x24; }") unless defined(&ATA_CMD_PIO_READ_EXT);
    eval("sub ATA_CMD_PIO_WRITE () { 0x30; }") unless defined(&ATA_CMD_PIO_WRITE);
    eval("sub ATA_CMD_PIO_WRITE_EXT () { 0x34; }") unless defined(&ATA_CMD_PIO_WRITE_EXT);
    eval("sub ATA_CMD_SET_FEATURES () { 0xEF; }") unless defined(&ATA_CMD_SET_FEATURES);
    eval("sub ATA_CMD_PACKET () { 0xA0; }") unless defined(&ATA_CMD_PACKET);
    eval("sub ATA_CMD_VERIFY () { 0x40; }") unless defined(&ATA_CMD_VERIFY);
    eval("sub ATA_CMD_VERIFY_EXT () { 0x42; }") unless defined(&ATA_CMD_VERIFY_EXT);
    eval("sub SETFEATURES_XFER () { 0x03; }") unless defined(&SETFEATURES_XFER);
    eval("sub XFER_UDMA_7 () { 0x47; }") unless defined(&XFER_UDMA_7);
    eval("sub XFER_UDMA_6 () { 0x46; }") unless defined(&XFER_UDMA_6);
    eval("sub XFER_UDMA_5 () { 0x45; }") unless defined(&XFER_UDMA_5);
    eval("sub XFER_UDMA_4 () { 0x44; }") unless defined(&XFER_UDMA_4);
    eval("sub XFER_UDMA_3 () { 0x43; }") unless defined(&XFER_UDMA_3);
    eval("sub XFER_UDMA_2 () { 0x42; }") unless defined(&XFER_UDMA_2);
    eval("sub XFER_UDMA_1 () { 0x41; }") unless defined(&XFER_UDMA_1);
    eval("sub XFER_UDMA_0 () { 0x40; }") unless defined(&XFER_UDMA_0);
    eval("sub XFER_MW_DMA_2 () { 0x22; }") unless defined(&XFER_MW_DMA_2);
    eval("sub XFER_MW_DMA_1 () { 0x21; }") unless defined(&XFER_MW_DMA_1);
    eval("sub XFER_MW_DMA_0 () { 0x20; }") unless defined(&XFER_MW_DMA_0);
    eval("sub XFER_PIO_4 () { 0x0C; }") unless defined(&XFER_PIO_4);
    eval("sub XFER_PIO_3 () { 0x0B; }") unless defined(&XFER_PIO_3);
    eval("sub XFER_PIO_2 () { 0x0A; }") unless defined(&XFER_PIO_2);
    eval("sub XFER_PIO_1 () { 0x09; }") unless defined(&XFER_PIO_1);
    eval("sub XFER_PIO_0 () { 0x08; }") unless defined(&XFER_PIO_0);
    eval("sub XFER_SW_DMA_2 () { 0x12; }") unless defined(&XFER_SW_DMA_2);
    eval("sub XFER_SW_DMA_1 () { 0x11; }") unless defined(&XFER_SW_DMA_1);
    eval("sub XFER_SW_DMA_0 () { 0x10; }") unless defined(&XFER_SW_DMA_0);
    eval("sub XFER_PIO_SLOW () { 0x00; }") unless defined(&XFER_PIO_SLOW);
    eval("sub ATAPI_PKT_DMA () { (1<<0); }") unless defined(&ATAPI_PKT_DMA);
    eval("sub ATAPI_DMADIR () { (1<<2); }") unless defined(&ATAPI_DMADIR);
    eval("sub ATAPI_CDB_LEN () { 16; }") unless defined(&ATAPI_CDB_LEN);
    eval("sub ATA_CBL_NONE () { 0; }") unless defined(&ATA_CBL_NONE);
    eval("sub ATA_CBL_PATA40 () { 1; }") unless defined(&ATA_CBL_PATA40);
    eval("sub ATA_CBL_PATA80 () { 2; }") unless defined(&ATA_CBL_PATA80);
    eval("sub ATA_CBL_PATA_UNK () { 3; }") unless defined(&ATA_CBL_PATA_UNK);
    eval("sub ATA_CBL_SATA () { 4; }") unless defined(&ATA_CBL_SATA);
    eval("sub SCR_STATUS () { 0; }") unless defined(&SCR_STATUS);
    eval("sub SCR_ERROR () { 1; }") unless defined(&SCR_ERROR);
    eval("sub SCR_CONTROL () { 2; }") unless defined(&SCR_CONTROL);
    eval("sub SCR_ACTIVE () { 3; }") unless defined(&SCR_ACTIVE);
    eval("sub SCR_NOTIFICATION () { 4; }") unless defined(&SCR_NOTIFICATION);
    eval("sub ATA_TFLAG_LBA48 () { (1<<0); }") unless defined(&ATA_TFLAG_LBA48);
    eval("sub ATA_TFLAG_ISADDR () { (1<<1); }") unless defined(&ATA_TFLAG_ISADDR);
    eval("sub ATA_TFLAG_DEVICE () { (1<<2); }") unless defined(&ATA_TFLAG_DEVICE);
    eval("sub ATA_TFLAG_WRITE () { (1<<3); }") unless defined(&ATA_TFLAG_WRITE);
    eval("sub ATA_PROT_UNKNOWN () { 0; }") unless defined(&ATA_PROT_UNKNOWN);
    eval("sub ATA_PROT_NODATA () { 1; }") unless defined(&ATA_PROT_NODATA);
    eval("sub ATA_PROT_PIO () { 2; }") unless defined(&ATA_PROT_PIO);
    eval("sub ATA_PROT_PIO_MULT () { 3; }") unless defined(&ATA_PROT_PIO_MULT);
    eval("sub ATA_PROT_DMA () { 4; }") unless defined(&ATA_PROT_DMA);
    eval("sub ATA_PROT_ATAPI () { 5; }") unless defined(&ATA_PROT_ATAPI);
    eval("sub ATA_PROT_ATAPI_NODATA () { 6; }") unless defined(&ATA_PROT_ATAPI_NODATA);
    eval("sub ATA_PROT_ATAPI_DMA () { 7; }") unless defined(&ATA_PROT_ATAPI_DMA);
    eval("sub ATA_IOC_GET_IO32 () { 0x309; }") unless defined(&ATA_IOC_GET_IO32);
    eval("sub ATA_IOC_SET_IO32 () { 0x324; }") unless defined(&ATA_IOC_SET_IO32);
    eval 'sub ata_id_is_ata {
        my($id) = @_;
	    eval q(((($id)[0] & (1<< 15)) == 0));
    }' unless defined(&ata_id_is_ata);
    eval 'sub ata_id_rahead_enabled {
        my($id) = @_;
	    eval q((($id)[85] & (1<< 6)));
    }' unless defined(&ata_id_rahead_enabled);
    eval 'sub ata_id_wcache_enabled {
        my($id) = @_;
	    eval q((($id)[85] & (1<< 5)));
    }' unless defined(&ata_id_wcache_enabled);
    eval 'sub ata_id_has_flush {
        my($id) = @_;
	    eval q((($id)[83] & (1<< 12)));
    }' unless defined(&ata_id_has_flush);
    eval 'sub ata_id_has_flush_ext {
        my($id) = @_;
	    eval q((($id)[83] & (1<< 13)));
    }' unless defined(&ata_id_has_flush_ext);
    eval 'sub ata_id_has_lba48 {
        my($id) = @_;
	    eval q((($id)[83] & (1<< 10)));
    }' unless defined(&ata_id_has_lba48);
    eval 'sub ata_id_has_wcache {
        my($id) = @_;
	    eval q((($id)[82] & (1<< 5)));
    }' unless defined(&ata_id_has_wcache);
    eval 'sub ata_id_has_pm {
        my($id) = @_;
	    eval q((($id)[82] & (1<< 3)));
    }' unless defined(&ata_id_has_pm);
    eval 'sub ata_id_has_lba {
        my($id) = @_;
	    eval q((($id)[49] & (1<< 9)));
    }' unless defined(&ata_id_has_lba);
    eval 'sub ata_id_has_dma {
        my($id) = @_;
	    eval q((($id)[49] & (1<< 8)));
    }' unless defined(&ata_id_has_dma);
    eval 'sub ata_id_removeable {
        my($id) = @_;
	    eval q((($id)[0] & (1<< 7)));
    }' unless defined(&ata_id_removeable);
    eval 'sub ata_id_u32 {
        my($id,$n) = @_;
	    eval q(((( &u32) ($id)[($n) + 1] << 16) | (( &u32) ($id)[($n)])));
    }' unless defined(&ata_id_u32);
    eval 'sub ata_id_u64 {
        my($id,$n) = @_;
	    eval q(( (( &u64) ($id)[($n) + 3] << 48) | (( &u64) ($id)[($n) + 2] << 32) | (( &u64) ($id)[($n) + 1] << 16) | (( &u64) ($id)[($n) + 0]) ));
    }' unless defined(&ata_id_u64);
    eval 'sub atapi_cdb_len {
        my($dev_id) = @_;
	    eval q({  &u16  &tmp = $dev_id->[0] & 0x3;  &switch ( &tmp) {  &case 0: 12;  &case 1: 16;  &default: -1; } });
    }' unless defined(&atapi_cdb_len);
    eval 'sub is_atapi_taskfile {
        my($tf) = @_;
	    eval q({ ( ($tf->{protocol}) ==  &ATA_PROT_ATAPI) || ( ($tf->{protocol}) ==  &ATA_PROT_ATAPI_NODATA) || ( ($tf->{protocol}) ==  &ATA_PROT_ATAPI_DMA); });
    }' unless defined(&is_atapi_taskfile);
    eval 'sub ata_ok {
        my($status) = @_;
	    eval q({ (($status & ( &ATA_BUSY |  &ATA_DRDY |  &ATA_DF |  &ATA_DRQ |  &ATA_ERR)) ==  &ATA_DRDY); });
    }' unless defined(&ata_ok);
}
1;
