require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_I386_TLBFLUSH_H)) {
    eval 'sub _I386_TLBFLUSH_H () {1;}' unless defined(&_I386_TLBFLUSH_H);
    require 'linux/config.ph';
    require 'linux/mm.ph';
    require 'asm/processor.ph';
    eval 'sub __flush_tlb () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__flush_tlb);
    eval 'sub __flush_tlb_global () {
        eval q(\\"(assembly code)\\");
    }' unless defined(&__flush_tlb_global);
    eval 'sub __flush_tlb_all () {
        eval q( &do {  &if ( &cpu_has_pge)  &__flush_tlb_global();  &else  &__flush_tlb(); }  &while (0));
    }' unless defined(&__flush_tlb_all);
    eval 'sub cpu_has_invlpg () {( ($boot_cpu_data->{x86}) > 3);}' unless defined(&cpu_has_invlpg);
    eval 'sub __flush_tlb_single {
        my($addr) = @_;
	    eval q(\\"(assembly code)\\");
    }' unless defined(&__flush_tlb_single);
    if(defined(&CONFIG_X86_INVLPG)) {
	eval 'sub __flush_tlb_one {
	    my($addr) = @_;
    	    eval q( &__flush_tlb_single($addr));
	}' unless defined(&__flush_tlb_one);
    } else {
	eval 'sub __flush_tlb_one {
	    my($addr) = @_;
    	    eval q( &do {  &if ( &cpu_has_invlpg)  &__flush_tlb_single($addr);  &else  &__flush_tlb(); }  &while (0));
	}' unless defined(&__flush_tlb_one);
    }
    unless(defined(&CONFIG_SMP)) {
	eval 'sub flush_tlb () {
	    eval q( &__flush_tlb());
	}' unless defined(&flush_tlb);
	eval 'sub flush_tlb_all () {
	    eval q( &__flush_tlb_all());
	}' unless defined(&flush_tlb_all);
	eval 'sub local_flush_tlb () {
	    eval q( &__flush_tlb());
	}' unless defined(&local_flush_tlb);
	eval 'sub flush_tlb_mm {
	    my($mm) = @_;
    	    eval q({  &if ($mm ==  ($current->{active_mm}))  &__flush_tlb(); });
	}' unless defined(&flush_tlb_mm);
	eval 'sub flush_tlb_page {
	    my($vma,$addr) = @_;
    	    eval q({  &if ( ($vma->{vm_mm}) ==  ($current->{active_mm}))  &__flush_tlb_one($addr); });
	}' unless defined(&flush_tlb_page);
	eval 'sub flush_tlb_range {
	    my($vma,$start,$end) = @_;
    	    eval q({  &if ( ($vma->{vm_mm}) ==  ($current->{active_mm}))  &__flush_tlb(); });
	}' unless defined(&flush_tlb_range);
    } else {
	require 'asm/smp.ph';
	eval 'sub local_flush_tlb () {
	    eval q( &__flush_tlb());
	}' unless defined(&local_flush_tlb);
	eval 'sub flush_tlb () {
	    eval q( &flush_tlb_current_task());
	}' unless defined(&flush_tlb);
	eval 'sub flush_tlb_range {
	    my($vma,$start,$end) = @_;
    	    eval q({  &flush_tlb_mm( ($vma->{vm_mm})); });
	}' unless defined(&flush_tlb_range);
	eval 'sub TLBSTATE_OK () {1;}' unless defined(&TLBSTATE_OK);
	eval 'sub TLBSTATE_LAZY () {2;}' unless defined(&TLBSTATE_LAZY);
    }
    eval 'sub flush_tlb_kernel_range {
        my($start, $end) = @_;
	    eval q( &flush_tlb_all());
    }' unless defined(&flush_tlb_kernel_range);
    eval 'sub flush_tlb_pgtables {
        my($mm,$start,$end) = @_;
	    eval q({ }  &endif );
    }' unless defined(&flush_tlb_pgtables);
1;
