require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_I386_PGTABLE_2LEVEL_H)) {
    eval 'sub _I386_PGTABLE_2LEVEL_H () {1;}' unless defined(&_I386_PGTABLE_2LEVEL_H);
    require 'asm-generic/pgtable-nopmd.ph';
    eval 'sub pte_ERROR {
        my($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pte %08lx.\\\\n\\",  &__FILE__,  &__LINE__, ($e). &pte_low));
    }' unless defined(&pte_ERROR);
    eval 'sub pgd_ERROR {
        my($e) = @_;
	    eval q( &printk(\\"%s:%d: bad pgd %08lx.\\\\n\\",  &__FILE__,  &__LINE__,  &pgd_val($e)));
    }' unless defined(&pgd_ERROR);
    eval 'sub set_pte {
        my($pteptr, $pteval) = @_;
	    eval q((*($pteptr) = $pteval));
    }' unless defined(&set_pte);
    eval 'sub set_pte_atomic {
        my($pteptr, $pteval) = @_;
	    eval q( &set_pte($pteptr,$pteval));
    }' unless defined(&set_pte_atomic);
    eval 'sub set_pmd {
        my($pmdptr, $pmdval) = @_;
	    eval q((*($pmdptr) = ($pmdval)));
    }' unless defined(&set_pmd);
    eval 'sub ptep_get_and_clear {
        my($xp) = @_;
	    eval q( &__pte( &xchg(($xp)-> &pte_low, 0)));
    }' unless defined(&ptep_get_and_clear);
    eval 'sub pte_same {
        my($a, $b) = @_;
	    eval q((($a). &pte_low == ($b). &pte_low));
    }' unless defined(&pte_same);
    eval 'sub pte_page {
        my($x) = @_;
	    eval q( &pfn_to_page( &pte_pfn($x)));
    }' unless defined(&pte_page);
    eval 'sub pte_none {
        my($x) = @_;
	    eval q((!($x). &pte_low));
    }' unless defined(&pte_none);
    eval 'sub pte_pfn {
        my($x) = @_;
	    eval q((((($x). &pte_low >>  &PAGE_SHIFT))));
    }' unless defined(&pte_pfn);
    eval 'sub pfn_pte {
        my($pfn, $prot) = @_;
	    eval q( &__pte((($pfn) <<  &PAGE_SHIFT) |  &pgprot_val($prot)));
    }' unless defined(&pfn_pte);
    eval 'sub pfn_pmd {
        my($pfn, $prot) = @_;
	    eval q( &__pmd((($pfn) <<  &PAGE_SHIFT) |  &pgprot_val($prot)));
    }' unless defined(&pfn_pmd);
    eval 'sub pmd_page {
        my($pmd) = @_;
	    eval q(( &pfn_to_page( &pmd_val($pmd) >>  &PAGE_SHIFT)));
    }' unless defined(&pmd_page);
    eval 'sub pmd_page_kernel {
        my($pmd) = @_;
	    eval q((  &__va( &pmd_val($pmd) &  &PAGE_MASK)));
    }' unless defined(&pmd_page_kernel);
    eval 'sub PTE_FILE_MAX_BITS () {29;}' unless defined(&PTE_FILE_MAX_BITS);
    eval 'sub pte_to_pgoff {
        my($pte) = @_;
	    eval q((((($pte). &pte_low >> 1) & 0x1f ) + ((($pte). &pte_low >> 8) << 5)));
    }' unless defined(&pte_to_pgoff);
    eval 'sub pgoff_to_pte {
        my($off) = @_;
	    eval q((( &pte_t) { ((($off) & 0x1f) << 1) + ((($off) >> 5) << 8) +  &_PAGE_FILE }));
    }' unless defined(&pgoff_to_pte);
    eval 'sub __swp_type {
        my($x) = @_;
	    eval q(((($x). &val >> 1) & 0x1f));
    }' unless defined(&__swp_type);
    eval 'sub __swp_offset {
        my($x) = @_;
	    eval q((($x). &val >> 8));
    }' unless defined(&__swp_offset);
    eval 'sub __swp_entry {
        my($type, $offset) = @_;
	    eval q((( &swp_entry_t) { (($type) << 1) | (($offset) << 8) }));
    }' unless defined(&__swp_entry);
    eval 'sub __pte_to_swp_entry {
        my($pte) = @_;
	    eval q((( &swp_entry_t) { ($pte). &pte_low }));
    }' unless defined(&__pte_to_swp_entry);
    eval 'sub __swp_entry_to_pte {
        my($x) = @_;
	    eval q((( &pte_t) { ($x). &val }));
    }' unless defined(&__swp_entry_to_pte);
}
1;
