require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__i386_PCI_H)) {
    eval 'sub __i386_PCI_H () {1;}' unless defined(&__i386_PCI_H);
    require 'linux/config.ph';
    if(defined(&__KERNEL__)) {
	require 'linux/mm.ph';
	if(defined(&CONFIG_PCI)) {
	} else {
	    eval 'sub pcibios_assign_all_busses () {
	        eval q(0);
	    }' unless defined(&pcibios_assign_all_busses);
	}
	eval 'sub pcibios_scan_all_fns {
	    my($a, $b) = @_;
    	    eval q(0);
	}' unless defined(&pcibios_scan_all_fns);
	eval 'sub PCIBIOS_MIN_IO () {0x1000;}' unless defined(&PCIBIOS_MIN_IO);
	eval 'sub PCIBIOS_MIN_MEM () {( &pci_mem_start);}' unless defined(&PCIBIOS_MIN_MEM);
	eval 'sub PCIBIOS_MIN_CARDBUS_IO () {0x4000;}' unless defined(&PCIBIOS_MIN_CARDBUS_IO);
	require 'linux/types.ph';
	require 'linux/slab.ph';
	require 'asm/scatterlist.ph';
	require 'linux/string.ph';
	require 'asm/io.ph';
	eval 'sub PCI_DMA_BUS_IS_PHYS () {(1);}' unless defined(&PCI_DMA_BUS_IS_PHYS);
	eval 'sub DECLARE_PCI_UNMAP_ADDR {
	    my($ADDR_NAME) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PCI_UNMAP_ADDR);
	eval 'sub DECLARE_PCI_UNMAP_LEN {
	    my($LEN_NAME) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PCI_UNMAP_LEN);
	eval 'sub pci_unmap_addr {
	    my($PTR, $ADDR_NAME) = @_;
    	    eval q((0));
	}' unless defined(&pci_unmap_addr);
	eval 'sub pci_unmap_addr_set {
	    my($PTR, $ADDR_NAME, $VAL) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&pci_unmap_addr_set);
	eval 'sub pci_unmap_len {
	    my($PTR, $LEN_NAME) = @_;
    	    eval q((0));
	}' unless defined(&pci_unmap_len);
	eval 'sub pci_unmap_len_set {
	    my($PTR, $LEN_NAME, $VAL) = @_;
    	    eval q( &do { }  &while (0));
	}' unless defined(&pci_unmap_len_set);
	eval 'sub pci_dac_dma_supported {
	    my($pci_dev, $mask) = @_;
    	    eval q((1));
	}' unless defined(&pci_dac_dma_supported);
	eval 'sub pci_dac_page_to_dma {
	    my($pdev,$page,$offset,$direction) = @_;
    	    eval q({ (( &dma64_addr_t)  &page_to_phys($page) + ( &dma64_addr_t) $offset); });
	}' unless defined(&pci_dac_page_to_dma);
	eval 'sub pci_dac_dma_to_page {
	    my($pdev,$dma_addr) = @_;
    	    eval q({  &pfn_to_page($dma_addr >>  &PAGE_SHIFT); });
	}' unless defined(&pci_dac_dma_to_page);
	eval 'sub pci_dac_dma_to_offset {
	    my($pdev,$dma_addr) = @_;
    	    eval q({ ($dma_addr & ~ &PAGE_MASK); });
	}' unless defined(&pci_dac_dma_to_offset);
	eval 'sub pci_dac_dma_sync_single_for_cpu {
	    my($pdev,$dma_addr,$len,$direction) = @_;
    	    eval q({ });
	}' unless defined(&pci_dac_dma_sync_single_for_cpu);
	eval 'sub pci_dac_dma_sync_single_for_device {
	    my($pdev,$dma_addr,$len,$direction) = @_;
    	    eval q({  &flush_write_buffers(); });
	}' unless defined(&pci_dac_dma_sync_single_for_device);
	eval 'sub HAVE_PCI_MMAP () {1;}' unless defined(&HAVE_PCI_MMAP);
	eval 'sub pcibios_add_platform_entries {
	    my($dev) = @_;
    	    eval q({ });
	}' unless defined(&pcibios_add_platform_entries);
    }
    require 'asm-generic/pci-dma-compat.ph';
    require 'asm-generic/pci.ph';
}
1;
