require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&_ASM_I386_DMA_MAPPING_H)) {
    eval 'sub _ASM_I386_DMA_MAPPING_H () {1;}' unless defined(&_ASM_I386_DMA_MAPPING_H);
    require 'linux/mm.ph';
    require 'asm/cache.ph';
    require 'asm/io.ph';
    require 'asm/scatterlist.ph';
    eval 'sub dma_alloc_noncoherent {
        my($d, $s, $h, $f) = @_;
	    eval q( &dma_alloc_coherent($d, $s, $h, $f));
    }' unless defined(&dma_alloc_noncoherent);
    eval 'sub dma_free_noncoherent {
        my($d, $s, $v, $h) = @_;
	    eval q( &dma_free_coherent($d, $s, $v, $h));
    }' unless defined(&dma_free_noncoherent);
    eval 'sub dma_map_single {
        my($dev,$ptr,$size,$direction) = @_;
	    eval q({  &BUG_ON($direction ==  &DMA_NONE);  &flush_write_buffers();  &virt_to_phys($ptr); });
    }' unless defined(&dma_map_single);
    eval 'sub dma_unmap_single {
        my($dev,$dma_addr,$size,$direction) = @_;
	    eval q({  &BUG_ON($direction ==  &DMA_NONE); });
    }' unless defined(&dma_unmap_single);
    eval 'sub dma_map_sg {
        my($dev,$sg,$nents,$direction) = @_;
	    eval q({ \'int\'  &i;  &BUG_ON($direction ==  &DMA_NONE);  &for ( &i = 0;  &i < $nents;  &i++ ) {  &BUG_ON(! ($sg[&i]->{page}));  ($sg[&i]->{dma_address}) =  &page_to_phys( ($sg[&i]->{page})) +  ($sg[&i]->{offset}); }  &flush_write_buffers(); $nents; });
    }' unless defined(&dma_map_sg);
    eval 'sub dma_map_page {
        my($dev,$page,$offset,$size,$direction) = @_;
	    eval q({  &BUG_ON($direction ==  &DMA_NONE);  &page_to_phys($page) + $offset; });
    }' unless defined(&dma_map_page);
    eval 'sub dma_unmap_page {
        my($dev,$dma_address,$size,$direction) = @_;
	    eval q({  &BUG_ON($direction ==  &DMA_NONE); });
    }' unless defined(&dma_unmap_page);
    eval 'sub dma_unmap_sg {
        my($dev,$sg,$nhwentries,$direction) = @_;
	    eval q({  &BUG_ON($direction ==  &DMA_NONE); });
    }' unless defined(&dma_unmap_sg);
    eval 'sub dma_sync_single_for_cpu {
        my($dev,$dma_handle,$size,$direction) = @_;
	    eval q({ });
    }' unless defined(&dma_sync_single_for_cpu);
    eval 'sub dma_sync_single_for_device {
        my($dev,$dma_handle,$size,$direction) = @_;
	    eval q({  &flush_write_buffers(); });
    }' unless defined(&dma_sync_single_for_device);
    eval 'sub dma_sync_single_range_for_cpu {
        my($dev,$dma_handle,$offset,$size,$direction) = @_;
	    eval q({ });
    }' unless defined(&dma_sync_single_range_for_cpu);
    eval 'sub dma_sync_single_range_for_device {
        my($dev,$dma_handle,$offset,$size,$direction) = @_;
	    eval q({  &flush_write_buffers(); });
    }' unless defined(&dma_sync_single_range_for_device);
    eval 'sub dma_sync_sg_for_cpu {
        my($dev,$sg,$nelems,$direction) = @_;
	    eval q({ });
    }' unless defined(&dma_sync_sg_for_cpu);
    eval 'sub dma_sync_sg_for_device {
        my($dev,$sg,$nelems,$direction) = @_;
	    eval q({  &flush_write_buffers(); });
    }' unless defined(&dma_sync_sg_for_device);
    eval 'sub dma_mapping_error {
        my($dma_addr) = @_;
	    eval q({ 0; });
    }' unless defined(&dma_mapping_error);
    eval 'sub dma_supported {
        my($dev,$mask) = @_;
	    eval q({  &if($mask < 0xffffff) 0; 1; });
    }' unless defined(&dma_supported);
    eval 'sub dma_set_mask {
        my($dev,$mask) = @_;
	    eval q({  &if(! ($dev->{dma_mask}) || ! &dma_supported($dev, $mask)) - &EIO; * ($dev->{dma_mask}) = $mask; 0; });
    }' unless defined(&dma_set_mask);
    eval 'sub dma_get_cache_alignment {
        my($void) = @_;
	    eval q({ (1<<  &L1_CACHE_SHIFT_MAX); });
    }' unless defined(&dma_get_cache_alignment);
    eval 'sub dma_is_consistent {
        my($d) = @_;
	    eval q((1));
    }' unless defined(&dma_is_consistent);
    eval 'sub dma_cache_sync {
        my($vaddr,$size,$direction) = @_;
	    eval q({  &flush_write_buffers(); });
    }' unless defined(&dma_cache_sync);
    eval 'sub ARCH_HAS_DMA_DECLARE_COHERENT_MEMORY () {1;}' unless defined(&ARCH_HAS_DMA_DECLARE_COHERENT_MEMORY);
}
1;
