require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__ARCH_DESC_H)) {
    eval 'sub __ARCH_DESC_H () {1;}' unless defined(&__ARCH_DESC_H);
    require 'asm/ldt.ph';
    require 'asm/segment.ph';
    unless(defined(&__ASSEMBLY__)) {
	require 'linux/preempt.ph';
	require 'linux/smp.ph';
	require 'linux/percpu.ph';
	require 'asm/mmu.ph';
	eval 'sub load_TR_desc () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&load_TR_desc);
	eval 'sub load_LDT_desc () {
	    eval q(\\"(assembly code)\\");
	}' unless defined(&load_LDT_desc);
	eval 'sub _set_tssldt_desc {
	    my($n,$addr,$limit,$type) = @_;
    	    eval q(\\"(assembly code)\\");
	}' unless defined(&_set_tssldt_desc);
	eval 'sub __set_tss_desc {
	    my($cpu,$entry,$addr) = @_;
    	    eval q({  &_set_tssldt_desc( &per_cpu( &cpu_gdt_table, $cpu)[$entry], $addr,  &offsetof(\'struct tss_struct\',  &__cacheline_filler) - 1, 0x89); });
	}' unless defined(&__set_tss_desc);
	eval 'sub set_tss_desc {
	    my($cpu,$addr) = @_;
    	    eval q( &__set_tss_desc($cpu,  &GDT_ENTRY_TSS, $addr));
	}' unless defined(&set_tss_desc);
	eval 'sub set_ldt_desc {
	    my($cpu,$addr,$size) = @_;
    	    eval q({  &_set_tssldt_desc( &per_cpu( &cpu_gdt_table, $cpu)[ &GDT_ENTRY_LDT], $addr, (($size << 3)-1), 0x82); });
	}' unless defined(&set_ldt_desc);
	eval 'sub LDT_entry_a {
	    my($info) = @_;
    	    eval q((((($info)-> &base_addr & 0xffff) << 16) | (($info)-> &limit & 0xffff)));
	}' unless defined(&LDT_entry_a);
	eval 'sub LDT_entry_b {
	    my($info) = @_;
    	    eval q(((($info)-> &base_addr & 0xff000000) | ((($info)-> &base_addr & 0xff0000) >> 16) | (($info)-> &limit & 0xf0000) | ((($info)-> &read_exec_only ^ 1) << 9) | (($info)-> &contents << 10) | ((($info)-> &seg_not_present ^ 1) << 15) | (($info)-> &seg_32bit << 22) | (($info)-> &limit_in_pages << 23) | (($info)-> &useable << 20) | 0x7000));
	}' unless defined(&LDT_entry_b);
	eval 'sub LDT_empty {
	    my($info) = @_;
    	    eval q(( ($info)-> &base_addr == 0 && ($info)-> &limit == 0 && ($info)-> &contents == 0 && ($info)-> &read_exec_only == 1 && ($info)-> &seg_32bit == 0 && ($info)-> &limit_in_pages == 0 && ($info)-> &seg_not_present == 1 && ($info)-> &useable == 0));
	}' unless defined(&LDT_empty);
	if((defined(&TLS_SIZE) ? &TLS_SIZE : 0) != 24) {
	    die("update\ this\ code\.");
	}
	eval 'sub load_TLS {
	    my($t,$cpu) = @_;
    	    eval q({  &define  &C( &i)  &per_cpu( &cpu_gdt_table, $cpu)[ &GDT_ENTRY_TLS_MIN +  &i] =  ($t->{tls_array[&i]})   &C(0);  &C(1);  &C(2);  &undef  &C });
	}' unless defined(&load_TLS);
	eval 'sub clear_LDT {
	    my($void) = @_;
    	    eval q({ \'int\'  &cpu =  &get_cpu();  &set_ldt_desc( &cpu,  $default_ldt[0], 5);  &load_LDT_desc();  &put_cpu(); });
	}' unless defined(&clear_LDT);
	eval 'sub load_LDT {
	    my($pc) = @_;
    	    eval q({ \'int\'  &cpu =  &get_cpu();  &load_LDT_nolock($pc,  &cpu);  &put_cpu(); });
	}' unless defined(&load_LDT);
	eval 'sub get_desc_base {
	    my($desc) = @_;
    	    eval q({ my $base;  $base = (($desc->[0] >> 16) & 0xffff) | (($desc->[1] << 16) & 0xff0000) | ($desc->[1] & 0xff000000);  $base; });
	}' unless defined(&get_desc_base);
    }
}
1;
