require '_h2ph_pre.ph';

no warnings 'redefine';

unless(defined(&__LINUX_KVM_H)) {
    eval 'sub __LINUX_KVM_H () {1;}' unless defined(&__LINUX_KVM_H);
    require 'asm/types.ph';
    require 'linux/ioctl.ph';
    eval 'sub KVM_API_VERSION () {12;}' unless defined(&KVM_API_VERSION);
    eval 'sub KVM_NR_INTERRUPTS () {256;}' unless defined(&KVM_NR_INTERRUPTS);
    eval 'sub KVM_IRQ_BITMAP_SIZE_BYTES () {(( &KVM_NR_INTERRUPTS + 7) / 8);}' unless defined(&KVM_IRQ_BITMAP_SIZE_BYTES);
    eval 'sub KVM_IRQ_BITMAP_SIZE {
        my($type) = @_;
	    eval q(( &KVM_IRQ_BITMAP_SIZE_BYTES / $sizeof{$type}));
    }' unless defined(&KVM_IRQ_BITMAP_SIZE);
    eval 'sub KVM_MEM_LOG_DIRTY_PAGES () {1;}' unless defined(&KVM_MEM_LOG_DIRTY_PAGES);
    eval("sub KVM_EXIT_UNKNOWN () { 0; }") unless defined(&KVM_EXIT_UNKNOWN);
    eval("sub KVM_EXIT_EXCEPTION () { 1; }") unless defined(&KVM_EXIT_EXCEPTION);
    eval("sub KVM_EXIT_IO () { 2; }") unless defined(&KVM_EXIT_IO);
    eval("sub KVM_EXIT_HYPERCALL () { 3; }") unless defined(&KVM_EXIT_HYPERCALL);
    eval("sub KVM_EXIT_DEBUG () { 4; }") unless defined(&KVM_EXIT_DEBUG);
    eval("sub KVM_EXIT_HLT () { 5; }") unless defined(&KVM_EXIT_HLT);
    eval("sub KVM_EXIT_MMIO () { 6; }") unless defined(&KVM_EXIT_MMIO);
    eval("sub KVM_EXIT_IRQ_WINDOW_OPEN () { 7; }") unless defined(&KVM_EXIT_IRQ_WINDOW_OPEN);
    eval("sub KVM_EXIT_SHUTDOWN () { 8; }") unless defined(&KVM_EXIT_SHUTDOWN);
    eval("sub KVM_EXIT_FAIL_ENTRY () { 9; }") unless defined(&KVM_EXIT_FAIL_ENTRY);
    eval("sub KVM_EXIT_INTR () { 10; }") unless defined(&KVM_EXIT_INTR);
    eval 'sub KVM_EXIT_IO_IN () {0;}' unless defined(&KVM_EXIT_IO_IN);
    eval 'sub KVM_EXIT_IO_OUT () {1;}' unless defined(&KVM_EXIT_IO_OUT);
    eval 'sub KVMIO () {0xae;}' unless defined(&KVMIO);
    eval 'sub KVM_GET_API_VERSION () { &_IO( &KVMIO, 0x);}' unless defined(&KVM_GET_API_VERSION);
    eval 'sub KVM_CREATE_VM () { &_IO( &KVMIO, 0x1);}' unless defined(&KVM_CREATE_VM);
    eval 'sub KVM_GET_MSR_INDEX_LIST () { &_IOWR( &KVMIO, 0x2, \'struct kvm_msr_list\');}' unless defined(&KVM_GET_MSR_INDEX_LIST);
    eval 'sub KVM_CHECK_EXTENSION () { &_IO( &KVMIO, 0x3);}' unless defined(&KVM_CHECK_EXTENSION);
    eval 'sub KVM_GET_VCPU_MMAP_SIZE () { &_IO( &KVMIO, 0x4);}' unless defined(&KVM_GET_VCPU_MMAP_SIZE);
    eval 'sub KVM_SET_MEMORY_REGION () { &_IOW( &KVMIO, 0x40, \'struct kvm_memory_region\');}' unless defined(&KVM_SET_MEMORY_REGION);
    eval 'sub KVM_CREATE_VCPU () { &_IO( &KVMIO, 0x41);}' unless defined(&KVM_CREATE_VCPU);
    eval 'sub KVM_GET_DIRTY_LOG () { &_IOW( &KVMIO, 0x42, \'struct kvm_dirty_log\');}' unless defined(&KVM_GET_DIRTY_LOG);
    eval 'sub KVM_SET_MEMORY_ALIAS () { &_IOW( &KVMIO, 0x43, \'struct kvm_memory_alias\');}' unless defined(&KVM_SET_MEMORY_ALIAS);
    eval 'sub KVM_RUN () { &_IO( &KVMIO, 0x80);}' unless defined(&KVM_RUN);
    eval 'sub KVM_GET_REGS () { &_IOR( &KVMIO, 0x81, \'struct kvm_regs\');}' unless defined(&KVM_GET_REGS);
    eval 'sub KVM_SET_REGS () { &_IOW( &KVMIO, 0x82, \'struct kvm_regs\');}' unless defined(&KVM_SET_REGS);
    eval 'sub KVM_GET_SREGS () { &_IOR( &KVMIO, 0x83, \'struct kvm_sregs\');}' unless defined(&KVM_GET_SREGS);
    eval 'sub KVM_SET_SREGS () { &_IOW( &KVMIO, 0x84, \'struct kvm_sregs\');}' unless defined(&KVM_SET_SREGS);
    eval 'sub KVM_TRANSLATE () { &_IOWR( &KVMIO, 0x85, \'struct kvm_translation\');}' unless defined(&KVM_TRANSLATE);
    eval 'sub KVM_INTERRUPT () { &_IOW( &KVMIO, 0x86, \'struct kvm_interrupt\');}' unless defined(&KVM_INTERRUPT);
    eval 'sub KVM_DEBUG_GUEST () { &_IOW( &KVMIO, 0x87, \'struct kvm_debug_guest\');}' unless defined(&KVM_DEBUG_GUEST);
    eval 'sub KVM_GET_MSRS () { &_IOWR( &KVMIO, 0x88, \'struct kvm_msrs\');}' unless defined(&KVM_GET_MSRS);
    eval 'sub KVM_SET_MSRS () { &_IOW( &KVMIO, 0x89, \'struct kvm_msrs\');}' unless defined(&KVM_SET_MSRS);
    eval 'sub KVM_SET_CPUID () { &_IOW( &KVMIO, 0x8a, \'struct kvm_cpuid\');}' unless defined(&KVM_SET_CPUID);
    eval 'sub KVM_SET_SIGNAL_MASK () { &_IOW( &KVMIO, 0x8b, \'struct kvm_signal_mask\');}' unless defined(&KVM_SET_SIGNAL_MASK);
    eval 'sub KVM_GET_FPU () { &_IOR( &KVMIO, 0x8c, \'struct kvm_fpu\');}' unless defined(&KVM_GET_FPU);
    eval 'sub KVM_SET_FPU () { &_IOW( &KVMIO, 0x8d, \'struct kvm_fpu\');}' unless defined(&KVM_SET_FPU);
}
1;
