/*
 *  OGF/Graphite: Geometry and Graphics Programming Library + Utilities
 *  Copyright (C) 2000-2015 INRIA - Project ALICE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  If you modify this software, you should include a notice giving the
 *  name of the person performing the modification, the date of modification,
 *  and the reason for such modification.
 *
 *  Contact for Graphite: Bruno Levy - Bruno.Levy@inria.fr
 *  Contact for this Plugin: Nicolas Ray - nicolas.ray@inria.fr
 *
 *     Project ALICE
 *     LORIA, INRIA Lorraine,
 *     Campus Scientifique, BP 239
 *     54506 VANDOEUVRE LES NANCY CEDEX
 *     FRANCE
 *
 *  Note that the GNU General Public License does not permit incorporating
 *  the Software into proprietary programs.
 *
 * As an exception to the GPL, Graphite can be linked with the following
 * (non-GPL) libraries:
 *     Qt, tetgen, SuperLU, WildMagic and CGAL
 */

#include <exploragram/hexdom/sphere_model.h>

namespace GEO {

#ifdef HEXDOM_LOW_RESOLUTION_SPHERE    

    const vec3 SPHERE_MODEL_PTS[SPHERE_MODEL_NB_PTS] = {
	vec3(0, 0, 1),
	vec3(0.894427, 0, 0.447214),
	vec3(0.276393, 0.850651, 0.447214),
	vec3(-0.723607, 0.525731, 0.447214),
	vec3(-0.723607, -0.525731, 0.447214),
	vec3(0.276393, -0.850651, 0.447214),
	vec3(0.723607, 0.525731, -0.447214),
	vec3(0.723607, -0.525731, -0.447214),
	vec3(-0.276393, 0.850651, -0.447214),
	vec3(-0.894427, 0, -0.447214),
	vec3(-0.276393, -0.850651, -0.447214),
	vec3(0, 0, -1),
	vec3(0.525731, 0, 0.850651),
	vec3(0.688191, 0.5, 0.525731),
	vec3(0.16246, 0.5, 0.850651),
	vec3(-0.262866, 0.809017, 0.525731),
	vec3(-0.425325, 0.309017, 0.850651),
	vec3(-0.850651, 0, 0.525731),
	vec3(-0.425325, -0.309017, 0.850651),
	vec3(-0.262866, -0.809017, 0.525731),
	vec3(0.16246, -0.5, 0.850651),
	vec3(0.688191, -0.5, 0.525731),
	vec3(0.587785, -0.809017, -2.61678e-010),
	vec3(0.951057, -0.309017, 4.48188e-008),
	vec3(0.850651, 0, -0.525731),
	vec3(0.951057, 0.309017, 4.48188e-008),
	vec3(0.587785, 0.809017, -2.61678e-010),
	vec3(0.262866, 0.809017, -0.525731),
	vec3(0, 1, 0),
	vec3(-0.587785, 0.809017, 2.61678e-010),
	vec3(-0.688191, 0.5, -0.525731),
	vec3(-0.951057, 0.309017, -4.48188e-008),
	vec3(-0.951057, -0.309017, -4.48188e-008),
	vec3(-0.688191, -0.5, -0.525731),
	vec3(-0.587785, -0.809017, 2.61678e-010),
	vec3(0, -1, 0),
	vec3(0.262866, -0.809017, -0.525731),
	vec3(0.425325, -0.309017, -0.850651),
	vec3(0.425325, 0.309017, -0.850651),
	vec3(-0.16246, 0.5, -0.850651),
	vec3(-0.16246, -0.5, -0.850651),
	vec3(-0.525731, 0, -0.850651),
	vec3(0.273267, 0, 0.961938),
	vec3(0.822619, 0.259892, 0.505721),
	vec3(0.228109, 0.702046, 0.674609),
	vec3(0.00703146, 0.862668, 0.505721),
	vec3(-0.597196, 0.433889, 0.674609),
	vec3(-0.818274, 0.273267, 0.505721),
	vec3(-0.597196, -0.433889, 0.674609),
	vec3(-0.512752, -0.69378, 0.505721),
	vec3(0.228109, -0.702046, 0.674609),
	vec3(0.501375, -0.702046, 0.505721),
	vec3(0.449186, -0.862668, 0.232454),
	vec3(0.870463, -0.433889, -0.232454),
	vec3(0.818274, -0.273267, -0.505721),
	vec3(0.870463, 0.433889, -0.232454),
	vec3(0.68164, 0.69378, -0.232454),
	vec3(0.512752, 0.69378, -0.505721),
	vec3(-0.143665, 0.961938, -0.232454),
	vec3(-0.449186, 0.862668, -0.232454),
	vec3(-0.501375, 0.702046, -0.505721),
	vec3(-0.959253, 0.160622, -0.232454),
	vec3(-0.959253, -0.160622, -0.232454),
	vec3(-0.822619, -0.259892, -0.505721),
	vec3(-0.449186, -0.862668, -0.232454),
	vec3(-0.143665, -0.961938, -0.232454),
	vec3(-0.00703146, -0.862668, -0.505721),
	vec3(0.597196, -0.433889, -0.674609),
	vec3(0.221077, 0.160622, -0.961938),
	vec3(-0.084444, 0.259892, -0.961938),
	vec3(-0.228109, -0.702046, -0.674609),
	vec3(-0.273267, 0, -0.961938),
	vec3(0.738175, 0, 0.674609),
	vec3(0.501375, 0.702046, 0.505721),
	vec3(0.084444, 0.259892, 0.961938),
	vec3(-0.512752, 0.69378, 0.505721),
	vec3(-0.221077, 0.160622, 0.961938),
	vec3(-0.818274, -0.273267, 0.505721),
	vec3(-0.221077, -0.160622, 0.961938),
	vec3(0.00703146, -0.862668, 0.505721),
	vec3(0.084444, -0.259892, 0.961938),
	vec3(0.822619, -0.259892, 0.505721),
	vec3(0.68164, -0.69378, -0.232454),
	vec3(0.959253, -0.160622, 0.232454),
	vec3(0.818274, 0.273267, -0.505721),
	vec3(0.959253, 0.160622, 0.232454),
	vec3(0.449186, 0.862668, 0.232454),
	vec3(-0.00703146, 0.862668, -0.505721),
	vec3(0.143665, 0.961938, 0.232454),
	vec3(-0.68164, 0.69378, 0.232454),
	vec3(-0.822619, 0.259892, -0.505721),
	vec3(-0.870463, 0.433889, 0.232454),
	vec3(-0.870463, -0.433889, 0.232454),
	vec3(-0.501375, -0.702046, -0.505721),
	vec3(-0.68164, -0.69378, 0.232454),
	vec3(0.143665, -0.961938, 0.232454),
	vec3(0.512752, -0.69378, -0.505721),
	vec3(0.221077, -0.160622, -0.961938),
	vec3(0.597196, 0.433889, -0.674609),
	vec3(-0.228109, 0.702046, -0.674609),
	vec3(-0.084444, -0.259892, -0.961938),
	vec3(-0.738175, 0, -0.674609),
	vec3(0.447214, 0.525731, 0.723607),
	vec3(0.361803, 0.262866, 0.894427),
	vec3(0.638197, 0.262866, 0.723607),
	vec3(-0.361803, 0.587785, 0.723607),
	vec3(-0.138197, 0.425325, 0.894427),
	vec3(-0.0527864, 0.688191, 0.723607),
	vec3(-0.67082, -0.16246, 0.723607),
	vec3(-0.447214, 0, 0.894427),
	vec3(-0.67082, 0.16246, 0.723607),
	vec3(-0.0527864, -0.688191, 0.723607),
	vec3(-0.138197, -0.425325, 0.894427),
	vec3(-0.361803, -0.587785, 0.723607),
	vec3(0.638197, -0.262866, 0.723607),
	vec3(0.361803, -0.262866, 0.894427),
	vec3(0.447214, -0.525731, 0.723607),
	vec3(0.809017, -0.587785, 2.34251e-008),
	vec3(0.861803, -0.425325, 0.276393),
	vec3(0.67082, -0.688191, 0.276393),
	vec3(0.947214, 0.16246, -0.276393),
	vec3(1, 0, 4.71253e-008),
	vec3(0.947214, -0.16246, -0.276393),
	vec3(0.67082, 0.688191, 0.276393),
	vec3(0.861803, 0.425325, 0.276393),
	vec3(0.809017, 0.587785, 2.34251e-008),
	vec3(0.138197, 0.951057, -0.276393),
	vec3(0.309017, 0.951057, -1.37573e-010),
	vec3(0.447214, 0.850651, -0.276393),
	vec3(-0.447214, 0.850651, 0.276393),
	vec3(-0.138197, 0.951057, 0.276393),
	vec3(-0.309017, 0.951057, 1.37573e-010),
	vec3(-0.861803, 0.425325, -0.276393),
	vec3(-0.809017, 0.587785, -2.34251e-008),
	vec3(-0.67082, 0.688191, -0.276393),
	vec3(-0.947214, -0.16246, 0.276393),
	vec3(-0.947214, 0.16246, 0.276393),
	vec3(-1, 0, -4.71253e-008),
	vec3(-0.67082, -0.688191, -0.276393),
	vec3(-0.809017, -0.587785, -2.34251e-008),
	vec3(-0.861803, -0.425325, -0.276393),
	vec3(-0.138197, -0.951057, 0.276393),
	vec3(-0.447214, -0.850651, 0.276393),
	vec3(-0.309017, -0.951057, 1.37573e-010),
	vec3(0.447214, -0.850651, -0.276393),
	vec3(0.309017, -0.951057, -1.37573e-010),
	vec3(0.138197, -0.951057, -0.276393),
	vec3(0.447214, 0, -0.894427),
	vec3(0.67082, 0.16246, -0.723607),
	vec3(0.67082, -0.16246, -0.723607),
	vec3(0.0527864, 0.688191, -0.723607),
	vec3(0.361803, 0.587785, -0.723607),
	vec3(0.138197, 0.425325, -0.894427),
	vec3(0.138197, -0.425325, -0.894427),
	vec3(0.361803, -0.587785, -0.723607),
	vec3(0.0527864, -0.688191, -0.723607),
	vec3(-0.638197, 0.262866, -0.723607),
	vec3(-0.447214, 0.525731, -0.723607),
	vec3(-0.361803, 0.262866, -0.894427),
	vec3(-0.447214, -0.525731, -0.723607),
	vec3(-0.638197, -0.262866, -0.723607),
	vec3(-0.361803, -0.262866, -0.894427),
	vec3(0.137952, 0, 0.990439),
	vec3(0.866811, 0.1312, 0.481067),
	vec3(0.254686, 0.783843, 0.566326),
	vec3(0.14308, 0.864929, 0.481067),
	vec3(-0.666777, 0.484442, 0.566326),
	vec3(-0.778382, 0.403355, 0.481067),
	vec3(-0.666777, -0.484442, 0.566326),
	vec3(-0.624147, -0.615642, 0.481067),
	vec3(0.254686, -0.783843, 0.566326),
	vec3(0.392638, -0.783843, 0.481067),
	vec3(0.366292, -0.864929, 0.343115),
	vec3(0.804729, -0.484442, -0.343115),
	vec3(0.778382, -0.403355, -0.481067),
	vec3(0.804729, 0.484442, -0.343115),
	vec3(0.709406, 0.615642, -0.343115),
	vec3(0.624147, 0.615642, -0.481067),
	vec3(-0.212056, 0.915043, -0.343115),
	vec3(-0.366292, 0.864929, -0.343115),
	vec3(-0.392638, 0.783843, -0.481067),
	vec3(-0.935787, 0.0810863, -0.343115),
	vec3(-0.935787, -0.0810863, -0.343115),
	vec3(-0.866811, -0.1312, -0.481067),
	vec3(-0.366292, -0.864929, -0.343115),
	vec3(-0.212056, -0.915043, -0.343115),
	vec3(-0.14308, -0.864929, -0.481067),
	vec3(0.666777, -0.484442, -0.566326),
	vec3(0.111606, 0.0810863, -0.990439),
	vec3(-0.0426296, 0.1312, -0.990439),
	vec3(-0.254686, -0.783843, -0.566326),
	vec3(-0.137952, 0, -0.990439),
	vec3(0.638054, 0, 0.769992),
	vec3(0.600525, 0.606825, 0.520705),
	vec3(0.124644, 0.383614, 0.915043),
	vec3(-0.391553, 0.758652, 0.520705),
	vec3(-0.326321, 0.237086, 0.915043),
	vec3(-0.842518, -0.137952, 0.520705),
	vec3(-0.326321, -0.237086, 0.915043),
	vec3(-0.129152, -0.843911, 0.520705),
	vec3(0.124644, -0.383614, 0.915043),
	vec3(0.762697, -0.383614, 0.520705),
	vec3(0.64084, -0.758652, -0.117349),
	vec3(0.964375, -0.237086, 0.117349),
	vec3(0.842518, 0.137952, -0.520705),
	vec3(0.964375, 0.237086, 0.117349),
	vec3(0.523491, 0.843911, 0.117349),
	vec3(0.129152, 0.843911, -0.520705),
	vec3(0.0725258, 0.990439, 0.117349),
	vec3(-0.64084, 0.758652, 0.117349),
	vec3(-0.762697, 0.383614, -0.520705),
	vec3(-0.919552, 0.375039, 0.117349),
	vec3(-0.919552, -0.375039, 0.117349),
	vec3(-0.600525, -0.606825, -0.520705),
	vec3(-0.64084, -0.758652, 0.117349),
	vec3(0.0725258, -0.990439, 0.117349),
	vec3(0.391553, -0.758652, -0.520705),
	vec3(0.326321, -0.237086, -0.915043),
	vec3(0.516196, 0.375039, -0.769992),
	vec3(-0.197169, 0.606825, -0.769992),
	vec3(-0.124644, -0.383614, -0.915043),
	vec3(-0.638054, 0, -0.769992),
	vec3(0.308637, 0.519258, 0.79694),
	vec3(0.449299, 0.133071, 0.883415),
	vec3(0.671461, 0.386187, 0.632456),
	vec3(-0.39847, 0.453991, 0.79694),
	vec3(0.0122828, 0.46843, 0.883415),
	vec3(-0.159793, 0.757935, 0.632456),
	vec3(-0.554905, -0.238677, 0.79694),
	vec3(-0.441708, 0.156434, 0.883415),
	vec3(-0.770218, 0.0822425, 0.632456),
	vec3(0.0555203, -0.601501, 0.79694),
	vec3(-0.285273, -0.371748, 0.883415),
	vec3(-0.316228, -0.707107, 0.632456),
	vec3(0.589218, -0.133071, 0.79694),
	vec3(0.265399, -0.386187, 0.883415),
	vec3(0.574779, -0.519258, 0.632456),
	vec3(0.891007, -0.453991, 3.45473e-008),
	vec3(0.784658, -0.46843, 0.406061),
	vec3(0.637147, -0.757935, 0.139919),
	vec3(0.960966, 0.238677, -0.139919),
	vec3(0.987688, -0.156434, 4.65451e-008),
	vec3(0.910138, -0.0822425, -0.406061),
	vec3(0.687976, 0.601501, 0.406061),
	vec3(0.917729, 0.371748, 0.139919),
	vec3(0.707107, 0.707107, 1.17261e-008),
	vec3(0.0699596, 0.987688, -0.139919),
	vec3(0.45399, 0.891007, -2.02114e-010),
	vec3(0.359465, 0.840178, -0.406061),
	vec3(-0.359465, 0.840178, 0.406061),
	vec3(-0.0699596, 0.987688, 0.139919),
	vec3(-0.45399, 0.891007, 2.02114e-010),
	vec3(-0.917729, 0.371748, -0.139919),
	vec3(-0.707107, 0.707107, -1.17261e-008),
	vec3(-0.687976, 0.601501, -0.406061),
	vec3(-0.910138, -0.0822425, 0.406061),
	vec3(-0.960966, 0.238677, 0.139919),
	vec3(-0.987688, -0.156434, -4.65451e-008),
	vec3(-0.637147, -0.757935, -0.139919),
	vec3(-0.891007, -0.453991, -3.45473e-008),
	vec3(-0.784658, -0.46843, -0.406061),
	vec3(-0.203031, -0.891007, 0.406061),
	vec3(-0.52395, -0.840178, 0.139919),
	vec3(-0.156434, -0.987688, 6.96437e-011),
	vec3(0.52395, -0.840178, -0.139919),
	vec3(0.156434, -0.987688, -6.96437e-011),
	vec3(0.203031, -0.891007, -0.406061),
	vec3(0.441708, 0.156434, -0.883415),
	vec3(0.770218, 0.0822425, -0.632456),
	vec3(0.554905, -0.238677, -0.79694),
	vec3(0.159793, 0.757935, -0.632456),
	vec3(0.39847, 0.453991, -0.79694),
	vec3(-0.0122828, 0.46843, -0.883415),
	vec3(0.285273, -0.371748, -0.883415),
	vec3(0.316228, -0.707107, -0.632456),
	vec3(-0.0555203, -0.601501, -0.79694),
	vec3(-0.671461, 0.386187, -0.632456),
	vec3(-0.308637, 0.519258, -0.79694),
	vec3(-0.449299, 0.133071, -0.883415),
	vec3(-0.574779, -0.519258, -0.632456),
	vec3(-0.589218, -0.133071, -0.79694),
	vec3(-0.265399, -0.386187, -0.883415),
	vec3(0.403355, 0, 0.915043),
	vec3(0.762697, 0.383614, 0.520705),
	vec3(0.197169, 0.606825, 0.769992),
	vec3(-0.129152, 0.843911, 0.520705),
	vec3(-0.516196, 0.375039, 0.769992),
	vec3(-0.842518, 0.137952, 0.520705),
	vec3(-0.516196, -0.375039, 0.769992),
	vec3(-0.391553, -0.758652, 0.520705),
	vec3(0.197169, -0.606825, 0.769992),
	vec3(0.600525, -0.606825, 0.520705),
	vec3(0.523491, -0.843911, 0.117349),
	vec3(0.919552, -0.375039, -0.117349),
	vec3(0.842518, -0.137952, -0.520705),
	vec3(0.919552, 0.375039, -0.117349),
	vec3(0.64084, 0.758652, -0.117349),
	vec3(0.391553, 0.758652, -0.520705),
	vec3(-0.0725258, 0.990439, -0.117349),
	vec3(-0.523491, 0.843911, -0.117349),
	vec3(-0.600525, 0.606825, -0.520705),
	vec3(-0.964375, 0.237086, -0.117349),
	vec3(-0.964375, -0.237086, -0.117349),
	vec3(-0.762697, -0.383614, -0.520705),
	vec3(-0.523491, -0.843911, -0.117349),
	vec3(-0.0725258, -0.990439, -0.117349),
	vec3(0.129152, -0.843911, -0.520705),
	vec3(0.516196, -0.375039, -0.769992),
	vec3(0.326321, 0.237086, -0.915043),
	vec3(-0.124644, 0.383614, -0.915043),
	vec3(-0.197169, -0.606825, -0.769992),
	vec3(-0.403355, 0, -0.915043),
	vec3(0.824181, 0, 0.566326),
	vec3(0.392638, 0.783843, 0.481067),
	vec3(0.0426296, 0.1312, 0.990439),
	vec3(-0.624147, 0.615642, 0.481067),
	vec3(-0.111606, 0.0810863, 0.990439),
	vec3(-0.778382, -0.403355, 0.481067),
	vec3(-0.111606, -0.0810863, 0.990439),
	vec3(0.14308, -0.864929, 0.481067),
	vec3(0.0426296, -0.1312, 0.990439),
	vec3(0.866811, -0.1312, 0.481067),
	vec3(0.709406, -0.615642, -0.343115),
	vec3(0.935787, -0.0810863, 0.343115),
	vec3(0.778382, 0.403355, -0.481067),
	vec3(0.935787, 0.0810863, 0.343115),
	vec3(0.366292, 0.864929, 0.343115),
	vec3(-0.14308, 0.864929, -0.481067),
	vec3(0.212056, 0.915043, 0.343115),
	vec3(-0.709406, 0.615642, 0.343115),
	vec3(-0.866811, 0.1312, -0.481067),
	vec3(-0.804729, 0.484442, 0.343115),
	vec3(-0.804729, -0.484442, 0.343115),
	vec3(-0.392638, -0.783843, -0.481067),
	vec3(-0.709406, -0.615642, 0.343115),
	vec3(0.212056, -0.915043, 0.343115),
	vec3(0.624147, -0.615642, -0.481067),
	vec3(0.111606, -0.0810863, -0.990439),
	vec3(0.666777, 0.484442, -0.566326),
	vec3(-0.254686, 0.783843, -0.566326),
	vec3(-0.0426296, -0.1312, -0.990439),
	vec3(-0.824181, 0, -0.566326),
	vec3(0.574779, 0.519258, 0.632456),
	vec3(0.265399, 0.386187, 0.883415),
	vec3(0.589218, 0.133071, 0.79694),
	vec3(-0.316228, 0.707107, 0.632456),
	vec3(-0.285273, 0.371748, 0.883415),
	vec3(0.0555203, 0.601501, 0.79694),
	vec3(-0.770218, -0.0822425, 0.632456),
	vec3(-0.441708, -0.156434, 0.883415),
	vec3(-0.554905, 0.238677, 0.79694),
	vec3(-0.159793, -0.757935, 0.632456),
	vec3(0.0122828, -0.46843, 0.883415),
	vec3(-0.39847, -0.453991, 0.79694),
	vec3(0.671461, -0.386187, 0.632456),
	vec3(0.449299, -0.133071, 0.883415),
	vec3(0.308637, -0.519258, 0.79694),
	vec3(0.707107, -0.707107, 1.17261e-008),
	vec3(0.917729, -0.371748, 0.139919),
	vec3(0.687976, -0.601501, 0.406061),
	vec3(0.910138, 0.0822425, -0.406061),
	vec3(0.987688, 0.156434, 4.65451e-008),
	vec3(0.960966, -0.238677, -0.139919),
	vec3(0.637147, 0.757935, 0.139919),
	vec3(0.784658, 0.46843, 0.406061),
	vec3(0.891007, 0.453991, 3.45473e-008),
	vec3(0.203031, 0.891007, -0.406061),
	vec3(0.156434, 0.987688, -6.96437e-011),
	vec3(0.52395, 0.840178, -0.139919),
	vec3(-0.52395, 0.840178, 0.139919),
	vec3(-0.203031, 0.891007, 0.406061),
	vec3(-0.156434, 0.987688, 6.96437e-011),
	vec3(-0.784658, 0.46843, -0.406061),
	vec3(-0.891007, 0.453991, -3.45473e-008),
	vec3(-0.637147, 0.757935, -0.139919),
	vec3(-0.960966, -0.238677, 0.139919),
	vec3(-0.910138, 0.0822425, 0.406061),
	vec3(-0.987688, 0.156434, -4.65451e-008),
	vec3(-0.687976, -0.601501, -0.406061),
	vec3(-0.707107, -0.707107, -1.17261e-008),
	vec3(-0.917729, -0.371748, -0.139919),
	vec3(-0.0699596, -0.987688, 0.139919),
	vec3(-0.359465, -0.840178, 0.406061),
	vec3(-0.45399, -0.891007, 2.02114e-010),
	vec3(0.359465, -0.840178, -0.406061),
	vec3(0.45399, -0.891007, -2.02114e-010),
	vec3(0.0699596, -0.987688, -0.139919),
	vec3(0.441708, -0.156434, -0.883415),
	vec3(0.554905, 0.238677, -0.79694),
	vec3(0.770218, -0.0822425, -0.632456),
	vec3(-0.0555203, 0.601501, -0.79694),
	vec3(0.316228, 0.707107, -0.632456),
	vec3(0.285273, 0.371748, -0.883415),
	vec3(-0.0122828, -0.46843, -0.883415),
	vec3(0.39847, -0.453991, -0.79694),
	vec3(0.159793, -0.757935, -0.632456),
	vec3(-0.589218, 0.133071, -0.79694),
	vec3(-0.574779, 0.519258, -0.632456),
	vec3(-0.265399, 0.386187, -0.883415),
	vec3(-0.308637, -0.519258, -0.79694),
	vec3(-0.671461, -0.386187, -0.632456),
	vec3(-0.449299, -0.133071, -0.883415),
	vec3(0.409955, 0.399607, 0.819909),
	vec3(0.506732, 0.266405, 0.819909),
	vec3(0.550012, 0.399607, 0.733349),
	vec3(-0.253366, 0.513375, 0.819909),
	vec3(-0.0967772, 0.564254, 0.819909),
	vec3(-0.210086, 0.646578, 0.733349),
	vec3(-0.566543, -0.0823236, 0.819909),
	vec3(-0.566543, 0.0823236, 0.819909),
	vec3(-0.679852, 0, 0.733349),
	vec3(-0.0967772, -0.564254, 0.819909),
	vec3(-0.253366, -0.513375, 0.819909),
	vec3(-0.210086, -0.646578, 0.733349),
	vec3(0.506732, -0.266405, 0.819909),
	vec3(0.409955, -0.399607, 0.819909),
	vec3(0.550012, -0.399607, 0.733349),
	vec3(0.846658, -0.513375, 0.140057),
	vec3(0.776629, -0.564254, 0.280115),
	vec3(0.749881, -0.646578, 0.140057),
	vec3(0.986715, 0.0823236, -0.140057),
	vec3(0.986715, -0.0823236, -0.140057),
	vec3(0.959967, 0, -0.280114),
	vec3(0.776629, 0.564254, 0.280115),
	vec3(0.846658, 0.513375, 0.140057),
	vec3(0.749881, 0.646578, 0.140057),
	vec3(0.226617, 0.963861, -0.140057),
	vec3(0.383206, 0.912982, -0.140057),
	vec3(0.296646, 0.912982, -0.280114),
	vec3(-0.296646, 0.912982, 0.280114),
	vec3(-0.226617, 0.963861, 0.140057),
	vec3(-0.383206, 0.912982, 0.140057),
	vec3(-0.846658, 0.513375, -0.140057),
	vec3(-0.749881, 0.646578, -0.140057),
	vec3(-0.776629, 0.564254, -0.280115),
	vec3(-0.959967, 0, 0.280114),
	vec3(-0.986715, 0.0823236, 0.140057),
	vec3(-0.986715, -0.0823236, 0.140057),
	vec3(-0.749881, -0.646578, -0.140057),
	vec3(-0.846658, -0.513375, -0.140057),
	vec3(-0.776629, -0.564254, -0.280115),
	vec3(-0.296646, -0.912982, 0.280114),
	vec3(-0.383206, -0.912982, 0.140057),
	vec3(-0.226617, -0.963861, 0.140057),
	vec3(0.383206, -0.912982, -0.140057),
	vec3(0.226617, -0.963861, -0.140057),
	vec3(0.296646, -0.912982, -0.280114),
	vec3(0.566543, 0.0823236, -0.819909),
	vec3(0.679852, 0, -0.733349),
	vec3(0.566543, -0.0823236, -0.819909),
	vec3(0.210086, 0.646578, -0.733349),
	vec3(0.253366, 0.513375, -0.819909),
	vec3(0.0967772, 0.564254, -0.819909),
	vec3(0.253366, -0.513375, -0.819909),
	vec3(0.210086, -0.646578, -0.733349),
	vec3(0.0967772, -0.564254, -0.819909),
	vec3(-0.550012, 0.399607, -0.733349),
	vec3(-0.409955, 0.399607, -0.819909),
	vec3(-0.506732, 0.266405, -0.819909),
	vec3(-0.550012, -0.399607, -0.733349),
	vec3(-0.506732, -0.266405, -0.819909),
	vec3(-0.409955, -0.399607, -0.819909),
	vec3(0.36954, 0.711282, 0.597928),
	vec3(0.341154, 0.62024, 0.70634),
	vec3(0.479201, 0.62024, 0.621023),
	vec3(0.181208, 0.131655, 0.974592),
	vec3(0.32082, 0.132792, 0.937785),
	vec3(0.225432, 0.264083, 0.937785),
	vec3(0.790663, 0.131655, 0.597928),
	vec3(0.737964, 0.264083, 0.621023),
	vec3(0.695305, 0.132792, 0.70634),
	vec3(-0.562275, 0.571252, 0.597928),
	vec3(-0.48446, 0.516122, 0.70634),
	vec3(-0.441802, 0.647412, 0.621023),
	vec3(-0.0692153, 0.213023, 0.974592),
	vec3(-0.0271543, 0.346153, 0.937785),
	vec3(-0.181495, 0.296005, 0.937785),
	vec3(0.119117, 0.792649, 0.597928),
	vec3(-0.0231141, 0.783452, 0.621023),
	vec3(0.088568, 0.70231, 0.70634),
	vec3(-0.717045, -0.358229, 0.597928),
	vec3(-0.640567, -0.301259, 0.70634),
	vec3(-0.75225, -0.220117, 0.621023),
	vec3(-0.223985, 0, 0.974592),
	vec3(-0.337602, 0.0811419, 0.937785),
	vec3(-0.337602, -0.0811419, 0.937785),
	vec3(-0.717045, 0.358229, 0.597928),
	vec3(-0.75225, 0.220117, 0.621023),
	vec3(-0.640567, 0.301259, 0.70634),
	vec3(0.119117, -0.792649, 0.597928),
	vec3(0.088568, -0.70231, 0.70634),
	vec3(-0.0231141, -0.783452, 0.621023),
	vec3(-0.0692153, -0.213023, 0.974592),
	vec3(-0.181495, -0.296005, 0.937785),
	vec3(-0.0271543, -0.346153, 0.937785),
	vec3(-0.562275, -0.571252, 0.597928),
	vec3(-0.441802, -0.647412, 0.621023),
	vec3(-0.48446, -0.516122, 0.70634),
	vec3(0.790663, -0.131655, 0.597928),
	vec3(0.695305, -0.132792, 0.70634),
	vec3(0.737964, -0.264083, 0.621023),
	vec3(0.181208, -0.131655, 0.974592),
	vec3(0.225432, -0.264083, 0.937785),
	vec3(0.32082, -0.132792, 0.937785),
	vec3(0.36954, -0.711282, 0.597928),
	vec3(0.479201, -0.62024, 0.621023),
	vec3(0.341154, -0.62024, 0.70634),
	vec3(0.78626, -0.571252, -0.235512),
	vec3(0.848427, -0.516122, -0.11743),
	vec3(0.753039, -0.647412, -0.11743),
	vec3(0.902656, -0.213023, 0.373943),
	vec3(0.850924, -0.346153, 0.395103),
	vec3(0.919948, -0.296005, 0.257056),
	vec3(0.481533, -0.792649, 0.373943),
	vec3(0.565797, -0.783452, 0.257056),
	vec3(0.592161, -0.70231, 0.395103),
	vec3(0.855476, 0.358229, -0.373943),
	vec3(0.91824, 0.301259, -0.257056),
	vec3(0.891876, 0.220117, -0.395103),
	vec3(0.971871, 0, 0.235512),
	vec3(0.989761, -0.0811419, 0.11743),
	vec3(0.989761, 0.0811419, 0.11743),
	vec3(0.855476, -0.358229, -0.373943),
	vec3(0.891876, -0.220117, -0.395103),
	vec3(0.91824, -0.301259, -0.257056),
	vec3(0.481533, 0.792649, 0.373943),
	vec3(0.592161, 0.70231, 0.395103),
	vec3(0.565797, 0.783452, 0.257056),
	vec3(0.902656, 0.213023, 0.373943),
	vec3(0.919948, 0.296005, 0.257056),
	vec3(0.850924, 0.346153, 0.395103),
	vec3(0.78626, 0.571252, -0.235512),
	vec3(0.753039, 0.647412, -0.11743),
	vec3(0.848427, 0.516122, -0.11743),
	vec3(-0.0763393, 0.924305, -0.373943),
	vec3(-0.00276234, 0.966393, -0.257056),
	vec3(0.066261, 0.916244, -0.395103),
	vec3(0.300325, 0.924305, 0.235512),
	vec3(0.383023, 0.916244, 0.11743),
	vec3(0.228682, 0.966393, 0.11743),
	vec3(0.605052, 0.702907, -0.373943),
	vec3(0.484949, 0.780204, -0.395103),
	vec3(0.570266, 0.780204, -0.257056),
	vec3(-0.605052, 0.702907, 0.373943),
	vec3(-0.484949, 0.780204, 0.395103),
	vec3(-0.570266, 0.780204, 0.257056),
	vec3(0.0763393, 0.924305, 0.373943),
	vec3(0.00276234, 0.966393, 0.257056),
	vec3(-0.066261, 0.916244, 0.395103),
	vec3(-0.300325, 0.924305, -0.235512),
	vec3(-0.383023, 0.916244, -0.11743),
	vec3(-0.228682, 0.966393, -0.11743),
	vec3(-0.902656, 0.213023, -0.373943),
	vec3(-0.919948, 0.296005, -0.257056),
	vec3(-0.850924, 0.346153, -0.395103),
	vec3(-0.78626, 0.571252, 0.235512),
	vec3(-0.753039, 0.647412, 0.11743),
	vec3(-0.848427, 0.516122, 0.11743),
	vec3(-0.481533, 0.792649, -0.373943),
	vec3(-0.592161, 0.70231, -0.395103),
	vec3(-0.565797, 0.783452, -0.257056),
	vec3(-0.855476, -0.358229, 0.373943),
	vec3(-0.891876, -0.220117, 0.395103),
	vec3(-0.91824, -0.301259, 0.257056),
	vec3(-0.855476, 0.358229, 0.373943),
	vec3(-0.91824, 0.301259, 0.257056),
	vec3(-0.891876, 0.220117, 0.395103),
	vec3(-0.971871, 0, -0.235512),
	vec3(-0.989761, -0.0811419, -0.11743),
	vec3(-0.989761, 0.0811419, -0.11743),
	vec3(-0.481533, -0.792649, -0.373943),
	vec3(-0.565797, -0.783452, -0.257056),
	vec3(-0.592161, -0.70231, -0.395103),
	vec3(-0.78626, -0.571252, 0.235512),
	vec3(-0.848427, -0.516122, 0.11743),
	vec3(-0.753039, -0.647412, 0.11743),
	vec3(-0.902656, -0.213023, -0.373943),
	vec3(-0.850924, -0.346153, -0.395103),
	vec3(-0.919948, -0.296005, -0.257056),
	vec3(0.0763393, -0.924305, 0.373943),
	vec3(-0.066261, -0.916244, 0.395103),
	vec3(0.00276234, -0.966393, 0.257056),
	vec3(-0.605052, -0.702907, 0.373943),
	vec3(-0.570266, -0.780204, 0.257056),
	vec3(-0.484949, -0.780204, 0.395103),
	vec3(-0.300325, -0.924305, -0.235512),
	vec3(-0.228682, -0.966393, -0.11743),
	vec3(-0.383023, -0.916244, -0.11743),
	vec3(0.605052, -0.702907, -0.373943),
	vec3(0.570266, -0.780204, -0.257056),
	vec3(0.484949, -0.780204, -0.395103),
	vec3(0.300325, -0.924305, 0.235512),
	vec3(0.228682, -0.966393, 0.11743),
	vec3(0.383023, -0.916244, 0.11743),
	vec3(-0.0763393, -0.924305, -0.373943),
	vec3(0.066261, -0.916244, -0.395103),
	vec3(-0.00276234, -0.966393, -0.257056),
	vec3(0.223985, 0, -0.974592),
	vec3(0.337602, 0.0811419, -0.937785),
	vec3(0.337602, -0.0811419, -0.937785),
	vec3(0.717045, 0.358229, -0.597928),
	vec3(0.75225, 0.220117, -0.621023),
	vec3(0.640567, 0.301259, -0.70634),
	vec3(0.717045, -0.358229, -0.597928),
	vec3(0.640567, -0.301259, -0.70634),
	vec3(0.75225, -0.220117, -0.621023),
	vec3(-0.119117, 0.792649, -0.597928),
	vec3(0.0231141, 0.783452, -0.621023),
	vec3(-0.088568, 0.70231, -0.70634),
	vec3(0.562275, 0.571252, -0.597928),
	vec3(0.48446, 0.516122, -0.70634),
	vec3(0.441802, 0.647412, -0.621023),
	vec3(0.0692153, 0.213023, -0.974592),
	vec3(0.0271543, 0.346153, -0.937785),
	vec3(0.181495, 0.296005, -0.937785),
	vec3(0.0692153, -0.213023, -0.974592),
	vec3(0.181495, -0.296005, -0.937785),
	vec3(0.0271543, -0.346153, -0.937785),
	vec3(0.562275, -0.571252, -0.597928),
	vec3(0.441802, -0.647412, -0.621023),
	vec3(0.48446, -0.516122, -0.70634),
	vec3(-0.119117, -0.792649, -0.597928),
	vec3(-0.088568, -0.70231, -0.70634),
	vec3(0.0231141, -0.783452, -0.621023),
	vec3(-0.790663, 0.131655, -0.597928),
	vec3(-0.737964, 0.264083, -0.621023),
	vec3(-0.695305, 0.132792, -0.70634),
	vec3(-0.36954, 0.711282, -0.597928),
	vec3(-0.341154, 0.62024, -0.70634),
	vec3(-0.479201, 0.62024, -0.621023),
	vec3(-0.181208, 0.131655, -0.974592),
	vec3(-0.32082, 0.132792, -0.937785),
	vec3(-0.225432, 0.264083, -0.937785),
	vec3(-0.36954, -0.711282, -0.597928),
	vec3(-0.479201, -0.62024, -0.621023),
	vec3(-0.341154, -0.62024, -0.70634),
	vec3(-0.790663, -0.131655, -0.597928),
	vec3(-0.695305, -0.132792, -0.70634),
	vec3(-0.737964, -0.264083, -0.621023),
	vec3(-0.181208, -0.131655, -0.974592),
	vec3(-0.225432, -0.264083, -0.937785),
	vec3(-0.32082, -0.132792, -0.937785)
    };
    
    const index_t SPHERE_MODEL_TRIANGLES[SPHERE_MODEL_NB_TRIANGLES][3] = {
	{ 403, 404, 402 },
	{ 406, 407, 405 },
	{ 409, 410, 408 },
	{ 412, 413, 411 },
	{ 415, 416, 414 },
	{ 418, 419, 417 },
	{ 421, 422, 420 },
	{ 424, 425, 423 },
	{ 427, 428, 426 },
	{ 430, 431, 429 },
	{ 433, 434, 432 },
	{ 436, 437, 435 },
	{ 439, 440, 438 },
	{ 442, 443, 441 },
	{ 445, 446, 444 },
	{ 448, 449, 447 },
	{ 451, 452, 450 },
	{ 454, 455, 453 },
	{ 457, 458, 456 },
	{ 460, 461, 459 },
	{ 463, 464, 462 },
	{ 466, 467, 465 },
	{ 469, 470, 468 },
	{ 472, 473, 471 },
	{ 475, 476, 474 },
	{ 478, 479, 477 },
	{ 481, 482, 480 },
	{ 484, 485, 483 },
	{ 487, 488, 486 },
	{ 490, 491, 489 },
	{ 493, 494, 492 },
	{ 496, 497, 495 },
	{ 499, 500, 498 },
	{ 502, 503, 501 },
	{ 505, 506, 504 },
	{ 508, 509, 507 },
	{ 511, 512, 510 },
	{ 514, 515, 513 },
	{ 517, 518, 516 },
	{ 520, 521, 519 },
	{ 523, 524, 522 },
	{ 526, 527, 525 },
	{ 529, 530, 528 },
	{ 532, 533, 531 },
	{ 535, 536, 534 },
	{ 538, 539, 537 },
	{ 541, 542, 540 },
	{ 544, 545, 543 },
	{ 547, 548, 546 },
	{ 550, 551, 549 },
	{ 553, 554, 552 },
	{ 556, 557, 555 },
	{ 559, 560, 558 },
	{ 562, 563, 561 },
	{ 565, 566, 564 },
	{ 568, 569, 567 },
	{ 571, 572, 570 },
	{ 574, 575, 573 },
	{ 577, 578, 576 },
	{ 580, 581, 579 },
	{ 583, 584, 582 },
	{ 586, 587, 585 },
	{ 589, 590, 588 },
	{ 592, 593, 591 },
	{ 595, 596, 594 },
	{ 598, 599, 597 },
	{ 601, 602, 600 },
	{ 604, 605, 603 },
	{ 607, 608, 606 },
	{ 610, 611, 609 },
	{ 613, 614, 612 },
	{ 616, 617, 615 },
	{ 619, 620, 618 },
	{ 622, 623, 621 },
	{ 625, 626, 624 },
	{ 628, 629, 627 },
	{ 631, 632, 630 },
	{ 634, 635, 633 },
	{ 637, 638, 636 },
	{ 640, 641, 639 },
	{ 343, 402, 222 },
	{ 344, 403, 223 },
	{ 342, 404, 224 },
	{ 346, 405, 225 },
	{ 347, 406, 226 },
	{ 345, 407, 227 },
	{ 349, 408, 228 },
	{ 350, 409, 229 },
	{ 348, 410, 230 },
	{ 352, 411, 231 },
	{ 353, 412, 232 },
	{ 351, 413, 233 },
	{ 355, 414, 234 },
	{ 356, 415, 235 },
	{ 354, 416, 236 },
	{ 358, 417, 237 },
	{ 359, 418, 238 },
	{ 357, 419, 239 },
	{ 361, 420, 240 },
	{ 362, 421, 241 },
	{ 360, 422, 242 },
	{ 364, 423, 243 },
	{ 365, 424, 244 },
	{ 363, 425, 245 },
	{ 367, 426, 246 },
	{ 368, 427, 247 },
	{ 366, 428, 248 },
	{ 370, 429, 249 },
	{ 371, 430, 250 },
	{ 369, 431, 251 },
	{ 373, 432, 252 },
	{ 374, 433, 253 },
	{ 372, 434, 254 },
	{ 376, 435, 255 },
	{ 377, 436, 256 },
	{ 375, 437, 257 },
	{ 379, 438, 258 },
	{ 380, 439, 259 },
	{ 378, 440, 260 },
	{ 382, 441, 261 },
	{ 383, 442, 262 },
	{ 381, 443, 263 },
	{ 385, 444, 264 },
	{ 386, 445, 265 },
	{ 384, 446, 266 },
	{ 388, 447, 267 },
	{ 389, 448, 268 },
	{ 387, 449, 269 },
	{ 391, 450, 270 },
	{ 392, 451, 271 },
	{ 390, 452, 272 },
	{ 394, 453, 273 },
	{ 395, 454, 274 },
	{ 393, 455, 275 },
	{ 397, 456, 276 },
	{ 398, 457, 277 },
	{ 396, 458, 278 },
	{ 400, 459, 279 },
	{ 401, 460, 280 },
	{ 399, 461, 281 },
	{ 164, 462, 313 },
	{ 222, 463, 284 },
	{ 193, 464, 342 },
	{ 162, 465, 314 },
	{ 223, 466, 282 },
	{ 194, 467, 343 },
	{ 163, 468, 312 },
	{ 224, 469, 283 },
	{ 192, 470, 344 },
	{ 166, 471, 315 },
	{ 225, 472, 286 },
	{ 195, 473, 345 },
	{ 314, 474, 316 },
	{ 226, 475, 194 },
	{ 196, 476, 346 },
	{ 165, 477, 164 },
	{ 227, 478, 285 },
	{ 284, 479, 347 },
	{ 168, 480, 317 },
	{ 228, 481, 288 },
	{ 197, 482, 348 },
	{ 316, 483, 318 },
	{ 229, 484, 196 },
	{ 198, 485, 349 },
	{ 167, 486, 166 },
	{ 230, 487, 287 },
	{ 286, 488, 350 },
	{ 170, 489, 319 },
	{ 231, 490, 290 },
	{ 199, 491, 351 },
	{ 318, 492, 320 },
	{ 232, 493, 198 },
	{ 200, 494, 352 },
	{ 169, 495, 168 },
	{ 233, 496, 289 },
	{ 288, 497, 353 },
	{ 312, 498, 321 },
	{ 234, 499, 192 },
	{ 201, 500, 354 },
	{ 320, 501, 162 },
	{ 235, 502, 200 },
	{ 282, 503, 355 },
	{ 171, 504, 170 },
	{ 236, 505, 291 },
	{ 290, 506, 356 },
	{ 173, 507, 322 },
	{ 237, 508, 293 },
	{ 202, 509, 357 },
	{ 321, 510, 323 },
	{ 238, 511, 201 },
	{ 203, 512, 358 },
	{ 172, 513, 171 },
	{ 239, 514, 292 },
	{ 291, 515, 359 },
	{ 175, 516, 324 },
	{ 240, 517, 295 },
	{ 204, 518, 360 },
	{ 323, 519, 325 },
	{ 241, 520, 203 },
	{ 205, 521, 361 },
	{ 174, 522, 173 },
	{ 242, 523, 294 },
	{ 293, 524, 362 },
	{ 313, 525, 326 },
	{ 243, 526, 193 },
	{ 206, 527, 363 },
	{ 325, 528, 163 },
	{ 244, 529, 205 },
	{ 283, 530, 364 },
	{ 176, 531, 175 },
	{ 245, 532, 296 },
	{ 295, 533, 365 },
	{ 178, 534, 327 },
	{ 246, 535, 298 },
	{ 207, 536, 366 },
	{ 326, 537, 328 },
	{ 247, 538, 206 },
	{ 208, 539, 367 },
	{ 177, 540, 176 },
	{ 248, 541, 297 },
	{ 296, 542, 368 },
	{ 315, 543, 329 },
	{ 249, 544, 195 },
	{ 209, 545, 369 },
	{ 328, 546, 165 },
	{ 250, 547, 208 },
	{ 285, 548, 370 },
	{ 179, 549, 178 },
	{ 251, 550, 299 },
	{ 298, 551, 371 },
	{ 181, 552, 330 },
	{ 252, 553, 301 },
	{ 210, 554, 372 },
	{ 329, 555, 331 },
	{ 253, 556, 209 },
	{ 211, 557, 373 },
	{ 180, 558, 179 },
	{ 254, 559, 300 },
	{ 299, 560, 374 },
	{ 317, 561, 332 },
	{ 255, 562, 197 },
	{ 212, 563, 375 },
	{ 331, 564, 167 },
	{ 256, 565, 211 },
	{ 287, 566, 376 },
	{ 182, 567, 181 },
	{ 257, 568, 302 },
	{ 301, 569, 377 },
	{ 184, 570, 333 },
	{ 258, 571, 304 },
	{ 213, 572, 378 },
	{ 332, 573, 334 },
	{ 259, 574, 212 },
	{ 214, 575, 379 },
	{ 183, 576, 182 },
	{ 260, 577, 303 },
	{ 302, 578, 380 },
	{ 319, 579, 335 },
	{ 261, 580, 199 },
	{ 215, 581, 381 },
	{ 334, 582, 169 },
	{ 262, 583, 214 },
	{ 289, 584, 382 },
	{ 185, 585, 184 },
	{ 263, 586, 305 },
	{ 304, 587, 383 },
	{ 322, 588, 336 },
	{ 264, 589, 202 },
	{ 216, 590, 384 },
	{ 335, 591, 172 },
	{ 265, 592, 215 },
	{ 292, 593, 385 },
	{ 186, 594, 185 },
	{ 266, 595, 306 },
	{ 305, 596, 386 },
	{ 188, 597, 337 },
	{ 267, 598, 308 },
	{ 217, 599, 387 },
	{ 324, 600, 338 },
	{ 268, 601, 204 },
	{ 218, 602, 388 },
	{ 187, 603, 174 },
	{ 269, 604, 307 },
	{ 294, 605, 389 },
	{ 327, 606, 339 },
	{ 270, 607, 207 },
	{ 219, 608, 390 },
	{ 338, 609, 177 },
	{ 271, 610, 218 },
	{ 297, 611, 391 },
	{ 189, 612, 188 },
	{ 272, 613, 309 },
	{ 308, 614, 392 },
	{ 337, 615, 340 },
	{ 273, 616, 217 },
	{ 220, 617, 393 },
	{ 336, 618, 187 },
	{ 274, 619, 216 },
	{ 307, 620, 394 },
	{ 190, 621, 186 },
	{ 275, 622, 310 },
	{ 306, 623, 395 },
	{ 330, 624, 341 },
	{ 276, 625, 210 },
	{ 221, 626, 396 },
	{ 339, 627, 180 },
	{ 277, 628, 219 },
	{ 300, 629, 397 },
	{ 191, 630, 189 },
	{ 278, 631, 311 },
	{ 309, 632, 398 },
	{ 333, 633, 190 },
	{ 279, 634, 213 },
	{ 310, 635, 399 },
	{ 341, 636, 183 },
	{ 280, 637, 221 },
	{ 303, 638, 400 },
	{ 340, 639, 191 },
	{ 281, 640, 220 },
	{ 311, 641, 401 },
	{ 103, 403, 402 },
	{ 104, 404, 403 },
	{ 102, 402, 404 },
	{ 106, 406, 405 },
	{ 107, 407, 406 },
	{ 105, 405, 407 },
	{ 109, 409, 408 },
	{ 110, 410, 409 },
	{ 108, 408, 410 },
	{ 112, 412, 411 },
	{ 113, 413, 412 },
	{ 111, 411, 413 },
	{ 115, 415, 414 },
	{ 116, 416, 415 },
	{ 114, 414, 416 },
	{ 118, 418, 417 },
	{ 119, 419, 418 },
	{ 117, 417, 419 },
	{ 121, 421, 420 },
	{ 122, 422, 421 },
	{ 120, 420, 422 },
	{ 124, 424, 423 },
	{ 125, 425, 424 },
	{ 123, 423, 425 },
	{ 127, 427, 426 },
	{ 128, 428, 427 },
	{ 126, 426, 428 },
	{ 130, 430, 429 },
	{ 131, 431, 430 },
	{ 129, 429, 431 },
	{ 133, 433, 432 },
	{ 134, 434, 433 },
	{ 132, 432, 434 },
	{ 136, 436, 435 },
	{ 137, 437, 436 },
	{ 135, 435, 437 },
	{ 139, 439, 438 },
	{ 140, 440, 439 },
	{ 138, 438, 440 },
	{ 142, 442, 441 },
	{ 143, 443, 442 },
	{ 141, 441, 443 },
	{ 145, 445, 444 },
	{ 146, 446, 445 },
	{ 144, 444, 446 },
	{ 148, 448, 447 },
	{ 149, 449, 448 },
	{ 147, 447, 449 },
	{ 151, 451, 450 },
	{ 152, 452, 451 },
	{ 150, 450, 452 },
	{ 154, 454, 453 },
	{ 155, 455, 454 },
	{ 153, 453, 455 },
	{ 157, 457, 456 },
	{ 158, 458, 457 },
	{ 156, 456, 458 },
	{ 160, 460, 459 },
	{ 161, 461, 460 },
	{ 159, 459, 461 },
	{ 44, 463, 462 },
	{ 102, 464, 463 },
	{ 73, 462, 464 },
	{ 42, 466, 465 },
	{ 103, 467, 466 },
	{ 74, 465, 467 },
	{ 43, 469, 468 },
	{ 104, 470, 469 },
	{ 72, 468, 470 },
	{ 46, 472, 471 },
	{ 105, 473, 472 },
	{ 75, 471, 473 },
	{ 74, 475, 474 },
	{ 106, 476, 475 },
	{ 76, 474, 476 },
	{ 45, 478, 477 },
	{ 107, 479, 478 },
	{ 44, 477, 479 },
	{ 48, 481, 480 },
	{ 108, 482, 481 },
	{ 77, 480, 482 },
	{ 76, 484, 483 },
	{ 109, 485, 484 },
	{ 78, 483, 485 },
	{ 47, 487, 486 },
	{ 110, 488, 487 },
	{ 46, 486, 488 },
	{ 50, 490, 489 },
	{ 111, 491, 490 },
	{ 79, 489, 491 },
	{ 78, 493, 492 },
	{ 112, 494, 493 },
	{ 80, 492, 494 },
	{ 49, 496, 495 },
	{ 113, 497, 496 },
	{ 48, 495, 497 },
	{ 72, 499, 498 },
	{ 114, 500, 499 },
	{ 81, 498, 500 },
	{ 80, 502, 501 },
	{ 115, 503, 502 },
	{ 42, 501, 503 },
	{ 51, 505, 504 },
	{ 116, 506, 505 },
	{ 50, 504, 506 },
	{ 53, 508, 507 },
	{ 117, 509, 508 },
	{ 82, 507, 509 },
	{ 81, 511, 510 },
	{ 118, 512, 511 },
	{ 83, 510, 512 },
	{ 52, 514, 513 },
	{ 119, 515, 514 },
	{ 51, 513, 515 },
	{ 55, 517, 516 },
	{ 120, 518, 517 },
	{ 84, 516, 518 },
	{ 83, 520, 519 },
	{ 121, 521, 520 },
	{ 85, 519, 521 },
	{ 54, 523, 522 },
	{ 122, 524, 523 },
	{ 53, 522, 524 },
	{ 73, 526, 525 },
	{ 123, 527, 526 },
	{ 86, 525, 527 },
	{ 85, 529, 528 },
	{ 124, 530, 529 },
	{ 43, 528, 530 },
	{ 56, 532, 531 },
	{ 125, 533, 532 },
	{ 55, 531, 533 },
	{ 58, 535, 534 },
	{ 126, 536, 535 },
	{ 87, 534, 536 },
	{ 86, 538, 537 },
	{ 127, 539, 538 },
	{ 88, 537, 539 },
	{ 57, 541, 540 },
	{ 128, 542, 541 },
	{ 56, 540, 542 },
	{ 75, 544, 543 },
	{ 129, 545, 544 },
	{ 89, 543, 545 },
	{ 88, 547, 546 },
	{ 130, 548, 547 },
	{ 45, 546, 548 },
	{ 59, 550, 549 },
	{ 131, 551, 550 },
	{ 58, 549, 551 },
	{ 61, 553, 552 },
	{ 132, 554, 553 },
	{ 90, 552, 554 },
	{ 89, 556, 555 },
	{ 133, 557, 556 },
	{ 91, 555, 557 },
	{ 60, 559, 558 },
	{ 134, 560, 559 },
	{ 59, 558, 560 },
	{ 77, 562, 561 },
	{ 135, 563, 562 },
	{ 92, 561, 563 },
	{ 91, 565, 564 },
	{ 136, 566, 565 },
	{ 47, 564, 566 },
	{ 62, 568, 567 },
	{ 137, 569, 568 },
	{ 61, 567, 569 },
	{ 64, 571, 570 },
	{ 138, 572, 571 },
	{ 93, 570, 572 },
	{ 92, 574, 573 },
	{ 139, 575, 574 },
	{ 94, 573, 575 },
	{ 63, 577, 576 },
	{ 140, 578, 577 },
	{ 62, 576, 578 },
	{ 79, 580, 579 },
	{ 141, 581, 580 },
	{ 95, 579, 581 },
	{ 94, 583, 582 },
	{ 142, 584, 583 },
	{ 49, 582, 584 },
	{ 65, 586, 585 },
	{ 143, 587, 586 },
	{ 64, 585, 587 },
	{ 82, 589, 588 },
	{ 144, 590, 589 },
	{ 96, 588, 590 },
	{ 95, 592, 591 },
	{ 145, 593, 592 },
	{ 52, 591, 593 },
	{ 66, 595, 594 },
	{ 146, 596, 595 },
	{ 65, 594, 596 },
	{ 68, 598, 597 },
	{ 147, 599, 598 },
	{ 97, 597, 599 },
	{ 84, 601, 600 },
	{ 148, 602, 601 },
	{ 98, 600, 602 },
	{ 67, 604, 603 },
	{ 149, 605, 604 },
	{ 54, 603, 605 },
	{ 87, 607, 606 },
	{ 150, 608, 607 },
	{ 99, 606, 608 },
	{ 98, 610, 609 },
	{ 151, 611, 610 },
	{ 57, 609, 611 },
	{ 69, 613, 612 },
	{ 152, 614, 613 },
	{ 68, 612, 614 },
	{ 97, 616, 615 },
	{ 153, 617, 616 },
	{ 100, 615, 617 },
	{ 96, 619, 618 },
	{ 154, 620, 619 },
	{ 67, 618, 620 },
	{ 70, 622, 621 },
	{ 155, 623, 622 },
	{ 66, 621, 623 },
	{ 90, 625, 624 },
	{ 156, 626, 625 },
	{ 101, 624, 626 },
	{ 99, 628, 627 },
	{ 157, 629, 628 },
	{ 60, 627, 629 },
	{ 71, 631, 630 },
	{ 158, 632, 631 },
	{ 69, 630, 632 },
	{ 93, 634, 633 },
	{ 159, 635, 634 },
	{ 70, 633, 635 },
	{ 101, 637, 636 },
	{ 160, 638, 637 },
	{ 63, 636, 638 },
	{ 100, 640, 639 },
	{ 161, 641, 640 },
	{ 71, 639, 641 },
	{ 14, 343, 222 },
	{ 103, 402, 343 },
	{ 102, 222, 402 },
	{ 12, 344, 223 },
	{ 104, 403, 344 },
	{ 103, 223, 403 },
	{ 13, 342, 224 },
	{ 102, 404, 342 },
	{ 104, 224, 404 },
	{ 16, 346, 225 },
	{ 106, 405, 346 },
	{ 105, 225, 405 },
	{ 14, 347, 226 },
	{ 107, 406, 347 },
	{ 106, 226, 406 },
	{ 15, 345, 227 },
	{ 105, 407, 345 },
	{ 107, 227, 407 },
	{ 18, 349, 228 },
	{ 109, 408, 349 },
	{ 108, 228, 408 },
	{ 16, 350, 229 },
	{ 110, 409, 350 },
	{ 109, 229, 409 },
	{ 17, 348, 230 },
	{ 108, 410, 348 },
	{ 110, 230, 410 },
	{ 20, 352, 231 },
	{ 112, 411, 352 },
	{ 111, 231, 411 },
	{ 18, 353, 232 },
	{ 113, 412, 353 },
	{ 112, 232, 412 },
	{ 19, 351, 233 },
	{ 111, 413, 351 },
	{ 113, 233, 413 },
	{ 12, 355, 234 },
	{ 115, 414, 355 },
	{ 114, 234, 414 },
	{ 20, 356, 235 },
	{ 116, 415, 356 },
	{ 115, 235, 415 },
	{ 21, 354, 236 },
	{ 114, 416, 354 },
	{ 116, 236, 416 },
	{ 23, 358, 237 },
	{ 118, 417, 358 },
	{ 117, 237, 417 },
	{ 21, 359, 238 },
	{ 119, 418, 359 },
	{ 118, 238, 418 },
	{ 22, 357, 239 },
	{ 117, 419, 357 },
	{ 119, 239, 419 },
	{ 25, 361, 240 },
	{ 121, 420, 361 },
	{ 120, 240, 420 },
	{ 23, 362, 241 },
	{ 122, 421, 362 },
	{ 121, 241, 421 },
	{ 24, 360, 242 },
	{ 120, 422, 360 },
	{ 122, 242, 422 },
	{ 13, 364, 243 },
	{ 124, 423, 364 },
	{ 123, 243, 423 },
	{ 25, 365, 244 },
	{ 125, 424, 365 },
	{ 124, 244, 424 },
	{ 26, 363, 245 },
	{ 123, 425, 363 },
	{ 125, 245, 425 },
	{ 28, 367, 246 },
	{ 127, 426, 367 },
	{ 126, 246, 426 },
	{ 26, 368, 247 },
	{ 128, 427, 368 },
	{ 127, 247, 427 },
	{ 27, 366, 248 },
	{ 126, 428, 366 },
	{ 128, 248, 428 },
	{ 15, 370, 249 },
	{ 130, 429, 370 },
	{ 129, 249, 429 },
	{ 28, 371, 250 },
	{ 131, 430, 371 },
	{ 130, 250, 430 },
	{ 29, 369, 251 },
	{ 129, 431, 369 },
	{ 131, 251, 431 },
	{ 31, 373, 252 },
	{ 133, 432, 373 },
	{ 132, 252, 432 },
	{ 29, 374, 253 },
	{ 134, 433, 374 },
	{ 133, 253, 433 },
	{ 30, 372, 254 },
	{ 132, 434, 372 },
	{ 134, 254, 434 },
	{ 17, 376, 255 },
	{ 136, 435, 376 },
	{ 135, 255, 435 },
	{ 31, 377, 256 },
	{ 137, 436, 377 },
	{ 136, 256, 436 },
	{ 32, 375, 257 },
	{ 135, 437, 375 },
	{ 137, 257, 437 },
	{ 34, 379, 258 },
	{ 139, 438, 379 },
	{ 138, 258, 438 },
	{ 32, 380, 259 },
	{ 140, 439, 380 },
	{ 139, 259, 439 },
	{ 33, 378, 260 },
	{ 138, 440, 378 },
	{ 140, 260, 440 },
	{ 19, 382, 261 },
	{ 142, 441, 382 },
	{ 141, 261, 441 },
	{ 34, 383, 262 },
	{ 143, 442, 383 },
	{ 142, 262, 442 },
	{ 35, 381, 263 },
	{ 141, 443, 381 },
	{ 143, 263, 443 },
	{ 22, 385, 264 },
	{ 145, 444, 385 },
	{ 144, 264, 444 },
	{ 35, 386, 265 },
	{ 146, 445, 386 },
	{ 145, 265, 445 },
	{ 36, 384, 266 },
	{ 144, 446, 384 },
	{ 146, 266, 446 },
	{ 38, 388, 267 },
	{ 148, 447, 388 },
	{ 147, 267, 447 },
	{ 24, 389, 268 },
	{ 149, 448, 389 },
	{ 148, 268, 448 },
	{ 37, 387, 269 },
	{ 147, 449, 387 },
	{ 149, 269, 449 },
	{ 27, 391, 270 },
	{ 151, 450, 391 },
	{ 150, 270, 450 },
	{ 38, 392, 271 },
	{ 152, 451, 392 },
	{ 151, 271, 451 },
	{ 39, 390, 272 },
	{ 150, 452, 390 },
	{ 152, 272, 452 },
	{ 37, 394, 273 },
	{ 154, 453, 394 },
	{ 153, 273, 453 },
	{ 36, 395, 274 },
	{ 155, 454, 395 },
	{ 154, 274, 454 },
	{ 40, 393, 275 },
	{ 153, 455, 393 },
	{ 155, 275, 455 },
	{ 30, 397, 276 },
	{ 157, 456, 397 },
	{ 156, 276, 456 },
	{ 39, 398, 277 },
	{ 158, 457, 398 },
	{ 157, 277, 457 },
	{ 41, 396, 278 },
	{ 156, 458, 396 },
	{ 158, 278, 458 },
	{ 33, 400, 279 },
	{ 160, 459, 400 },
	{ 159, 279, 459 },
	{ 41, 401, 280 },
	{ 161, 460, 401 },
	{ 160, 280, 460 },
	{ 40, 399, 281 },
	{ 159, 461, 399 },
	{ 161, 281, 461 },
	{ 2, 164, 313 },
	{ 44, 462, 164 },
	{ 73, 313, 462 },
	{ 14, 222, 284 },
	{ 102, 463, 222 },
	{ 44, 284, 463 },
	{ 13, 193, 342 },
	{ 73, 464, 193 },
	{ 102, 342, 464 },
	{ 0, 162, 314 },
	{ 42, 465, 162 },
	{ 74, 314, 465 },
	{ 12, 223, 282 },
	{ 103, 466, 223 },
	{ 42, 282, 466 },
	{ 14, 194, 343 },
	{ 74, 467, 194 },
	{ 103, 343, 467 },
	{ 1, 163, 312 },
	{ 43, 468, 163 },
	{ 72, 312, 468 },
	{ 13, 224, 283 },
	{ 104, 469, 224 },
	{ 43, 283, 469 },
	{ 12, 192, 344 },
	{ 72, 470, 192 },
	{ 104, 344, 470 },
	{ 3, 166, 315 },
	{ 46, 471, 166 },
	{ 75, 315, 471 },
	{ 16, 225, 286 },
	{ 105, 472, 225 },
	{ 46, 286, 472 },
	{ 15, 195, 345 },
	{ 75, 473, 195 },
	{ 105, 345, 473 },
	{ 0, 314, 316 },
	{ 74, 474, 314 },
	{ 76, 316, 474 },
	{ 14, 226, 194 },
	{ 106, 475, 226 },
	{ 74, 194, 475 },
	{ 16, 196, 346 },
	{ 76, 476, 196 },
	{ 106, 346, 476 },
	{ 2, 165, 164 },
	{ 45, 477, 165 },
	{ 44, 164, 477 },
	{ 15, 227, 285 },
	{ 107, 478, 227 },
	{ 45, 285, 478 },
	{ 14, 284, 347 },
	{ 44, 479, 284 },
	{ 107, 347, 479 },
	{ 4, 168, 317 },
	{ 48, 480, 168 },
	{ 77, 317, 480 },
	{ 18, 228, 288 },
	{ 108, 481, 228 },
	{ 48, 288, 481 },
	{ 17, 197, 348 },
	{ 77, 482, 197 },
	{ 108, 348, 482 },
	{ 0, 316, 318 },
	{ 76, 483, 316 },
	{ 78, 318, 483 },
	{ 16, 229, 196 },
	{ 109, 484, 229 },
	{ 76, 196, 484 },
	{ 18, 198, 349 },
	{ 78, 485, 198 },
	{ 109, 349, 485 },
	{ 3, 167, 166 },
	{ 47, 486, 167 },
	{ 46, 166, 486 },
	{ 17, 230, 287 },
	{ 110, 487, 230 },
	{ 47, 287, 487 },
	{ 16, 286, 350 },
	{ 46, 488, 286 },
	{ 110, 350, 488 },
	{ 5, 170, 319 },
	{ 50, 489, 170 },
	{ 79, 319, 489 },
	{ 20, 231, 290 },
	{ 111, 490, 231 },
	{ 50, 290, 490 },
	{ 19, 199, 351 },
	{ 79, 491, 199 },
	{ 111, 351, 491 },
	{ 0, 318, 320 },
	{ 78, 492, 318 },
	{ 80, 320, 492 },
	{ 18, 232, 198 },
	{ 112, 493, 232 },
	{ 78, 198, 493 },
	{ 20, 200, 352 },
	{ 80, 494, 200 },
	{ 112, 352, 494 },
	{ 4, 169, 168 },
	{ 49, 495, 169 },
	{ 48, 168, 495 },
	{ 19, 233, 289 },
	{ 113, 496, 233 },
	{ 49, 289, 496 },
	{ 18, 288, 353 },
	{ 48, 497, 288 },
	{ 113, 353, 497 },
	{ 1, 312, 321 },
	{ 72, 498, 312 },
	{ 81, 321, 498 },
	{ 12, 234, 192 },
	{ 114, 499, 234 },
	{ 72, 192, 499 },
	{ 21, 201, 354 },
	{ 81, 500, 201 },
	{ 114, 354, 500 },
	{ 0, 320, 162 },
	{ 80, 501, 320 },
	{ 42, 162, 501 },
	{ 20, 235, 200 },
	{ 115, 502, 235 },
	{ 80, 200, 502 },
	{ 12, 282, 355 },
	{ 42, 503, 282 },
	{ 115, 355, 503 },
	{ 5, 171, 170 },
	{ 51, 504, 171 },
	{ 50, 170, 504 },
	{ 21, 236, 291 },
	{ 116, 505, 236 },
	{ 51, 291, 505 },
	{ 20, 290, 356 },
	{ 50, 506, 290 },
	{ 116, 356, 506 },
	{ 7, 173, 322 },
	{ 53, 507, 173 },
	{ 82, 322, 507 },
	{ 23, 237, 293 },
	{ 117, 508, 237 },
	{ 53, 293, 508 },
	{ 22, 202, 357 },
	{ 82, 509, 202 },
	{ 117, 357, 509 },
	{ 1, 321, 323 },
	{ 81, 510, 321 },
	{ 83, 323, 510 },
	{ 21, 238, 201 },
	{ 118, 511, 238 },
	{ 81, 201, 511 },
	{ 23, 203, 358 },
	{ 83, 512, 203 },
	{ 118, 358, 512 },
	{ 5, 172, 171 },
	{ 52, 513, 172 },
	{ 51, 171, 513 },
	{ 22, 239, 292 },
	{ 119, 514, 239 },
	{ 52, 292, 514 },
	{ 21, 291, 359 },
	{ 51, 515, 291 },
	{ 119, 359, 515 },
	{ 6, 175, 324 },
	{ 55, 516, 175 },
	{ 84, 324, 516 },
	{ 25, 240, 295 },
	{ 120, 517, 240 },
	{ 55, 295, 517 },
	{ 24, 204, 360 },
	{ 84, 518, 204 },
	{ 120, 360, 518 },
	{ 1, 323, 325 },
	{ 83, 519, 323 },
	{ 85, 325, 519 },
	{ 23, 241, 203 },
	{ 121, 520, 241 },
	{ 83, 203, 520 },
	{ 25, 205, 361 },
	{ 85, 521, 205 },
	{ 121, 361, 521 },
	{ 7, 174, 173 },
	{ 54, 522, 174 },
	{ 53, 173, 522 },
	{ 24, 242, 294 },
	{ 122, 523, 242 },
	{ 54, 294, 523 },
	{ 23, 293, 362 },
	{ 53, 524, 293 },
	{ 122, 362, 524 },
	{ 2, 313, 326 },
	{ 73, 525, 313 },
	{ 86, 326, 525 },
	{ 13, 243, 193 },
	{ 123, 526, 243 },
	{ 73, 193, 526 },
	{ 26, 206, 363 },
	{ 86, 527, 206 },
	{ 123, 363, 527 },
	{ 1, 325, 163 },
	{ 85, 528, 325 },
	{ 43, 163, 528 },
	{ 25, 244, 205 },
	{ 124, 529, 244 },
	{ 85, 205, 529 },
	{ 13, 283, 364 },
	{ 43, 530, 283 },
	{ 124, 364, 530 },
	{ 6, 176, 175 },
	{ 56, 531, 176 },
	{ 55, 175, 531 },
	{ 26, 245, 296 },
	{ 125, 532, 245 },
	{ 56, 296, 532 },
	{ 25, 295, 365 },
	{ 55, 533, 295 },
	{ 125, 365, 533 },
	{ 8, 178, 327 },
	{ 58, 534, 178 },
	{ 87, 327, 534 },
	{ 28, 246, 298 },
	{ 126, 535, 246 },
	{ 58, 298, 535 },
	{ 27, 207, 366 },
	{ 87, 536, 207 },
	{ 126, 366, 536 },
	{ 2, 326, 328 },
	{ 86, 537, 326 },
	{ 88, 328, 537 },
	{ 26, 247, 206 },
	{ 127, 538, 247 },
	{ 86, 206, 538 },
	{ 28, 208, 367 },
	{ 88, 539, 208 },
	{ 127, 367, 539 },
	{ 6, 177, 176 },
	{ 57, 540, 177 },
	{ 56, 176, 540 },
	{ 27, 248, 297 },
	{ 128, 541, 248 },
	{ 57, 297, 541 },
	{ 26, 296, 368 },
	{ 56, 542, 296 },
	{ 128, 368, 542 },
	{ 3, 315, 329 },
	{ 75, 543, 315 },
	{ 89, 329, 543 },
	{ 15, 249, 195 },
	{ 129, 544, 249 },
	{ 75, 195, 544 },
	{ 29, 209, 369 },
	{ 89, 545, 209 },
	{ 129, 369, 545 },
	{ 2, 328, 165 },
	{ 88, 546, 328 },
	{ 45, 165, 546 },
	{ 28, 250, 208 },
	{ 130, 547, 250 },
	{ 88, 208, 547 },
	{ 15, 285, 370 },
	{ 45, 548, 285 },
	{ 130, 370, 548 },
	{ 8, 179, 178 },
	{ 59, 549, 179 },
	{ 58, 178, 549 },
	{ 29, 251, 299 },
	{ 131, 550, 251 },
	{ 59, 299, 550 },
	{ 28, 298, 371 },
	{ 58, 551, 298 },
	{ 131, 371, 551 },
	{ 9, 181, 330 },
	{ 61, 552, 181 },
	{ 90, 330, 552 },
	{ 31, 252, 301 },
	{ 132, 553, 252 },
	{ 61, 301, 553 },
	{ 30, 210, 372 },
	{ 90, 554, 210 },
	{ 132, 372, 554 },
	{ 3, 329, 331 },
	{ 89, 555, 329 },
	{ 91, 331, 555 },
	{ 29, 253, 209 },
	{ 133, 556, 253 },
	{ 89, 209, 556 },
	{ 31, 211, 373 },
	{ 91, 557, 211 },
	{ 133, 373, 557 },
	{ 8, 180, 179 },
	{ 60, 558, 180 },
	{ 59, 179, 558 },
	{ 30, 254, 300 },
	{ 134, 559, 254 },
	{ 60, 300, 559 },
	{ 29, 299, 374 },
	{ 59, 560, 299 },
	{ 134, 374, 560 },
	{ 4, 317, 332 },
	{ 77, 561, 317 },
	{ 92, 332, 561 },
	{ 17, 255, 197 },
	{ 135, 562, 255 },
	{ 77, 197, 562 },
	{ 32, 212, 375 },
	{ 92, 563, 212 },
	{ 135, 375, 563 },
	{ 3, 331, 167 },
	{ 91, 564, 331 },
	{ 47, 167, 564 },
	{ 31, 256, 211 },
	{ 136, 565, 256 },
	{ 91, 211, 565 },
	{ 17, 287, 376 },
	{ 47, 566, 287 },
	{ 136, 376, 566 },
	{ 9, 182, 181 },
	{ 62, 567, 182 },
	{ 61, 181, 567 },
	{ 32, 257, 302 },
	{ 137, 568, 257 },
	{ 62, 302, 568 },
	{ 31, 301, 377 },
	{ 61, 569, 301 },
	{ 137, 377, 569 },
	{ 10, 184, 333 },
	{ 64, 570, 184 },
	{ 93, 333, 570 },
	{ 34, 258, 304 },
	{ 138, 571, 258 },
	{ 64, 304, 571 },
	{ 33, 213, 378 },
	{ 93, 572, 213 },
	{ 138, 378, 572 },
	{ 4, 332, 334 },
	{ 92, 573, 332 },
	{ 94, 334, 573 },
	{ 32, 259, 212 },
	{ 139, 574, 259 },
	{ 92, 212, 574 },
	{ 34, 214, 379 },
	{ 94, 575, 214 },
	{ 139, 379, 575 },
	{ 9, 183, 182 },
	{ 63, 576, 183 },
	{ 62, 182, 576 },
	{ 33, 260, 303 },
	{ 140, 577, 260 },
	{ 63, 303, 577 },
	{ 32, 302, 380 },
	{ 62, 578, 302 },
	{ 140, 380, 578 },
	{ 5, 319, 335 },
	{ 79, 579, 319 },
	{ 95, 335, 579 },
	{ 19, 261, 199 },
	{ 141, 580, 261 },
	{ 79, 199, 580 },
	{ 35, 215, 381 },
	{ 95, 581, 215 },
	{ 141, 381, 581 },
	{ 4, 334, 169 },
	{ 94, 582, 334 },
	{ 49, 169, 582 },
	{ 34, 262, 214 },
	{ 142, 583, 262 },
	{ 94, 214, 583 },
	{ 19, 289, 382 },
	{ 49, 584, 289 },
	{ 142, 382, 584 },
	{ 10, 185, 184 },
	{ 65, 585, 185 },
	{ 64, 184, 585 },
	{ 35, 263, 305 },
	{ 143, 586, 263 },
	{ 65, 305, 586 },
	{ 34, 304, 383 },
	{ 64, 587, 304 },
	{ 143, 383, 587 },
	{ 7, 322, 336 },
	{ 82, 588, 322 },
	{ 96, 336, 588 },
	{ 22, 264, 202 },
	{ 144, 589, 264 },
	{ 82, 202, 589 },
	{ 36, 216, 384 },
	{ 96, 590, 216 },
	{ 144, 384, 590 },
	{ 5, 335, 172 },
	{ 95, 591, 335 },
	{ 52, 172, 591 },
	{ 35, 265, 215 },
	{ 145, 592, 265 },
	{ 95, 215, 592 },
	{ 22, 292, 385 },
	{ 52, 593, 292 },
	{ 145, 385, 593 },
	{ 10, 186, 185 },
	{ 66, 594, 186 },
	{ 65, 185, 594 },
	{ 36, 266, 306 },
	{ 146, 595, 266 },
	{ 66, 306, 595 },
	{ 35, 305, 386 },
	{ 65, 596, 305 },
	{ 146, 386, 596 },
	{ 11, 188, 337 },
	{ 68, 597, 188 },
	{ 97, 337, 597 },
	{ 38, 267, 308 },
	{ 147, 598, 267 },
	{ 68, 308, 598 },
	{ 37, 217, 387 },
	{ 97, 599, 217 },
	{ 147, 387, 599 },
	{ 6, 324, 338 },
	{ 84, 600, 324 },
	{ 98, 338, 600 },
	{ 24, 268, 204 },
	{ 148, 601, 268 },
	{ 84, 204, 601 },
	{ 38, 218, 388 },
	{ 98, 602, 218 },
	{ 148, 388, 602 },
	{ 7, 187, 174 },
	{ 67, 603, 187 },
	{ 54, 174, 603 },
	{ 37, 269, 307 },
	{ 149, 604, 269 },
	{ 67, 307, 604 },
	{ 24, 294, 389 },
	{ 54, 605, 294 },
	{ 149, 389, 605 },
	{ 8, 327, 339 },
	{ 87, 606, 327 },
	{ 99, 339, 606 },
	{ 27, 270, 207 },
	{ 150, 607, 270 },
	{ 87, 207, 607 },
	{ 39, 219, 390 },
	{ 99, 608, 219 },
	{ 150, 390, 608 },
	{ 6, 338, 177 },
	{ 98, 609, 338 },
	{ 57, 177, 609 },
	{ 38, 271, 218 },
	{ 151, 610, 271 },
	{ 98, 218, 610 },
	{ 27, 297, 391 },
	{ 57, 611, 297 },
	{ 151, 391, 611 },
	{ 11, 189, 188 },
	{ 69, 612, 189 },
	{ 68, 188, 612 },
	{ 39, 272, 309 },
	{ 152, 613, 272 },
	{ 69, 309, 613 },
	{ 38, 308, 392 },
	{ 68, 614, 308 },
	{ 152, 392, 614 },
	{ 11, 337, 340 },
	{ 97, 615, 337 },
	{ 100, 340, 615 },
	{ 37, 273, 217 },
	{ 153, 616, 273 },
	{ 97, 217, 616 },
	{ 40, 220, 393 },
	{ 100, 617, 220 },
	{ 153, 393, 617 },
	{ 7, 336, 187 },
	{ 96, 618, 336 },
	{ 67, 187, 618 },
	{ 36, 274, 216 },
	{ 154, 619, 274 },
	{ 96, 216, 619 },
	{ 37, 307, 394 },
	{ 67, 620, 307 },
	{ 154, 394, 620 },
	{ 10, 190, 186 },
	{ 70, 621, 190 },
	{ 66, 186, 621 },
	{ 40, 275, 310 },
	{ 155, 622, 275 },
	{ 70, 310, 622 },
	{ 36, 306, 395 },
	{ 66, 623, 306 },
	{ 155, 395, 623 },
	{ 9, 330, 341 },
	{ 90, 624, 330 },
	{ 101, 341, 624 },
	{ 30, 276, 210 },
	{ 156, 625, 276 },
	{ 90, 210, 625 },
	{ 41, 221, 396 },
	{ 101, 626, 221 },
	{ 156, 396, 626 },
	{ 8, 339, 180 },
	{ 99, 627, 339 },
	{ 60, 180, 627 },
	{ 39, 277, 219 },
	{ 157, 628, 277 },
	{ 99, 219, 628 },
	{ 30, 300, 397 },
	{ 60, 629, 300 },
	{ 157, 397, 629 },
	{ 11, 191, 189 },
	{ 71, 630, 191 },
	{ 69, 189, 630 },
	{ 41, 278, 311 },
	{ 158, 631, 278 },
	{ 71, 311, 631 },
	{ 39, 309, 398 },
	{ 69, 632, 309 },
	{ 158, 398, 632 },
	{ 10, 333, 190 },
	{ 93, 633, 333 },
	{ 70, 190, 633 },
	{ 33, 279, 213 },
	{ 159, 634, 279 },
	{ 93, 213, 634 },
	{ 40, 310, 399 },
	{ 70, 635, 310 },
	{ 159, 399, 635 },
	{ 9, 341, 183 },
	{ 101, 636, 341 },
	{ 63, 183, 636 },
	{ 41, 280, 221 },
	{ 160, 637, 280 },
	{ 101, 221, 637 },
	{ 33, 303, 400 },
	{ 63, 638, 303 },
	{ 160, 400, 638 },
	{ 11, 340, 191 },
	{ 100, 639, 340 },
	{ 71, 191, 639 },
	{ 40, 281, 220 },
	{ 161, 640, 281 },
	{ 100, 220, 640 },
	{ 41, 311, 401 },
	{ 71, 641, 311 },
	{ 161, 401, 641 }
    };    

#else

    const vec3 SPHERE_MODEL_PTS[SPHERE_MODEL_NB_PTS] = {
	vec3(0, 0, 1),
	vec3(0.894427156973875, 0, 0.4472136635520332),
	vec3(0.2763932064839828, 0.8506508115204552, 0.4472135868565416),
	vec3(-0.7236067940608635, 0.5257311241705899, 0.4472135873017355),
	vec3(-0.7236067940608635, -0.5257311241705899, 0.4472135873017355),
	vec3(0.2763932064839828, -0.8506508115204552, 0.4472135868565416),
	vec3(0.7236067940608635, 0.5257311241705899, -0.4472135873017355),
	vec3(0.7236067940608635, -0.5257311241705899, -0.4472135873017355),
	vec3(-0.2763932064839828, 0.8506508115204552, -0.4472135868565416),
	vec3(-0.894427156973875, 0, -0.4472136635520332),
	vec3(-0.2763932064839828, -0.8506508115204552, -0.4472135868565416),
	vec3(0, 0, -1),
	vec3(0.5257310797584478, 0, 0.8506508283520429),
	vec3(0.6881909377429022, 0.4999999982431924, 0.5257311432332619),
	vec3(0.1624598510902554, 0.5000000033554612, 0.8506508058118036),
	vec3(-0.2628655511898554, 0.8090170026665143, 0.5257311017945799),
	vec3(-0.4253254032123109, 0.3090170023338805, 0.8506508059426429),
	vec3(-0.8506508114634344, 0, 0.5257311070847919),
	vec3(-0.4253254032123109, -0.3090170023338805, 0.8506508059426429),
	vec3(-0.2628655511898554, -0.8090170026665143, 0.5257311017945799),
	vec3(0.1624598510902554, -0.5000000033554612, 0.8506508058118036),
	vec3(0.6881909377429022, -0.4999999982431924, 0.5257311432332619),
	vec3(0.5877852482479979, -0.8090169973134307, -2.616784614232326e-10),
	vec3(0.9510565120964196, -0.3090170072973185, 4.481880131014739e-08),
	vec3(0.8506508114634344, 0, -0.5257311070847919),
	vec3(0.9510565120964196, 0.3090170072973185, 4.481880131014739e-08),
	vec3(0.5877852482479979, 0.8090169973134307, -2.616784614232326e-10),
	vec3(0.2628655511898554, 0.8090170026665143, -0.5257311017945799),
	vec3(0, 1, 0),
	vec3(-0.5877852482479979, 0.8090169973134307, 2.616784614232326e-10),
	vec3(-0.6881909377429022, 0.4999999982431924, -0.5257311432332619),
	vec3(-0.9510565120964196, 0.3090170072973185, -4.481880131014739e-08),
	vec3(-0.9510565120964196, -0.3090170072973185, -4.481880131014739e-08),
	vec3(-0.6881909377429022, -0.4999999982431924, -0.5257311432332619),
	vec3(-0.5877852482479979, -0.8090169973134307, 2.616784614232326e-10),
	vec3(0, -1, 0),
	vec3(0.2628655511898554, -0.8090170026665143, -0.5257311017945799),
	vec3(0.4253254032123109, -0.3090170023338805, -0.8506508059426429),
	vec3(0.4253254032123109, 0.3090170023338805, -0.8506508059426429),
	vec3(-0.1624598510902554, 0.5000000033554612, -0.8506508058118036),
	vec3(-0.1624598510902554, -0.5000000033554612, -0.8506508058118036),
	vec3(-0.5257310797584478, 0, -0.8506508283520429),
	vec3(0.2732665106155135, 0, 0.9619383629817564),
	vec3(0.8226192870247987, 0.2598919116622528, 0.505720973331492),
	vec3(0.228108721481095, 0.7020464486489894, 0.6746089201334373),
	vec3(0.007031456424493246, 0.8626684862125161, 0.5057209126745267),
	vec3(-0.5971963737198065, 0.4338885752362154, 0.674608920409003),
	vec3(-0.818273642980063, 0.273266535726724, 0.5057209167673924),
	vec3(-0.5971963737198065, -0.4338885752362154, 0.674608920409003),
	vec3(-0.5127523697775821, -0.6937804880054391, 0.5057209129059312),
	vec3(0.228108721481095, -0.7020464486489894, 0.6746089201334373),
	vec3(0.5013752361660863, -0.7020464443420094, 0.505720933466416),
	vec3(0.4491859827941719, -0.862668482118211, 0.232454388689686),
	vec3(0.8704629043421207, -0.4338885794178085, -0.232454367167141),
	vec3(0.818273642980063, -0.273266535726724, -0.5057209167673924),
	vec3(0.8704629043421207, 0.4338885794178085, -0.232454367167141),
	vec3(0.6816403719942949, 0.6937804841679618, -0.2324543891931232),
	vec3(0.5127523697775821, 0.6937804880054391, -0.5057209129059312),
	vec3(-0.1436647182279582, 0.961938358607363, -0.2324543890234249),
	vec3(-0.4491859827941719, 0.862668482118211, -0.232454388689686),
	vec3(-0.5013752361660863, 0.7020464443420094, -0.505720933466416),
	vec3(-0.9592525665239648, 0.1606220430543494, -0.232454453392989),
	vec3(-0.9592525665239648, -0.1606220430543494, -0.232454453392989),
	vec3(-0.8226192870247987, -0.2598919116622528, -0.505720973331492),
	vec3(-0.4491859827941719, -0.862668482118211, -0.232454388689686),
	vec3(-0.1436647182279582, -0.961938358607363, -0.2324543890234249),
	vec3(-0.007031456424493246, -0.8626684862125161, -0.5057209126745267),
	vec3(0.5971963737198065, -0.4338885752362154, -0.674608920409003),
	vec3(0.2210772655271963, 0.1606220398815062, -0.9619383571577347),
	vec3(-0.08444400303155747, 0.259891914930235, -0.9619383571237305),
	vec3(-0.228108721481095, -0.7020464486489894, -0.6746089201334373),
	vec3(-0.2732665106155135, 0, -0.9619383629817564),
	vec3(0.7381752778474314, 0, 0.6746089676063218),
	vec3(0.5013752361660863, 0.7020464443420094, 0.505720933466416),
	vec3(0.08444400303155747, 0.259891914930235, 0.9619383571237305),
	vec3(-0.5127523697775821, 0.6937804880054391, 0.5057209129059312),
	vec3(-0.2210772655271963, 0.1606220398815062, 0.9619383571577347),
	vec3(-0.818273642980063, -0.273266535726724, 0.5057209167673924),
	vec3(-0.2210772655271963, -0.1606220398815062, 0.9619383571577347),
	vec3(0.007031456424493246, -0.8626684862125161, 0.5057209126745267),
	vec3(0.08444400303155747, -0.259891914930235, 0.9619383571237305),
	vec3(0.8226192870247987, -0.2598919116622528, 0.505720973331492),
	vec3(0.6816403719942949, -0.6937804841679618, -0.2324543891931232),
	vec3(0.9592525665239648, -0.1606220430543494, 0.232454453392989),
	vec3(0.818273642980063, 0.273266535726724, -0.5057209167673924),
	vec3(0.9592525665239648, 0.1606220430543494, 0.232454453392989),
	vec3(0.4491859827941719, 0.862668482118211, 0.232454388689686),
	vec3(-0.007031456424493246, 0.8626684862125161, -0.5057209126745267),
	vec3(0.1436647182279582, 0.961938358607363, 0.2324543890234249),
	vec3(-0.6816403719942949, 0.6937804841679618, 0.2324543891931232),
	vec3(-0.8226192870247987, 0.2598919116622528, -0.505720973331492),
	vec3(-0.8704629043421207, 0.4338885794178085, 0.232454367167141),
	vec3(-0.8704629043421207, -0.4338885794178085, 0.232454367167141),
	vec3(-0.5013752361660863, -0.7020464443420094, -0.505720933466416),
	vec3(-0.6816403719942949, -0.6937804841679618, 0.2324543891931232),
	vec3(0.1436647182279582, -0.961938358607363, 0.2324543890234249),
	vec3(0.5127523697775821, -0.6937804880054391, -0.5057209129059312),
	vec3(0.2210772655271963, -0.1606220398815062, -0.9619383571577347),
	vec3(0.5971963737198065, 0.4338885752362154, -0.674608920409003),
	vec3(-0.228108721481095, 0.7020464486489894, -0.6746089201334373),
	vec3(-0.08444400303155747, -0.259891914930235, -0.9619383571237305),
	vec3(-0.7381752778474314, 0, -0.6746089676063218),
	vec3(0.4472135822317256, 0.5257311094251856, 0.723606807907465),
	vec3(0.3618033823095633, 0.2628655570129412, 0.8944271974205816),
	vec3(0.6381965717777373, 0.2628655549262457, 0.7236068240449784),
	vec3(-0.3618033961454464, 0.5877852613837908, 0.72360679172988),
	vec3(-0.1381965990664858, 0.4253254101598886, 0.8944271884724767),
	vec3(-0.05278640042385407, 0.6881909669766437, 0.7236067916362067),
	vec3(-0.6708203953145451, -0.1624598525272729, 0.7236067948456912),
	vec3(-0.4472135957026711, 0, 0.8944271908985595),
	vec3(-0.6708203953145451, 0.1624598525272729, 0.7236067948456912),
	vec3(-0.05278640042385407, -0.6881909669766437, 0.7236067916362067),
	vec3(-0.1381965990664858, -0.4253254101598886, 0.8944271884724767),
	vec3(-0.3618033961454464, -0.5877852613837908, 0.72360679172988),
	vec3(0.6381965717777373, -0.2628655549262457, 0.7236068240449784),
	vec3(0.3618033823095633, -0.2628655570129412, 0.8944271974205816),
	vec3(0.4472135822317256, -0.5257311094251856, 0.723606807907465),
	vec3(0.8090169889124732, -0.5877852598109237, 2.342506571540531e-08),
	vec3(0.8618033836039541, -0.4253254094348548, 0.2763932417731106),
	vec3(0.6708203822824916, -0.6881909639180641, 0.2763932196995752),
	vec3(0.9472136012574548, 0.1624598559956791, -0.2763931778874921),
	vec3(0.9999999999999989, 0, 4.712527672130964e-08),
	vec3(0.9472136012574548, -0.1624598559956791, -0.2763931778874921),
	vec3(0.6708203822824916, 0.6881909639180641, 0.2763932196995752),
	vec3(0.8618033836039541, 0.4253254094348548, 0.2763932417731106),
	vec3(0.8090169889124732, 0.5877852598109237, 2.342506571540531e-08),
	vec3(0.1381965982481421, 0.9510565184747208, -0.2763931961886626),
	vec3(0.3090169919976646, 0.9510565170675797, -1.375725084299267e-10),
	vec3(0.4472135901587011, 0.8506508130105388, -0.2763931965549709),
	vec3(-0.4472135901587011, 0.8506508130105388, 0.2763931965549709),
	vec3(-0.1381965982481421, 0.9510565184747208, 0.2763931961886626),
	vec3(-0.3090169919976646, 0.9510565170675797, 1.375725084299267e-10),
	vec3(-0.8618033836039541, 0.4253254094348548, -0.2763932417731106),
	vec3(-0.8090169889124732, 0.5877852598109237, -2.342506571540531e-08),
	vec3(-0.6708203822824916, 0.6881909639180641, -0.2763932196995752),
	vec3(-0.9472136012574548, -0.1624598559956791, 0.2763931778874921),
	vec3(-0.9472136012574548, 0.1624598559956791, 0.2763931778874921),
	vec3(-0.9999999999999989, 0, -4.712527672130964e-08),
	vec3(-0.6708203822824916, -0.6881909639180641, -0.2763932196995752),
	vec3(-0.8090169889124732, -0.5877852598109237, -2.342506571540531e-08),
	vec3(-0.8618033836039541, -0.4253254094348548, -0.2763932417731106),
	vec3(-0.1381965982481421, -0.9510565184747208, 0.2763931961886626),
	vec3(-0.4472135901587011, -0.8506508130105388, 0.2763931965549709),
	vec3(-0.3090169919976646, -0.9510565170675797, 1.375725084299267e-10),
	vec3(0.4472135901587011, -0.8506508130105388, -0.2763931965549709),
	vec3(0.3090169919976646, -0.9510565170675797, -1.375725084299267e-10),
	vec3(0.1381965982481421, -0.9510565184747208, -0.2763931961886626),
	vec3(0.4472135957026711, 0, -0.8944271908985595),
	vec3(0.6708203953145451, 0.1624598525272729, -0.7236067948456912),
	vec3(0.6708203953145451, -0.1624598525272729, -0.7236067948456912),
	vec3(0.05278640042385407, 0.6881909669766437, -0.7236067916362067),
	vec3(0.3618033961454464, 0.5877852613837908, -0.72360679172988),
	vec3(0.1381965990664858, 0.4253254101598886, -0.8944271884724767),
	vec3(0.1381965990664858, -0.4253254101598886, -0.8944271884724767),
	vec3(0.3618033961454464, -0.5877852613837908, -0.72360679172988),
	vec3(0.05278640042385407, -0.6881909669766437, -0.7236067916362067),
	vec3(-0.6381965717777373, 0.2628655549262457, -0.7236068240449784),
	vec3(-0.4472135822317256, 0.5257311094251856, -0.723606807907465),
	vec3(-0.3618033823095633, 0.2628655570129412, -0.8944271974205816),
	vec3(-0.4472135822317256, -0.5257311094251856, -0.723606807907465),
	vec3(-0.6381965717777373, -0.2628655549262457, -0.7236068240449784),
	vec3(-0.3618033823095633, -0.2628655570129412, -0.8944271974205816),
	vec3(0.1379522327079985, 0, 0.990438883268866),
	vec3(0.8668109030140122, 0.1312003780802619, 0.4810668552370133),
	vec3(0.2546860473879966, 0.7838430461064585, 0.5663259629722333),
	vec3(0.1430803394630376, 0.8649293403494969, 0.4810667860720864),
	vec3(-0.66677671487506, 0.4844416536151999, 0.5663259633311843),
	vec3(-0.7783824251503506, 0.4033553583401605, 0.4810667886222659),
	vec3(-0.66677671487506, -0.4844416536151999, 0.5663259633311843),
	vec3(-0.6241471262413267, -0.6156420322024284, 0.4810667864136515),
	vec3(0.2546860473879966, -0.7838430461064585, 0.5663259629722333),
	vec3(0.3926382821301419, -0.7838430434806346, 0.4810667963941255),
	vec3(0.3662917531776543, -0.864929337960137, 0.3431145463105281),
	vec3(0.8047289586160284, -0.4844416561645797, -0.3431145361789291),
	vec3(0.7783824251503506, -0.4033553583401605, -0.4810667886222659),
	vec3(0.8047289586160284, 0.4844416561645797, -0.3431145361789291),
	vec3(0.7094063001095109, 0.6156420300356564, -0.3431145467894223),
	vec3(0.6241471262413267, 0.6156420322024284, -0.4810667864136515),
	vec3(-0.2120564591496344, 0.9150434230561556, -0.343114546550555),
	vec3(-0.3662917531776543, 0.864929337960137, -0.3431145463105281),
	vec3(-0.3926382821301419, 0.7838430434806346, -0.4810667963941255),
	vec3(-0.9357870330215365, 0.0810862972725732, -0.3431146182012269),
	vec3(-0.9357870330215365, -0.0810862972725732, -0.3431146182012269),
	vec3(-0.8668109030140122, -0.1312003780802619, -0.4810668552370133),
	vec3(-0.3662917531776543, -0.864929337960137, -0.3431145463105281),
	vec3(-0.2120564591496344, -0.9150434230561556, -0.343114546550555),
	vec3(-0.1430803394630376, -0.8649293403494969, -0.4810667860720864),
	vec3(0.66677671487506, -0.4844416536151999, -0.5663259633311843),
	vec3(0.1116057081309664, 0.08108629559745745, -0.9904388817988051),
	vec3(-0.04262958804632378, 0.1312003798056067, -0.9904388817902221),
	vec3(-0.2546860473879966, -0.7838430461064585, -0.5663259629722333),
	vec3(-0.1379522327079985, 0, -0.990438883268866),
	vec3(0.6380536845617648, 0, 0.7699918802280683),
	vec3(0.6005247749732796, 0.6068251479182845, 0.5207045558637298),
	vec3(0.124643659826608, 0.3836137354140363, 0.91504341977128),
	vec3(-0.3915526414914458, 0.7586523095873944, 0.5207045247535147),
	vec3(-0.3263213311888211, 0.2370863315475067, 0.9150434198465675),
	vec3(-0.8425176382259097, -0.137952245635604, 0.5207045296541302),
	vec3(-0.3263213311888211, -0.2370863315475067, 0.9150434198465675),
	vec3(-0.1291518837831958, -0.8439114816958738, 0.5207045246366956),
	vec3(0.124643659826608, -0.3836137354140363, 0.91504341977128),
	vec3(0.7626973514845153, -0.3836137309624749, 0.5207045759886848),
	vec3(0.6408399563247782, -0.7586523046649289, -0.1173491840800292),
	vec3(0.9643750439601537, -0.2370863358694723, 0.117349239157481),
	vec3(0.8425176382259097, 0.137952245635604, -0.5207045296541302),
	vec3(0.9643750439601537, 0.2370863358694723, 0.117349239157481),
	vec3(0.5234907723733176, 0.8439114766119701, 0.1173491835616762),
	vec3(0.1291518837831958, 0.8439114816958738, -0.5207045246366956),
	vec3(0.07252578670677969, 0.9904388821647107, 0.1173491838867285),
	vec3(-0.6408399563247782, 0.7586523046649289, 0.1173491840800292),
	vec3(-0.7626973514845153, 0.3836137309624749, -0.5207045759886848),
	vec3(-0.9195516510714687, 0.3750385819053184, 0.1173491503769141),
	vec3(-0.9195516510714687, -0.3750385819053184, 0.1173491503769141),
	vec3(-0.6005247749732796, -0.6068251479182845, -0.5207045558637298),
	vec3(-0.6408399563247782, -0.7586523046649289, 0.1173491840800292),
	vec3(0.07252578670677969, -0.9904388821647107, 0.1173491838867285),
	vec3(0.3915526414914458, -0.7586523095873944, -0.5207045247535147),
	vec3(0.3263213311888211, -0.2370863315475067, -0.9150434198465675),
	vec3(0.516196302327633, 0.3750385769492678, -0.7699918462315996),
	vec3(-0.1971694466726691, 0.6068251530229443, -0.7699918460331082),
	vec3(-0.124643659826608, -0.3836137354140363, -0.91504341977128),
	vec3(-0.6380536845617648, 0, -0.7699918802280683),
	vec3(0.3086365441732552, 0.5192584892122319, 0.7969404651426734),
	vec3(0.449298845051711, 0.1330711045231942, 0.8834153207728379),
	vec3(0.6714605482046627, 0.3861873840494224, 0.6324555609730678),
	vec3(-0.3984702295170882, 0.4539905084740856, 0.79694045850618),
	vec3(0.01228284825638614, 0.4684298556043672, 0.8834153055144464),
	vec3(-0.1597932964828671, 0.7579354278236298, 0.6324555238504522),
	vec3(-0.5549046970823517, -0.23867693666269, 0.7969404601733167),
	vec3(-0.4417076539384268, 0.1564344691729744, 0.8834153073763102),
	vec3(-0.7702182686384396, 0.08224246754021672, 0.632455528229852),
	vec3(0.05552027202442999, -0.6015009602503508, 0.7969404583858439),
	vec3(-0.2852731874665643, -0.3717480415260556, 0.8834153055806813),
	vec3(-0.3162277622416949, -0.7071067901469845, 0.6324555239031744),
	vec3(0.5892180779457885, -0.1330711035409922, 0.7969404858734768),
	vec3(0.2653991200755921, -0.3861873874785771, 0.8834153093622348),
	vec3(0.5747787391263857, -0.519258486624235, 0.6324555518904008),
	vec3(0.8910065189945569, -0.4539905099329737, 3.454726769439494e-08),
	vec3(0.7846575974917251, -0.4684298524757175, 0.4060614830393194),
	vec3(0.6371471547070409, -0.7579354242212467, 0.1399192479942657),
	vec3(0.960966146113209, 0.2386769412387386, -0.1399192043475329),
	vec3(0.9876883395323689, -0.1564344717502818, 4.654508631487376e-08),
	vec3(0.9101375108698275, -0.08224246940201979, -0.4060614332023329),
	vec3(0.6879757842842922, 0.6015009566345066, 0.4060614724474446),
	vec3(0.917728710846699, 0.3717480435338905, 0.1399192817891102),
	vec3(0.7071067761333635, 0.7071067862397314, 1.172606089090206e-08),
	vec3(0.06995961807531294, 0.9876883411468217, -0.1399192359948978),
	vec3(0.4539904963987761, 0.8910065258905756, -2.02113841666672e-10),
	vec3(0.3594651834541738, 0.8401778915830602, -0.4060614391681398),
	vec3(-0.3594651834541738, 0.8401778915830602, 0.4060614391681398),
	vec3(-0.06995961807531294, 0.9876883411468217, 0.1399192359948978),
	vec3(-0.4539904963987761, 0.8910065258905756, 2.02113841666672e-10),
	vec3(-0.917728710846699, 0.3717480435338905, -0.1399192817891102),
	vec3(-0.7071067761333635, 0.7071067862397314, -1.172606089090206e-08),
	vec3(-0.6879757842842922, 0.6015009566345066, -0.4060614724474446),
	vec3(-0.9101375108698275, -0.08224246940201979, 0.4060614332023329),
	vec3(-0.960966146113209, 0.2386769412387386, 0.1399192043475329),
	vec3(-0.9876883395323689, -0.1564344717502818, -4.654508631487376e-08),
	vec3(-0.6371471547070409, -0.7579354242212467, -0.1399192479942657),
	vec3(-0.8910065189945569, -0.4539905099329737, -3.454726769439494e-08),
	vec3(-0.7846575974917251, -0.4684298524757175, -0.4060614830393194),
	vec3(-0.2030307196763695, -0.8910065289915158, 0.4060614389007987),
	vec3(-0.5239501143719624, -0.840177888873155, 0.1399192363410274),
	vec3(-0.1564344638058066, -0.9876883407906514, 6.964368351245239e-11),
	vec3(0.5239501143719624, -0.840177888873155, -0.1399192363410274),
	vec3(0.1564344638058066, -0.9876883407906514, -6.964368351245239e-11),
	vec3(0.2030307196763695, -0.8910065289915158, -0.4060614389007987),
	vec3(0.4417076539384268, 0.1564344691729744, -0.8834153073763102),
	vec3(0.7702182686384396, 0.08224246754021672, -0.632455528229852),
	vec3(0.5549046970823517, -0.23867693666269, -0.7969404601733167),
	vec3(0.1597932964828671, 0.7579354278236298, -0.6324555238504522),
	vec3(0.3984702295170882, 0.4539905084740856, -0.79694045850618),
	vec3(-0.01228284825638614, 0.4684298556043672, -0.8834153055144464),
	vec3(0.2852731874665643, -0.3717480415260556, -0.8834153055806813),
	vec3(0.3162277622416949, -0.7071067901469845, -0.6324555239031744),
	vec3(-0.05552027202442999, -0.6015009602503508, -0.7969404583858439),
	vec3(-0.6714605482046627, 0.3861873840494224, -0.6324555609730678),
	vec3(-0.3086365441732552, 0.5192584892122319, -0.7969404651426734),
	vec3(-0.449298845051711, 0.1330711045231942, -0.8834153207728379),
	vec3(-0.5747787391263857, -0.519258486624235, -0.6324555518904008),
	vec3(-0.5892180779457885, -0.1330711035409922, -0.7969404858734768),
	vec3(-0.2653991200755921, -0.3861873874785771, -0.8834153093622348),
	vec3(0.4033553225096194, 0, 0.9150434327413978),
	vec3(0.7626973514845153, 0.3836137309624749, 0.5207045759886848),
	vec3(0.1971694466726691, 0.6068251530229443, 0.7699918460331082),
	vec3(-0.1291518837831958, 0.8439114816958738, 0.5207045246366956),
	vec3(-0.516196302327633, 0.3750385769492678, 0.7699918462315996),
	vec3(-0.8425176382259097, 0.137952245635604, 0.5207045296541302),
	vec3(-0.516196302327633, -0.3750385769492678, 0.7699918462315996),
	vec3(-0.3915526414914458, -0.7586523095873944, 0.5207045247535147),
	vec3(0.1971694466726691, -0.6068251530229443, 0.7699918460331082),
	vec3(0.6005247749732796, -0.6068251479182845, 0.5207045558637298),
	vec3(0.5234907723733176, -0.8439114766119701, 0.1173491835616762),
	vec3(0.9195516510714687, -0.3750385819053184, -0.1173491503769141),
	vec3(0.8425176382259097, -0.137952245635604, -0.5207045296541302),
	vec3(0.9195516510714687, 0.3750385819053184, -0.1173491503769141),
	vec3(0.6408399563247782, 0.7586523046649289, -0.1173491840800292),
	vec3(0.3915526414914458, 0.7586523095873944, -0.5207045247535147),
	vec3(-0.07252578670677969, 0.9904388821647107, -0.1173491838867285),
	vec3(-0.5234907723733176, 0.8439114766119701, -0.1173491835616762),
	vec3(-0.6005247749732796, 0.6068251479182845, -0.5207045558637298),
	vec3(-0.9643750439601537, 0.2370863358694723, -0.117349239157481),
	vec3(-0.9643750439601537, -0.2370863358694723, -0.117349239157481),
	vec3(-0.7626973514845153, -0.3836137309624749, -0.5207045759886848),
	vec3(-0.5234907723733176, -0.8439114766119701, -0.1173491835616762),
	vec3(-0.07252578670677969, -0.9904388821647107, -0.1173491838867285),
	vec3(0.1291518837831958, -0.8439114816958738, -0.5207045246366956),
	vec3(0.516196302327633, -0.3750385769492678, -0.7699918462315996),
	vec3(0.3263213311888211, 0.2370863315475067, -0.9150434198465675),
	vec3(-0.124643659826608, 0.3836137354140363, -0.91504341977128),
	vec3(-0.1971694466726691, -0.6068251530229443, -0.7699918460331082),
	vec3(-0.4033553225096194, 0, -0.9150434327413978),
	vec3(0.8241813111340248, 0, 0.5663260248102676),
	vec3(0.3926382821301419, 0.7838430434806346, 0.4810667963941255),
	vec3(0.04262958804632378, 0.1312003798056067, 0.9904388817902221),
	vec3(-0.6241471262413267, 0.6156420322024284, 0.4810667864136515),
	vec3(-0.1116057081309664, 0.08108629559745745, 0.9904388817988051),
	vec3(-0.7783824251503506, -0.4033553583401605, 0.4810667886222659),
	vec3(-0.1116057081309664, -0.08108629559745745, 0.9904388817988051),
	vec3(0.1430803394630376, -0.8649293403494969, 0.4810667860720864),
	vec3(0.04262958804632378, -0.1312003798056067, 0.9904388817902221),
	vec3(0.8668109030140122, -0.1312003780802619, 0.4810668552370133),
	vec3(0.7094063001095109, -0.6156420300356564, -0.3431145467894223),
	vec3(0.9357870330215365, -0.0810862972725732, 0.3431146182012269),
	vec3(0.7783824251503506, 0.4033553583401605, -0.4810667886222659),
	vec3(0.9357870330215365, 0.0810862972725732, 0.3431146182012269),
	vec3(0.3662917531776543, 0.864929337960137, 0.3431145463105281),
	vec3(-0.1430803394630376, 0.8649293403494969, -0.4810667860720864),
	vec3(0.2120564591496344, 0.9150434230561556, 0.343114546550555),
	vec3(-0.7094063001095109, 0.6156420300356564, 0.3431145467894223),
	vec3(-0.8668109030140122, 0.1312003780802619, -0.4810668552370133),
	vec3(-0.8047289586160284, 0.4844416561645797, 0.3431145361789291),
	vec3(-0.8047289586160284, -0.4844416561645797, 0.3431145361789291),
	vec3(-0.3926382821301419, -0.7838430434806346, -0.4810667963941255),
	vec3(-0.7094063001095109, -0.6156420300356564, 0.3431145467894223),
	vec3(0.2120564591496344, -0.9150434230561556, 0.343114546550555),
	vec3(0.6241471262413267, -0.6156420322024284, -0.4810667864136515),
	vec3(0.1116057081309664, -0.08108629559745745, -0.9904388817988051),
	vec3(0.66677671487506, 0.4844416536151999, -0.5663259633311843),
	vec3(-0.2546860473879966, 0.7838430461064585, -0.5663259629722333),
	vec3(-0.04262958804632378, -0.1312003798056067, -0.9904388817902221),
	vec3(-0.8241813111340248, 0, -0.5663260248102676),
	vec3(0.5747787391263857, 0.519258486624235, 0.6324555518904008),
	vec3(0.2653991200755921, 0.3861873874785771, 0.8834153093622348),
	vec3(0.5892180779457885, 0.1330711035409922, 0.7969404858734768),
	vec3(-0.3162277622416949, 0.7071067901469845, 0.6324555239031744),
	vec3(-0.2852731874665643, 0.3717480415260556, 0.8834153055806813),
	vec3(0.05552027202442999, 0.6015009602503508, 0.7969404583858439),
	vec3(-0.7702182686384396, -0.08224246754021672, 0.632455528229852),
	vec3(-0.4417076539384268, -0.1564344691729744, 0.8834153073763102),
	vec3(-0.5549046970823517, 0.23867693666269, 0.7969404601733167),
	vec3(-0.1597932964828671, -0.7579354278236298, 0.6324555238504522),
	vec3(0.01228284825638614, -0.4684298556043672, 0.8834153055144464),
	vec3(-0.3984702295170882, -0.4539905084740856, 0.79694045850618),
	vec3(0.6714605482046627, -0.3861873840494224, 0.6324555609730678),
	vec3(0.449298845051711, -0.1330711045231942, 0.8834153207728379),
	vec3(0.3086365441732552, -0.5192584892122319, 0.7969404651426734),
	vec3(0.7071067761333635, -0.7071067862397314, 1.172606089090206e-08),
	vec3(0.917728710846699, -0.3717480435338905, 0.1399192817891102),
	vec3(0.6879757842842922, -0.6015009566345066, 0.4060614724474446),
	vec3(0.9101375108698275, 0.08224246940201979, -0.4060614332023329),
	vec3(0.9876883395323689, 0.1564344717502818, 4.654508631487376e-08),
	vec3(0.960966146113209, -0.2386769412387386, -0.1399192043475329),
	vec3(0.6371471547070409, 0.7579354242212467, 0.1399192479942657),
	vec3(0.7846575974917251, 0.4684298524757175, 0.4060614830393194),
	vec3(0.8910065189945569, 0.4539905099329737, 3.454726769439494e-08),
	vec3(0.2030307196763695, 0.8910065289915158, -0.4060614389007987),
	vec3(0.1564344638058066, 0.9876883407906514, -6.964368351245239e-11),
	vec3(0.5239501143719624, 0.840177888873155, -0.1399192363410274),
	vec3(-0.5239501143719624, 0.840177888873155, 0.1399192363410274),
	vec3(-0.2030307196763695, 0.8910065289915158, 0.4060614389007987),
	vec3(-0.1564344638058066, 0.9876883407906514, 6.964368351245239e-11),
	vec3(-0.7846575974917251, 0.4684298524757175, -0.4060614830393194),
	vec3(-0.8910065189945569, 0.4539905099329737, -3.454726769439494e-08),
	vec3(-0.6371471547070409, 0.7579354242212467, -0.1399192479942657),
	vec3(-0.960966146113209, -0.2386769412387386, 0.1399192043475329),
	vec3(-0.9101375108698275, 0.08224246940201979, 0.4060614332023329),
	vec3(-0.9876883395323689, 0.1564344717502818, -4.654508631487376e-08),
	vec3(-0.6879757842842922, -0.6015009566345066, -0.4060614724474446),
	vec3(-0.7071067761333635, -0.7071067862397314, -1.172606089090206e-08),
	vec3(-0.917728710846699, -0.3717480435338905, -0.1399192817891102),
	vec3(-0.06995961807531294, -0.9876883411468217, 0.1399192359948978),
	vec3(-0.3594651834541738, -0.8401778915830602, 0.4060614391681398),
	vec3(-0.4539904963987761, -0.8910065258905756, 2.02113841666672e-10),
	vec3(0.3594651834541738, -0.8401778915830602, -0.4060614391681398),
	vec3(0.4539904963987761, -0.8910065258905756, -2.02113841666672e-10),
	vec3(0.06995961807531294, -0.9876883411468217, -0.1399192359948978),
	vec3(0.4417076539384268, -0.1564344691729744, -0.8834153073763102),
	vec3(0.5549046970823517, 0.23867693666269, -0.7969404601733167),
	vec3(0.7702182686384396, -0.08224246754021672, -0.632455528229852),
	vec3(-0.05552027202442999, 0.6015009602503508, -0.7969404583858439),
	vec3(0.3162277622416949, 0.7071067901469845, -0.6324555239031744),
	vec3(0.2852731874665643, 0.3717480415260556, -0.8834153055806813),
	vec3(-0.01228284825638614, -0.4684298556043672, -0.8834153055144464),
	vec3(0.3984702295170882, -0.4539905084740856, -0.79694045850618),
	vec3(0.1597932964828671, -0.7579354278236298, -0.6324555238504522),
	vec3(-0.5892180779457885, 0.1330711035409922, -0.7969404858734768),
	vec3(-0.5747787391263857, 0.519258486624235, -0.6324555518904008),
	vec3(-0.2653991200755921, 0.3861873874785771, -0.8834153093622348),
	vec3(-0.3086365441732552, -0.5192584892122319, -0.7969404651426734),
	vec3(-0.6714605482046627, -0.3861873840494224, -0.6324555609730678),
	vec3(-0.449298845051711, -0.1330711045231942, -0.8834153207728379),
	vec3(0.4099546661978357, 0.3996070506848672, 0.819909371031679),
	vec3(0.506731829804539, 0.2664047005694781, 0.819909378027493),
	vec3(0.5500118991689517, 0.3996070494052607, 0.7333492461564166),
	vec3(-0.2533659246213241, 0.5133754489949428, 0.8199093587769459),
	vec3(-0.09677716943320852, 0.5642542183564642, 0.8199093587363374),
	vec3(-0.2100858562629002, 0.646577799850411, 0.7333492222255956),
	vec3(-0.5665434373056467, -0.08232358230113269, 0.8199093617242161),
	vec3(-0.5665434373056467, 0.08232358230113269, 0.8199093617242161),
	vec3(-0.6798521256994913, 0, 0.7333492259366495),
	vec3(-0.09677716943320852, -0.5642542183564642, 0.8199093587363374),
	vec3(-0.2533659246213241, -0.5133754489949428, 0.8199093587769459),
	vec3(-0.2100858562629002, -0.646577799850411, 0.7333492222255956),
	vec3(0.506731829804539, -0.2664047005694781, 0.819909378027493),
	vec3(0.4099546661978357, -0.3996070506848672, 0.819909371031679),
	vec3(0.5500118991689517, -0.3996070494052607, 0.7333492461564166),
	vec3(0.8466579059529646, -0.5133754482717764, 0.1400572718536742),
	vec3(0.7766292820817066, -0.5642542161174972, 0.2801145083834144),
	vec3(0.7498807344360752, -0.6465777972617529, 0.1400572604678249),
	vec3(0.9867151600848543, 0.08232358417824362, -0.1400572038374619),
	vec3(0.9867151600848543, -0.08232358417824362, -0.1400572038374619),
	vec3(0.9599666098063316, 0, -0.280114455280227),
	vec3(0.7766292820817066, 0.5642542161174972, 0.2801145083834144),
	vec3(0.8466579059529646, 0.5133754482717764, 0.1400572718536742),
	vec3(0.7498807344360752, 0.6465777972617529, 0.1400572604678249),
	vec3(0.2266173716117238, 0.9638612645605649, -0.1400572367409219),
	vec3(0.3832061246886294, 0.9129824951188945, -0.1400572368983506),
	vec3(0.2966459900281714, 0.9129824961604853, -0.2801144735724587),
	vec3(-0.2966459900281714, 0.9129824961604853, 0.2801144735724587),
	vec3(-0.2266173716117238, 0.9638612645605649, 0.1400572367409219),
	vec3(-0.3832061246886294, 0.9129824951188945, 0.1400572368983506),
	vec3(-0.8466579059529646, 0.5133754482717764, -0.1400572718536742),
	vec3(-0.7498807344360752, 0.6465777972617529, -0.1400572604678249),
	vec3(-0.7766292820817066, 0.5642542161174972, -0.2801145083834144),
	vec3(-0.9599666098063316, 0, 0.280114455280227),
	vec3(-0.9867151600848543, 0.08232358417824362, 0.1400572038374619),
	vec3(-0.9867151600848543, -0.08232358417824362, 0.1400572038374619),
	vec3(-0.7498807344360752, -0.6465777972617529, -0.1400572604678249),
	vec3(-0.8466579059529646, -0.5133754482717764, -0.1400572718536742),
	vec3(-0.7766292820817066, -0.5642542161174972, -0.2801145083834144),
	vec3(-0.2966459900281714, -0.9129824961604853, 0.2801144735724587),
	vec3(-0.3832061246886294, -0.9129824951188945, 0.1400572368983506),
	vec3(-0.2266173716117238, -0.9638612645605649, 0.1400572367409219),
	vec3(0.3832061246886294, -0.9129824951188945, -0.1400572368983506),
	vec3(0.2266173716117238, -0.9638612645605649, -0.1400572367409219),
	vec3(0.2966459900281714, -0.9129824961604853, -0.2801144735724587),
	vec3(0.5665434373056467, 0.08232358230113269, -0.8199093617242161),
	vec3(0.6798521256994913, 0, -0.7333492259366495),
	vec3(0.5665434373056467, -0.08232358230113269, -0.8199093617242161),
	vec3(0.2100858562629002, 0.646577799850411, -0.7333492222255956),
	vec3(0.2533659246213241, 0.5133754489949428, -0.8199093587769459),
	vec3(0.09677716943320852, 0.5642542183564642, -0.8199093587363374),
	vec3(0.2533659246213241, -0.5133754489949428, -0.8199093587769459),
	vec3(0.2100858562629002, -0.646577799850411, -0.7333492222255956),
	vec3(0.09677716943320852, -0.5642542183564642, -0.8199093587363374),
	vec3(-0.5500118991689517, 0.3996070494052607, -0.7333492461564166),
	vec3(-0.4099546661978357, 0.3996070506848672, -0.819909371031679),
	vec3(-0.506731829804539, 0.2664047005694781, -0.819909378027493),
	vec3(-0.5500118991689517, -0.3996070494052607, -0.7333492461564166),
	vec3(-0.506731829804539, -0.2664047005694781, -0.819909378027493),
	vec3(-0.4099546661978357, -0.3996070506848672, -0.819909371031679),
	vec3(0.3695400909736716, 0.711281735495454, 0.5979284354450336),
	vec3(0.341154324930319, 0.6202395829170048, 0.7063402766119729),
	vec3(0.4792010812969229, 0.6202395810980263, 0.6210226934043592),
	vec3(0.181208064253859, 0.1316553722158737, 0.9745924791501673),
	vec3(0.3208199100385678, 0.1327924773204121, 0.9377850197619673),
	vec3(0.2254319522962262, 0.2640827517398355, 0.9377850154046121),
	vec3(0.790663263062189, 0.1316553706317965, 0.5979284805289478),
	vec3(0.7379641468123296, 0.2640827490310694, 0.6210227207467885),
	vec3(0.6953053477032212, 0.132792476188007, 0.7063403087203508),
	vec3(-0.5622749563493212, 0.5712516699760317, 0.5979284263287403),
	vec3(-0.484460408669222, 0.5161216300240885, 0.7063402688883939),
	vec3(-0.441801611599371, 0.6474119038631433, 0.6210226748875588),
	vec3(-0.06921532380681002, 0.2130228687798916, 0.9745924770523849),
	vec3(-0.02715433878700868, 0.346153018844607, 0.9377850123721352),
	vec3(-0.1814953129006053, 0.2960045977985254, 0.9377850123974283),
	vec3(0.1191167015966522, 0.7926492343412211, 0.597928426067042),
	vec3(-0.02311414410080619, 0.7834517048389895, 0.6210226747288444),
	vec3(0.08856803304570114, 0.7023098520826699, 0.7063402687020144),
	vec3(-0.7170451308061174, -0.3582288024884039, 0.5979284283716256),
	vec3(-0.6405673304414007, -0.3012588868807266, 0.7063402708656522),
	vec3(-0.7522495095195809, -0.2201170331889808, 0.6210226784326247),
	vec3(-0.2239854959239761, 0, 0.9745924777134752),
	vec3(-0.3376022330652917, 0.08114185377861541, 0.937785013633028),
	vec3(-0.3376022330652917, -0.08114185377861541, 0.937785013633028),
	vec3(-0.7170451308061174, 0.3582288024884039, 0.5979284283716256),
	vec3(-0.7522495095195809, 0.2201170331889808, 0.6210226784326247),
	vec3(-0.6405673304414007, 0.3012588868807266, 0.7063402708656522),
	vec3(0.1191167015966522, -0.7926492343412211, 0.597928426067042),
	vec3(0.08856803304570114, -0.7023098520826699, 0.7063402687020144),
	vec3(-0.02311414410080619, -0.7834517048389895, 0.6210226747288444),
	vec3(-0.06921532380681002, -0.2130228687798916, 0.9745924770523849),
	vec3(-0.1814953129006053, -0.2960045977985254, 0.9377850123974283),
	vec3(-0.02715433878700868, -0.346153018844607, 0.9377850123721352),
	vec3(-0.5622749563493212, -0.5712516699760317, 0.5979284263287403),
	vec3(-0.441801611599371, -0.6474119038631433, 0.6210226748875588),
	vec3(-0.484460408669222, -0.5161216300240885, 0.7063402688883939),
	vec3(0.790663263062189, -0.1316553706317965, 0.5979284805289478),
	vec3(0.6953053477032212, -0.132792476188007, 0.7063403087203508),
	vec3(0.7379641468123296, -0.2640827490310694, 0.6210227207467885),
	vec3(0.181208064253859, -0.1316553722158737, 0.9745924791501673),
	vec3(0.2254319522962262, -0.2640827517398355, 0.9377850154046121),
	vec3(0.3208199100385678, -0.1327924773204121, 0.9377850197619673),
	vec3(0.3695400909736716, -0.711281735495454, 0.5979284354450336),
	vec3(0.4792010812969229, -0.6202395810980263, 0.6210226934043592),
	vec3(0.341154324930319, -0.6202395829170048, 0.7063402766119729),
	vec3(0.7862604526380321, -0.5712516698332614, -0.2355122721434008),
	vec3(0.848427226691192, -0.5161216311557084, -0.1174295655372357),
	vec3(0.7530392579353233, -0.6474119017224308, -0.1174295768380487),
	vec3(0.9026560226116191, -0.2130228686542205, 0.3739429933469791),
	vec3(0.8509241836557593, -0.3461530171424835, 0.3951026732292952),
	vec3(0.9199475716491957, -0.2960045988667242, 0.2570559138913119),
	vec3(0.4815328378663605, -0.7926492307506445, 0.3739429408971122),
	vec3(0.5657965290270652, -0.7834517007553785, 0.2570558700446854),
	vec3(0.5921611099116828, -0.7023098480828698, 0.3951026413401716),
	vec3(0.8554757824966849, 0.3582288050993348, -0.3739429217926016),
	vec3(0.9182403697927125, 0.3012588907720733, -0.2570558383186869),
	vec3(0.8918757853466004, 0.2201170351596021, -0.3951026124248375),
	vec3(0.9718713565108024, 0, 0.2355123487077762),
	vec3(0.9897607174386858, -0.08114185546378656, 0.1174296449247478),
	vec3(0.9897607174386858, 0.08114185546378656, 0.1174296449247478),
	vec3(0.8554757824966849, -0.3582288050993348, -0.3739429217926016),
	vec3(0.8918757853466004, -0.2201170351596021, -0.3951026124248375),
	vec3(0.9182403697927125, -0.3012588907720733, -0.2570558383186869),
	vec3(0.4815328378663605, 0.7926492307506445, 0.3739429408971122),
	vec3(0.5921611099116828, 0.7023098480828698, 0.3951026413401716),
	vec3(0.5657965290270652, 0.7834517007553785, 0.2570558700446854),
	vec3(0.9026560226116191, 0.2130228686542205, 0.3739429933469791),
	vec3(0.9199475716491957, 0.2960045988667242, 0.2570559138913119),
	vec3(0.8509241836557593, 0.3461530171424835, 0.3951026732292952),
	vec3(0.7862604526380321, 0.5712516698332614, -0.2355122721434008),
	vec3(0.7530392579353233, 0.6474119017224308, -0.1174295768380487),
	vec3(0.848427226691192, 0.5161216311557084, -0.1174295655372357),
	vec3(-0.07633927733231499, 0.9243046034206623, -0.3739429299127768),
	vec3(-0.002762344395900058, 0.9663925988454489, -0.2570558584241521),
	vec3(0.06626103591946797, 0.9162441789999279, -0.3951026190341278),
	vec3(0.300324770700046, 0.9243046016710172, 0.2355122829785045),
	vec3(0.3830233692272967, 0.9162441762123739, 0.1174295881908749),
	vec3(0.2286823971505686, 0.9663925977660102, 0.117429588335019),
	vec3(0.6050523776467045, 0.7029070388504071, -0.3739429301893834),
	vec3(0.4849485012165494, 0.7802043779857945, -0.3951026192517862),
	vec3(0.5702660928504041, 0.7802043763376512, -0.2570558586936138),
	vec3(-0.6050523776467045, 0.7029070388504071, 0.3739429301893834),
	vec3(-0.4849485012165494, 0.7802043779857945, 0.3951026192517862),
	vec3(-0.5702660928504041, 0.7802043763376512, 0.2570558586936138),
	vec3(0.07633927733231499, 0.9243046034206623, 0.3739429299127768),
	vec3(0.002762344395900058, 0.9663925988454489, 0.2570558584241521),
	vec3(-0.06626103591946797, 0.9162441789999279, 0.3951026190341278),
	vec3(-0.300324770700046, 0.9243046016710172, -0.2355122829785045),
	vec3(-0.3830233692272967, 0.9162441762123739, -0.1174295881908749),
	vec3(-0.2286823971505686, 0.9663925977660102, -0.117429588335019),
	vec3(-0.9026560226116191, 0.2130228686542205, -0.3739429933469791),
	vec3(-0.9199475716491957, 0.2960045988667242, -0.2570559138913119),
	vec3(-0.8509241836557593, 0.3461530171424835, -0.3951026732292952),
	vec3(-0.7862604526380321, 0.5712516698332614, 0.2355122721434008),
	vec3(-0.7530392579353233, 0.6474119017224308, 0.1174295768380487),
	vec3(-0.848427226691192, 0.5161216311557084, 0.1174295655372357),
	vec3(-0.4815328378663605, 0.7926492307506445, -0.3739429408971122),
	vec3(-0.5921611099116828, 0.7023098480828698, -0.3951026413401716),
	vec3(-0.5657965290270652, 0.7834517007553785, -0.2570558700446854),
	vec3(-0.8554757824966849, -0.3582288050993348, 0.3739429217926016),
	vec3(-0.8918757853466004, -0.2201170351596021, 0.3951026124248375),
	vec3(-0.9182403697927125, -0.3012588907720733, 0.2570558383186869),
	vec3(-0.8554757824966849, 0.3582288050993348, 0.3739429217926016),
	vec3(-0.9182403697927125, 0.3012588907720733, 0.2570558383186869),
	vec3(-0.8918757853466004, 0.2201170351596021, 0.3951026124248375),
	vec3(-0.9718713565108024, 0, -0.2355123487077762),
	vec3(-0.9897607174386858, -0.08114185546378656, -0.1174296449247478),
	vec3(-0.9897607174386858, 0.08114185546378656, -0.1174296449247478),
	vec3(-0.4815328378663605, -0.7926492307506445, -0.3739429408971122),
	vec3(-0.5657965290270652, -0.7834517007553785, -0.2570558700446854),
	vec3(-0.5921611099116828, -0.7023098480828698, -0.3951026413401716),
	vec3(-0.7862604526380321, -0.5712516698332614, 0.2355122721434008),
	vec3(-0.848427226691192, -0.5161216311557084, 0.1174295655372357),
	vec3(-0.7530392579353233, -0.6474119017224308, 0.1174295768380487),
	vec3(-0.9026560226116191, -0.2130228686542205, -0.3739429933469791),
	vec3(-0.8509241836557593, -0.3461530171424835, -0.3951026732292952),
	vec3(-0.9199475716491957, -0.2960045988667242, -0.2570559138913119),
	vec3(0.07633927733231499, -0.9243046034206623, 0.3739429299127768),
	vec3(-0.06626103591946797, -0.9162441789999279, 0.3951026190341278),
	vec3(0.002762344395900058, -0.9663925988454489, 0.2570558584241521),
	vec3(-0.6050523776467045, -0.7029070388504071, 0.3739429301893834),
	vec3(-0.5702660928504041, -0.7802043763376512, 0.2570558586936138),
	vec3(-0.4849485012165494, -0.7802043779857945, 0.3951026192517862),
	vec3(-0.300324770700046, -0.9243046016710172, -0.2355122829785045),
	vec3(-0.2286823971505686, -0.9663925977660102, -0.117429588335019),
	vec3(-0.3830233692272967, -0.9162441762123739, -0.1174295881908749),
	vec3(0.6050523776467045, -0.7029070388504071, -0.3739429301893834),
	vec3(0.5702660928504041, -0.7802043763376512, -0.2570558586936138),
	vec3(0.4849485012165494, -0.7802043779857945, -0.3951026192517862),
	vec3(0.300324770700046, -0.9243046016710172, 0.2355122829785045),
	vec3(0.2286823971505686, -0.9663925977660102, 0.117429588335019),
	vec3(0.3830233692272967, -0.9162441762123739, 0.1174295881908749),
	vec3(-0.07633927733231499, -0.9243046034206623, -0.3739429299127768),
	vec3(0.06626103591946797, -0.9162441789999279, -0.3951026190341278),
	vec3(-0.002762344395900058, -0.9663925988454489, -0.2570558584241521),
	vec3(0.2239854959239761, 0, -0.9745924777134752),
	vec3(0.3376022330652917, 0.08114185377861541, -0.937785013633028),
	vec3(0.3376022330652917, -0.08114185377861541, -0.937785013633028),
	vec3(0.7170451308061174, 0.3582288024884039, -0.5979284283716256),
	vec3(0.7522495095195809, 0.2201170331889808, -0.6210226784326247),
	vec3(0.6405673304414007, 0.3012588868807266, -0.7063402708656522),
	vec3(0.7170451308061174, -0.3582288024884039, -0.5979284283716256),
	vec3(0.6405673304414007, -0.3012588868807266, -0.7063402708656522),
	vec3(0.7522495095195809, -0.2201170331889808, -0.6210226784326247),
	vec3(-0.1191167015966522, 0.7926492343412211, -0.597928426067042),
	vec3(0.02311414410080619, 0.7834517048389895, -0.6210226747288444),
	vec3(-0.08856803304570114, 0.7023098520826699, -0.7063402687020144),
	vec3(0.5622749563493212, 0.5712516699760317, -0.5979284263287403),
	vec3(0.484460408669222, 0.5161216300240885, -0.7063402688883939),
	vec3(0.441801611599371, 0.6474119038631433, -0.6210226748875588),
	vec3(0.06921532380681002, 0.2130228687798916, -0.9745924770523849),
	vec3(0.02715433878700868, 0.346153018844607, -0.9377850123721352),
	vec3(0.1814953129006053, 0.2960045977985254, -0.9377850123974283),
	vec3(0.06921532380681002, -0.2130228687798916, -0.9745924770523849),
	vec3(0.1814953129006053, -0.2960045977985254, -0.9377850123974283),
	vec3(0.02715433878700868, -0.346153018844607, -0.9377850123721352),
	vec3(0.5622749563493212, -0.5712516699760317, -0.5979284263287403),
	vec3(0.441801611599371, -0.6474119038631433, -0.6210226748875588),
	vec3(0.484460408669222, -0.5161216300240885, -0.7063402688883939),
	vec3(-0.1191167015966522, -0.7926492343412211, -0.597928426067042),
	vec3(-0.08856803304570114, -0.7023098520826699, -0.7063402687020144),
	vec3(0.02311414410080619, -0.7834517048389895, -0.6210226747288444),
	vec3(-0.790663263062189, 0.1316553706317965, -0.5979284805289478),
	vec3(-0.7379641468123296, 0.2640827490310694, -0.6210227207467885),
	vec3(-0.6953053477032212, 0.132792476188007, -0.7063403087203508),
	vec3(-0.3695400909736716, 0.711281735495454, -0.5979284354450336),
	vec3(-0.341154324930319, 0.6202395829170048, -0.7063402766119729),
	vec3(-0.4792010812969229, 0.6202395810980263, -0.6210226934043592),
	vec3(-0.181208064253859, 0.1316553722158737, -0.9745924791501673),
	vec3(-0.3208199100385678, 0.1327924773204121, -0.9377850197619673),
	vec3(-0.2254319522962262, 0.2640827517398355, -0.9377850154046121),
	vec3(-0.3695400909736716, -0.711281735495454, -0.5979284354450336),
	vec3(-0.4792010812969229, -0.6202395810980263, -0.6210226934043592),
	vec3(-0.341154324930319, -0.6202395829170048, -0.7063402766119729),
	vec3(-0.790663263062189, -0.1316553706317965, -0.5979284805289478),
	vec3(-0.6953053477032212, -0.132792476188007, -0.7063403087203508),
	vec3(-0.7379641468123296, -0.2640827490310694, -0.6210227207467885),
	vec3(-0.181208064253859, -0.1316553722158737, -0.9745924791501673),
	vec3(-0.2254319522962262, -0.2640827517398355, -0.9377850154046121),
	vec3(-0.3208199100385678, -0.1327924773204121, -0.9377850197619673),
	vec3(0.0691415820296805, 0, 0.9976068572511083),
	vec3(0.8827315327616699, 0.06575755627407728, 0.4652536779662192),
	vec3(0.2661766256963305, 0.8192074093886291, 0.50798545681514),
	vec3(0.2102399071495789, 0.8598478147710262, 0.4652536049029899),
	vec3(-0.6968594388377338, 0.5062980325447761, 0.5079854572170817),
	vec3(-0.7527961586136724, 0.46565762663815, 0.4652536064666494),
	vec3(-0.6968594388377338, -0.5062980325447761, 0.5079854572170817),
	vec3(-0.6754935127675508, -0.572055589053028, 0.4652536052973131),
	vec3(0.2661766256963305, -0.8192074093886291, 0.50798545681514),
	vec3(0.3353182087231465, -0.819207407955155, 0.4652536100344591),
	vec3(0.3221133431146726, -0.8598478134937279, 0.3961120192793256),
	vec3(0.7660010265951327, -0.5062980339365184, -0.3961120145706497),
	vec3(0.7527961586136724, -0.46565762663815, -0.4652536064666494),
	vec3(0.7660010265951327, 0.5062980339365184, -0.3961120145706497),
	vec3(0.7182253630664412, 0.5720555879139837, -0.3961120197424781),
	vec3(0.6754935127675508, 0.572055589053028, -0.4652536052973131),
	vec3(-0.2448106998357109, 0.8849649650222424, -0.3961120194201772),
	vec3(-0.3221133431146726, 0.8598478134937279, -0.3961120192793256),
	vec3(-0.3353182087231465, 0.819207407955155, -0.4652536100344591),
	vec3(-0.9173023309635631, 0.04064040695560462, -0.3961120938967863),
	vec3(-0.9173023309635631, -0.04064040695560462, -0.3961120938967863),
	vec3(-0.8827315327616699, -0.06575755627407728, -0.4652536779662192),
	vec3(-0.3221133431146726, -0.8598478134937279, -0.3961120192793256),
	vec3(-0.2448106998357109, -0.8849649650222424, -0.3961120194201772),
	vec3(-0.2102399071495789, -0.8598478147710262, -0.4652536049029899),
	vec3(0.6968594388377338, -0.5062980325447761, -0.5079854572170817),
	vec3(0.05593671863869709, 0.04064040610688723, -0.9976068568827113),
	vec3(-0.02136592574134023, 0.06575755714824381, -0.9976068568805605),
	vec3(-0.2661766256963305, -0.8192074093886291, -0.50798545681514),
	vec3(-0.0691415820296805, 0, -0.9976068572511083),
	vec3(0.5832882742641752, 0, 0.8122652209136619),
	vec3(0.6459035960123568, 0.5547401455638538, 0.5244729883970199),
	vec3(0.1438961194666474, 0.442866712811342, 0.8849649605979418),
	vec3(-0.327994032986502, 0.7857149844942375, 0.5244729520828214),
	vec3(-0.3767249238592107, 0.27370668621296, 0.8849649606993444),
	vec3(-0.8486150822583008, -0.06914158854026285, 0.5244729572607784),
	vec3(-0.3767249238592107, -0.27370668621296, 0.8849649606993444),
	vec3(-0.1964789196507752, -0.8284468339777816, 0.5244729520242717),
	vec3(0.1438961194666474, -0.442866712811342, 0.8849649605979418),
	vec3(0.727184400855205, -0.4428667079544819, 0.5244729984836363),
	vec3(0.6157862668643198, -0.7857149792712613, -0.05881534570217478),
	vec3(0.9600132272913174, -0.273706690928425, 0.05881539566066786),
	vec3(0.8486150822583008, 0.06914158854026285, -0.5244729572607784),
	vec3(0.9600132272913174, 0.273706690928425, 0.05881539566066786),
	vec3(0.5569709213577366, 0.8284468286699294, 0.05881534518007033),
	vec3(0.1964789196507752, 0.8284468339777816, -0.5244729520242717),
	vec3(0.03634988382434518, 0.9976068569744072, 0.05881534547719083),
	vec3(-0.6157862668643198, 0.7857149792712613, 0.05881534570217478),
	vec3(-0.727184400855205, 0.4428667079544819, -0.5244729984836363),
	vec3(-0.9375477677821279, 0.3428482796791154, 0.05881530623758086),
	vec3(-0.9375477677821279, -0.3428482796791154, 0.05881530623758086),
	vec3(-0.6459035960123568, -0.5547401455638538, -0.5244729883970199),
	vec3(-0.6157862668643198, -0.7857149792712613, 0.05881534570217478),
	vec3(0.03634988382434518, -0.9976068569744072, 0.05881534547719083),
	vec3(0.327994032986502, -0.7857149844942375, -0.5244729520828214),
	vec3(0.3767249238592107, -0.27370668621296, -0.8849649606993444),
	vec3(0.4718901534427998, 0.3428482746302798, -0.8122651929430258),
	vec3(-0.1802460033642198, 0.5547401507640806, -0.8122651927797169),
	vec3(-0.1438961194666474, -0.442866712811342, -0.8849649605979418),
	vec3(-0.5832882742641752, 0, -0.8122652209136619),
	vec3(0.2362765593149162, 0.5112051208578973, 0.8263429747550151),
	vec3(0.4890224553408556, 0.06674129338289006, 0.8697141127577384),
	vec3(0.6819278990718476, 0.4444638247643474, 0.5808840236598899),
	vec3(-0.4131714861908644, 0.3826834407592372, 0.8263429718751795),
	vec3(0.08764151922866649, 0.4857122181526711, 0.8697140939668068),
	vec3(-0.211982896371649, 0.7858988792519084, 0.5808839843174202),
	vec3(-0.4916305832033238, -0.2746937587050914, 0.8263429727344627),
	vec3(-0.4348570477989103, 0.2334453699588763, 0.8697140951050405),
	vec3(-0.8129405645747626, 0.04124838879026752, 0.5808839891846503),
	vec3(0.109327080466277, -0.5524535116371868, 0.8263429717474826),
	vec3(-0.3563979512832385, -0.3414350522495877, 0.8697140940656484),
	vec3(-0.2904419924647737, -0.7604059742956296, 0.5808839843450726),
	vec3(0.5591984008720434, -0.0667412928995105, 0.8263429967539213),
	vec3(0.2145909979735989, -0.4444638289867313, 0.8697140957298257),
	vec3(0.6334375146361062, -0.511205116995859, 0.5808840188960983),
	vec3(0.923879527722436, -0.382683443926396, 3.98057423179899e-08),
	vec3(0.7387014375560701, -0.4857122139747437, 0.4673369569682546),
	vec3(0.6143600687019951, -0.7858988749292943, 0.07017595292797471),
	vec3(0.9589675062742516, 0.2746937635775325, -0.07017590869916669),
	vec3(0.9723699180187415, -0.2334453737648788, 4.582320146211041e-08),
	vec3(0.8831165150134035, -0.0412483897372541, -0.4673369140723472),
	vec3(0.6902110515244972, 0.552453507378411, 0.4673369518224937),
	vec3(0.9372819388055479, 0.3414350557145615, 0.07017599246257616),
	vec3(0.6494480437124178, 0.7604059695439755, 5.749916287231103e-09),
	vec3(0.03508797354522289, 0.9969173338714753, -0.07017594701234098),
	vec3(0.5224985609862104, 0.8526401666396787, -2.326132204614924e-10),
	vec3(0.3121275523710819, 0.827147266026392, -0.4673369141806615),
	vec3(-0.3121275523710819, 0.827147266026392, 0.4673369141806615),
	vec3(-0.03508797354522289, 0.9969173338714753, 0.07017594701234098),
	vec3(-0.5224985609862104, 0.8526401666396787, 2.326132204614924e-10),
	vec3(-0.9372819388055479, 0.3414350557145615, -0.07017599246257616),
	vec3(-0.6494480437124178, 0.7604059695439755, -5.749916287231103e-09),
	vec3(-0.6902110515244972, 0.552453507378411, -0.4673369518224937),
	vec3(-0.8831165150134035, -0.0412483897372541, 0.4673369140723472),
	vec3(-0.9589675062742516, 0.2746937635775325, 0.07017590869916669),
	vec3(-0.9723699180187415, -0.2334453737648788, -4.582320146211041e-08),
	vec3(-0.6143600687019951, -0.7858988749292943, -0.07017595292797471),
	vec3(-0.923879527722436, -0.382683443926396, -3.98057423179899e-08),
	vec3(-0.7387014375560701, -0.4857122139747437, -0.4673369569682546),
	vec3(-0.2336684572716483, -0.8526401708033698, 0.4673369140231576),
	vec3(-0.5575865344613419, -0.8271472619824312, 0.07017594732070147),
	vec3(-0.07845909510486554, -0.9969173337821574, 3.492951780075611e-11),
	vec3(0.5575865344613419, -0.8271472619824312, -0.07017594732070147),
	vec3(0.07845909510486554, -0.9969173337821574, -3.492951780075611e-11),
	vec3(0.2336684572716483, -0.8526401708033698, -0.4673369140231576),
	vec3(0.4348570477989103, 0.2334453699588763, -0.8697140951050405),
	vec3(0.8129405645747626, 0.04124838879026752, -0.5808839891846503),
	vec3(0.4916305832033238, -0.2746937587050914, -0.8263429727344627),
	vec3(0.211982896371649, 0.7858988792519084, -0.5808839843174202),
	vec3(0.4131714861908644, 0.3826834407592372, -0.8263429718751795),
	vec3(-0.08764151922866649, 0.4857122181526711, -0.8697140939668068),
	vec3(0.3563979512832385, -0.3414350522495877, -0.8697140940656484),
	vec3(0.2904419924647737, -0.7604059742956296, -0.5808839843450726),
	vec3(-0.109327080466277, -0.5524535116371868, -0.8263429717474826),
	vec3(-0.6819278990718476, 0.4444638247643474, -0.5808840236598899),
	vec3(-0.2362765593149162, 0.5112051208578973, -0.8263429747550151),
	vec3(-0.4890224553408556, 0.06674129338289006, -0.8697141127577384),
	vec3(-0.6334375146361062, -0.511205116995859, -0.5808840188960983),
	vec3(-0.5591984008720434, -0.0667412928995105, -0.8263429967539213),
	vec3(-0.2145909979735989, -0.4444638289867313, -0.8697140957298257),
	vec3(0.3391224850787188, 0, 0.9407422283038188),
	vec3(0.7945598144940891, 0.3225246689586165, 0.5144439124960597),
	vec3(0.2131491805717815, 0.6560057164024883, 0.724033097909782),
	vec3(-0.06120669004524833, 0.8553369275918693, 0.5144438564035986),
	vec3(-0.5580317879562956, 0.405433837289968, 0.7240330981458181),
	vec3(-0.8323876634797095, 0.2061026237737758, 0.5144438610386511),
	vec3(-0.5580317879562956, -0.405433837289968, 0.7240330981458181),
	vec3(-0.4532371670181834, -0.7279585076516062, 0.5144438565781282),
	vec3(0.2131491805717815, -0.6560057164024883, 0.724033097909782),
	vec3(0.5522716706393702, -0.656005711591358, 0.5144438824290898),
	vec3(0.487505046861351, -0.8553369229124217, 0.1753213551950297),
	vec3(0.8971542965382148, -0.4054338419610345, -0.1753213278404425),
	vec3(0.8323876634797095, -0.2061026237737758, -0.5144438610386511),
	vec3(0.8971542965382148, 0.4054338419610345, -0.1753213278404425),
	vec3(0.6628264025075711, 0.7279585031936079, -0.1753213557071503),
	vec3(0.4532371670181834, 0.7279585076516062, -0.5144438565781282),
	vec3(-0.1083545604279483, 0.9785303835487571, -0.1753213555343111),
	vec3(-0.487505046861351, 0.8553369229124217, -0.1753213551950297),
	vec3(-0.5522716706393702, 0.656005711591358, -0.5144438824290898),
	vec3(-0.9641210851978887, 0.1993312176382351, -0.17532141555356),
	vec3(-0.9641210851978887, -0.1993312176382351, -0.17532141555356),
	vec3(-0.7945598144940891, -0.3225246689586165, -0.5144439124960597),
	vec3(-0.487505046861351, -0.8553369229124217, -0.1753213551950297),
	vec3(-0.1083545604279483, -0.9785303835487571, -0.1753213555343111),
	vec3(0.06120669004524833, -0.8553369275918693, -0.5144438564035986),
	vec3(0.5580317879562956, -0.405433837289968, -0.7240330981458181),
	vec3(0.2743558712229135, 0.1993312138369612, -0.9407422192693382),
	vec3(-0.104794619952777, 0.3225246728738732, -0.9407422192165897),
	vec3(-0.2131491805717815, -0.6560057164024883, -0.724033097909782),
	vec3(-0.3391224850787188, 0, -0.9407422283038188),
	vec3(0.7830522503055501, 0, 0.621955925521587),
	vec3(0.4480790764428009, 0.7447269820578122, 0.4945774595037966),
	vec3(0.06368921294067212, 0.1960152398905703, 0.9785303827095202),
	vec3(-0.5698133929799876, 0.6562818364303699, 0.4945774442412589),
	vec3(-0.1667405207587081, 0.1211440828675967, 0.9785303827287549),
	vec3(-0.8002431304713398, -0.3391225157760805, 0.494577447349889),
	vec3(-0.1667405207587081, -0.1211440828675967, 0.9785303827287549),
	vec3(0.07523594833185734, -0.8658710666204572, 0.4945774439540869),
	vec3(0.06368921294067212, -0.1960152398905703, 0.9785303827095202),
	vec3(0.846741468417424, -0.1960152373598238, 0.494577508976173),
	vec3(0.697191815747175, -0.6562818333601719, -0.2884748295026258),
	vec3(0.9497927900644807, -0.1211440853246669, 0.2884748975775517),
	vec3(0.8002431304713398, 0.3391225157760805, -0.494577447349889),
	vec3(0.9497927900644807, 0.1211440853246669, 0.2884748975775517),
	vec3(0.4087169861696529, 0.8658710632905365, 0.2884748290102819),
	vec3(-0.07523594833185734, 0.8658710666204572, -0.4945774439540869),
	vec3(0.1782872555910661, 0.9407422215180659, 0.288474829312819),
	vec3(-0.697191815747175, 0.6562818333601719, 0.2884748295026258),
	vec3(-0.846741468417424, 0.1960152373598238, -0.494577508976173),
	vec3(-0.8396052271382272, 0.4602666017446594, 0.2884748132516749),
	vec3(-0.8396052271382272, -0.4602666017446594, 0.2884748132516749),
	vec3(-0.4480790764428009, -0.7447269820578122, -0.4945774595037966),
	vec3(-0.697191815747175, -0.6562818333601719, 0.2884748295026258),
	vec3(0.1782872555910661, -0.9407422215180659, 0.288474829312819),
	vec3(0.5698133929799876, -0.6562818364303699, -0.4945774442412589),
	vec3(0.1667405207587081, -0.1211440828675967, -0.9785303827287549),
	vec3(0.6335026067004427, 0.4602665982674692, -0.621955871282711),
	vec3(-0.2419764687558151, 0.7447269856392674, -0.6219558709660326),
	vec3(-0.06368921294067212, -0.1960152398905703, -0.9785303827095202),
	vec3(-0.7830522503055501, 0, -0.621955925521587),
	vec3(0.5125762620231672, 0.5241104554330811, 0.6801277866078446),
	vec3(0.3145709684469798, 0.3255299724500799, 0.8916699741759726),
	vec3(0.6156050296908593, 0.1985804865913292, 0.7626245719647822),
	vec3(-0.3400638826724031, 0.6494480574206308, 0.6801277647724278),
	vec3(-0.2123896195833197, 0.3997690805039968, 0.8916699679624978),
	vec3(0.001371162637170271, 0.6468399553590048, 0.7626245420022771),
	vec3(-0.7227473208227106, -0.1227294941155373, 0.6801277685242222),
	vec3(-0.4458349853637033, -0.07845909781352496, 0.8916699702221862),
	vec3(-0.6147576388858986, 0.2011885918974407, 0.7626245445314229),
	vec3(-0.1066185177672842, -0.7252990523615556, 0.6801277646975873),
	vec3(-0.06315155055998029, -0.4482594672228027, 0.8916699679292777),
	vec3(-0.3813122713286946, -0.5224985736859317, 0.7626245421112009),
	vec3(0.6568534198391829, -0.3255299697286946, 0.6801277995009508),
	vec3(0.4068051581430956, -0.1985804881030303, 0.8916699798989161),
	vec3(0.3790936823552179, -0.5241104567310809, 0.7626245531999998),
	vec3(0.7604059602616986, -0.6494480545805675, 1.7629910431845e-08),
	vec3(0.8925173803689549, -0.3997690811105679, 0.2087999222398098),
	vec3(0.681498917189325, -0.6468399521505417, 0.3422824888475347),
	vec3(0.9315472055860589, 0.1227294968281773, -0.3422824482399107),
	vec3(0.9969173334666134, 0.07845909911421987, 4.698000520788432e-08),
	vec3(0.9570401093324565, -0.2011885959965202, -0.208799851460361),
	vec3(0.656006016288201, 0.7252990491767123, 0.2087998942936552),
	vec3(0.825776082549864, 0.4482594652487249, 0.3422825051087588),
	vec3(0.8526401589374363, 0.5224985735551272, 2.90757976831514e-08),
	vec3(0.171141230235898, 0.9238795358852286, -0.3422824600908406),
	vec3(0.2334453620329866, 0.9723699208353206, -1.039284727632488e-10),
	vec3(0.4870833676890085, 0.8480285398400005, -0.2087998767661778),
	vec3(-0.4870833676890085, 0.8480285398400005, 0.2087998767661778),
	vec3(-0.171141230235898, 0.9238795358852286, 0.3422824600908406),
	vec3(-0.2334453620329866, 0.9723699208353206, 1.039284727632488e-10),
	vec3(-0.825776082549864, 0.4482594652487249, -0.3422825051087588),
	vec3(-0.8526401589374363, 0.5224985735551272, -2.90757976831514e-08),
	vec3(-0.656006016288201, 0.7252990491767123, -0.2087998942936552),
	vec3(-0.9570401093324565, -0.2011885959965202, 0.208799851460361),
	vec3(-0.9315472055860589, 0.1227294968281773, 0.3422824482399107),
	vec3(-0.9969173334666134, 0.07845909911421987, -4.698000520788432e-08),
	vec3(-0.681498917189325, -0.6468399521505417, -0.3422824888475347),
	vec3(-0.7604059602616986, -0.6494480545805675, -1.7629910431845e-08),
	vec3(-0.8925173803689549, -0.3997690811105679, -0.2087999222398098),
	vec3(-0.1043999383153924, -0.972369921632584, 0.2087998763983937),
	vec3(-0.4045865922105127, -0.8480285411991428, 0.3422824604257981),
	vec3(-0.3826834294784014, -0.9238795337069922, 1.70368363848123e-10),
	vec3(0.4045865922105127, -0.8480285411991428, -0.3422824604257981),
	vec3(0.3826834294784014, -0.9238795337069922, -1.70368363848123e-10),
	vec3(0.1043999383153924, -0.972369921632584, -0.2087998763983937),
	vec3(0.4458349853637033, -0.07845909781352496, -0.8916699702221862),
	vec3(0.6147576388858986, 0.2011885918974407, -0.7626245445314229),
	vec3(0.7227473208227106, -0.1227294941155373, -0.6801277685242222),
	vec3(-0.001371162637170271, 0.6468399553590048, -0.7626245420022771),
	vec3(0.3400638826724031, 0.6494480574206308, -0.6801277647724278),
	vec3(0.2123896195833197, 0.3997690805039968, -0.8916699679624978),
	vec3(0.06315155055998029, -0.4482594672228027, -0.8916699679292777),
	vec3(0.3813122713286946, -0.5224985736859317, -0.7626245421112009),
	vec3(0.1066185177672842, -0.7252990523615556, -0.6801277646975873),
	vec3(-0.6156050296908593, 0.1985804865913292, -0.7626245719647822),
	vec3(-0.5125762620231672, 0.5241104554330811, -0.6801277866078446),
	vec3(-0.3145709684469798, 0.3255299724500799, -0.8916699741759726),
	vec3(-0.3790936823552179, -0.5241104567310809, -0.7626245531999998),
	vec3(-0.6568534198391829, -0.3255299697286946, -0.6801277995009508),
	vec3(-0.4068051581430956, -0.1985804881030303, -0.8916699798989161),
	vec3(0.3871670301192918, 0.3323419205718645, 0.8600293824162126),
	vec3(0.5743749995721008, 0.2655184397153206, 0.7743341126656443),
	vec3(0.5002770346050555, 0.4642133988156665, 0.73090957649136),
	vec3(-0.196434750136181, 0.4709170504471297, 0.8600293719037226),
	vec3(-0.0750313952359558, 0.6283128291328413, 0.774334087120043),
	vec3(-0.2868990661793857, 0.6192415893515606, 0.7309095565408553),
	vec3(-0.5085704004833218, -0.04129918299641058, 0.8600293746355776),
	vec3(-0.6207469831620547, 0.1228002424929602, 0.7743340902600619),
	vec3(-0.6775904310626306, -0.08150105950306978, 0.7309095600908743),
	vec3(-0.1178790377311258, -0.4964413479540561, 0.8600293718851371),
	vec3(-0.308611331539507, -0.5524181092863872, 0.7743340871857995),
	vec3(-0.1318748422886026, -0.6696120116883372, 0.7309095564938625),
	vec3(0.435717125539874, -0.2655184407621509, 0.8600293856180181),
	vec3(0.4300146732500801, -0.464213399521708, 0.7743341013374822),
	vec3(0.5960872655428849, -0.3323419188372027, 0.7309095845870489),
	vec3(0.8570819378788526, -0.4709170498211259, 0.2089202813266298),
	vec3(0.7261405163000503, -0.6283128263862733, 0.2791826333889509),
	vec3(0.7820505441794771, -0.6192415872063558, 0.07026238697010706),
	vec3(0.996673258065322, 0.04129918395299328, -0.07026232320577702),
	vec3(0.9701919621688232, -0.1228002452189278, -0.2089202151951311),
	vec3(0.9567730455820301, 0.08150106125477478, -0.2791825858860686),
	vec3(0.8219507531589716, 0.4964413463968252, 0.2791826444625577),
	vec3(0.8306006440196596, 0.5524181082524475, 0.07026239270701007),
	vec3(0.712721601170578, 0.6696120087931198, 0.2089202644668312),
	vec3(0.2687111150773606, 0.9606547438730186, -0.07026236338286829),
	vec3(0.4165957651485247, 0.884760024726389, -0.2089202410166972),
	vec3(0.2181470135636516, 0.9351304475963907, -0.2791826041347025),
	vec3(-0.2181470135636516, 0.9351304475963907, 0.2791826041347025),
	vec3(-0.2687111150773606, 0.9606547438730186, 0.07026236338286829),
	vec3(-0.4165957651485247, 0.884760024726389, 0.2089202410166972),
	vec3(-0.8306006440196596, 0.5524181082524475, -0.07026239270701007),
	vec3(-0.712721601170578, 0.6696120087931198, -0.2089202644668312),
	vec3(-0.8219507531589716, 0.4964413463968252, -0.2791826444625577),
	vec3(-0.9567730455820301, 0.08150106125477478, 0.2791825858860686),
	vec3(-0.996673258065322, 0.04129918395299328, 0.07026232320577702),
	vec3(-0.9701919621688232, -0.1228002452189278, 0.2089202151951311),
	vec3(-0.7820505441794771, -0.6192415872063558, -0.07026238697010706),
	vec3(-0.8570819378788526, -0.4709170498211259, -0.2089202813266298),
	vec3(-0.7261405163000503, -0.6283128263862733, -0.2791826333889509),
	vec3(-0.3731712355307885, -0.8847600253279883, 0.279182604318468),
	vec3(-0.3472668263932536, -0.9351304462843709, 0.07026236345833331),
	vec3(-0.1830158318750649, -0.9606547445789378, 0.2089202407643974),
	vec3(0.3472668263932536, -0.9351304462843709, -0.07026236345833331),
	vec3(0.1830158318750649, -0.9606547445789378, -0.2089202407643974),
	vec3(0.3731712355307885, -0.8847600253279883, -0.279182604318468),
	vec3(0.6207469831620547, 0.1228002424929602, -0.7743340902600619),
	vec3(0.6775904310626306, -0.08150105950306978, -0.7309095600908743),
	vec3(0.5085704004833218, -0.04129918299641058, -0.8600293746355776),
	vec3(0.2868990661793857, 0.6192415893515606, -0.7309095565408553),
	vec3(0.196434750136181, 0.4709170504471297, -0.8600293719037226),
	vec3(0.0750313952359558, 0.6283128291328413, -0.774334087120043),
	vec3(0.308611331539507, -0.5524181092863872, -0.7743340871857995),
	vec3(0.1318748422886026, -0.6696120116883372, -0.7309095564938625),
	vec3(0.1178790377311258, -0.4964413479540561, -0.8600293718851371),
	vec3(-0.5002770346050555, 0.4642133988156665, -0.73090957649136),
	vec3(-0.3871670301192918, 0.3323419205718645, -0.8600293824162126),
	vec3(-0.5743749995721008, 0.2655184397153206, -0.7743341126656443),
	vec3(-0.5960872655428849, -0.3323419188372027, -0.7309095845870489),
	vec3(-0.435717125539874, -0.2655184407621509, -0.8600293856180181),
	vec3(-0.4300146732500801, -0.464213399521708, -0.7743341013374822),
	vec3(0.2997991395355598, 0.7089691548913239, 0.6383441182829368),
	vec3(0.3951968841337059, 0.5744577408693167, 0.7168108026015872),
	vec3(0.4915480473667672, 0.6628419453847681, 0.5648195044157509),
	vec3(0.2279785112534667, 0.06604240900587859, 0.9714237996978217),
	vec3(0.3421887113356475, 0.1983373764355497, 0.9184602173981801),
	vec3(0.1553361201951539, 0.2626605594970475, 0.952302536092084),
	vec3(0.8092724530415962, 0.1964122339306219, 0.5536247204654248),
	vec3(0.6898485123309551, 0.264151198802353, 0.6740424127649891),
	vec3(0.7185821131631301, 0.06656685584061349, 0.6922489439107188),
	vec3(-0.581626701156737, 0.5042094529304301, 0.6383441141556239),
	vec3(-0.4242192202600887, 0.5533717949987785, 0.7168107906984603),
	vec3(-0.478503444661927, 0.6723194203618882, 0.5648194848364609),
	vec3(0.00763917677851769, 0.237228690723573, 0.9714237959179947),
	vec3(-0.08288791926355771, 0.3867304447559839, 0.9184602092300989),
	vec3(-0.2018035326058024, 0.2289000133233526, 0.952302534979503),
	vec3(0.06327981995235234, 0.8303585955097378, 0.5536246627904987),
	vec3(-0.03804779270257293, 0.7377121687356224, 0.6740423737198179),
	vec3(0.1587452578209707, 0.7039825305942619, 0.6922489001345201),
	vec3(-0.6592642103385624, -0.3973505902246242, 0.6383441152034022),
	vec3(-0.6573787929872064, -0.2324551764596211, 0.716810793353316),
	vec3(-0.7872794551801698, -0.2473257059041617, 0.5648194885538413),
	vec3(-0.2232572544632482, 0.08057298596113982, 0.9714237964260698),
	vec3(-0.3934162811319001, 0.04067518160005083, 0.9184602110827386),
	vec3(-0.280057565895342, -0.1211925759767702, 0.9523025356014183),
	vec3(-0.7701634102502587, 0.3167776044563868, 0.5536246660207299),
	vec3(-0.7133633767690419, 0.1917799948837663, 0.6740423771893369),
	vec3(-0.620472186725573, 0.368518281681692, 0.6922489014555087),
	vec3(0.174179017751144, -0.7497856107207234, 0.638344113884822),
	vec3(0.01793679016414742, -0.6970369876111752, 0.716810790558112),
	vec3(-0.008062007600087349, -0.825175104933515, 0.5648194846421456),
	vec3(-0.1456197464460605, -0.1874318493109405, 0.9714237959350522),
	vec3(-0.1602567105599133, -0.3615918012823269, 0.9184602092447547),
	vec3(0.0287184404647641, -0.3038011407309091, 0.9523025349477287),
	vec3(-0.5392669755027578, -0.6345792792134705, 0.5536246630389763),
	vec3(-0.402835011801831, -0.6191856196070922, 0.6740423738448498),
	vec3(-0.5422181525471248, -0.4762257185310113, 0.6922489003660496),
	vec3(0.7669127247671226, -0.06604240822015314, 0.6383441649351473),
	vec3(0.6684643029895334, -0.1983373747927902, 0.716810826779996),
	vec3(0.7822968245335927, -0.2626605565000715, 0.5648195378912896),
	vec3(0.1332592980114285, -0.196412236338106, 0.9714237967592545),
	vec3(0.2943721736095204, -0.2641512012071731, 0.9184602148733575),
	vec3(0.2978065193268439, -0.06656685641802862, 0.952302541565994),
	vec3(0.4368780799754227, -0.7089691527308095, 0.5536246776591034),
	vec3(0.4643976310662084, -0.5744577400396785, 0.6740423912252097),
	vec3(0.2853629379766348, -0.6628419483607846, 0.6922489040241394),
	vec3(0.8310637061283673, -0.5042094548869164, -0.2347465483427205),
	vec3(0.8308516667079509, -0.5533717947279252, -0.05886564981561856),
	vec3(0.719183156172671, -0.6723194175181301, -0.1753915297430229),
	vec3(0.8654514870413844, -0.2372286889997827, 0.4412666684594486),
	vec3(0.8585643733899588, -0.3867304436268262, 0.3366107257912404),
	vec3(0.9420145499826164, -0.2289000154169407, 0.2453841285885725),
	vec3(0.4668773633624513, -0.8303585918278689, 0.3041876666753014),
	vec3(0.6198973167009688, -0.73771216504524, 0.267409944263865),
	vec3(0.548173197735869, -0.7039825263606622, 0.4515692060613648),
	vec3(0.8657842580239011, 0.3973505937676793, -0.3041876463475723),
	vec3(0.9351238049619198, 0.2324551801540923, -0.2674099074699172),
	vec3(0.8572719914374934, 0.2473257069530594, -0.451569183378321),
	vec3(0.9687115222475319, -0.08057298756320473, 0.2347466300929773),
	vec3(0.997436893218007, -0.04067518245506716, 0.05886572500069127),
	vec3(0.9770108223358457, 0.1211925784426057, 0.1753915960616914),
	vec3(0.8396045094211718, -0.3167776058743056, -0.4412666044197959),
	vec3(0.9219076384619082, -0.1917799976576114, -0.3366106632951995),
	vec3(0.8966498437456364, -0.368518285736681, -0.2453840475430784),
	vec3(0.493057107952597, 0.7497856069153729, 0.4412666223044375),
	vec3(0.6331134815413475, 0.6970369840040658, 0.3366106986135611),
	vec3(0.5087953511084511, 0.8251751007108844, 0.2453840741719192),
	vec3(0.9339909683991825, 0.1874318508225656, 0.3041877253374717),
	vec3(0.8931647514274672, 0.3615918014031965, 0.2674099773110611),
	vec3(0.8389219796027437, 0.3038011383082383, 0.451569242201052),
	vec3(0.7363444804517491, 0.6345792771293696, -0.2347465593916349),
	vec3(0.7830351238640968, 0.6191856178864558, -0.05886565550222486),
	vec3(0.8616535728997226, 0.4762257211517053, -0.1753915129722096),
	vec3(-0.1103608125826261, 0.9461978428507319, -0.3041876612072291),
	vec3(0.06789113895477847, 0.9611881836387137, -0.2674099266757564),
	vec3(0.0296908905774268, 0.8917419596757836, -0.4515691844782064),
	vec3(0.3759777889106019, 0.8964009999237679, 0.2347465645788325),
	vec3(0.346909345219813, 0.9360495386246361, 0.05886567284731102),
	vec3(0.1866519660141208, 0.9666430845504996, 0.1753915353537875),
	vec3(0.5607254537642254, 0.7006216864507677, -0.4412666064589358),
	vec3(0.4672787294788676, 0.8175229916167087, -0.3366106759368783),
	vec3(0.6275617382274364, 0.7388862723818409, -0.2453840687547311),
	vec3(-0.5607254537642254, 0.7006216864507677, 0.4412666064589358),
	vec3(-0.4672787294788676, 0.8175229916167087, 0.3366106759368783),
	vec3(-0.6275617382274364, 0.7388862723818409, 0.2453840687547311),
	vec3(0.1103608125826261, 0.9461978428507319, 0.3041876612072291),
	vec3(-0.06789113895477847, 0.9611881836387137, 0.2674099266757564),
	vec3(-0.0296908905774268, 0.8917419596757836, 0.4515691844782064),
	vec3(-0.3759777889106019, 0.8964009999237679, -0.2347465645788325),
	vec3(-0.346909345219813, 0.9360495386246361, -0.05886567284731102),
	vec3(-0.1866519660141208, 0.9666430845504996, -0.1753915353537875),
	vec3(-0.9339909683991825, 0.1874318508225656, -0.3041877253374717),
	vec3(-0.8931647514274672, 0.3615918014031965, -0.2674099773110611),
	vec3(-0.8389219796027437, 0.3038011383082383, -0.451569242201052),
	vec3(-0.7363444804517491, 0.6345792771293696, 0.2347465593916349),
	vec3(-0.7830351238640968, 0.6191856178864558, 0.05886565550222486),
	vec3(-0.8616535728997226, 0.4762257211517053, 0.1753915129722096),
	vec3(-0.493057107952597, 0.7497856069153729, -0.4412666223044375),
	vec3(-0.6331134815413475, 0.6970369840040658, -0.3366106986135611),
	vec3(-0.5087953511084511, 0.8251751007108844, -0.2453840741719192),
	vec3(-0.8396045094211718, -0.3167776058743056, 0.4412666044197959),
	vec3(-0.9219076384619082, -0.1917799976576114, 0.3366106632951995),
	vec3(-0.8966498437456364, -0.368518285736681, 0.2453840475430784),
	vec3(-0.8657842580239011, 0.3973505937676793, 0.3041876463475723),
	vec3(-0.9351238049619198, 0.2324551801540923, 0.2674099074699172),
	vec3(-0.8572719914374934, 0.2473257069530594, 0.451569183378321),
	vec3(-0.9687115222475319, -0.08057298756320473, -0.2347466300929773),
	vec3(-0.997436893218007, -0.04067518245506716, -0.05886572500069127),
	vec3(-0.9770108223358457, 0.1211925784426057, -0.1753915960616914),
	vec3(-0.4668773633624513, -0.8303585918278689, -0.3041876666753014),
	vec3(-0.6198973167009688, -0.73771216504524, -0.267409944263865),
	vec3(-0.548173197735869, -0.7039825263606622, -0.4515692060613648),
	vec3(-0.8310637061283673, -0.5042094548869164, 0.2347465483427205),
	vec3(-0.8308516667079509, -0.5533717947279252, 0.05886564981561856),
	vec3(-0.719183156172671, -0.6723194175181301, 0.1753915297430229),
	vec3(-0.8654514870413844, -0.2372286889997827, -0.4412666684594486),
	vec3(-0.8585643733899588, -0.3867304436268262, -0.3366107257912404),
	vec3(-0.9420145499826164, -0.2289000154169407, -0.2453841285885725),
	vec3(0.04182134010602744, -0.8964010027771276, 0.4412666061825845),
	vec3(-0.1024915134557914, -0.9360495407295009, 0.336610675662005),
	vec3(0.07340166739635964, -0.9666430851833029, 0.2453840685348988),
	vec3(-0.6454449022157667, -0.7006216845257704, 0.3041876614459423),
	vec3(-0.5100471452230306, -0.8175229908662124, 0.2674099269941182),
	vec3(-0.5001323264608305, -0.7388862750632873, 0.4515691846793547),
	vec3(-0.2227188676993237, -0.9461978420555437, -0.2347465647462463),
	vec3(-0.2695405549391224, -0.9611881823010494, -0.0588656729165197),
	vec3(-0.4171739360469534, -0.8917419562239848, -0.1753915351233153),
	vec3(0.6454449022157667, -0.7006216845257704, -0.3041876614459423),
	vec3(0.5100471452230306, -0.8175229908662124, -0.2674099269941182),
	vec3(0.5001323264608305, -0.7388862750632873, -0.4515691846793547),
	vec3(0.2227188676993237, -0.9461978420555437, 0.2347465647462463),
	vec3(0.2695405549391224, -0.9611881823010494, 0.0588656729165197),
	vec3(0.4171739360469534, -0.8917419562239848, 0.1753915351233153),
	vec3(-0.04182134010602744, -0.8964010027771276, -0.4412666061825845),
	vec3(0.1024915134557914, -0.9360495407295009, -0.336610675662005),
	vec3(-0.07340166739635964, -0.9666430851833029, -0.2453840685348988),
	vec3(0.2232572544632482, 0.08057298596113982, -0.9714237964260698),
	vec3(0.3934162811319001, 0.04067518160005083, -0.9184602110827386),
	vec3(0.280057565895342, -0.1211925759767702, -0.9523025356014183),
	vec3(0.7701634102502587, 0.3167776044563868, -0.5536246660207299),
	vec3(0.7133633767690419, 0.1917799948837663, -0.6740423771893369),
	vec3(0.620472186725573, 0.368518281681692, -0.6922489014555087),
	vec3(0.6592642103385624, -0.3973505902246242, -0.6383441152034022),
	vec3(0.6573787929872064, -0.2324551764596211, -0.716810793353316),
	vec3(0.7872794551801698, -0.2473257059041617, -0.5648194885538413),
	vec3(-0.06327981995235234, 0.8303585955097378, -0.5536246627904987),
	vec3(0.03804779270257293, 0.7377121687356224, -0.6740423737198179),
	vec3(-0.1587452578209707, 0.7039825305942619, -0.6922489001345201),
	vec3(0.581626701156737, 0.5042094529304301, -0.6383441141556239),
	vec3(0.4242192202600887, 0.5533717949987785, -0.7168107906984603),
	vec3(0.478503444661927, 0.6723194203618882, -0.5648194848364609),
	vec3(-0.00763917677851769, 0.237228690723573, -0.9714237959179947),
	vec3(0.08288791926355771, 0.3867304447559839, -0.9184602092300989),
	vec3(0.2018035326058024, 0.2289000133233526, -0.952302534979503),
	vec3(0.1456197464460605, -0.1874318493109405, -0.9714237959350522),
	vec3(0.1602567105599133, -0.3615918012823269, -0.9184602092447547),
	vec3(-0.0287184404647641, -0.3038011407309091, -0.9523025349477287),
	vec3(0.5392669755027578, -0.6345792792134705, -0.5536246630389763),
	vec3(0.402835011801831, -0.6191856196070922, -0.6740423738448498),
	vec3(0.5422181525471248, -0.4762257185310113, -0.6922489003660496),
	vec3(-0.174179017751144, -0.7497856107207234, -0.638344113884822),
	vec3(-0.01793679016414742, -0.6970369876111752, -0.716810790558112),
	vec3(0.008062007600087349, -0.825175104933515, -0.5648194846421456),
	vec3(-0.8092724530415962, 0.1964122339306219, -0.5536247204654248),
	vec3(-0.6898485123309551, 0.264151198802353, -0.6740424127649891),
	vec3(-0.7185821131631301, 0.06656685584061349, -0.6922489439107188),
	vec3(-0.2997991395355598, 0.7089691548913239, -0.6383441182829368),
	vec3(-0.3951968841337059, 0.5744577408693167, -0.7168108026015872),
	vec3(-0.4915480473667672, 0.6628419453847681, -0.5648195044157509),
	vec3(-0.2279785112534667, 0.06604240900587859, -0.9714237996978217),
	vec3(-0.3421887113356475, 0.1983373764355497, -0.9184602173981801),
	vec3(-0.1553361201951539, 0.2626605594970475, -0.952302536092084),
	vec3(-0.4368780799754227, -0.7089691527308095, -0.5536246776591034),
	vec3(-0.4643976310662084, -0.5744577400396785, -0.6740423912252097),
	vec3(-0.2853629379766348, -0.6628419483607846, -0.6922489040241394),
	vec3(-0.7669127247671226, -0.06604240822015314, -0.6383441649351473),
	vec3(-0.6684643029895334, -0.1983373747927902, -0.716810826779996),
	vec3(-0.7822968245335927, -0.2626605565000715, -0.5648195378912896),
	vec3(-0.1332592980114285, -0.196412236338106, -0.9714237967592545),
	vec3(-0.2943721736095204, -0.2641512012071731, -0.9184602148733575),
	vec3(-0.2978065193268439, -0.06656685641802862, -0.952302541565994),
	vec3(0.2061026046155194, 0, 0.9785303860231929),
	vec3(0.846741468417424, 0.1960152373598238, 0.494577508976173),
	vec3(0.2419764687558151, 0.7447269856392674, 0.6219558709660326),
	vec3(0.07523594833185734, 0.8658710666204572, 0.4945774439540869),
	vec3(-0.6335026067004427, 0.4602665982674692, 0.621955871282711),
	vec3(-0.8002431304713398, 0.3391225157760805, 0.494577447349889),
	vec3(-0.6335026067004427, -0.4602665982674692, 0.621955871282711),
	vec3(-0.5698133929799876, -0.6562818364303699, 0.4945774442412589),
	vec3(0.2419764687558151, -0.7447269856392674, 0.6219558709660326),
	vec3(0.4480790764428009, -0.7447269820578122, 0.4945774595037966),
	vec3(0.4087169861696529, -0.8658710632905365, 0.2884748290102819),
	vec3(0.8396052271382272, -0.4602666017446594, -0.2884748132516749),
	vec3(0.8002431304713398, -0.3391225157760805, -0.494577447349889),
	vec3(0.8396052271382272, 0.4602666017446594, -0.2884748132516749),
	vec3(0.697191815747175, 0.6562818333601719, -0.2884748295026258),
	vec3(0.5698133929799876, 0.6562818364303699, -0.4945774442412589),
	vec3(-0.1782872555910661, 0.9407422215180659, -0.288474829312819),
	vec3(-0.4087169861696529, 0.8658710632905365, -0.2884748290102819),
	vec3(-0.4480790764428009, 0.7447269820578122, -0.4945774595037966),
	vec3(-0.9497927900644807, 0.1211440853246669, -0.2884748975775517),
	vec3(-0.9497927900644807, -0.1211440853246669, -0.2884748975775517),
	vec3(-0.846741468417424, -0.1960152373598238, -0.494577508976173),
	vec3(-0.4087169861696529, -0.8658710632905365, -0.2884748290102819),
	vec3(-0.1782872555910661, -0.9407422215180659, -0.288474829312819),
	vec3(-0.07523594833185734, -0.8658710666204572, -0.4945774439540869),
	vec3(0.6335026067004427, -0.4602665982674692, -0.621955871282711),
	vec3(0.1667405207587081, 0.1211440828675967, -0.9785303827287549),
	vec3(-0.06368921294067212, 0.1960152398905703, -0.9785303827095202),
	vec3(-0.2419764687558151, -0.7447269856392674, -0.6219558709660326),
	vec3(-0.2061026046155194, 0, -0.9785303860231929),
	vec3(0.689765187762129, 0, 0.7240331385727278),
	vec3(0.5522716706393702, 0.656005711591358, 0.5144438824290898),
	vec3(0.104794619952777, 0.3225246728738732, 0.9407422192165897),
	vec3(-0.4532371670181834, 0.7279585076516062, 0.5144438565781282),
	vec3(-0.2743558712229135, 0.1993312138369612, 0.9407422192693382),
	vec3(-0.8323876634797095, -0.2061026237737758, 0.5144438610386511),
	vec3(-0.2743558712229135, -0.1993312138369612, 0.9407422192693382),
	vec3(-0.06120669004524833, -0.8553369275918693, 0.5144438564035986),
	vec3(0.104794619952777, -0.3225246728738732, 0.9407422192165897),
	vec3(0.7945598144940891, -0.3225246689586165, 0.5144439124960597),
	vec3(0.6628264025075711, -0.7279585031936079, -0.1753213557071503),
	vec3(0.9641210851978887, -0.1993312176382351, 0.17532141555356),
	vec3(0.8323876634797095, 0.2061026237737758, -0.5144438610386511),
	vec3(0.9641210851978887, 0.1993312176382351, 0.17532141555356),
	vec3(0.487505046861351, 0.8553369229124217, 0.1753213551950297),
	vec3(0.06120669004524833, 0.8553369275918693, -0.5144438564035986),
	vec3(0.1083545604279483, 0.9785303835487571, 0.1753213555343111),
	vec3(-0.6628264025075711, 0.7279585031936079, 0.1753213557071503),
	vec3(-0.7945598144940891, 0.3225246689586165, -0.5144439124960597),
	vec3(-0.8971542965382148, 0.4054338419610345, 0.1753213278404425),
	vec3(-0.8971542965382148, -0.4054338419610345, 0.1753213278404425),
	vec3(-0.5522716706393702, -0.656005711591358, -0.5144438824290898),
	vec3(-0.6628264025075711, -0.7279585031936079, 0.1753213557071503),
	vec3(0.1083545604279483, -0.9785303835487571, 0.1753213555343111),
	vec3(0.4532371670181834, -0.7279585076516062, -0.5144438565781282),
	vec3(0.2743558712229135, -0.1993312138369612, -0.9407422192693382),
	vec3(0.5580317879562956, 0.405433837289968, -0.7240330981458181),
	vec3(-0.2131491805717815, 0.6560057164024883, -0.724033097909782),
	vec3(-0.104794619952777, -0.3225246728738732, -0.9407422192165897),
	vec3(-0.689765187762129, 0, -0.7240331385727278),
	vec3(0.3790936823552179, 0.5241104567310809, 0.7626245531999998),
	vec3(0.4068051581430956, 0.1985804881030303, 0.8916699798989161),
	vec3(0.6568534198391829, 0.3255299697286946, 0.6801277995009508),
	vec3(-0.3813122713286946, 0.5224985736859317, 0.7626245421112009),
	vec3(-0.06315155055998029, 0.4482594672228027, 0.8916699679292777),
	vec3(-0.1066185177672842, 0.7252990523615556, 0.6801277646975873),
	vec3(-0.6147576388858986, -0.2011885918974407, 0.7626245445314229),
	vec3(-0.4458349853637033, 0.07845909781352496, 0.8916699702221862),
	vec3(-0.7227473208227106, 0.1227294941155373, 0.6801277685242222),
	vec3(0.001371162637170271, -0.6468399553590048, 0.7626245420022771),
	vec3(-0.2123896195833197, -0.3997690805039968, 0.8916699679624978),
	vec3(-0.3400638826724031, -0.6494480574206308, 0.6801277647724278),
	vec3(0.6156050296908593, -0.1985804865913292, 0.7626245719647822),
	vec3(0.3145709684469798, -0.3255299724500799, 0.8916699741759726),
	vec3(0.5125762620231672, -0.5241104554330811, 0.6801277866078446),
	vec3(0.8526401589374363, -0.5224985735551272, 2.90757976831514e-08),
	vec3(0.825776082549864, -0.4482594652487249, 0.3422825051087588),
	vec3(0.656006016288201, -0.7252990491767123, 0.2087998942936552),
	vec3(0.9570401093324565, 0.2011885959965202, -0.208799851460361),
	vec3(0.9969173334666134, -0.07845909911421987, 4.698000520788432e-08),
	vec3(0.9315472055860589, -0.1227294968281773, -0.3422824482399107),
	vec3(0.681498917189325, 0.6468399521505417, 0.3422824888475347),
	vec3(0.8925173803689549, 0.3997690811105679, 0.2087999222398098),
	vec3(0.7604059602616986, 0.6494480545805675, 1.7629910431845e-08),
	vec3(0.1043999383153924, 0.972369921632584, -0.2087998763983937),
	vec3(0.3826834294784014, 0.9238795337069922, -1.70368363848123e-10),
	vec3(0.4045865922105127, 0.8480285411991428, -0.3422824604257981),
	vec3(-0.4045865922105127, 0.8480285411991428, 0.3422824604257981),
	vec3(-0.1043999383153924, 0.972369921632584, 0.2087998763983937),
	vec3(-0.3826834294784014, 0.9238795337069922, 1.70368363848123e-10),
	vec3(-0.8925173803689549, 0.3997690811105679, -0.2087999222398098),
	vec3(-0.7604059602616986, 0.6494480545805675, -1.7629910431845e-08),
	vec3(-0.681498917189325, 0.6468399521505417, -0.3422824888475347),
	vec3(-0.9315472055860589, -0.1227294968281773, 0.3422824482399107),
	vec3(-0.9570401093324565, 0.2011885959965202, 0.208799851460361),
	vec3(-0.9969173334666134, -0.07845909911421987, -4.698000520788432e-08),
	vec3(-0.656006016288201, -0.7252990491767123, -0.2087998942936552),
	vec3(-0.8526401589374363, -0.5224985735551272, -2.90757976831514e-08),
	vec3(-0.825776082549864, -0.4482594652487249, -0.3422825051087588),
	vec3(-0.171141230235898, -0.9238795358852286, 0.3422824600908406),
	vec3(-0.4870833676890085, -0.8480285398400005, 0.2087998767661778),
	vec3(-0.2334453620329866, -0.9723699208353206, 1.039284727632488e-10),
	vec3(0.4870833676890085, -0.8480285398400005, -0.2087998767661778),
	vec3(0.2334453620329866, -0.9723699208353206, -1.039284727632488e-10),
	vec3(0.171141230235898, -0.9238795358852286, -0.3422824600908406),
	vec3(0.4458349853637033, 0.07845909781352496, -0.8916699702221862),
	vec3(0.7227473208227106, 0.1227294941155373, -0.6801277685242222),
	vec3(0.6147576388858986, -0.2011885918974407, -0.7626245445314229),
	vec3(0.1066185177672842, 0.7252990523615556, -0.6801277646975873),
	vec3(0.3813122713286946, 0.5224985736859317, -0.7626245421112009),
	vec3(0.06315155055998029, 0.4482594672228027, -0.8916699679292777),
	vec3(0.2123896195833197, -0.3997690805039968, -0.8916699679624978),
	vec3(0.3400638826724031, -0.6494480574206308, -0.6801277647724278),
	vec3(-0.001371162637170271, -0.6468399553590048, -0.7626245420022771),
	vec3(-0.6568534198391829, 0.3255299697286946, -0.6801277995009508),
	vec3(-0.3790936823552179, 0.5241104567310809, -0.7626245531999998),
	vec3(-0.4068051581430956, 0.1985804881030303, -0.8916699798989161),
	vec3(-0.5125762620231672, -0.5241104554330811, -0.6801277866078446),
	vec3(-0.6156050296908593, -0.1985804865913292, -0.7626245719647822),
	vec3(-0.3145709684469798, -0.3255299724500799, -0.8916699741759726),
	vec3(0.4656575862099384, 0, 0.8849649780670046),
	vec3(0.727184400855205, 0.4428667079544819, 0.5244729984836363),
	vec3(0.1802460033642198, 0.5547401507640806, 0.8122651927797169),
	vec3(-0.1964789196507752, 0.8284468339777816, 0.5244729520242717),
	vec3(-0.4718901534427998, 0.3428482746302798, 0.8122651929430258),
	vec3(-0.8486150822583008, 0.06914158854026285, 0.5244729572607784),
	vec3(-0.4718901534427998, -0.3428482746302798, 0.8122651929430258),
	vec3(-0.327994032986502, -0.7857149844942375, 0.5244729520828214),
	vec3(0.1802460033642198, -0.5547401507640806, 0.8122651927797169),
	vec3(0.6459035960123568, -0.5547401455638538, 0.5244729883970199),
	vec3(0.5569709213577366, -0.8284468286699294, 0.05881534518007033),
	vec3(0.9375477677821279, -0.3428482796791154, -0.05881530623758086),
	vec3(0.8486150822583008, -0.06914158854026285, -0.5244729572607784),
	vec3(0.9375477677821279, 0.3428482796791154, -0.05881530623758086),
	vec3(0.6157862668643198, 0.7857149792712613, -0.05881534570217478),
	vec3(0.327994032986502, 0.7857149844942375, -0.5244729520828214),
	vec3(-0.03634988382434518, 0.9976068569744072, -0.05881534547719083),
	vec3(-0.5569709213577366, 0.8284468286699294, -0.05881534518007033),
	vec3(-0.6459035960123568, 0.5547401455638538, -0.5244729883970199),
	vec3(-0.9600132272913174, 0.273706690928425, -0.05881539566066786),
	vec3(-0.9600132272913174, -0.273706690928425, -0.05881539566066786),
	vec3(-0.727184400855205, -0.4428667079544819, -0.5244729984836363),
	vec3(-0.5569709213577366, -0.8284468286699294, -0.05881534518007033),
	vec3(-0.03634988382434518, -0.9976068569744072, -0.05881534547719083),
	vec3(0.1964789196507752, -0.8284468339777816, -0.5244729520242717),
	vec3(0.4718901534427998, -0.3428482746302798, -0.8122651929430258),
	vec3(0.3767249238592107, 0.27370668621296, -0.8849649606993444),
	vec3(-0.1438961194666474, 0.442866712811342, -0.8849649605979418),
	vec3(-0.1802460033642198, -0.5547401507640806, -0.8122651927797169),
	vec3(-0.4656575862099384, 0, -0.8849649780670046),
	vec3(0.8613656049054742, 0, 0.5079855260593815),
	vec3(0.3353182087231465, 0.819207407955155, 0.4652536100344591),
	vec3(0.02136592574134023, 0.06575755714824381, 0.9976068568805605),
	vec3(-0.6754935127675508, 0.572055589053028, 0.4652536052973131),
	vec3(-0.05593671863869709, 0.04064040610688723, 0.9976068568827113),
	vec3(-0.7527961586136724, -0.46565762663815, 0.4652536064666494),
	vec3(-0.05593671863869709, -0.04064040610688723, 0.9976068568827113),
	vec3(0.2102399071495789, -0.8598478147710262, 0.4652536049029899),
	vec3(0.02136592574134023, -0.06575755714824381, 0.9976068568805605),
	vec3(0.8827315327616699, -0.06575755627407728, 0.4652536779662192),
	vec3(0.7182253630664412, -0.5720555879139837, -0.3961120197424781),
	vec3(0.9173023309635631, -0.04064040695560462, 0.3961120938967863),
	vec3(0.7527961586136724, 0.46565762663815, -0.4652536064666494),
	vec3(0.9173023309635631, 0.04064040695560462, 0.3961120938967863),
	vec3(0.3221133431146726, 0.8598478134937279, 0.3961120192793256),
	vec3(-0.2102399071495789, 0.8598478147710262, -0.4652536049029899),
	vec3(0.2448106998357109, 0.8849649650222424, 0.3961120194201772),
	vec3(-0.7182253630664412, 0.5720555879139837, 0.3961120197424781),
	vec3(-0.8827315327616699, 0.06575755627407728, -0.4652536779662192),
	vec3(-0.7660010265951327, 0.5062980339365184, 0.3961120145706497),
	vec3(-0.7660010265951327, -0.5062980339365184, 0.3961120145706497),
	vec3(-0.3353182087231465, -0.819207407955155, -0.4652536100344591),
	vec3(-0.7182253630664412, -0.5720555879139837, 0.3961120197424781),
	vec3(0.2448106998357109, -0.8849649650222424, 0.3961120194201772),
	vec3(0.6754935127675508, -0.572055589053028, -0.4652536052973131),
	vec3(0.05593671863869709, -0.04064040610688723, -0.9976068568827113),
	vec3(0.6968594388377338, 0.5062980325447761, -0.5079854572170817),
	vec3(-0.2661766256963305, 0.8192074093886291, -0.50798545681514),
	vec3(-0.02136592574134023, -0.06575755714824381, -0.9976068568805605),
	vec3(-0.8613656049054742, 0, -0.5079855260593815),
	vec3(0.6334375146361062, 0.511205116995859, 0.5808840188960983),
	vec3(0.2145909979735989, 0.4444638289867313, 0.8697140957298257),
	vec3(0.5591984008720434, 0.0667412928995105, 0.8263429967539213),
	vec3(-0.2904419924647737, 0.7604059742956296, 0.5808839843450726),
	vec3(-0.3563979512832385, 0.3414350522495877, 0.8697140940656484),
	vec3(0.109327080466277, 0.5524535116371868, 0.8263429717474826),
	vec3(-0.8129405645747626, -0.04124838879026752, 0.5808839891846503),
	vec3(-0.4348570477989103, -0.2334453699588763, 0.8697140951050405),
	vec3(-0.4916305832033238, 0.2746937587050914, 0.8263429727344627),
	vec3(-0.211982896371649, -0.7858988792519084, 0.5808839843174202),
	vec3(0.08764151922866649, -0.4857122181526711, 0.8697140939668068),
	vec3(-0.4131714861908644, -0.3826834407592372, 0.8263429718751795),
	vec3(0.6819278990718476, -0.4444638247643474, 0.5808840236598899),
	vec3(0.4890224553408556, -0.06674129338289006, 0.8697141127577384),
	vec3(0.2362765593149162, -0.5112051208578973, 0.8263429747550151),
	vec3(0.6494480437124178, -0.7604059695439755, 5.749916287231103e-09),
	vec3(0.9372819388055479, -0.3414350557145615, 0.07017599246257616),
	vec3(0.6902110515244972, -0.552453507378411, 0.4673369518224937),
	vec3(0.8831165150134035, 0.0412483897372541, -0.4673369140723472),
	vec3(0.9723699180187415, 0.2334453737648788, 4.582320146211041e-08),
	vec3(0.9589675062742516, -0.2746937635775325, -0.07017590869916669),
	vec3(0.6143600687019951, 0.7858988749292943, 0.07017595292797471),
	vec3(0.7387014375560701, 0.4857122139747437, 0.4673369569682546),
	vec3(0.923879527722436, 0.382683443926396, 3.98057423179899e-08),
	vec3(0.2336684572716483, 0.8526401708033698, -0.4673369140231576),
	vec3(0.07845909510486554, 0.9969173337821574, -3.492951780075611e-11),
	vec3(0.5575865344613419, 0.8271472619824312, -0.07017594732070147),
	vec3(-0.5575865344613419, 0.8271472619824312, 0.07017594732070147),
	vec3(-0.2336684572716483, 0.8526401708033698, 0.4673369140231576),
	vec3(-0.07845909510486554, 0.9969173337821574, 3.492951780075611e-11),
	vec3(-0.7387014375560701, 0.4857122139747437, -0.4673369569682546),
	vec3(-0.923879527722436, 0.382683443926396, -3.98057423179899e-08),
	vec3(-0.6143600687019951, 0.7858988749292943, -0.07017595292797471),
	vec3(-0.9589675062742516, -0.2746937635775325, 0.07017590869916669),
	vec3(-0.8831165150134035, 0.0412483897372541, 0.4673369140723472),
	vec3(-0.9723699180187415, 0.2334453737648788, -4.582320146211041e-08),
	vec3(-0.6902110515244972, -0.552453507378411, -0.4673369518224937),
	vec3(-0.6494480437124178, -0.7604059695439755, -5.749916287231103e-09),
	vec3(-0.9372819388055479, -0.3414350557145615, -0.07017599246257616),
	vec3(-0.03508797354522289, -0.9969173338714753, 0.07017594701234098),
	vec3(-0.3121275523710819, -0.827147266026392, 0.4673369141806615),
	vec3(-0.5224985609862104, -0.8526401666396787, 2.326132204614924e-10),
	vec3(0.3121275523710819, -0.827147266026392, -0.4673369141806615),
	vec3(0.5224985609862104, -0.8526401666396787, -2.326132204614924e-10),
	vec3(0.03508797354522289, -0.9969173338714753, -0.07017594701234098),
	vec3(0.4348570477989103, -0.2334453699588763, -0.8697140951050405),
	vec3(0.4916305832033238, 0.2746937587050914, -0.8263429727344627),
	vec3(0.8129405645747626, -0.04124838879026752, -0.5808839891846503),
	vec3(-0.109327080466277, 0.5524535116371868, -0.8263429717474826),
	vec3(0.2904419924647737, 0.7604059742956296, -0.5808839843450726),
	vec3(0.3563979512832385, 0.3414350522495877, -0.8697140940656484),
	vec3(-0.08764151922866649, -0.4857122181526711, -0.8697140939668068),
	vec3(0.4131714861908644, -0.3826834407592372, -0.8263429718751795),
	vec3(0.211982896371649, -0.7858988792519084, -0.5808839843174202),
	vec3(-0.5591984008720434, 0.0667412928995105, -0.8263429967539213),
	vec3(-0.6334375146361062, 0.511205116995859, -0.5808840188960983),
	vec3(-0.2145909979735989, 0.4444638289867313, -0.8697140957298257),
	vec3(-0.2362765593149162, -0.5112051208578973, -0.8263429747550151),
	vec3(-0.6819278990718476, -0.4444638247643474, -0.5808840236598899),
	vec3(-0.4890224553408556, -0.06674129338289006, -0.8697141127577384),
	vec3(0.4300146732500801, 0.464213399521708, 0.7743341013374822),
	vec3(0.435717125539874, 0.2655184407621509, 0.8600293856180181),
	vec3(0.5960872655428849, 0.3323419188372027, 0.7309095845870489),
	vec3(-0.308611331539507, 0.5524181092863872, 0.7743340871857995),
	vec3(-0.1178790377311258, 0.4964413479540561, 0.8600293718851371),
	vec3(-0.1318748422886026, 0.6696120116883372, 0.7309095564938625),
	vec3(-0.6207469831620547, -0.1228002424929602, 0.7743340902600619),
	vec3(-0.5085704004833218, 0.04129918299641058, 0.8600293746355776),
	vec3(-0.6775904310626306, 0.08150105950306978, 0.7309095600908743),
	vec3(-0.0750313952359558, -0.6283128291328413, 0.774334087120043),
	vec3(-0.196434750136181, -0.4709170504471297, 0.8600293719037226),
	vec3(-0.2868990661793857, -0.6192415893515606, 0.7309095565408553),
	vec3(0.5743749995721008, -0.2655184397153206, 0.7743341126656443),
	vec3(0.3871670301192918, -0.3323419205718645, 0.8600293824162126),
	vec3(0.5002770346050555, -0.4642133988156665, 0.73090957649136),
	vec3(0.8306006440196596, -0.5524181082524475, 0.07026239270701007),
	vec3(0.8219507531589716, -0.4964413463968252, 0.2791826444625577),
	vec3(0.712721601170578, -0.6696120087931198, 0.2089202644668312),
	vec3(0.9701919621688232, 0.1228002452189278, -0.2089202151951311),
	vec3(0.996673258065322, -0.04129918395299328, -0.07026232320577702),
	vec3(0.9567730455820301, -0.08150106125477478, -0.2791825858860686),
	vec3(0.7261405163000503, 0.6283128263862733, 0.2791826333889509),
	vec3(0.8570819378788526, 0.4709170498211259, 0.2089202813266298),
	vec3(0.7820505441794771, 0.6192415872063558, 0.07026238697010706),
	vec3(0.1830158318750649, 0.9606547445789378, -0.2089202407643974),
	vec3(0.3472668263932536, 0.9351304462843709, -0.07026236345833331),
	vec3(0.3731712355307885, 0.8847600253279883, -0.279182604318468),
	vec3(-0.3731712355307885, 0.8847600253279883, 0.279182604318468),
	vec3(-0.1830158318750649, 0.9606547445789378, 0.2089202407643974),
	vec3(-0.3472668263932536, 0.9351304462843709, 0.07026236345833331),
	vec3(-0.8570819378788526, 0.4709170498211259, -0.2089202813266298),
	vec3(-0.7820505441794771, 0.6192415872063558, -0.07026238697010706),
	vec3(-0.7261405163000503, 0.6283128263862733, -0.2791826333889509),
	vec3(-0.9567730455820301, -0.08150106125477478, 0.2791825858860686),
	vec3(-0.9701919621688232, 0.1228002452189278, 0.2089202151951311),
	vec3(-0.996673258065322, -0.04129918395299328, 0.07026232320577702),
	vec3(-0.712721601170578, -0.6696120087931198, -0.2089202644668312),
	vec3(-0.8306006440196596, -0.5524181082524475, -0.07026239270701007),
	vec3(-0.8219507531589716, -0.4964413463968252, -0.2791826444625577),
	vec3(-0.2181470135636516, -0.9351304475963907, 0.2791826041347025),
	vec3(-0.4165957651485247, -0.884760024726389, 0.2089202410166972),
	vec3(-0.2687111150773606, -0.9606547438730186, 0.07026236338286829),
	vec3(0.4165957651485247, -0.884760024726389, -0.2089202410166972),
	vec3(0.2687111150773606, -0.9606547438730186, -0.07026236338286829),
	vec3(0.2181470135636516, -0.9351304475963907, -0.2791826041347025),
	vec3(0.5085704004833218, 0.04129918299641058, -0.8600293746355776),
	vec3(0.6775904310626306, 0.08150105950306978, -0.7309095600908743),
	vec3(0.6207469831620547, -0.1228002424929602, -0.7743340902600619),
	vec3(0.1318748422886026, 0.6696120116883372, -0.7309095564938625),
	vec3(0.308611331539507, 0.5524181092863872, -0.7743340871857995),
	vec3(0.1178790377311258, 0.4964413479540561, -0.8600293718851371),
	vec3(0.196434750136181, -0.4709170504471297, -0.8600293719037226),
	vec3(0.2868990661793857, -0.6192415893515606, -0.7309095565408553),
	vec3(0.0750313952359558, -0.6283128291328413, -0.774334087120043),
	vec3(-0.5960872655428849, 0.3323419188372027, -0.7309095845870489),
	vec3(-0.4300146732500801, 0.464213399521708, -0.7743341013374822),
	vec3(-0.435717125539874, 0.2655184407621509, -0.8600293856180181),
	vec3(-0.5002770346050555, -0.4642133988156665, -0.73090957649136),
	vec3(-0.5743749995721008, -0.2655184397153206, -0.7743341126656443),
	vec3(-0.3871670301192918, -0.3323419205718645, -0.8600293824162126),
	vec3(0.4368780799754227, 0.7089691527308095, 0.5536246776591034),
	vec3(0.2853629379766348, 0.6628419483607846, 0.6922489040241394),
	vec3(0.4643976310662084, 0.5744577400396785, 0.6740423912252097),
	vec3(0.1332592980114285, 0.196412236338106, 0.9714237967592545),
	vec3(0.2978065193268439, 0.06656685641802862, 0.952302541565994),
	vec3(0.2943721736095204, 0.2641512012071731, 0.9184602148733575),
	vec3(0.7669127247671226, 0.06604240822015314, 0.6383441649351473),
	vec3(0.7822968245335927, 0.2626605565000715, 0.5648195378912896),
	vec3(0.6684643029895334, 0.1983373747927902, 0.716810826779996),
	vec3(-0.5392669755027578, 0.6345792792134705, 0.5536246630389763),
	vec3(-0.5422181525471248, 0.4762257185310113, 0.6922489003660496),
	vec3(-0.402835011801831, 0.6191856196070922, 0.6740423738448498),
	vec3(-0.1456197464460605, 0.1874318493109405, 0.9714237959350522),
	vec3(0.0287184404647641, 0.3038011407309091, 0.9523025349477287),
	vec3(-0.1602567105599133, 0.3615918012823269, 0.9184602092447547),
	vec3(0.174179017751144, 0.7497856107207234, 0.638344113884822),
	vec3(-0.008062007600087349, 0.825175104933515, 0.5648194846421456),
	vec3(0.01793679016414742, 0.6970369876111752, 0.716810790558112),
	vec3(-0.7701634102502587, -0.3167776044563868, 0.5536246660207299),
	vec3(-0.620472186725573, -0.368518281681692, 0.6922489014555087),
	vec3(-0.7133633767690419, -0.1917799948837663, 0.6740423771893369),
	vec3(-0.2232572544632482, -0.08057298596113982, 0.9714237964260698),
	vec3(-0.280057565895342, 0.1211925759767702, 0.9523025356014183),
	vec3(-0.3934162811319001, -0.04067518160005083, 0.9184602110827386),
	vec3(-0.6592642103385624, 0.3973505902246242, 0.6383441152034022),
	vec3(-0.7872794551801698, 0.2473257059041617, 0.5648194885538413),
	vec3(-0.6573787929872064, 0.2324551764596211, 0.716810793353316),
	vec3(0.06327981995235234, -0.8303585955097378, 0.5536246627904987),
	vec3(0.1587452578209707, -0.7039825305942619, 0.6922489001345201),
	vec3(-0.03804779270257293, -0.7377121687356224, 0.6740423737198179),
	vec3(0.00763917677851769, -0.237228690723573, 0.9714237959179947),
	vec3(-0.2018035326058024, -0.2289000133233526, 0.952302534979503),
	vec3(-0.08288791926355771, -0.3867304447559839, 0.9184602092300989),
	vec3(-0.581626701156737, -0.5042094529304301, 0.6383441141556239),
	vec3(-0.478503444661927, -0.6723194203618882, 0.5648194848364609),
	vec3(-0.4242192202600887, -0.5533717949987785, 0.7168107906984603),
	vec3(0.8092724530415962, -0.1964122339306219, 0.5536247204654248),
	vec3(0.7185821131631301, -0.06656685584061349, 0.6922489439107188),
	vec3(0.6898485123309551, -0.264151198802353, 0.6740424127649891),
	vec3(0.2279785112534667, -0.06604240900587859, 0.9714237996978217),
	vec3(0.1553361201951539, -0.2626605594970475, 0.952302536092084),
	vec3(0.3421887113356475, -0.1983373764355497, 0.9184602173981801),
	vec3(0.2997991395355598, -0.7089691548913239, 0.6383441182829368),
	vec3(0.4915480473667672, -0.6628419453847681, 0.5648195044157509),
	vec3(0.3951968841337059, -0.5744577408693167, 0.7168108026015872),
	vec3(0.7363444804517491, -0.6345792771293696, -0.2347465593916349),
	vec3(0.8616535728997226, -0.4762257211517053, -0.1753915129722096),
	vec3(0.7830351238640968, -0.6191856178864558, -0.05886565550222486),
	vec3(0.9339909683991825, -0.1874318508225656, 0.3041877253374717),
	vec3(0.8389219796027437, -0.3038011383082383, 0.451569242201052),
	vec3(0.8931647514274672, -0.3615918014031965, 0.2674099773110611),
	vec3(0.493057107952597, -0.7497856069153729, 0.4412666223044375),
	vec3(0.5087953511084511, -0.8251751007108844, 0.2453840741719192),
	vec3(0.6331134815413475, -0.6970369840040658, 0.3366106986135611),
	vec3(0.8396045094211718, 0.3167776058743056, -0.4412666044197959),
	vec3(0.8966498437456364, 0.368518285736681, -0.2453840475430784),
	vec3(0.9219076384619082, 0.1917799976576114, -0.3366106632951995),
	vec3(0.9687115222475319, 0.08057298756320473, 0.2347466300929773),
	vec3(0.9770108223358457, -0.1211925784426057, 0.1753915960616914),
	vec3(0.997436893218007, 0.04067518245506716, 0.05886572500069127),
	vec3(0.8657842580239011, -0.3973505937676793, -0.3041876463475723),
	vec3(0.8572719914374934, -0.2473257069530594, -0.451569183378321),
	vec3(0.9351238049619198, -0.2324551801540923, -0.2674099074699172),
	vec3(0.4668773633624513, 0.8303585918278689, 0.3041876666753014),
	vec3(0.548173197735869, 0.7039825263606622, 0.4515692060613648),
	vec3(0.6198973167009688, 0.73771216504524, 0.267409944263865),
	vec3(0.8654514870413844, 0.2372286889997827, 0.4412666684594486),
	vec3(0.9420145499826164, 0.2289000154169407, 0.2453841285885725),
	vec3(0.8585643733899588, 0.3867304436268262, 0.3366107257912404),
	vec3(0.8310637061283673, 0.5042094548869164, -0.2347465483427205),
	vec3(0.719183156172671, 0.6723194175181301, -0.1753915297430229),
	vec3(0.8308516667079509, 0.5533717947279252, -0.05886564981561856),
	vec3(-0.04182134010602744, 0.8964010027771276, -0.4412666061825845),
	vec3(-0.07340166739635964, 0.9666430851833029, -0.2453840685348988),
	vec3(0.1024915134557914, 0.9360495407295009, -0.336610675662005),
	vec3(0.2227188676993237, 0.9461978420555437, 0.2347465647462463),
	vec3(0.4171739360469534, 0.8917419562239848, 0.1753915351233153),
	vec3(0.2695405549391224, 0.9611881823010494, 0.0588656729165197),
	vec3(0.6454449022157667, 0.7006216845257704, -0.3041876614459423),
	vec3(0.5001323264608305, 0.7388862750632873, -0.4515691846793547),
	vec3(0.5100471452230306, 0.8175229908662124, -0.2674099269941182),
	vec3(-0.6454449022157667, 0.7006216845257704, 0.3041876614459423),
	vec3(-0.5001323264608305, 0.7388862750632873, 0.4515691846793547),
	vec3(-0.5100471452230306, 0.8175229908662124, 0.2674099269941182),
	vec3(0.04182134010602744, 0.8964010027771276, 0.4412666061825845),
	vec3(0.07340166739635964, 0.9666430851833029, 0.2453840685348988),
	vec3(-0.1024915134557914, 0.9360495407295009, 0.336610675662005),
	vec3(-0.2227188676993237, 0.9461978420555437, -0.2347465647462463),
	vec3(-0.4171739360469534, 0.8917419562239848, -0.1753915351233153),
	vec3(-0.2695405549391224, 0.9611881823010494, -0.0588656729165197),
	vec3(-0.8654514870413844, 0.2372286889997827, -0.4412666684594486),
	vec3(-0.9420145499826164, 0.2289000154169407, -0.2453841285885725),
	vec3(-0.8585643733899588, 0.3867304436268262, -0.3366107257912404),
	vec3(-0.8310637061283673, 0.5042094548869164, 0.2347465483427205),
	vec3(-0.719183156172671, 0.6723194175181301, 0.1753915297430229),
	vec3(-0.8308516667079509, 0.5533717947279252, 0.05886564981561856),
	vec3(-0.4668773633624513, 0.8303585918278689, -0.3041876666753014),
	vec3(-0.548173197735869, 0.7039825263606622, -0.4515692060613648),
	vec3(-0.6198973167009688, 0.73771216504524, -0.267409944263865),
	vec3(-0.8657842580239011, -0.3973505937676793, 0.3041876463475723),
	vec3(-0.8572719914374934, -0.2473257069530594, 0.451569183378321),
	vec3(-0.9351238049619198, -0.2324551801540923, 0.2674099074699172),
	vec3(-0.8396045094211718, 0.3167776058743056, 0.4412666044197959),
	vec3(-0.8966498437456364, 0.368518285736681, 0.2453840475430784),
	vec3(-0.9219076384619082, 0.1917799976576114, 0.3366106632951995),
	vec3(-0.9687115222475319, 0.08057298756320473, -0.2347466300929773),
	vec3(-0.9770108223358457, -0.1211925784426057, -0.1753915960616914),
	vec3(-0.997436893218007, 0.04067518245506716, -0.05886572500069127),
	vec3(-0.493057107952597, -0.7497856069153729, -0.4412666223044375),
	vec3(-0.5087953511084511, -0.8251751007108844, -0.2453840741719192),
	vec3(-0.6331134815413475, -0.6970369840040658, -0.3366106986135611),
	vec3(-0.7363444804517491, -0.6345792771293696, 0.2347465593916349),
	vec3(-0.8616535728997226, -0.4762257211517053, 0.1753915129722096),
	vec3(-0.7830351238640968, -0.6191856178864558, 0.05886565550222486),
	vec3(-0.9339909683991825, -0.1874318508225656, -0.3041877253374717),
	vec3(-0.8389219796027437, -0.3038011383082383, -0.451569242201052),
	vec3(-0.8931647514274672, -0.3615918014031965, -0.2674099773110611),
	vec3(0.1103608125826261, -0.9461978428507319, 0.3041876612072291),
	vec3(-0.0296908905774268, -0.8917419596757836, 0.4515691844782064),
	vec3(-0.06789113895477847, -0.9611881836387137, 0.2674099266757564),
	vec3(-0.5607254537642254, -0.7006216864507677, 0.4412666064589358),
	vec3(-0.6275617382274364, -0.7388862723818409, 0.2453840687547311),
	vec3(-0.4672787294788676, -0.8175229916167087, 0.3366106759368783),
	vec3(-0.3759777889106019, -0.8964009999237679, -0.2347465645788325),
	vec3(-0.1866519660141208, -0.9666430845504996, -0.1753915353537875),
	vec3(-0.346909345219813, -0.9360495386246361, -0.05886567284731102),
	vec3(0.5607254537642254, -0.7006216864507677, -0.4412666064589358),
	vec3(0.6275617382274364, -0.7388862723818409, -0.2453840687547311),
	vec3(0.4672787294788676, -0.8175229916167087, -0.3366106759368783),
	vec3(0.3759777889106019, -0.8964009999237679, 0.2347465645788325),
	vec3(0.1866519660141208, -0.9666430845504996, 0.1753915353537875),
	vec3(0.346909345219813, -0.9360495386246361, 0.05886567284731102),
	vec3(-0.1103608125826261, -0.9461978428507319, -0.3041876612072291),
	vec3(0.0296908905774268, -0.8917419596757836, -0.4515691844782064),
	vec3(0.06789113895477847, -0.9611881836387137, -0.2674099266757564),
	vec3(0.2232572544632482, -0.08057298596113982, -0.9714237964260698),
	vec3(0.280057565895342, 0.1211925759767702, -0.9523025356014183),
	vec3(0.3934162811319001, -0.04067518160005083, -0.9184602110827386),
	vec3(0.6592642103385624, 0.3973505902246242, -0.6383441152034022),
	vec3(0.7872794551801698, 0.2473257059041617, -0.5648194885538413),
	vec3(0.6573787929872064, 0.2324551764596211, -0.716810793353316),
	vec3(0.7701634102502587, -0.3167776044563868, -0.5536246660207299),
	vec3(0.620472186725573, -0.368518281681692, -0.6922489014555087),
	vec3(0.7133633767690419, -0.1917799948837663, -0.6740423771893369),
	vec3(-0.174179017751144, 0.7497856107207234, -0.638344113884822),
	vec3(0.008062007600087349, 0.825175104933515, -0.5648194846421456),
	vec3(-0.01793679016414742, 0.6970369876111752, -0.716810790558112),
	vec3(0.5392669755027578, 0.6345792792134705, -0.5536246630389763),
	vec3(0.5422181525471248, 0.4762257185310113, -0.6922489003660496),
	vec3(0.402835011801831, 0.6191856196070922, -0.6740423738448498),
	vec3(0.1456197464460605, 0.1874318493109405, -0.9714237959350522),
	vec3(-0.0287184404647641, 0.3038011407309091, -0.9523025349477287),
	vec3(0.1602567105599133, 0.3615918012823269, -0.9184602092447547),
	vec3(-0.00763917677851769, -0.237228690723573, -0.9714237959179947),
	vec3(0.2018035326058024, -0.2289000133233526, -0.952302534979503),
	vec3(0.08288791926355771, -0.3867304447559839, -0.9184602092300989),
	vec3(0.581626701156737, -0.5042094529304301, -0.6383441141556239),
	vec3(0.478503444661927, -0.6723194203618882, -0.5648194848364609),
	vec3(0.4242192202600887, -0.5533717949987785, -0.7168107906984603),
	vec3(-0.06327981995235234, -0.8303585955097378, -0.5536246627904987),
	vec3(-0.1587452578209707, -0.7039825305942619, -0.6922489001345201),
	vec3(0.03804779270257293, -0.7377121687356224, -0.6740423737198179),
	vec3(-0.7669127247671226, 0.06604240822015314, -0.6383441649351473),
	vec3(-0.7822968245335927, 0.2626605565000715, -0.5648195378912896),
	vec3(-0.6684643029895334, 0.1983373747927902, -0.716810826779996),
	vec3(-0.4368780799754227, 0.7089691527308095, -0.5536246776591034),
	vec3(-0.2853629379766348, 0.6628419483607846, -0.6922489040241394),
	vec3(-0.4643976310662084, 0.5744577400396785, -0.6740423912252097),
	vec3(-0.1332592980114285, 0.196412236338106, -0.9714237967592545),
	vec3(-0.2978065193268439, 0.06656685641802862, -0.952302541565994),
	vec3(-0.2943721736095204, 0.2641512012071731, -0.9184602148733575),
	vec3(-0.2997991395355598, -0.7089691548913239, -0.6383441182829368),
	vec3(-0.4915480473667672, -0.6628419453847681, -0.5648195044157509),
	vec3(-0.3951968841337059, -0.5744577408693167, -0.7168108026015872),
	vec3(-0.8092724530415962, -0.1964122339306219, -0.5536247204654248),
	vec3(-0.7185821131631301, -0.06656685584061349, -0.6922489439107188),
	vec3(-0.6898485123309551, -0.264151198802353, -0.6740424127649891),
	vec3(-0.2279785112534667, -0.06604240900587859, -0.9714237996978217),
	vec3(-0.1553361201951539, -0.2626605594970475, -0.952302536092084),
	vec3(-0.3421887113356475, -0.1983373764355497, -0.9184602173981801),
	vec3(0.45990432261889, 0.3341400627724058, 0.8227019098597699),
	vec3(0.5301714501542698, 0.3341400621765583, 0.7792744396488085),
	vec3(0.4816180611475196, 0.4009680745288218, 0.7792744358601489),
	vec3(-0.175667824531754, 0.5406499871878561, 0.8227018942351185),
	vec3(-0.1539540864042353, 0.6074780000919469, 0.7792744180862897),
	vec3(-0.2325151274147121, 0.5819519712186898, 0.7792744181082819),
	vec3(-0.5684730319776966, 0, 0.8227018973565605),
	vec3(-0.6253203355933932, 0.04130198440989028, 0.7792744214826836),
	vec3(-0.6253203355933932, -0.04130198440989028, 0.7792744214826836),
	vec3(-0.175667824531754, -0.5406499871878561, 0.8227018942351185),
	vec3(-0.2325151274147121, -0.5819519712186898, 0.7792744181082819),
	vec3(-0.1539540864042353, -0.6074780000919469, 0.7792744180862897),
	vec3(0.45990432261889, -0.3341400627724058, 0.8227019098597699),
	vec3(0.4816180611475196, -0.4009680745288218, 0.7792744358601489),
	vec3(0.5301714501542698, -0.3341400621765583, 0.7792744396488085),
	vec3(0.8144079769894059, -0.5406499856513964, 0.2108014232190292),
	vec3(0.7658545844579285, -0.6074779977993813, 0.2108014175816384),
	vec3(0.8009881516296262, -0.5819519694745912, 0.1405342882488089),
	vec3(0.9900758210291521, 0, -0.1405342257724078),
	vec3(0.9766559944744465, -0.04130198536702666, -0.2108013625711936),
	vec3(0.9766559944744465, 0.04130198536702666, -0.2108013625711936),
	vec3(0.8144079769894059, 0.5406499856513964, 0.2108014232190292),
	vec3(0.8009881516296262, 0.5819519694745912, 0.1405342882488089),
	vec3(0.7658545844579285, 0.6074779977993813, 0.2108014175816384),
	vec3(0.3059502493513199, 0.9416180579316041, -0.1405342588089443),
	vec3(0.3410838140434523, 0.9160920295067796, -0.210801388211087),
	vec3(0.2625227740929512, 0.9416180583700382, -0.2108013881215691),
	vec3(-0.2625227740929512, 0.9416180583700382, 0.2108013881215691),
	vec3(-0.3059502493513199, 0.9416180579316041, 0.1405342588089443),
	vec3(-0.3410838140434523, 0.9160920295067796, 0.210801388211087),
	vec3(-0.8009881516296262, 0.5819519694745912, -0.1405342882488089),
	vec3(-0.7658545844579285, 0.6074779977993813, -0.2108014175816384),
	vec3(-0.8144079769894059, 0.5406499856513964, -0.2108014232190292),
	vec3(-0.9766559944744465, 0.04130198536702666, 0.2108013625711936),
	vec3(-0.9900758210291521, 0, 0.1405342257724078),
	vec3(-0.9766559944744465, -0.04130198536702666, 0.2108013625711936),
	vec3(-0.8009881516296262, -0.5819519694745912, -0.1405342882488089),
	vec3(-0.8144079769894059, -0.5406499856513964, -0.2108014232190292),
	vec3(-0.7658545844579285, -0.6074779977993813, -0.2108014175816384),
	vec3(-0.3410838140434523, -0.9160920295067796, 0.210801388211087),
	vec3(-0.3059502493513199, -0.9416180579316041, 0.1405342588089443),
	vec3(-0.2625227740929512, -0.9416180583700382, 0.2108013881215691),
	vec3(0.3059502493513199, -0.9416180579316041, -0.1405342588089443),
	vec3(0.2625227740929512, -0.9416180583700382, -0.2108013881215691),
	vec3(0.3410838140434523, -0.9160920295067796, -0.210801388211087),
	vec3(0.6253203355933932, 0.04130198440989028, -0.7792744214826836),
	vec3(0.6253203355933932, -0.04130198440989028, -0.7792744214826836),
	vec3(0.5684730319776966, 0, -0.8227018973565605),
	vec3(0.2325151274147121, 0.5819519712186898, -0.7792744181082819),
	vec3(0.175667824531754, 0.5406499871878561, -0.8227018942351185),
	vec3(0.1539540864042353, 0.6074780000919469, -0.7792744180862897),
	vec3(0.2325151274147121, -0.5819519712186898, -0.7792744181082819),
	vec3(0.1539540864042353, -0.6074780000919469, -0.7792744180862897),
	vec3(0.175667824531754, -0.5406499871878561, -0.8227018942351185),
	vec3(-0.4816180611475196, 0.4009680745288218, -0.7792744358601489),
	vec3(-0.45990432261889, 0.3341400627724058, -0.8227019098597699),
	vec3(-0.5301714501542698, 0.3341400621765583, -0.7792744396488085),
	vec3(-0.5301714501542698, -0.3341400621765583, -0.7792744396488085),
	vec3(-0.45990432261889, -0.3341400627724058, -0.8227019098597699),
	vec3(-0.4816180611475196, -0.4009680745288218, -0.7792744358601489),
	vec3(0.3562768584096539, 0.6675024055536659, 0.6538404535831481),
	vec3(0.4115347125563457, 0.6222915486628134, 0.6658771724755275),
	vec3(0.4254808137638239, 0.6675024045463057, 0.6110700590306924),
	vec3(0.251670683551911, 0.1325698456354605, 0.9586903061305585),
	vec3(0.2740295260940814, 0.1990941147056523, 0.9408875343622242),
	vec3(0.2038519289824483, 0.1983867220562399, 0.9586903043016108),
	vec3(0.7663132831739173, 0.1983867198749349, 0.6110700953315222),
	vec3(0.719005622646297, 0.1990941128053397, 0.6658772025300652),
	vec3(0.7449280820126271, 0.1325698442730731, 0.6538404920302826),
	vec3(-0.5247369039322772, 0.5451090293969176, 0.6538404451557874),
	vec3(-0.4646632076233954, 0.5836914525294369, 0.66587715963623),
	vec3(-0.5033517039334641, 0.6109259054484169, 0.6110700452479328),
	vec3(-0.04831089124592208, 0.2803193947895158, 0.9586903017616609),
	vec3(-0.1046699684283119, 0.3221410480026539, 0.9408875293577696),
	vec3(-0.1256832697982139, 0.2551795857442543, 0.9586903017722772),
	vec3(0.0481268584887213, 0.7901121474513726, 0.6110700450372176),
	vec3(0.032835216518626, 0.7453384848934718, 0.6658771594617726),
	vec3(0.1041140371220154, 0.7494350804736041, 0.6538404449326136),
	vec3(-0.6805821064904111, -0.3306065122758958, 0.6538404471779355),
	vec3(-0.6987123798137348, -0.2615504059382899, 0.6658771624320383),
	vec3(-0.7365692861510186, -0.2899294448109305, 0.6110700481373675),
	vec3(-0.2815284703725243, 0.04067706753243745, 0.9586903027290244),
	vec3(-0.3387191380029065, 0, 0.9408875307658021),
	vec3(-0.2815284703725243, -0.04067706753243745, 0.9586903027290244),
	vec3(-0.7365692861510186, 0.2899294448109305, 0.6110700481373675),
	vec3(-0.6987123798137348, 0.2615504059382899, 0.6658771624320383),
	vec3(-0.6805821064904111, 0.3306065122758958, 0.6538404471779355),
	vec3(0.1041140371220154, -0.7494350804736041, 0.6538404449326136),
	vec3(0.032835216518626, -0.7453384848934718, 0.6658771594617726),
	vec3(0.0481268584887213, -0.7901121474513726, 0.6110700450372176),
	vec3(-0.1256832697982139, -0.2551795857442543, 0.9586903017722772),
	vec3(-0.1046699684283119, -0.3221410480026539, 0.9408875293577696),
	vec3(-0.04831089124592208, -0.2803193947895158, 0.9586903017616609),
	vec3(-0.5033517039334641, -0.6109259054484169, 0.6110700452479328),
	vec3(-0.4646632076233954, -0.5836914525294369, 0.66587715963623),
	vec3(-0.5247369039322772, -0.5451090293969176, 0.6538404451557874),
	vec3(0.7449280820126271, -0.1325698442730731, 0.6538404920302826),
	vec3(0.719005622646297, -0.1990941128053397, 0.6658772025300652),
	vec3(0.7663132831739173, -0.1983867198749349, 0.6110700953315222),
	vec3(0.2038519289824483, -0.1983867220562399, 0.9586903043016108),
	vec3(0.2740295260940814, -0.1990941147056523, 0.9408875343622242),
	vec3(0.251670683551911, -0.1325698456354605, 0.9586903061305585),
	vec3(0.4254808137638239, -0.6675024045463057, 0.6110700590306924),
	vec3(0.4115347125563457, -0.6222915486628134, 0.6658771724755275),
	vec3(0.3562768584096539, -0.6675024055536659, 0.6538404535831481),
	vec3(0.8194821543343318, -0.5451090300171105, -0.1769325976787983),
	vec3(0.80338234458769, -0.583691451943209, -0.1178180687891907),
	vec3(0.7716633938538915, -0.6109259042493372, -0.1769326032788298),
	vec3(0.8790839393212928, -0.2803193938336965, 0.3855288122411429),
	vec3(0.8883652055130684, -0.322141047655686, 0.3271580765456061),
	vec3(0.9136859222768167, -0.2551795862746182, 0.3163248554601387),
	vec3(0.5250346817966718, -0.7901121435248636, 0.3163248070657959),
	vec3(0.5808942816800735, -0.7453384809924996, 0.3271580386650843),
	vec3(0.5382514594164906, -0.7494350765553665, 0.3855287699568867),
	vec3(0.8891782522660518, 0.3306065156192068, -0.3163247817152751),
	vec3(0.9080523229256142, 0.2615504089699224, -0.3271580083034228),
	vec3(0.8759614727324965, 0.2899294471159154, -0.3855287459883835),
	vec3(0.9833820235891853, -0.04067706838780731, 0.1769326758657444),
	vec3(0.993035188310731, 0, 0.1178181428162541),
	vec3(0.9833820235891853, 0.04067706838780731, 0.1769326758657444),
	vec3(0.8759614727324965, -0.2899294471159154, -0.3855287459883835),
	vec3(0.9080523229256142, -0.2615504089699224, -0.3271580083034228),
	vec3(0.8891782522660518, -0.3306065156192068, -0.3163247817152751),
	vec3(0.5382514594164906, 0.7494350765553665, 0.3855287699568867),
	vec3(0.5808942816800735, 0.7453384809924996, 0.3271580386650843),
	vec3(0.5250346817966718, 0.7901121435248636, 0.3163248070657959),
	vec3(0.9136859222768167, 0.2551795862746182, 0.3163248554601387),
	vec3(0.8883652055130684, 0.322141047655686, 0.3271580765456061),
	vec3(0.8790839393212928, 0.2803193938336965, 0.3855288122411429),
	vec3(0.7716633938538915, 0.6109259042493372, -0.1769326032788298),
	vec3(0.80338234458769, 0.583691451943209, -0.1178180687891907),
	vec3(0.8194821543343318, 0.5451090300171105, -0.1769325976787983),
	vec3(-0.03965428270072445, 0.9478217983663201, -0.3163247957481768),
	vec3(0.03185438356687668, 0.9444325953761917, -0.3271580215103474),
	vec3(-0.005052303927479877, 0.9226819899638579, -0.3855287533003989),
	vec3(0.3425679490531336, 0.9226819876012313, 0.1769326143981676),
	vec3(0.3068647502244213, 0.9444325935180392, 0.1178180859227217),
	vec3(0.2651955715481197, 0.9478217969453344, 0.1769326144795904),
	vec3(0.5464262558950483, 0.7434957478402878, -0.3855287535475539),
	vec3(0.5293528042845781, 0.7827855628377626, -0.3271580217705511),
	vec3(0.5891966545277835, 0.7434957469452277, -0.3163247960050328),
	vec3(-0.5464262558950483, 0.7434957478402878, 0.3855287535475539),
	vec3(-0.5293528042845781, 0.7827855628377626, 0.3271580217705511),
	vec3(-0.5891966545277835, 0.7434957469452277, 0.3163247960050328),
	vec3(0.03965428270072445, 0.9478217983663201, 0.3163247957481768),
	vec3(-0.03185438356687668, 0.9444325953761917, 0.3271580215103474),
	vec3(0.005052303927479877, 0.9226819899638579, 0.3855287533003989),
	vec3(-0.3425679490531336, 0.9226819876012313, -0.1769326143981676),
	vec3(-0.3068647502244213, 0.9444325935180392, -0.1178180859227217),
	vec3(-0.2651955715481197, 0.9478217969453344, -0.1769326144795904),
	vec3(-0.9136859222768167, 0.2551795862746182, -0.3163248554601387),
	vec3(-0.8883652055130684, 0.322141047655686, -0.3271580765456061),
	vec3(-0.8790839393212928, 0.2803193938336965, -0.3855288122411429),
	vec3(-0.7716633938538915, 0.6109259042493372, 0.1769326032788298),
	vec3(-0.80338234458769, 0.583691451943209, 0.1178180687891907),
	vec3(-0.8194821543343318, 0.5451090300171105, 0.1769325976787983),
	vec3(-0.5382514594164906, 0.7494350765553665, -0.3855287699568867),
	vec3(-0.5808942816800735, 0.7453384809924996, -0.3271580386650843),
	vec3(-0.5250346817966718, 0.7901121435248636, -0.3163248070657959),
	vec3(-0.8759614727324965, -0.2899294471159154, 0.3855287459883835),
	vec3(-0.9080523229256142, -0.2615504089699224, 0.3271580083034228),
	vec3(-0.8891782522660518, -0.3306065156192068, 0.3163247817152751),
	vec3(-0.8891782522660518, 0.3306065156192068, 0.3163247817152751),
	vec3(-0.9080523229256142, 0.2615504089699224, 0.3271580083034228),
	vec3(-0.8759614727324965, 0.2899294471159154, 0.3855287459883835),
	vec3(-0.9833820235891853, -0.04067706838780731, -0.1769326758657444),
	vec3(-0.993035188310731, 0, -0.1178181428162541),
	vec3(-0.9833820235891853, 0.04067706838780731, -0.1769326758657444),
	vec3(-0.5250346817966718, -0.7901121435248636, -0.3163248070657959),
	vec3(-0.5808942816800735, -0.7453384809924996, -0.3271580386650843),
	vec3(-0.5382514594164906, -0.7494350765553665, -0.3855287699568867),
	vec3(-0.8194821543343318, -0.5451090300171105, 0.1769325976787983),
	vec3(-0.80338234458769, -0.583691451943209, 0.1178180687891907),
	vec3(-0.7716633938538915, -0.6109259042493372, 0.1769326032788298),
	vec3(-0.8790839393212928, -0.2803193938336965, -0.3855288122411429),
	vec3(-0.8883652055130684, -0.322141047655686, -0.3271580765456061),
	vec3(-0.9136859222768167, -0.2551795862746182, -0.3163248554601387),
	vec3(0.005052303927479877, -0.9226819899638579, 0.3855287533003989),
	vec3(-0.03185438356687668, -0.9444325953761917, 0.3271580215103474),
	vec3(0.03965428270072445, -0.9478217983663201, 0.3163247957481768),
	vec3(-0.5891966545277835, -0.7434957469452277, 0.3163247960050328),
	vec3(-0.5293528042845781, -0.7827855628377626, 0.3271580217705511),
	vec3(-0.5464262558950483, -0.7434957478402878, 0.3855287535475539),
	vec3(-0.2651955715481197, -0.9478217969453344, -0.1769326144795904),
	vec3(-0.3068647502244213, -0.9444325935180392, -0.1178180859227217),
	vec3(-0.3425679490531336, -0.9226819876012313, -0.1769326143981676),
	vec3(0.5891966545277835, -0.7434957469452277, -0.3163247960050328),
	vec3(0.5293528042845781, -0.7827855628377626, -0.3271580217705511),
	vec3(0.5464262558950483, -0.7434957478402878, -0.3855287535475539),
	vec3(0.2651955715481197, -0.9478217969453344, 0.1769326144795904),
	vec3(0.3068647502244213, -0.9444325935180392, 0.1178180859227217),
	vec3(0.3425679490531336, -0.9226819876012313, 0.1769326143981676),
	vec3(-0.005052303927479877, -0.9226819899638579, -0.3855287533003989),
	vec3(0.03185438356687668, -0.9444325953761917, -0.3271580215103474),
	vec3(-0.03965428270072445, -0.9478217983663201, -0.3163247957481768),
	vec3(0.2815284703725243, 0.04067706753243745, -0.9586903027290244),
	vec3(0.3387191380029065, 0, -0.9408875307658021),
	vec3(0.2815284703725243, -0.04067706753243745, -0.9586903027290244),
	vec3(0.7365692861510186, 0.2899294448109305, -0.6110700481373675),
	vec3(0.6987123798137348, 0.2615504059382899, -0.6658771624320383),
	vec3(0.6805821064904111, 0.3306065122758958, -0.6538404471779355),
	vec3(0.6805821064904111, -0.3306065122758958, -0.6538404471779355),
	vec3(0.6987123798137348, -0.2615504059382899, -0.6658771624320383),
	vec3(0.7365692861510186, -0.2899294448109305, -0.6110700481373675),
	vec3(-0.0481268584887213, 0.7901121474513726, -0.6110700450372176),
	vec3(-0.032835216518626, 0.7453384848934718, -0.6658771594617726),
	vec3(-0.1041140371220154, 0.7494350804736041, -0.6538404449326136),
	vec3(0.5247369039322772, 0.5451090293969176, -0.6538404451557874),
	vec3(0.4646632076233954, 0.5836914525294369, -0.66587715963623),
	vec3(0.5033517039334641, 0.6109259054484169, -0.6110700452479328),
	vec3(0.04831089124592208, 0.2803193947895158, -0.9586903017616609),
	vec3(0.1046699684283119, 0.3221410480026539, -0.9408875293577696),
	vec3(0.1256832697982139, 0.2551795857442543, -0.9586903017722772),
	vec3(0.1256832697982139, -0.2551795857442543, -0.9586903017722772),
	vec3(0.1046699684283119, -0.3221410480026539, -0.9408875293577696),
	vec3(0.04831089124592208, -0.2803193947895158, -0.9586903017616609),
	vec3(0.5033517039334641, -0.6109259054484169, -0.6110700452479328),
	vec3(0.4646632076233954, -0.5836914525294369, -0.66587715963623),
	vec3(0.5247369039322772, -0.5451090293969176, -0.6538404451557874),
	vec3(-0.1041140371220154, -0.7494350804736041, -0.6538404449326136),
	vec3(-0.032835216518626, -0.7453384848934718, -0.6658771594617726),
	vec3(-0.0481268584887213, -0.7901121474513726, -0.6110700450372176),
	vec3(-0.7663132831739173, 0.1983867198749349, -0.6110700953315222),
	vec3(-0.719005622646297, 0.1990941128053397, -0.6658772025300652),
	vec3(-0.7449280820126271, 0.1325698442730731, -0.6538404920302826),
	vec3(-0.3562768584096539, 0.6675024055536659, -0.6538404535831481),
	vec3(-0.4115347125563457, 0.6222915486628134, -0.6658771724755275),
	vec3(-0.4254808137638239, 0.6675024045463057, -0.6110700590306924),
	vec3(-0.251670683551911, 0.1325698456354605, -0.9586903061305585),
	vec3(-0.2740295260940814, 0.1990941147056523, -0.9408875343622242),
	vec3(-0.2038519289824483, 0.1983867220562399, -0.9586903043016108),
	vec3(-0.4254808137638239, -0.6675024045463057, -0.6110700590306924),
	vec3(-0.4115347125563457, -0.6222915486628134, -0.6658771724755275),
	vec3(-0.3562768584096539, -0.6675024055536659, -0.6538404535831481),
	vec3(-0.7449280820126271, -0.1325698442730731, -0.6538404920302826),
	vec3(-0.719005622646297, -0.1990941128053397, -0.6658772025300652),
	vec3(-0.7663132831739173, -0.1983867198749349, -0.6110700953315222),
	vec3(-0.2038519289824483, -0.1983867220562399, -0.9586903043016108),
	vec3(-0.2740295260940814, -0.1990941147056523, -0.9408875343622242),
	vec3(-0.251670683551911, -0.1325698456354605, -0.9586903061305585),
	vec3(0.2879934530130329, 0.4542618181847967, 0.8430337902842759),
	vec3(0.3387417671232413, 0.3941362319857225, 0.8543480823659174),
	vec3(0.3604286544940019, 0.4608816047652282, 0.8109743099560376),
	vec3(0.5210235063549314, 0.133523434586323, 0.8430338061085598),
	vec3(0.5497030090857538, 0.2003677814319438, 0.8109743238636528),
	vec3(0.4795227729872087, 0.2003677819523299, 0.8543480919052615),
	vec3(0.6252377298876787, 0.4542618151034005, 0.6346053769578902),
	vec3(0.5641688494841359, 0.460881602889256, 0.6850559520141232),
	vec3(0.6126621982811917, 0.3941362296240275, 0.6850559563240169),
	vec3(-0.3430337867949106, 0.4142726857374034, 0.8430337851883888),
	vec3(-0.2701688632911439, 0.4439573769149704, 0.8543480747275961),
	vec3(-0.3269458694226094, 0.4852082873994554, 0.8109743006448364),
	vec3(0.03401679713289796, 0.5367838435521608, 0.8430337850965336),
	vec3(-0.02069350113115726, 0.5847157111242114, 0.810974300564107),
	vec3(-0.04238038826843778, 0.5179703369828064, 0.8543480746722231),
	vec3(-0.2388195663817262, 0.7350110689727167, 0.6346053444471048),
	vec3(-0.2639866820932823, 0.6789767373482807, 0.6850559260507599),
	vec3(-0.1855227888392181, 0.704471200999964, 0.6850559260257424),
	vec3(-0.5000000003815028, -0.1982272273328965, 0.843033786963731),
	vec3(-0.5057153205715988, -0.1197554910565916, 0.8543480771330616),
	vec3(-0.5624923273151616, -0.1610064018518979, 0.8109743030912128),
	vec3(-0.5000000003815028, 0.1982272273328965, 0.843033786963731),
	vec3(-0.5624923273151616, 0.1610064018518979, 0.8109743030912128),
	vec3(-0.5057153205715988, 0.1197554910565916, 0.8543480771330616),
	vec3(-0.7728363676194773, 0, 0.6346053489254028),
	vec3(-0.727321617295778, -0.04125091080771766, 0.6850559301048256),
	vec3(-0.727321617295778, 0.04125091080771766, 0.6850559301048256),
	vec3(0.03401679713289796, -0.5367838435521608, 0.8430337850965336),
	vec3(-0.04238038826843778, -0.5179703369828064, 0.8543480746722231),
	vec3(-0.02069350113115726, -0.5847157111242114, 0.810974300564107),
	vec3(-0.3430337867949106, -0.4142726857374034, 0.8430337851883888),
	vec3(-0.3269458694226094, -0.4852082873994554, 0.8109743006448364),
	vec3(-0.2701688632911439, -0.4439573769149704, 0.8543480747275961),
	vec3(-0.2388195663817262, -0.7350110689727167, 0.6346053444471048),
	vec3(-0.1855227888392181, -0.704471200999964, 0.6850559260257424),
	vec3(-0.2639866820932823, -0.6789767373482807, 0.6850559260507599),
	vec3(0.5210235063549314, -0.133523434586323, 0.8430338061085598),
	vec3(0.4795227729872087, -0.2003677819523299, 0.8543480919052615),
	vec3(0.5497030090857538, -0.2003677814319438, 0.8109743238636528),
	vec3(0.2879934530130329, -0.4542618181847967, 0.8430337902842759),
	vec3(0.3604286544940019, -0.4608816047652282, 0.8109743099560376),
	vec3(0.3387417671232413, -0.3941362319857225, 0.8543480823659174),
	vec3(0.6252377298876787, -0.4542618151034005, 0.6346053769578902),
	vec3(0.6126621982811917, -0.3941362296240275, 0.6850559563240169),
	vec3(0.5641688494841359, -0.460881602889256, 0.6850559520141232),
	vec3(0.9074417097439176, -0.4142726875647819, 0.07019746259579754),
	vec3(0.8849753311667966, -0.4439573774964607, 0.1404297340048883),
	vec3(0.8715721006261746, -0.485208287723465, 0.07024949063545412),
	vec3(0.7388195526171342, -0.536783840092479, 0.4074417475985857),
	vec3(0.7346118709426968, -0.5847157081337523, 0.344169928569762),
	vec3(0.7831052223083134, -0.5179703344018958, 0.3441699340050428),
	vec3(0.674411635696494, -0.7350110651368444, 0.0701974341666487),
	vec3(0.7307910822107557, -0.6789767342359924, 0.07024947350307308),
	vec3(0.6957009613683045, -0.7044711977953574, 0.1404297113434032),
	vec3(0.977639142169332, 0.1982272309951999, -0.07019738307364497),
	vec3(0.9903149203084344, 0.1197554933303623, -0.07024941588156353),
	vec3(0.9769116888432101, 0.1610064051067975, -0.140429661097977),
	vec3(0.977639142169332, -0.1982272309951999, -0.07019738307364497),
	vec3(0.9769116888432101, -0.1610064051067975, -0.140429661097977),
	vec3(0.9903149203084344, -0.1197554933303623, -0.07024941588156353),
	vec3(0.913231218582656, 0, -0.4074417030766947),
	vec3(0.9380007752191707, 0.04125091175519217, -0.3441698824237823),
	vec3(0.9380007752191707, -0.04125091175519217, -0.3441698824237823),
	vec3(0.7388195526171342, 0.536783840092479, 0.4074417475985857),
	vec3(0.7831052223083134, 0.5179703344018958, 0.3441699340050428),
	vec3(0.7346118709426968, 0.5847157081337523, 0.344169928569762),
	vec3(0.9074417097439176, 0.4142726875647819, 0.07019746259579754),
	vec3(0.8715721006261746, 0.485208287723465, 0.07024949063545412),
	vec3(0.8849753311667966, 0.4439573774964607, 0.1404297340048883),
	vec3(0.674411635696494, 0.7350110651368444, 0.0701974341666487),
	vec3(0.6957009613683045, 0.7044711977953574, 0.1404297113434032),
	vec3(0.7307910822107557, 0.6789767342359924, 0.07024947350307308),
	vec3(0.1135818163267338, 0.9910456563160109, -0.07019742229659855),
	vec3(0.1921299003602622, 0.9788519374030351, -0.07024945572657633),
	vec3(0.1487561270153196, 0.9788519376693705, -0.1404296934281385),
	vec3(0.490632395964318, 0.8685344978180238, -0.07019742253321057),
	vec3(0.4550084915989321, 0.8793445136609439, -0.1404296936807258),
	vec3(0.4199183727294213, 0.9048389769420134, -0.07024945587550999),
	vec3(0.2822039596864225, 0.8685345008107711, -0.4074417087617425),
	vec3(0.2506262275131402, 0.904838979019647, -0.3441698942807386),
	vec3(0.3290901197458106, 0.8793445154636736, -0.3441698943975852),
	vec3(-0.2822039596864225, 0.8685345008107711, 0.4074417087617425),
	vec3(-0.2506262275131402, 0.904838979019647, 0.3441698942807386),
	vec3(-0.3290901197458106, 0.8793445154636736, 0.3441698943975852),
	vec3(-0.1135818163267338, 0.9910456563160109, 0.07019742229659855),
	vec3(-0.1921299003602622, 0.9788519374030351, 0.07024945572657633),
	vec3(-0.1487561270153196, 0.9788519376693705, 0.1404296934281385),
	vec3(-0.490632395964318, 0.8685344978180238, 0.07019742253321057),
	vec3(-0.4550084915989321, 0.8793445136609439, 0.1404296936807258),
	vec3(-0.4199183727294213, 0.9048389769420134, 0.07024945587550999),
	vec3(-0.9074417097439176, 0.4142726875647819, -0.07019746259579754),
	vec3(-0.8715721006261746, 0.485208287723465, -0.07024949063545412),
	vec3(-0.8849753311667966, 0.4439573774964607, -0.1404297340048883),
	vec3(-0.674411635696494, 0.7350110651368444, -0.0701974341666487),
	vec3(-0.6957009613683045, 0.7044711977953574, -0.1404297113434032),
	vec3(-0.7307910822107557, 0.6789767342359924, -0.07024947350307308),
	vec3(-0.7388195526171342, 0.536783840092479, -0.4074417475985857),
	vec3(-0.7831052223083134, 0.5179703344018958, -0.3441699340050428),
	vec3(-0.7346118709426968, 0.5847157081337523, -0.344169928569762),
	vec3(-0.913231218582656, 0, 0.4074417030766947),
	vec3(-0.9380007752191707, 0.04125091175519217, 0.3441698824237823),
	vec3(-0.9380007752191707, -0.04125091175519217, 0.3441698824237823),
	vec3(-0.977639142169332, 0.1982272309951999, 0.07019738307364497),
	vec3(-0.9903149203084344, 0.1197554933303623, 0.07024941588156353),
	vec3(-0.9769116888432101, 0.1610064051067975, 0.140429661097977),
	vec3(-0.977639142169332, -0.1982272309951999, 0.07019738307364497),
	vec3(-0.9769116888432101, -0.1610064051067975, 0.140429661097977),
	vec3(-0.9903149203084344, -0.1197554933303623, 0.07024941588156353),
	vec3(-0.674411635696494, -0.7350110651368444, -0.0701974341666487),
	vec3(-0.7307910822107557, -0.6789767342359924, -0.07024947350307308),
	vec3(-0.6957009613683045, -0.7044711977953574, -0.1404297113434032),
	vec3(-0.9074417097439176, -0.4142726875647819, -0.07019746259579754),
	vec3(-0.8849753311667966, -0.4439573774964607, -0.1404297340048883),
	vec3(-0.8715721006261746, -0.485208287723465, -0.07024949063545412),
	vec3(-0.7388195526171342, -0.536783840092479, -0.4074417475985857),
	vec3(-0.7346118709426968, -0.5847157081337523, -0.344169928569762),
	vec3(-0.7831052223083134, -0.5179703344018958, -0.3441699340050428),
	vec3(-0.2822039596864225, -0.8685345008107711, 0.4074417087617425),
	vec3(-0.3290901197458106, -0.8793445154636736, 0.3441698943975852),
	vec3(-0.2506262275131402, -0.904838979019647, 0.3441698942807386),
	vec3(-0.490632395964318, -0.8685344978180238, 0.07019742253321057),
	vec3(-0.4199183727294213, -0.9048389769420134, 0.07024945587550999),
	vec3(-0.4550084915989321, -0.8793445136609439, 0.1404296936807258),
	vec3(-0.1135818163267338, -0.9910456563160109, 0.07019742229659855),
	vec3(-0.1487561270153196, -0.9788519376693705, 0.1404296934281385),
	vec3(-0.1921299003602622, -0.9788519374030351, 0.07024945572657633),
	vec3(0.490632395964318, -0.8685344978180238, -0.07019742253321057),
	vec3(0.4199183727294213, -0.9048389769420134, -0.07024945587550999),
	vec3(0.4550084915989321, -0.8793445136609439, -0.1404296936807258),
	vec3(0.1135818163267338, -0.9910456563160109, -0.07019742229659855),
	vec3(0.1487561270153196, -0.9788519376693705, -0.1404296934281385),
	vec3(0.1921299003602622, -0.9788519374030351, -0.07024945572657633),
	vec3(0.2822039596864225, -0.8685345008107711, -0.4074417087617425),
	vec3(0.3290901197458106, -0.8793445154636736, -0.3441698943975852),
	vec3(0.2506262275131402, -0.904838979019647, -0.3441698942807386),
	vec3(0.5000000003815028, 0.1982272273328965, -0.843033786963731),
	vec3(0.5624923273151616, 0.1610064018518979, -0.8109743030912128),
	vec3(0.5057153205715988, 0.1197554910565916, -0.8543480771330616),
	vec3(0.7728363676194773, 0, -0.6346053489254028),
	vec3(0.727321617295778, -0.04125091080771766, -0.6850559301048256),
	vec3(0.727321617295778, 0.04125091080771766, -0.6850559301048256),
	vec3(0.5000000003815028, -0.1982272273328965, -0.843033786963731),
	vec3(0.5057153205715988, -0.1197554910565916, -0.8543480771330616),
	vec3(0.5624923273151616, -0.1610064018518979, -0.8109743030912128),
	vec3(0.2388195663817262, 0.7350110689727167, -0.6346053444471048),
	vec3(0.2639866820932823, 0.6789767373482807, -0.6850559260507599),
	vec3(0.1855227888392181, 0.704471200999964, -0.6850559260257424),
	vec3(0.3430337867949106, 0.4142726857374034, -0.8430337851883888),
	vec3(0.2701688632911439, 0.4439573769149704, -0.8543480747275961),
	vec3(0.3269458694226094, 0.4852082873994554, -0.8109743006448364),
	vec3(-0.03401679713289796, 0.5367838435521608, -0.8430337850965336),
	vec3(0.02069350113115726, 0.5847157111242114, -0.810974300564107),
	vec3(0.04238038826843778, 0.5179703369828064, -0.8543480746722231),
	vec3(0.3430337867949106, -0.4142726857374034, -0.8430337851883888),
	vec3(0.3269458694226094, -0.4852082873994554, -0.8109743006448364),
	vec3(0.2701688632911439, -0.4439573769149704, -0.8543480747275961),
	vec3(0.2388195663817262, -0.7350110689727167, -0.6346053444471048),
	vec3(0.1855227888392181, -0.704471200999964, -0.6850559260257424),
	vec3(0.2639866820932823, -0.6789767373482807, -0.6850559260507599),
	vec3(-0.03401679713289796, -0.5367838435521608, -0.8430337850965336),
	vec3(0.04238038826843778, -0.5179703369828064, -0.8543480746722231),
	vec3(0.02069350113115726, -0.5847157111242114, -0.810974300564107),
	vec3(-0.6252377298876787, 0.4542618151034005, -0.6346053769578902),
	vec3(-0.5641688494841359, 0.460881602889256, -0.6850559520141232),
	vec3(-0.6126621982811917, 0.3941362296240275, -0.6850559563240169),
	vec3(-0.2879934530130329, 0.4542618181847967, -0.8430337902842759),
	vec3(-0.3387417671232413, 0.3941362319857225, -0.8543480823659174),
	vec3(-0.3604286544940019, 0.4608816047652282, -0.8109743099560376),
	vec3(-0.5210235063549314, 0.133523434586323, -0.8430338061085598),
	vec3(-0.5497030090857538, 0.2003677814319438, -0.8109743238636528),
	vec3(-0.4795227729872087, 0.2003677819523299, -0.8543480919052615),
	vec3(-0.6252377298876787, -0.4542618151034005, -0.6346053769578902),
	vec3(-0.6126621982811917, -0.3941362296240275, -0.6850559563240169),
	vec3(-0.5641688494841359, -0.460881602889256, -0.6850559520141232),
	vec3(-0.5210235063549314, -0.133523434586323, -0.8430338061085598),
	vec3(-0.4795227729872087, -0.2003677819523299, -0.8543480919052615),
	vec3(-0.5497030090857538, -0.2003677814319438, -0.8109743238636528),
	vec3(-0.2879934530130329, -0.4542618181847967, -0.8430337902842759),
	vec3(-0.3604286544940019, -0.4608816047652282, -0.8109743099560376),
	vec3(-0.3387417671232413, -0.3941362319857225, -0.8543480823659174),
	vec3(0.3247314778202054, 0.7864327006042664, 0.5254265645482588),
	vec3(0.312874881421455, 0.749387057039492, 0.5835480677006817),
	vec3(0.3820193572266981, 0.7493870558307721, 0.540814433292407),
	vec3(0.2535637261648291, 0.5645128161113286, 0.7855130280392967),
	vec3(0.3256887600479907, 0.5711402419378897, 0.7534757166740885),
	vec3(0.2700057274014135, 0.61545583545293, 0.7404802642727014),
	vec3(0.5891870476937116, 0.5645128123355965, 0.5780864187463012),
	vec3(0.5415554366997106, 0.6154558319801341, 0.5726533225806226),
	vec3(0.5282767073251864, 0.571140239647055, 0.6282694860914094),
	vec3(0.09058921294853754, 0.06581691941908625, 0.9937110886045029),
	vec3(0.159969655135884, 0.06598835973848186, 0.9849138265933375),
	vec3(0.1121919999838403, 0.1317486679452729, 0.9849138254864089),
	vec3(0.4274408998687668, 0.06670938210107737, 0.9015786906638108),
	vec3(0.3859996104400737, 0.1332563820105958, 0.9128236617187121),
	vec3(0.3632227867084265, 0.06660439559154094, 0.9293186007519973),
	vec3(0.1955308999941006, 0.3859061470472636, 0.9015786781078136),
	vec3(0.1755865620349274, 0.3248635308578524, 0.9293185920615835),
	vec3(0.2460147886875718, 0.325928980242859, 0.9128236541549849),
	vec3(0.848289452184969, 0.06581691856236001, 0.5254266252700571),
	vec3(0.8307598820061816, 0.1317486662863841, 0.5408144851803013),
	vec3(0.8093930606468889, 0.06598835893498346, 0.583548121290549),
	vec3(0.7189523798619085, 0.3859061430949148, 0.5780864331676577),
	vec3(0.7064331049583341, 0.3259289771194073, 0.6282695043473179),
	vec3(0.7526830895261419, 0.3248635273111496, 0.5726533465931549),
	vec3(0.6152390575570327, 0.06670938159887017, 0.7855130555649793),
	vec3(0.6687696039323282, 0.06660439503273816, 0.7404802977922638),
	vec3(0.6438299789792864, 0.1332563809506197, 0.7534757428766206),
	vec3(-0.6475943939798771, 0.5518590680207195, 0.5254265599768804),
	vec3(-0.6160257834455692, 0.5291350412433695, 0.583548063366378),
	vec3(-0.5946589635521519, 0.5948953489156701, 0.540814423721838),
	vec3(-0.4585280883117704, 0.4155974975135082, 0.7855130249013462),
	vec3(-0.4425432834363517, 0.4862404729258598, 0.7534757094785531),
	vec3(-0.5018969206093552, 0.4469770289192903, 0.7404802608451697),
	vec3(-0.3548147703953562, 0.734794260598439, 0.5780863891330463),
	vec3(-0.417983439082012, 0.7052361625664525, 0.5726532979576023),
	vec3(-0.3799401600931812, 0.6789130701408901, 0.6282694628423685),
	vec3(-0.03460200149720084, 0.1064940134515928, 0.9937110880891687),
	vec3(-0.01332531339781465, 0.1725317180438165, 0.9849138248048399),
	vec3(-0.09063119189928517, 0.1474135161732432, 0.9849138248112653),
	vec3(0.06864212016938311, 0.427134814018541, 0.901578676540211),
	vec3(-0.007453901772566477, 0.4082859562230665, 0.9128236507121084),
	vec3(0.04889747850771557, 0.3660273125454728, 0.9293185907245838),
	vec3(-0.3065961809171641, 0.3052125025676215, 0.9015786766130947),
	vec3(-0.2547043427467997, 0.2673811037187092, 0.9293185907750288),
	vec3(-0.233954124846683, 0.3346915745693134, 0.9128236507560136),
	vec3(0.1995402625882863, 0.8271097956423047, 0.525426559624409),
	vec3(0.1314185086161542, 0.8308122140491804, 0.5408144234206447),
	vec3(0.1873575673738617, 0.7901701083008331, 0.5835480630553053),
	vec3(-0.1448500371759792, 0.8030159360349073, 0.5780863890493347),
	vec3(-0.09167703080615207, 0.7725754359384491, 0.6282694627363987),
	vec3(-0.07637169637537679, 0.8162325431460495, 0.5726532978182169),
	vec3(0.1266749461320592, 0.605741484450085, 0.785513024741568),
	vec3(0.143316643557175, 0.6566196183989075, 0.7404802606505989),
	vec3(0.07222006902109285, 0.6534972204115205, 0.7534757093264554),
	vec3(-0.7249668243135851, -0.4453650553537312, 0.5254265611048261),
	vec3(-0.6935997539481926, -0.4223636321662246, 0.5835480644697237),
	vec3(-0.7495388138363048, -0.3817215259075892, 0.5408144258538663),
	vec3(-0.5369496714047589, -0.3076594490635966, 0.7855130258501163),
	vec3(-0.5991955578803346, -0.2706271159500195, 0.7534757113066416),
	vec3(-0.5801950846845989, -0.339208852338781, 0.7404802618590439),
	vec3(-0.8084746589339488, -0.1103849953834097, 0.5780863937646691),
	vec3(-0.799883428322876, -0.1795959257928088, 0.5726533022109159),
	vec3(-0.7630926602721795, -0.1515488991492229, 0.6282694668734006),
	vec3(-0.1119744304475942, 0, 0.9937110882575162),
	vec3(-0.1682051611388171, 0.04064210638514562, 0.9849138251414907),
	vec3(-0.1682051611388171, -0.04064210638514562, 0.9849138251414907),
	vec3(-0.3850177633905594, 0.1972744537967651, 0.9015786775167873),
	vec3(-0.390606397936309, 0.1190782168822028, 0.9128236522764825),
	vec3(-0.333002506047983, 0.1596129267195899, 0.9293185915442399),
	vec3(-0.3850177633905594, -0.1972744537967651, 0.9015786775167873),
	vec3(-0.333002506047983, -0.1596129267195899, 0.9293185915442399),
	vec3(-0.390606397936309, -0.1190782168822028, 0.9128236522764825),
	vec3(-0.7249668243135851, 0.4453650553537312, 0.5254265611048261),
	vec3(-0.7495388138363048, 0.3817215259075892, 0.5408144258538663),
	vec3(-0.6935997539481926, 0.4223636321662246, 0.5835480644697237),
	vec3(-0.8084746589339488, 0.1103849953834097, 0.5780863937646691),
	vec3(-0.7630926602721795, 0.1515488991492229, 0.6282694668734006),
	vec3(-0.799883428322876, 0.1795959257928088, 0.5726533022109159),
	vec3(-0.5369496714047589, 0.3076594490635966, 0.7855130258501163),
	vec3(-0.5801950846845989, 0.339208852338781, 0.7404802618590439),
	vec3(-0.5991955578803346, 0.2706271159500195, 0.7534757113066416),
	vec3(0.1995402625882863, -0.8271097956423047, 0.525426559624409),
	vec3(0.1873575673738617, -0.7901701083008331, 0.5835480630553053),
	vec3(0.1314185086161542, -0.8308122140491804, 0.5408144234206447),
	vec3(0.1266749461320592, -0.605741484450085, 0.785513024741568),
	vec3(0.07222006902109285, -0.6534972204115205, 0.7534757093264554),
	vec3(0.143316643557175, -0.6566196183989075, 0.7404802606505989),
	vec3(-0.1448500371759792, -0.8030159360349073, 0.5780863890493347),
	vec3(-0.07637169637537679, -0.8162325431460495, 0.5726532978182169),
	vec3(-0.09167703080615207, -0.7725754359384491, 0.6282694627363987),
	vec3(-0.03460200149720084, -0.1064940134515928, 0.9937110880891687),
	vec3(-0.09063119189928517, -0.1474135161732432, 0.9849138248112653),
	vec3(-0.01332531339781465, -0.1725317180438165, 0.9849138248048399),
	vec3(-0.3065961809171641, -0.3052125025676215, 0.9015786766130947),
	vec3(-0.233954124846683, -0.3346915745693134, 0.9128236507560136),
	vec3(-0.2547043427467997, -0.2673811037187092, 0.9293185907750288),
	vec3(0.06864212016938311, -0.427134814018541, 0.901578676540211),
	vec3(0.04889747850771557, -0.3660273125454728, 0.9293185907245838),
	vec3(-0.007453901772566477, -0.4082859562230665, 0.9128236507121084),
	vec3(-0.6475943939798771, -0.5518590680207195, 0.5254265599768804),
	vec3(-0.5946589635521519, -0.5948953489156701, 0.540814423721838),
	vec3(-0.6160257834455692, -0.5291350412433695, 0.583548063366378),
	vec3(-0.3548147703953562, -0.734794260598439, 0.5780863891330463),
	vec3(-0.3799401600931812, -0.6789130701408901, 0.6282694628423685),
	vec3(-0.417983439082012, -0.7052361625664525, 0.5726532979576023),
	vec3(-0.4585280883117704, -0.4155974975135082, 0.7855130249013462),
	vec3(-0.5018969206093552, -0.4469770289192903, 0.7404802608451697),
	vec3(-0.4425432834363517, -0.4862404729258598, 0.7534757094785531),
	vec3(0.848289452184969, -0.06581691856236001, 0.5254266252700571),
	vec3(0.8093930606468889, -0.06598835893498346, 0.583548121290549),
	vec3(0.8307598820061816, -0.1317486662863841, 0.5408144851803013),
	vec3(0.6152390575570327, -0.06670938159887017, 0.7855130555649793),
	vec3(0.6438299789792864, -0.1332563809506197, 0.7534757428766206),
	vec3(0.6687696039323282, -0.06660439503273816, 0.7404802977922638),
	vec3(0.7189523798619085, -0.3859061430949148, 0.5780864331676577),
	vec3(0.7526830895261419, -0.3248635273111496, 0.5726533465931549),
	vec3(0.7064331049583341, -0.3259289771194073, 0.6282695043473179),
	vec3(0.09058921294853754, -0.06581691941908625, 0.9937110886045029),
	vec3(0.1121919999838403, -0.1317486679452729, 0.9849138254864089),
	vec3(0.159969655135884, -0.06598835973848186, 0.9849138265933375),
	vec3(0.1955308999941006, -0.3859061470472636, 0.9015786781078136),
	vec3(0.2460147886875718, -0.325928980242859, 0.9128236541549849),
	vec3(0.1755865620349274, -0.3248635308578524, 0.9293185920615835),
	vec3(0.4274408998687668, -0.06670938210107737, 0.9015786906638108),
	vec3(0.3632227867084265, -0.06660439559154094, 0.9293186007519973),
	vec3(0.3859996104400737, -0.1332563820105958, 0.9128236617187121),
	vec3(0.3247314778202054, -0.7864327006042664, 0.5254265645482588),
	vec3(0.3820193572266981, -0.7493870558307721, 0.540814433292407),
	vec3(0.312874881421455, -0.749387057039492, 0.5835480677006817),
	vec3(0.5891870476937116, -0.5645128123355965, 0.5780864187463012),
	vec3(0.5282767073251864, -0.571140239647055, 0.6282694860914094),
	vec3(0.5415554366997106, -0.6154558319801341, 0.5726533225806226),
	vec3(0.2535637261648291, -0.5645128161113286, 0.7855130280392967),
	vec3(0.2700057274014135, -0.61545583545293, 0.7404802642727014),
	vec3(0.3256887600479907, -0.5711402419378897, 0.7534757166740885),
	vec3(0.7595688249863434, -0.5518590681370708, -0.3442481213075094),
	vec3(0.797436366084589, -0.5291350424010078, -0.2900195664935197),
	vec3(0.7496587043181064, -0.5948953478925407, -0.2900195719187088),
	vec3(0.9076442042210505, -0.4155975006924117, -0.0588278502255242),
	vec3(0.8718405365238666, -0.4862404743341545, -0.0588581344681673),
	vec3(0.8867608087524729, -0.4469770319100539, -0.1177573819577312),
	vec3(0.6757341796533615, -0.7347942563395582, -0.0588278785831562),
	vec3(0.6991245624518367, -0.7052361589246849, -0.1177574045301796),
	vec3(0.7318556998406828, -0.6789130670468262, -0.05885815154909231),
	vec3(0.9042766742955582, -0.1064940134168315, 0.4134521996934357),
	vec3(0.8868929394609479, -0.1725317171549816, 0.4285483875945315),
	vec3(0.9214651833451599, -0.1474135169288065, 0.3594039105370883),
	vec3(0.7756987734762599, -0.4271348103152457, 0.464593657559361),
	vec3(0.8197877617460405, -0.4082859537433035, 0.4015602142485462),
	vec3(0.8093401768056286, -0.3660273094253116, 0.4593391850943057),
	vec3(0.9435104560796476, -0.3052125056977993, 0.1289703285025139),
	vec3(0.9451150506269881, -0.2673811063977811, 0.1877894699386632),
	vec3(0.9210817486220466, -0.3346915761866369, 0.1989722623509558),
	vec3(0.3807186920986894, -0.8271097932973368, 0.4134521342529267),
	vec3(0.4249469897014183, -0.8308122109313341, 0.3594038482140828),
	vec3(0.4381524077616308, -0.7901701051103219, 0.4285483316530683),
	vec3(0.5818350965581676, -0.8030159315594784, 0.1289702836889595),
	vec3(0.6029405079938764, -0.7725754320133662, 0.1989722233615716),
	vec3(0.5463511475406084, -0.8162325387222852, 0.1877894201280614),
	vec3(0.6459334386864414, -0.6057414800177474, 0.4645936419847113),
	vec3(0.5982125202640856, -0.6566196139726261, 0.4593391591686151),
	vec3(0.6416313579155551, -0.6534972164998112, 0.4015601929554768),
	vec3(0.7941708293811159, 0.4453650567870308, -0.4134521253460856),
	vec3(0.8321285023351566, 0.4223636347548599, -0.359403833644151),
	vec3(0.8189230821249859, 0.3817215273041518, -0.4285483183440342),
	vec3(0.9427154057866085, 0.3076594538506633, -0.1289702452075716),
	vec3(0.941897569333299, 0.2706271202565351, -0.1989721856583931),
	vec3(0.9217768153490562, 0.3392088568868872, -0.1877893875980299),
	vec3(0.8786170557871984, 0.1103849963445891, -0.4645936093639689),
	vec3(0.8699154356927352, 0.1795959268396773, -0.4593391315859294),
	vec3(0.9032067146450726, 0.1515489010709358, -0.4015601588856217),
	vec3(0.938878681135162, 0, 0.344248198411987),
	vec3(0.9561573217842743, -0.0406421072341751, 0.2900196460895187),
	vec3(0.9561573217842743, 0.0406421072341751, 0.2900196460895187),
	vec3(0.97858165858045, -0.1972744573065407, 0.05882793540781012),
	vec3(0.9911387835651618, -0.1190782190462656, 0.05885821490446989),
	vec3(0.9801310584692129, -0.1596129297500483, 0.117757466347687),
	vec3(0.97858165858045, 0.1972744573065407, 0.05882793540781012),
	vec3(0.9801310584692129, 0.1596129297500483, 0.117757466347687),
	vec3(0.9911387835651618, 0.1190782190462656, 0.05885821490446989),
	vec3(0.7941708293811159, -0.4453650567870308, -0.4134521253460856),
	vec3(0.8189230821249859, -0.3817215273041518, -0.4285483183440342),
	vec3(0.8321285023351566, -0.4223636347548599, -0.359403833644151),
	vec3(0.8786170557871984, -0.1103849963445891, -0.4645936093639689),
	vec3(0.9032067146450726, -0.1515489010709358, -0.4015601588856217),
	vec3(0.8699154356927352, -0.1795959268396773, -0.4593391315859294),
	vec3(0.9427154057866085, -0.3076594538506633, -0.1289702452075716),
	vec3(0.9217768153490562, -0.3392088568868872, -0.1877893875980299),
	vec3(0.941897569333299, -0.2706271202565351, -0.1989721856583931),
	vec3(0.3807186920986894, 0.8271097932973368, 0.4134521342529267),
	vec3(0.4381524077616308, 0.7901701051103219, 0.4285483316530683),
	vec3(0.4249469897014183, 0.8308122109313341, 0.3594038482140828),
	vec3(0.6459334386864414, 0.6057414800177474, 0.4645936419847113),
	vec3(0.6416313579155551, 0.6534972164998112, 0.4015601929554768),
	vec3(0.5982125202640856, 0.6566196139726261, 0.4593391591686151),
	vec3(0.5818350965581676, 0.8030159315594784, 0.1289702836889595),
	vec3(0.5463511475406084, 0.8162325387222852, 0.1877894201280614),
	vec3(0.6029405079938764, 0.7725754320133662, 0.1989722233615716),
	vec3(0.9042766742955582, 0.1064940134168315, 0.4134521996934357),
	vec3(0.9214651833451599, 0.1474135169288065, 0.3594039105370883),
	vec3(0.8868929394609479, 0.1725317171549816, 0.4285483875945315),
	vec3(0.9435104560796476, 0.3052125056977993, 0.1289703285025139),
	vec3(0.9210817486220466, 0.3346915761866369, 0.1989722623509558),
	vec3(0.9451150506269881, 0.2673811063977811, 0.1877894699386632),
	vec3(0.7756987734762599, 0.4271348103152457, 0.464593657559361),
	vec3(0.8093401768056286, 0.3660273094253116, 0.4593391850943057),
	vec3(0.8197877617460405, 0.4082859537433035, 0.4015602142485462),
	vec3(0.7595688249863434, 0.5518590681370708, -0.3442481213075094),
	vec3(0.7496587043181064, 0.5948953478925407, -0.2900195719187088),
	vec3(0.797436366084589, 0.5291350424010078, -0.2900195664935197),
	vec3(0.6757341796533615, 0.7347942563395582, -0.0588278785831562),
	vec3(0.7318556998406828, 0.6789130670468262, -0.05885815154909231),
	vec3(0.6991245624518367, 0.7052361589246849, -0.1177574045301796),
	vec3(0.9076442042210505, 0.4155975006924117, -0.0588278502255242),
	vec3(0.8867608087524729, 0.4469770319100539, -0.1177573819577312),
	vec3(0.8718405365238666, 0.4862404743341545, -0.0588581344681673),
	vec3(-0.1781550487368228, 0.8929267134623428, -0.4134521290245334),
	vec3(-0.1445498294886343, 0.9219187732829787, -0.3594038428609448),
	vec3(-0.1099775904451299, 0.8968005721293695, -0.4285483209957998),
	vec3(-0.001286436483559351, 0.9916476251739598, -0.1289702778473382),
	vec3(0.03368067755619682, 0.9794261947676788, -0.1989722115328181),
	vec3(-0.03776208237662317, 0.9814831435023499, -0.1877894143857069),
	vec3(0.1665252294945457, 0.8697253163623461, -0.4645936095344038),
	vec3(0.09801277655843166, 0.8828369369964673, -0.4593391321300665),
	vec3(0.1349746543648168, 0.9058318147244689, -0.4015601649965711),
	vec3(0.2901294778953876, 0.8929267123409446, 0.3442481262754261),
	vec3(0.3341218078751135, 0.8968005700542033, 0.2900195770163141),
	vec3(0.2568159304451578, 0.9219187723198884, 0.2900195771215756),
	vec3(0.490017511191682, 0.8697253122567585, 0.05882788408054529),
	vec3(0.4195288376018977, 0.9058318116885042, 0.05885816301519117),
	vec3(0.4546780640239181, 0.8828369331269857, 0.1177574099681215),
	vec3(0.1147792143916353, 0.9916476249009109, 0.05882788430686217),
	vec3(0.1510762464914388, 0.9814831430484332, 0.1177574102034637),
	vec3(0.1930286171609152, 0.9794261940476892, 0.05885816315689357),
	vec3(0.6689796061807111, 0.6176759856608219, -0.4134521293357099),
	vec3(0.6160998801350275, 0.6608837068826233, -0.4285483212832452),
	vec3(0.6588335183357897, 0.6608837058578864, -0.3594038431191735),
	vec3(0.3764899616789263, 0.801503641026577, -0.464593609702222),
	vec3(0.4232377815545939, 0.8121694490422056, -0.4015601652395638),
	vec3(0.4396245181150186, 0.7718405564564312, -0.4593391323207334),
	vec3(0.5839165923297567, 0.8015036372745203, -0.1289702781175527),
	vec3(0.6074514764576103, 0.7718405531607269, -0.1877894146271635),
	vec3(0.5484440250674699, 0.812169446782431, -0.1989722118309798),
	vec3(-0.6689796061807111, 0.6176759856608219, 0.4134521293357099),
	vec3(-0.6160998801350275, 0.6608837068826233, 0.4285483212832452),
	vec3(-0.6588335183357897, 0.6608837058578864, 0.3594038431191735),
	vec3(-0.3764899616789263, 0.801503641026577, 0.464593609702222),
	vec3(-0.4232377815545939, 0.8121694490422056, 0.4015601652395638),
	vec3(-0.4396245181150186, 0.7718405564564312, 0.4593391323207334),
	vec3(-0.5839165923297567, 0.8015036372745203, 0.1289702781175527),
	vec3(-0.6074514764576103, 0.7718405531607269, 0.1877894146271635),
	vec3(-0.5484440250674699, 0.812169446782431, 0.1989722118309798),
	vec3(0.1781550487368228, 0.8929267134623428, 0.4134521290245334),
	vec3(0.1445498294886343, 0.9219187732829787, 0.3594038428609448),
	vec3(0.1099775904451299, 0.8968005721293695, 0.4285483209957998),
	vec3(0.001286436483559351, 0.9916476251739598, 0.1289702778473382),
	vec3(-0.03368067755619682, 0.9794261947676788, 0.1989722115328181),
	vec3(0.03776208237662317, 0.9814831435023499, 0.1877894143857069),
	vec3(-0.1665252294945457, 0.8697253163623461, 0.4645936095344038),
	vec3(-0.09801277655843166, 0.8828369369964673, 0.4593391321300665),
	vec3(-0.1349746543648168, 0.9058318147244689, 0.4015601649965711),
	vec3(-0.2901294778953876, 0.8929267123409446, -0.3442481262754261),
	vec3(-0.3341218078751135, 0.8968005700542033, -0.2900195770163141),
	vec3(-0.2568159304451578, 0.9219187723198884, -0.2900195771215756),
	vec3(-0.490017511191682, 0.8697253122567585, -0.05882788408054529),
	vec3(-0.4195288376018977, 0.9058318116885042, -0.05885816301519117),
	vec3(-0.4546780640239181, 0.8828369331269857, -0.1177574099681215),
	vec3(-0.1147792143916353, 0.9916476249009109, -0.05882788430686217),
	vec3(-0.1510762464914388, 0.9814831430484332, -0.1177574102034637),
	vec3(-0.1930286171609152, 0.9794261940476892, -0.05885816315689357),
	vec3(-0.9042766742955582, 0.1064940134168315, -0.4134521996934357),
	vec3(-0.9214651833451599, 0.1474135169288065, -0.3594039105370883),
	vec3(-0.8868929394609479, 0.1725317171549816, -0.4285483875945315),
	vec3(-0.9435104560796476, 0.3052125056977993, -0.1289703285025139),
	vec3(-0.9210817486220466, 0.3346915761866369, -0.1989722623509558),
	vec3(-0.9451150506269881, 0.2673811063977811, -0.1877894699386632),
	vec3(-0.7756987734762599, 0.4271348103152457, -0.464593657559361),
	vec3(-0.8093401768056286, 0.3660273094253116, -0.4593391850943057),
	vec3(-0.8197877617460405, 0.4082859537433035, -0.4015602142485462),
	vec3(-0.7595688249863434, 0.5518590681370708, 0.3442481213075094),
	vec3(-0.7496587043181064, 0.5948953478925407, 0.2900195719187088),
	vec3(-0.797436366084589, 0.5291350424010078, 0.2900195664935197),
	vec3(-0.6757341796533615, 0.7347942563395582, 0.0588278785831562),
	vec3(-0.7318556998406828, 0.6789130670468262, 0.05885815154909231),
	vec3(-0.6991245624518367, 0.7052361589246849, 0.1177574045301796),
	vec3(-0.9076442042210505, 0.4155975006924117, 0.0588278502255242),
	vec3(-0.8867608087524729, 0.4469770319100539, 0.1177573819577312),
	vec3(-0.8718405365238666, 0.4862404743341545, 0.0588581344681673),
	vec3(-0.3807186920986894, 0.8271097932973368, -0.4134521342529267),
	vec3(-0.4381524077616308, 0.7901701051103219, -0.4285483316530683),
	vec3(-0.4249469897014183, 0.8308122109313341, -0.3594038482140828),
	vec3(-0.6459334386864414, 0.6057414800177474, -0.4645936419847113),
	vec3(-0.6416313579155551, 0.6534972164998112, -0.4015601929554768),
	vec3(-0.5982125202640856, 0.6566196139726261, -0.4593391591686151),
	vec3(-0.5818350965581676, 0.8030159315594784, -0.1289702836889595),
	vec3(-0.5463511475406084, 0.8162325387222852, -0.1877894201280614),
	vec3(-0.6029405079938764, 0.7725754320133662, -0.1989722233615716),
	vec3(-0.7941708293811159, -0.4453650567870308, 0.4134521253460856),
	vec3(-0.8189230821249859, -0.3817215273041518, 0.4285483183440342),
	vec3(-0.8321285023351566, -0.4223636347548599, 0.359403833644151),
	vec3(-0.8786170557871984, -0.1103849963445891, 0.4645936093639689),
	vec3(-0.9032067146450726, -0.1515489010709358, 0.4015601588856217),
	vec3(-0.8699154356927352, -0.1795959268396773, 0.4593391315859294),
	vec3(-0.9427154057866085, -0.3076594538506633, 0.1289702452075716),
	vec3(-0.9217768153490562, -0.3392088568868872, 0.1877893875980299),
	vec3(-0.941897569333299, -0.2706271202565351, 0.1989721856583931),
	vec3(-0.7941708293811159, 0.4453650567870308, 0.4134521253460856),
	vec3(-0.8321285023351566, 0.4223636347548599, 0.359403833644151),
	vec3(-0.8189230821249859, 0.3817215273041518, 0.4285483183440342),
	vec3(-0.9427154057866085, 0.3076594538506633, 0.1289702452075716),
	vec3(-0.941897569333299, 0.2706271202565351, 0.1989721856583931),
	vec3(-0.9217768153490562, 0.3392088568868872, 0.1877893875980299),
	vec3(-0.8786170557871984, 0.1103849963445891, 0.4645936093639689),
	vec3(-0.8699154356927352, 0.1795959268396773, 0.4593391315859294),
	vec3(-0.9032067146450726, 0.1515489010709358, 0.4015601588856217),
	vec3(-0.938878681135162, 0, -0.344248198411987),
	vec3(-0.9561573217842743, -0.0406421072341751, -0.2900196460895187),
	vec3(-0.9561573217842743, 0.0406421072341751, -0.2900196460895187),
	vec3(-0.97858165858045, -0.1972744573065407, -0.05882793540781012),
	vec3(-0.9911387835651618, -0.1190782190462656, -0.05885821490446989),
	vec3(-0.9801310584692129, -0.1596129297500483, -0.117757466347687),
	vec3(-0.97858165858045, 0.1972744573065407, -0.05882793540781012),
	vec3(-0.9801310584692129, 0.1596129297500483, -0.117757466347687),
	vec3(-0.9911387835651618, 0.1190782190462656, -0.05885821490446989),
	vec3(-0.3807186920986894, -0.8271097932973368, -0.4134521342529267),
	vec3(-0.4249469897014183, -0.8308122109313341, -0.3594038482140828),
	vec3(-0.4381524077616308, -0.7901701051103219, -0.4285483316530683),
	vec3(-0.5818350965581676, -0.8030159315594784, -0.1289702836889595),
	vec3(-0.6029405079938764, -0.7725754320133662, -0.1989722233615716),
	vec3(-0.5463511475406084, -0.8162325387222852, -0.1877894201280614),
	vec3(-0.6459334386864414, -0.6057414800177474, -0.4645936419847113),
	vec3(-0.5982125202640856, -0.6566196139726261, -0.4593391591686151),
	vec3(-0.6416313579155551, -0.6534972164998112, -0.4015601929554768),
	vec3(-0.7595688249863434, -0.5518590681370708, 0.3442481213075094),
	vec3(-0.797436366084589, -0.5291350424010078, 0.2900195664935197),
	vec3(-0.7496587043181064, -0.5948953478925407, 0.2900195719187088),
	vec3(-0.9076442042210505, -0.4155975006924117, 0.0588278502255242),
	vec3(-0.8718405365238666, -0.4862404743341545, 0.0588581344681673),
	vec3(-0.8867608087524729, -0.4469770319100539, 0.1177573819577312),
	vec3(-0.6757341796533615, -0.7347942563395582, 0.0588278785831562),
	vec3(-0.6991245624518367, -0.7052361589246849, 0.1177574045301796),
	vec3(-0.7318556998406828, -0.6789130670468262, 0.05885815154909231),
	vec3(-0.9042766742955582, -0.1064940134168315, -0.4134521996934357),
	vec3(-0.8868929394609479, -0.1725317171549816, -0.4285483875945315),
	vec3(-0.9214651833451599, -0.1474135169288065, -0.3594039105370883),
	vec3(-0.7756987734762599, -0.4271348103152457, -0.464593657559361),
	vec3(-0.8197877617460405, -0.4082859537433035, -0.4015602142485462),
	vec3(-0.8093401768056286, -0.3660273094253116, -0.4593391850943057),
	vec3(-0.9435104560796476, -0.3052125056977993, -0.1289703285025139),
	vec3(-0.9451150506269881, -0.2673811063977811, -0.1877894699386632),
	vec3(-0.9210817486220466, -0.3346915761866369, -0.1989722623509558),
	vec3(0.1781550487368228, -0.8929267134623428, 0.4134521290245334),
	vec3(0.1099775904451299, -0.8968005721293695, 0.4285483209957998),
	vec3(0.1445498294886343, -0.9219187732829787, 0.3594038428609448),
	vec3(-0.1665252294945457, -0.8697253163623461, 0.4645936095344038),
	vec3(-0.1349746543648168, -0.9058318147244689, 0.4015601649965711),
	vec3(-0.09801277655843166, -0.8828369369964673, 0.4593391321300665),
	vec3(0.001286436483559351, -0.9916476251739598, 0.1289702778473382),
	vec3(0.03776208237662317, -0.9814831435023499, 0.1877894143857069),
	vec3(-0.03368067755619682, -0.9794261947676788, 0.1989722115328181),
	vec3(-0.6689796061807111, -0.6176759856608219, 0.4134521293357099),
	vec3(-0.6588335183357897, -0.6608837058578864, 0.3594038431191735),
	vec3(-0.6160998801350275, -0.6608837068826233, 0.4285483212832452),
	vec3(-0.5839165923297567, -0.8015036372745203, 0.1289702781175527),
	vec3(-0.5484440250674699, -0.812169446782431, 0.1989722118309798),
	vec3(-0.6074514764576103, -0.7718405531607269, 0.1877894146271635),
	vec3(-0.3764899616789263, -0.801503641026577, 0.464593609702222),
	vec3(-0.4396245181150186, -0.7718405564564312, 0.4593391323207334),
	vec3(-0.4232377815545939, -0.8121694490422056, 0.4015601652395638),
	vec3(-0.2901294778953876, -0.8929267123409446, -0.3442481262754261),
	vec3(-0.2568159304451578, -0.9219187723198884, -0.2900195771215756),
	vec3(-0.3341218078751135, -0.8968005700542033, -0.2900195770163141),
	vec3(-0.1147792143916353, -0.9916476249009109, -0.05882788430686217),
	vec3(-0.1930286171609152, -0.9794261940476892, -0.05885816315689357),
	vec3(-0.1510762464914388, -0.9814831430484332, -0.1177574102034637),
	vec3(-0.490017511191682, -0.8697253122567585, -0.05882788408054529),
	vec3(-0.4546780640239181, -0.8828369331269857, -0.1177574099681215),
	vec3(-0.4195288376018977, -0.9058318116885042, -0.05885816301519117),
	vec3(0.6689796061807111, -0.6176759856608219, -0.4134521293357099),
	vec3(0.6588335183357897, -0.6608837058578864, -0.3594038431191735),
	vec3(0.6160998801350275, -0.6608837068826233, -0.4285483212832452),
	vec3(0.5839165923297567, -0.8015036372745203, -0.1289702781175527),
	vec3(0.5484440250674699, -0.812169446782431, -0.1989722118309798),
	vec3(0.6074514764576103, -0.7718405531607269, -0.1877894146271635),
	vec3(0.3764899616789263, -0.801503641026577, -0.464593609702222),
	vec3(0.4396245181150186, -0.7718405564564312, -0.4593391323207334),
	vec3(0.4232377815545939, -0.8121694490422056, -0.4015601652395638),
	vec3(0.2901294778953876, -0.8929267123409446, 0.3442481262754261),
	vec3(0.2568159304451578, -0.9219187723198884, 0.2900195771215756),
	vec3(0.3341218078751135, -0.8968005700542033, 0.2900195770163141),
	vec3(0.1147792143916353, -0.9916476249009109, 0.05882788430686217),
	vec3(0.1930286171609152, -0.9794261940476892, 0.05885816315689357),
	vec3(0.1510762464914388, -0.9814831430484332, 0.1177574102034637),
	vec3(0.490017511191682, -0.8697253122567585, 0.05882788408054529),
	vec3(0.4546780640239181, -0.8828369331269857, 0.1177574099681215),
	vec3(0.4195288376018977, -0.9058318116885042, 0.05885816301519117),
	vec3(-0.1781550487368228, -0.8929267134623428, -0.4134521290245334),
	vec3(-0.1099775904451299, -0.8968005721293695, -0.4285483209957998),
	vec3(-0.1445498294886343, -0.9219187732829787, -0.3594038428609448),
	vec3(0.1665252294945457, -0.8697253163623461, -0.4645936095344038),
	vec3(0.1349746543648168, -0.9058318147244689, -0.4015601649965711),
	vec3(0.09801277655843166, -0.8828369369964673, -0.4593391321300665),
	vec3(-0.001286436483559351, -0.9916476251739598, -0.1289702778473382),
	vec3(-0.03776208237662317, -0.9814831435023499, -0.1877894143857069),
	vec3(0.03368067755619682, -0.9794261947676788, -0.1989722115328181),
	vec3(0.1119744304475942, 0, -0.9937110882575162),
	vec3(0.1682051611388171, 0.04064210638514562, -0.9849138251414907),
	vec3(0.1682051611388171, -0.04064210638514562, -0.9849138251414907),
	vec3(0.3850177633905594, 0.1972744537967651, -0.9015786775167873),
	vec3(0.390606397936309, 0.1190782168822028, -0.9128236522764825),
	vec3(0.333002506047983, 0.1596129267195899, -0.9293185915442399),
	vec3(0.3850177633905594, -0.1972744537967651, -0.9015786775167873),
	vec3(0.333002506047983, -0.1596129267195899, -0.9293185915442399),
	vec3(0.390606397936309, -0.1190782168822028, -0.9128236522764825),
	vec3(0.7249668243135851, 0.4453650553537312, -0.5254265611048261),
	vec3(0.7495388138363048, 0.3817215259075892, -0.5408144258538663),
	vec3(0.6935997539481926, 0.4223636321662246, -0.5835480644697237),
	vec3(0.8084746589339488, 0.1103849953834097, -0.5780863937646691),
	vec3(0.7630926602721795, 0.1515488991492229, -0.6282694668734006),
	vec3(0.799883428322876, 0.1795959257928088, -0.5726533022109159),
	vec3(0.5369496714047589, 0.3076594490635966, -0.7855130258501163),
	vec3(0.5801950846845989, 0.339208852338781, -0.7404802618590439),
	vec3(0.5991955578803346, 0.2706271159500195, -0.7534757113066416),
	vec3(0.7249668243135851, -0.4453650553537312, -0.5254265611048261),
	vec3(0.6935997539481926, -0.4223636321662246, -0.5835480644697237),
	vec3(0.7495388138363048, -0.3817215259075892, -0.5408144258538663),
	vec3(0.5369496714047589, -0.3076594490635966, -0.7855130258501163),
	vec3(0.5991955578803346, -0.2706271159500195, -0.7534757113066416),
	vec3(0.5801950846845989, -0.339208852338781, -0.7404802618590439),
	vec3(0.8084746589339488, -0.1103849953834097, -0.5780863937646691),
	vec3(0.799883428322876, -0.1795959257928088, -0.5726533022109159),
	vec3(0.7630926602721795, -0.1515488991492229, -0.6282694668734006),
	vec3(-0.1995402625882863, 0.8271097956423047, -0.525426559624409),
	vec3(-0.1314185086161542, 0.8308122140491804, -0.5408144234206447),
	vec3(-0.1873575673738617, 0.7901701083008331, -0.5835480630553053),
	vec3(0.1448500371759792, 0.8030159360349073, -0.5780863890493347),
	vec3(0.09167703080615207, 0.7725754359384491, -0.6282694627363987),
	vec3(0.07637169637537679, 0.8162325431460495, -0.5726532978182169),
	vec3(-0.1266749461320592, 0.605741484450085, -0.785513024741568),
	vec3(-0.143316643557175, 0.6566196183989075, -0.7404802606505989),
	vec3(-0.07222006902109285, 0.6534972204115205, -0.7534757093264554),
	vec3(0.6475943939798771, 0.5518590680207195, -0.5254265599768804),
	vec3(0.6160257834455692, 0.5291350412433695, -0.583548063366378),
	vec3(0.5946589635521519, 0.5948953489156701, -0.540814423721838),
	vec3(0.4585280883117704, 0.4155974975135082, -0.7855130249013462),
	vec3(0.4425432834363517, 0.4862404729258598, -0.7534757094785531),
	vec3(0.5018969206093552, 0.4469770289192903, -0.7404802608451697),
	vec3(0.3548147703953562, 0.734794260598439, -0.5780863891330463),
	vec3(0.417983439082012, 0.7052361625664525, -0.5726532979576023),
	vec3(0.3799401600931812, 0.6789130701408901, -0.6282694628423685),
	vec3(0.03460200149720084, 0.1064940134515928, -0.9937110880891687),
	vec3(0.01332531339781465, 0.1725317180438165, -0.9849138248048399),
	vec3(0.09063119189928517, 0.1474135161732432, -0.9849138248112653),
	vec3(-0.06864212016938311, 0.427134814018541, -0.901578676540211),
	vec3(0.007453901772566477, 0.4082859562230665, -0.9128236507121084),
	vec3(-0.04889747850771557, 0.3660273125454728, -0.9293185907245838),
	vec3(0.3065961809171641, 0.3052125025676215, -0.9015786766130947),
	vec3(0.2547043427467997, 0.2673811037187092, -0.9293185907750288),
	vec3(0.233954124846683, 0.3346915745693134, -0.9128236507560136),
	vec3(0.03460200149720084, -0.1064940134515928, -0.9937110880891687),
	vec3(0.09063119189928517, -0.1474135161732432, -0.9849138248112653),
	vec3(0.01332531339781465, -0.1725317180438165, -0.9849138248048399),
	vec3(0.3065961809171641, -0.3052125025676215, -0.9015786766130947),
	vec3(0.233954124846683, -0.3346915745693134, -0.9128236507560136),
	vec3(0.2547043427467997, -0.2673811037187092, -0.9293185907750288),
	vec3(-0.06864212016938311, -0.427134814018541, -0.901578676540211),
	vec3(-0.04889747850771557, -0.3660273125454728, -0.9293185907245838),
	vec3(0.007453901772566477, -0.4082859562230665, -0.9128236507121084),
	vec3(0.6475943939798771, -0.5518590680207195, -0.5254265599768804),
	vec3(0.5946589635521519, -0.5948953489156701, -0.540814423721838),
	vec3(0.6160257834455692, -0.5291350412433695, -0.583548063366378),
	vec3(0.3548147703953562, -0.734794260598439, -0.5780863891330463),
	vec3(0.3799401600931812, -0.6789130701408901, -0.6282694628423685),
	vec3(0.417983439082012, -0.7052361625664525, -0.5726532979576023),
	vec3(0.4585280883117704, -0.4155974975135082, -0.7855130249013462),
	vec3(0.5018969206093552, -0.4469770289192903, -0.7404802608451697),
	vec3(0.4425432834363517, -0.4862404729258598, -0.7534757094785531),
	vec3(-0.1995402625882863, -0.8271097956423047, -0.525426559624409),
	vec3(-0.1873575673738617, -0.7901701083008331, -0.5835480630553053),
	vec3(-0.1314185086161542, -0.8308122140491804, -0.5408144234206447),
	vec3(-0.1266749461320592, -0.605741484450085, -0.785513024741568),
	vec3(-0.07222006902109285, -0.6534972204115205, -0.7534757093264554),
	vec3(-0.143316643557175, -0.6566196183989075, -0.7404802606505989),
	vec3(0.1448500371759792, -0.8030159360349073, -0.5780863890493347),
	vec3(0.07637169637537679, -0.8162325431460495, -0.5726532978182169),
	vec3(0.09167703080615207, -0.7725754359384491, -0.6282694627363987),
	vec3(-0.848289452184969, 0.06581691856236001, -0.5254266252700571),
	vec3(-0.8307598820061816, 0.1317486662863841, -0.5408144851803013),
	vec3(-0.8093930606468889, 0.06598835893498346, -0.583548121290549),
	vec3(-0.7189523798619085, 0.3859061430949148, -0.5780864331676577),
	vec3(-0.7064331049583341, 0.3259289771194073, -0.6282695043473179),
	vec3(-0.7526830895261419, 0.3248635273111496, -0.5726533465931549),
	vec3(-0.6152390575570327, 0.06670938159887017, -0.7855130555649793),
	vec3(-0.6687696039323282, 0.06660439503273816, -0.7404802977922638),
	vec3(-0.6438299789792864, 0.1332563809506197, -0.7534757428766206),
	vec3(-0.3247314778202054, 0.7864327006042664, -0.5254265645482588),
	vec3(-0.312874881421455, 0.749387057039492, -0.5835480677006817),
	vec3(-0.3820193572266981, 0.7493870558307721, -0.540814433292407),
	vec3(-0.2535637261648291, 0.5645128161113286, -0.7855130280392967),
	vec3(-0.3256887600479907, 0.5711402419378897, -0.7534757166740885),
	vec3(-0.2700057274014135, 0.61545583545293, -0.7404802642727014),
	vec3(-0.5891870476937116, 0.5645128123355965, -0.5780864187463012),
	vec3(-0.5415554366997106, 0.6154558319801341, -0.5726533225806226),
	vec3(-0.5282767073251864, 0.571140239647055, -0.6282694860914094),
	vec3(-0.09058921294853754, 0.06581691941908625, -0.9937110886045029),
	vec3(-0.159969655135884, 0.06598835973848186, -0.9849138265933375),
	vec3(-0.1121919999838403, 0.1317486679452729, -0.9849138254864089),
	vec3(-0.4274408998687668, 0.06670938210107737, -0.9015786906638108),
	vec3(-0.3859996104400737, 0.1332563820105958, -0.9128236617187121),
	vec3(-0.3632227867084265, 0.06660439559154094, -0.9293186007519973),
	vec3(-0.1955308999941006, 0.3859061470472636, -0.9015786781078136),
	vec3(-0.1755865620349274, 0.3248635308578524, -0.9293185920615835),
	vec3(-0.2460147886875718, 0.325928980242859, -0.9128236541549849),
	vec3(-0.3247314778202054, -0.7864327006042664, -0.5254265645482588),
	vec3(-0.3820193572266981, -0.7493870558307721, -0.540814433292407),
	vec3(-0.312874881421455, -0.749387057039492, -0.5835480677006817),
	vec3(-0.5891870476937116, -0.5645128123355965, -0.5780864187463012),
	vec3(-0.5282767073251864, -0.571140239647055, -0.6282694860914094),
	vec3(-0.5415554366997106, -0.6154558319801341, -0.5726533225806226),
	vec3(-0.2535637261648291, -0.5645128161113286, -0.7855130280392967),
	vec3(-0.2700057274014135, -0.61545583545293, -0.7404802642727014),
	vec3(-0.3256887600479907, -0.5711402419378897, -0.7534757166740885),
	vec3(-0.848289452184969, -0.06581691856236001, -0.5254266252700571),
	vec3(-0.8093930606468889, -0.06598835893498346, -0.583548121290549),
	vec3(-0.8307598820061816, -0.1317486662863841, -0.5408144851803013),
	vec3(-0.6152390575570327, -0.06670938159887017, -0.7855130555649793),
	vec3(-0.6438299789792864, -0.1332563809506197, -0.7534757428766206),
	vec3(-0.6687696039323282, -0.06660439503273816, -0.7404802977922638),
	vec3(-0.7189523798619085, -0.3859061430949148, -0.5780864331676577),
	vec3(-0.7526830895261419, -0.3248635273111496, -0.5726533465931549),
	vec3(-0.7064331049583341, -0.3259289771194073, -0.6282695043473179),
	vec3(-0.09058921294853754, -0.06581691941908625, -0.9937110886045029),
	vec3(-0.1121919999838403, -0.1317486679452729, -0.9849138254864089),
	vec3(-0.159969655135884, -0.06598835973848186, -0.9849138265933375),
	vec3(-0.1955308999941006, -0.3859061470472636, -0.9015786781078136),
	vec3(-0.2460147886875718, -0.325928980242859, -0.9128236541549849),
	vec3(-0.1755865620349274, -0.3248635308578524, -0.9293185920615835),
	vec3(-0.4274408998687668, -0.06670938210107737, -0.9015786906638108),
	vec3(-0.3632227867084265, -0.06660439559154094, -0.9293186007519973),
	vec3(-0.3859996104400737, -0.1332563820105958, -0.9128236617187121)
    };

    const index_t SPHERE_MODEL_TRIANGLES[SPHERE_MODEL_NB_TRIANGLES][3] = {
	{1603, 1604, 1602},
	{1606, 1607, 1605},
	{1609, 1610, 1608},
	{1612, 1613, 1611},
	{1615, 1616, 1614},
	{1618, 1619, 1617},
	{1621, 1622, 1620},
	{1624, 1625, 1623},
	{1627, 1628, 1626},
	{1630, 1631, 1629},
	{1633, 1634, 1632},
	{1636, 1637, 1635},
	{1639, 1640, 1638},
	{1642, 1643, 1641},
	{1645, 1646, 1644},
	{1648, 1649, 1647},
	{1651, 1652, 1650},
	{1654, 1655, 1653},
	{1657, 1658, 1656},
	{1660, 1661, 1659},
	{1663, 1664, 1662},
	{1666, 1667, 1665},
	{1669, 1670, 1668},
	{1672, 1673, 1671},
	{1675, 1676, 1674},
	{1678, 1679, 1677},
	{1681, 1682, 1680},
	{1684, 1685, 1683},
	{1687, 1688, 1686},
	{1690, 1691, 1689},
	{1693, 1694, 1692},
	{1696, 1697, 1695},
	{1699, 1700, 1698},
	{1702, 1703, 1701},
	{1705, 1706, 1704},
	{1708, 1709, 1707},
	{1711, 1712, 1710},
	{1714, 1715, 1713},
	{1717, 1718, 1716},
	{1720, 1721, 1719},
	{1723, 1724, 1722},
	{1726, 1727, 1725},
	{1729, 1730, 1728},
	{1732, 1733, 1731},
	{1735, 1736, 1734},
	{1738, 1739, 1737},
	{1741, 1742, 1740},
	{1744, 1745, 1743},
	{1747, 1748, 1746},
	{1750, 1751, 1749},
	{1753, 1754, 1752},
	{1756, 1757, 1755},
	{1759, 1760, 1758},
	{1762, 1763, 1761},
	{1765, 1766, 1764},
	{1768, 1769, 1767},
	{1771, 1772, 1770},
	{1774, 1775, 1773},
	{1777, 1778, 1776},
	{1780, 1781, 1779},
	{1783, 1784, 1782},
	{1786, 1787, 1785},
	{1789, 1790, 1788},
	{1792, 1793, 1791},
	{1795, 1796, 1794},
	{1798, 1799, 1797},
	{1801, 1802, 1800},
	{1804, 1805, 1803},
	{1807, 1808, 1806},
	{1810, 1811, 1809},
	{1813, 1814, 1812},
	{1816, 1817, 1815},
	{1819, 1820, 1818},
	{1822, 1823, 1821},
	{1825, 1826, 1824},
	{1828, 1829, 1827},
	{1831, 1832, 1830},
	{1834, 1835, 1833},
	{1837, 1838, 1836},
	{1840, 1841, 1839},
	{1843, 1844, 1842},
	{1846, 1847, 1845},
	{1849, 1850, 1848},
	{1852, 1853, 1851},
	{1855, 1856, 1854},
	{1858, 1859, 1857},
	{1861, 1862, 1860},
	{1864, 1865, 1863},
	{1867, 1868, 1866},
	{1870, 1871, 1869},
	{1873, 1874, 1872},
	{1876, 1877, 1875},
	{1879, 1880, 1878},
	{1882, 1883, 1881},
	{1885, 1886, 1884},
	{1888, 1889, 1887},
	{1891, 1892, 1890},
	{1894, 1895, 1893},
	{1897, 1898, 1896},
	{1900, 1901, 1899},
	{1903, 1904, 1902},
	{1906, 1907, 1905},
	{1909, 1910, 1908},
	{1912, 1913, 1911},
	{1915, 1916, 1914},
	{1918, 1919, 1917},
	{1921, 1922, 1920},
	{1924, 1925, 1923},
	{1927, 1928, 1926},
	{1930, 1931, 1929},
	{1933, 1934, 1932},
	{1936, 1937, 1935},
	{1939, 1940, 1938},
	{1942, 1943, 1941},
	{1945, 1946, 1944},
	{1948, 1949, 1947},
	{1951, 1952, 1950},
	{1954, 1955, 1953},
	{1957, 1958, 1956},
	{1960, 1961, 1959},
	{1963, 1964, 1962},
	{1966, 1967, 1965},
	{1969, 1970, 1968},
	{1972, 1973, 1971},
	{1975, 1976, 1974},
	{1978, 1979, 1977},
	{1981, 1982, 1980},
	{1984, 1985, 1983},
	{1987, 1988, 1986},
	{1990, 1991, 1989},
	{1993, 1994, 1992},
	{1996, 1997, 1995},
	{1999, 2000, 1998},
	{2002, 2003, 2001},
	{2005, 2006, 2004},
	{2008, 2009, 2007},
	{2011, 2012, 2010},
	{2014, 2015, 2013},
	{2017, 2018, 2016},
	{2020, 2021, 2019},
	{2023, 2024, 2022},
	{2026, 2027, 2025},
	{2029, 2030, 2028},
	{2032, 2033, 2031},
	{2035, 2036, 2034},
	{2038, 2039, 2037},
	{2041, 2042, 2040},
	{2044, 2045, 2043},
	{2047, 2048, 2046},
	{2050, 2051, 2049},
	{2053, 2054, 2052},
	{2056, 2057, 2055},
	{2059, 2060, 2058},
	{2062, 2063, 2061},
	{2065, 2066, 2064},
	{2068, 2069, 2067},
	{2071, 2072, 2070},
	{2074, 2075, 2073},
	{2077, 2078, 2076},
	{2080, 2081, 2079},
	{2083, 2084, 2082},
	{2086, 2087, 2085},
	{2089, 2090, 2088},
	{2092, 2093, 2091},
	{2095, 2096, 2094},
	{2098, 2099, 2097},
	{2101, 2102, 2100},
	{2104, 2105, 2103},
	{2107, 2108, 2106},
	{2110, 2111, 2109},
	{2113, 2114, 2112},
	{2116, 2117, 2115},
	{2119, 2120, 2118},
	{2122, 2123, 2121},
	{2125, 2126, 2124},
	{2128, 2129, 2127},
	{2131, 2132, 2130},
	{2134, 2135, 2133},
	{2137, 2138, 2136},
	{2140, 2141, 2139},
	{2143, 2144, 2142},
	{2146, 2147, 2145},
	{2149, 2150, 2148},
	{2152, 2153, 2151},
	{2155, 2156, 2154},
	{2158, 2159, 2157},
	{2161, 2162, 2160},
	{2164, 2165, 2163},
	{2167, 2168, 2166},
	{2170, 2171, 2169},
	{2173, 2174, 2172},
	{2176, 2177, 2175},
	{2179, 2180, 2178},
	{2182, 2183, 2181},
	{2185, 2186, 2184},
	{2188, 2189, 2187},
	{2191, 2192, 2190},
	{2194, 2195, 2193},
	{2197, 2198, 2196},
	{2200, 2201, 2199},
	{2203, 2204, 2202},
	{2206, 2207, 2205},
	{2209, 2210, 2208},
	{2212, 2213, 2211},
	{2215, 2216, 2214},
	{2218, 2219, 2217},
	{2221, 2222, 2220},
	{2224, 2225, 2223},
	{2227, 2228, 2226},
	{2230, 2231, 2229},
	{2233, 2234, 2232},
	{2236, 2237, 2235},
	{2239, 2240, 2238},
	{2242, 2243, 2241},
	{2245, 2246, 2244},
	{2248, 2249, 2247},
	{2251, 2252, 2250},
	{2254, 2255, 2253},
	{2257, 2258, 2256},
	{2260, 2261, 2259},
	{2263, 2264, 2262},
	{2266, 2267, 2265},
	{2269, 2270, 2268},
	{2272, 2273, 2271},
	{2275, 2276, 2274},
	{2278, 2279, 2277},
	{2281, 2282, 2280},
	{2284, 2285, 2283},
	{2287, 2288, 2286},
	{2290, 2291, 2289},
	{2293, 2294, 2292},
	{2296, 2297, 2295},
	{2299, 2300, 2298},
	{2302, 2303, 2301},
	{2305, 2306, 2304},
	{2308, 2309, 2307},
	{2311, 2312, 2310},
	{2314, 2315, 2313},
	{2317, 2318, 2316},
	{2320, 2321, 2319},
	{2323, 2324, 2322},
	{2326, 2327, 2325},
	{2329, 2330, 2328},
	{2332, 2333, 2331},
	{2335, 2336, 2334},
	{2338, 2339, 2337},
	{2341, 2342, 2340},
	{2344, 2345, 2343},
	{2347, 2348, 2346},
	{2350, 2351, 2349},
	{2353, 2354, 2352},
	{2356, 2357, 2355},
	{2359, 2360, 2358},
	{2362, 2363, 2361},
	{2365, 2366, 2364},
	{2368, 2369, 2367},
	{2371, 2372, 2370},
	{2374, 2375, 2373},
	{2377, 2378, 2376},
	{2380, 2381, 2379},
	{2383, 2384, 2382},
	{2386, 2387, 2385},
	{2389, 2390, 2388},
	{2392, 2393, 2391},
	{2395, 2396, 2394},
	{2398, 2399, 2397},
	{2401, 2402, 2400},
	{2404, 2405, 2403},
	{2407, 2408, 2406},
	{2410, 2411, 2409},
	{2413, 2414, 2412},
	{2416, 2417, 2415},
	{2419, 2420, 2418},
	{2422, 2423, 2421},
	{2425, 2426, 2424},
	{2428, 2429, 2427},
	{2431, 2432, 2430},
	{2434, 2435, 2433},
	{2437, 2438, 2436},
	{2440, 2441, 2439},
	{2443, 2444, 2442},
	{2446, 2447, 2445},
	{2449, 2450, 2448},
	{2452, 2453, 2451},
	{2455, 2456, 2454},
	{2458, 2459, 2457},
	{2461, 2462, 2460},
	{2464, 2465, 2463},
	{2467, 2468, 2466},
	{2470, 2471, 2469},
	{2473, 2474, 2472},
	{2476, 2477, 2475},
	{2479, 2480, 2478},
	{2482, 2483, 2481},
	{2485, 2486, 2484},
	{2488, 2489, 2487},
	{2491, 2492, 2490},
	{2494, 2495, 2493},
	{2497, 2498, 2496},
	{2500, 2501, 2499},
	{2503, 2504, 2502},
	{2506, 2507, 2505},
	{2509, 2510, 2508},
	{2512, 2513, 2511},
	{2515, 2516, 2514},
	{2518, 2519, 2517},
	{2521, 2522, 2520},
	{2524, 2525, 2523},
	{2527, 2528, 2526},
	{2530, 2531, 2529},
	{2533, 2534, 2532},
	{2536, 2537, 2535},
	{2539, 2540, 2538},
	{2542, 2543, 2541},
	{2545, 2546, 2544},
	{2548, 2549, 2547},
	{2551, 2552, 2550},
	{2554, 2555, 2553},
	{2557, 2558, 2556},
	{2560, 2561, 2559},
	{1363, 1602, 882},
	{1364, 1603, 883},
	{1362, 1604, 884},
	{1366, 1605, 885},
	{1367, 1606, 886},
	{1365, 1607, 887},
	{1369, 1608, 888},
	{1370, 1609, 889},
	{1368, 1610, 890},
	{1372, 1611, 891},
	{1373, 1612, 892},
	{1371, 1613, 893},
	{1375, 1614, 894},
	{1376, 1615, 895},
	{1374, 1616, 896},
	{1378, 1617, 897},
	{1379, 1618, 898},
	{1377, 1619, 899},
	{1381, 1620, 900},
	{1382, 1621, 901},
	{1380, 1622, 902},
	{1384, 1623, 903},
	{1385, 1624, 904},
	{1383, 1625, 905},
	{1387, 1626, 906},
	{1388, 1627, 907},
	{1386, 1628, 908},
	{1390, 1629, 909},
	{1391, 1630, 910},
	{1389, 1631, 911},
	{1393, 1632, 912},
	{1394, 1633, 913},
	{1392, 1634, 914},
	{1396, 1635, 915},
	{1397, 1636, 916},
	{1395, 1637, 917},
	{1399, 1638, 918},
	{1400, 1639, 919},
	{1398, 1640, 920},
	{1402, 1641, 921},
	{1403, 1642, 922},
	{1401, 1643, 923},
	{1405, 1644, 924},
	{1406, 1645, 925},
	{1404, 1646, 926},
	{1408, 1647, 927},
	{1409, 1648, 928},
	{1407, 1649, 929},
	{1411, 1650, 930},
	{1412, 1651, 931},
	{1410, 1652, 932},
	{1414, 1653, 933},
	{1415, 1654, 934},
	{1413, 1655, 935},
	{1417, 1656, 936},
	{1418, 1657, 937},
	{1416, 1658, 938},
	{1420, 1659, 939},
	{1421, 1660, 940},
	{1419, 1661, 941},
	{1423, 1662, 942},
	{1424, 1663, 943},
	{1422, 1664, 944},
	{1426, 1665, 945},
	{1427, 1666, 946},
	{1425, 1667, 947},
	{1429, 1668, 948},
	{1430, 1669, 949},
	{1428, 1670, 950},
	{1432, 1671, 951},
	{1433, 1672, 952},
	{1431, 1673, 953},
	{1435, 1674, 954},
	{1436, 1675, 955},
	{1434, 1676, 956},
	{1438, 1677, 957},
	{1439, 1678, 958},
	{1437, 1679, 959},
	{1441, 1680, 960},
	{1442, 1681, 961},
	{1440, 1682, 962},
	{1444, 1683, 963},
	{1445, 1684, 964},
	{1443, 1685, 965},
	{1447, 1686, 966},
	{1448, 1687, 967},
	{1446, 1688, 968},
	{1450, 1689, 969},
	{1451, 1690, 970},
	{1449, 1691, 971},
	{1453, 1692, 972},
	{1454, 1693, 973},
	{1452, 1694, 974},
	{1456, 1695, 975},
	{1457, 1696, 976},
	{1455, 1697, 977},
	{1459, 1698, 978},
	{1460, 1699, 979},
	{1458, 1700, 980},
	{1462, 1701, 981},
	{1463, 1702, 982},
	{1461, 1703, 983},
	{1465, 1704, 984},
	{1466, 1705, 985},
	{1464, 1706, 986},
	{1468, 1707, 987},
	{1469, 1708, 988},
	{1467, 1709, 989},
	{1471, 1710, 990},
	{1472, 1711, 991},
	{1470, 1712, 992},
	{1474, 1713, 993},
	{1475, 1714, 994},
	{1473, 1715, 995},
	{1477, 1716, 996},
	{1478, 1717, 997},
	{1476, 1718, 998},
	{1480, 1719, 999},
	{1481, 1720, 1000},
	{1479, 1721, 1001},
	{1483, 1722, 1002},
	{1484, 1723, 1003},
	{1482, 1724, 1004},
	{1486, 1725, 1005},
	{1487, 1726, 1006},
	{1485, 1727, 1007},
	{1489, 1728, 1008},
	{1490, 1729, 1009},
	{1488, 1730, 1010},
	{1492, 1731, 1011},
	{1493, 1732, 1012},
	{1491, 1733, 1013},
	{1495, 1734, 1014},
	{1496, 1735, 1015},
	{1494, 1736, 1016},
	{1498, 1737, 1017},
	{1499, 1738, 1018},
	{1497, 1739, 1019},
	{1501, 1740, 1020},
	{1502, 1741, 1021},
	{1500, 1742, 1022},
	{1504, 1743, 1023},
	{1505, 1744, 1024},
	{1503, 1745, 1025},
	{1507, 1746, 1026},
	{1508, 1747, 1027},
	{1506, 1748, 1028},
	{1510, 1749, 1029},
	{1511, 1750, 1030},
	{1509, 1751, 1031},
	{1513, 1752, 1032},
	{1514, 1753, 1033},
	{1512, 1754, 1034},
	{1516, 1755, 1035},
	{1517, 1756, 1036},
	{1515, 1757, 1037},
	{1519, 1758, 1038},
	{1520, 1759, 1039},
	{1518, 1760, 1040},
	{1522, 1761, 1041},
	{1523, 1762, 1042},
	{1521, 1763, 1043},
	{1525, 1764, 1044},
	{1526, 1765, 1045},
	{1524, 1766, 1046},
	{1528, 1767, 1047},
	{1529, 1768, 1048},
	{1527, 1769, 1049},
	{1531, 1770, 1050},
	{1532, 1771, 1051},
	{1530, 1772, 1052},
	{1534, 1773, 1053},
	{1535, 1774, 1054},
	{1533, 1775, 1055},
	{1537, 1776, 1056},
	{1538, 1777, 1057},
	{1536, 1778, 1058},
	{1540, 1779, 1059},
	{1541, 1780, 1060},
	{1539, 1781, 1061},
	{1543, 1782, 1062},
	{1544, 1783, 1063},
	{1542, 1784, 1064},
	{1546, 1785, 1065},
	{1547, 1786, 1066},
	{1545, 1787, 1067},
	{1549, 1788, 1068},
	{1550, 1789, 1069},
	{1548, 1790, 1070},
	{1552, 1791, 1071},
	{1553, 1792, 1072},
	{1551, 1793, 1073},
	{1555, 1794, 1074},
	{1556, 1795, 1075},
	{1554, 1796, 1076},
	{1558, 1797, 1077},
	{1559, 1798, 1078},
	{1557, 1799, 1079},
	{1561, 1800, 1080},
	{1562, 1801, 1081},
	{1560, 1802, 1082},
	{1564, 1803, 1083},
	{1565, 1804, 1084},
	{1563, 1805, 1085},
	{1567, 1806, 1086},
	{1568, 1807, 1087},
	{1566, 1808, 1088},
	{1570, 1809, 1089},
	{1571, 1810, 1090},
	{1569, 1811, 1091},
	{1573, 1812, 1092},
	{1574, 1813, 1093},
	{1572, 1814, 1094},
	{1576, 1815, 1095},
	{1577, 1816, 1096},
	{1575, 1817, 1097},
	{1579, 1818, 1098},
	{1580, 1819, 1099},
	{1578, 1820, 1100},
	{1582, 1821, 1101},
	{1583, 1822, 1102},
	{1581, 1823, 1103},
	{1585, 1824, 1104},
	{1586, 1825, 1105},
	{1584, 1826, 1106},
	{1588, 1827, 1107},
	{1589, 1828, 1108},
	{1587, 1829, 1109},
	{1591, 1830, 1110},
	{1592, 1831, 1111},
	{1590, 1832, 1112},
	{1594, 1833, 1113},
	{1595, 1834, 1114},
	{1593, 1835, 1115},
	{1597, 1836, 1116},
	{1598, 1837, 1117},
	{1596, 1838, 1118},
	{1600, 1839, 1119},
	{1601, 1840, 1120},
	{1599, 1841, 1121},
	{1303, 1842, 702},
	{882, 1843, 823},
	{1182, 1844, 1362},
	{1304, 1845, 703},
	{883, 1846, 824},
	{1183, 1847, 1363},
	{1302, 1848, 704},
	{884, 1849, 822},
	{1184, 1850, 1364},
	{1306, 1851, 705},
	{885, 1852, 826},
	{1185, 1853, 1365},
	{1307, 1854, 706},
	{886, 1855, 827},
	{1186, 1856, 1366},
	{1305, 1857, 707},
	{887, 1858, 825},
	{1187, 1859, 1367},
	{1309, 1860, 708},
	{888, 1861, 829},
	{1188, 1862, 1368},
	{1310, 1863, 709},
	{889, 1864, 830},
	{1189, 1865, 1369},
	{1308, 1866, 710},
	{890, 1867, 828},
	{1190, 1868, 1370},
	{1312, 1869, 711},
	{891, 1870, 832},
	{1191, 1871, 1371},
	{1313, 1872, 712},
	{892, 1873, 833},
	{1192, 1874, 1372},
	{1311, 1875, 713},
	{893, 1876, 831},
	{1193, 1877, 1373},
	{1315, 1878, 714},
	{894, 1879, 835},
	{1194, 1880, 1374},
	{1316, 1881, 715},
	{895, 1882, 836},
	{1195, 1883, 1375},
	{1314, 1884, 716},
	{896, 1885, 834},
	{1196, 1886, 1376},
	{1318, 1887, 717},
	{897, 1888, 838},
	{1197, 1889, 1377},
	{1319, 1890, 718},
	{898, 1891, 839},
	{1198, 1892, 1378},
	{1317, 1893, 719},
	{899, 1894, 837},
	{1199, 1895, 1379},
	{1321, 1896, 720},
	{900, 1897, 841},
	{1200, 1898, 1380},
	{1322, 1899, 721},
	{901, 1900, 842},
	{1201, 1901, 1381},
	{1320, 1902, 722},
	{902, 1903, 840},
	{1202, 1904, 1382},
	{1324, 1905, 723},
	{903, 1906, 844},
	{1203, 1907, 1383},
	{1325, 1908, 724},
	{904, 1909, 845},
	{1204, 1910, 1384},
	{1323, 1911, 725},
	{905, 1912, 843},
	{1205, 1913, 1385},
	{1327, 1914, 726},
	{906, 1915, 847},
	{1206, 1916, 1386},
	{1328, 1917, 727},
	{907, 1918, 848},
	{1207, 1919, 1387},
	{1326, 1920, 728},
	{908, 1921, 846},
	{1208, 1922, 1388},
	{1330, 1923, 729},
	{909, 1924, 850},
	{1209, 1925, 1389},
	{1331, 1926, 730},
	{910, 1927, 851},
	{1210, 1928, 1390},
	{1329, 1929, 731},
	{911, 1930, 849},
	{1211, 1931, 1391},
	{1333, 1932, 732},
	{912, 1933, 853},
	{1212, 1934, 1392},
	{1334, 1935, 733},
	{913, 1936, 854},
	{1213, 1937, 1393},
	{1332, 1938, 734},
	{914, 1939, 852},
	{1214, 1940, 1394},
	{1336, 1941, 735},
	{915, 1942, 856},
	{1215, 1943, 1395},
	{1337, 1944, 736},
	{916, 1945, 857},
	{1216, 1946, 1396},
	{1335, 1947, 737},
	{917, 1948, 855},
	{1217, 1949, 1397},
	{1339, 1950, 738},
	{918, 1951, 859},
	{1218, 1952, 1398},
	{1340, 1953, 739},
	{919, 1954, 860},
	{1219, 1955, 1399},
	{1338, 1956, 740},
	{920, 1957, 858},
	{1220, 1958, 1400},
	{1342, 1959, 741},
	{921, 1960, 862},
	{1221, 1961, 1401},
	{1343, 1962, 742},
	{922, 1963, 863},
	{1222, 1964, 1402},
	{1341, 1965, 743},
	{923, 1966, 861},
	{1223, 1967, 1403},
	{1345, 1968, 744},
	{924, 1969, 865},
	{1224, 1970, 1404},
	{1346, 1971, 745},
	{925, 1972, 866},
	{1225, 1973, 1405},
	{1344, 1974, 746},
	{926, 1975, 864},
	{1226, 1976, 1406},
	{1348, 1977, 747},
	{927, 1978, 868},
	{1227, 1979, 1407},
	{1349, 1980, 748},
	{928, 1981, 869},
	{1228, 1982, 1408},
	{1347, 1983, 749},
	{929, 1984, 867},
	{1229, 1985, 1409},
	{1351, 1986, 750},
	{930, 1987, 871},
	{1230, 1988, 1410},
	{1352, 1989, 751},
	{931, 1990, 872},
	{1231, 1991, 1411},
	{1350, 1992, 752},
	{932, 1993, 870},
	{1232, 1994, 1412},
	{1354, 1995, 753},
	{933, 1996, 874},
	{1233, 1997, 1413},
	{1355, 1998, 754},
	{934, 1999, 875},
	{1234, 2000, 1414},
	{1353, 2001, 755},
	{935, 2002, 873},
	{1235, 2003, 1415},
	{1357, 2004, 756},
	{936, 2005, 877},
	{1236, 2006, 1416},
	{1358, 2007, 757},
	{937, 2008, 878},
	{1237, 2009, 1417},
	{1356, 2010, 758},
	{938, 2011, 876},
	{1238, 2012, 1418},
	{1360, 2013, 759},
	{939, 2014, 880},
	{1239, 2015, 1419},
	{1361, 2016, 760},
	{940, 2017, 881},
	{1240, 2018, 1420},
	{1359, 2019, 761},
	{941, 2020, 879},
	{1241, 2021, 1421},
	{644, 2022, 1273},
	{942, 2023, 1124},
	{793, 2024, 1422},
	{702, 2025, 1244},
	{943, 2026, 1182},
	{764, 2027, 1423},
	{673, 2028, 1302},
	{944, 2029, 1153},
	{822, 2030, 1424},
	{642, 2031, 1274},
	{945, 2032, 1122},
	{794, 2033, 1425},
	{703, 2034, 1242},
	{946, 2035, 1183},
	{762, 2036, 1426},
	{674, 2037, 1303},
	{947, 2038, 1154},
	{823, 2039, 1427},
	{643, 2040, 1272},
	{948, 2041, 1123},
	{792, 2042, 1428},
	{704, 2043, 1243},
	{949, 2044, 1184},
	{763, 2045, 1429},
	{672, 2046, 1304},
	{950, 2047, 1152},
	{824, 2048, 1430},
	{646, 2049, 1275},
	{951, 2050, 1126},
	{795, 2051, 1431},
	{705, 2052, 1246},
	{952, 2053, 1185},
	{766, 2054, 1432},
	{675, 2055, 1305},
	{953, 2056, 1155},
	{825, 2057, 1433},
	{1274, 2058, 1276},
	{954, 2059, 794},
	{796, 2060, 1434},
	{706, 2061, 674},
	{955, 2062, 1186},
	{1154, 2063, 1435},
	{676, 2064, 1306},
	{956, 2065, 1156},
	{826, 2066, 1436},
	{645, 2067, 644},
	{957, 2068, 1125},
	{1124, 2069, 1437},
	{707, 2070, 1245},
	{958, 2071, 1187},
	{765, 2072, 1438},
	{1244, 2073, 1307},
	{959, 2074, 764},
	{827, 2075, 1439},
	{648, 2076, 1277},
	{960, 2077, 1128},
	{797, 2078, 1440},
	{708, 2079, 1248},
	{961, 2080, 1188},
	{768, 2081, 1441},
	{677, 2082, 1308},
	{962, 2083, 1157},
	{828, 2084, 1442},
	{1276, 2085, 1278},
	{963, 2086, 796},
	{798, 2087, 1443},
	{709, 2088, 676},
	{964, 2089, 1189},
	{1156, 2090, 1444},
	{678, 2091, 1309},
	{965, 2092, 1158},
	{829, 2093, 1445},
	{647, 2094, 646},
	{966, 2095, 1127},
	{1126, 2096, 1446},
	{710, 2097, 1247},
	{967, 2098, 1190},
	{767, 2099, 1447},
	{1246, 2100, 1310},
	{968, 2101, 766},
	{830, 2102, 1448},
	{650, 2103, 1279},
	{969, 2104, 1130},
	{799, 2105, 1449},
	{711, 2106, 1250},
	{970, 2107, 1191},
	{770, 2108, 1450},
	{679, 2109, 1311},
	{971, 2110, 1159},
	{831, 2111, 1451},
	{1278, 2112, 1280},
	{972, 2113, 798},
	{800, 2114, 1452},
	{712, 2115, 678},
	{973, 2116, 1192},
	{1158, 2117, 1453},
	{680, 2118, 1312},
	{974, 2119, 1160},
	{832, 2120, 1454},
	{649, 2121, 648},
	{975, 2122, 1129},
	{1128, 2123, 1455},
	{713, 2124, 1249},
	{976, 2125, 1193},
	{769, 2126, 1456},
	{1248, 2127, 1313},
	{977, 2128, 768},
	{833, 2129, 1457},
	{1272, 2130, 1281},
	{978, 2131, 792},
	{801, 2132, 1458},
	{714, 2133, 672},
	{979, 2134, 1194},
	{1152, 2135, 1459},
	{681, 2136, 1314},
	{980, 2137, 1161},
	{834, 2138, 1460},
	{1280, 2139, 642},
	{981, 2140, 800},
	{1122, 2141, 1461},
	{715, 2142, 680},
	{982, 2143, 1195},
	{1160, 2144, 1462},
	{1242, 2145, 1315},
	{983, 2146, 762},
	{835, 2147, 1463},
	{651, 2148, 650},
	{984, 2149, 1131},
	{1130, 2150, 1464},
	{716, 2151, 1251},
	{985, 2152, 1196},
	{771, 2153, 1465},
	{1250, 2154, 1316},
	{986, 2155, 770},
	{836, 2156, 1466},
	{653, 2157, 1282},
	{987, 2158, 1133},
	{802, 2159, 1467},
	{717, 2160, 1253},
	{988, 2161, 1197},
	{773, 2162, 1468},
	{682, 2163, 1317},
	{989, 2164, 1162},
	{837, 2165, 1469},
	{1281, 2166, 1283},
	{990, 2167, 801},
	{803, 2168, 1470},
	{718, 2169, 681},
	{991, 2170, 1198},
	{1161, 2171, 1471},
	{683, 2172, 1318},
	{992, 2173, 1163},
	{838, 2174, 1472},
	{652, 2175, 651},
	{993, 2176, 1132},
	{1131, 2177, 1473},
	{719, 2178, 1252},
	{994, 2179, 1199},
	{772, 2180, 1474},
	{1251, 2181, 1319},
	{995, 2182, 771},
	{839, 2183, 1475},
	{655, 2184, 1284},
	{996, 2185, 1135},
	{804, 2186, 1476},
	{720, 2187, 1255},
	{997, 2188, 1200},
	{775, 2189, 1477},
	{684, 2190, 1320},
	{998, 2191, 1164},
	{840, 2192, 1478},
	{1283, 2193, 1285},
	{999, 2194, 803},
	{805, 2195, 1479},
	{721, 2196, 683},
	{1000, 2197, 1201},
	{1163, 2198, 1480},
	{685, 2199, 1321},
	{1001, 2200, 1165},
	{841, 2201, 1481},
	{654, 2202, 653},
	{1002, 2203, 1134},
	{1133, 2204, 1482},
	{722, 2205, 1254},
	{1003, 2206, 1202},
	{774, 2207, 1483},
	{1253, 2208, 1322},
	{1004, 2209, 773},
	{842, 2210, 1484},
	{1273, 2211, 1286},
	{1005, 2212, 793},
	{806, 2213, 1485},
	{723, 2214, 673},
	{1006, 2215, 1203},
	{1153, 2216, 1486},
	{686, 2217, 1323},
	{1007, 2218, 1166},
	{843, 2219, 1487},
	{1285, 2220, 643},
	{1008, 2221, 805},
	{1123, 2222, 1488},
	{724, 2223, 685},
	{1009, 2224, 1204},
	{1165, 2225, 1489},
	{1243, 2226, 1324},
	{1010, 2227, 763},
	{844, 2228, 1490},
	{656, 2229, 655},
	{1011, 2230, 1136},
	{1135, 2231, 1491},
	{725, 2232, 1256},
	{1012, 2233, 1205},
	{776, 2234, 1492},
	{1255, 2235, 1325},
	{1013, 2236, 775},
	{845, 2237, 1493},
	{658, 2238, 1287},
	{1014, 2239, 1138},
	{807, 2240, 1494},
	{726, 2241, 1258},
	{1015, 2242, 1206},
	{778, 2243, 1495},
	{687, 2244, 1326},
	{1016, 2245, 1167},
	{846, 2246, 1496},
	{1286, 2247, 1288},
	{1017, 2248, 806},
	{808, 2249, 1497},
	{727, 2250, 686},
	{1018, 2251, 1207},
	{1166, 2252, 1498},
	{688, 2253, 1327},
	{1019, 2254, 1168},
	{847, 2255, 1499},
	{657, 2256, 656},
	{1020, 2257, 1137},
	{1136, 2258, 1500},
	{728, 2259, 1257},
	{1021, 2260, 1208},
	{777, 2261, 1501},
	{1256, 2262, 1328},
	{1022, 2263, 776},
	{848, 2264, 1502},
	{1275, 2265, 1289},
	{1023, 2266, 795},
	{809, 2267, 1503},
	{729, 2268, 675},
	{1024, 2269, 1209},
	{1155, 2270, 1504},
	{689, 2271, 1329},
	{1025, 2272, 1169},
	{849, 2273, 1505},
	{1288, 2274, 645},
	{1026, 2275, 808},
	{1125, 2276, 1506},
	{730, 2277, 688},
	{1027, 2278, 1210},
	{1168, 2279, 1507},
	{1245, 2280, 1330},
	{1028, 2281, 765},
	{850, 2282, 1508},
	{659, 2283, 658},
	{1029, 2284, 1139},
	{1138, 2285, 1509},
	{731, 2286, 1259},
	{1030, 2287, 1211},
	{779, 2288, 1510},
	{1258, 2289, 1331},
	{1031, 2290, 778},
	{851, 2291, 1511},
	{661, 2292, 1290},
	{1032, 2293, 1141},
	{810, 2294, 1512},
	{732, 2295, 1261},
	{1033, 2296, 1212},
	{781, 2297, 1513},
	{690, 2298, 1332},
	{1034, 2299, 1170},
	{852, 2300, 1514},
	{1289, 2301, 1291},
	{1035, 2302, 809},
	{811, 2303, 1515},
	{733, 2304, 689},
	{1036, 2305, 1213},
	{1169, 2306, 1516},
	{691, 2307, 1333},
	{1037, 2308, 1171},
	{853, 2309, 1517},
	{660, 2310, 659},
	{1038, 2311, 1140},
	{1139, 2312, 1518},
	{734, 2313, 1260},
	{1039, 2314, 1214},
	{780, 2315, 1519},
	{1259, 2316, 1334},
	{1040, 2317, 779},
	{854, 2318, 1520},
	{1277, 2319, 1292},
	{1041, 2320, 797},
	{812, 2321, 1521},
	{735, 2322, 677},
	{1042, 2323, 1215},
	{1157, 2324, 1522},
	{692, 2325, 1335},
	{1043, 2326, 1172},
	{855, 2327, 1523},
	{1291, 2328, 647},
	{1044, 2329, 811},
	{1127, 2330, 1524},
	{736, 2331, 691},
	{1045, 2332, 1216},
	{1171, 2333, 1525},
	{1247, 2334, 1336},
	{1046, 2335, 767},
	{856, 2336, 1526},
	{662, 2337, 661},
	{1047, 2338, 1142},
	{1141, 2339, 1527},
	{737, 2340, 1262},
	{1048, 2341, 1217},
	{782, 2342, 1528},
	{1261, 2343, 1337},
	{1049, 2344, 781},
	{857, 2345, 1529},
	{664, 2346, 1293},
	{1050, 2347, 1144},
	{813, 2348, 1530},
	{738, 2349, 1264},
	{1051, 2350, 1218},
	{784, 2351, 1531},
	{693, 2352, 1338},
	{1052, 2353, 1173},
	{858, 2354, 1532},
	{1292, 2355, 1294},
	{1053, 2356, 812},
	{814, 2357, 1533},
	{739, 2358, 692},
	{1054, 2359, 1219},
	{1172, 2360, 1534},
	{694, 2361, 1339},
	{1055, 2362, 1174},
	{859, 2363, 1535},
	{663, 2364, 662},
	{1056, 2365, 1143},
	{1142, 2366, 1536},
	{740, 2367, 1263},
	{1057, 2368, 1220},
	{783, 2369, 1537},
	{1262, 2370, 1340},
	{1058, 2371, 782},
	{860, 2372, 1538},
	{1279, 2373, 1295},
	{1059, 2374, 799},
	{815, 2375, 1539},
	{741, 2376, 679},
	{1060, 2377, 1221},
	{1159, 2378, 1540},
	{695, 2379, 1341},
	{1061, 2380, 1175},
	{861, 2381, 1541},
	{1294, 2382, 649},
	{1062, 2383, 814},
	{1129, 2384, 1542},
	{742, 2385, 694},
	{1063, 2386, 1222},
	{1174, 2387, 1543},
	{1249, 2388, 1342},
	{1064, 2389, 769},
	{862, 2390, 1544},
	{665, 2391, 664},
	{1065, 2392, 1145},
	{1144, 2393, 1545},
	{743, 2394, 1265},
	{1066, 2395, 1223},
	{785, 2396, 1546},
	{1264, 2397, 1343},
	{1067, 2398, 784},
	{863, 2399, 1547},
	{1282, 2400, 1296},
	{1068, 2401, 802},
	{816, 2402, 1548},
	{744, 2403, 682},
	{1069, 2404, 1224},
	{1162, 2405, 1549},
	{696, 2406, 1344},
	{1070, 2407, 1176},
	{864, 2408, 1550},
	{1295, 2409, 652},
	{1071, 2410, 815},
	{1132, 2411, 1551},
	{745, 2412, 695},
	{1072, 2413, 1225},
	{1175, 2414, 1552},
	{1252, 2415, 1345},
	{1073, 2416, 772},
	{865, 2417, 1553},
	{666, 2418, 665},
	{1074, 2419, 1146},
	{1145, 2420, 1554},
	{746, 2421, 1266},
	{1075, 2422, 1226},
	{786, 2423, 1555},
	{1265, 2424, 1346},
	{1076, 2425, 785},
	{866, 2426, 1556},
	{668, 2427, 1297},
	{1077, 2428, 1148},
	{817, 2429, 1557},
	{747, 2430, 1268},
	{1078, 2431, 1227},
	{788, 2432, 1558},
	{697, 2433, 1347},
	{1079, 2434, 1177},
	{867, 2435, 1559},
	{1284, 2436, 1298},
	{1080, 2437, 804},
	{818, 2438, 1560},
	{748, 2439, 684},
	{1081, 2440, 1228},
	{1164, 2441, 1561},
	{698, 2442, 1348},
	{1082, 2443, 1178},
	{868, 2444, 1562},
	{667, 2445, 654},
	{1083, 2446, 1147},
	{1134, 2447, 1563},
	{749, 2448, 1267},
	{1084, 2449, 1229},
	{787, 2450, 1564},
	{1254, 2451, 1349},
	{1085, 2452, 774},
	{869, 2453, 1565},
	{1287, 2454, 1299},
	{1086, 2455, 807},
	{819, 2456, 1566},
	{750, 2457, 687},
	{1087, 2458, 1230},
	{1167, 2459, 1567},
	{699, 2460, 1350},
	{1088, 2461, 1179},
	{870, 2462, 1568},
	{1298, 2463, 657},
	{1089, 2464, 818},
	{1137, 2465, 1569},
	{751, 2466, 698},
	{1090, 2467, 1231},
	{1178, 2468, 1570},
	{1257, 2469, 1351},
	{1091, 2470, 777},
	{871, 2471, 1571},
	{669, 2472, 668},
	{1092, 2473, 1149},
	{1148, 2474, 1572},
	{752, 2475, 1269},
	{1093, 2476, 1232},
	{789, 2477, 1573},
	{1268, 2478, 1352},
	{1094, 2479, 788},
	{872, 2480, 1574},
	{1297, 2481, 1300},
	{1095, 2482, 817},
	{820, 2483, 1575},
	{753, 2484, 697},
	{1096, 2485, 1233},
	{1177, 2486, 1576},
	{700, 2487, 1353},
	{1097, 2488, 1180},
	{873, 2489, 1577},
	{1296, 2490, 667},
	{1098, 2491, 816},
	{1147, 2492, 1578},
	{754, 2493, 696},
	{1099, 2494, 1234},
	{1176, 2495, 1579},
	{1267, 2496, 1354},
	{1100, 2497, 787},
	{874, 2498, 1580},
	{670, 2499, 666},
	{1101, 2500, 1150},
	{1146, 2501, 1581},
	{755, 2502, 1270},
	{1102, 2503, 1235},
	{790, 2504, 1582},
	{1266, 2505, 1355},
	{1103, 2506, 786},
	{875, 2507, 1583},
	{1290, 2508, 1301},
	{1104, 2509, 810},
	{821, 2510, 1584},
	{756, 2511, 690},
	{1105, 2512, 1236},
	{1170, 2513, 1585},
	{701, 2514, 1356},
	{1106, 2515, 1181},
	{876, 2516, 1586},
	{1299, 2517, 660},
	{1107, 2518, 819},
	{1140, 2519, 1587},
	{757, 2520, 699},
	{1108, 2521, 1237},
	{1179, 2522, 1588},
	{1260, 2523, 1357},
	{1109, 2524, 780},
	{877, 2525, 1589},
	{671, 2526, 669},
	{1110, 2527, 1151},
	{1149, 2528, 1590},
	{758, 2529, 1271},
	{1111, 2530, 1238},
	{791, 2531, 1591},
	{1269, 2532, 1358},
	{1112, 2533, 789},
	{878, 2534, 1592},
	{1293, 2535, 670},
	{1113, 2536, 813},
	{1150, 2537, 1593},
	{759, 2538, 693},
	{1114, 2539, 1239},
	{1173, 2540, 1594},
	{1270, 2541, 1359},
	{1115, 2542, 790},
	{879, 2543, 1595},
	{1301, 2544, 663},
	{1116, 2545, 821},
	{1143, 2546, 1596},
	{760, 2547, 701},
	{1117, 2548, 1240},
	{1181, 2549, 1597},
	{1263, 2550, 1360},
	{1118, 2551, 783},
	{880, 2552, 1598},
	{1300, 2553, 671},
	{1119, 2554, 820},
	{1151, 2555, 1599},
	{761, 2556, 700},
	{1120, 2557, 1241},
	{1180, 2558, 1600},
	{1271, 2559, 1361},
	{1121, 2560, 791},
	{881, 2561, 1601},
	{403, 1603, 1602},
	{404, 1604, 1603},
	{402, 1602, 1604},
	{406, 1606, 1605},
	{407, 1607, 1606},
	{405, 1605, 1607},
	{409, 1609, 1608},
	{410, 1610, 1609},
	{408, 1608, 1610},
	{412, 1612, 1611},
	{413, 1613, 1612},
	{411, 1611, 1613},
	{415, 1615, 1614},
	{416, 1616, 1615},
	{414, 1614, 1616},
	{418, 1618, 1617},
	{419, 1619, 1618},
	{417, 1617, 1619},
	{421, 1621, 1620},
	{422, 1622, 1621},
	{420, 1620, 1622},
	{424, 1624, 1623},
	{425, 1625, 1624},
	{423, 1623, 1625},
	{427, 1627, 1626},
	{428, 1628, 1627},
	{426, 1626, 1628},
	{430, 1630, 1629},
	{431, 1631, 1630},
	{429, 1629, 1631},
	{433, 1633, 1632},
	{434, 1634, 1633},
	{432, 1632, 1634},
	{436, 1636, 1635},
	{437, 1637, 1636},
	{435, 1635, 1637},
	{439, 1639, 1638},
	{440, 1640, 1639},
	{438, 1638, 1640},
	{442, 1642, 1641},
	{443, 1643, 1642},
	{441, 1641, 1643},
	{445, 1645, 1644},
	{446, 1646, 1645},
	{444, 1644, 1646},
	{448, 1648, 1647},
	{449, 1649, 1648},
	{447, 1647, 1649},
	{451, 1651, 1650},
	{452, 1652, 1651},
	{450, 1650, 1652},
	{454, 1654, 1653},
	{455, 1655, 1654},
	{453, 1653, 1655},
	{457, 1657, 1656},
	{458, 1658, 1657},
	{456, 1656, 1658},
	{460, 1660, 1659},
	{461, 1661, 1660},
	{459, 1659, 1661},
	{463, 1663, 1662},
	{464, 1664, 1663},
	{462, 1662, 1664},
	{466, 1666, 1665},
	{467, 1667, 1666},
	{465, 1665, 1667},
	{469, 1669, 1668},
	{470, 1670, 1669},
	{468, 1668, 1670},
	{472, 1672, 1671},
	{473, 1673, 1672},
	{471, 1671, 1673},
	{475, 1675, 1674},
	{476, 1676, 1675},
	{474, 1674, 1676},
	{478, 1678, 1677},
	{479, 1679, 1678},
	{477, 1677, 1679},
	{481, 1681, 1680},
	{482, 1682, 1681},
	{480, 1680, 1682},
	{484, 1684, 1683},
	{485, 1685, 1684},
	{483, 1683, 1685},
	{487, 1687, 1686},
	{488, 1688, 1687},
	{486, 1686, 1688},
	{490, 1690, 1689},
	{491, 1691, 1690},
	{489, 1689, 1691},
	{493, 1693, 1692},
	{494, 1694, 1693},
	{492, 1692, 1694},
	{496, 1696, 1695},
	{497, 1697, 1696},
	{495, 1695, 1697},
	{499, 1699, 1698},
	{500, 1700, 1699},
	{498, 1698, 1700},
	{502, 1702, 1701},
	{503, 1703, 1702},
	{501, 1701, 1703},
	{505, 1705, 1704},
	{506, 1706, 1705},
	{504, 1704, 1706},
	{508, 1708, 1707},
	{509, 1709, 1708},
	{507, 1707, 1709},
	{511, 1711, 1710},
	{512, 1712, 1711},
	{510, 1710, 1712},
	{514, 1714, 1713},
	{515, 1715, 1714},
	{513, 1713, 1715},
	{517, 1717, 1716},
	{518, 1718, 1717},
	{516, 1716, 1718},
	{520, 1720, 1719},
	{521, 1721, 1720},
	{519, 1719, 1721},
	{523, 1723, 1722},
	{524, 1724, 1723},
	{522, 1722, 1724},
	{526, 1726, 1725},
	{527, 1727, 1726},
	{525, 1725, 1727},
	{529, 1729, 1728},
	{530, 1730, 1729},
	{528, 1728, 1730},
	{532, 1732, 1731},
	{533, 1733, 1732},
	{531, 1731, 1733},
	{535, 1735, 1734},
	{536, 1736, 1735},
	{534, 1734, 1736},
	{538, 1738, 1737},
	{539, 1739, 1738},
	{537, 1737, 1739},
	{541, 1741, 1740},
	{542, 1742, 1741},
	{540, 1740, 1742},
	{544, 1744, 1743},
	{545, 1745, 1744},
	{543, 1743, 1745},
	{547, 1747, 1746},
	{548, 1748, 1747},
	{546, 1746, 1748},
	{550, 1750, 1749},
	{551, 1751, 1750},
	{549, 1749, 1751},
	{553, 1753, 1752},
	{554, 1754, 1753},
	{552, 1752, 1754},
	{556, 1756, 1755},
	{557, 1757, 1756},
	{555, 1755, 1757},
	{559, 1759, 1758},
	{560, 1760, 1759},
	{558, 1758, 1760},
	{562, 1762, 1761},
	{563, 1763, 1762},
	{561, 1761, 1763},
	{565, 1765, 1764},
	{566, 1766, 1765},
	{564, 1764, 1766},
	{568, 1768, 1767},
	{569, 1769, 1768},
	{567, 1767, 1769},
	{571, 1771, 1770},
	{572, 1772, 1771},
	{570, 1770, 1772},
	{574, 1774, 1773},
	{575, 1775, 1774},
	{573, 1773, 1775},
	{577, 1777, 1776},
	{578, 1778, 1777},
	{576, 1776, 1778},
	{580, 1780, 1779},
	{581, 1781, 1780},
	{579, 1779, 1781},
	{583, 1783, 1782},
	{584, 1784, 1783},
	{582, 1782, 1784},
	{586, 1786, 1785},
	{587, 1787, 1786},
	{585, 1785, 1787},
	{589, 1789, 1788},
	{590, 1790, 1789},
	{588, 1788, 1790},
	{592, 1792, 1791},
	{593, 1793, 1792},
	{591, 1791, 1793},
	{595, 1795, 1794},
	{596, 1796, 1795},
	{594, 1794, 1796},
	{598, 1798, 1797},
	{599, 1799, 1798},
	{597, 1797, 1799},
	{601, 1801, 1800},
	{602, 1802, 1801},
	{600, 1800, 1802},
	{604, 1804, 1803},
	{605, 1805, 1804},
	{603, 1803, 1805},
	{607, 1807, 1806},
	{608, 1808, 1807},
	{606, 1806, 1808},
	{610, 1810, 1809},
	{611, 1811, 1810},
	{609, 1809, 1811},
	{613, 1813, 1812},
	{614, 1814, 1813},
	{612, 1812, 1814},
	{616, 1816, 1815},
	{617, 1817, 1816},
	{615, 1815, 1817},
	{619, 1819, 1818},
	{620, 1820, 1819},
	{618, 1818, 1820},
	{622, 1822, 1821},
	{623, 1823, 1822},
	{621, 1821, 1823},
	{625, 1825, 1824},
	{626, 1826, 1825},
	{624, 1824, 1826},
	{628, 1828, 1827},
	{629, 1829, 1828},
	{627, 1827, 1829},
	{631, 1831, 1830},
	{632, 1832, 1831},
	{630, 1830, 1832},
	{634, 1834, 1833},
	{635, 1835, 1834},
	{633, 1833, 1835},
	{637, 1837, 1836},
	{638, 1838, 1837},
	{636, 1836, 1838},
	{640, 1840, 1839},
	{641, 1841, 1840},
	{639, 1839, 1841},
	{343, 1843, 1842},
	{402, 1844, 1843},
	{222, 1842, 1844},
	{344, 1846, 1845},
	{403, 1847, 1846},
	{223, 1845, 1847},
	{342, 1849, 1848},
	{404, 1850, 1849},
	{224, 1848, 1850},
	{346, 1852, 1851},
	{405, 1853, 1852},
	{225, 1851, 1853},
	{347, 1855, 1854},
	{406, 1856, 1855},
	{226, 1854, 1856},
	{345, 1858, 1857},
	{407, 1859, 1858},
	{227, 1857, 1859},
	{349, 1861, 1860},
	{408, 1862, 1861},
	{228, 1860, 1862},
	{350, 1864, 1863},
	{409, 1865, 1864},
	{229, 1863, 1865},
	{348, 1867, 1866},
	{410, 1868, 1867},
	{230, 1866, 1868},
	{352, 1870, 1869},
	{411, 1871, 1870},
	{231, 1869, 1871},
	{353, 1873, 1872},
	{412, 1874, 1873},
	{232, 1872, 1874},
	{351, 1876, 1875},
	{413, 1877, 1876},
	{233, 1875, 1877},
	{355, 1879, 1878},
	{414, 1880, 1879},
	{234, 1878, 1880},
	{356, 1882, 1881},
	{415, 1883, 1882},
	{235, 1881, 1883},
	{354, 1885, 1884},
	{416, 1886, 1885},
	{236, 1884, 1886},
	{358, 1888, 1887},
	{417, 1889, 1888},
	{237, 1887, 1889},
	{359, 1891, 1890},
	{418, 1892, 1891},
	{238, 1890, 1892},
	{357, 1894, 1893},
	{419, 1895, 1894},
	{239, 1893, 1895},
	{361, 1897, 1896},
	{420, 1898, 1897},
	{240, 1896, 1898},
	{362, 1900, 1899},
	{421, 1901, 1900},
	{241, 1899, 1901},
	{360, 1903, 1902},
	{422, 1904, 1903},
	{242, 1902, 1904},
	{364, 1906, 1905},
	{423, 1907, 1906},
	{243, 1905, 1907},
	{365, 1909, 1908},
	{424, 1910, 1909},
	{244, 1908, 1910},
	{363, 1912, 1911},
	{425, 1913, 1912},
	{245, 1911, 1913},
	{367, 1915, 1914},
	{426, 1916, 1915},
	{246, 1914, 1916},
	{368, 1918, 1917},
	{427, 1919, 1918},
	{247, 1917, 1919},
	{366, 1921, 1920},
	{428, 1922, 1921},
	{248, 1920, 1922},
	{370, 1924, 1923},
	{429, 1925, 1924},
	{249, 1923, 1925},
	{371, 1927, 1926},
	{430, 1928, 1927},
	{250, 1926, 1928},
	{369, 1930, 1929},
	{431, 1931, 1930},
	{251, 1929, 1931},
	{373, 1933, 1932},
	{432, 1934, 1933},
	{252, 1932, 1934},
	{374, 1936, 1935},
	{433, 1937, 1936},
	{253, 1935, 1937},
	{372, 1939, 1938},
	{434, 1940, 1939},
	{254, 1938, 1940},
	{376, 1942, 1941},
	{435, 1943, 1942},
	{255, 1941, 1943},
	{377, 1945, 1944},
	{436, 1946, 1945},
	{256, 1944, 1946},
	{375, 1948, 1947},
	{437, 1949, 1948},
	{257, 1947, 1949},
	{379, 1951, 1950},
	{438, 1952, 1951},
	{258, 1950, 1952},
	{380, 1954, 1953},
	{439, 1955, 1954},
	{259, 1953, 1955},
	{378, 1957, 1956},
	{440, 1958, 1957},
	{260, 1956, 1958},
	{382, 1960, 1959},
	{441, 1961, 1960},
	{261, 1959, 1961},
	{383, 1963, 1962},
	{442, 1964, 1963},
	{262, 1962, 1964},
	{381, 1966, 1965},
	{443, 1967, 1966},
	{263, 1965, 1967},
	{385, 1969, 1968},
	{444, 1970, 1969},
	{264, 1968, 1970},
	{386, 1972, 1971},
	{445, 1973, 1972},
	{265, 1971, 1973},
	{384, 1975, 1974},
	{446, 1976, 1975},
	{266, 1974, 1976},
	{388, 1978, 1977},
	{447, 1979, 1978},
	{267, 1977, 1979},
	{389, 1981, 1980},
	{448, 1982, 1981},
	{268, 1980, 1982},
	{387, 1984, 1983},
	{449, 1985, 1984},
	{269, 1983, 1985},
	{391, 1987, 1986},
	{450, 1988, 1987},
	{270, 1986, 1988},
	{392, 1990, 1989},
	{451, 1991, 1990},
	{271, 1989, 1991},
	{390, 1993, 1992},
	{452, 1994, 1993},
	{272, 1992, 1994},
	{394, 1996, 1995},
	{453, 1997, 1996},
	{273, 1995, 1997},
	{395, 1999, 1998},
	{454, 2000, 1999},
	{274, 1998, 2000},
	{393, 2002, 2001},
	{455, 2003, 2002},
	{275, 2001, 2003},
	{397, 2005, 2004},
	{456, 2006, 2005},
	{276, 2004, 2006},
	{398, 2008, 2007},
	{457, 2009, 2008},
	{277, 2007, 2009},
	{396, 2011, 2010},
	{458, 2012, 2011},
	{278, 2010, 2012},
	{400, 2014, 2013},
	{459, 2015, 2014},
	{279, 2013, 2015},
	{401, 2017, 2016},
	{460, 2018, 2017},
	{280, 2016, 2018},
	{399, 2020, 2019},
	{461, 2021, 2020},
	{281, 2019, 2021},
	{164, 2023, 2022},
	{462, 2024, 2023},
	{313, 2022, 2024},
	{222, 2026, 2025},
	{463, 2027, 2026},
	{284, 2025, 2027},
	{193, 2029, 2028},
	{464, 2030, 2029},
	{342, 2028, 2030},
	{162, 2032, 2031},
	{465, 2033, 2032},
	{314, 2031, 2033},
	{223, 2035, 2034},
	{466, 2036, 2035},
	{282, 2034, 2036},
	{194, 2038, 2037},
	{467, 2039, 2038},
	{343, 2037, 2039},
	{163, 2041, 2040},
	{468, 2042, 2041},
	{312, 2040, 2042},
	{224, 2044, 2043},
	{469, 2045, 2044},
	{283, 2043, 2045},
	{192, 2047, 2046},
	{470, 2048, 2047},
	{344, 2046, 2048},
	{166, 2050, 2049},
	{471, 2051, 2050},
	{315, 2049, 2051},
	{225, 2053, 2052},
	{472, 2054, 2053},
	{286, 2052, 2054},
	{195, 2056, 2055},
	{473, 2057, 2056},
	{345, 2055, 2057},
	{314, 2059, 2058},
	{474, 2060, 2059},
	{316, 2058, 2060},
	{226, 2062, 2061},
	{475, 2063, 2062},
	{194, 2061, 2063},
	{196, 2065, 2064},
	{476, 2066, 2065},
	{346, 2064, 2066},
	{165, 2068, 2067},
	{477, 2069, 2068},
	{164, 2067, 2069},
	{227, 2071, 2070},
	{478, 2072, 2071},
	{285, 2070, 2072},
	{284, 2074, 2073},
	{479, 2075, 2074},
	{347, 2073, 2075},
	{168, 2077, 2076},
	{480, 2078, 2077},
	{317, 2076, 2078},
	{228, 2080, 2079},
	{481, 2081, 2080},
	{288, 2079, 2081},
	{197, 2083, 2082},
	{482, 2084, 2083},
	{348, 2082, 2084},
	{316, 2086, 2085},
	{483, 2087, 2086},
	{318, 2085, 2087},
	{229, 2089, 2088},
	{484, 2090, 2089},
	{196, 2088, 2090},
	{198, 2092, 2091},
	{485, 2093, 2092},
	{349, 2091, 2093},
	{167, 2095, 2094},
	{486, 2096, 2095},
	{166, 2094, 2096},
	{230, 2098, 2097},
	{487, 2099, 2098},
	{287, 2097, 2099},
	{286, 2101, 2100},
	{488, 2102, 2101},
	{350, 2100, 2102},
	{170, 2104, 2103},
	{489, 2105, 2104},
	{319, 2103, 2105},
	{231, 2107, 2106},
	{490, 2108, 2107},
	{290, 2106, 2108},
	{199, 2110, 2109},
	{491, 2111, 2110},
	{351, 2109, 2111},
	{318, 2113, 2112},
	{492, 2114, 2113},
	{320, 2112, 2114},
	{232, 2116, 2115},
	{493, 2117, 2116},
	{198, 2115, 2117},
	{200, 2119, 2118},
	{494, 2120, 2119},
	{352, 2118, 2120},
	{169, 2122, 2121},
	{495, 2123, 2122},
	{168, 2121, 2123},
	{233, 2125, 2124},
	{496, 2126, 2125},
	{289, 2124, 2126},
	{288, 2128, 2127},
	{497, 2129, 2128},
	{353, 2127, 2129},
	{312, 2131, 2130},
	{498, 2132, 2131},
	{321, 2130, 2132},
	{234, 2134, 2133},
	{499, 2135, 2134},
	{192, 2133, 2135},
	{201, 2137, 2136},
	{500, 2138, 2137},
	{354, 2136, 2138},
	{320, 2140, 2139},
	{501, 2141, 2140},
	{162, 2139, 2141},
	{235, 2143, 2142},
	{502, 2144, 2143},
	{200, 2142, 2144},
	{282, 2146, 2145},
	{503, 2147, 2146},
	{355, 2145, 2147},
	{171, 2149, 2148},
	{504, 2150, 2149},
	{170, 2148, 2150},
	{236, 2152, 2151},
	{505, 2153, 2152},
	{291, 2151, 2153},
	{290, 2155, 2154},
	{506, 2156, 2155},
	{356, 2154, 2156},
	{173, 2158, 2157},
	{507, 2159, 2158},
	{322, 2157, 2159},
	{237, 2161, 2160},
	{508, 2162, 2161},
	{293, 2160, 2162},
	{202, 2164, 2163},
	{509, 2165, 2164},
	{357, 2163, 2165},
	{321, 2167, 2166},
	{510, 2168, 2167},
	{323, 2166, 2168},
	{238, 2170, 2169},
	{511, 2171, 2170},
	{201, 2169, 2171},
	{203, 2173, 2172},
	{512, 2174, 2173},
	{358, 2172, 2174},
	{172, 2176, 2175},
	{513, 2177, 2176},
	{171, 2175, 2177},
	{239, 2179, 2178},
	{514, 2180, 2179},
	{292, 2178, 2180},
	{291, 2182, 2181},
	{515, 2183, 2182},
	{359, 2181, 2183},
	{175, 2185, 2184},
	{516, 2186, 2185},
	{324, 2184, 2186},
	{240, 2188, 2187},
	{517, 2189, 2188},
	{295, 2187, 2189},
	{204, 2191, 2190},
	{518, 2192, 2191},
	{360, 2190, 2192},
	{323, 2194, 2193},
	{519, 2195, 2194},
	{325, 2193, 2195},
	{241, 2197, 2196},
	{520, 2198, 2197},
	{203, 2196, 2198},
	{205, 2200, 2199},
	{521, 2201, 2200},
	{361, 2199, 2201},
	{174, 2203, 2202},
	{522, 2204, 2203},
	{173, 2202, 2204},
	{242, 2206, 2205},
	{523, 2207, 2206},
	{294, 2205, 2207},
	{293, 2209, 2208},
	{524, 2210, 2209},
	{362, 2208, 2210},
	{313, 2212, 2211},
	{525, 2213, 2212},
	{326, 2211, 2213},
	{243, 2215, 2214},
	{526, 2216, 2215},
	{193, 2214, 2216},
	{206, 2218, 2217},
	{527, 2219, 2218},
	{363, 2217, 2219},
	{325, 2221, 2220},
	{528, 2222, 2221},
	{163, 2220, 2222},
	{244, 2224, 2223},
	{529, 2225, 2224},
	{205, 2223, 2225},
	{283, 2227, 2226},
	{530, 2228, 2227},
	{364, 2226, 2228},
	{176, 2230, 2229},
	{531, 2231, 2230},
	{175, 2229, 2231},
	{245, 2233, 2232},
	{532, 2234, 2233},
	{296, 2232, 2234},
	{295, 2236, 2235},
	{533, 2237, 2236},
	{365, 2235, 2237},
	{178, 2239, 2238},
	{534, 2240, 2239},
	{327, 2238, 2240},
	{246, 2242, 2241},
	{535, 2243, 2242},
	{298, 2241, 2243},
	{207, 2245, 2244},
	{536, 2246, 2245},
	{366, 2244, 2246},
	{326, 2248, 2247},
	{537, 2249, 2248},
	{328, 2247, 2249},
	{247, 2251, 2250},
	{538, 2252, 2251},
	{206, 2250, 2252},
	{208, 2254, 2253},
	{539, 2255, 2254},
	{367, 2253, 2255},
	{177, 2257, 2256},
	{540, 2258, 2257},
	{176, 2256, 2258},
	{248, 2260, 2259},
	{541, 2261, 2260},
	{297, 2259, 2261},
	{296, 2263, 2262},
	{542, 2264, 2263},
	{368, 2262, 2264},
	{315, 2266, 2265},
	{543, 2267, 2266},
	{329, 2265, 2267},
	{249, 2269, 2268},
	{544, 2270, 2269},
	{195, 2268, 2270},
	{209, 2272, 2271},
	{545, 2273, 2272},
	{369, 2271, 2273},
	{328, 2275, 2274},
	{546, 2276, 2275},
	{165, 2274, 2276},
	{250, 2278, 2277},
	{547, 2279, 2278},
	{208, 2277, 2279},
	{285, 2281, 2280},
	{548, 2282, 2281},
	{370, 2280, 2282},
	{179, 2284, 2283},
	{549, 2285, 2284},
	{178, 2283, 2285},
	{251, 2287, 2286},
	{550, 2288, 2287},
	{299, 2286, 2288},
	{298, 2290, 2289},
	{551, 2291, 2290},
	{371, 2289, 2291},
	{181, 2293, 2292},
	{552, 2294, 2293},
	{330, 2292, 2294},
	{252, 2296, 2295},
	{553, 2297, 2296},
	{301, 2295, 2297},
	{210, 2299, 2298},
	{554, 2300, 2299},
	{372, 2298, 2300},
	{329, 2302, 2301},
	{555, 2303, 2302},
	{331, 2301, 2303},
	{253, 2305, 2304},
	{556, 2306, 2305},
	{209, 2304, 2306},
	{211, 2308, 2307},
	{557, 2309, 2308},
	{373, 2307, 2309},
	{180, 2311, 2310},
	{558, 2312, 2311},
	{179, 2310, 2312},
	{254, 2314, 2313},
	{559, 2315, 2314},
	{300, 2313, 2315},
	{299, 2317, 2316},
	{560, 2318, 2317},
	{374, 2316, 2318},
	{317, 2320, 2319},
	{561, 2321, 2320},
	{332, 2319, 2321},
	{255, 2323, 2322},
	{562, 2324, 2323},
	{197, 2322, 2324},
	{212, 2326, 2325},
	{563, 2327, 2326},
	{375, 2325, 2327},
	{331, 2329, 2328},
	{564, 2330, 2329},
	{167, 2328, 2330},
	{256, 2332, 2331},
	{565, 2333, 2332},
	{211, 2331, 2333},
	{287, 2335, 2334},
	{566, 2336, 2335},
	{376, 2334, 2336},
	{182, 2338, 2337},
	{567, 2339, 2338},
	{181, 2337, 2339},
	{257, 2341, 2340},
	{568, 2342, 2341},
	{302, 2340, 2342},
	{301, 2344, 2343},
	{569, 2345, 2344},
	{377, 2343, 2345},
	{184, 2347, 2346},
	{570, 2348, 2347},
	{333, 2346, 2348},
	{258, 2350, 2349},
	{571, 2351, 2350},
	{304, 2349, 2351},
	{213, 2353, 2352},
	{572, 2354, 2353},
	{378, 2352, 2354},
	{332, 2356, 2355},
	{573, 2357, 2356},
	{334, 2355, 2357},
	{259, 2359, 2358},
	{574, 2360, 2359},
	{212, 2358, 2360},
	{214, 2362, 2361},
	{575, 2363, 2362},
	{379, 2361, 2363},
	{183, 2365, 2364},
	{576, 2366, 2365},
	{182, 2364, 2366},
	{260, 2368, 2367},
	{577, 2369, 2368},
	{303, 2367, 2369},
	{302, 2371, 2370},
	{578, 2372, 2371},
	{380, 2370, 2372},
	{319, 2374, 2373},
	{579, 2375, 2374},
	{335, 2373, 2375},
	{261, 2377, 2376},
	{580, 2378, 2377},
	{199, 2376, 2378},
	{215, 2380, 2379},
	{581, 2381, 2380},
	{381, 2379, 2381},
	{334, 2383, 2382},
	{582, 2384, 2383},
	{169, 2382, 2384},
	{262, 2386, 2385},
	{583, 2387, 2386},
	{214, 2385, 2387},
	{289, 2389, 2388},
	{584, 2390, 2389},
	{382, 2388, 2390},
	{185, 2392, 2391},
	{585, 2393, 2392},
	{184, 2391, 2393},
	{263, 2395, 2394},
	{586, 2396, 2395},
	{305, 2394, 2396},
	{304, 2398, 2397},
	{587, 2399, 2398},
	{383, 2397, 2399},
	{322, 2401, 2400},
	{588, 2402, 2401},
	{336, 2400, 2402},
	{264, 2404, 2403},
	{589, 2405, 2404},
	{202, 2403, 2405},
	{216, 2407, 2406},
	{590, 2408, 2407},
	{384, 2406, 2408},
	{335, 2410, 2409},
	{591, 2411, 2410},
	{172, 2409, 2411},
	{265, 2413, 2412},
	{592, 2414, 2413},
	{215, 2412, 2414},
	{292, 2416, 2415},
	{593, 2417, 2416},
	{385, 2415, 2417},
	{186, 2419, 2418},
	{594, 2420, 2419},
	{185, 2418, 2420},
	{266, 2422, 2421},
	{595, 2423, 2422},
	{306, 2421, 2423},
	{305, 2425, 2424},
	{596, 2426, 2425},
	{386, 2424, 2426},
	{188, 2428, 2427},
	{597, 2429, 2428},
	{337, 2427, 2429},
	{267, 2431, 2430},
	{598, 2432, 2431},
	{308, 2430, 2432},
	{217, 2434, 2433},
	{599, 2435, 2434},
	{387, 2433, 2435},
	{324, 2437, 2436},
	{600, 2438, 2437},
	{338, 2436, 2438},
	{268, 2440, 2439},
	{601, 2441, 2440},
	{204, 2439, 2441},
	{218, 2443, 2442},
	{602, 2444, 2443},
	{388, 2442, 2444},
	{187, 2446, 2445},
	{603, 2447, 2446},
	{174, 2445, 2447},
	{269, 2449, 2448},
	{604, 2450, 2449},
	{307, 2448, 2450},
	{294, 2452, 2451},
	{605, 2453, 2452},
	{389, 2451, 2453},
	{327, 2455, 2454},
	{606, 2456, 2455},
	{339, 2454, 2456},
	{270, 2458, 2457},
	{607, 2459, 2458},
	{207, 2457, 2459},
	{219, 2461, 2460},
	{608, 2462, 2461},
	{390, 2460, 2462},
	{338, 2464, 2463},
	{609, 2465, 2464},
	{177, 2463, 2465},
	{271, 2467, 2466},
	{610, 2468, 2467},
	{218, 2466, 2468},
	{297, 2470, 2469},
	{611, 2471, 2470},
	{391, 2469, 2471},
	{189, 2473, 2472},
	{612, 2474, 2473},
	{188, 2472, 2474},
	{272, 2476, 2475},
	{613, 2477, 2476},
	{309, 2475, 2477},
	{308, 2479, 2478},
	{614, 2480, 2479},
	{392, 2478, 2480},
	{337, 2482, 2481},
	{615, 2483, 2482},
	{340, 2481, 2483},
	{273, 2485, 2484},
	{616, 2486, 2485},
	{217, 2484, 2486},
	{220, 2488, 2487},
	{617, 2489, 2488},
	{393, 2487, 2489},
	{336, 2491, 2490},
	{618, 2492, 2491},
	{187, 2490, 2492},
	{274, 2494, 2493},
	{619, 2495, 2494},
	{216, 2493, 2495},
	{307, 2497, 2496},
	{620, 2498, 2497},
	{394, 2496, 2498},
	{190, 2500, 2499},
	{621, 2501, 2500},
	{186, 2499, 2501},
	{275, 2503, 2502},
	{622, 2504, 2503},
	{310, 2502, 2504},
	{306, 2506, 2505},
	{623, 2507, 2506},
	{395, 2505, 2507},
	{330, 2509, 2508},
	{624, 2510, 2509},
	{341, 2508, 2510},
	{276, 2512, 2511},
	{625, 2513, 2512},
	{210, 2511, 2513},
	{221, 2515, 2514},
	{626, 2516, 2515},
	{396, 2514, 2516},
	{339, 2518, 2517},
	{627, 2519, 2518},
	{180, 2517, 2519},
	{277, 2521, 2520},
	{628, 2522, 2521},
	{219, 2520, 2522},
	{300, 2524, 2523},
	{629, 2525, 2524},
	{397, 2523, 2525},
	{191, 2527, 2526},
	{630, 2528, 2527},
	{189, 2526, 2528},
	{278, 2530, 2529},
	{631, 2531, 2530},
	{311, 2529, 2531},
	{309, 2533, 2532},
	{632, 2534, 2533},
	{398, 2532, 2534},
	{333, 2536, 2535},
	{633, 2537, 2536},
	{190, 2535, 2537},
	{279, 2539, 2538},
	{634, 2540, 2539},
	{213, 2538, 2540},
	{310, 2542, 2541},
	{635, 2543, 2542},
	{399, 2541, 2543},
	{341, 2545, 2544},
	{636, 2546, 2545},
	{183, 2544, 2546},
	{280, 2548, 2547},
	{637, 2549, 2548},
	{221, 2547, 2549},
	{303, 2551, 2550},
	{638, 2552, 2551},
	{400, 2550, 2552},
	{340, 2554, 2553},
	{639, 2555, 2554},
	{191, 2553, 2555},
	{281, 2557, 2556},
	{640, 2558, 2557},
	{220, 2556, 2558},
	{311, 2560, 2559},
	{641, 2561, 2560},
	{401, 2559, 2561},
	{103, 1363, 882},
	{403, 1602, 1363},
	{402, 882, 1602},
	{104, 1364, 883},
	{404, 1603, 1364},
	{403, 883, 1603},
	{102, 1362, 884},
	{402, 1604, 1362},
	{404, 884, 1604},
	{106, 1366, 885},
	{406, 1605, 1366},
	{405, 885, 1605},
	{107, 1367, 886},
	{407, 1606, 1367},
	{406, 886, 1606},
	{105, 1365, 887},
	{405, 1607, 1365},
	{407, 887, 1607},
	{109, 1369, 888},
	{409, 1608, 1369},
	{408, 888, 1608},
	{110, 1370, 889},
	{410, 1609, 1370},
	{409, 889, 1609},
	{108, 1368, 890},
	{408, 1610, 1368},
	{410, 890, 1610},
	{112, 1372, 891},
	{412, 1611, 1372},
	{411, 891, 1611},
	{113, 1373, 892},
	{413, 1612, 1373},
	{412, 892, 1612},
	{111, 1371, 893},
	{411, 1613, 1371},
	{413, 893, 1613},
	{115, 1375, 894},
	{415, 1614, 1375},
	{414, 894, 1614},
	{116, 1376, 895},
	{416, 1615, 1376},
	{415, 895, 1615},
	{114, 1374, 896},
	{414, 1616, 1374},
	{416, 896, 1616},
	{118, 1378, 897},
	{418, 1617, 1378},
	{417, 897, 1617},
	{119, 1379, 898},
	{419, 1618, 1379},
	{418, 898, 1618},
	{117, 1377, 899},
	{417, 1619, 1377},
	{419, 899, 1619},
	{121, 1381, 900},
	{421, 1620, 1381},
	{420, 900, 1620},
	{122, 1382, 901},
	{422, 1621, 1382},
	{421, 901, 1621},
	{120, 1380, 902},
	{420, 1622, 1380},
	{422, 902, 1622},
	{124, 1384, 903},
	{424, 1623, 1384},
	{423, 903, 1623},
	{125, 1385, 904},
	{425, 1624, 1385},
	{424, 904, 1624},
	{123, 1383, 905},
	{423, 1625, 1383},
	{425, 905, 1625},
	{127, 1387, 906},
	{427, 1626, 1387},
	{426, 906, 1626},
	{128, 1388, 907},
	{428, 1627, 1388},
	{427, 907, 1627},
	{126, 1386, 908},
	{426, 1628, 1386},
	{428, 908, 1628},
	{130, 1390, 909},
	{430, 1629, 1390},
	{429, 909, 1629},
	{131, 1391, 910},
	{431, 1630, 1391},
	{430, 910, 1630},
	{129, 1389, 911},
	{429, 1631, 1389},
	{431, 911, 1631},
	{133, 1393, 912},
	{433, 1632, 1393},
	{432, 912, 1632},
	{134, 1394, 913},
	{434, 1633, 1394},
	{433, 913, 1633},
	{132, 1392, 914},
	{432, 1634, 1392},
	{434, 914, 1634},
	{136, 1396, 915},
	{436, 1635, 1396},
	{435, 915, 1635},
	{137, 1397, 916},
	{437, 1636, 1397},
	{436, 916, 1636},
	{135, 1395, 917},
	{435, 1637, 1395},
	{437, 917, 1637},
	{139, 1399, 918},
	{439, 1638, 1399},
	{438, 918, 1638},
	{140, 1400, 919},
	{440, 1639, 1400},
	{439, 919, 1639},
	{138, 1398, 920},
	{438, 1640, 1398},
	{440, 920, 1640},
	{142, 1402, 921},
	{442, 1641, 1402},
	{441, 921, 1641},
	{143, 1403, 922},
	{443, 1642, 1403},
	{442, 922, 1642},
	{141, 1401, 923},
	{441, 1643, 1401},
	{443, 923, 1643},
	{145, 1405, 924},
	{445, 1644, 1405},
	{444, 924, 1644},
	{146, 1406, 925},
	{446, 1645, 1406},
	{445, 925, 1645},
	{144, 1404, 926},
	{444, 1646, 1404},
	{446, 926, 1646},
	{148, 1408, 927},
	{448, 1647, 1408},
	{447, 927, 1647},
	{149, 1409, 928},
	{449, 1648, 1409},
	{448, 928, 1648},
	{147, 1407, 929},
	{447, 1649, 1407},
	{449, 929, 1649},
	{151, 1411, 930},
	{451, 1650, 1411},
	{450, 930, 1650},
	{152, 1412, 931},
	{452, 1651, 1412},
	{451, 931, 1651},
	{150, 1410, 932},
	{450, 1652, 1410},
	{452, 932, 1652},
	{154, 1414, 933},
	{454, 1653, 1414},
	{453, 933, 1653},
	{155, 1415, 934},
	{455, 1654, 1415},
	{454, 934, 1654},
	{153, 1413, 935},
	{453, 1655, 1413},
	{455, 935, 1655},
	{157, 1417, 936},
	{457, 1656, 1417},
	{456, 936, 1656},
	{158, 1418, 937},
	{458, 1657, 1418},
	{457, 937, 1657},
	{156, 1416, 938},
	{456, 1658, 1416},
	{458, 938, 1658},
	{160, 1420, 939},
	{460, 1659, 1420},
	{459, 939, 1659},
	{161, 1421, 940},
	{461, 1660, 1421},
	{460, 940, 1660},
	{159, 1419, 941},
	{459, 1661, 1419},
	{461, 941, 1661},
	{44, 1423, 942},
	{463, 1662, 1423},
	{462, 942, 1662},
	{102, 1424, 943},
	{464, 1663, 1424},
	{463, 943, 1663},
	{73, 1422, 944},
	{462, 1664, 1422},
	{464, 944, 1664},
	{42, 1426, 945},
	{466, 1665, 1426},
	{465, 945, 1665},
	{103, 1427, 946},
	{467, 1666, 1427},
	{466, 946, 1666},
	{74, 1425, 947},
	{465, 1667, 1425},
	{467, 947, 1667},
	{43, 1429, 948},
	{469, 1668, 1429},
	{468, 948, 1668},
	{104, 1430, 949},
	{470, 1669, 1430},
	{469, 949, 1669},
	{72, 1428, 950},
	{468, 1670, 1428},
	{470, 950, 1670},
	{46, 1432, 951},
	{472, 1671, 1432},
	{471, 951, 1671},
	{105, 1433, 952},
	{473, 1672, 1433},
	{472, 952, 1672},
	{75, 1431, 953},
	{471, 1673, 1431},
	{473, 953, 1673},
	{74, 1435, 954},
	{475, 1674, 1435},
	{474, 954, 1674},
	{106, 1436, 955},
	{476, 1675, 1436},
	{475, 955, 1675},
	{76, 1434, 956},
	{474, 1676, 1434},
	{476, 956, 1676},
	{45, 1438, 957},
	{478, 1677, 1438},
	{477, 957, 1677},
	{107, 1439, 958},
	{479, 1678, 1439},
	{478, 958, 1678},
	{44, 1437, 959},
	{477, 1679, 1437},
	{479, 959, 1679},
	{48, 1441, 960},
	{481, 1680, 1441},
	{480, 960, 1680},
	{108, 1442, 961},
	{482, 1681, 1442},
	{481, 961, 1681},
	{77, 1440, 962},
	{480, 1682, 1440},
	{482, 962, 1682},
	{76, 1444, 963},
	{484, 1683, 1444},
	{483, 963, 1683},
	{109, 1445, 964},
	{485, 1684, 1445},
	{484, 964, 1684},
	{78, 1443, 965},
	{483, 1685, 1443},
	{485, 965, 1685},
	{47, 1447, 966},
	{487, 1686, 1447},
	{486, 966, 1686},
	{110, 1448, 967},
	{488, 1687, 1448},
	{487, 967, 1687},
	{46, 1446, 968},
	{486, 1688, 1446},
	{488, 968, 1688},
	{50, 1450, 969},
	{490, 1689, 1450},
	{489, 969, 1689},
	{111, 1451, 970},
	{491, 1690, 1451},
	{490, 970, 1690},
	{79, 1449, 971},
	{489, 1691, 1449},
	{491, 971, 1691},
	{78, 1453, 972},
	{493, 1692, 1453},
	{492, 972, 1692},
	{112, 1454, 973},
	{494, 1693, 1454},
	{493, 973, 1693},
	{80, 1452, 974},
	{492, 1694, 1452},
	{494, 974, 1694},
	{49, 1456, 975},
	{496, 1695, 1456},
	{495, 975, 1695},
	{113, 1457, 976},
	{497, 1696, 1457},
	{496, 976, 1696},
	{48, 1455, 977},
	{495, 1697, 1455},
	{497, 977, 1697},
	{72, 1459, 978},
	{499, 1698, 1459},
	{498, 978, 1698},
	{114, 1460, 979},
	{500, 1699, 1460},
	{499, 979, 1699},
	{81, 1458, 980},
	{498, 1700, 1458},
	{500, 980, 1700},
	{80, 1462, 981},
	{502, 1701, 1462},
	{501, 981, 1701},
	{115, 1463, 982},
	{503, 1702, 1463},
	{502, 982, 1702},
	{42, 1461, 983},
	{501, 1703, 1461},
	{503, 983, 1703},
	{51, 1465, 984},
	{505, 1704, 1465},
	{504, 984, 1704},
	{116, 1466, 985},
	{506, 1705, 1466},
	{505, 985, 1705},
	{50, 1464, 986},
	{504, 1706, 1464},
	{506, 986, 1706},
	{53, 1468, 987},
	{508, 1707, 1468},
	{507, 987, 1707},
	{117, 1469, 988},
	{509, 1708, 1469},
	{508, 988, 1708},
	{82, 1467, 989},
	{507, 1709, 1467},
	{509, 989, 1709},
	{81, 1471, 990},
	{511, 1710, 1471},
	{510, 990, 1710},
	{118, 1472, 991},
	{512, 1711, 1472},
	{511, 991, 1711},
	{83, 1470, 992},
	{510, 1712, 1470},
	{512, 992, 1712},
	{52, 1474, 993},
	{514, 1713, 1474},
	{513, 993, 1713},
	{119, 1475, 994},
	{515, 1714, 1475},
	{514, 994, 1714},
	{51, 1473, 995},
	{513, 1715, 1473},
	{515, 995, 1715},
	{55, 1477, 996},
	{517, 1716, 1477},
	{516, 996, 1716},
	{120, 1478, 997},
	{518, 1717, 1478},
	{517, 997, 1717},
	{84, 1476, 998},
	{516, 1718, 1476},
	{518, 998, 1718},
	{83, 1480, 999},
	{520, 1719, 1480},
	{519, 999, 1719},
	{121, 1481, 1000},
	{521, 1720, 1481},
	{520, 1000, 1720},
	{85, 1479, 1001},
	{519, 1721, 1479},
	{521, 1001, 1721},
	{54, 1483, 1002},
	{523, 1722, 1483},
	{522, 1002, 1722},
	{122, 1484, 1003},
	{524, 1723, 1484},
	{523, 1003, 1723},
	{53, 1482, 1004},
	{522, 1724, 1482},
	{524, 1004, 1724},
	{73, 1486, 1005},
	{526, 1725, 1486},
	{525, 1005, 1725},
	{123, 1487, 1006},
	{527, 1726, 1487},
	{526, 1006, 1726},
	{86, 1485, 1007},
	{525, 1727, 1485},
	{527, 1007, 1727},
	{85, 1489, 1008},
	{529, 1728, 1489},
	{528, 1008, 1728},
	{124, 1490, 1009},
	{530, 1729, 1490},
	{529, 1009, 1729},
	{43, 1488, 1010},
	{528, 1730, 1488},
	{530, 1010, 1730},
	{56, 1492, 1011},
	{532, 1731, 1492},
	{531, 1011, 1731},
	{125, 1493, 1012},
	{533, 1732, 1493},
	{532, 1012, 1732},
	{55, 1491, 1013},
	{531, 1733, 1491},
	{533, 1013, 1733},
	{58, 1495, 1014},
	{535, 1734, 1495},
	{534, 1014, 1734},
	{126, 1496, 1015},
	{536, 1735, 1496},
	{535, 1015, 1735},
	{87, 1494, 1016},
	{534, 1736, 1494},
	{536, 1016, 1736},
	{86, 1498, 1017},
	{538, 1737, 1498},
	{537, 1017, 1737},
	{127, 1499, 1018},
	{539, 1738, 1499},
	{538, 1018, 1738},
	{88, 1497, 1019},
	{537, 1739, 1497},
	{539, 1019, 1739},
	{57, 1501, 1020},
	{541, 1740, 1501},
	{540, 1020, 1740},
	{128, 1502, 1021},
	{542, 1741, 1502},
	{541, 1021, 1741},
	{56, 1500, 1022},
	{540, 1742, 1500},
	{542, 1022, 1742},
	{75, 1504, 1023},
	{544, 1743, 1504},
	{543, 1023, 1743},
	{129, 1505, 1024},
	{545, 1744, 1505},
	{544, 1024, 1744},
	{89, 1503, 1025},
	{543, 1745, 1503},
	{545, 1025, 1745},
	{88, 1507, 1026},
	{547, 1746, 1507},
	{546, 1026, 1746},
	{130, 1508, 1027},
	{548, 1747, 1508},
	{547, 1027, 1747},
	{45, 1506, 1028},
	{546, 1748, 1506},
	{548, 1028, 1748},
	{59, 1510, 1029},
	{550, 1749, 1510},
	{549, 1029, 1749},
	{131, 1511, 1030},
	{551, 1750, 1511},
	{550, 1030, 1750},
	{58, 1509, 1031},
	{549, 1751, 1509},
	{551, 1031, 1751},
	{61, 1513, 1032},
	{553, 1752, 1513},
	{552, 1032, 1752},
	{132, 1514, 1033},
	{554, 1753, 1514},
	{553, 1033, 1753},
	{90, 1512, 1034},
	{552, 1754, 1512},
	{554, 1034, 1754},
	{89, 1516, 1035},
	{556, 1755, 1516},
	{555, 1035, 1755},
	{133, 1517, 1036},
	{557, 1756, 1517},
	{556, 1036, 1756},
	{91, 1515, 1037},
	{555, 1757, 1515},
	{557, 1037, 1757},
	{60, 1519, 1038},
	{559, 1758, 1519},
	{558, 1038, 1758},
	{134, 1520, 1039},
	{560, 1759, 1520},
	{559, 1039, 1759},
	{59, 1518, 1040},
	{558, 1760, 1518},
	{560, 1040, 1760},
	{77, 1522, 1041},
	{562, 1761, 1522},
	{561, 1041, 1761},
	{135, 1523, 1042},
	{563, 1762, 1523},
	{562, 1042, 1762},
	{92, 1521, 1043},
	{561, 1763, 1521},
	{563, 1043, 1763},
	{91, 1525, 1044},
	{565, 1764, 1525},
	{564, 1044, 1764},
	{136, 1526, 1045},
	{566, 1765, 1526},
	{565, 1045, 1765},
	{47, 1524, 1046},
	{564, 1766, 1524},
	{566, 1046, 1766},
	{62, 1528, 1047},
	{568, 1767, 1528},
	{567, 1047, 1767},
	{137, 1529, 1048},
	{569, 1768, 1529},
	{568, 1048, 1768},
	{61, 1527, 1049},
	{567, 1769, 1527},
	{569, 1049, 1769},
	{64, 1531, 1050},
	{571, 1770, 1531},
	{570, 1050, 1770},
	{138, 1532, 1051},
	{572, 1771, 1532},
	{571, 1051, 1771},
	{93, 1530, 1052},
	{570, 1772, 1530},
	{572, 1052, 1772},
	{92, 1534, 1053},
	{574, 1773, 1534},
	{573, 1053, 1773},
	{139, 1535, 1054},
	{575, 1774, 1535},
	{574, 1054, 1774},
	{94, 1533, 1055},
	{573, 1775, 1533},
	{575, 1055, 1775},
	{63, 1537, 1056},
	{577, 1776, 1537},
	{576, 1056, 1776},
	{140, 1538, 1057},
	{578, 1777, 1538},
	{577, 1057, 1777},
	{62, 1536, 1058},
	{576, 1778, 1536},
	{578, 1058, 1778},
	{79, 1540, 1059},
	{580, 1779, 1540},
	{579, 1059, 1779},
	{141, 1541, 1060},
	{581, 1780, 1541},
	{580, 1060, 1780},
	{95, 1539, 1061},
	{579, 1781, 1539},
	{581, 1061, 1781},
	{94, 1543, 1062},
	{583, 1782, 1543},
	{582, 1062, 1782},
	{142, 1544, 1063},
	{584, 1783, 1544},
	{583, 1063, 1783},
	{49, 1542, 1064},
	{582, 1784, 1542},
	{584, 1064, 1784},
	{65, 1546, 1065},
	{586, 1785, 1546},
	{585, 1065, 1785},
	{143, 1547, 1066},
	{587, 1786, 1547},
	{586, 1066, 1786},
	{64, 1545, 1067},
	{585, 1787, 1545},
	{587, 1067, 1787},
	{82, 1549, 1068},
	{589, 1788, 1549},
	{588, 1068, 1788},
	{144, 1550, 1069},
	{590, 1789, 1550},
	{589, 1069, 1789},
	{96, 1548, 1070},
	{588, 1790, 1548},
	{590, 1070, 1790},
	{95, 1552, 1071},
	{592, 1791, 1552},
	{591, 1071, 1791},
	{145, 1553, 1072},
	{593, 1792, 1553},
	{592, 1072, 1792},
	{52, 1551, 1073},
	{591, 1793, 1551},
	{593, 1073, 1793},
	{66, 1555, 1074},
	{595, 1794, 1555},
	{594, 1074, 1794},
	{146, 1556, 1075},
	{596, 1795, 1556},
	{595, 1075, 1795},
	{65, 1554, 1076},
	{594, 1796, 1554},
	{596, 1076, 1796},
	{68, 1558, 1077},
	{598, 1797, 1558},
	{597, 1077, 1797},
	{147, 1559, 1078},
	{599, 1798, 1559},
	{598, 1078, 1798},
	{97, 1557, 1079},
	{597, 1799, 1557},
	{599, 1079, 1799},
	{84, 1561, 1080},
	{601, 1800, 1561},
	{600, 1080, 1800},
	{148, 1562, 1081},
	{602, 1801, 1562},
	{601, 1081, 1801},
	{98, 1560, 1082},
	{600, 1802, 1560},
	{602, 1082, 1802},
	{67, 1564, 1083},
	{604, 1803, 1564},
	{603, 1083, 1803},
	{149, 1565, 1084},
	{605, 1804, 1565},
	{604, 1084, 1804},
	{54, 1563, 1085},
	{603, 1805, 1563},
	{605, 1085, 1805},
	{87, 1567, 1086},
	{607, 1806, 1567},
	{606, 1086, 1806},
	{150, 1568, 1087},
	{608, 1807, 1568},
	{607, 1087, 1807},
	{99, 1566, 1088},
	{606, 1808, 1566},
	{608, 1088, 1808},
	{98, 1570, 1089},
	{610, 1809, 1570},
	{609, 1089, 1809},
	{151, 1571, 1090},
	{611, 1810, 1571},
	{610, 1090, 1810},
	{57, 1569, 1091},
	{609, 1811, 1569},
	{611, 1091, 1811},
	{69, 1573, 1092},
	{613, 1812, 1573},
	{612, 1092, 1812},
	{152, 1574, 1093},
	{614, 1813, 1574},
	{613, 1093, 1813},
	{68, 1572, 1094},
	{612, 1814, 1572},
	{614, 1094, 1814},
	{97, 1576, 1095},
	{616, 1815, 1576},
	{615, 1095, 1815},
	{153, 1577, 1096},
	{617, 1816, 1577},
	{616, 1096, 1816},
	{100, 1575, 1097},
	{615, 1817, 1575},
	{617, 1097, 1817},
	{96, 1579, 1098},
	{619, 1818, 1579},
	{618, 1098, 1818},
	{154, 1580, 1099},
	{620, 1819, 1580},
	{619, 1099, 1819},
	{67, 1578, 1100},
	{618, 1820, 1578},
	{620, 1100, 1820},
	{70, 1582, 1101},
	{622, 1821, 1582},
	{621, 1101, 1821},
	{155, 1583, 1102},
	{623, 1822, 1583},
	{622, 1102, 1822},
	{66, 1581, 1103},
	{621, 1823, 1581},
	{623, 1103, 1823},
	{90, 1585, 1104},
	{625, 1824, 1585},
	{624, 1104, 1824},
	{156, 1586, 1105},
	{626, 1825, 1586},
	{625, 1105, 1825},
	{101, 1584, 1106},
	{624, 1826, 1584},
	{626, 1106, 1826},
	{99, 1588, 1107},
	{628, 1827, 1588},
	{627, 1107, 1827},
	{157, 1589, 1108},
	{629, 1828, 1589},
	{628, 1108, 1828},
	{60, 1587, 1109},
	{627, 1829, 1587},
	{629, 1109, 1829},
	{71, 1591, 1110},
	{631, 1830, 1591},
	{630, 1110, 1830},
	{158, 1592, 1111},
	{632, 1831, 1592},
	{631, 1111, 1831},
	{69, 1590, 1112},
	{630, 1832, 1590},
	{632, 1112, 1832},
	{93, 1594, 1113},
	{634, 1833, 1594},
	{633, 1113, 1833},
	{159, 1595, 1114},
	{635, 1834, 1595},
	{634, 1114, 1834},
	{70, 1593, 1115},
	{633, 1835, 1593},
	{635, 1115, 1835},
	{101, 1597, 1116},
	{637, 1836, 1597},
	{636, 1116, 1836},
	{160, 1598, 1117},
	{638, 1837, 1598},
	{637, 1117, 1837},
	{63, 1596, 1118},
	{636, 1838, 1596},
	{638, 1118, 1838},
	{100, 1600, 1119},
	{640, 1839, 1600},
	{639, 1119, 1839},
	{161, 1601, 1120},
	{641, 1840, 1601},
	{640, 1120, 1840},
	{71, 1599, 1121},
	{639, 1841, 1599},
	{641, 1121, 1841},
	{14, 1303, 702},
	{343, 1842, 1303},
	{222, 702, 1842},
	{103, 882, 823},
	{402, 1843, 882},
	{343, 823, 1843},
	{102, 1182, 1362},
	{222, 1844, 1182},
	{402, 1362, 1844},
	{12, 1304, 703},
	{344, 1845, 1304},
	{223, 703, 1845},
	{104, 883, 824},
	{403, 1846, 883},
	{344, 824, 1846},
	{103, 1183, 1363},
	{223, 1847, 1183},
	{403, 1363, 1847},
	{13, 1302, 704},
	{342, 1848, 1302},
	{224, 704, 1848},
	{102, 884, 822},
	{404, 1849, 884},
	{342, 822, 1849},
	{104, 1184, 1364},
	{224, 1850, 1184},
	{404, 1364, 1850},
	{16, 1306, 705},
	{346, 1851, 1306},
	{225, 705, 1851},
	{106, 885, 826},
	{405, 1852, 885},
	{346, 826, 1852},
	{105, 1185, 1365},
	{225, 1853, 1185},
	{405, 1365, 1853},
	{14, 1307, 706},
	{347, 1854, 1307},
	{226, 706, 1854},
	{107, 886, 827},
	{406, 1855, 886},
	{347, 827, 1855},
	{106, 1186, 1366},
	{226, 1856, 1186},
	{406, 1366, 1856},
	{15, 1305, 707},
	{345, 1857, 1305},
	{227, 707, 1857},
	{105, 887, 825},
	{407, 1858, 887},
	{345, 825, 1858},
	{107, 1187, 1367},
	{227, 1859, 1187},
	{407, 1367, 1859},
	{18, 1309, 708},
	{349, 1860, 1309},
	{228, 708, 1860},
	{109, 888, 829},
	{408, 1861, 888},
	{349, 829, 1861},
	{108, 1188, 1368},
	{228, 1862, 1188},
	{408, 1368, 1862},
	{16, 1310, 709},
	{350, 1863, 1310},
	{229, 709, 1863},
	{110, 889, 830},
	{409, 1864, 889},
	{350, 830, 1864},
	{109, 1189, 1369},
	{229, 1865, 1189},
	{409, 1369, 1865},
	{17, 1308, 710},
	{348, 1866, 1308},
	{230, 710, 1866},
	{108, 890, 828},
	{410, 1867, 890},
	{348, 828, 1867},
	{110, 1190, 1370},
	{230, 1868, 1190},
	{410, 1370, 1868},
	{20, 1312, 711},
	{352, 1869, 1312},
	{231, 711, 1869},
	{112, 891, 832},
	{411, 1870, 891},
	{352, 832, 1870},
	{111, 1191, 1371},
	{231, 1871, 1191},
	{411, 1371, 1871},
	{18, 1313, 712},
	{353, 1872, 1313},
	{232, 712, 1872},
	{113, 892, 833},
	{412, 1873, 892},
	{353, 833, 1873},
	{112, 1192, 1372},
	{232, 1874, 1192},
	{412, 1372, 1874},
	{19, 1311, 713},
	{351, 1875, 1311},
	{233, 713, 1875},
	{111, 893, 831},
	{413, 1876, 893},
	{351, 831, 1876},
	{113, 1193, 1373},
	{233, 1877, 1193},
	{413, 1373, 1877},
	{12, 1315, 714},
	{355, 1878, 1315},
	{234, 714, 1878},
	{115, 894, 835},
	{414, 1879, 894},
	{355, 835, 1879},
	{114, 1194, 1374},
	{234, 1880, 1194},
	{414, 1374, 1880},
	{20, 1316, 715},
	{356, 1881, 1316},
	{235, 715, 1881},
	{116, 895, 836},
	{415, 1882, 895},
	{356, 836, 1882},
	{115, 1195, 1375},
	{235, 1883, 1195},
	{415, 1375, 1883},
	{21, 1314, 716},
	{354, 1884, 1314},
	{236, 716, 1884},
	{114, 896, 834},
	{416, 1885, 896},
	{354, 834, 1885},
	{116, 1196, 1376},
	{236, 1886, 1196},
	{416, 1376, 1886},
	{23, 1318, 717},
	{358, 1887, 1318},
	{237, 717, 1887},
	{118, 897, 838},
	{417, 1888, 897},
	{358, 838, 1888},
	{117, 1197, 1377},
	{237, 1889, 1197},
	{417, 1377, 1889},
	{21, 1319, 718},
	{359, 1890, 1319},
	{238, 718, 1890},
	{119, 898, 839},
	{418, 1891, 898},
	{359, 839, 1891},
	{118, 1198, 1378},
	{238, 1892, 1198},
	{418, 1378, 1892},
	{22, 1317, 719},
	{357, 1893, 1317},
	{239, 719, 1893},
	{117, 899, 837},
	{419, 1894, 899},
	{357, 837, 1894},
	{119, 1199, 1379},
	{239, 1895, 1199},
	{419, 1379, 1895},
	{25, 1321, 720},
	{361, 1896, 1321},
	{240, 720, 1896},
	{121, 900, 841},
	{420, 1897, 900},
	{361, 841, 1897},
	{120, 1200, 1380},
	{240, 1898, 1200},
	{420, 1380, 1898},
	{23, 1322, 721},
	{362, 1899, 1322},
	{241, 721, 1899},
	{122, 901, 842},
	{421, 1900, 901},
	{362, 842, 1900},
	{121, 1201, 1381},
	{241, 1901, 1201},
	{421, 1381, 1901},
	{24, 1320, 722},
	{360, 1902, 1320},
	{242, 722, 1902},
	{120, 902, 840},
	{422, 1903, 902},
	{360, 840, 1903},
	{122, 1202, 1382},
	{242, 1904, 1202},
	{422, 1382, 1904},
	{13, 1324, 723},
	{364, 1905, 1324},
	{243, 723, 1905},
	{124, 903, 844},
	{423, 1906, 903},
	{364, 844, 1906},
	{123, 1203, 1383},
	{243, 1907, 1203},
	{423, 1383, 1907},
	{25, 1325, 724},
	{365, 1908, 1325},
	{244, 724, 1908},
	{125, 904, 845},
	{424, 1909, 904},
	{365, 845, 1909},
	{124, 1204, 1384},
	{244, 1910, 1204},
	{424, 1384, 1910},
	{26, 1323, 725},
	{363, 1911, 1323},
	{245, 725, 1911},
	{123, 905, 843},
	{425, 1912, 905},
	{363, 843, 1912},
	{125, 1205, 1385},
	{245, 1913, 1205},
	{425, 1385, 1913},
	{28, 1327, 726},
	{367, 1914, 1327},
	{246, 726, 1914},
	{127, 906, 847},
	{426, 1915, 906},
	{367, 847, 1915},
	{126, 1206, 1386},
	{246, 1916, 1206},
	{426, 1386, 1916},
	{26, 1328, 727},
	{368, 1917, 1328},
	{247, 727, 1917},
	{128, 907, 848},
	{427, 1918, 907},
	{368, 848, 1918},
	{127, 1207, 1387},
	{247, 1919, 1207},
	{427, 1387, 1919},
	{27, 1326, 728},
	{366, 1920, 1326},
	{248, 728, 1920},
	{126, 908, 846},
	{428, 1921, 908},
	{366, 846, 1921},
	{128, 1208, 1388},
	{248, 1922, 1208},
	{428, 1388, 1922},
	{15, 1330, 729},
	{370, 1923, 1330},
	{249, 729, 1923},
	{130, 909, 850},
	{429, 1924, 909},
	{370, 850, 1924},
	{129, 1209, 1389},
	{249, 1925, 1209},
	{429, 1389, 1925},
	{28, 1331, 730},
	{371, 1926, 1331},
	{250, 730, 1926},
	{131, 910, 851},
	{430, 1927, 910},
	{371, 851, 1927},
	{130, 1210, 1390},
	{250, 1928, 1210},
	{430, 1390, 1928},
	{29, 1329, 731},
	{369, 1929, 1329},
	{251, 731, 1929},
	{129, 911, 849},
	{431, 1930, 911},
	{369, 849, 1930},
	{131, 1211, 1391},
	{251, 1931, 1211},
	{431, 1391, 1931},
	{31, 1333, 732},
	{373, 1932, 1333},
	{252, 732, 1932},
	{133, 912, 853},
	{432, 1933, 912},
	{373, 853, 1933},
	{132, 1212, 1392},
	{252, 1934, 1212},
	{432, 1392, 1934},
	{29, 1334, 733},
	{374, 1935, 1334},
	{253, 733, 1935},
	{134, 913, 854},
	{433, 1936, 913},
	{374, 854, 1936},
	{133, 1213, 1393},
	{253, 1937, 1213},
	{433, 1393, 1937},
	{30, 1332, 734},
	{372, 1938, 1332},
	{254, 734, 1938},
	{132, 914, 852},
	{434, 1939, 914},
	{372, 852, 1939},
	{134, 1214, 1394},
	{254, 1940, 1214},
	{434, 1394, 1940},
	{17, 1336, 735},
	{376, 1941, 1336},
	{255, 735, 1941},
	{136, 915, 856},
	{435, 1942, 915},
	{376, 856, 1942},
	{135, 1215, 1395},
	{255, 1943, 1215},
	{435, 1395, 1943},
	{31, 1337, 736},
	{377, 1944, 1337},
	{256, 736, 1944},
	{137, 916, 857},
	{436, 1945, 916},
	{377, 857, 1945},
	{136, 1216, 1396},
	{256, 1946, 1216},
	{436, 1396, 1946},
	{32, 1335, 737},
	{375, 1947, 1335},
	{257, 737, 1947},
	{135, 917, 855},
	{437, 1948, 917},
	{375, 855, 1948},
	{137, 1217, 1397},
	{257, 1949, 1217},
	{437, 1397, 1949},
	{34, 1339, 738},
	{379, 1950, 1339},
	{258, 738, 1950},
	{139, 918, 859},
	{438, 1951, 918},
	{379, 859, 1951},
	{138, 1218, 1398},
	{258, 1952, 1218},
	{438, 1398, 1952},
	{32, 1340, 739},
	{380, 1953, 1340},
	{259, 739, 1953},
	{140, 919, 860},
	{439, 1954, 919},
	{380, 860, 1954},
	{139, 1219, 1399},
	{259, 1955, 1219},
	{439, 1399, 1955},
	{33, 1338, 740},
	{378, 1956, 1338},
	{260, 740, 1956},
	{138, 920, 858},
	{440, 1957, 920},
	{378, 858, 1957},
	{140, 1220, 1400},
	{260, 1958, 1220},
	{440, 1400, 1958},
	{19, 1342, 741},
	{382, 1959, 1342},
	{261, 741, 1959},
	{142, 921, 862},
	{441, 1960, 921},
	{382, 862, 1960},
	{141, 1221, 1401},
	{261, 1961, 1221},
	{441, 1401, 1961},
	{34, 1343, 742},
	{383, 1962, 1343},
	{262, 742, 1962},
	{143, 922, 863},
	{442, 1963, 922},
	{383, 863, 1963},
	{142, 1222, 1402},
	{262, 1964, 1222},
	{442, 1402, 1964},
	{35, 1341, 743},
	{381, 1965, 1341},
	{263, 743, 1965},
	{141, 923, 861},
	{443, 1966, 923},
	{381, 861, 1966},
	{143, 1223, 1403},
	{263, 1967, 1223},
	{443, 1403, 1967},
	{22, 1345, 744},
	{385, 1968, 1345},
	{264, 744, 1968},
	{145, 924, 865},
	{444, 1969, 924},
	{385, 865, 1969},
	{144, 1224, 1404},
	{264, 1970, 1224},
	{444, 1404, 1970},
	{35, 1346, 745},
	{386, 1971, 1346},
	{265, 745, 1971},
	{146, 925, 866},
	{445, 1972, 925},
	{386, 866, 1972},
	{145, 1225, 1405},
	{265, 1973, 1225},
	{445, 1405, 1973},
	{36, 1344, 746},
	{384, 1974, 1344},
	{266, 746, 1974},
	{144, 926, 864},
	{446, 1975, 926},
	{384, 864, 1975},
	{146, 1226, 1406},
	{266, 1976, 1226},
	{446, 1406, 1976},
	{38, 1348, 747},
	{388, 1977, 1348},
	{267, 747, 1977},
	{148, 927, 868},
	{447, 1978, 927},
	{388, 868, 1978},
	{147, 1227, 1407},
	{267, 1979, 1227},
	{447, 1407, 1979},
	{24, 1349, 748},
	{389, 1980, 1349},
	{268, 748, 1980},
	{149, 928, 869},
	{448, 1981, 928},
	{389, 869, 1981},
	{148, 1228, 1408},
	{268, 1982, 1228},
	{448, 1408, 1982},
	{37, 1347, 749},
	{387, 1983, 1347},
	{269, 749, 1983},
	{147, 929, 867},
	{449, 1984, 929},
	{387, 867, 1984},
	{149, 1229, 1409},
	{269, 1985, 1229},
	{449, 1409, 1985},
	{27, 1351, 750},
	{391, 1986, 1351},
	{270, 750, 1986},
	{151, 930, 871},
	{450, 1987, 930},
	{391, 871, 1987},
	{150, 1230, 1410},
	{270, 1988, 1230},
	{450, 1410, 1988},
	{38, 1352, 751},
	{392, 1989, 1352},
	{271, 751, 1989},
	{152, 931, 872},
	{451, 1990, 931},
	{392, 872, 1990},
	{151, 1231, 1411},
	{271, 1991, 1231},
	{451, 1411, 1991},
	{39, 1350, 752},
	{390, 1992, 1350},
	{272, 752, 1992},
	{150, 932, 870},
	{452, 1993, 932},
	{390, 870, 1993},
	{152, 1232, 1412},
	{272, 1994, 1232},
	{452, 1412, 1994},
	{37, 1354, 753},
	{394, 1995, 1354},
	{273, 753, 1995},
	{154, 933, 874},
	{453, 1996, 933},
	{394, 874, 1996},
	{153, 1233, 1413},
	{273, 1997, 1233},
	{453, 1413, 1997},
	{36, 1355, 754},
	{395, 1998, 1355},
	{274, 754, 1998},
	{155, 934, 875},
	{454, 1999, 934},
	{395, 875, 1999},
	{154, 1234, 1414},
	{274, 2000, 1234},
	{454, 1414, 2000},
	{40, 1353, 755},
	{393, 2001, 1353},
	{275, 755, 2001},
	{153, 935, 873},
	{455, 2002, 935},
	{393, 873, 2002},
	{155, 1235, 1415},
	{275, 2003, 1235},
	{455, 1415, 2003},
	{30, 1357, 756},
	{397, 2004, 1357},
	{276, 756, 2004},
	{157, 936, 877},
	{456, 2005, 936},
	{397, 877, 2005},
	{156, 1236, 1416},
	{276, 2006, 1236},
	{456, 1416, 2006},
	{39, 1358, 757},
	{398, 2007, 1358},
	{277, 757, 2007},
	{158, 937, 878},
	{457, 2008, 937},
	{398, 878, 2008},
	{157, 1237, 1417},
	{277, 2009, 1237},
	{457, 1417, 2009},
	{41, 1356, 758},
	{396, 2010, 1356},
	{278, 758, 2010},
	{156, 938, 876},
	{458, 2011, 938},
	{396, 876, 2011},
	{158, 1238, 1418},
	{278, 2012, 1238},
	{458, 1418, 2012},
	{33, 1360, 759},
	{400, 2013, 1360},
	{279, 759, 2013},
	{160, 939, 880},
	{459, 2014, 939},
	{400, 880, 2014},
	{159, 1239, 1419},
	{279, 2015, 1239},
	{459, 1419, 2015},
	{41, 1361, 760},
	{401, 2016, 1361},
	{280, 760, 2016},
	{161, 940, 881},
	{460, 2017, 940},
	{401, 881, 2017},
	{160, 1240, 1420},
	{280, 2018, 1240},
	{460, 1420, 2018},
	{40, 1359, 761},
	{399, 2019, 1359},
	{281, 761, 2019},
	{159, 941, 879},
	{461, 2020, 941},
	{399, 879, 2020},
	{161, 1241, 1421},
	{281, 2021, 1241},
	{461, 1421, 2021},
	{2, 644, 1273},
	{164, 2022, 644},
	{313, 1273, 2022},
	{44, 942, 1124},
	{462, 2023, 942},
	{164, 1124, 2023},
	{73, 793, 1422},
	{313, 2024, 793},
	{462, 1422, 2024},
	{14, 702, 1244},
	{222, 2025, 702},
	{284, 1244, 2025},
	{102, 943, 1182},
	{463, 2026, 943},
	{222, 1182, 2026},
	{44, 764, 1423},
	{284, 2027, 764},
	{463, 1423, 2027},
	{13, 673, 1302},
	{193, 2028, 673},
	{342, 1302, 2028},
	{73, 944, 1153},
	{464, 2029, 944},
	{193, 1153, 2029},
	{102, 822, 1424},
	{342, 2030, 822},
	{464, 1424, 2030},
	{0, 642, 1274},
	{162, 2031, 642},
	{314, 1274, 2031},
	{42, 945, 1122},
	{465, 2032, 945},
	{162, 1122, 2032},
	{74, 794, 1425},
	{314, 2033, 794},
	{465, 1425, 2033},
	{12, 703, 1242},
	{223, 2034, 703},
	{282, 1242, 2034},
	{103, 946, 1183},
	{466, 2035, 946},
	{223, 1183, 2035},
	{42, 762, 1426},
	{282, 2036, 762},
	{466, 1426, 2036},
	{14, 674, 1303},
	{194, 2037, 674},
	{343, 1303, 2037},
	{74, 947, 1154},
	{467, 2038, 947},
	{194, 1154, 2038},
	{103, 823, 1427},
	{343, 2039, 823},
	{467, 1427, 2039},
	{1, 643, 1272},
	{163, 2040, 643},
	{312, 1272, 2040},
	{43, 948, 1123},
	{468, 2041, 948},
	{163, 1123, 2041},
	{72, 792, 1428},
	{312, 2042, 792},
	{468, 1428, 2042},
	{13, 704, 1243},
	{224, 2043, 704},
	{283, 1243, 2043},
	{104, 949, 1184},
	{469, 2044, 949},
	{224, 1184, 2044},
	{43, 763, 1429},
	{283, 2045, 763},
	{469, 1429, 2045},
	{12, 672, 1304},
	{192, 2046, 672},
	{344, 1304, 2046},
	{72, 950, 1152},
	{470, 2047, 950},
	{192, 1152, 2047},
	{104, 824, 1430},
	{344, 2048, 824},
	{470, 1430, 2048},
	{3, 646, 1275},
	{166, 2049, 646},
	{315, 1275, 2049},
	{46, 951, 1126},
	{471, 2050, 951},
	{166, 1126, 2050},
	{75, 795, 1431},
	{315, 2051, 795},
	{471, 1431, 2051},
	{16, 705, 1246},
	{225, 2052, 705},
	{286, 1246, 2052},
	{105, 952, 1185},
	{472, 2053, 952},
	{225, 1185, 2053},
	{46, 766, 1432},
	{286, 2054, 766},
	{472, 1432, 2054},
	{15, 675, 1305},
	{195, 2055, 675},
	{345, 1305, 2055},
	{75, 953, 1155},
	{473, 2056, 953},
	{195, 1155, 2056},
	{105, 825, 1433},
	{345, 2057, 825},
	{473, 1433, 2057},
	{0, 1274, 1276},
	{314, 2058, 1274},
	{316, 1276, 2058},
	{74, 954, 794},
	{474, 2059, 954},
	{314, 794, 2059},
	{76, 796, 1434},
	{316, 2060, 796},
	{474, 1434, 2060},
	{14, 706, 674},
	{226, 2061, 706},
	{194, 674, 2061},
	{106, 955, 1186},
	{475, 2062, 955},
	{226, 1186, 2062},
	{74, 1154, 1435},
	{194, 2063, 1154},
	{475, 1435, 2063},
	{16, 676, 1306},
	{196, 2064, 676},
	{346, 1306, 2064},
	{76, 956, 1156},
	{476, 2065, 956},
	{196, 1156, 2065},
	{106, 826, 1436},
	{346, 2066, 826},
	{476, 1436, 2066},
	{2, 645, 644},
	{165, 2067, 645},
	{164, 644, 2067},
	{45, 957, 1125},
	{477, 2068, 957},
	{165, 1125, 2068},
	{44, 1124, 1437},
	{164, 2069, 1124},
	{477, 1437, 2069},
	{15, 707, 1245},
	{227, 2070, 707},
	{285, 1245, 2070},
	{107, 958, 1187},
	{478, 2071, 958},
	{227, 1187, 2071},
	{45, 765, 1438},
	{285, 2072, 765},
	{478, 1438, 2072},
	{14, 1244, 1307},
	{284, 2073, 1244},
	{347, 1307, 2073},
	{44, 959, 764},
	{479, 2074, 959},
	{284, 764, 2074},
	{107, 827, 1439},
	{347, 2075, 827},
	{479, 1439, 2075},
	{4, 648, 1277},
	{168, 2076, 648},
	{317, 1277, 2076},
	{48, 960, 1128},
	{480, 2077, 960},
	{168, 1128, 2077},
	{77, 797, 1440},
	{317, 2078, 797},
	{480, 1440, 2078},
	{18, 708, 1248},
	{228, 2079, 708},
	{288, 1248, 2079},
	{108, 961, 1188},
	{481, 2080, 961},
	{228, 1188, 2080},
	{48, 768, 1441},
	{288, 2081, 768},
	{481, 1441, 2081},
	{17, 677, 1308},
	{197, 2082, 677},
	{348, 1308, 2082},
	{77, 962, 1157},
	{482, 2083, 962},
	{197, 1157, 2083},
	{108, 828, 1442},
	{348, 2084, 828},
	{482, 1442, 2084},
	{0, 1276, 1278},
	{316, 2085, 1276},
	{318, 1278, 2085},
	{76, 963, 796},
	{483, 2086, 963},
	{316, 796, 2086},
	{78, 798, 1443},
	{318, 2087, 798},
	{483, 1443, 2087},
	{16, 709, 676},
	{229, 2088, 709},
	{196, 676, 2088},
	{109, 964, 1189},
	{484, 2089, 964},
	{229, 1189, 2089},
	{76, 1156, 1444},
	{196, 2090, 1156},
	{484, 1444, 2090},
	{18, 678, 1309},
	{198, 2091, 678},
	{349, 1309, 2091},
	{78, 965, 1158},
	{485, 2092, 965},
	{198, 1158, 2092},
	{109, 829, 1445},
	{349, 2093, 829},
	{485, 1445, 2093},
	{3, 647, 646},
	{167, 2094, 647},
	{166, 646, 2094},
	{47, 966, 1127},
	{486, 2095, 966},
	{167, 1127, 2095},
	{46, 1126, 1446},
	{166, 2096, 1126},
	{486, 1446, 2096},
	{17, 710, 1247},
	{230, 2097, 710},
	{287, 1247, 2097},
	{110, 967, 1190},
	{487, 2098, 967},
	{230, 1190, 2098},
	{47, 767, 1447},
	{287, 2099, 767},
	{487, 1447, 2099},
	{16, 1246, 1310},
	{286, 2100, 1246},
	{350, 1310, 2100},
	{46, 968, 766},
	{488, 2101, 968},
	{286, 766, 2101},
	{110, 830, 1448},
	{350, 2102, 830},
	{488, 1448, 2102},
	{5, 650, 1279},
	{170, 2103, 650},
	{319, 1279, 2103},
	{50, 969, 1130},
	{489, 2104, 969},
	{170, 1130, 2104},
	{79, 799, 1449},
	{319, 2105, 799},
	{489, 1449, 2105},
	{20, 711, 1250},
	{231, 2106, 711},
	{290, 1250, 2106},
	{111, 970, 1191},
	{490, 2107, 970},
	{231, 1191, 2107},
	{50, 770, 1450},
	{290, 2108, 770},
	{490, 1450, 2108},
	{19, 679, 1311},
	{199, 2109, 679},
	{351, 1311, 2109},
	{79, 971, 1159},
	{491, 2110, 971},
	{199, 1159, 2110},
	{111, 831, 1451},
	{351, 2111, 831},
	{491, 1451, 2111},
	{0, 1278, 1280},
	{318, 2112, 1278},
	{320, 1280, 2112},
	{78, 972, 798},
	{492, 2113, 972},
	{318, 798, 2113},
	{80, 800, 1452},
	{320, 2114, 800},
	{492, 1452, 2114},
	{18, 712, 678},
	{232, 2115, 712},
	{198, 678, 2115},
	{112, 973, 1192},
	{493, 2116, 973},
	{232, 1192, 2116},
	{78, 1158, 1453},
	{198, 2117, 1158},
	{493, 1453, 2117},
	{20, 680, 1312},
	{200, 2118, 680},
	{352, 1312, 2118},
	{80, 974, 1160},
	{494, 2119, 974},
	{200, 1160, 2119},
	{112, 832, 1454},
	{352, 2120, 832},
	{494, 1454, 2120},
	{4, 649, 648},
	{169, 2121, 649},
	{168, 648, 2121},
	{49, 975, 1129},
	{495, 2122, 975},
	{169, 1129, 2122},
	{48, 1128, 1455},
	{168, 2123, 1128},
	{495, 1455, 2123},
	{19, 713, 1249},
	{233, 2124, 713},
	{289, 1249, 2124},
	{113, 976, 1193},
	{496, 2125, 976},
	{233, 1193, 2125},
	{49, 769, 1456},
	{289, 2126, 769},
	{496, 1456, 2126},
	{18, 1248, 1313},
	{288, 2127, 1248},
	{353, 1313, 2127},
	{48, 977, 768},
	{497, 2128, 977},
	{288, 768, 2128},
	{113, 833, 1457},
	{353, 2129, 833},
	{497, 1457, 2129},
	{1, 1272, 1281},
	{312, 2130, 1272},
	{321, 1281, 2130},
	{72, 978, 792},
	{498, 2131, 978},
	{312, 792, 2131},
	{81, 801, 1458},
	{321, 2132, 801},
	{498, 1458, 2132},
	{12, 714, 672},
	{234, 2133, 714},
	{192, 672, 2133},
	{114, 979, 1194},
	{499, 2134, 979},
	{234, 1194, 2134},
	{72, 1152, 1459},
	{192, 2135, 1152},
	{499, 1459, 2135},
	{21, 681, 1314},
	{201, 2136, 681},
	{354, 1314, 2136},
	{81, 980, 1161},
	{500, 2137, 980},
	{201, 1161, 2137},
	{114, 834, 1460},
	{354, 2138, 834},
	{500, 1460, 2138},
	{0, 1280, 642},
	{320, 2139, 1280},
	{162, 642, 2139},
	{80, 981, 800},
	{501, 2140, 981},
	{320, 800, 2140},
	{42, 1122, 1461},
	{162, 2141, 1122},
	{501, 1461, 2141},
	{20, 715, 680},
	{235, 2142, 715},
	{200, 680, 2142},
	{115, 982, 1195},
	{502, 2143, 982},
	{235, 1195, 2143},
	{80, 1160, 1462},
	{200, 2144, 1160},
	{502, 1462, 2144},
	{12, 1242, 1315},
	{282, 2145, 1242},
	{355, 1315, 2145},
	{42, 983, 762},
	{503, 2146, 983},
	{282, 762, 2146},
	{115, 835, 1463},
	{355, 2147, 835},
	{503, 1463, 2147},
	{5, 651, 650},
	{171, 2148, 651},
	{170, 650, 2148},
	{51, 984, 1131},
	{504, 2149, 984},
	{171, 1131, 2149},
	{50, 1130, 1464},
	{170, 2150, 1130},
	{504, 1464, 2150},
	{21, 716, 1251},
	{236, 2151, 716},
	{291, 1251, 2151},
	{116, 985, 1196},
	{505, 2152, 985},
	{236, 1196, 2152},
	{51, 771, 1465},
	{291, 2153, 771},
	{505, 1465, 2153},
	{20, 1250, 1316},
	{290, 2154, 1250},
	{356, 1316, 2154},
	{50, 986, 770},
	{506, 2155, 986},
	{290, 770, 2155},
	{116, 836, 1466},
	{356, 2156, 836},
	{506, 1466, 2156},
	{7, 653, 1282},
	{173, 2157, 653},
	{322, 1282, 2157},
	{53, 987, 1133},
	{507, 2158, 987},
	{173, 1133, 2158},
	{82, 802, 1467},
	{322, 2159, 802},
	{507, 1467, 2159},
	{23, 717, 1253},
	{237, 2160, 717},
	{293, 1253, 2160},
	{117, 988, 1197},
	{508, 2161, 988},
	{237, 1197, 2161},
	{53, 773, 1468},
	{293, 2162, 773},
	{508, 1468, 2162},
	{22, 682, 1317},
	{202, 2163, 682},
	{357, 1317, 2163},
	{82, 989, 1162},
	{509, 2164, 989},
	{202, 1162, 2164},
	{117, 837, 1469},
	{357, 2165, 837},
	{509, 1469, 2165},
	{1, 1281, 1283},
	{321, 2166, 1281},
	{323, 1283, 2166},
	{81, 990, 801},
	{510, 2167, 990},
	{321, 801, 2167},
	{83, 803, 1470},
	{323, 2168, 803},
	{510, 1470, 2168},
	{21, 718, 681},
	{238, 2169, 718},
	{201, 681, 2169},
	{118, 991, 1198},
	{511, 2170, 991},
	{238, 1198, 2170},
	{81, 1161, 1471},
	{201, 2171, 1161},
	{511, 1471, 2171},
	{23, 683, 1318},
	{203, 2172, 683},
	{358, 1318, 2172},
	{83, 992, 1163},
	{512, 2173, 992},
	{203, 1163, 2173},
	{118, 838, 1472},
	{358, 2174, 838},
	{512, 1472, 2174},
	{5, 652, 651},
	{172, 2175, 652},
	{171, 651, 2175},
	{52, 993, 1132},
	{513, 2176, 993},
	{172, 1132, 2176},
	{51, 1131, 1473},
	{171, 2177, 1131},
	{513, 1473, 2177},
	{22, 719, 1252},
	{239, 2178, 719},
	{292, 1252, 2178},
	{119, 994, 1199},
	{514, 2179, 994},
	{239, 1199, 2179},
	{52, 772, 1474},
	{292, 2180, 772},
	{514, 1474, 2180},
	{21, 1251, 1319},
	{291, 2181, 1251},
	{359, 1319, 2181},
	{51, 995, 771},
	{515, 2182, 995},
	{291, 771, 2182},
	{119, 839, 1475},
	{359, 2183, 839},
	{515, 1475, 2183},
	{6, 655, 1284},
	{175, 2184, 655},
	{324, 1284, 2184},
	{55, 996, 1135},
	{516, 2185, 996},
	{175, 1135, 2185},
	{84, 804, 1476},
	{324, 2186, 804},
	{516, 1476, 2186},
	{25, 720, 1255},
	{240, 2187, 720},
	{295, 1255, 2187},
	{120, 997, 1200},
	{517, 2188, 997},
	{240, 1200, 2188},
	{55, 775, 1477},
	{295, 2189, 775},
	{517, 1477, 2189},
	{24, 684, 1320},
	{204, 2190, 684},
	{360, 1320, 2190},
	{84, 998, 1164},
	{518, 2191, 998},
	{204, 1164, 2191},
	{120, 840, 1478},
	{360, 2192, 840},
	{518, 1478, 2192},
	{1, 1283, 1285},
	{323, 2193, 1283},
	{325, 1285, 2193},
	{83, 999, 803},
	{519, 2194, 999},
	{323, 803, 2194},
	{85, 805, 1479},
	{325, 2195, 805},
	{519, 1479, 2195},
	{23, 721, 683},
	{241, 2196, 721},
	{203, 683, 2196},
	{121, 1000, 1201},
	{520, 2197, 1000},
	{241, 1201, 2197},
	{83, 1163, 1480},
	{203, 2198, 1163},
	{520, 1480, 2198},
	{25, 685, 1321},
	{205, 2199, 685},
	{361, 1321, 2199},
	{85, 1001, 1165},
	{521, 2200, 1001},
	{205, 1165, 2200},
	{121, 841, 1481},
	{361, 2201, 841},
	{521, 1481, 2201},
	{7, 654, 653},
	{174, 2202, 654},
	{173, 653, 2202},
	{54, 1002, 1134},
	{522, 2203, 1002},
	{174, 1134, 2203},
	{53, 1133, 1482},
	{173, 2204, 1133},
	{522, 1482, 2204},
	{24, 722, 1254},
	{242, 2205, 722},
	{294, 1254, 2205},
	{122, 1003, 1202},
	{523, 2206, 1003},
	{242, 1202, 2206},
	{54, 774, 1483},
	{294, 2207, 774},
	{523, 1483, 2207},
	{23, 1253, 1322},
	{293, 2208, 1253},
	{362, 1322, 2208},
	{53, 1004, 773},
	{524, 2209, 1004},
	{293, 773, 2209},
	{122, 842, 1484},
	{362, 2210, 842},
	{524, 1484, 2210},
	{2, 1273, 1286},
	{313, 2211, 1273},
	{326, 1286, 2211},
	{73, 1005, 793},
	{525, 2212, 1005},
	{313, 793, 2212},
	{86, 806, 1485},
	{326, 2213, 806},
	{525, 1485, 2213},
	{13, 723, 673},
	{243, 2214, 723},
	{193, 673, 2214},
	{123, 1006, 1203},
	{526, 2215, 1006},
	{243, 1203, 2215},
	{73, 1153, 1486},
	{193, 2216, 1153},
	{526, 1486, 2216},
	{26, 686, 1323},
	{206, 2217, 686},
	{363, 1323, 2217},
	{86, 1007, 1166},
	{527, 2218, 1007},
	{206, 1166, 2218},
	{123, 843, 1487},
	{363, 2219, 843},
	{527, 1487, 2219},
	{1, 1285, 643},
	{325, 2220, 1285},
	{163, 643, 2220},
	{85, 1008, 805},
	{528, 2221, 1008},
	{325, 805, 2221},
	{43, 1123, 1488},
	{163, 2222, 1123},
	{528, 1488, 2222},
	{25, 724, 685},
	{244, 2223, 724},
	{205, 685, 2223},
	{124, 1009, 1204},
	{529, 2224, 1009},
	{244, 1204, 2224},
	{85, 1165, 1489},
	{205, 2225, 1165},
	{529, 1489, 2225},
	{13, 1243, 1324},
	{283, 2226, 1243},
	{364, 1324, 2226},
	{43, 1010, 763},
	{530, 2227, 1010},
	{283, 763, 2227},
	{124, 844, 1490},
	{364, 2228, 844},
	{530, 1490, 2228},
	{6, 656, 655},
	{176, 2229, 656},
	{175, 655, 2229},
	{56, 1011, 1136},
	{531, 2230, 1011},
	{176, 1136, 2230},
	{55, 1135, 1491},
	{175, 2231, 1135},
	{531, 1491, 2231},
	{26, 725, 1256},
	{245, 2232, 725},
	{296, 1256, 2232},
	{125, 1012, 1205},
	{532, 2233, 1012},
	{245, 1205, 2233},
	{56, 776, 1492},
	{296, 2234, 776},
	{532, 1492, 2234},
	{25, 1255, 1325},
	{295, 2235, 1255},
	{365, 1325, 2235},
	{55, 1013, 775},
	{533, 2236, 1013},
	{295, 775, 2236},
	{125, 845, 1493},
	{365, 2237, 845},
	{533, 1493, 2237},
	{8, 658, 1287},
	{178, 2238, 658},
	{327, 1287, 2238},
	{58, 1014, 1138},
	{534, 2239, 1014},
	{178, 1138, 2239},
	{87, 807, 1494},
	{327, 2240, 807},
	{534, 1494, 2240},
	{28, 726, 1258},
	{246, 2241, 726},
	{298, 1258, 2241},
	{126, 1015, 1206},
	{535, 2242, 1015},
	{246, 1206, 2242},
	{58, 778, 1495},
	{298, 2243, 778},
	{535, 1495, 2243},
	{27, 687, 1326},
	{207, 2244, 687},
	{366, 1326, 2244},
	{87, 1016, 1167},
	{536, 2245, 1016},
	{207, 1167, 2245},
	{126, 846, 1496},
	{366, 2246, 846},
	{536, 1496, 2246},
	{2, 1286, 1288},
	{326, 2247, 1286},
	{328, 1288, 2247},
	{86, 1017, 806},
	{537, 2248, 1017},
	{326, 806, 2248},
	{88, 808, 1497},
	{328, 2249, 808},
	{537, 1497, 2249},
	{26, 727, 686},
	{247, 2250, 727},
	{206, 686, 2250},
	{127, 1018, 1207},
	{538, 2251, 1018},
	{247, 1207, 2251},
	{86, 1166, 1498},
	{206, 2252, 1166},
	{538, 1498, 2252},
	{28, 688, 1327},
	{208, 2253, 688},
	{367, 1327, 2253},
	{88, 1019, 1168},
	{539, 2254, 1019},
	{208, 1168, 2254},
	{127, 847, 1499},
	{367, 2255, 847},
	{539, 1499, 2255},
	{6, 657, 656},
	{177, 2256, 657},
	{176, 656, 2256},
	{57, 1020, 1137},
	{540, 2257, 1020},
	{177, 1137, 2257},
	{56, 1136, 1500},
	{176, 2258, 1136},
	{540, 1500, 2258},
	{27, 728, 1257},
	{248, 2259, 728},
	{297, 1257, 2259},
	{128, 1021, 1208},
	{541, 2260, 1021},
	{248, 1208, 2260},
	{57, 777, 1501},
	{297, 2261, 777},
	{541, 1501, 2261},
	{26, 1256, 1328},
	{296, 2262, 1256},
	{368, 1328, 2262},
	{56, 1022, 776},
	{542, 2263, 1022},
	{296, 776, 2263},
	{128, 848, 1502},
	{368, 2264, 848},
	{542, 1502, 2264},
	{3, 1275, 1289},
	{315, 2265, 1275},
	{329, 1289, 2265},
	{75, 1023, 795},
	{543, 2266, 1023},
	{315, 795, 2266},
	{89, 809, 1503},
	{329, 2267, 809},
	{543, 1503, 2267},
	{15, 729, 675},
	{249, 2268, 729},
	{195, 675, 2268},
	{129, 1024, 1209},
	{544, 2269, 1024},
	{249, 1209, 2269},
	{75, 1155, 1504},
	{195, 2270, 1155},
	{544, 1504, 2270},
	{29, 689, 1329},
	{209, 2271, 689},
	{369, 1329, 2271},
	{89, 1025, 1169},
	{545, 2272, 1025},
	{209, 1169, 2272},
	{129, 849, 1505},
	{369, 2273, 849},
	{545, 1505, 2273},
	{2, 1288, 645},
	{328, 2274, 1288},
	{165, 645, 2274},
	{88, 1026, 808},
	{546, 2275, 1026},
	{328, 808, 2275},
	{45, 1125, 1506},
	{165, 2276, 1125},
	{546, 1506, 2276},
	{28, 730, 688},
	{250, 2277, 730},
	{208, 688, 2277},
	{130, 1027, 1210},
	{547, 2278, 1027},
	{250, 1210, 2278},
	{88, 1168, 1507},
	{208, 2279, 1168},
	{547, 1507, 2279},
	{15, 1245, 1330},
	{285, 2280, 1245},
	{370, 1330, 2280},
	{45, 1028, 765},
	{548, 2281, 1028},
	{285, 765, 2281},
	{130, 850, 1508},
	{370, 2282, 850},
	{548, 1508, 2282},
	{8, 659, 658},
	{179, 2283, 659},
	{178, 658, 2283},
	{59, 1029, 1139},
	{549, 2284, 1029},
	{179, 1139, 2284},
	{58, 1138, 1509},
	{178, 2285, 1138},
	{549, 1509, 2285},
	{29, 731, 1259},
	{251, 2286, 731},
	{299, 1259, 2286},
	{131, 1030, 1211},
	{550, 2287, 1030},
	{251, 1211, 2287},
	{59, 779, 1510},
	{299, 2288, 779},
	{550, 1510, 2288},
	{28, 1258, 1331},
	{298, 2289, 1258},
	{371, 1331, 2289},
	{58, 1031, 778},
	{551, 2290, 1031},
	{298, 778, 2290},
	{131, 851, 1511},
	{371, 2291, 851},
	{551, 1511, 2291},
	{9, 661, 1290},
	{181, 2292, 661},
	{330, 1290, 2292},
	{61, 1032, 1141},
	{552, 2293, 1032},
	{181, 1141, 2293},
	{90, 810, 1512},
	{330, 2294, 810},
	{552, 1512, 2294},
	{31, 732, 1261},
	{252, 2295, 732},
	{301, 1261, 2295},
	{132, 1033, 1212},
	{553, 2296, 1033},
	{252, 1212, 2296},
	{61, 781, 1513},
	{301, 2297, 781},
	{553, 1513, 2297},
	{30, 690, 1332},
	{210, 2298, 690},
	{372, 1332, 2298},
	{90, 1034, 1170},
	{554, 2299, 1034},
	{210, 1170, 2299},
	{132, 852, 1514},
	{372, 2300, 852},
	{554, 1514, 2300},
	{3, 1289, 1291},
	{329, 2301, 1289},
	{331, 1291, 2301},
	{89, 1035, 809},
	{555, 2302, 1035},
	{329, 809, 2302},
	{91, 811, 1515},
	{331, 2303, 811},
	{555, 1515, 2303},
	{29, 733, 689},
	{253, 2304, 733},
	{209, 689, 2304},
	{133, 1036, 1213},
	{556, 2305, 1036},
	{253, 1213, 2305},
	{89, 1169, 1516},
	{209, 2306, 1169},
	{556, 1516, 2306},
	{31, 691, 1333},
	{211, 2307, 691},
	{373, 1333, 2307},
	{91, 1037, 1171},
	{557, 2308, 1037},
	{211, 1171, 2308},
	{133, 853, 1517},
	{373, 2309, 853},
	{557, 1517, 2309},
	{8, 660, 659},
	{180, 2310, 660},
	{179, 659, 2310},
	{60, 1038, 1140},
	{558, 2311, 1038},
	{180, 1140, 2311},
	{59, 1139, 1518},
	{179, 2312, 1139},
	{558, 1518, 2312},
	{30, 734, 1260},
	{254, 2313, 734},
	{300, 1260, 2313},
	{134, 1039, 1214},
	{559, 2314, 1039},
	{254, 1214, 2314},
	{60, 780, 1519},
	{300, 2315, 780},
	{559, 1519, 2315},
	{29, 1259, 1334},
	{299, 2316, 1259},
	{374, 1334, 2316},
	{59, 1040, 779},
	{560, 2317, 1040},
	{299, 779, 2317},
	{134, 854, 1520},
	{374, 2318, 854},
	{560, 1520, 2318},
	{4, 1277, 1292},
	{317, 2319, 1277},
	{332, 1292, 2319},
	{77, 1041, 797},
	{561, 2320, 1041},
	{317, 797, 2320},
	{92, 812, 1521},
	{332, 2321, 812},
	{561, 1521, 2321},
	{17, 735, 677},
	{255, 2322, 735},
	{197, 677, 2322},
	{135, 1042, 1215},
	{562, 2323, 1042},
	{255, 1215, 2323},
	{77, 1157, 1522},
	{197, 2324, 1157},
	{562, 1522, 2324},
	{32, 692, 1335},
	{212, 2325, 692},
	{375, 1335, 2325},
	{92, 1043, 1172},
	{563, 2326, 1043},
	{212, 1172, 2326},
	{135, 855, 1523},
	{375, 2327, 855},
	{563, 1523, 2327},
	{3, 1291, 647},
	{331, 2328, 1291},
	{167, 647, 2328},
	{91, 1044, 811},
	{564, 2329, 1044},
	{331, 811, 2329},
	{47, 1127, 1524},
	{167, 2330, 1127},
	{564, 1524, 2330},
	{31, 736, 691},
	{256, 2331, 736},
	{211, 691, 2331},
	{136, 1045, 1216},
	{565, 2332, 1045},
	{256, 1216, 2332},
	{91, 1171, 1525},
	{211, 2333, 1171},
	{565, 1525, 2333},
	{17, 1247, 1336},
	{287, 2334, 1247},
	{376, 1336, 2334},
	{47, 1046, 767},
	{566, 2335, 1046},
	{287, 767, 2335},
	{136, 856, 1526},
	{376, 2336, 856},
	{566, 1526, 2336},
	{9, 662, 661},
	{182, 2337, 662},
	{181, 661, 2337},
	{62, 1047, 1142},
	{567, 2338, 1047},
	{182, 1142, 2338},
	{61, 1141, 1527},
	{181, 2339, 1141},
	{567, 1527, 2339},
	{32, 737, 1262},
	{257, 2340, 737},
	{302, 1262, 2340},
	{137, 1048, 1217},
	{568, 2341, 1048},
	{257, 1217, 2341},
	{62, 782, 1528},
	{302, 2342, 782},
	{568, 1528, 2342},
	{31, 1261, 1337},
	{301, 2343, 1261},
	{377, 1337, 2343},
	{61, 1049, 781},
	{569, 2344, 1049},
	{301, 781, 2344},
	{137, 857, 1529},
	{377, 2345, 857},
	{569, 1529, 2345},
	{10, 664, 1293},
	{184, 2346, 664},
	{333, 1293, 2346},
	{64, 1050, 1144},
	{570, 2347, 1050},
	{184, 1144, 2347},
	{93, 813, 1530},
	{333, 2348, 813},
	{570, 1530, 2348},
	{34, 738, 1264},
	{258, 2349, 738},
	{304, 1264, 2349},
	{138, 1051, 1218},
	{571, 2350, 1051},
	{258, 1218, 2350},
	{64, 784, 1531},
	{304, 2351, 784},
	{571, 1531, 2351},
	{33, 693, 1338},
	{213, 2352, 693},
	{378, 1338, 2352},
	{93, 1052, 1173},
	{572, 2353, 1052},
	{213, 1173, 2353},
	{138, 858, 1532},
	{378, 2354, 858},
	{572, 1532, 2354},
	{4, 1292, 1294},
	{332, 2355, 1292},
	{334, 1294, 2355},
	{92, 1053, 812},
	{573, 2356, 1053},
	{332, 812, 2356},
	{94, 814, 1533},
	{334, 2357, 814},
	{573, 1533, 2357},
	{32, 739, 692},
	{259, 2358, 739},
	{212, 692, 2358},
	{139, 1054, 1219},
	{574, 2359, 1054},
	{259, 1219, 2359},
	{92, 1172, 1534},
	{212, 2360, 1172},
	{574, 1534, 2360},
	{34, 694, 1339},
	{214, 2361, 694},
	{379, 1339, 2361},
	{94, 1055, 1174},
	{575, 2362, 1055},
	{214, 1174, 2362},
	{139, 859, 1535},
	{379, 2363, 859},
	{575, 1535, 2363},
	{9, 663, 662},
	{183, 2364, 663},
	{182, 662, 2364},
	{63, 1056, 1143},
	{576, 2365, 1056},
	{183, 1143, 2365},
	{62, 1142, 1536},
	{182, 2366, 1142},
	{576, 1536, 2366},
	{33, 740, 1263},
	{260, 2367, 740},
	{303, 1263, 2367},
	{140, 1057, 1220},
	{577, 2368, 1057},
	{260, 1220, 2368},
	{63, 783, 1537},
	{303, 2369, 783},
	{577, 1537, 2369},
	{32, 1262, 1340},
	{302, 2370, 1262},
	{380, 1340, 2370},
	{62, 1058, 782},
	{578, 2371, 1058},
	{302, 782, 2371},
	{140, 860, 1538},
	{380, 2372, 860},
	{578, 1538, 2372},
	{5, 1279, 1295},
	{319, 2373, 1279},
	{335, 1295, 2373},
	{79, 1059, 799},
	{579, 2374, 1059},
	{319, 799, 2374},
	{95, 815, 1539},
	{335, 2375, 815},
	{579, 1539, 2375},
	{19, 741, 679},
	{261, 2376, 741},
	{199, 679, 2376},
	{141, 1060, 1221},
	{580, 2377, 1060},
	{261, 1221, 2377},
	{79, 1159, 1540},
	{199, 2378, 1159},
	{580, 1540, 2378},
	{35, 695, 1341},
	{215, 2379, 695},
	{381, 1341, 2379},
	{95, 1061, 1175},
	{581, 2380, 1061},
	{215, 1175, 2380},
	{141, 861, 1541},
	{381, 2381, 861},
	{581, 1541, 2381},
	{4, 1294, 649},
	{334, 2382, 1294},
	{169, 649, 2382},
	{94, 1062, 814},
	{582, 2383, 1062},
	{334, 814, 2383},
	{49, 1129, 1542},
	{169, 2384, 1129},
	{582, 1542, 2384},
	{34, 742, 694},
	{262, 2385, 742},
	{214, 694, 2385},
	{142, 1063, 1222},
	{583, 2386, 1063},
	{262, 1222, 2386},
	{94, 1174, 1543},
	{214, 2387, 1174},
	{583, 1543, 2387},
	{19, 1249, 1342},
	{289, 2388, 1249},
	{382, 1342, 2388},
	{49, 1064, 769},
	{584, 2389, 1064},
	{289, 769, 2389},
	{142, 862, 1544},
	{382, 2390, 862},
	{584, 1544, 2390},
	{10, 665, 664},
	{185, 2391, 665},
	{184, 664, 2391},
	{65, 1065, 1145},
	{585, 2392, 1065},
	{185, 1145, 2392},
	{64, 1144, 1545},
	{184, 2393, 1144},
	{585, 1545, 2393},
	{35, 743, 1265},
	{263, 2394, 743},
	{305, 1265, 2394},
	{143, 1066, 1223},
	{586, 2395, 1066},
	{263, 1223, 2395},
	{65, 785, 1546},
	{305, 2396, 785},
	{586, 1546, 2396},
	{34, 1264, 1343},
	{304, 2397, 1264},
	{383, 1343, 2397},
	{64, 1067, 784},
	{587, 2398, 1067},
	{304, 784, 2398},
	{143, 863, 1547},
	{383, 2399, 863},
	{587, 1547, 2399},
	{7, 1282, 1296},
	{322, 2400, 1282},
	{336, 1296, 2400},
	{82, 1068, 802},
	{588, 2401, 1068},
	{322, 802, 2401},
	{96, 816, 1548},
	{336, 2402, 816},
	{588, 1548, 2402},
	{22, 744, 682},
	{264, 2403, 744},
	{202, 682, 2403},
	{144, 1069, 1224},
	{589, 2404, 1069},
	{264, 1224, 2404},
	{82, 1162, 1549},
	{202, 2405, 1162},
	{589, 1549, 2405},
	{36, 696, 1344},
	{216, 2406, 696},
	{384, 1344, 2406},
	{96, 1070, 1176},
	{590, 2407, 1070},
	{216, 1176, 2407},
	{144, 864, 1550},
	{384, 2408, 864},
	{590, 1550, 2408},
	{5, 1295, 652},
	{335, 2409, 1295},
	{172, 652, 2409},
	{95, 1071, 815},
	{591, 2410, 1071},
	{335, 815, 2410},
	{52, 1132, 1551},
	{172, 2411, 1132},
	{591, 1551, 2411},
	{35, 745, 695},
	{265, 2412, 745},
	{215, 695, 2412},
	{145, 1072, 1225},
	{592, 2413, 1072},
	{265, 1225, 2413},
	{95, 1175, 1552},
	{215, 2414, 1175},
	{592, 1552, 2414},
	{22, 1252, 1345},
	{292, 2415, 1252},
	{385, 1345, 2415},
	{52, 1073, 772},
	{593, 2416, 1073},
	{292, 772, 2416},
	{145, 865, 1553},
	{385, 2417, 865},
	{593, 1553, 2417},
	{10, 666, 665},
	{186, 2418, 666},
	{185, 665, 2418},
	{66, 1074, 1146},
	{594, 2419, 1074},
	{186, 1146, 2419},
	{65, 1145, 1554},
	{185, 2420, 1145},
	{594, 1554, 2420},
	{36, 746, 1266},
	{266, 2421, 746},
	{306, 1266, 2421},
	{146, 1075, 1226},
	{595, 2422, 1075},
	{266, 1226, 2422},
	{66, 786, 1555},
	{306, 2423, 786},
	{595, 1555, 2423},
	{35, 1265, 1346},
	{305, 2424, 1265},
	{386, 1346, 2424},
	{65, 1076, 785},
	{596, 2425, 1076},
	{305, 785, 2425},
	{146, 866, 1556},
	{386, 2426, 866},
	{596, 1556, 2426},
	{11, 668, 1297},
	{188, 2427, 668},
	{337, 1297, 2427},
	{68, 1077, 1148},
	{597, 2428, 1077},
	{188, 1148, 2428},
	{97, 817, 1557},
	{337, 2429, 817},
	{597, 1557, 2429},
	{38, 747, 1268},
	{267, 2430, 747},
	{308, 1268, 2430},
	{147, 1078, 1227},
	{598, 2431, 1078},
	{267, 1227, 2431},
	{68, 788, 1558},
	{308, 2432, 788},
	{598, 1558, 2432},
	{37, 697, 1347},
	{217, 2433, 697},
	{387, 1347, 2433},
	{97, 1079, 1177},
	{599, 2434, 1079},
	{217, 1177, 2434},
	{147, 867, 1559},
	{387, 2435, 867},
	{599, 1559, 2435},
	{6, 1284, 1298},
	{324, 2436, 1284},
	{338, 1298, 2436},
	{84, 1080, 804},
	{600, 2437, 1080},
	{324, 804, 2437},
	{98, 818, 1560},
	{338, 2438, 818},
	{600, 1560, 2438},
	{24, 748, 684},
	{268, 2439, 748},
	{204, 684, 2439},
	{148, 1081, 1228},
	{601, 2440, 1081},
	{268, 1228, 2440},
	{84, 1164, 1561},
	{204, 2441, 1164},
	{601, 1561, 2441},
	{38, 698, 1348},
	{218, 2442, 698},
	{388, 1348, 2442},
	{98, 1082, 1178},
	{602, 2443, 1082},
	{218, 1178, 2443},
	{148, 868, 1562},
	{388, 2444, 868},
	{602, 1562, 2444},
	{7, 667, 654},
	{187, 2445, 667},
	{174, 654, 2445},
	{67, 1083, 1147},
	{603, 2446, 1083},
	{187, 1147, 2446},
	{54, 1134, 1563},
	{174, 2447, 1134},
	{603, 1563, 2447},
	{37, 749, 1267},
	{269, 2448, 749},
	{307, 1267, 2448},
	{149, 1084, 1229},
	{604, 2449, 1084},
	{269, 1229, 2449},
	{67, 787, 1564},
	{307, 2450, 787},
	{604, 1564, 2450},
	{24, 1254, 1349},
	{294, 2451, 1254},
	{389, 1349, 2451},
	{54, 1085, 774},
	{605, 2452, 1085},
	{294, 774, 2452},
	{149, 869, 1565},
	{389, 2453, 869},
	{605, 1565, 2453},
	{8, 1287, 1299},
	{327, 2454, 1287},
	{339, 1299, 2454},
	{87, 1086, 807},
	{606, 2455, 1086},
	{327, 807, 2455},
	{99, 819, 1566},
	{339, 2456, 819},
	{606, 1566, 2456},
	{27, 750, 687},
	{270, 2457, 750},
	{207, 687, 2457},
	{150, 1087, 1230},
	{607, 2458, 1087},
	{270, 1230, 2458},
	{87, 1167, 1567},
	{207, 2459, 1167},
	{607, 1567, 2459},
	{39, 699, 1350},
	{219, 2460, 699},
	{390, 1350, 2460},
	{99, 1088, 1179},
	{608, 2461, 1088},
	{219, 1179, 2461},
	{150, 870, 1568},
	{390, 2462, 870},
	{608, 1568, 2462},
	{6, 1298, 657},
	{338, 2463, 1298},
	{177, 657, 2463},
	{98, 1089, 818},
	{609, 2464, 1089},
	{338, 818, 2464},
	{57, 1137, 1569},
	{177, 2465, 1137},
	{609, 1569, 2465},
	{38, 751, 698},
	{271, 2466, 751},
	{218, 698, 2466},
	{151, 1090, 1231},
	{610, 2467, 1090},
	{271, 1231, 2467},
	{98, 1178, 1570},
	{218, 2468, 1178},
	{610, 1570, 2468},
	{27, 1257, 1351},
	{297, 2469, 1257},
	{391, 1351, 2469},
	{57, 1091, 777},
	{611, 2470, 1091},
	{297, 777, 2470},
	{151, 871, 1571},
	{391, 2471, 871},
	{611, 1571, 2471},
	{11, 669, 668},
	{189, 2472, 669},
	{188, 668, 2472},
	{69, 1092, 1149},
	{612, 2473, 1092},
	{189, 1149, 2473},
	{68, 1148, 1572},
	{188, 2474, 1148},
	{612, 1572, 2474},
	{39, 752, 1269},
	{272, 2475, 752},
	{309, 1269, 2475},
	{152, 1093, 1232},
	{613, 2476, 1093},
	{272, 1232, 2476},
	{69, 789, 1573},
	{309, 2477, 789},
	{613, 1573, 2477},
	{38, 1268, 1352},
	{308, 2478, 1268},
	{392, 1352, 2478},
	{68, 1094, 788},
	{614, 2479, 1094},
	{308, 788, 2479},
	{152, 872, 1574},
	{392, 2480, 872},
	{614, 1574, 2480},
	{11, 1297, 1300},
	{337, 2481, 1297},
	{340, 1300, 2481},
	{97, 1095, 817},
	{615, 2482, 1095},
	{337, 817, 2482},
	{100, 820, 1575},
	{340, 2483, 820},
	{615, 1575, 2483},
	{37, 753, 697},
	{273, 2484, 753},
	{217, 697, 2484},
	{153, 1096, 1233},
	{616, 2485, 1096},
	{273, 1233, 2485},
	{97, 1177, 1576},
	{217, 2486, 1177},
	{616, 1576, 2486},
	{40, 700, 1353},
	{220, 2487, 700},
	{393, 1353, 2487},
	{100, 1097, 1180},
	{617, 2488, 1097},
	{220, 1180, 2488},
	{153, 873, 1577},
	{393, 2489, 873},
	{617, 1577, 2489},
	{7, 1296, 667},
	{336, 2490, 1296},
	{187, 667, 2490},
	{96, 1098, 816},
	{618, 2491, 1098},
	{336, 816, 2491},
	{67, 1147, 1578},
	{187, 2492, 1147},
	{618, 1578, 2492},
	{36, 754, 696},
	{274, 2493, 754},
	{216, 696, 2493},
	{154, 1099, 1234},
	{619, 2494, 1099},
	{274, 1234, 2494},
	{96, 1176, 1579},
	{216, 2495, 1176},
	{619, 1579, 2495},
	{37, 1267, 1354},
	{307, 2496, 1267},
	{394, 1354, 2496},
	{67, 1100, 787},
	{620, 2497, 1100},
	{307, 787, 2497},
	{154, 874, 1580},
	{394, 2498, 874},
	{620, 1580, 2498},
	{10, 670, 666},
	{190, 2499, 670},
	{186, 666, 2499},
	{70, 1101, 1150},
	{621, 2500, 1101},
	{190, 1150, 2500},
	{66, 1146, 1581},
	{186, 2501, 1146},
	{621, 1581, 2501},
	{40, 755, 1270},
	{275, 2502, 755},
	{310, 1270, 2502},
	{155, 1102, 1235},
	{622, 2503, 1102},
	{275, 1235, 2503},
	{70, 790, 1582},
	{310, 2504, 790},
	{622, 1582, 2504},
	{36, 1266, 1355},
	{306, 2505, 1266},
	{395, 1355, 2505},
	{66, 1103, 786},
	{623, 2506, 1103},
	{306, 786, 2506},
	{155, 875, 1583},
	{395, 2507, 875},
	{623, 1583, 2507},
	{9, 1290, 1301},
	{330, 2508, 1290},
	{341, 1301, 2508},
	{90, 1104, 810},
	{624, 2509, 1104},
	{330, 810, 2509},
	{101, 821, 1584},
	{341, 2510, 821},
	{624, 1584, 2510},
	{30, 756, 690},
	{276, 2511, 756},
	{210, 690, 2511},
	{156, 1105, 1236},
	{625, 2512, 1105},
	{276, 1236, 2512},
	{90, 1170, 1585},
	{210, 2513, 1170},
	{625, 1585, 2513},
	{41, 701, 1356},
	{221, 2514, 701},
	{396, 1356, 2514},
	{101, 1106, 1181},
	{626, 2515, 1106},
	{221, 1181, 2515},
	{156, 876, 1586},
	{396, 2516, 876},
	{626, 1586, 2516},
	{8, 1299, 660},
	{339, 2517, 1299},
	{180, 660, 2517},
	{99, 1107, 819},
	{627, 2518, 1107},
	{339, 819, 2518},
	{60, 1140, 1587},
	{180, 2519, 1140},
	{627, 1587, 2519},
	{39, 757, 699},
	{277, 2520, 757},
	{219, 699, 2520},
	{157, 1108, 1237},
	{628, 2521, 1108},
	{277, 1237, 2521},
	{99, 1179, 1588},
	{219, 2522, 1179},
	{628, 1588, 2522},
	{30, 1260, 1357},
	{300, 2523, 1260},
	{397, 1357, 2523},
	{60, 1109, 780},
	{629, 2524, 1109},
	{300, 780, 2524},
	{157, 877, 1589},
	{397, 2525, 877},
	{629, 1589, 2525},
	{11, 671, 669},
	{191, 2526, 671},
	{189, 669, 2526},
	{71, 1110, 1151},
	{630, 2527, 1110},
	{191, 1151, 2527},
	{69, 1149, 1590},
	{189, 2528, 1149},
	{630, 1590, 2528},
	{41, 758, 1271},
	{278, 2529, 758},
	{311, 1271, 2529},
	{158, 1111, 1238},
	{631, 2530, 1111},
	{278, 1238, 2530},
	{71, 791, 1591},
	{311, 2531, 791},
	{631, 1591, 2531},
	{39, 1269, 1358},
	{309, 2532, 1269},
	{398, 1358, 2532},
	{69, 1112, 789},
	{632, 2533, 1112},
	{309, 789, 2533},
	{158, 878, 1592},
	{398, 2534, 878},
	{632, 1592, 2534},
	{10, 1293, 670},
	{333, 2535, 1293},
	{190, 670, 2535},
	{93, 1113, 813},
	{633, 2536, 1113},
	{333, 813, 2536},
	{70, 1150, 1593},
	{190, 2537, 1150},
	{633, 1593, 2537},
	{33, 759, 693},
	{279, 2538, 759},
	{213, 693, 2538},
	{159, 1114, 1239},
	{634, 2539, 1114},
	{279, 1239, 2539},
	{93, 1173, 1594},
	{213, 2540, 1173},
	{634, 1594, 2540},
	{40, 1270, 1359},
	{310, 2541, 1270},
	{399, 1359, 2541},
	{70, 1115, 790},
	{635, 2542, 1115},
	{310, 790, 2542},
	{159, 879, 1595},
	{399, 2543, 879},
	{635, 1595, 2543},
	{9, 1301, 663},
	{341, 2544, 1301},
	{183, 663, 2544},
	{101, 1116, 821},
	{636, 2545, 1116},
	{341, 821, 2545},
	{63, 1143, 1596},
	{183, 2546, 1143},
	{636, 1596, 2546},
	{41, 760, 701},
	{280, 2547, 760},
	{221, 701, 2547},
	{160, 1117, 1240},
	{637, 2548, 1117},
	{280, 1240, 2548},
	{101, 1181, 1597},
	{221, 2549, 1181},
	{637, 1597, 2549},
	{33, 1263, 1360},
	{303, 2550, 1263},
	{400, 1360, 2550},
	{63, 1118, 783},
	{638, 2551, 1118},
	{303, 783, 2551},
	{160, 880, 1598},
	{400, 2552, 880},
	{638, 1598, 2552},
	{11, 1300, 671},
	{340, 2553, 1300},
	{191, 671, 2553},
	{100, 1119, 820},
	{639, 2554, 1119},
	{340, 820, 2554},
	{71, 1151, 1599},
	{191, 2555, 1151},
	{639, 1599, 2555},
	{40, 761, 700},
	{281, 2556, 761},
	{220, 700, 2556},
	{161, 1120, 1241},
	{640, 2557, 1120},
	{281, 1241, 2557},
	{100, 1180, 1600},
	{220, 2558, 1180},
	{640, 1600, 2558},
	{41, 1271, 1361},
	{311, 2559, 1271},
	{401, 1361, 2559},
	{71, 1121, 791},
	{641, 2560, 1121},
	{311, 791, 2560},
	{161, 881, 1601},
	{401, 2561, 881},
	{641, 1601, 2561},
    };
    
#endif
    
}
